/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.compiler.impl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.compiler.CompilationResult;
import org.apache.sling.commons.compiler.CompilationUnit;
import org.apache.sling.commons.compiler.CompilationUnitWithSource;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.commons.compiler.impl.CompilationResultImpl;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JavaCompiler.class})
public class EclipseJavaCompiler
implements JavaCompiler {
    private final Logger logger = LoggerFactory.getLogger(EclipseJavaCompiler.class);
    @Reference
    private ClassLoaderWriter classLoaderWriter;
    private IProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
    private final IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
    private final Set<String> warningEmittedForUnsupportedJavaVersion = new CopyOnWriteArraySet<String>();
    private static final Options EMPTY_OPTIONS = new Options();

    private ClassLoader getClassLoader(Options options, ClassLoaderWriter classLoaderWriter) {
        ClassLoader loader;
        if (options.get("classLoader") != null) {
            loader = (ClassLoader)options.get("classLoader");
        } else if (options.get("classLoader") != null) {
            final ClassLoader additionalClassLoader = (ClassLoader)options.get("classLoader");
            loader = new ClassLoader(classLoaderWriter.getClassLoader()){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    return additionalClassLoader.loadClass(name);
                }

                @Override
                protected URL findResource(String name) {
                    return additionalClassLoader.getResource(name);
                }
            };
        } else {
            ClassLoader cl = classLoaderWriter.getClassLoader();
            loader = cl == null ? this.classLoaderWriter.getClassLoader() : cl;
        }
        return loader;
    }

    private ClassLoaderWriter getClassLoaderWriter(Options options) {
        if (options.get("classLoaderWriter") != null) {
            return (ClassLoaderWriter)options.get("classLoaderWriter");
        }
        return this.classLoaderWriter;
    }

    private boolean isOutDated(CompilationUnit unit, ClassLoaderWriter writer) {
        long targetLastModified = writer.getLastModified('/' + unit.getMainClassName().replace('.', '/') + ".class");
        if (targetLastModified < 0L) {
            return true;
        }
        return targetLastModified < unit.getLastModified();
    }

    private boolean isForceCompilation(Options options) {
        Boolean flag = (Boolean)options.get("forceCompilation");
        if (flag != null) {
            return flag;
        }
        return false;
    }

    private boolean isIgnoreWarnings(Options options) {
        Boolean flag = (Boolean)options.get("ignoreWarnings");
        if (flag != null) {
            return flag;
        }
        return false;
    }

    @Override
    public CompilationResult compile(CompilationUnit[] units, Options compileOptions) {
        Options options = compileOptions != null ? compileOptions : EMPTY_OPTIONS;
        ClassLoaderWriter writer = this.getClassLoaderWriter(options);
        if (writer == null) {
            return new CompilationResultImpl("Class loader writer for compilation is not available.");
        }
        ClassLoader loader = this.getClassLoader(options, writer);
        if (loader == null) {
            return new CompilationResultImpl("Class loader for compilation is not available.");
        }
        boolean needsCompilation = this.isForceCompilation(options);
        if (!needsCompilation) {
            for (CompilationUnit unit : units) {
                if (!this.isOutDated(unit, writer)) continue;
                needsCompilation = true;
                break;
            }
        }
        if (!needsCompilation) {
            this.logger.debug("All source files are recent - no compilation required.");
            return new CompilationResultImpl(writer);
        }
        for (CompilationUnit unit : units) {
            String name = '/' + unit.getMainClassName().replace('.', '/') + ".class";
            writer.delete(name);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (options.isGenerateDebugInfo()) {
            props.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
            props.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            props.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        }
        if (options.getSourceVersion() != null) {
            props.put("org.eclipse.jdt.core.compiler.source", this.adjustJavaVersion(options.getSourceVersion()));
            props.put("org.eclipse.jdt.core.compiler.compliance", this.adjustJavaVersion(options.getSourceVersion()));
        }
        if (options.getTargetVersion() != null) {
            props.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.adjustJavaVersion(options.getTargetVersion()));
        }
        props.put("org.eclipse.jdt.core.encoding", "UTF8");
        CompilerOptions settings = new CompilerOptions(props);
        this.logger.debug("Compiling with settings {}.", (Object)settings);
        CompilationResultImpl result = new CompilationResultImpl(this.isIgnoreWarnings(options), writer);
        CompileContext context = new CompileContext(units, result, writer, loader);
        Compiler compiler = new Compiler(context, this.policy, settings, context, this.problemFactory, null, null);
        compiler.compile(context.getSourceUnits());
        return result;
    }

    private String adjustJavaVersion(String javaVersion) {
        if (CompilerOptions.versionToJdkLevel(javaVersion) == 0L) {
            String latestSupportedVersion = "11";
            if (!this.warningEmittedForUnsupportedJavaVersion.contains(javaVersion) && this.warningEmittedForUnsupportedJavaVersion.add(javaVersion)) {
                this.logger.warn("Using unsupported java version '{}', assuming latest supported version '{}'", (Object)javaVersion, (Object)latestSupportedVersion);
            }
            return latestSupportedVersion;
        }
        return javaVersion;
    }

    private class CompilationUnitAdapter
    implements ICompilationUnit {
        private final CompilationResultImpl errorHandler;
        private final CompilationUnit compUnit;
        private final String mainTypeName;
        private final String packageName;

        public CompilationUnitAdapter(CompilationUnit compUnit, CompilationResultImpl errorHandler) {
            this.compUnit = compUnit;
            this.errorHandler = errorHandler;
            int pos = compUnit.getMainClassName().lastIndexOf(46);
            if (pos == -1) {
                this.packageName = "";
                this.mainTypeName = compUnit.getMainClassName();
            } else {
                this.packageName = compUnit.getMainClassName().substring(0, pos);
                this.mainTypeName = compUnit.getMainClassName().substring(pos + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public char[] getContents() {
            char[] cArray;
            BufferedReader reader;
            Reader fr;
            block16: {
                int count;
                fr = null;
                fr = this.compUnit.getSource();
                reader = new BufferedReader(fr);
                char[] chars = new char[8192];
                StringBuilder buf = new StringBuilder();
                while ((count = ((Reader)reader).read(chars, 0, chars.length)) > 0) {
                    buf.append(chars, 0, count);
                }
                char[] result = new char[buf.length()];
                buf.getChars(0, result.length, result, 0);
                cArray = result;
                ((Reader)reader).close();
                if (fr == null) break block16;
                try {
                    fr.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return cArray;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)reader).close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            this.errorHandler.onError("Unable to read source file " + this.compUnit.getMainClassName() + " : " + e.getMessage(), this.compUnit.getMainClassName(), 0, 0);
                            char[] cArray2 = null;
                            return cArray2;
                        }
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        if (fr != null) {
                            try {
                                fr.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }

        @Override
        public char[] getMainTypeName() {
            return this.mainTypeName.toCharArray();
        }

        @Override
        public char[][] getPackageName() {
            return CharOperation.splitOn('.', this.packageName.toCharArray());
        }

        @Override
        public char[] getFileName() {
            if (this.compUnit instanceof CompilationUnitWithSource) {
                return ((CompilationUnitWithSource)this.compUnit).getFileName().toCharArray();
            }
            return (this.packageName.replace('.', '/') + '/' + this.mainTypeName + ".java").toCharArray();
        }

        @Override
        public boolean ignoreOptionalProblems() {
            return false;
        }
    }

    private class CompileContext
    implements ICompilerRequestor,
    INameEnvironment {
        private final Map<String, ICompilationUnit> compUnits = new HashMap<String, ICompilationUnit>();
        private final CompilationResultImpl errorHandler;
        private final ClassLoaderWriter classLoaderWriter;
        private final ClassLoader classLoader;

        public CompileContext(CompilationUnit[] units, CompilationResultImpl errorHandler, ClassLoaderWriter classWriter, ClassLoader classLoader) {
            for (int i = 0; i < units.length; ++i) {
                CompilationUnitAdapter cua = new CompilationUnitAdapter(units[i], errorHandler);
                char[][] compoundName = CharOperation.arrayConcat(cua.getPackageName(), cua.getMainTypeName());
                this.compUnits.put(CharOperation.toString(compoundName), new CompilationUnitAdapter(units[i], errorHandler));
            }
            this.errorHandler = errorHandler;
            this.classLoaderWriter = classWriter;
            this.classLoader = classLoader;
        }

        public ICompilationUnit[] getSourceUnits() {
            return this.compUnits.values().toArray(new ICompilationUnit[this.compUnits.size()]);
        }

        @Override
        public void acceptResult(org.eclipse.jdt.internal.compiler.CompilationResult result) {
            int i;
            if (result.hasProblems()) {
                CategorizedProblem[] problems = result.getProblems();
                for (i = 0; i < problems.length; ++i) {
                    CategorizedProblem problem = problems[i];
                    String msg = problem.getMessage();
                    String fileName = CharOperation.charToString(problem.getOriginatingFileName());
                    int line = problem.getSourceLineNumber();
                    int pos = problem.getSourceStart();
                    if (problem.isError()) {
                        this.errorHandler.onError(msg, fileName, line, pos);
                        continue;
                    }
                    if (problem.isWarning()) {
                        this.errorHandler.onWarning(msg, fileName, line, pos);
                        continue;
                    }
                    EclipseJavaCompiler.this.logger.debug("unknown problem category: {}", (Object)problem);
                }
            }
            if (this.errorHandler.getErrors() == null) {
                ClassFile[] classFiles = result.getClassFiles();
                for (i = 0; i < classFiles.length; ++i) {
                    ClassFile classFile = classFiles[i];
                    String className = CharOperation.toString(classFile.getCompoundName());
                    try {
                        this.write(className, classFile.getBytes());
                        continue;
                    }
                    catch (IOException e) {
                        this.errorHandler.onError("Unable to write class file: " + e.getMessage(), className, 0, 0);
                    }
                }
            }
        }

        @Override
        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            String fqn = CharOperation.toString(compoundTypeName);
            ICompilationUnit cu = this.compUnits.get(fqn);
            if (cu != null) {
                return new NameEnvironmentAnswer(cu, null);
            }
            try {
                byte[] bytes = this.findClass(CharOperation.toString(compoundTypeName));
                if (bytes == null) {
                    return null;
                }
                ClassFileReader classFileReader = new ClassFileReader(bytes, fqn.toCharArray(), true);
                return new NameEnvironmentAnswer(classFileReader, null);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            return this.findType(CharOperation.arrayConcat(packageName, typeName));
        }

        @Override
        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            String fqn = CharOperation.toString(CharOperation.arrayConcat(parentPackageName, packageName));
            return this.compUnits.get(fqn) == null && this.isPackage(fqn);
        }

        @Override
        public void cleanup() {
        }

        private void write(String name, byte[] data) throws IOException {
            OutputStream os = this.classLoaderWriter.getOutputStream('/' + name.replace('.', '/') + ".class");
            os.write(data);
            os.close();
        }

        private boolean isPackage(String result) {
            InputStream is;
            String resourceName = result.replace('.', '/') + ".class";
            if (resourceName.startsWith("/")) {
                resourceName = resourceName.substring(1);
            }
            if ((is = this.classLoader.getResourceAsStream(resourceName)) != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return is == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] findClass(String name) throws Exception {
            String resourceName = name.replace('.', '/') + ".class";
            InputStream is = this.classLoader.getResourceAsStream(resourceName);
            if (is != null) {
                try {
                    int count;
                    byte[] buf = new byte[8192];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
                    while ((count = is.read(buf, 0, buf.length)) > 0) {
                        baos.write(buf, 0, count);
                    }
                    baos.flush();
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }
    }
}

