/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.html.internal;

import java.io.IOException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DOMBuilder
implements ContentHandler,
LexicalHandler {
    private static final SAXTransformerFactory FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
    private final DOMResult result;
    private final ContentHandler contentHandler;
    private final LexicalHandler lexicalHandler;

    public DOMBuilder() throws IOException {
        try {
            TransformerHandler handler = FACTORY.newTransformerHandler();
            this.contentHandler = handler;
            this.lexicalHandler = handler;
            this.result = new DOMResult();
            handler.setResult(this.result);
        }
        catch (TransformerException te) {
            throw new IOException("Unable to get transformer handler", te);
        }
    }

    public Document getDocument() {
        if (this.result.getNode() == null) {
            return null;
        }
        if (this.result.getNode().getNodeType() == 9) {
            return (Document)this.result.getNode();
        }
        return this.result.getNode().getOwnerDocument();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.contentHandler.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.contentHandler.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.lexicalHandler.startDTD(name, publicId, systemId);
    }

    @Override
    public void endDTD() throws SAXException {
        this.lexicalHandler.endDTD();
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.lexicalHandler.startEntity(name);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.lexicalHandler.endEntity(name);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.lexicalHandler.startCDATA();
    }

    @Override
    public void endCDATA() throws SAXException {
        this.lexicalHandler.endCDATA();
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.lexicalHandler.comment(ch, start, length);
    }
}

