/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.metrics.prometheus.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.MetricsServlet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Servlet;
import org.apache.sling.metrics.prometheus.impl.WrapperMetricsServletConfiguration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HttpWhiteboardServletPattern(value={"/metrics"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=org.osgi.service.http)")
@Component(service={Servlet.class})
@Designate(ocd=WrapperMetricsServletConfiguration.class)
public class WrapperMetricsServlet
extends MetricsServlet {
    private static final long serialVersionUID = 1L;
    private final MetricRegistry metrics = new MetricRegistry();
    private DropwizardExports exports;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ConcurrentMap<MetricRegistry, CopyMetricRegistryListener> childRegistries = new ConcurrentHashMap<MetricRegistry, CopyMetricRegistryListener>();

    @Activate
    public WrapperMetricsServlet() {
        this.exports = new DropwizardExports(this.metrics);
        CollectorRegistry.defaultRegistry.register((Collector)this.exports);
    }

    @Deactivate
    public void deactivate() {
        CollectorRegistry.defaultRegistry.unregister((Collector)this.exports);
    }

    @Reference(service=MetricRegistry.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    void bindMetricRegistry(MetricRegistry metricRegistry, Map<String, Object> properties) {
        this.log.info("Binding Metrics Registry...");
        String name = this.registryName(metricRegistry, properties);
        CopyMetricRegistryListener listener = new CopyMetricRegistryListener(this.metrics, metricRegistry, name);
        listener.start();
        this.childRegistries.put(metricRegistry, listener);
        this.log.info("Bound Metrics Registry {} ", (Object)name);
    }

    void unbindMetricRegistry(MetricRegistry metricRegistry, Map<String, Object> properties) {
        String name = this.registryName(metricRegistry, properties);
        CopyMetricRegistryListener metricRegistryListener = (CopyMetricRegistryListener)this.childRegistries.remove(metricRegistry);
        if (metricRegistryListener != null) {
            metricRegistryListener.stop();
        }
        this.log.info("Unbound Metrics Registry {} ", (Object)name);
    }

    private String registryName(MetricRegistry metricRegistry, Map<String, Object> properties) {
        String name = (String)properties.get("name");
        if (name == null) {
            name = metricRegistry.toString();
        }
        return name;
    }

    static class CopyMetricRegistryListener
    implements MetricRegistryListener {
        private MetricRegistry parent;
        private MetricRegistry child;
        private String name;

        public CopyMetricRegistryListener(MetricRegistry parent, MetricRegistry child, String name) {
            this.parent = parent;
            this.child = child;
            this.name = name;
        }

        public void start() {
            this.child.addListener((MetricRegistryListener)this);
        }

        public void stop() {
            this.child.removeListener((MetricRegistryListener)this);
            this.child.getMetrics().keySet().stream().map(this::getMetricName).forEach(this::removeMetric);
        }

        public void onGaugeAdded(String name, Gauge<?> gauge) {
            this.addMetric(name, (Metric)gauge);
        }

        public void onGaugeRemoved(String name) {
            this.removeMetric(name);
        }

        public void onCounterAdded(String name, Counter counter) {
            this.addMetric(name, (Metric)counter);
        }

        public void onCounterRemoved(String name) {
            this.removeMetric(name);
        }

        public void onHistogramAdded(String name, Histogram histogram) {
            this.addMetric(name, (Metric)histogram);
        }

        public void onHistogramRemoved(String name) {
            this.removeMetric(name);
        }

        public void onMeterAdded(String name, Meter meter) {
            this.addMetric(name, (Metric)meter);
        }

        public void onMeterRemoved(String name) {
            this.removeMetric(name);
        }

        public void onTimerAdded(String name, Timer timer) {
            this.addMetric(name, (Metric)timer);
        }

        public void onTimerRemoved(String name) {
            this.removeMetric(name);
        }

        private void addMetric(String metricName, Metric m) {
            this.parent.register(this.getMetricName(metricName), m);
        }

        private void removeMetric(String metricName) {
            this.parent.remove(this.getMetricName(metricName));
        }

        private String getMetricName(String metricName) {
            return this.name + "_" + metricName;
        }
    }
}

