/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.sling.engine.impl.parameters.MultipartRequestParameter;

public class SlingPart
implements Part {
    private final MultipartRequestParameter param;

    public SlingPart(MultipartRequestParameter param) {
        this.param = param;
    }

    public InputStream getInputStream() throws IOException {
        return this.param.getInputStream();
    }

    public String getContentType() {
        return this.param.getContentType();
    }

    public String getName() {
        return this.param.getFileItem().getFieldName();
    }

    public long getSize() {
        return this.param.getSize();
    }

    public void write(String fileName) throws IOException {
        throw new IOException("Unsupported yet");
    }

    public void delete() {
        this.param.getFileItem().delete();
    }

    public String getHeader(String name) {
        return this.param.getFileItem().getHeaders().getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        ArrayList<String> headers = new ArrayList<String>();
        Iterator itemHeaders = this.param.getFileItem().getHeaders().getHeaders(name);
        while (itemHeaders.hasNext()) {
            headers.add((String)itemHeaders.next());
        }
        return headers;
    }

    public Collection<String> getHeaderNames() {
        ArrayList<String> headers = new ArrayList<String>();
        Iterator itemHeaders = this.param.getFileItem().getHeaders().getHeaderNames();
        while (itemHeaders.hasNext()) {
            headers.add((String)itemHeaders.next());
        }
        return headers;
    }

    public String getSubmittedFileName() {
        return this.param.getFileName();
    }
}

