/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.internal;

import java.util.Iterator;
import java.util.Map;
import org.ops4j.peaberry.Import;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConcurrentImport<T>
implements Import<T> {
    private final Iterable<Import<T>> services;
    private Import<T> service;
    private T instance;
    private int count;

    ConcurrentImport(Iterable<Import<T>> services) {
        this.services = services;
    }

    @Override
    public synchronized T get() {
        Iterator<Import<T>> i;
        ++this.count;
        if (null == this.service && (i = this.services.iterator()).hasNext()) {
            this.service = i.next();
            this.instance = this.service.get();
        }
        return this.instance;
    }

    @Override
    public synchronized Map<String, ?> attributes() {
        if (null == this.service) {
            Iterator<Import<T>> i = this.services.iterator();
            return i.hasNext() ? i.next().attributes() : null;
        }
        return this.service.attributes();
    }

    @Override
    public synchronized void unget() {
        if (0 == --this.count && null != this.service) {
            Import<T> temp = this.service;
            this.instance = null;
            this.service = null;
            temp.unget();
        }
    }

    @Override
    public synchronized boolean available() {
        if (null == this.service) {
            return this.services.iterator().hasNext();
        }
        return this.service.available();
    }
}

