/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.apache.jackrabbit.core.security.authentication.CredentialsCallback;
import org.apache.jackrabbit.core.security.authentication.DefaultLoginModule;
import org.apache.sling.jcr.jackrabbit.server.impl.Activator;
import org.apache.sling.jcr.jackrabbit.server.impl.security.AdministrativeCredentials;
import org.apache.sling.jcr.jackrabbit.server.impl.security.AnonCredentials;
import org.apache.sling.jcr.jackrabbit.server.impl.security.AuthenticationPluginWrapper;
import org.apache.sling.jcr.jackrabbit.server.impl.security.CallbackHandlerWrapper;
import org.apache.sling.jcr.jackrabbit.server.impl.security.TrustedCredentials;
import org.apache.sling.jcr.jackrabbit.server.security.AuthenticationPlugin;
import org.apache.sling.jcr.jackrabbit.server.security.LoginModulePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluggableDefaultLoginModule
extends DefaultLoginModule {
    private static final Logger log = LoggerFactory.getLogger(PluggableDefaultLoginModule.class);
    private CallbackHandler pluggableCallackHander;

    @Override
    protected void doInit(CallbackHandler callbackHandler, Session session, Map options) throws LoginException {
        LoginModulePlugin[] modules = Activator.getLoginModules();
        for (int i = 0; i < modules.length; ++i) {
            modules[i].doInit(callbackHandler, session, options);
        }
        super.doInit(callbackHandler, session, options);
        this.pluggableCallackHander = callbackHandler;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        CallbackHandlerWrapper wrappedCallbackHandler = new CallbackHandlerWrapper(subject, callbackHandler);
        super.initialize(subject, wrappedCallbackHandler, sharedState, options);
    }

    @Override
    protected Principal getPrincipal(Credentials creds) {
        if (creds instanceof TrustedCredentials) {
            return ((TrustedCredentials)creds).getPrincipal();
        }
        LoginModulePlugin[] modules = Activator.getLoginModules();
        for (int i = 0; i < modules.length; ++i) {
            Principal p;
            if (!modules[i].canHandle(creds) || (p = modules[i].getPrincipal(creds)) == null) continue;
            return p;
        }
        return super.getPrincipal(creds);
    }

    protected Set getPrincipals() {
        Set<Principal> principals = super.getPrincipals();
        LoginModulePlugin[] modules = Activator.getLoginModules();
        for (int i = 0; i < modules.length; ++i) {
            modules[i].addPrincipals(principals);
        }
        return principals;
    }

    @Override
    protected Authentication getAuthentication(Principal principal, Credentials creds) throws RepositoryException {
        if (creds instanceof TrustedCredentials) {
            return ((TrustedCredentials)creds).getTrustedAuthentication();
        }
        LoginModulePlugin[] modules = Activator.getLoginModules();
        for (int i = 0; i < modules.length; ++i) {
            AuthenticationPlugin pa;
            if (!modules[i].canHandle(creds) || (pa = modules[i].getAuthentication(principal, creds)) == null) continue;
            return new AuthenticationPluginWrapper(pa, modules[i]);
        }
        return super.getAuthentication(principal, creds);
    }

    @Override
    protected boolean impersonate(Principal principal, Credentials creds) throws RepositoryException, FailedLoginException {
        if (creds instanceof AdministrativeCredentials) {
            return true;
        }
        if (creds instanceof AnonCredentials) {
            return false;
        }
        LoginModulePlugin[] modules = Activator.getLoginModules();
        for (int i = 0; i < modules.length; ++i) {
            int result;
            if (!modules[i].canHandle(creds) || (result = modules[i].impersonate(principal, creds)) == 0) continue;
            return result == 1;
        }
        return super.impersonate(principal, creds);
    }

    @Override
    protected Credentials getCredentials() {
        Credentials creds = super.getCredentials();
        if (creds == null) {
            CredentialsCallback callback = new CredentialsCallback();
            try {
                this.pluggableCallackHander.handle(new Callback[]{callback});
                Credentials callbackCreds = callback.getCredentials();
                if (callbackCreds instanceof TrustedCredentials) {
                    creds = callbackCreds;
                }
            }
            catch (UnsupportedCallbackException e) {
                log.warn("Credentials-Callback not supported try Name-Callback");
            }
            catch (IOException e) {
                log.error("Credentials-Callback failed: " + e.getMessage() + ": try Name-Callback");
            }
        }
        return creds;
    }

    @Override
    protected boolean supportsCredentials(Credentials creds) {
        if (creds instanceof TrustedCredentials) {
            return true;
        }
        return super.supportsCredentials(creds);
    }
}

