/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.internal.HelperData;
import org.apache.sling.jcr.resource.internal.NodeUtil;
import org.apache.sling.jcr.resource.internal.helper.JcrPropertyMapCacheEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JcrValueMap
implements ValueMap {
    protected final Node node;
    protected final Map<String, JcrPropertyMapCacheEntry> cache = new LinkedHashMap<String, JcrPropertyMapCacheEntry>();
    protected final Map<String, Object> valueCache = new LinkedHashMap<String, Object>();
    private boolean fullyRead = false;
    protected final HelperData helper;

    public JcrValueMap(@NotNull Node node, @NotNull HelperData helper) {
        this.node = node;
        this.helper = helper;
    }

    protected String checkKey(String key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        if (key.startsWith("./")) {
            return key.substring(2);
        }
        return key;
    }

    public <T> T get(@NotNull String aKey, @NotNull Class<T> type) {
        String key = this.checkKey(aKey);
        if (type == null) {
            return (T)this.get(key);
        }
        JcrPropertyMapCacheEntry entry = this.read(key);
        if (entry == null) {
            return null;
        }
        return entry.convertToType(type, this.node, this.helper.getDynamicClassLoader());
    }

    @NotNull
    public <T> T get(@NotNull String aKey, @NotNull T defaultValue) {
        String key = this.checkKey(aKey);
        if (defaultValue == null) {
            return (T)this.get(key);
        }
        Class<?> type = JcrValueMap.normalizeClass(defaultValue.getClass());
        Class<Object> value = this.get(key, (T)type);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public Object get(Object aKey) {
        String key = this.checkKey(aKey.toString());
        JcrPropertyMapCacheEntry entry = this.read(key);
        return entry == null ? null : entry.getPropertyValueOrNull();
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        this.readFully();
        return this.valueCache.containsValue(value);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        this.readFully();
        return this.cache.size();
    }

    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        this.readFully();
        Map<String, Object> sourceMap = this.cache.size() == this.valueCache.size() ? this.valueCache : JcrValueMap.transformEntries(this.cache);
        return Collections.unmodifiableSet(sourceMap.entrySet());
    }

    @NotNull
    public Set<String> keySet() {
        this.readFully();
        return Collections.unmodifiableSet(this.cache.keySet());
    }

    @NotNull
    public Collection<Object> values() {
        this.readFully();
        Map<String, Object> sourceMap = this.cache.size() == this.valueCache.size() ? this.valueCache : JcrValueMap.transformEntries(this.cache);
        return Collections.unmodifiableCollection(sourceMap.values());
    }

    public String getPath() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    private JcrPropertyMapCacheEntry cacheProperty(@NotNull Property prop) {
        try {
            JcrPropertyMapCacheEntry entry;
            String name = prop.getName();
            String key = null;
            if (name.contains("_x") && (key = ISO9075.decode(name)).equals(name)) {
                key = null;
            }
            if (key == null) {
                key = Text.unescapeIllegalJcrChars(name);
            }
            if ((entry = this.cache.get(key)) == null) {
                entry = new JcrPropertyMapCacheEntry(prop);
                this.cache.put(key, entry);
                this.valueCache.put(key, entry.getPropertyValue());
            }
            return entry;
        }
        catch (RepositoryException re) {
            throw new IllegalArgumentException(re);
        }
    }

    @Nullable
    JcrPropertyMapCacheEntry read(@NotNull String name) {
        if (name.length() == 0) {
            return null;
        }
        if (name.indexOf(47) != -1) {
            return this.readPath(name);
        }
        JcrPropertyMapCacheEntry cachedValued = this.cache.get(name);
        if (this.fullyRead || cachedValued != null) {
            return cachedValued;
        }
        try {
            String key = this.escapeKeyName(name);
            Property property = NodeUtil.getPropertyOrNull(this.node, key);
            if (property != null) {
                return this.cacheProperty(property);
            }
        }
        catch (RepositoryException re) {
            throw new IllegalArgumentException(re);
        }
        return null;
    }

    @Nullable
    private JcrPropertyMapCacheEntry readPath(@NotNull String name) {
        int pos;
        String path = ISO9075.encodePath(name);
        try {
            Property property = NodeUtil.getPropertyOrNull(this.node, path);
            if (property != null) {
                return new JcrPropertyMapCacheEntry(property);
            }
        }
        catch (RepositoryException re) {
            throw new IllegalArgumentException(re);
        }
        StringBuilder sb = new StringBuilder();
        int lastPos = -1;
        for (pos = 0; pos < name.length(); ++pos) {
            if (name.charAt(pos) != '/') continue;
            if (lastPos + 1 < pos) {
                sb.append(Text.escapeIllegalJcrChars(name.substring(lastPos + 1, pos)));
            }
            sb.append('/');
            lastPos = pos;
        }
        if (lastPos + 1 < pos) {
            sb.append(Text.escapeIllegalJcrChars(name.substring(lastPos + 1)));
        }
        String newPath = sb.toString();
        try {
            Property property = NodeUtil.getPropertyOrNull(this.node, newPath);
            if (property != null) {
                return new JcrPropertyMapCacheEntry(property);
            }
        }
        catch (RepositoryException re) {
            throw new IllegalArgumentException(re);
        }
        return null;
    }

    @NotNull
    protected String escapeKeyName(@NotNull String key) throws RepositoryException {
        int indexOfPrefix = key.indexOf(58);
        if (indexOfPrefix > 0 && key.length() > indexOfPrefix + 1) {
            String prefix = key.substring(0, indexOfPrefix);
            for (String existingPrefix : this.helper.getNamespacePrefixes(this.node.getSession())) {
                if (!existingPrefix.equals(prefix)) continue;
                return prefix + ":" + Text.escapeIllegalJcrChars(key.substring(indexOfPrefix + 1));
            }
        }
        return Text.escapeIllegalJcrChars(key);
    }

    void readFully() {
        if (!this.fullyRead) {
            try {
                PropertyIterator pi = this.node.getProperties();
                while (pi.hasNext()) {
                    Property prop = pi.nextProperty();
                    this.cacheProperty(prop);
                }
                this.fullyRead = true;
            }
            catch (RepositoryException re) {
                throw new IllegalArgumentException(re);
            }
        }
    }

    private static Class<?> normalizeClass(Class<?> type) {
        if (Calendar.class.isAssignableFrom(type)) {
            type = Calendar.class;
        } else if (Date.class.isAssignableFrom(type)) {
            type = Date.class;
        } else if (Value.class.isAssignableFrom(type)) {
            type = Value.class;
        } else if (Property.class.isAssignableFrom(type)) {
            type = Property.class;
        }
        return type;
    }

    @NotNull
    private static Map<String, Object> transformEntries(@NotNull Map<String, JcrPropertyMapCacheEntry> map) {
        LinkedHashMap<String, Object> transformedEntries = new LinkedHashMap<String, Object>(map.size());
        for (Map.Entry<String, JcrPropertyMapCacheEntry> entry : map.entrySet()) {
            transformedEntries.put(entry.getKey(), entry.getValue().getPropertyValueOrNull());
        }
        return transformedEntries;
    }

    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    public Object put(String aKey, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@NotNull Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object aKey) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this instanceof ModifiableValueMap) {
            sb.append("JcrModifiablePropertyMap");
        } else {
            sb.append("JcrPropertyMap");
        }
        sb.append(" [node=");
        sb.append(this.node);
        sb.append(", values={");
        Iterator<Map.Entry<String, Object>> iter = this.entrySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Map.Entry<String, Object> e = iter.next();
            sb.append(e.getKey());
            sb.append("=");
            sb.append(e.getValue());
        }
        sb.append("}]");
        return sb.toString();
    }
}

