/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.testing.paxexam.it.tests;

import java.io.IOException;

import org.apache.sling.testing.paxexam.it.SlingOptionsHttpTestSupport;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

import static org.apache.sling.testing.paxexam.SlingOptions.slingQuickstartOakMongo;
import static org.ops4j.pax.exam.CoreOptions.options;

@RunWith(PaxExam.class)
@ExamReactorStrategy(PerClass.class)
public class SlingOptionsSlingQuickstartOakMongoIT extends SlingOptionsHttpTestSupport {

    @Configuration
    public Option[] configuration() throws IOException {
        final int httpPort = findFreePort();
        return options(
            baseConfiguration(),
            slingQuickstartOakMongo(workingDirectory(), httpPort, "")
        );
    }

    @Test
    @SuppressWarnings("java:S2699")
    public void test() {
    }

}
