/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.serversetup.instance;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sling.testing.serversetup.jarexec.JarExecutor;

public class SlingInstanceState {
    public static final String DEFAULT_INSTANCE_NAME = "default";
    private String serverBaseUrl;
    private boolean serverStarted = false;
    private boolean serverReady = false;
    private boolean serverReadyTestFailed = false;
    private boolean installBundlesFailed = false;
    private boolean extraBundlesInstalled = false;
    private boolean startupInfoProvided = false;
    private boolean serverInfoLogged = false;
    private JarExecutor jarExecutor;
    static Set<String> startedServersUrls = new CopyOnWriteArraySet<String>();
    private static final Map<String, SlingInstanceState> slingInstancesState = new HashMap<String, SlingInstanceState>();

    public static synchronized SlingInstanceState getInstance(String instanceName) {
        if (slingInstancesState.containsKey(instanceName)) {
            return slingInstancesState.get(instanceName);
        }
        slingInstancesState.put(instanceName, new SlingInstanceState());
        return slingInstancesState.get(instanceName);
    }

    private SlingInstanceState() {
    }

    public boolean isServerStarted() {
        return this.serverStarted;
    }

    public boolean setServerStarted(boolean serverStarted) {
        this.serverStarted = serverStarted;
        return startedServersUrls.add(this.serverBaseUrl);
    }

    public boolean isServerReady() {
        return this.serverReady;
    }

    public void setServerReady(boolean serverReady) {
        this.serverReady = serverReady;
    }

    public boolean isServerReadyTestFailed() {
        return this.serverReadyTestFailed;
    }

    public void setServerReadyTestFailed(boolean serverReadyTestFailed) {
        this.serverReadyTestFailed = serverReadyTestFailed;
    }

    public boolean isInstallBundlesFailed() {
        return this.installBundlesFailed;
    }

    public void setInstallBundlesFailed(boolean installBundlesFailed) {
        this.installBundlesFailed = installBundlesFailed;
    }

    public boolean isExtraBundlesInstalled() {
        return this.extraBundlesInstalled;
    }

    public void setExtraBundlesInstalled(boolean extraBundlesInstalled) {
        this.extraBundlesInstalled = extraBundlesInstalled;
    }

    public boolean isStartupInfoProvided() {
        return this.startupInfoProvided;
    }

    public void setStartupInfoProvided(boolean startupInfoProvided) {
        this.startupInfoProvided = startupInfoProvided;
    }

    public boolean isServerInfoLogged() {
        return this.serverInfoLogged;
    }

    public void setServerInfoLogged(boolean serverInfoLogged) {
        this.serverInfoLogged = serverInfoLogged;
    }

    public JarExecutor getJarExecutor() {
        return this.jarExecutor;
    }

    public void setJarExecutor(JarExecutor jarExecutor) {
        this.jarExecutor = jarExecutor;
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    public void setServerBaseUrl(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
    }
}

