/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.util.tomcat.buf;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.struts2.util.tomcat.buf.ByteChunk;
import org.apache.struts2.util.tomcat.buf.CharChunk;
import org.apache.struts2.util.tomcat.buf.Utf8Decoder;

public class B2CConverter {
    private static final Map<String, Charset> encodingToCharsetCache = new HashMap<String, Charset>();
    public static final Charset ISO_8859_1;
    public static final Charset UTF_8;
    protected static final int LEFTOVER_SIZE = 9;
    private final CharsetDecoder decoder;
    private ByteBuffer bb = null;
    private CharBuffer cb = null;
    private final ByteBuffer leftovers;

    public static Charset getCharset(String enc) throws UnsupportedEncodingException {
        String lowerCaseEnc = enc.toLowerCase(Locale.ENGLISH);
        return B2CConverter.getCharsetLower(lowerCaseEnc);
    }

    public static Charset getCharsetLower(String lowerCaseEnc) throws UnsupportedEncodingException {
        Charset charset = encodingToCharsetCache.get(lowerCaseEnc);
        if (charset == null) {
            throw new UnsupportedEncodingException("The character encoding " + lowerCaseEnc + " is not supported");
        }
        return charset;
    }

    public B2CConverter(String encoding) throws IOException {
        this(encoding, false);
    }

    public B2CConverter(String encoding, boolean replaceOnError) throws IOException {
        byte[] left = new byte[9];
        this.leftovers = ByteBuffer.wrap(left);
        CodingErrorAction action = replaceOnError ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        Charset charset = B2CConverter.getCharset(encoding);
        this.decoder = charset.equals(UTF_8) ? new Utf8Decoder() : charset.newDecoder();
        this.decoder.onMalformedInput(action);
        this.decoder.onUnmappableCharacter(action);
    }

    public void recycle() {
        this.decoder.reset();
        this.leftovers.position(0);
    }

    public void convert(ByteChunk bc, CharChunk cc, boolean endOfInput) throws IOException {
        if (this.bb == null || this.bb.array() != bc.getBuffer()) {
            this.bb = ByteBuffer.wrap(bc.getBuffer(), bc.getStart(), bc.getLength());
        } else {
            this.bb.limit(bc.getEnd());
            this.bb.position(bc.getStart());
        }
        if (this.cb == null || this.cb.array() != cc.getBuffer()) {
            this.cb = CharBuffer.wrap(cc.getBuffer(), cc.getEnd(), cc.getBuffer().length - cc.getEnd());
        } else {
            this.cb.limit(cc.getBuffer().length);
            this.cb.position(cc.getEnd());
        }
        CoderResult result = null;
        if (this.leftovers.position() > 0) {
            int pos = this.cb.position();
            do {
                this.leftovers.put(bc.substractB());
                this.leftovers.flip();
                result = this.decoder.decode(this.leftovers, this.cb, endOfInput);
                this.leftovers.position(this.leftovers.limit());
                this.leftovers.limit(this.leftovers.array().length);
            } while (result.isUnderflow() && this.cb.position() == pos);
            if (result.isError() || result.isMalformed()) {
                result.throwException();
            }
            this.bb.position(bc.getStart());
            this.leftovers.position(0);
        }
        if ((result = this.decoder.decode(this.bb, this.cb, endOfInput)).isError() || result.isMalformed()) {
            result.throwException();
        } else if (result.isOverflow()) {
            bc.setOffset(this.bb.position());
            cc.setEnd(this.cb.position());
        } else if (result.isUnderflow()) {
            bc.setOffset(this.bb.position());
            cc.setEnd(this.cb.position());
            if (bc.getLength() > 0) {
                this.leftovers.limit(this.leftovers.array().length);
                this.leftovers.position(bc.getLength());
                bc.substract(this.leftovers.array(), 0, bc.getLength());
            }
        }
    }

    static {
        for (Charset charset : Charset.availableCharsets().values()) {
            encodingToCharsetCache.put(charset.name().toLowerCase(Locale.ENGLISH), charset);
            for (String alias : charset.aliases()) {
                encodingToCharsetCache.put(alias.toLowerCase(Locale.ENGLISH), charset);
            }
        }
        Charset iso88591 = null;
        Charset utf8 = null;
        try {
            iso88591 = B2CConverter.getCharset("ISO-8859-1");
            utf8 = B2CConverter.getCharset("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ISO_8859_1 = iso88591;
        UTF_8 = utf8;
    }
}

