/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.eventing;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.eventing.SynapseSubscription;
import org.apache.synapse.securevault.PasswordManager;
import org.wso2.eventing.Subscription;
import org.wso2.eventing.SubscriptionManager;
import org.wso2.eventing.exceptions.EventException;

public class EventSourceFactory {
    private static final Log log = LogFactory.getLog(EventSourceFactory.class);
    private static final QName SUBSCRIPTION_MANAGER_QNAME = new QName("http://ws.apache.org/ns/synapse", "subscriptionManager");
    private static final QName PROPERTIES_QNAME = new QName("http://ws.apache.org/ns/synapse", "property");
    private static final QName SUBSCRIPTION_QNAME = new QName("http://ws.apache.org/ns/synapse", "subscription");
    private static final QName FILTER_QNAME = new QName("http://ws.apache.org/ns/synapse", "filter");
    private static final QName ENDPOINT_QNAME = new QName("http://ws.apache.org/ns/synapse", "endpoint");
    private static final QName ADDRESS_QNAME = new QName("http://ws.apache.org/ns/synapse", "address");
    private static final QName EXPIRES_QNAME = new QName("http://ws.apache.org/ns/synapse", "expires");
    private static final QName FILTER_SOURCE_QNAME = new QName("source");
    private static final QName FILTER_DIALECT_QNAME = new QName("dialect");
    private static final QName ID_QNAME = new QName("id");
    private static final QName EP_URI_QNAME = new QName("uri");

    public static SynapseEventSource createEventSource(OMElement elem, Properties properties) {
        SynapseEventSource eventSource = null;
        OMAttribute name = elem.getAttribute(new QName("", "name"));
        if (name == null) {
            EventSourceFactory.handleException("The 'name' attribute is required for a event source de");
        } else {
            eventSource = new SynapseEventSource(name.getAttributeValue());
        }
        OMElement subscriptionManagerElem = elem.getFirstChildWithName(SUBSCRIPTION_MANAGER_QNAME);
        if (eventSource != null && subscriptionManagerElem != null) {
            OMAttribute clazz = subscriptionManagerElem.getAttribute(new QName("", "class"));
            if (clazz != null) {
                String className = clazz.getAttributeValue();
                try {
                    Class<?> subscriptionManagerClass = Class.forName(className);
                    SubscriptionManager manager = (SubscriptionManager)subscriptionManagerClass.newInstance();
                    Iterator itr = subscriptionManagerElem.getChildrenWithName(PROPERTIES_QNAME);
                    while (itr.hasNext()) {
                        OMElement propElem = (OMElement)itr.next();
                        String propName = propElem.getAttribute(new QName("name")).getAttributeValue();
                        String propValue = propElem.getAttribute(new QName("value")).getAttributeValue();
                        if (propName == null || "".equals(propName.trim()) || propValue == null || "".equals(propValue.trim())) continue;
                        propName = propName.trim();
                        propValue = propValue.trim();
                        PasswordManager passwordManager = PasswordManager.getInstance();
                        String key = eventSource.getName() + "." + propName;
                        if (passwordManager.isInitialized() && passwordManager.isTokenProtected(key)) {
                            eventSource.putConfigurationProperty(propName, propValue);
                            propValue = passwordManager.resolve(propValue);
                        }
                        manager.addProperty(propName, propValue);
                    }
                    eventSource.setSubscriptionManager(manager);
                    eventSource.getSubscriptionManager().init();
                }
                catch (ClassNotFoundException e) {
                    EventSourceFactory.handleException("SubscriptionManager class not found", e);
                }
                catch (IllegalAccessException e) {
                    EventSourceFactory.handleException("Unable to access the SubscriptionManager object", e);
                }
                catch (InstantiationException e) {
                    EventSourceFactory.handleException("Unable to instantiate the SubscriptionManager object", e);
                }
            } else {
                EventSourceFactory.handleException("SynapseSubscription manager class is a required attribute");
            }
        } else {
            EventSourceFactory.handleException("SynapseSubscription Manager has not been specified for the event source");
        }
        try {
            EventSourceFactory.createStaticSubscriptions(elem, eventSource);
        }
        catch (EventException e) {
            EventSourceFactory.handleException("Static subscription creation failure", (Exception)((Object)e));
        }
        return eventSource;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static void createStaticSubscriptions(OMElement elem, SynapseEventSource synapseEventSource) throws EventException {
        Iterator iterator = elem.getChildrenWithName(SUBSCRIPTION_QNAME);
        while (iterator.hasNext()) {
            SynapseSubscription synapseSubscription;
            block16: {
                synapseSubscription = new SynapseSubscription();
                OMElement elmSubscription = (OMElement)iterator.next();
                synapseSubscription.setId(elmSubscription.getAttribute(ID_QNAME).getAttributeValue());
                OMElement elmFilter = elmSubscription.getFirstChildWithName(FILTER_QNAME);
                OMAttribute dialectAttr = elmFilter.getAttribute(FILTER_DIALECT_QNAME);
                if (dialectAttr != null && dialectAttr.getAttributeValue() != null) {
                    OMAttribute sourceAttr = elmFilter.getAttribute(FILTER_SOURCE_QNAME);
                    if (sourceAttr != null) {
                        synapseSubscription.setFilterDialect(dialectAttr.getAttributeValue());
                        synapseSubscription.setFilterValue(sourceAttr.getAttributeValue());
                    } else {
                        EventSourceFactory.handleException("Error in creating static subscription. Filter source not defined");
                    }
                } else {
                    EventSourceFactory.handleException("Error in creating static subscription. Filter dialect not defined");
                }
                OMElement elmEndpoint = elmSubscription.getFirstChildWithName(ENDPOINT_QNAME);
                if (elmEndpoint != null) {
                    OMElement elmAddress = elmEndpoint.getFirstChildWithName(ADDRESS_QNAME);
                    if (elmAddress != null) {
                        OMAttribute uriAttr = elmAddress.getAttribute(EP_URI_QNAME);
                        if (uriAttr != null) {
                            synapseSubscription.setEndpointUrl(uriAttr.getAttributeValue());
                            synapseSubscription.setAddressUrl(uriAttr.getAttributeValue());
                        } else {
                            EventSourceFactory.handleException("Error in creating static subscription. URI not defined");
                        }
                    } else {
                        EventSourceFactory.handleException("Error in creating static subscription. Address not defined");
                    }
                } else {
                    EventSourceFactory.handleException("Error in creating static subscription. Endpoint not defined");
                }
                OMElement elmExpires = elmSubscription.getFirstChildWithName(EXPIRES_QNAME);
                if (elmExpires != null) {
                    try {
                        if (elmExpires.getText().startsWith("P")) {
                            synapseSubscription.setExpires(ConverterUtil.convertToDuration((String)elmExpires.getText()).getAsCalendar());
                            break block16;
                        }
                        synapseSubscription.setExpires(ConverterUtil.convertToDateTime((String)elmExpires.getText()));
                    }
                    catch (Exception e) {
                        EventSourceFactory.handleException("Error in creating static subscription. invalid date format", e);
                    }
                } else {
                    synapseSubscription.setExpires(null);
                }
            }
            synapseSubscription.setStaticEntry(true);
            synapseEventSource.getSubscriptionManager().subscribe((Subscription)synapseSubscription);
        }
    }
}

