/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public abstract class AColGroup
implements Serializable {
    protected static final Log LOG = LogFactory.getLog((String)AColGroup.class.getName());
    private static final long serialVersionUID = -1318908671481L;
    protected final IColIndex _colIndexes;

    protected AColGroup(IColIndex colIndices) {
        this._colIndexes = colIndices;
    }

    public final IColIndex getColIndices() {
        return this._colIndexes;
    }

    public final int getNumCols() {
        return this._colIndexes.size();
    }

    public final AColGroup shiftColIndices(int offset) {
        return this.copyAndSet(this._colIndexes.shift(offset));
    }

    protected abstract AColGroup copyAndSet(IColIndex var1);

    public long estimateInMemorySize() {
        long size = 16L;
        return size += this._colIndexes.estimateInMemorySize();
    }

    public final void decompressToSparseBlock(SparseBlock sb, int rl, int ru) {
        this.decompressToSparseBlock(sb, rl, ru, 0, 0);
    }

    public final void decompressToDenseBlock(DenseBlock db, int rl, int ru) {
        this.decompressToDenseBlock(db, rl, ru, 0, 0);
    }

    protected void write(DataOutput out) throws IOException {
        out.writeByte(this.getColGroupType().ordinal());
        this._colIndexes.write(out);
    }

    public long getExactSizeOnDisk() {
        long ret = 0L;
        ++ret;
        return ret += this._colIndexes.getExactSizeOnDisk();
    }

    public final AColGroup sliceColumns(int cl, int cu) {
        AColGroup ret = cu - cl == 1 ? this.sliceColumn(cl) : this.sliceMultiColumns(cl, cu);
        return ret;
    }

    public final AColGroup sliceColumn(int col) {
        int idx = this._colIndexes.findIndex(col);
        if (idx >= 0) {
            return this.sliceSingleColumn(idx);
        }
        return null;
    }

    protected final AColGroup sliceMultiColumns(int cl, int cu) {
        IColIndex.SliceResult sr = this._colIndexes.slice(cl, cu);
        if (sr.ret != null) {
            return this.sliceMultiColumns(sr.idStart, sr.idEnd, sr.ret);
        }
        return null;
    }

    public static double[] colSum(Collection<AColGroup> groups, double[] res, int nRows) {
        for (AColGroup g : groups) {
            g.computeColSums(res, nRows);
        }
        return res;
    }

    public double get(int r, int c) {
        int colIdx = this._colIndexes.findIndex(c);
        if (colIdx < 0) {
            return 0.0;
        }
        return this.getIdx(r, colIdx);
    }

    public abstract double getIdx(int var1, int var2);

    public abstract int getNumValues();

    public abstract CompressionType getCompType();

    protected abstract ColGroupType getColGroupType();

    public abstract void decompressToDenseBlock(DenseBlock var1, int var2, int var3, int var4, int var5);

    public abstract void decompressToSparseBlock(SparseBlock var1, int var2, int var3, int var4, int var5);

    public final AColGroup rightMultByMatrix(MatrixBlock right) {
        return this.rightMultByMatrix(right, null);
    }

    public abstract AColGroup rightMultByMatrix(MatrixBlock var1, IColIndex var2);

    public abstract void tsmm(MatrixBlock var1, int var2);

    public abstract void leftMultByMatrixNoPreAgg(MatrixBlock var1, MatrixBlock var2, int var3, int var4, int var5, int var6);

    public abstract void leftMultByAColGroup(AColGroup var1, MatrixBlock var2, int var3);

    public abstract void tsmmAColGroup(AColGroup var1, MatrixBlock var2);

    public abstract AColGroup scalarOperation(ScalarOperator var1);

    public abstract AColGroup binaryRowOpLeft(BinaryOperator var1, double[] var2, boolean var3);

    public abstract AColGroup binaryRowOpRight(BinaryOperator var1, double[] var2, boolean var3);

    public abstract void unaryAggregateOperations(AggregateUnaryOperator var1, double[] var2, int var3, int var4, int var5);

    protected abstract AColGroup sliceSingleColumn(int var1);

    protected abstract AColGroup sliceMultiColumns(int var1, int var2, IColIndex var3);

    public abstract AColGroup sliceRows(int var1, int var2);

    public abstract double getMin();

    public abstract double getMax();

    public abstract double getSum(int var1);

    public abstract boolean containsValue(double var1);

    public abstract long getNumberNonZeros(int var1);

    public abstract AColGroup replace(double var1, double var3);

    public abstract void computeColSums(double[] var1, int var2);

    public abstract CM_COV_Object centralMoment(CMOperator var1, int var2);

    public abstract AColGroup rexpandCols(int var1, boolean var2, boolean var3, int var4);

    public abstract double getCost(ComputationCostEstimator var1, int var2);

    public abstract AColGroup unaryOperation(UnaryOperator var1);

    public abstract boolean isEmpty();

    public abstract AColGroup append(AColGroup var1);

    public static AColGroup appendN(AColGroup[] groups) {
        return groups[0].appendNInternal(groups);
    }

    protected abstract AColGroup appendNInternal(AColGroup[] var1);

    public abstract ICLAScheme getCompressionScheme();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%15s", "ColGroupType: "));
        sb.append(this.getClass().getSimpleName());
        sb.append(String.format("\n%15s", "Columns: "));
        sb.append(this._colIndexes);
        return sb.toString();
    }

    protected static enum ColGroupType {
        UNCOMPRESSED,
        RLE,
        OLE,
        DDC,
        CONST,
        EMPTY,
        SDC,
        SDCSingle,
        SDCSingleZeros,
        SDCZeros,
        SDCFOR,
        DDCFOR,
        DeltaDDC,
        LinearFunctional;

    }

    public static enum CompressionType {
        UNCOMPRESSED,
        RLE,
        OLE,
        DDC,
        CONST,
        EMPTY,
        SDC,
        SDCFOR,
        DDCFOR,
        DeltaDDC,
        LinearFunctional;

    }
}

