/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils.stats;

import java.util.concurrent.atomic.LongAdder;
import org.apache.sysds.utils.Statistics;

public class ParForStatistics {
    private static final LongAdder optTime = new LongAdder();
    private static final LongAdder optCount = new LongAdder();
    private static final LongAdder initTime = new LongAdder();
    private static final LongAdder mergeTime = new LongAdder();

    public static synchronized void incrementOptimCount() {
        optCount.increment();
    }

    public static synchronized void incrementOptimTime(long time) {
        optTime.add(time);
    }

    public static synchronized void incrementInitTime(long time) {
        initTime.add(time);
    }

    public static synchronized void incrementMergeTime(long time) {
        mergeTime.add(time);
    }

    public static long getOptCount() {
        return optCount.longValue();
    }

    public static long getOptTime() {
        return optTime.longValue();
    }

    public static long getInitTime() {
        return initTime.longValue();
    }

    public static long getMergeTime() {
        return mergeTime.longValue();
    }

    public static void reset() {
        optCount.reset();
        optTime.reset();
        initTime.reset();
        mergeTime.reset();
    }

    public static String displayStatistics() {
        if (optCount.longValue() > 0L) {
            StringBuilder sb = new StringBuilder();
            sb.append("ParFor loops optimized:\t\t" + ParForStatistics.getOptCount() + ".\n");
            sb.append("ParFor optimize time:\t\t" + String.format("%.3f", (double)ParForStatistics.getOptTime() / 1000.0) + " sec.\n");
            sb.append("ParFor initialize time:\t\t" + String.format("%.3f", (double)ParForStatistics.getInitTime() / 1000.0) + " sec.\n");
            sb.append("ParFor result merge time:\t" + String.format("%.3f", (double)ParForStatistics.getMergeTime() / 1000.0) + " sec.\n");
            sb.append("ParFor total update in-place:\t" + Statistics.getTotalUIPVar() + "/" + Statistics.getTotalLixUIP() + "/" + Statistics.getTotalLix() + "\n");
            return sb.toString();
        }
        return "";
    }
}

