/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import org.apache.tapestry5.ioc.internal.services.MethodLogger;
import org.apache.tapestry5.ioc.services.ExceptionTracker;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.slf4j.Logger;

public class LoggingAdvice
implements MethodAdvice {
    private final MethodLogger methodLogger;

    public LoggingAdvice(Logger logger, ExceptionTracker exceptionTracker) {
        this.methodLogger = new MethodLogger(logger, exceptionTracker);
    }

    public void advise(MethodInvocation invocation) {
        boolean debug = this.methodLogger.isDebugEnabled();
        if (!debug) {
            invocation.proceed();
            return;
        }
        this.methodLogger.entry(invocation);
        try {
            invocation.proceed();
        }
        catch (RuntimeException ex) {
            this.methodLogger.fail(invocation, ex);
            throw ex;
        }
        if (invocation.didThrowCheckedException()) {
            Exception thrown = (Exception)invocation.getCheckedException(Exception.class);
            this.methodLogger.fail(invocation, thrown);
            return;
        }
        this.methodLogger.exit(invocation);
    }
}

