/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class CssCompressor {
    private static final Pattern PRESERVE_TOKEN_URL = Pattern.compile("(?i)url\\(\\s*([\"']?)data\\:");
    private static final Pattern PRESERVE_TOKEN_CALC = Pattern.compile("(?i)calc\\(\\s*([\"']?)");
    private static final Pattern PRESERVE_TOKEN_PROGID_DX_IMAGE_TRANSFORM_MICROSOFT_MATRIX = Pattern.compile("(?i)progid:DXImageTransform.Microsoft.Matrix\\s*([\"']?)");
    private static final Pattern PRESERVE_CSS_VARS = Pattern.compile("var\\(--[a-zA-Z0-9-\\-]+(\\))");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern PRESERVE_STRINGS = Pattern.compile("(\"([^\\\\\"]|\\\\.|\\\\)*\")|('([^\\\\']|\\\\.|\\\\)*')");
    private static final Pattern MINIFY_ALPHA_OPACITY_FILTER_STRINGS = Pattern.compile("(?i)progid:DXImageTransform.Microsoft.Alpha\\(Opacity=");
    private static final Pattern UNNECESSARY_SPACES1 = Pattern.compile("(^|\\})((^|([^\\{:])+):)+([^\\{]*\\{)");
    private static final Pattern UNNECESSARY_SPACES2 = Pattern.compile("\\s+([!{};:>+\\(\\)\\],])");
    private static final Pattern IMPORTANT = Pattern.compile("!important");
    private static final Pattern PSEUDO_CLASS_COLON = Pattern.compile("___YUICSSMIN_PSEUDOCLASSCOLON___");
    private static final Pattern IE6_SPACE = Pattern.compile("(?i):first\\-(line|letter)(\\{|,)");
    private static final Pattern CHARSET_DIRECTIVE = Pattern.compile("(?i)^(.*)(@charset)( \"[^\"]*\";)");
    private static final Pattern CHARSET_MULTIPLE = Pattern.compile("(?i)^((\\s*)(@charset)( [^;]+;\\s*))+");
    private static final Pattern LOWERCASE_DIRECTIVES = Pattern.compile("(?i)@(font-face|import|(?:-(?:atsc|khtml|moz|ms|o|wap|webkit)-)?keyframe|media|page|namespace)");
    private static final Pattern LOWERCAUSE_PSEUDO_CLASSES = Pattern.compile("(?i):(active|after|before|checked|disabled|empty|enabled|first-(?:child|of-type)|focus|hover|last-(?:child|of-type)|link|only-(?:child|of-type)|root|:selection|target|visited)");
    private static final Pattern LOWERCASE_FUNCTIONS1 = Pattern.compile("(?i):(lang|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|(?:-(?:moz|webkit)-)?any)\\(");
    private static final Pattern LOWERCASE_FUNCTIONS2 = Pattern.compile("(?i)([:,\\( ]\\s*)(attr|color-stop|from|rgba|to|url|(?:-(?:atsc|khtml|moz|ms|o|wap|webkit)-)?(?:calc|max|min|(?:repeating-)?(?:linear|radial)-gradient)|-webkit-gradient)");
    private static final Pattern RESTORE_AND_SPACE = Pattern.compile("(?i)\\band\\(");
    private static final Pattern TRAILING_SPACES = Pattern.compile("([!{}:;>+\\(\\[,])\\s+");
    private static final Pattern UNNECESSARY_SEMICOLON = Pattern.compile(";+}");
    private static final Pattern ZERO_UNITS = Pattern.compile("(?i)(^|: ?)((?:[0-9a-z-.]+ )*?)?(?:0?\\.)?0(?:px|em|in|cm|mm|pc|pt|ex|deg|g?rad|k?hz)");
    private static final Pattern ZERO_PERCENTAGE = Pattern.compile("(?i)(: ?)((?:[0-9a-z-.]+ )*?)?(?:0?\\.)?0(?:%)");
    private static final Pattern KEYFRAME_TO = Pattern.compile("(?i)(^|,|\\{) ?(?:100% ?\\{)");
    private static final Pattern ZERO_UNITS_GROUPS = Pattern.compile("(?i)\\( ?((?:[0-9a-z-.]+[ ,])*)?(?:0?\\.)?0(?:px|em|%|in|cm|mm|pc|pt|ex|deg|g?rad|m?s|k?hz)");
    private static final Pattern UNNECESSARY_DOT_ZERO1 = Pattern.compile("([0-9])\\.0(px|em|%|in|cm|mm|pc|pt|ex|deg|m?s|g?rad|k?hz| |;)");
    private static final Pattern UNNECESSARY_DOT_ZERO2 = Pattern.compile("([ |:])\\.0(px|em|%|in|cm|mm|pc|pt|ex|deg|m?s|g?rad|k?hz| |;)");
    private static final Pattern ZERO_VALUE_1 = Pattern.compile(":0 0 0 0(;|})");
    private static final Pattern ZERO_VALUE_2 = Pattern.compile(":0 0 0(;|})");
    private static final Pattern ZERO_VALUE_3 = Pattern.compile("(?<!flex):0 0(;|\\})");
    private static final Pattern BACKGROUND_POSITION_TRANSFORM_ORIGIN = Pattern.compile("(?i)(background-position|webkit-mask-position|transform-origin|webkit-transform-origin|moz-transform-origin|o-transform-origin|ms-transform-origin):0(;|})");
    private static final Pattern RESTORE_DOT_ZERO = Pattern.compile("(:|\\s)0+\\.(\\d+)");
    private static final Pattern RGB = Pattern.compile("rgb\\s*\\(\\s*([0-9,\\s]+)\\s*\\)");
    private static final Pattern HEX_COLORS = Pattern.compile("(\\=\\s*?[\"']?)?#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])(:?\\}|[^0-9a-fA-F{][^{]*?\\})");
    private static final Pattern COLOR_RED = Pattern.compile("(:|\\s)(#f00)(;|})");
    private static final Pattern COLOR_NAVY = Pattern.compile("(:|\\s)(#000080)(;|})");
    private static final Pattern COLOR_GRAY = Pattern.compile("(:|\\s)(#808080)(;|})");
    private static final Pattern COLOR_OLIVE = Pattern.compile("(:|\\s)(#808000)(;|})");
    private static final Pattern COLOR_PURPLE = Pattern.compile("(:|\\s)(#800080)(;|})");
    private static final Pattern COLOR_SILVER = Pattern.compile("(:|\\s)(#c0c0c0)(;|})");
    private static final Pattern COLOR_TEAL = Pattern.compile("(:|\\s)(#008080)(;|})");
    private static final Pattern COLOR_ORANGE = Pattern.compile("(:|\\s)(#ffa500)(;|})");
    private static final Pattern COLOR_MAROON = Pattern.compile("(:|\\s)(#800000)(;|})");
    private static final Pattern NONE = Pattern.compile("(?i)(border|border-top|border-right|border-bottom|border-left|outline|background):none(;|})");
    private static final Pattern OPERA_DEVICE_PIXEL_RATIO = Pattern.compile("\\(([\\-A-Za-z]+):([0-9]+)\\/([0-9]+)\\)");
    private static final Pattern EMPTY_RULE = Pattern.compile("[^\\}\\{/;]+\\{\\}");
    private static final Pattern MULTI_SEMICOLON = Pattern.compile(";;+");
    private static final Pattern CALC = Pattern.compile("calc\\([^\\)]*\\)");
    private static final Pattern CALC_PLUS = Pattern.compile("(?<=[-|%|px|em|rem|vw|\\d]+)\\+");
    private static final Pattern CALC_MINUS = Pattern.compile("(?<=[-|%|px|em|rem|vw|\\d]+)\\-");
    private static final Pattern CALC_MULTI = Pattern.compile("(?<=[-|%|px|em|rem|vw|\\d]+)\\*");
    private static final Pattern CALC_DIV = Pattern.compile("(?<=[-|%|px|em|rem|vw|\\d]+)\\/");

    private static String preserveToken(String css, String preservedToken, Pattern tokenRegex, boolean removeWhiteSpace, String preserverIdentifier, List<String> preservedTokens) {
        int maxIndex = css.length() - 1;
        int appendIndex = 0;
        StringBuilder sb = new StringBuilder();
        Pattern p = tokenRegex;
        Matcher m = p.matcher(css);
        while (m.find()) {
            int startIndex = m.start() + (preservedToken.length() + 1);
            String terminator = m.group(1);
            if (m.start() < appendIndex) continue;
            if (terminator.length() == 0) {
                terminator = ")";
            }
            boolean foundTerminator = false;
            int endIndex = m.end() - 1;
            while (!foundTerminator && endIndex + 1 <= maxIndex && (endIndex = css.indexOf(terminator, endIndex + 1)) > 0) {
                if (endIndex <= 0 || css.charAt(endIndex - 1) == '\\') continue;
                foundTerminator = true;
                if (")".equals(terminator)) continue;
                endIndex = css.indexOf(")", endIndex);
            }
            sb.append(css.substring(appendIndex, m.start()));
            if (foundTerminator) {
                String token = css.substring(startIndex, endIndex);
                if (removeWhiteSpace) {
                    token = WHITESPACE.matcher(token).replaceAll("");
                }
                preservedTokens.add(token);
                String preserver = preservedToken + "(___YUICSSMIN_PRESERVED_" + preserverIdentifier + "_" + (preservedTokens.size() - 1) + "___)";
                sb.append(preserver);
                appendIndex = endIndex + 1;
                continue;
            }
            sb.append(css.substring(m.start(), m.end()));
            appendIndex = m.end();
        }
        sb.append(css.substring(appendIndex));
        return sb.toString();
    }

    private static String restorePreservedTokens(String css, String preserverIdentifier, List<String> preservedTokens) {
        String prefix = "___YUICSSMIN_PRESERVED_" + preserverIdentifier + "_";
        for (int idx = 0; idx < preservedTokens.size(); ++idx) {
            css = css.replace(prefix + idx + "___", preservedTokens.get(idx));
        }
        return css;
    }

    public static String compress(InputStream is) throws IOException {
        return CssCompressor.compress(IOUtils.toString((InputStream)is));
    }

    public static String compress(String uncompressedCss) throws IOException {
        String oldCss;
        String s;
        String token;
        String css = uncompressedCss;
        int startIndex = 0;
        int endIndex = 0;
        int i = 0;
        int max = 0;
        ArrayList<String> preservedTokens = new ArrayList<String>();
        ArrayList<String> preservedCssVars = new ArrayList<String>();
        ArrayList<String> comments = new ArrayList<String>();
        int totallen = css.length();
        StringBuilder sb = new StringBuilder(css);
        while ((startIndex = sb.indexOf("/*", startIndex)) >= 0) {
            endIndex = sb.indexOf("*/", startIndex + 2);
            if (endIndex < 0) {
                endIndex = totallen;
            }
            token = sb.substring(startIndex + 2, endIndex);
            comments.add(token);
            sb.replace(startIndex + 2, endIndex, "___YUICSSMIN_PRESERVE_CANDIDATE_COMMENT_" + (comments.size() - 1) + "___");
            startIndex += 2;
        }
        css = sb.toString();
        css = CssCompressor.preserveToken(css, "var", PRESERVE_CSS_VARS, false, "CSS_VAR", preservedCssVars);
        css = CssCompressor.preserveToken(css, "url", PRESERVE_TOKEN_URL, true, "TOKEN", preservedTokens);
        css = CssCompressor.preserveToken(css, "calc", PRESERVE_TOKEN_CALC, false, "TOKEN", preservedTokens);
        css = CssCompressor.preserveToken(css, "progid:DXImageTransform.Microsoft.Matrix", PRESERVE_TOKEN_PROGID_DX_IMAGE_TRANSFORM_MICROSOFT_MATRIX, false, "TOKEN", preservedTokens);
        StringBuffer sbuffer = new StringBuffer();
        Pattern p = PRESERVE_STRINGS;
        Matcher m = p.matcher(css);
        while (m.find()) {
            token = m.group();
            char quote = token.charAt(0);
            if ((token = token.substring(1, token.length() - 1)).indexOf("___YUICSSMIN_PRESERVE_CANDIDATE_COMMENT_") >= 0) {
                max = comments.size();
                for (i = 0; i < max; ++i) {
                    token = token.replace("___YUICSSMIN_PRESERVE_CANDIDATE_COMMENT_" + i + "___", ((String)comments.get(i)).toString());
                }
            }
            token = MINIFY_ALPHA_OPACITY_FILTER_STRINGS.matcher(token).replaceAll("alpha(opacity=");
            preservedTokens.add(token);
            String preserver = quote + "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___" + quote;
            m.appendReplacement(sbuffer, preserver);
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        max = comments.size();
        for (i = 0; i < max; ++i) {
            token = ((String)comments.get(i)).toString();
            String placeholder = "___YUICSSMIN_PRESERVE_CANDIDATE_COMMENT_" + i + "___";
            if (token.startsWith("!")) {
                preservedTokens.add(token);
                css = css.replace(placeholder, "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___");
                continue;
            }
            if (token.endsWith("\\")) {
                preservedTokens.add("\\");
                css = css.replace(placeholder, "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___");
                preservedTokens.add("");
                css = css.replace("___YUICSSMIN_PRESERVE_CANDIDATE_COMMENT_" + ++i + "___", "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___");
                continue;
            }
            if (token.length() == 0 && (startIndex = css.indexOf(placeholder)) > 2 && css.charAt(startIndex - 3) == '>') {
                preservedTokens.add("");
                css = css.replace(placeholder, "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___");
            }
            css = css.replace("/*" + placeholder + "*/", "");
        }
        String backslash9 = "\\9";
        while (css.indexOf("\\9") > -1) {
            preservedTokens.add("\\9");
            css = css.replace("\\9", "___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___");
        }
        css = WHITESPACE.matcher(css).replaceAll(" ");
        sbuffer = new StringBuffer();
        p = UNNECESSARY_SPACES1;
        m = p.matcher(css);
        while (m.find()) {
            s = m.group();
            s = s.replace(":", PSEUDO_CLASS_COLON.pattern());
            s = s.replace("\\", "\\\\");
            s = s.replace("$", "\\$");
            m.appendReplacement(sbuffer, s);
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        css = UNNECESSARY_SPACES2.matcher(css).replaceAll("$1");
        css = IMPORTANT.matcher(css).replaceAll(" !important");
        css = PSEUDO_CLASS_COLON.matcher(css).replaceAll(":");
        sbuffer = new StringBuffer();
        p = IE6_SPACE;
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sbuffer, ":first-" + m.group(1).toLowerCase() + " " + m.group(2));
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        css = css.replace("*/ ", "*/");
        sbuffer = new StringBuffer();
        p = CHARSET_DIRECTIVE;
        m = p.matcher(css);
        while (m.find()) {
            s = m.group(1).replace("\\", "\\\\").replace("$", "\\$");
            m.appendReplacement(sbuffer, m.group(2).toLowerCase() + m.group(3) + s);
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        sbuffer = new StringBuffer();
        p = CHARSET_MULTIPLE;
        m = p.matcher(css);
        while (m.find()) {
            String group2 = m.group(2);
            String group3 = m.group(3);
            String group4 = m.group(4);
            m.appendReplacement(sbuffer, group2 + group3.toLowerCase() + group4);
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        sbuffer = new StringBuffer();
        p = LOWERCASE_DIRECTIVES;
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sbuffer, '@' + m.group(1).toLowerCase());
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        sbuffer = new StringBuffer();
        p = LOWERCAUSE_PSEUDO_CLASSES;
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sbuffer, ':' + m.group(1).toLowerCase());
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        sbuffer = new StringBuffer();
        p = LOWERCASE_FUNCTIONS1;
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sbuffer, ':' + m.group(1).toLowerCase() + '(');
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        sbuffer = new StringBuffer();
        p = LOWERCASE_FUNCTIONS2;
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sbuffer, m.group(1) + m.group(2).toLowerCase());
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        css = RESTORE_AND_SPACE.matcher(css).replaceAll("and (");
        css = TRAILING_SPACES.matcher(css).replaceAll("$1");
        css = UNNECESSARY_SEMICOLON.matcher(css).replaceAll("}");
        p = ZERO_UNITS;
        do {
            oldCss = css;
        } while (!(css = (m = p.matcher(css)).replaceAll("$1$20")).equals(oldCss));
        p = ZERO_PERCENTAGE;
        do {
            oldCss = css;
        } while (!(css = (m = p.matcher(css)).replaceAll("$1$20")).equals(oldCss));
        p = KEYFRAME_TO;
        do {
            oldCss = css;
        } while (!(css = (m = p.matcher(css)).replaceAll("$1to{")).equals(oldCss));
        p = ZERO_UNITS_GROUPS;
        do {
            oldCss = css;
        } while (!(css = (m = p.matcher(css)).replaceAll("($10")).equals(oldCss));
        css = UNNECESSARY_DOT_ZERO1.matcher(css).replaceAll("$1$2");
        css = UNNECESSARY_DOT_ZERO2.matcher(css).replaceAll("$1\\0$2");
        css = ZERO_VALUE_1.matcher(css).replaceAll(":0$1");
        css = ZERO_VALUE_2.matcher(css).replaceAll(":0$1");
        css = ZERO_VALUE_3.matcher(css).replaceAll(":0$1");
        sbuffer = new StringBuffer();
        p = BACKGROUND_POSITION_TRANSFORM_ORIGIN;
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sbuffer, m.group(1).toLowerCase() + ":0 0" + m.group(2));
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        css = RESTORE_DOT_ZERO.matcher(css).replaceAll("$1.$2");
        p = RGB;
        m = p.matcher(css);
        sbuffer = new StringBuffer();
        while (m.find()) {
            String[] rgbcolors = m.group(1).split(",");
            StringBuffer hexcolor = new StringBuffer("#");
            for (i = 0; i < rgbcolors.length; ++i) {
                int val = Integer.parseInt(rgbcolors[i]);
                if (val < 16) {
                    hexcolor.append("0");
                }
                if (val > 255) {
                    val = 255;
                }
                hexcolor.append(Integer.toHexString(val));
            }
            m.appendReplacement(sbuffer, hexcolor.toString());
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        p = HEX_COLORS;
        m = p.matcher(css);
        sb = new StringBuilder();
        int index = 0;
        while (m.find(index)) {
            boolean isFilter;
            sb.append(css.substring(index, m.start()));
            boolean bl = isFilter = m.group(1) != null && !"".equals(m.group(1));
            if (isFilter) {
                sb.append(m.group(1).concat("#").concat(m.group(2)).concat(m.group(3)).concat(m.group(4)).concat(m.group(5)).concat(m.group(6)).concat(m.group(7)));
            } else if (m.group(2).equalsIgnoreCase(m.group(3)) && m.group(4).equalsIgnoreCase(m.group(5)) && m.group(6).equalsIgnoreCase(m.group(7))) {
                sb.append("#".concat(m.group(3)).concat(m.group(5)).concat(m.group(7)).toLowerCase());
            } else {
                sb.append("#".concat(m.group(2)).concat(m.group(3)).concat(m.group(4)).concat(m.group(5) + m.group(6) + m.group(7)).toLowerCase());
            }
            index = m.end(7);
        }
        sb.append(css.substring(index));
        css = sb.toString();
        css = COLOR_RED.matcher(css).replaceAll("$1red$3");
        css = COLOR_NAVY.matcher(css).replaceAll("$1navy$3");
        css = COLOR_GRAY.matcher(css).replaceAll("$1gray$3");
        css = COLOR_OLIVE.matcher(css).replaceAll("$1olive$3");
        css = COLOR_PURPLE.matcher(css).replaceAll("$1purple$3");
        css = COLOR_SILVER.matcher(css).replaceAll("$1silver$3");
        css = COLOR_TEAL.matcher(css).replaceAll("$1teal$3");
        css = COLOR_ORANGE.matcher(css).replaceAll("$1orange$3");
        css = COLOR_MAROON.matcher(css).replaceAll("$1maroon$3");
        sbuffer = new StringBuffer();
        p = NONE;
        m = p.matcher(css);
        while (m.find()) {
            m.appendReplacement(sbuffer, m.group(1).toLowerCase().concat(":0").concat(m.group(2)));
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        css = css.replaceAll("(?i)progid:DXImageTransform.Microsoft.Alpha\\(Opacity=", "alpha(opacity=");
        css = OPERA_DEVICE_PIXEL_RATIO.matcher(css).replaceAll("($1:$2___YUI_QUERY_FRACTION___$3)");
        css = EMPTY_RULE.matcher(css).replaceAll("");
        css = css.replaceAll("___YUI_QUERY_FRACTION___", "/");
        css = MULTI_SEMICOLON.matcher(css).replaceAll(";");
        css = CssCompressor.restorePreservedTokens(css, "TOKEN", preservedTokens);
        sbuffer = new StringBuffer();
        p = CALC;
        m = p.matcher(css);
        while (m.find()) {
            String s2 = m.group();
            s2 = CALC_PLUS.matcher(s2).replaceAll(" + ");
            s2 = CALC_MINUS.matcher(s2).replaceAll(" - ");
            s2 = CALC_MULTI.matcher(s2).replaceAll(" * ");
            s2 = CALC_DIV.matcher(s2).replaceAll(" / ");
            m.appendReplacement(sbuffer, s2);
        }
        m.appendTail(sbuffer);
        css = sbuffer.toString();
        css = CssCompressor.restorePreservedTokens(css, "CSS_VAR", preservedCssVars);
        return css.trim();
    }
}

