/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.tutorial2;

import ojb.broker.Identity;
import org.odmg.Implementation;
import org.odmg.ODMGException;
import org.odmg.Transaction;
import test.ojb.tutorial2.AbstractUseCase;
import test.ojb.tutorial2.Product;

public class UCEnterNewProduct
extends AbstractUseCase {
    public UCEnterNewProduct(Implementation impl) {
        super(impl);
    }

    public void apply() {
        Product newProduct = new Product();
        System.out.println("please enter a new product");
        String in = this.readLineWithMessage("enter name:");
        newProduct.setName(in);
        in = this.readLineWithMessage("enter price:");
        newProduct.setPrice(Double.parseDouble(in));
        in = this.readLineWithMessage("enter available stock:");
        newProduct.setStock(Integer.parseInt(in));
        Transaction tx = null;
        try {
            tx = this.odmg.newTransaction();
            tx.begin();
            System.out.println("new product has no valid _id yet: " + newProduct.getId());
            Identity oid = new Identity(newProduct);
            System.out.println("now _id contains a valid pk: " + newProduct.getId());
            String name = "product_" + newProduct.getId();
            this.odmg.getDatabase(null).makePersistent(newProduct);
            this.odmg.getDatabase(null).bind(newProduct, name);
            tx.commit();
        }
        catch (ODMGException ex) {
            tx.abort();
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public String getDescription() {
        return "Enter a new product";
    }
}

