/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import java.math.BigDecimal;
import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.BigDecimalValidator;
import org.apache.turbine.services.intake.xmlmodel.XmlField;

public class BigDecimalField
extends Field {
    public BigDecimalField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = new BigDecimal(prop);
    }

    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = new BigDecimal(prop);
    }

    protected String getDefaultValidator() {
        return BigDecimalValidator.class.getName();
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            BigDecimal[] values = this.parser.getBigDecimals(this.getKey());
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                values[i] = (BigDecimal)this.getEmptyValue();
            }
            this.setTestValue(values);
        } else {
            this.setTestValue(this.parser.getBigDecimal(this.getKey(), (BigDecimal)this.getEmptyValue()));
        }
    }
}

