/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.assemblerbroker;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.assemblerbroker.util.AssemblerFactory;
import org.apache.turbine.util.TurbineException;

public class TurbineAssemblerBrokerService
extends TurbineBaseService
implements AssemblerBrokerService {
    private static Log log = LogFactory.getLog((Class)TurbineAssemblerBrokerService.class);
    private Map factories = null;

    private List getFactoryGroup(String type) {
        if (!this.factories.containsKey(type)) {
            this.factories.put(type, new Vector());
        }
        return (List)this.factories.get(type);
    }

    private void registerFactories(String type) throws TurbineException {
        List names = this.getConfiguration().getList(type);
        log.info((Object)("Registering " + names.size() + " " + type + " factories."));
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String factory = (String)it.next();
            try {
                Object o = Class.forName(factory).newInstance();
                this.registerFactory(type, (AssemblerFactory)o);
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable t) {
                throw new TurbineException("Failed registering " + type + " factory: " + factory, t);
            }
        }
    }

    public void init() throws InitializationException {
        this.factories = new HashMap();
        try {
            this.registerFactories("action");
            this.registerFactories("screen");
            this.registerFactories("navigation");
            this.registerFactories("layout");
            this.registerFactories("page");
            this.registerFactories("scheduledjob");
        }
        catch (TurbineException e) {
            throw new InitializationException("AssemblerBrokerService failed to initialize", (Throwable)((Object)e));
        }
        this.setInit(true);
    }

    public void registerFactory(String type, AssemblerFactory factory) {
        this.getFactoryGroup(type).add(factory);
    }

    public Assembler getAssembler(String type, String name) throws TurbineException {
        List facs = this.getFactoryGroup(type);
        Assembler assembler = null;
        Iterator it = facs.iterator();
        while (assembler == null && it.hasNext()) {
            AssemblerFactory fac = (AssemblerFactory)it.next();
            try {
                assembler = fac.getAssembler(name);
            }
            catch (Exception e) {
                throw new TurbineException("Failed to load an assembler for " + name + " from the " + type + " factory " + fac.getClass().getName(), e);
            }
        }
        return assembler;
    }
}

