/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.rundata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.pool.PoolService;
import org.apache.turbine.services.pool.TurbinePool;
import org.apache.turbine.services.rundata.DefaultTurbineRunData;
import org.apache.turbine.services.rundata.RunDataService;
import org.apache.turbine.services.rundata.TurbineRunData;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.parser.CookieParser;
import org.apache.turbine.util.parser.DefaultCookieParser;
import org.apache.turbine.util.parser.DefaultParameterParser;
import org.apache.turbine.util.parser.ParameterParser;

public class TurbineRunDataService
extends TurbineBaseService
implements RunDataService {
    public static final String RUN_DATA = "run.data";
    public static final String PARAMETER_PARSER = "parameter.parser";
    public static final String COOKIE_PARSER = "cookie.parser";
    private static final String DEFAULT_RUN_DATA = DefaultTurbineRunData.class.getName();
    private static final String DEFAULT_PARAMETER_PARSER = DefaultParameterParser.class.getName();
    private static final String DEFAULT_COOKIE_PARSER = DefaultCookieParser.class.getName();
    private Map configurations = new HashMap();
    private PoolService pool = null;

    public void init() throws InitializationException {
        String[] def = new String[]{DEFAULT_RUN_DATA, DEFAULT_PARAMETER_PARSER, DEFAULT_COOKIE_PARSER};
        this.configurations.put("default", def.clone());
        Configuration conf = this.getConfiguration();
        if (conf != null) {
            String[] plist = new String[]{RUN_DATA, PARAMETER_PARSER, COOKIE_PARSER};
            Iterator i = conf.getKeys();
            block0: while (i.hasNext()) {
                String key = (String)i.next();
                String value = conf.getString(key);
                for (int j = 0; j < plist.length; ++j) {
                    if (!key.endsWith(plist[j]) || key.length() <= plist[j].length() + 1) continue;
                    String[] config = (String[])this.configurations.get(key = key.substring(0, key.length() - plist[j].length() - 1));
                    if (config == null) {
                        config = (String[])def.clone();
                        this.configurations.put(key, config);
                    }
                    config[j] = value;
                    continue block0;
                }
            }
        }
        this.pool = TurbinePool.getService();
        if (this.pool == null) {
            throw new InitializationException("RunData Service requires configured Pool Service!");
        }
        this.setInit(true);
    }

    public RunData getRunData(HttpServletRequest req, HttpServletResponse res, ServletConfig config) throws TurbineException {
        return this.getRunData("default", req, res, config);
    }

    public RunData getRunData(String key, HttpServletRequest req, HttpServletResponse res, ServletConfig config) throws TurbineException, IllegalArgumentException {
        TurbineRunData data;
        if (req == null || res == null || config == null) {
            throw new IllegalArgumentException("HttpServletRequest, HttpServletResponse or ServletConfig was null.");
        }
        String[] cfg = (String[])this.configurations.get(key);
        if (cfg == null) {
            throw new TurbineException("RunTime configuration '" + key + "' is undefined");
        }
        try {
            data = (TurbineRunData)this.pool.getInstance(cfg[0]);
            ParameterParser pp = (ParameterParser)this.pool.getInstance(cfg[1]);
            data.setParameterParser(pp);
            CookieParser cp = (CookieParser)this.pool.getInstance(cfg[2]);
            data.setCookieParser(cp);
            Locale locale = req.getLocale();
            if (locale == null) {
                locale = data.getLocale();
            }
            data.setLocale(locale);
        }
        catch (ClassCastException x) {
            throw new TurbineException("RunData configuration '" + key + "' is illegal", x);
        }
        data.setRequest(req);
        data.setResponse(res);
        data.setServletConfig(config);
        data.setServerData(new ServerData(req));
        return data;
    }

    public boolean putRunData(RunData data) {
        if (data instanceof TurbineRunData) {
            this.pool.putInstance(((TurbineRunData)data).getParameterParser());
            this.pool.putInstance(((TurbineRunData)data).getCookieParser());
            return this.pool.putInstance(data);
        }
        return false;
    }
}

