/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.turbine.util.parser.BaseValueParser;
import org.apache.turbine.util.parser.ValueParser;

public abstract class DataStreamParser
implements Iterator {
    protected static final String EMPTYFIELDNAME = "UNKNOWNFIELD";
    private List columnNames = Collections.EMPTY_LIST;
    private StreamTokenizer tokenizer;
    private ValueParser lineValues;
    private boolean neverRead = true;
    private String characterEncoding;
    private char fieldSeparator;

    public DataStreamParser(Reader in, List columnNames, String characterEncoding) {
        this.setColumnNames(columnNames);
        this.characterEncoding = characterEncoding;
        if (this.characterEncoding == null) {
            if (in instanceof InputStreamReader) {
                this.characterEncoding = ((InputStreamReader)in).getEncoding();
            }
            if (this.characterEncoding == null) {
                this.characterEncoding = "US-ASCII";
            }
        }
        this.tokenizer = new StreamTokenizer(new BufferedReader(in));
        this.initTokenizer(this.tokenizer);
    }

    protected void initTokenizer(StreamTokenizer tokenizer) {
        tokenizer.resetSyntax();
        tokenizer.wordChars(32, 65535);
        tokenizer.quoteChar(34);
        tokenizer.eolIsSignificant(true);
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
        this.tokenizer.ordinaryChar(fieldSeparator);
    }

    public void setColumnNames(List columnNames) {
        if (columnNames != null) {
            this.columnNames = columnNames;
        }
    }

    public List getColumnNames() {
        return this.columnNames;
    }

    public void readColumnNames() throws IOException {
        ArrayList<String> columnNames = new ArrayList<String>();
        int fieldCounter = 0;
        if (this.hasNextRow()) {
            String colName = null;
            boolean foundEol = false;
            while (!foundEol) {
                this.tokenizer.nextToken();
                if (this.tokenizer.ttype == 34 || this.tokenizer.ttype == -3) {
                    colName = this.tokenizer.sval;
                } else {
                    ++fieldCounter;
                    if (colName == null) {
                        colName = EMPTYFIELDNAME + fieldCounter;
                    }
                    columnNames.add(colName);
                    colName = null;
                }
                if (this.tokenizer.ttype == 10) {
                    foundEol = true;
                    continue;
                }
                if (this.tokenizer.ttype != -1) continue;
                this.tokenizer.pushBack();
                foundEol = true;
            }
            this.setColumnNames(columnNames);
        }
    }

    public boolean hasNextRow() throws IOException {
        if (this.neverRead || this.tokenizer.ttype == 10) {
            this.tokenizer.nextToken();
            this.tokenizer.pushBack();
            this.neverRead = false;
        }
        return this.tokenizer.ttype != -1;
    }

    public ValueParser nextRow() throws IOException, NoSuchElementException {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException();
        }
        if (this.lineValues == null) {
            this.lineValues = new BaseValueParser(this.characterEncoding);
        } else {
            this.lineValues.clear();
        }
        Iterator it = this.columnNames.iterator();
        String currVal = "";
        String colName = null;
        boolean foundEol = false;
        while (!foundEol || it.hasNext()) {
            if (!foundEol) {
                this.tokenizer.nextToken();
            }
            if (colName == null && it.hasNext()) {
                colName = String.valueOf(it.next());
            }
            if (this.tokenizer.ttype == 34 || this.tokenizer.ttype == -3) {
                currVal = this.tokenizer.sval;
            } else {
                this.lineValues.add(colName, currVal);
                colName = null;
                currVal = "";
            }
            if (this.tokenizer.ttype == 10) {
                foundEol = true;
                continue;
            }
            if (this.tokenizer.ttype != -1) continue;
            this.tokenizer.pushBack();
            foundEol = true;
        }
        return this.lineValues;
    }

    public boolean hasNext() {
        boolean hasNext = false;
        try {
            hasNext = this.hasNextRow();
        }
        catch (IOException e) {
            throw new NestableRuntimeException((Throwable)e);
        }
        return hasNext;
    }

    public Object next() throws NoSuchElementException {
        ValueParser nextRow = null;
        try {
            nextRow = this.nextRow();
        }
        catch (IOException e) {
            throw new NestableRuntimeException((Throwable)e);
        }
        return nextRow;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

