/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.DB;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Query;
import org.apache.torque.util.SQLBuilder;
import org.apache.torque.util.SqlEnum;

public final class SqlExpression {
    private static final char SINGLE_QUOTE = '\'';
    private static final char BACKSLASH = '\\';

    private SqlExpression() {
    }

    public static String buildInnerJoin(String column, String relatedColumn) {
        return SqlExpression.buildInnerJoin(column, relatedColumn, false, null);
    }

    public static String buildInnerJoin(String column, String relatedColumn, boolean ignoreCase, DB db) {
        int addlength = ignoreCase ? 25 : 1;
        StringBuffer sb = new StringBuffer(column.length() + relatedColumn.length() + addlength);
        SqlExpression.buildInnerJoin(column, relatedColumn, ignoreCase, db, sb);
        return sb.toString();
    }

    public static void buildInnerJoin(String column, String relatedColumn, boolean ignoreCase, DB db, StringBuffer whereClause) {
        if (ignoreCase) {
            whereClause.append(db.ignoreCase(column)).append('=').append(db.ignoreCase(relatedColumn));
        } else {
            whereClause.append(column).append('=').append(relatedColumn);
        }
    }

    public static String build(String columnName, Object criteria, SqlEnum comparison) throws TorqueException {
        return SqlExpression.build(columnName, criteria, comparison, false, null);
    }

    public static String build(String columnName, Object criteria, SqlEnum comparison, boolean ignoreCase, DB db) throws TorqueException {
        int addlength = ignoreCase ? 40 : 20;
        StringBuffer sb = new StringBuffer(columnName.length() + addlength);
        SqlExpression.build(columnName, criteria, comparison, ignoreCase, db, sb);
        return sb.toString();
    }

    public static void build(String columnName, Object criteria, SqlEnum comparison, boolean ignoreCase, DB db, StringBuffer whereClause) throws TorqueException {
        Date dt;
        if (criteria != null && criteria instanceof ObjectKey && ((ObjectKey)criteria).getValue() == null) {
            criteria = null;
        }
        if (criteria == null) {
            criteria = "null";
            if (comparison.equals(Criteria.EQUAL)) {
                comparison = Criteria.ISNULL;
            } else if (comparison.equals(Criteria.NOT_EQUAL)) {
                comparison = Criteria.ISNOTNULL;
            } else if (comparison.equals(Criteria.ALT_NOT_EQUAL)) {
                comparison = Criteria.ISNOTNULL;
            }
        } else if (criteria instanceof String || criteria instanceof StringKey) {
            criteria = SqlExpression.quoteAndEscapeText(criteria.toString(), db);
        } else if (criteria instanceof Date) {
            dt = (Date)criteria;
            criteria = db.getDateString(dt);
        } else if (criteria instanceof DateKey) {
            dt = (Date)((DateKey)criteria).getValue();
            criteria = db.getDateString(dt);
        } else if (criteria instanceof Boolean) {
            criteria = db.getBooleanString((Boolean)criteria);
        } else if (criteria instanceof Criteria) {
            Query subquery = SQLBuilder.buildQueryClause((Criteria)criteria, null, new SQLBuilder.QueryCallback(){

                public String process(Criteria.Criterion criterion, List params) {
                    return criterion.toString();
                }
            });
            criteria = comparison.equals(Criteria.IN) || comparison.equals(Criteria.NOT_IN) ? subquery.toString() : "(" + subquery.toString() + ")";
        }
        if (comparison.equals(Criteria.LIKE) || comparison.equals(Criteria.NOT_LIKE) || comparison.equals(Criteria.ILIKE) || comparison.equals(Criteria.NOT_ILIKE)) {
            SqlExpression.buildLike(columnName, (String)criteria, comparison, ignoreCase, db, whereClause);
        } else if (comparison.equals(Criteria.IN) || comparison.equals(Criteria.NOT_IN)) {
            SqlExpression.buildIn(columnName, criteria, comparison, ignoreCase, db, whereClause);
        } else if (comparison.equals(Criteria.ISNULL) || comparison.equals(Criteria.ISNOTNULL)) {
            whereClause.append(columnName).append(comparison);
        } else {
            String columnValue = criteria.toString();
            if (ignoreCase && db != null) {
                columnName = db.ignoreCase(columnName);
                columnValue = db.ignoreCase(columnValue);
            }
            whereClause.append(columnName).append(comparison).append(columnValue);
        }
    }

    static String buildLike(String columnName, String criteria, SqlEnum comparison, boolean ignoreCase, DB db) {
        StringBuffer whereClause = new StringBuffer();
        SqlExpression.buildLike(columnName, criteria, comparison, ignoreCase, db, whereClause);
        return whereClause.toString();
    }

    static void buildLike(String columnName, String criteria, SqlEnum comparison, boolean ignoreCase, DB db, StringBuffer whereClause) {
        char checkWildcard;
        int position;
        StringBuffer sb = new StringBuffer();
        boolean replaceWithEquals = true;
        for (position = 0; position < criteria.length(); ++position) {
            checkWildcard = criteria.charAt(position);
            switch (checkWildcard) {
                case '\\': {
                    int charsToProceed;
                    int n = charsToProceed = db.escapeText() ? 2 : 1;
                    if (position + charsToProceed >= criteria.length()) {
                        charsToProceed = criteria.length() - position - 1;
                    } else if (criteria.charAt(position + charsToProceed) == '\\' && db.escapeText()) {
                        ++charsToProceed;
                    }
                    sb.append(criteria.substring(position, position + charsToProceed));
                    checkWildcard = criteria.charAt(position += charsToProceed);
                    break;
                }
                case '%': 
                case '_': {
                    replaceWithEquals = false;
                    break;
                }
                case '*': {
                    replaceWithEquals = false;
                    checkWildcard = '%';
                    break;
                }
                case '?': {
                    replaceWithEquals = false;
                    checkWildcard = '_';
                }
            }
            sb.append(checkWildcard);
        }
        criteria = sb.toString();
        if (ignoreCase) {
            if (db.useIlike() && !replaceWithEquals) {
                if (SqlEnum.LIKE.equals(comparison)) {
                    comparison = SqlEnum.ILIKE;
                } else if (SqlEnum.NOT_LIKE.equals(comparison)) {
                    comparison = SqlEnum.NOT_ILIKE;
                }
            } else {
                columnName = db.ignoreCase(columnName);
            }
        }
        whereClause.append(columnName);
        if (replaceWithEquals) {
            if (comparison.equals(Criteria.NOT_LIKE) || comparison.equals(Criteria.NOT_ILIKE)) {
                whereClause.append(" ").append(Criteria.NOT_EQUAL).append(" ");
            } else {
                whereClause.append(" ").append(Criteria.EQUAL).append(" ");
            }
            sb = new StringBuffer();
            for (position = 0; position < criteria.length(); ++position) {
                checkWildcard = criteria.charAt(position);
                if (checkWildcard == '\\') {
                    int charsToSkip;
                    int n = charsToSkip = db.escapeText() ? 2 : 1;
                    if (position + charsToSkip >= criteria.length()) {
                        charsToSkip = criteria.length() - position - 1;
                    } else if (criteria.charAt(position + charsToSkip) == '\\' && db.escapeText()) {
                        sb.append('\\');
                        ++charsToSkip;
                    }
                    checkWildcard = criteria.charAt(position += charsToSkip);
                }
                sb.append(checkWildcard);
            }
            criteria = sb.toString();
        } else {
            whereClause.append(comparison);
        }
        if (ignoreCase && (!db.useIlike() || replaceWithEquals)) {
            criteria = db.ignoreCase(criteria);
        }
        whereClause.append(criteria);
        if (!replaceWithEquals && db.useEscapeClauseForLike()) {
            whereClause.append(SqlEnum.ESCAPE).append("'\\'");
        }
    }

    static String buildIn(String columnName, Object criteria, SqlEnum comparison, boolean ignoreCase, DB db) {
        StringBuffer whereClause = new StringBuffer();
        SqlExpression.buildIn(columnName, criteria, comparison, ignoreCase, db, whereClause);
        return whereClause.toString();
    }

    static void buildIn(String columnName, Object criteria, SqlEnum comparison, boolean ignoreCase, DB db, StringBuffer whereClause) {
        if (ignoreCase) {
            whereClause.append(db.ignoreCase(columnName));
        } else {
            whereClause.append(columnName);
        }
        whereClause.append(comparison);
        HashSet<Object> inClause = new HashSet<Object>();
        if (criteria instanceof List) {
            Iterator iter = ((List)criteria).iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                inClause.add(SqlExpression.processInValue(value, ignoreCase, db));
            }
        } else if (criteria instanceof String) {
            inClause.add(criteria);
        } else {
            for (int i = 0; i < Array.getLength(criteria); ++i) {
                Object value = Array.get(criteria, i);
                inClause.add(SqlExpression.processInValue(value, ignoreCase, db));
            }
        }
        whereClause.append('(').append(StringUtils.join(inClause.iterator(), (String)",")).append(')');
    }

    static String processInValue(Object value, boolean ignoreCase, DB db) {
        String ret = null;
        ret = value instanceof String ? SqlExpression.quoteAndEscapeText((String)value, db) : value.toString();
        if (ignoreCase) {
            ret = db.ignoreCase(ret);
        }
        return ret;
    }

    public static String quoteAndEscapeText(String rawText, DB db) {
        StringBuffer buf = new StringBuffer((int)((double)rawText.length() * 1.1));
        String escapeString = db != null && !db.escapeText() ? String.valueOf('\\') : String.valueOf('\\') + String.valueOf('\\');
        char[] data = rawText.toCharArray();
        buf.append('\'');
        block4: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '\'': {
                    buf.append('\'').append('\'');
                    continue block4;
                }
                case '\\': {
                    buf.append(escapeString);
                    continue block4;
                }
                default: {
                    buf.append(data[i]);
                }
            }
        }
        buf.append('\'');
        return buf.toString();
    }
}

