/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log.LogTarget;
import org.apache.log.output.db.ColumnInfo;
import org.apache.log.output.db.ColumnType;
import org.apache.log.output.db.DefaultJDBCTarget;
import org.apache.log.output.db.NormalizedJDBCTarget;

public class JDBCTargetFactory
implements LogTargetFactory {
    public LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        DataSource dataSource;
        String dataSourceName = configuration.getChild("datasource", true).getValue();
        boolean normalized = configuration.getChild("normalized", true).getValueAsBoolean(false);
        Configuration tableConfiguration = configuration.getChild("table");
        String table = tableConfiguration.getAttribute("name");
        Configuration[] conf = tableConfiguration.getChildren();
        ColumnInfo[] columns = new ColumnInfo[conf.length];
        for (int i = 0; i < conf.length; ++i) {
            String name = conf[i].getValue();
            int type = ColumnType.getTypeIdFor((String)conf[i].getName());
            String aux = conf[i].getAttribute("aux", null);
            columns[i] = new ColumnInfo(name, type, aux);
        }
        try {
            InitialContext ctx = new InitialContext();
            dataSource = (DataSource)ctx.lookup(dataSourceName);
        }
        catch (NamingException ne) {
            throw new ConfigurationException("Cannot lookup data source", (Throwable)ne);
        }
        Object logTarget = normalized ? new NormalizedJDBCTarget(dataSource, table, columns) : new DefaultJDBCTarget(dataSource, table, columns);
        return logTarget;
    }
}

