/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.pool;

public class BoundedBuffer {
    public static final int DEFAULT_CAPACITY = 1024;
    protected final Object[] array_;
    protected int takePtr_ = 0;
    protected int putPtr_ = 0;
    protected int usedSlots_ = 0;
    protected int emptySlots_;

    public BoundedBuffer(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.array_ = new Object[capacity];
        this.emptySlots_ = capacity;
    }

    public BoundedBuffer() {
        this(1024);
    }

    public synchronized int size() {
        return this.usedSlots_;
    }

    public int capacity() {
        return this.array_.length;
    }

    public synchronized Object peek() {
        if (this.usedSlots_ > 0) {
            return this.array_[this.takePtr_];
        }
        return null;
    }

    public synchronized boolean offer(Object x) {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (this.emptySlots_ > 0) {
            --this.emptySlots_;
            this.array_[this.putPtr_] = x;
            if (++this.putPtr_ >= this.array_.length) {
                this.putPtr_ = 0;
            }
            ++this.usedSlots_;
            return true;
        }
        return false;
    }

    public synchronized Object poll() {
        if (this.usedSlots_ > 0) {
            --this.usedSlots_;
            Object old = this.array_[this.takePtr_];
            this.array_[this.takePtr_] = null;
            if (++this.takePtr_ >= this.array_.length) {
                this.takePtr_ = 0;
            }
            ++this.emptySlots_;
            return old;
        }
        return null;
    }
}

