/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.session;

import java.io.Serializable;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.session.SessionService;

public class SessionListener
implements HttpSessionListener,
HttpSessionActivationListener,
Serializable {
    private static final long serialVersionUID = -8083730704842809870L;
    private SessionService sessionService;

    private SessionService getSessionService() {
        if (this.sessionService == null) {
            this.sessionService = (SessionService)TurbineServices.getInstance().getService("SessionService");
        }
        return this.sessionService;
    }

    public void sessionCreated(HttpSessionEvent event) {
        this.getSessionService().addSession(event.getSession());
        event.getSession().setAttribute(this.getClass().getName(), (Object)this);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.getSessionService().removeSession(event.getSession());
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        this.getSessionService().addSession(event.getSession());
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        this.getSessionService().removeSession(event.getSession());
    }
}

