/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccess;
import org.apache.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;
import org.apache.jcs.utils.serialization.StandardSerializer;

public class JDBCDiskCache
extends AbstractDiskCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCache == null ? (class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCache = JDBCDiskCache.class$("org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCache")) : class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCache));
    private static final long serialVersionUID = -7169488308515823492L;
    private IElementSerializer elementSerializer = new StandardSerializer();
    private JDBCDiskCacheAttributes jdbcDiskCacheAttributes;
    private int updateCount = 0;
    private int getCount = 0;
    private static final int LOG_INTERVAL = 100;
    private JDBCDiskCachePoolAccess poolAccess = null;
    private TableState tableState;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCache;

    public JDBCDiskCache(JDBCDiskCacheAttributes cattr, TableState tableState) {
        super(cattr);
        this.setTableState(tableState);
        this.setJdbcDiskCacheAttributes(cattr);
        if (log.isInfoEnabled()) {
            log.info((Object)("jdbcDiskCacheAttributes = " + this.getJdbcDiskCacheAttributes()));
        }
        this.initializePoolAccess(cattr);
        this.alive = true;
    }

    protected void initializePoolAccess(JDBCDiskCacheAttributes cattr) {
        try {
            try {
                Class.forName(cattr.getDriverClassName());
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Couldn't find class for driver [" + cattr.getDriverClassName() + "]"), (Throwable)e);
            }
            this.poolAccess = new JDBCDiskCachePoolAccess(cattr.getName());
            this.poolAccess.setupDriver(cattr.getUrl() + cattr.getDatabase(), cattr.getUserName(), cattr.getPassword(), cattr.getMaxActive());
            this.poolAccess.logDriverStats();
        }
        catch (Exception e) {
            log.error((Object)"Problem getting connection.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate(ICacheElement ce) {
        block46: {
            Connection con;
            this.incrementUpdateCount();
            if (log.isDebugEnabled()) {
                log.debug((Object)("updating, ce = " + ce));
            }
            try {
                con = this.poolAccess.getConnection();
            }
            catch (SQLException e) {
                log.error((Object)"Problem getting conenction.", (Throwable)e);
                return;
            }
            try {
                long expireTime;
                long now;
                Date createTime;
                boolean exists;
                byte[] element;
                block45: {
                    Statement sStatement = null;
                    try {
                        sStatement = con.createStatement();
                        this.alive = true;
                    }
                    catch (SQLException e) {
                        log.error((Object)"Problem creating statement.", (Throwable)e);
                        this.alive = false;
                    }
                    finally {
                        try {
                            sStatement.close();
                        }
                        catch (SQLException e) {
                            log.error((Object)"Problem closing statement.", (Throwable)e);
                        }
                    }
                    if (!this.alive) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Disk is not alive, aborting put.");
                        }
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Putting [" + ce.getKey() + "] on disk."));
                    }
                    try {
                        element = this.serialize(ce);
                    }
                    catch (IOException e) {
                        log.error((Object)"Could not serialize element", (Throwable)e);
                        try {
                            con.close();
                        }
                        catch (SQLException e2) {
                            log.error((Object)"Problem closing connection.", (Throwable)e2);
                        }
                        return;
                    }
                    exists = false;
                    if (this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) {
                        exists = this.doesElementExist(ce);
                    }
                    if (!exists) {
                        try {
                            String sqlI = "insert into " + this.getJdbcDiskCacheAttributes().getTableName() + " (CACHE_KEY, REGION, ELEMENT, MAX_LIFE_SECONDS, IS_ETERNAL, CREATE_TIME, CREATE_TIME_SECONDS, SYSTEM_EXPIRE_TIME_SECONDS) " + " values (?, ?, ?, ?, ?, ?, ?, ?)";
                            PreparedStatement psInsert = con.prepareStatement(sqlI);
                            psInsert.setString(1, (String)((Object)ce.getKey()));
                            psInsert.setString(2, this.getCacheName());
                            psInsert.setBytes(3, element);
                            psInsert.setLong(4, ce.getElementAttributes().getMaxLifeSeconds());
                            if (ce.getElementAttributes().getIsEternal()) {
                                psInsert.setString(5, "T");
                            } else {
                                psInsert.setString(5, "F");
                            }
                            createTime = new Date(ce.getElementAttributes().getCreateTime());
                            psInsert.setDate(6, createTime);
                            now = System.currentTimeMillis() / 1000L;
                            psInsert.setLong(7, now);
                            expireTime = now + ce.getElementAttributes().getMaxLifeSeconds();
                            psInsert.setLong(8, expireTime);
                            psInsert.execute();
                            psInsert.close();
                        }
                        catch (SQLException e) {
                            if (e.toString().indexOf("Violation of unique index") != -1 || e.getMessage().indexOf("Violation of unique index") != -1 || e.getMessage().indexOf("Duplicate entry") != -1) {
                                exists = true;
                            } else {
                                log.error((Object)"Could not insert element", (Throwable)e);
                            }
                            if (exists || this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) break block45;
                            exists = this.doesElementExist(ce);
                        }
                    }
                }
                if (!exists) break block46;
                String sqlU = null;
                try {
                    sqlU = "update " + this.getJdbcDiskCacheAttributes().getTableName() + " set ELEMENT  = ?, CREATE_TIME = ?, CREATE_TIME_SECONDS = ?, " + " SYSTEM_EXPIRE_TIME_SECONDS = ? " + " where CACHE_KEY = ? and REGION = ?";
                    PreparedStatement psUpdate = con.prepareStatement(sqlU);
                    psUpdate.setBytes(1, element);
                    createTime = new Date(ce.getElementAttributes().getCreateTime());
                    psUpdate.setDate(2, createTime);
                    now = System.currentTimeMillis() / 1000L;
                    psUpdate.setLong(3, now);
                    expireTime = now + ce.getElementAttributes().getMaxLifeSeconds();
                    psUpdate.setLong(4, expireTime);
                    psUpdate.setString(5, (String)((Object)ce.getKey()));
                    psUpdate.setString(6, this.getCacheName());
                    psUpdate.execute();
                    psUpdate.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("ran update " + sqlU));
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)("e2 sql [" + sqlU + "] Exception: "), (Throwable)e2);
                }
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    log.error((Object)"Problem closing connection.", (Throwable)e);
                }
            }
        }
        if (log.isInfoEnabled() && this.updateCount % 100 == 0) {
            log.info((Object)("Update Count [" + this.updateCount + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doesElementExist(ICacheElement ce) {
        Connection con;
        boolean exists = false;
        try {
            con = this.poolAccess.getConnection();
        }
        catch (SQLException e) {
            log.error((Object)"Problem getting conenction.", (Throwable)e);
            return exists;
        }
        Statement psSelect = null;
        try {
            String sqlS = "select CACHE_KEY from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
            psSelect = con.prepareStatement(sqlS);
            psSelect.setString(1, this.getCacheName());
            psSelect.setString(2, (String)((Object)ce.getKey()));
            ResultSet rs = psSelect.executeQuery();
            if (rs.next()) {
                exists = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + ce.getKey() + "] existing status is " + exists));
            }
            rs.close();
        }
        catch (SQLException e) {
            log.error((Object)"Problem looking for item before insert.", (Throwable)e);
        }
        finally {
            try {
                if (psSelect != null) {
                    psSelect.close();
                }
                psSelect.close();
            }
            catch (SQLException e1) {
                log.error((Object)"Problem closing statement.", (Throwable)e1);
            }
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Problem closing connection.", (Throwable)e);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICacheElement doGet(Serializable key) {
        this.incrementGetCount();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting " + key + " from disk"));
        }
        if (!this.alive) {
            return null;
        }
        ICacheElement obj = null;
        byte[] data = null;
        try {
            String selectString = "select ELEMENT from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
            Connection con = this.poolAccess.getConnection();
            try {
                PreparedStatement psSelect = null;
                try {
                    psSelect = con.prepareStatement(selectString);
                    psSelect.setString(1, this.getCacheName());
                    psSelect.setString(2, key.toString());
                    ResultSet rs = psSelect.executeQuery();
                    try {
                        if (rs.next()) {
                            data = rs.getBytes(1);
                        }
                        if (data != null) {
                            try {
                                obj = (ICacheElement)this.getElementSerializer().deSerialize(data);
                            }
                            catch (IOException ioe) {
                                log.error((Object)ioe);
                            }
                            catch (Exception e) {
                                log.error((Object)"Problem getting item.", (Throwable)e);
                            }
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                        rs.close();
                    }
                }
                finally {
                    if (psSelect != null) {
                        psSelect.close();
                    }
                    psSelect.close();
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
        }
        if (log.isInfoEnabled() && this.getCount % 100 == 0) {
            log.info((Object)("Get Count [" + this.getCount + "]"));
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doRemove(Serializable key) {
        String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
        try {
            boolean partial = false;
            if (key instanceof String && key.toString().endsWith(":")) {
                sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY like ?";
                partial = true;
            }
            Connection con = this.poolAccess.getConnection();
            PreparedStatement psSelect = null;
            try {
                psSelect = con.prepareStatement(sql);
                psSelect.setString(1, this.getCacheName());
                if (partial) {
                    psSelect.setString(2, key.toString() + "%");
                } else {
                    psSelect.setString(2, key.toString());
                }
                psSelect.executeUpdate();
                this.alive = true;
            }
            catch (SQLException e) {
                log.error((Object)("Problem creating statement. sql [" + sql + "]"), (Throwable)e);
                this.alive = false;
            }
            finally {
                try {
                    if (psSelect != null) {
                        psSelect.close();
                    }
                    con.close();
                }
                catch (SQLException e1) {
                    log.error((Object)"Problem closing statement.", (Throwable)e1);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem updating cache.", (Throwable)e);
            this.reset();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveAll() {
        if (this.jdbcDiskCacheAttributes.isAllowRemoveAll()) {
            try {
                String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ?";
                Connection con = this.poolAccess.getConnection();
                PreparedStatement psDelete = null;
                try {
                    psDelete = con.prepareStatement(sql);
                    psDelete.setString(1, this.getCacheName());
                    this.alive = true;
                    psDelete.executeUpdate();
                }
                catch (SQLException e) {
                    log.error((Object)"Problem creating statement.", (Throwable)e);
                    this.alive = false;
                }
                finally {
                    try {
                        if (psDelete != null) {
                            psDelete.close();
                        }
                        con.close();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Problem closing statement.", (Throwable)e1);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem removing all.", (Throwable)e);
                this.reset();
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"RemoveAll was requested but the request was not fulfilled: allowRemoveAll is set to false.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deleteExpired() {
        int deleted = 0;
        try {
            this.getTableState().setState(1);
            long now = System.currentTimeMillis() / 1000L;
            String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where IS_ETERNAL = ? and REGION = ? and ? > SYSTEM_EXPIRE_TIME_SECONDS";
            Connection con = this.poolAccess.getConnection();
            PreparedStatement psDelete = null;
            try {
                psDelete = con.prepareStatement(sql);
                psDelete.setString(1, "F");
                psDelete.setString(2, this.getCacheName());
                psDelete.setLong(3, now);
                this.alive = true;
                deleted = psDelete.executeUpdate();
            }
            catch (SQLException e) {
                log.error((Object)"Problem creating statement.", (Throwable)e);
                this.alive = false;
            }
            finally {
                try {
                    if (psDelete != null) {
                        psDelete.close();
                    }
                    con.close();
                }
                catch (SQLException e1) {
                    log.error((Object)"Problem closing statement.", (Throwable)e1);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem removing expired elements from the table.", (Throwable)e);
            this.reset();
        }
        finally {
            this.getTableState().setState(0);
        }
        return deleted;
    }

    public void reset() {
    }

    public void doDispose() {
        try {
            this.poolAccess.shutdownDriver();
        }
        catch (Exception e) {
            log.error((Object)"Problem shutting down.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Connection con;
        int size = 0;
        String selectString = "select count(*) from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ?";
        try {
            con = this.poolAccess.getConnection();
        }
        catch (SQLException e1) {
            log.error((Object)"Problem getting conenction.", (Throwable)e1);
            return size;
        }
        try {
            PreparedStatement psSelect = null;
            try {
                psSelect = con.prepareStatement(selectString);
                psSelect.setString(1, this.getCacheName());
                ResultSet rs = null;
                rs = psSelect.executeQuery();
                try {
                    if (rs.next()) {
                        size = rs.getInt(1);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    rs.close();
                }
            }
            finally {
                if (psSelect != null) {
                    psSelect.close();
                }
                psSelect.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Problem getting size.", (Throwable)e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Problem closing connection.", (Throwable)e);
            }
        }
        return size;
    }

    protected byte[] serialize(Serializable obj) throws IOException {
        return this.getElementSerializer().serialize(obj);
    }

    public Set getGroupKeys(String groupName) {
        throw new UnsupportedOperationException("Groups not implemented.");
    }

    public void setElementSerializer(IElementSerializer elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    public IElementSerializer getElementSerializer() {
        return this.elementSerializer;
    }

    private synchronized void incrementUpdateCount() {
        ++this.updateCount;
    }

    private synchronized void incrementGetCount() {
        ++this.getCount;
    }

    protected void setJdbcDiskCacheAttributes(JDBCDiskCacheAttributes jdbcDiskCacheAttributes) {
        this.jdbcDiskCacheAttributes = jdbcDiskCacheAttributes;
    }

    protected JDBCDiskCacheAttributes getJdbcDiskCacheAttributes() {
        return this.jdbcDiskCacheAttributes;
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.getJdbcDiskCacheAttributes();
    }

    public IStats getStatistics() {
        IStats stats = super.getStatistics();
        stats.setTypeName("JDBC/Abstract Disk Cache");
        stats.getStatElements();
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Update Count");
        se.setData("" + this.updateCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Get Count");
        se.setData("" + this.getCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Size");
        se.setData("" + this.getSize());
        elems.add(se);
        se = new StatElement();
        se.setName("Active DB Connections");
        se.setData("" + this.poolAccess.getNumActiveInPool());
        elems.add(se);
        se = new StatElement();
        se.setName("Idle DB Connections");
        se.setData("" + this.poolAccess.getNumIdleInPool());
        elems.add(se);
        se = new StatElement();
        se.setName("DB URL");
        se.setData(this.jdbcDiskCacheAttributes.getUrl());
        elems.add(se);
        IStatElement[] eqSEs = stats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    protected String getTableName() {
        String name = "UNDEFINED";
        if (this.getJdbcDiskCacheAttributes() != null) {
            name = this.getJdbcDiskCacheAttributes().getTableName();
        }
        return name;
    }

    public void setTableState(TableState tableState) {
        this.tableState = tableState;
    }

    public TableState getTableState() {
        return this.tableState;
    }

    public String toString() {
        return this.getStats();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

