/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.mimetype.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class MimeTypeMapper {
    private HashMap mimeTypeExtensions = new HashMap();
    protected HashMap extensionMimeTypes = new HashMap();

    public MimeTypeMapper() {
    }

    public MimeTypeMapper(InputStream input) throws IOException {
        this.parse(new BufferedReader(new InputStreamReader(input, "ISO-8859-1")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeTypeMapper(File file) throws IOException {
        FileReader freader = new FileReader(file);
        try {
            this.parse(new BufferedReader(freader));
        }
        finally {
            try {
                freader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public MimeTypeMapper(String path) throws IOException {
        this(new File(path));
    }

    public void setContentType(String spec) {
        try {
            this.parse(new BufferedReader(new StringReader(spec)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getContentType(String ext) {
        String lcExt;
        String mimeType = (String)this.mimeTypeExtensions.get(ext);
        if (mimeType == null && ext != null && !ext.equals(lcExt = ext.toLowerCase())) {
            mimeType = (String)this.mimeTypeExtensions.get(lcExt);
        }
        return mimeType;
    }

    public String getExtension(String type) {
        return (String)this.extensionMimeTypes.get(type);
    }

    protected synchronized void parse(BufferedReader reader) throws IOException {
        String next;
        int count = 0;
        String str = null;
        HashMap mimeTypes = (HashMap)this.extensionMimeTypes.clone();
        HashMap extensions = (HashMap)this.mimeTypeExtensions.clone();
        while ((next = reader.readLine()) != null) {
            int l = (str = str == null ? next : str + next).length();
            if (l == 0) {
                str = null;
                continue;
            }
            if (str.charAt(l - 1) != '\\') {
                count += this.parseMimeTypeExtension(str, mimeTypes, extensions);
                str = null;
                continue;
            }
            str = str.substring(0, l - 1);
        }
        if (str != null) {
            count += this.parseMimeTypeExtension(str, mimeTypes, extensions);
        }
        if (count > 0) {
            this.extensionMimeTypes = mimeTypes;
            this.mimeTypeExtensions = extensions;
        }
    }

    protected int parseMimeTypeExtension(String spec, Map mimeTypes, Map extensions) {
        int count = 0;
        if ((spec = spec.trim()).length() > 0 && spec.charAt(0) != '#') {
            StringTokenizer tokens = new StringTokenizer(spec);
            String type = tokens.nextToken();
            while (tokens.hasMoreTokens()) {
                String ext = tokens.nextToken();
                if (ext.length() == 0) continue;
                extensions.put(ext, type);
                if (count++ != 0) continue;
                mimeTypes.put(type, ext);
            }
        }
        return count;
    }
}

