/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.service.shutdown;

import java.io.File;
import java.security.MessageDigest;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.fulcrum.yaafi.service.shutdown.Shutdown;
import org.apache.fulcrum.yaafi.service.shutdown.ShutdownEntry;
import org.apache.fulcrum.yaafi.service.shutdown.ShutdownService;

public class ShutdownServiceImpl
extends AbstractLogEnabled
implements ShutdownService,
Serviceable,
Contextualizable,
Reconfigurable,
Initializable,
Runnable,
Startable,
Disposable {
    private int interval;
    private boolean terminateNow = false;
    private Thread workerThread;
    private ServiceManager serviceManager;
    private File applicationDir;
    private ShutdownEntry shutdownEntry;

    public void service(ServiceManager manager) throws ServiceException {
        this.serviceManager = manager;
    }

    public void contextualize(Context context) throws ContextException {
        this.applicationDir = (File)context.get((Object)"urn:avalon:home");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.interval = Math.max(configuration.getAttributeAsInteger("interval", 5000), 1000);
        this.getLogger().debug("Monitoring the resources every " + this.interval + " ms");
        if (configuration.getChild("entry", false) != null) {
            Configuration shutdownConfig = configuration.getChild("entry");
            String shutdownEntryLocation = shutdownConfig.getChild("location").getValue();
            this.shutdownEntry = new ShutdownEntry(this.getLogger(), this.applicationDir, shutdownEntryLocation, shutdownConfig.getChild("useSystemExit").getValueAsBoolean(false));
            this.getLogger().debug("Using a shutdown entry : " + shutdownEntryLocation);
        } else {
            this.shutdownEntry = null;
            this.getLogger().debug("No shutdown entry defined");
        }
    }

    public void initialize() throws Exception {
        MessageDigest.getInstance("SHA1");
        if (!(this.serviceManager instanceof Disposable)) {
            String msg = "The ServiceManager instance does not implement Disposable?!";
            throw new IllegalArgumentException(msg);
        }
        this.workerThread = new Thread((Runnable)this, "ShutdownService");
    }

    public void start() throws Exception {
        this.getLogger().debug("Starting worker thread ...");
        this.workerThread.start();
    }

    public void stop() throws Exception {
        this.getLogger().debug("Stopping worker thread ...");
        this.terminateNow = true;
        this.workerThread.interrupt();
        this.workerThread.join(10000L);
    }

    public void dispose() {
        this.terminateNow = false;
        this.applicationDir = null;
        this.workerThread = null;
        this.serviceManager = null;
    }

    public void reconfigure(Configuration configuration) throws ConfigurationException {
        this.configure(configuration);
    }

    @Override
    public void run() {
        while (!this.terminateNow) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!this.hasShutdownEntry() || !this.getShutdownEntry().hasChanged() || !(this.serviceManager instanceof Disposable)) continue;
            if (this.getShutdownEntry().isUseSystemExit()) {
                this.getLogger().warn("Forcing a shutdown using System.exit() ...");
            } else {
                this.getLogger().warn("Forcing a shutdown ...");
            }
            Shutdown shutdown = new Shutdown((Disposable)this.serviceManager, this.getShutdownEntry().isUseSystemExit());
            Thread shutdownThread = new Thread((Runnable)shutdown, "ShutdownServiceThread");
            shutdownThread.setDaemon(true);
            shutdownThread.start();
        }
    }

    private ShutdownEntry getShutdownEntry() {
        return this.shutdownEntry;
    }

    private boolean hasShutdownEntry() {
        return this.shutdownEntry != null;
    }
}

