/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.Rule;

@XmlType(name="field")
@XmlAccessorType(value=XmlAccessType.NONE)
public class XmlField
implements Serializable,
LogEnabled {
    private static final long serialVersionUID = -734309157828058007L;
    @XmlAttribute(required=true)
    private String key;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute
    private String displayName;
    @XmlAttribute
    private String displaySize;
    @XmlAttribute
    private String type = "String";
    @XmlAttribute
    private boolean multiValued = false;
    @XmlAttribute
    private String fieldClass;
    @XmlAttribute
    private String mapToObject;
    @XmlAttribute
    private String mapToProperty;
    @XmlAttribute
    private String validator;
    @XmlAttribute
    private String defaultValue;
    @XmlAttribute
    private String emptyValue;
    private List<Rule> rules = new ArrayList<Rule>();
    private Map<String, Rule> ruleMap = new HashMap<String, Rule>();
    private Group parent;
    private Logger log;

    public void enableLogging(Logger logger) {
        this.log = logger;
    }

    public Logger getLogger() {
        return this.log;
    }

    public String getRawName() {
        return this.name;
    }

    public String getName() {
        return StringUtils.replace((String)this.name, (String)"_", (String)"");
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplaySize() {
        return this.displaySize;
    }

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public String getMapToObject() {
        return this.mapToObject;
    }

    public String getMapToProperty() {
        if (this.mapToProperty == null) {
            return this.getName();
        }
        return this.mapToProperty;
    }

    public String getValidator() {
        return this.validator;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }

    public Group getGroup() {
        return this.parent;
    }

    public String getFieldClass() {
        return this.fieldClass;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    @XmlElement(name="rule")
    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public Map<String, Rule> getRuleMap() {
        return this.ruleMap;
    }

    public void afterUnmarshal(Unmarshaller um, Object parent) {
        this.parent = (Group)parent;
        this.ruleMap.clear();
        for (Rule rule : this.rules) {
            this.ruleMap.put(rule.getName(), rule);
        }
        if (this.mapToObject == null && this.mapToProperty != null && !"".equals(this.mapToProperty) && this.parent.getDefaultMapToObject() != null) {
            this.mapToObject = this.parent.getDefaultMapToObject();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" <field name=\"").append(this.name).append("\"").append(" key=\"").append(this.key).append("\"").append(" type=\"").append(this.type).append("\"");
        if (this.displayName != null) {
            result.append(" displayName=\"").append(this.displayName).append("\"");
        }
        if (this.mapToObject != null) {
            result.append(" mapToObject=\"").append(this.mapToObject).append("\"");
        }
        if (this.mapToProperty != null) {
            result.append(" mapToProperty=\"").append(this.mapToProperty).append("\"");
        }
        if (this.validator != null) {
            result.append(" validator=\"").append(this.validator).append("\"");
        }
        if (this.defaultValue != null) {
            result.append(" defaultValue=\"").append(this.defaultValue).append("\"");
        }
        if (this.emptyValue != null) {
            result.append(" emptyValue=\"").append(this.emptyValue).append("\"");
        }
        if (this.rules.size() == 0) {
            result.append(" />\n");
        } else {
            result.append(">\n");
            for (Rule rule : this.rules) {
                result.append(rule);
            }
            result.append("</field>\n");
        }
        return result.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

