/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc;

import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCacheFactory;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.ShrinkerThread;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory.JndiDataSourceFactory;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory.SharedPoolDataSourceFactory;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.config.PropertySetter;

public class JDBCDiskCacheFactory
extends AbstractAuxiliaryCacheFactory
implements IRequireScheduler {
    private static final Log log = LogManager.getLog(JDBCDiskCacheFactory.class);
    private ConcurrentMap<String, TableState> tableStates;
    protected ScheduledExecutorService scheduler;
    private ConcurrentMap<String, ShrinkerThread> shrinkerThreadMap;
    private ConcurrentMap<String, DataSourceFactory> dsFactories;
    protected static final String POOL_CONFIGURATION_PREFIX = "jcs.jdbcconnectionpool.";
    protected static final String ATTRIBUTE_PREFIX = ".attributes";

    public <K, V> JDBCDiskCache<K, V> createCache(AuxiliaryCacheAttributes rawAttr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) throws SQLException {
        JDBCDiskCacheAttributes cattr = (JDBCDiskCacheAttributes)rawAttr;
        TableState tableState = this.getTableState(cattr.getTableName());
        DataSourceFactory dsFactory = this.getDataSourceFactory(cattr, compositeCacheManager.getConfigurationProperties());
        JDBCDiskCache cache = new JDBCDiskCache(cattr, dsFactory, tableState);
        cache.setCacheEventLogger(cacheEventLogger);
        cache.setElementSerializer(elementSerializer);
        this.createShrinkerWhenNeeded(cattr, cache);
        return cache;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.tableStates = new ConcurrentHashMap<String, TableState>();
        this.shrinkerThreadMap = new ConcurrentHashMap<String, ShrinkerThread>();
        this.dsFactories = new ConcurrentHashMap<String, DataSourceFactory>();
    }

    @Override
    public void dispose() {
        this.tableStates.clear();
        for (DataSourceFactory dsFactory : this.dsFactories.values()) {
            try {
                dsFactory.close();
            }
            catch (SQLException e) {
                log.error("Could not close data source factory {0}", dsFactory.getName(), e);
            }
        }
        this.dsFactories.clear();
        this.shrinkerThreadMap.clear();
        super.dispose();
    }

    protected TableState getTableState(String tableName) {
        return this.tableStates.computeIfAbsent(tableName, key -> new TableState((String)key));
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutor) {
        this.scheduler = scheduledExecutor;
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduler;
    }

    protected void createShrinkerWhenNeeded(JDBCDiskCacheAttributes cattr, JDBCDiskCache<?, ?> raf) {
        if (cattr.isUseDiskShrinker()) {
            ScheduledExecutorService shrinkerService = this.getScheduledExecutorService();
            ShrinkerThread shrinkerThread = this.shrinkerThreadMap.computeIfAbsent(cattr.getTableName(), key -> {
                ShrinkerThread newShrinkerThread = new ShrinkerThread();
                long intervalMillis = Math.max(999, cattr.getShrinkerIntervalSeconds() * 1000);
                log.info("Setting the shrinker to run every [{0}] ms. for table [{1}]", intervalMillis, key);
                shrinkerService.scheduleAtFixedRate(newShrinkerThread, 0L, intervalMillis, TimeUnit.MILLISECONDS);
                return newShrinkerThread;
            });
            shrinkerThread.addDiskCacheToShrinkList(raf);
        }
    }

    protected DataSourceFactory getDataSourceFactory(JDBCDiskCacheAttributes cattr, Properties configProps) throws SQLException {
        String poolName = null;
        poolName = cattr.getConnectionPoolName() == null ? cattr.getCacheName() + "." + "jcs" : cattr.getConnectionPoolName();
        DataSourceFactory dsFactory = this.dsFactories.computeIfAbsent(poolName, key -> {
            JDBCDiskCacheAttributes dsConfig = null;
            if (cattr.getConnectionPoolName() == null) {
                dsConfig = cattr;
            } else {
                dsConfig = new JDBCDiskCacheAttributes();
                String dsConfigAttributePrefix = POOL_CONFIGURATION_PREFIX + key + ATTRIBUTE_PREFIX;
                PropertySetter.setProperties(dsConfig, configProps, dsConfigAttributePrefix + ".");
                dsConfig.setConnectionPoolName((String)key);
            }
            DataSourceFactory newDsFactory = dsConfig.getJndiPath() != null ? new JndiDataSourceFactory() : new SharedPoolDataSourceFactory();
            try {
                newDsFactory.initialize(dsConfig);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return newDsFactory;
        });
        return dsFactory;
    }
}

