/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.pages;

import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.pages.DefaultPage;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class TemplatePage
extends DefaultPage {
    @TurbineService
    private TemplateService templateService;

    @Override
    protected void doBuildAfterAction(PipelineData pipelineData) throws Exception {
        RunData data = pipelineData.getRunData();
        if (!data.hasScreen()) {
            String template = data.getTemplateInfo().getScreenTemplate();
            String layoutTemplate = this.templateService.getLayoutTemplateName(template);
            data.getTemplateInfo().setLayoutTemplate(layoutTemplate);
            String screen = this.templateService.getScreenName(template);
            if (screen == null) {
                String errMsg = "Couldn't map Template " + template + " to any Screen class!";
                this.log.error(errMsg);
                throw new TurbineException(errMsg);
            }
            data.setScreen(screen);
        }
    }
}

