/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.searchStrategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.caseditor.ide.searchstrategy.ITypeSystemSearchStrategy;
import org.apache.uima.ruta.ide.core.RutaNature;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ListDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorFolderSearchStrategy
implements ITypeSystemSearchStrategy {
    private List<IFile> collectTypeSystems(IFolder folder) throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        for (IResource each : folder.members()) {
            if (each instanceof IFolder) {
                result.addAll(this.collectTypeSystems((IFolder)each));
                continue;
            }
            if (!(each instanceof IFile) || each.getFileExtension() == null || !each.getFileExtension().equals("xml")) continue;
            result.add((IFile)each);
        }
        return result;
    }

    public IFile findTypeSystem(IFile casFile) {
        IProject project = casFile.getProject();
        try {
            IProjectNature nature = project.getNature("org.apache.uima.ruta.ide.nature");
            if (!(nature instanceof RutaNature)) {
                return null;
            }
        }
        catch (CoreException e) {
            return null;
        }
        IFolder folder = project.getFolder(RutaProjectUtils.getDefaultDescriptorLocation());
        try {
            List<IFile> list = this.collectTypeSystems(folder);
            ListDialog ld = new ListDialog(Display.getCurrent().getActiveShell());
            ld.setContentProvider(new IStructuredContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public Object[] getElements(Object inputElement) {
                    return ((Collection)inputElement).toArray();
                }
            });
            ld.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((IFile)element).getName();
                }
            });
            if (list == null || list.isEmpty()) {
                return null;
            }
            ld.setTitle("Select Type System Descriptor");
            ld.setInput(list);
            ld.open();
            if (ld.getResult() != null) {
                return (IFile)ld.getResult()[0];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

