/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.model;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.model.AbstractModelPart;

public class DefinedTypesWithSupers
extends AbstractModelPart {
    private Set cachedResult;

    public DefinedTypesWithSupers(MultiPageEditor pModelRoot) {
        super(pModelRoot);
        this.cachedResult = new HashSet(this.modelRoot.INITIAL_SIZE_TYPE_COLLECTIONS);
    }

    public Set get() {
        if (this.dirty) {
            this.update();
            this.dirty = false;
        }
        return this.cachedResult;
    }

    private void update() {
        this.cachedResult.clear();
        TypeSystemDescription typeSystemDescription = this.modelRoot.getMergedTypeSystemDescription();
        if (typeSystemDescription == null) {
            return;
        }
        TypeDescription[] types = typeSystemDescription.getTypes();
        TypeSystem typeSystem = this.modelRoot.descriptorCAS.get().getTypeSystem();
        Map allTypes = this.modelRoot.allTypes.get();
        for (int i = 0; i < types.length; ++i) {
            String typeName = types[i].getName();
            this.cachedResult.add(typeName);
            Type nextType = (Type)allTypes.get(typeName);
            while (nextType != null) {
                if ((nextType = typeSystem.getParent(nextType)) == null) continue;
                this.cachedResult.add(nextType.getName());
            }
        }
    }
}

