/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import java.util.Map;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.action.MarkFastAction;
import org.apache.uima.ruta.action.MarkFastReloadAction;
import org.apache.uima.ruta.action.MarkTableAction;
import org.apache.uima.ruta.action.MarkTableReloadAction;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.resource.WordTableExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.extensions.IRutaActionExtension;
import org.apache.uima.ruta.extensions.RutaParseException;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;

public class MarkReloadExtension
implements IRutaActionExtension {
    private final String[] knownExtensions = new String[]{"MARKFASTRELOAD", "MARKTABLERELOAD"};
    private final Class<?>[] extensions = new Class[]{MarkFastReloadAction.class, MarkTableReloadAction.class};

    @Override
    public String verbalize(RutaElement element, RutaVerbalizer verbalizer) {
        if (element instanceof MarkFastReloadAction) {
            MarkFastAction a = (MarkFastAction)element;
            String list = "";
            if (a.getList() != null) {
                list = verbalizer.verbalize(a.getList());
            } else if (a.getStringList() != null) {
                list = verbalizer.verbalize(a.getStringList());
            }
            return this.knownExtensions[0] + verbalizer.verbalize(a.getType()) + ", " + list + ", " + verbalizer.verbalize(a.getIgnore()) + ", " + verbalizer.verbalize(a.getIgnoreLength()) + ", " + verbalizer.verbalize(a.getIgnoreWS()) + ")";
        }
        if (element instanceof MarkTableReloadAction) {
            MarkTableAction a = (MarkTableAction)element;
            ITypeExpression typeExpr = a.getTypeExpr();
            INumberExpression indexExpr = a.getIndexExpr();
            WordTableExpression tableExpr = a.getTableExpr();
            Map<IStringExpression, INumberExpression> featureMap = a.getFeatureMap();
            IBooleanExpression ignoreCase = a.getIgnoreCase();
            INumberExpression ignoreLength = a.getIgnoreLength();
            IStringExpression ignoreChar = a.getIgnoreChar();
            INumberExpression maxIgnoreChar = a.getMaxIgnoreChar();
            String type = verbalizer.verbalize(typeExpr);
            String index = verbalizer.verbalize(indexExpr);
            String table = verbalizer.verbalize(tableExpr);
            Object map = "";
            if (featureMap != null) {
                map = (String)map + ", ";
                for (IStringExpression each : featureMap.keySet()) {
                    map = (String)map + verbalizer.verbalize(each);
                    map = (String)map + " = ";
                    map = (String)map + verbalizer.verbalize(featureMap.get(each));
                    map = (String)map + ", ";
                }
            }
            String icase = ignoreCase == null ? "" : ", " + verbalizer.verbalize(ignoreCase);
            String ilength = ignoreCase == null ? "" : ", " + verbalizer.verbalize(ignoreLength);
            String ichar = ignoreCase == null ? "" : ", " + verbalizer.verbalize(ignoreChar);
            String mic = ignoreCase == null ? "" : ", " + verbalizer.verbalize(maxIgnoreChar);
            return this.knownExtensions[1] + type + ", " + index + ", " + table + (String)map + icase + ilength + ichar + mic + ")";
        }
        return "UnknownAction";
    }

    @Override
    public AbstractRutaAction createAction(String name, List<RutaExpression> args) throws RutaParseException {
        INumberExpression ignoreLength = null;
        ITypeExpression typeExpr = null;
        switch (name) {
            case "MARKFASTRELOAD": {
                if (args.size() < 2) {
                    throw new RutaParseException("Not enough arguments for action " + name + ": " + args);
                }
                IStringExpression listName = null;
                IBooleanExpression ignore = null;
                IBooleanExpression ignoreWS = null;
                if (!(args.get(0) instanceof ITypeExpression)) {
                    throw new RutaParseException("Expected typeExpr expression argument typeExpr for action " + name + " but got " + args.get(0).getClass().getName());
                }
                typeExpr = (ITypeExpression)((Object)args.get(0));
                if (!(args.get(1) instanceof IStringExpression)) {
                    throw new RutaParseException("Expected string expression argument listName for action " + name + " but got " + args.get(1).getClass().getName());
                }
                listName = (IStringExpression)((Object)args.get(1));
                if (args.size() <= 2 || !(args.get(2) instanceof IBooleanExpression)) {
                    throw new RutaParseException("Expected boolean expression argument ignore for action " + name + " but got " + args.get(2).getClass().getName());
                }
                ignore = (IBooleanExpression)((Object)args.get(2));
                if (args.size() <= 3 || !(args.get(3) instanceof INumberExpression)) {
                    throw new RutaParseException("Expected number expression argument ignoreLength for action " + name + " but got " + args.get(3).getClass().getName());
                }
                ignoreLength = (INumberExpression)((Object)args.get(3));
                if (args.size() <= 4 || !(args.get(4) instanceof IBooleanExpression)) {
                    throw new RutaParseException("Expected boolean expression argument ignoreWS for action " + name + " but got " + args.get(4).getClass().getName());
                }
                ignoreWS = (IBooleanExpression)((Object)args.get(4));
                return new MarkFastReloadAction(typeExpr, listName, ignore, ignoreLength, ignoreWS);
            }
            case "MARKTABLERELOAD": {
                if (args.size() < 3) {
                    throw new RutaParseException("Not enough arguments for action " + name + ": " + args);
                }
                INumberExpression indexExpr = null;
                IStringExpression tableName = null;
                Map featureMap = null;
                IBooleanExpression ignoreCase = null;
                IStringExpression ignoreChar = null;
                INumberExpression maxIgnoreChar = null;
                if (!(args.get(0) instanceof ITypeExpression)) {
                    throw new RutaParseException("Expected type expression argument typeExpr for action " + name + " but got " + args.get(0).getClass().getName());
                }
                typeExpr = (ITypeExpression)((Object)args.get(0));
                if (!(args.get(1) instanceof INumberExpression)) {
                    throw new RutaParseException("Expected number expression argument indexExpr for action " + name + " but got " + args.get(1).getClass().getName());
                }
                indexExpr = (INumberExpression)((Object)args.get(1));
                if (!(args.get(2) instanceof IStringExpression)) {
                    throw new RutaParseException("Expected string expression argument tableName for action " + name + " but got " + args.get(2).getClass().getName());
                }
                tableName = (IStringExpression)((Object)args.get(2));
                if (args.size() <= 3 || !(args.get(3) instanceof Map)) {
                    throw new RutaParseException("Expected map argument featureMap for action " + name + " but got " + args.get(3).getClass().getName());
                }
                featureMap = (Map)((Object)args.get(3));
                if (args.size() <= 4 || !(args.get(4) instanceof IBooleanExpression)) {
                    throw new RutaParseException("Expected boolean expression argument ignoreCase for action " + name + " but got " + args.get(4).getClass().getName());
                }
                ignoreCase = (IBooleanExpression)((Object)args.get(4));
                if (args.size() <= 5 || !(args.get(5) instanceof INumberExpression)) {
                    throw new RutaParseException("Expected number expression argument ignoreLength for action " + name + " but got " + args.get(5).getClass().getName());
                }
                ignoreLength = (INumberExpression)((Object)args.get(5));
                if (args.size() <= 6 || !(args.get(6) instanceof IStringExpression)) {
                    throw new RutaParseException("Expected boolean expression argument ignoreChar for action " + name + " but got " + args.get(6).getClass().getName());
                }
                ignoreChar = (IStringExpression)((Object)args.get(6));
                if (args.size() <= 7 || !(args.get(7) instanceof INumberExpression)) {
                    throw new RutaParseException("Expected number expression argument maxIgnoreChar for action " + name + " but got " + args.get(7).getClass().getName());
                }
                maxIgnoreChar = (INumberExpression)((Object)args.get(7));
                return new MarkTableReloadAction(typeExpr, indexExpr, tableName, featureMap, ignoreCase, ignoreLength, ignoreChar, maxIgnoreChar);
            }
        }
        return null;
    }

    @Override
    public String verbalizeName(RutaElement element) {
        if (element instanceof MarkFastReloadAction) {
            return this.knownExtensions[0];
        }
        if (element instanceof MarkTableReloadAction) {
            return this.knownExtensions[1];
        }
        return "<unknown>";
    }

    @Override
    public String[] getKnownExtensions() {
        return this.knownExtensions;
    }

    @Override
    public Class<?>[] extensions() {
        return this.extensions;
    }
}

