/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class Replace
extends SystemFunction {
    private RegularExpression regexp;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Expression expression = this.simplifyArguments(staticContext);
        if (this.regexp == null && !(expression instanceof Literal)) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 3, staticContext);
            }
            catch (StaticError staticError) {
                staticError.setLocator(this);
                throw staticError;
            }
            if (this.regexp != null && this.regexp.matches("")) {
                DynamicError dynamicError = new DynamicError("The regular expression in replace() must not be one that matches a zero-length string");
                dynamicError.setErrorCode("FORX0003");
                dynamicError.setLocator(this);
                throw dynamicError;
            }
        }
        return expression;
    }

    public RegularExpression getCompiledRegularExpression() {
        return this.regexp;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        CharSequence charSequence;
        Object object;
        RegularExpression regularExpression;
        AtomicValue atomicValue;
        CharSequence charSequence2;
        String string;
        AtomicValue atomicValue2 = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            atomicValue2 = StringValue.EMPTY_STRING;
        }
        if ((string = Replace.checkReplacement(charSequence2 = (atomicValue = (AtomicValue)this.argument[2].evaluateItem(xPathContext)).getStringValueCS())) != null) {
            this.dynamicError(string, "FORX0004", xPathContext);
        }
        if ((regularExpression = this.regexp) == null) {
            Serializable serializable;
            object = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
            if (this.argument.length == 3) {
                charSequence = "";
            } else {
                serializable = (AtomicValue)this.argument[3].evaluateItem(xPathContext);
                charSequence = ((AtomicValue)serializable).getStringValueCS();
            }
            try {
                serializable = Configuration.getPlatform();
                regularExpression = serializable.compileRegularExpression(((AtomicValue)object).getStringValueCS(), true, charSequence);
            }
            catch (XPathException xPathException) {
                DynamicError dynamicError = new DynamicError(xPathException);
                dynamicError.setErrorCode("FORX0002");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(this);
                throw dynamicError;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                DynamicError dynamicError = new DynamicError(patternSyntaxException);
                dynamicError.setErrorCode("FORX0002");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(this);
                throw dynamicError;
            }
            if (regularExpression.matches("")) {
                this.dynamicError("The regular expression in replace() must not be one that matches a zero-length string", "FORX0003", xPathContext);
            }
        }
        object = atomicValue2.getStringValue();
        charSequence = regularExpression.replace((CharSequence)object, charSequence2);
        return StringValue.makeStringValue(charSequence);
    }

    public static String checkReplacement(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 == '$') {
                if (i + 1 < charSequence.length()) {
                    if ((c = charSequence.charAt(++i)) >= '0' && c <= '9') continue;
                    return "Invalid replacement string in replace(): $ sign must be followed by digit 0-9";
                }
                return "Invalid replacement string in replace(): $ sign at end of string";
            }
            if (c2 != '\\') continue;
            if (i + 1 < charSequence.length()) {
                if ((c = charSequence.charAt(++i)) == '\\' || c == '$') continue;
                return "Invalid replacement string in replace(): \\ character must be followed by \\ or $";
            }
            return "Invalid replacement string in replace(): \\ character at end of string";
        }
        return null;
    }
}

