/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class ObjectValue
extends AtomicValue {
    private Object value;

    public ObjectValue() {
        this.typeLabel = BuiltInAtomicType.ANY_ATOMIC;
    }

    public ObjectValue(Object object) {
        this.value = object;
        this.typeLabel = BuiltInAtomicType.ANY_ATOMIC;
    }

    public ObjectValue(Object object, ExternalObjectType externalObjectType) {
        this.value = object;
        this.typeLabel = externalObjectType;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public AtomicValue copy(AtomicType atomicType) {
        ObjectValue objectValue = new ObjectValue(this.value);
        objectValue.typeLabel = atomicType;
        return objectValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.typeLabel.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            if (typeHierarchy == null) {
                throw new NullPointerException("No TypeHierarchy supplied");
            }
            Configuration configuration = typeHierarchy.getConfiguration();
            this.typeLabel = new ExternalObjectType(this.value.getClass(), configuration);
        }
        return this.typeLabel;
    }

    public String displayTypeName() {
        return "java-type:" + this.value.getClass().getName();
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 285: 
            case 632: {
                return this;
            }
            case 514: {
                return BooleanValue.get(this.value == null ? false : this.value.toString().length() > 0);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        return new StringValue(this.getStringValue()).convertPrimitive(builtInAtomicType, bl, xPathContext);
    }

    public String getStringValue() {
        return this.value == null ? "" : this.value.toString();
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return this.value != null;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean equals(Object object) {
        return this.value.equals(((ObjectValue)object).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (this.value == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.value.getClass())) {
            return this.value;
        }
        if (clazz == Value.class || clazz == ObjectValue.class) {
            return this;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            BooleanValue booleanValue = (BooleanValue)this.convert(BuiltInAtomicType.BOOLEAN, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            DoubleValue doubleValue = (DoubleValue)this.convert(BuiltInAtomicType.DOUBLE, xPathContext);
            return new Double(doubleValue.getDoubleValue());
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            DoubleValue doubleValue = (DoubleValue)this.convert(BuiltInAtomicType.FLOAT, xPathContext);
            return new Float(doubleValue.getDoubleValue());
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Long(int64Value.longValue());
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Integer((int)int64Value.longValue());
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Short((short)int64Value.longValue());
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            Int64Value int64Value = (Int64Value)this.convert(BuiltInAtomicType.INTEGER, xPathContext);
            return new Byte((byte)int64Value.longValue());
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            String string = this.getStringValue();
            if (string.length() == 1) {
                return new Character(string.charAt(0));
            }
            throw new DynamicError("Cannot convert string to Java char unless length is 1");
        }
        throw new DynamicError("Conversion of external object to " + clazz.getName() + " is not supported");
    }
}

