/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.xbean.propertyeditor.Converter;
import org.apache.xbean.propertyeditor.PropertyEditorException;

public final class CollectionUtil {
    public static List toList(String text, PropertyEditor componentEditor) {
        if (text.length() == 0) {
            return null;
        }
        if (text.startsWith("[") && text.endsWith("]")) {
            text = text.substring(1, text.length() - 1).trim();
        }
        LinkedList<Object> list = new LinkedList<Object>();
        if (text.length() > 0) {
            StringTokenizer stok = new StringTokenizer(text, ",");
            while (stok.hasMoreTokens()) {
                String innerText = stok.nextToken();
                Object value = CollectionUtil.componentToObject(innerText, componentEditor);
                list.add(value);
            }
        }
        return list;
    }

    public static String toString(Collection values, PropertyEditor componentEditor) {
        if (values.size() == 0) {
            return "[]";
        }
        StringBuffer result = new StringBuffer();
        result.append("[");
        int i = 0;
        for (Object object : values) {
            String text = CollectionUtil.componentToString(object, componentEditor);
            if (i > 0) {
                result.append(",");
            }
            result.append(text);
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public static final Map toMap(String text, PropertyEditor keyEditor, PropertyEditor valueEditor) {
        Properties properties = new Properties();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes());
            properties.load(stream);
        }
        catch (IOException e) {
            throw new PropertyEditorException(e);
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String keyText = (String)entry.getKey();
            String valueText = (String)entry.getValue();
            Object keyObject = CollectionUtil.componentToObject(keyText, keyEditor);
            Object valueObject = CollectionUtil.componentToObject(valueText, valueEditor);
            map.put(keyObject, valueObject);
        }
        return map;
    }

    public static final String toString(Map map, PropertyEditor keyEditor, PropertyEditor valueEditor) {
        Properties properties = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            Object keyObject = entry.getKey();
            Object valueObject = entry.getValue();
            String keyText = CollectionUtil.componentToString(keyObject, keyEditor);
            String valueText = CollectionUtil.componentToString(valueObject, valueEditor);
            properties.setProperty(keyText, valueText);
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            properties.store(out, null);
            String text = new String(out.toByteArray());
            return text;
        }
        catch (IOException e) {
            throw new PropertyEditorException(e);
        }
    }

    private static final String componentToString(Object value, PropertyEditor componentEditor) {
        if (value == null) {
            return null;
        }
        if (componentEditor instanceof Converter) {
            Converter converter = (Converter)componentEditor;
            Class type = converter.getType();
            if (!type.isInstance(value)) {
                throw new PropertyEditorException("Value is not an instance of " + type.getSimpleName() + ": " + value.getClass().getName());
            }
            return converter.toString(value);
        }
        componentEditor.setValue(value);
        String text = componentEditor.getAsText();
        return text;
    }

    private static final Object componentToObject(String text, PropertyEditor componentEditor) {
        if (text == null) {
            return null;
        }
        if (componentEditor instanceof Converter) {
            Converter converter = (Converter)componentEditor;
            Object value = converter.toObject(text.trim());
            return value;
        }
        componentEditor.setAsText(text);
        Object value = componentEditor.getValue();
        return value;
    }
}

