/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.util.namespace.AbstractNamespaceContext;

public final class LiveNamespaceContext
extends AbstractNamespaceContext {
    private final OMElement element;

    public LiveNamespaceContext(OMElement element) {
        this.element = element;
    }

    @Override
    protected String doGetNamespaceURI(String prefix) {
        OMNamespace ns = this.element.findNamespaceURI(prefix);
        return ns == null ? "" : ns.getNamespaceURI();
    }

    @Override
    protected String doGetPrefix(String namespaceURI) {
        OMNamespace ns = this.element.findNamespace(namespaceURI, null);
        return ns == null ? null : ns.getPrefix();
    }

    @Override
    protected Iterator<String> doGetPrefixes(String namespaceURI) {
        ArrayList<String> prefixes = new ArrayList<String>();
        Iterator<OMNamespace> it = this.element.getNamespacesInScope();
        while (it.hasNext()) {
            OMNamespace ns = it.next();
            if (!ns.getNamespaceURI().equals(namespaceURI)) continue;
            prefixes.add(ns.getPrefix());
        }
        return prefixes.iterator();
    }
}

