/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.ant;

import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.ant.CmBaseWriter;
import org.apache.woden.ant.CmExtensionsWriter;
import org.apache.woden.ant.CmHttpWriter;
import org.apache.woden.ant.CmRpcWriter;
import org.apache.woden.ant.CmSoapWriter;
import org.apache.woden.ant.NamespaceWriter;
import org.apache.woden.ant.XMLWriter;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.BindingFault;
import org.apache.woden.wsdl20.BindingFaultReference;
import org.apache.woden.wsdl20.BindingMessageReference;
import org.apache.woden.wsdl20.BindingOperation;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.ElementDeclaration;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.InterfaceFault;
import org.apache.woden.wsdl20.InterfaceFaultReference;
import org.apache.woden.wsdl20.InterfaceMessageReference;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.TypeDefinition;
import org.apache.woden.wsdl20.extensions.InterfaceOperationExtensions;
import org.apache.woden.wsdl20.extensions.WSDLExtensionConstants;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingFaultExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.extensions.http.HTTPEndpointExtensions;
import org.apache.woden.wsdl20.extensions.rpc.RPCConstants;
import org.apache.woden.wsdl20.extensions.rpc.RPCInterfaceOperationExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingFaultExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingFaultReferenceExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPConstants;
import org.apache.woden.wsdl20.extensions.soap.SOAPEndpointExtensions;

public class CmWriter
extends NamespaceWriter {
    public static String NS = "http://www.w3.org/2002/ws/desc/wsdl/component";
    public static String PREFIX = "";
    private static String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    private static String[] XSD_TYPES = new String[]{"string", "boolean", "decimal", "float", "double", "duration", "dateTime", "time", "date", "gYearMonth", "gYear", "gMonthDay", "gDay", "gMonth", "hexBinary", "base64Binary", "anyURI", "QName", "NOTATION", "normalizedString", "token", "language", "NMTOKEN", "NMTOKENS", "Name", "NCName", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "integer", "nonPositiveInteger", "negativeInteger", "long", "int", "short", "byte", "nonNegativeInteger", "unsignedLong", "unsignedInt", "unsignedShort", "unsignedByte", "positiveInteger"};
    private CmBaseWriter cmbase;
    private CmExtensionsWriter cmextensions;
    private CmRpcWriter cmrpc;
    private CmHttpWriter cmhttp;
    private CmSoapWriter cmsoap;

    public CmWriter(XMLWriter out) {
        super(out, NS, PREFIX);
        Arrays.sort(XSD_TYPES);
        this.cmbase = (CmBaseWriter)out.lookup("http://www.w3.org/2002/ws/desc/wsdl/component-base");
        this.cmextensions = (CmExtensionsWriter)out.lookup("http://www.w3.org/2002/ws/desc/wsdl/component-extensions");
        this.cmrpc = (CmRpcWriter)out.lookup("http://www.w3.org/2002/ws/desc/wsdl/component-rpc");
        this.cmhttp = (CmHttpWriter)out.lookup("http://www.w3.org/2002/ws/desc/wsdl/component-http");
        this.cmsoap = (CmSoapWriter)out.lookup("http://www.w3.org/2002/ws/desc/wsdl/component-soap");
    }

    public void write(Description component) {
        this.out.xmlDeclaration("UTF-8");
        String attributes = "xmlns='" + NS + "'\n";
        attributes = attributes + " xmlns:cmextensions='http://www.w3.org/2002/ws/desc/wsdl/component-extensions'\n";
        attributes = attributes + " xmlns:cmbase='http://www.w3.org/2002/ws/desc/wsdl/component-base'\n";
        attributes = attributes + " xmlns:cmhttp='http://www.w3.org/2002/ws/desc/wsdl/component-http'\n";
        attributes = attributes + " xmlns:cmrpc='http://www.w3.org/2002/ws/desc/wsdl/component-rpc'\n";
        attributes = attributes + " xmlns:cmsoap='http://www.w3.org/2002/ws/desc/wsdl/component-soap'\n";
        attributes = attributes + this.cmbase.idAttribute(component);
        this.out.beginElement("descriptionComponent", attributes);
        URI[] extensions = new URI[]{WSDLExtensionConstants.NS_URI_WSDL_EXTENSIONS, HTTPConstants.NS_URI_HTTP, RPCConstants.NS_URI_RPC, SOAPConstants.NS_URI_SOAP};
        this.cmbase.writeUris("extensions", extensions);
        this.write("interfaces", component.getInterfaces());
        this.write("bindings", component.getBindings());
        this.write("services", component.getServices());
        this.write("elementDeclarations", component.getElementDeclarations());
        this.write("typeDefinitions", component.getTypeDefinitions());
        this.out.endElement();
    }

    private void writeRefs(String tag, Interface[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                QName x1 = ((Interface)o1).getName();
                QName x2 = ((Interface)o2).getName();
                return CmBaseWriter.compareQName(x1, x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.cmbase.writeRef("interface", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, Interface[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                QName x1 = ((Interface)o1).getName();
                QName x2 = ((Interface)o2).getName();
                return CmBaseWriter.compareQName(x1, x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("interfaceComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, Interface component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.write("name", component.getName());
        this.writeRefs("extendedInterfaces", component.getExtendedInterfaces());
        this.write("interfaceFaults", component.getInterfaceFaults());
        this.write("interfaceOperations", component.getInterfaceOperations());
        this.out.endElement();
    }

    private void write(String tag, InterfaceFault[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                QName x1 = ((InterfaceFault)o1).getName();
                QName x2 = ((InterfaceFault)o2).getName();
                return CmBaseWriter.compareQName(x1, x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("interfaceFaultComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, InterfaceFault component) {
        this.out.beginElement("interfaceFaultComponent", this.cmbase.idAttribute(component));
        this.cmbase.write("name", component.getName());
        this.out.write("messageContentModel", component.getMessageContentModel());
        this.cmbase.writeOptionalRef("elementDeclaration", component.getElementDeclaration());
        this.cmbase.parent(component.getParent());
        this.out.endElement();
    }

    private void write(String tag, InterfaceOperation[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                QName x1 = ((InterfaceOperation)o1).getName();
                QName x2 = ((InterfaceOperation)o2).getName();
                return CmBaseWriter.compareQName(x1, x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("interfaceOperationComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, InterfaceOperation component) {
        this.out.beginElement("interfaceOperationComponent", this.cmbase.idAttribute(component));
        this.cmbase.write("name", component.getName());
        this.write("messageExchangePattern", component.getMessageExchangePattern());
        this.write("interfaceMessageReferences", component.getInterfaceMessageReferences());
        this.write("interfaceFaultReferences", component.getInterfaceFaultReferences());
        this.cmbase.writeUris("style", component.getStyle());
        this.cmbase.parent(component.getParent());
        InterfaceOperationExtensions extensions = (InterfaceOperationExtensions)component.getComponentExtensionContext(WSDLExtensionConstants.NS_URI_WSDL_EXTENSIONS);
        this.cmextensions.wsdlInterfaceOperationExtension(extensions);
        RPCInterfaceOperationExtensions rpcExtensions = (RPCInterfaceOperationExtensions)component.getComponentExtensionContext(RPCConstants.NS_URI_RPC);
        this.cmrpc.rpcInterfaceOperationExtension(rpcExtensions);
        this.out.endElement();
    }

    private void write(String tag, InterfaceMessageReference[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                String x1 = ((InterfaceMessageReference)o1).getMessageLabel().toString();
                String x2 = ((InterfaceMessageReference)o2).getMessageLabel().toString();
                return x1.compareTo(x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("interfaceMessageReferenceComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, InterfaceMessageReference component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.out.write("messageLabel", component.getMessageLabel().toString());
        this.out.write("direction", component.getDirection().toString());
        this.out.write("messageContentModel", component.getMessageContentModel());
        this.cmbase.writeOptionalRef("elementDeclaration", component.getElementDeclaration());
        this.cmbase.parent(component.getParent());
        this.out.endElement();
    }

    private void write(String tag, InterfaceFaultReference[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                QName q2;
                InterfaceFault if2;
                InterfaceFaultReference i1 = (InterfaceFaultReference)o1;
                InterfaceFaultReference i2 = (InterfaceFaultReference)o2;
                InterfaceFault if1 = i1.getInterfaceFault();
                if (if1 == (if2 = i2.getInterfaceFault())) {
                    return 0;
                }
                if (if1 == null) {
                    return -1;
                }
                if (if2 == null) {
                    return 1;
                }
                QName q1 = if1.getName();
                int result = CmBaseWriter.compareQName(q1, q2 = if2.getName());
                if (result != 0) {
                    return result;
                }
                String x1 = i1.getMessageLabel().toString();
                String x2 = i2.getMessageLabel().toString();
                return x1.compareTo(x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("interfaceFaultReferenceComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, InterfaceFaultReference component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.writeRef("interfaceFault", component.getInterfaceFault());
        this.out.write("messageLabel", component.getMessageLabel().toString());
        this.out.write("direction", component.getDirection().toString());
        this.cmbase.parent(component.getParent());
        this.out.endElement();
    }

    private void write(String tag, Binding[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                QName x1 = ((Binding)o1).getName();
                QName x2 = ((Binding)o2).getName();
                return CmBaseWriter.compareQName(x1, x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("bindingComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, Binding component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.write("name", component.getName());
        this.cmbase.writeOptionalRef("interface", component.getInterface());
        this.write("type", component.getType());
        this.write("bindingFaults", component.getBindingFaults());
        this.write("bindingOperations", component.getBindingOperations());
        HTTPBindingExtensions http = (HTTPBindingExtensions)component.getComponentExtensionContext(HTTPConstants.NS_URI_HTTP);
        this.cmhttp.httpBindingExtension(http);
        SOAPBindingExtensions soap = (SOAPBindingExtensions)component.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        this.cmsoap.soapBindingExtension(soap);
        this.out.endElement();
    }

    private void write(String tag, BindingFault[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                InterfaceFault if2;
                InterfaceFault if1 = ((BindingFault)o1).getInterfaceFault();
                if (if1 == (if2 = ((BindingFault)o2).getInterfaceFault())) {
                    return 0;
                }
                if (if1 == null) {
                    return -1;
                }
                if (if2 == null) {
                    return 1;
                }
                QName x1 = if1.getName();
                QName x2 = if2.getName();
                return CmBaseWriter.compareQName(x1, x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("bindingFaultComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, BindingFault component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.writeRef("interfaceFault", component.getInterfaceFault());
        this.cmbase.parent(component.getParent());
        HTTPBindingFaultExtensions http = (HTTPBindingFaultExtensions)component.getComponentExtensionContext(HTTPConstants.NS_URI_HTTP);
        this.cmhttp.httpBindingFaultExtension(http);
        SOAPBindingFaultExtensions soap = (SOAPBindingFaultExtensions)component.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        this.cmsoap.soapBindingFaultExtension(soap);
        this.out.endElement();
    }

    private void write(String tag, BindingOperation[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                QName x1 = ((BindingOperation)o1).getInterfaceOperation().getName();
                QName x2 = ((BindingOperation)o1).getInterfaceOperation().getName();
                return CmBaseWriter.compareQName(x1, x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("bindingOperationComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, BindingOperation component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.writeRef("interfaceOperation", component.getInterfaceOperation());
        this.write("bindingMessageReferences", component.getBindingMessageReferences());
        this.write("bindingFaultReferences", component.getBindingFaultReferences());
        this.cmbase.parent(component.getParent());
        HTTPBindingOperationExtensions http = (HTTPBindingOperationExtensions)component.getComponentExtensionContext(HTTPConstants.NS_URI_HTTP);
        this.cmhttp.httpBindingOperationExtension(http);
        SOAPBindingOperationExtensions soap = (SOAPBindingOperationExtensions)component.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        this.cmsoap.soapBindingOperationExtension(soap);
        this.out.endElement();
    }

    private void write(String tag, BindingMessageReference[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                InterfaceMessageReference i1 = ((BindingMessageReference)o1).getInterfaceMessageReference();
                InterfaceMessageReference i2 = ((BindingMessageReference)o2).getInterfaceMessageReference();
                String x1 = i1.getMessageLabel().toString();
                String x2 = i2.getMessageLabel().toString();
                return x1.compareTo(x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("bindingMessageReferenceComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, BindingMessageReference component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.writeRef("interfaceMessageReference", component.getInterfaceMessageReference());
        this.cmbase.parent(component.getParent());
        HTTPBindingMessageReferenceExtensions http = (HTTPBindingMessageReferenceExtensions)component.getComponentExtensionContext(HTTPConstants.NS_URI_HTTP);
        this.cmhttp.httpBindingMessageReferenceExtension(http);
        SOAPBindingMessageReferenceExtensions soap = (SOAPBindingMessageReferenceExtensions)component.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        this.cmsoap.soapBindingMessageReferenceExtension(soap);
        this.out.endElement();
    }

    private void write(String tag, BindingFaultReference[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                QName q2;
                InterfaceFaultReference i1 = ((BindingFaultReference)o1).getInterfaceFaultReference();
                InterfaceFaultReference i2 = ((BindingFaultReference)o2).getInterfaceFaultReference();
                QName q1 = i1.getInterfaceFault().getName();
                int result = CmBaseWriter.compareQName(q1, q2 = i2.getInterfaceFault().getName());
                if (result != 0) {
                    return result;
                }
                String x1 = i1.getMessageLabel().toString();
                String x2 = i2.getMessageLabel().toString();
                return x1.compareTo(x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("bindingFaultReferenceComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, BindingFaultReference component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.writeRef("interfaceFaultReference", component.getInterfaceFaultReference());
        this.cmbase.parent(component.getParent());
        SOAPBindingFaultReferenceExtensions soap = (SOAPBindingFaultReferenceExtensions)component.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        this.cmsoap.soapBindingFaultReferenceExtension(soap);
        this.out.endElement();
    }

    private void write(String tag, Service[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                QName x1 = ((Service)o1).getName();
                QName x2 = ((Service)o2).getName();
                return CmBaseWriter.compareQName(x1, x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("serviceComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, Service component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.write("name", component.getName());
        this.cmbase.writeRef("interface", component.getInterface());
        this.write("endpoints", component.getEndpoints());
        this.out.endElement();
    }

    private void write(String tag, Endpoint[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                String x1 = ((Endpoint)o1).getName().toString();
                String x2 = ((Endpoint)o2).getName().toString();
                return x1.compareTo(x2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("endpointComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, Endpoint component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.out.write("name", component.getName());
        this.cmbase.writeRef("binding", component.getBinding());
        this.cmbase.write("address", component.getAddress());
        this.cmbase.parent(component.getParent());
        HTTPEndpointExtensions http = (HTTPEndpointExtensions)component.getComponentExtensionContext(HTTPConstants.NS_URI_HTTP);
        this.cmhttp.httpEndpointExtension(http);
        SOAPEndpointExtensions soap = (SOAPEndpointExtensions)component.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        this.cmsoap.soapEndpointExtension(soap);
        this.out.endElement();
    }

    private void write(String tag, ElementDeclaration[] components) {
        int i;
        Vector<ElementDeclaration> filteredElements = new Vector<ElementDeclaration>();
        for (i = 0; i < components.length; ++i) {
            if (XSD_NS.equals(components[i].getName().getNamespaceURI())) continue;
            filteredElements.addElement(components[i]);
        }
        components = new ElementDeclaration[filteredElements.size()];
        filteredElements.copyInto(components);
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                QName x1 = ((ElementDeclaration)o1).getName();
                QName x2 = ((ElementDeclaration)o2).getName();
                return CmBaseWriter.compareQName(x1, x2);
            }
        });
        this.out.beginElement(tag);
        for (i = 0; i < components.length; ++i) {
            this.write("elementDeclarationComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, ElementDeclaration component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.write("name", component.getName());
        this.write("system", component.getSystem());
        this.out.endElement();
    }

    private void write(String tag, TypeDefinition[] components) {
        int i;
        Vector<TypeDefinition> filteredTypes = new Vector<TypeDefinition>();
        for (i = 0; i < components.length; ++i) {
            if (!XSD_NS.equals(components[i].getName().getNamespaceURI())) {
                filteredTypes.addElement(components[i]);
                continue;
            }
            if (Arrays.binarySearch(XSD_TYPES, components[i].getName().getLocalPart()) < 0) continue;
            filteredTypes.addElement(components[i]);
        }
        components = new TypeDefinition[filteredTypes.size()];
        filteredTypes.copyInto(components);
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                QName x1 = ((TypeDefinition)o1).getName();
                QName x2 = ((TypeDefinition)o2).getName();
                return CmBaseWriter.compareQName(x1, x2);
            }
        });
        this.out.beginElement(tag);
        for (i = 0; i < components.length; ++i) {
            this.write("typeDefinitionComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, TypeDefinition component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.cmbase.write("name", component.getName());
        this.write("system", component.getSystem());
        this.out.endElement();
    }
}

