/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.geometry.PolySweepMerge;
import com.sun.electric.technology.Layer;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeometryHandler {
    HashMap<Layer, Object> layers;
    public static final ShapeSort shapeSort = new ShapeSort();
    public static final AreaSort areaSort = new AreaSort();

    public static GeometryHandler createGeometryHandler(GHMode mode, int initialSize) {
        switch (mode) {
            case ALGO_MERGE: {
                return new PolyMerge();
            }
            case ALGO_SWEEP: {
                if (initialSize > 0) {
                    return new PolySweepMerge(initialSize);
                }
                return new PolySweepMerge();
            }
        }
        return null;
    }

    public GeometryHandler() {
        this.layers = new HashMap();
    }

    public GeometryHandler(int initialSize) {
        this.layers = new HashMap(initialSize);
    }

    public void add(Layer key, Object value) {
    }

    public void addAll(GeometryHandler subMerge, AffineTransform tTrans) {
    }

    public void subtract(Object key, Object element) {
        System.out.println("Error: subtract not implemented for GeometryHandler subclass " + this.getClass().getName());
    }

    public void subtractAll(HashMap<Layer, List<PolyBase>> map) {
        System.out.println("Error: subtractAll not implemented for GeometryHandler subclass " + this.getClass().getName());
    }

    public Set<Layer> getKeySet() {
        return this.layers.keySet();
    }

    public Collection<PolyBase> getObjects(Object layer, boolean modified, boolean simple) {
        System.out.println("Error: getObjects not implemented for GeometryHandler subclass " + this.getClass().getName());
        return null;
    }

    public Collection<PolyBase.PolyBaseTree> getTreeObjects(Object layer) {
        System.out.println("Error: getTreeObjects not implemented for GeometryHandler subclass " + this.getClass().getName());
        return null;
    }

    public void postProcess(boolean merge) {
        if (!merge) {
            System.out.println("Error: postProcess not implemented for GeometryHandler subclass " + this.getClass().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AreaSort
    implements Comparator<Area> {
        private AreaSort() {
        }

        @Override
        public int compare(Area a1, Area a2) {
            double bb2;
            double bb1 = a1.getBounds2D().getX();
            if (bb1 < (bb2 = a2.getBounds2D().getX())) {
                return -1;
            }
            if (bb1 > bb2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShapeSort
    implements Comparator<Shape> {
        private ShapeSort() {
        }

        @Override
        public int compare(Shape s1, Shape s2) {
            double bb2;
            double bb1 = s1.getBounds2D().getX();
            if (bb1 < (bb2 = s2.getBounds2D().getX())) {
                return -1;
            }
            if (bb1 > bb2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GHMode {
        ALGO_MERGE,
        ALGO_SWEEP;

    }
}

