/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DBMath
extends GenMath {
    public static final double GRID = 400.0;
    private static final double EPSILON = 0.0025;
    private static final double HALF_EPSILON = 0.00125;
    private static final double TINYDELTA = 0.002525;

    public static double getEpsilon() {
        return 0.0025;
    }

    public static boolean pointInRect(Point2D pt, Rectangle2D bounds) {
        if (pt.getX() < bounds.getMinX() - 0.002525) {
            return false;
        }
        if (pt.getX() > bounds.getMaxX() + 0.002525) {
            return false;
        }
        if (pt.getY() < bounds.getMinY() - 0.002525) {
            return false;
        }
        return !(pt.getY() > bounds.getMaxY() + 0.002525);
    }

    public static boolean pointInsideRect(Point2D pt, Rectangle2D bounds) {
        double ptX = pt.getX();
        double ptY = pt.getY();
        boolean newV = DBMath.isGreaterThan(ptX, bounds.getMinX()) && DBMath.isGreaterThan(bounds.getMaxX(), ptX) && DBMath.isGreaterThan(ptY, bounds.getMinY()) && DBMath.isGreaterThan(bounds.getMaxY(), ptY);
        return newV;
    }

    public static boolean areEquals(double a, double b) {
        return Math.abs(a - b) < 0.002525;
    }

    public static boolean isInBetween(double x, double a, double b) {
        if (DBMath.isGreaterThan(a, b)) {
            double c = a;
            a = b;
            b = c;
        }
        boolean tooSmall = DBMath.isGreaterThan(a, x);
        boolean tooBig = DBMath.isGreaterThan(x, b);
        return !tooSmall && !tooBig;
    }

    public static boolean isGreaterThan(double a, double b) {
        return a - b > 0.00125;
    }

    public static boolean isLessThan(double a, double b) {
        return b - a > 0.00125;
    }

    public static boolean isGreaterThanOrEqualTo(double a, double b) {
        return a - b > -0.00125;
    }

    public static boolean isLessThanOrEqualTo(double a, double b) {
        return b - a > -0.00125;
    }

    public static double round(double lambdaValue) {
        double x = lambdaValue * 400.0;
        long l = (long)(x >= 0.0 ? x + 0.49999999999999994 : x - 0.49999999999999994);
        return (double)l / 400.0;
    }

    public static long lambdaToGrid(double lambdaValue) {
        double x = lambdaValue * 400.0;
        return (long)(x >= 0.0 ? x + 0.49999999999999994 : x - 0.49999999999999994);
    }

    public static long lambdaToSizeGrid(double lambdaValue) {
        double x = lambdaValue * 200.0;
        long l = (long)(x >= 0.0 ? x + 0.49999999999999994 : x - 0.49999999999999994);
        return l << 1;
    }

    public static double gridToLambda(double gridValue) {
        return gridValue / 400.0;
    }

    public static double roundShapeCoord(double v) {
        double LARGE = 4.294967296E9;
        return v >= 0.0 ? v + LARGE - LARGE : v - LARGE + LARGE;
    }

    public static void gridAlign(Point2D pt, double alignment) {
        if (alignment <= 0.0) {
            return;
        }
        long x = Math.round(pt.getX() / alignment);
        long y = Math.round(pt.getY() / alignment);
        pt.setLocation((double)x * alignment, (double)y * alignment);
    }

    public static boolean areEquals(Point2D a, Point2D b) {
        return DBMath.areEquals(a.getX(), b.getX()) && DBMath.areEquals(a.getY(), b.getY());
    }

    public static boolean isOnLine(Point2D end1, Point2D end2, Point2D pt) {
        Point2D closestPointOnSegment = DBMath.closestPointToSegment(end1, end2, pt);
        return DBMath.areEquals(closestPointOnSegment, pt);
    }

    public static boolean hasRemainder(double a, double divisor) {
        double val = DBMath.round(a / divisor);
        return val % 1.0 != 0.0;
    }

    public static void transformRect(Rectangle2D bounds, AffineTransform xform) {
        if (xform.getType() == 0) {
            return;
        }
        Point2D[] corners = Poly.makePoints(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
        xform.transform(corners, 0, corners, 0, 4);
        double lX = corners[0].getX();
        double lY = corners[0].getY();
        double hX = lX;
        double hY = lY;
        for (int i = 1; i < 4; ++i) {
            if (corners[i].getX() < lX) {
                lX = corners[i].getX();
            }
            if (corners[i].getX() > hX) {
                hX = corners[i].getX();
            }
            if (corners[i].getY() < lY) {
                lY = corners[i].getY();
            }
            if (!(corners[i].getY() > hY)) continue;
            hY = corners[i].getY();
        }
        bounds.setRect(lX, lY, hX - lX, hY - lY);
    }

    public static boolean rectsIntersect(Rectangle2D r1, Rectangle2D r2) {
        if (r2.getMaxX() < r1.getMinX()) {
            return false;
        }
        if (r2.getMinX() > r1.getMaxX()) {
            return false;
        }
        if (r2.getMaxY() < r1.getMinY()) {
            return false;
        }
        return !(r2.getMinY() > r1.getMaxY());
    }
}

