/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.text.Pref;
import com.sun.electric.tool.user.projectSettings.ProjSettings;
import com.sun.electric.tool.user.projectSettings.ProjSettingsNode;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Setting {
    private static final HashMap<String, Setting> allSettingsByXmlPath = new HashMap();
    private static final HashMap<String, Setting> allSettingsByPrefPath = new HashMap();
    private static final ArrayList<Object> values = new ArrayList();
    private final String xmlPath;
    private final Object factoryObj;
    private final Preferences prefs;
    private final String prefName;
    private final String prefPath;
    private final int index;
    private boolean valid;
    private final String description;
    private final String location;
    private String[] trueMeaning;
    private static Comparator<Setting> SETTINGS_BY_PREF_NAME = new Comparator<Setting>(){

        @Override
        public int compare(Setting s1, Setting s2) {
            String n1 = s1.getPrefName();
            String n2 = s2.getPrefName();
            return n1.compareTo(n2);
        }
    };
    private static int i;

    public Setting(String prefName, Pref.Group group, ProjSettingsNode xmlNode, String xmlName, String location, String description, Object factoryObj) {
        EDatabase.serverDatabase().checkChanging();
        if (xmlNode == null) {
            throw new NullPointerException();
        }
        if (xmlName == null) {
            xmlName = prefName;
        }
        this.xmlPath = xmlNode.getPath() + xmlName;
        assert (!allSettingsByXmlPath.containsKey(this.xmlPath));
        this.factoryObj = factoryObj;
        this.prefName = prefName;
        this.prefs = group.prefs;
        this.prefPath = this.prefs.absolutePath() + "/" + prefName;
        assert (!allSettingsByPrefPath.containsKey(this.prefPath));
        this.index = values.size();
        values.add(factoryObj);
        allSettingsByXmlPath.put(this.xmlPath, this);
        allSettingsByPrefPath.put(this.prefPath, this);
        assert (allSettingsByXmlPath.size() == allSettingsByPrefPath.size());
        assert (allSettingsByXmlPath.size() == values.size());
        this.valid = true;
        this.description = description;
        this.location = location;
        this.setCachedObjFromPreferences();
        xmlNode.putValue(xmlName, this);
    }

    public boolean getBoolean() {
        return (Boolean)this.getValue();
    }

    public int getInt() {
        return (Integer)this.getValue();
    }

    public long getLong() {
        return (Long)this.getValue();
    }

    public double getDouble() {
        return (Double)this.getValue();
    }

    public String getString() {
        return (String)this.getValue();
    }

    public boolean getBoolean(List<Object> context) {
        return (Boolean)this.getValue(context);
    }

    public int getInt(List<Object> context) {
        return (Integer)this.getValue(context);
    }

    public long getLong(List<Object> context) {
        return (Long)this.getValue(context);
    }

    public double getDouble(List<Object> context) {
        return (Double)this.getValue(context);
    }

    public String getString(List<Object> context) {
        return (String)this.getValue(context);
    }

    public void set(Object v) {
        EDatabase.serverDatabase().checkChanging();
        if (this.getValue().equals(v)) {
            return;
        }
        if (v.getClass() != this.factoryObj.getClass()) {
            throw new ClassCastException();
        }
        values.set(this.index, this.factoryObj.equals(v) ? this.factoryObj : v);
        this.saveToPreferences(v);
        this.setSideEffect();
    }

    public void set(List<Object> context, Object v) {
        if (this.getValue(context).equals(v)) {
            return;
        }
        if (v.getClass() != this.factoryObj.getClass()) {
            throw new ClassCastException();
        }
        context.set(this.index, this.factoryObj.equals(v) ? this.factoryObj : v);
    }

    protected void setSideEffect() {
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public String getPrefName() {
        return this.prefName;
    }

    public Object getValue() {
        return values.get(this.index);
    }

    public Object getValue(List<Object> context) {
        return context.get(this.index);
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public void setValidOption(boolean valid) {
        this.valid = valid;
    }

    public boolean isValidOption() {
        return this.valid;
    }

    public void setTrueMeaning(String[] trueMeaning) {
        this.trueMeaning = trueMeaning;
    }

    public String[] getTrueMeaning() {
        return this.trueMeaning;
    }

    public Object getFactoryValue() {
        return this.factoryObj;
    }

    public double getDoubleFactoryValue() {
        return (Double)this.factoryObj;
    }

    public static Setting makeBooleanSetting(String name, Pref.Group group, ProjSettingsNode xmlNode, String xmlName, String location, String description, boolean factory) {
        Setting setting = Setting.getSetting(xmlNode.getPath() + xmlName);
        if (setting != null) {
            return setting;
        }
        return new Setting(name, group, xmlNode, xmlName, location, description, factory);
    }

    public static Setting makeIntSetting(String name, Pref.Group group, ProjSettingsNode xmlNode, String xmlName, String location, String description, int factory) {
        Setting setting = Setting.getSetting(xmlNode.getPath() + xmlName);
        if (setting != null) {
            return setting;
        }
        return new Setting(name, group, xmlNode, xmlName, location, description, factory);
    }

    public static Setting makeLongSetting(String name, Pref.Group group, ProjSettingsNode xmlNode, String xmlName, String location, String description, long factory) {
        Setting setting = Setting.getSetting(xmlNode.getPath() + xmlName);
        if (setting != null) {
            return setting;
        }
        return new Setting(name, group, xmlNode, xmlName, location, description, factory);
    }

    public static Setting makeDoubleSetting(String name, Pref.Group group, ProjSettingsNode xmlNode, String xmlName, String location, String description, double factory) {
        Setting setting = Setting.getSetting(xmlNode.getPath() + xmlName);
        if (setting != null) {
            return setting;
        }
        return new Setting(name, group, xmlNode, xmlName, location, description, factory);
    }

    public static Setting makeStringSetting(String name, Pref.Group group, ProjSettingsNode xmlNode, String xmlName, String location, String description, String factory) {
        Setting setting = Setting.getSetting(xmlNode.getPath() + xmlName);
        if (setting != null) {
            return setting;
        }
        return new Setting(name, group, xmlNode, xmlName, location, description, factory);
    }

    public static Setting getSetting(String xmlPath) {
        return allSettingsByXmlPath.get(xmlPath);
    }

    public static Setting getSettingByPrefPath(String prefPath) {
        return allSettingsByPrefPath.get(prefPath);
    }

    public static List<Setting> getSettings(ProjSettingsNode node) {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        Setting.getSettings(node, settings);
        Collections.sort(settings, SETTINGS_BY_PREF_NAME);
        return settings;
    }

    private static void getSettings(ProjSettingsNode node, ArrayList<Setting> settings) {
        Set<String> keys = node.getKeys();
        for (String key : keys) {
            Setting setting = node.getValue(key);
            if (setting != null) {
                if (!setting.isValidOption() || setting.getValue().equals(setting.getFactoryValue())) continue;
                settings.add(setting);
                continue;
            }
            ProjSettingsNode subNode = node.getNode(key);
            if (subNode == null) continue;
            Setting.getSettings(subNode, settings);
        }
    }

    public static Map<Setting, Object> reconcileSettings(Map<Setting, Object> projectSettings) {
        HashSet<Setting> markedSettings = new HashSet<Setting>();
        HashMap<Setting, Object> settingsToReconcile = new HashMap<Setting, Object>();
        for (Map.Entry<Setting, Object> e : projectSettings.entrySet()) {
            Setting setting = e.getKey();
            Object value = e.getValue();
            markedSettings.add(setting);
            if (DBMath.objectsReallyEqual(value, setting.getValue()) || !setting.isValidOption()) continue;
            settingsToReconcile.put(setting, value);
        }
        for (Setting setting : allSettingsByXmlPath.values()) {
            if (markedSettings.contains(setting) || DBMath.objectsReallyEqual(setting.getValue(), setting.getFactoryValue()) || !setting.isValidOption()) continue;
            settingsToReconcile.put(setting, null);
        }
        return settingsToReconcile;
    }

    public static void finishSettingReconcilation(Map<Setting, Object> settingsToReconcile) {
        Pref.delayPrefFlushing();
        for (Map.Entry<Setting, Object> e : settingsToReconcile.entrySet()) {
            Setting setting = e.getKey();
            Object obj = e.getValue();
            if (obj == null) {
                obj = setting.factoryObj;
            }
            if (obj.getClass() != setting.factoryObj.getClass()) {
                if (obj instanceof Integer && setting.factoryObj instanceof Boolean) {
                    obj = (Integer)obj != 0;
                } else {
                    if (!(obj instanceof Float) || !(setting.factoryObj instanceof Double)) continue;
                    obj = ((Float)obj).doubleValue();
                }
            }
            setting.set(obj);
            System.out.println("Project Setting " + setting.xmlPath + " changed to " + obj);
        }
        Pref.resumePrefFlushing();
    }

    static void saveAllSettingsToPreferences() {
        for (Setting setting : allSettingsByXmlPath.values()) {
            Object value = setting.getValue();
            setting.saveToPreferences(value);
        }
    }

    private void saveToPreferences(Object v) {
        assert (v.getClass() == this.factoryObj.getClass());
        if (v.equals(this.factoryObj)) {
            this.prefs.remove(this.prefName);
            return;
        }
        if (v instanceof Boolean) {
            this.prefs.putBoolean(this.prefName, (Boolean)v);
        } else if (v instanceof Integer) {
            this.prefs.putInt(this.prefName, (Integer)v);
        } else if (v instanceof Long) {
            this.prefs.putLong(this.prefName, (Long)v);
        } else if (v instanceof Double) {
            this.prefs.putDouble(this.prefName, (Double)v);
        } else if (v instanceof String) {
            this.prefs.put(this.prefName, (String)v);
        } else assert (false);
    }

    private void setCachedObjFromPreferences() {
        Object cachedObj = null;
        if (this.factoryObj instanceof Boolean) {
            cachedObj = this.prefs.getBoolean(this.prefName, (Boolean)this.factoryObj);
        } else if (this.factoryObj instanceof Integer) {
            cachedObj = this.prefs.getInt(this.prefName, (Integer)this.factoryObj);
        } else if (this.factoryObj instanceof Long) {
            cachedObj = this.prefs.getLong(this.prefName, (Long)this.factoryObj);
        } else if (this.factoryObj instanceof Double) {
            cachedObj = this.prefs.getDouble(this.prefName, (Double)this.factoryObj);
        } else if (this.factoryObj instanceof String) {
            cachedObj = this.prefs.get(this.prefName, (String)this.factoryObj);
        }
        assert (cachedObj != null);
        values.set(this.index, cachedObj);
    }

    public static void implementSettingChanges(SettingChangeBatch batch) {
        for (Map.Entry<String, Object> e : batch.changesForSettings.entrySet()) {
            String xmlPath = e.getKey();
            Object newValue = e.getValue();
            Setting setting = Setting.getSetting(xmlPath);
            setting.set(newValue);
        }
    }

    public static List<Object> getContext() {
        return new ArrayList<Object>(values);
    }

    public static List<Object> resetContext() {
        ArrayList<Object> savedContext = new ArrayList<Object>(values);
        for (Setting setting : allSettingsByXmlPath.values()) {
            setting.set(setting.getFactoryValue());
        }
        return savedContext;
    }

    public static void restoreContext(List<Object> savedContext) {
        for (Setting setting : allSettingsByXmlPath.values()) {
            int index = setting.index;
            Object savedValue = index < savedContext.size() ? savedContext.get(index) : null;
            if (savedValue == null) continue;
            setting.set(savedValue);
        }
    }

    public static Collection<Setting> getSettings() {
        return allSettingsByXmlPath.values();
    }

    static void printAllSettings(PrintStream out) {
        TreeMap<String, Setting> sortedSettings = new TreeMap<String, Setting>();
        for (Setting setting : allSettingsByXmlPath.values()) {
            sortedSettings.put(setting.xmlPath, setting);
        }
        out.println("PROJECT SETTINGS");
        i = 0;
        Setting.printSettings(out, ProjSettings.getSettings(), 0);
    }

    private static void printSettings(PrintStream out, ProjSettingsNode node, int level) {
        Set<String> keys = node.getKeys();
        for (String key : keys) {
            out.print(i++ + "\t");
            for (int i = 0; i < level; ++i) {
                out.print("  ");
            }
            out.print(key);
            ProjSettingsNode subNode = node.getNode(key);
            if (subNode != null) {
                out.println(".");
                Setting.printSettings(out, subNode, level + 1);
                continue;
            }
            Setting setting = node.getValue(key);
            out.println(" " + setting.prefName + " " + setting.getValue());
        }
    }

    public static class SettingChangeBatch
    implements Serializable {
        public HashMap<String, Object> changesForSettings = new HashMap();

        public void add(Setting setting, Object newValue) {
            this.changesForSettings.put(setting.xmlPath, newValue);
        }
    }
}

