/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.xml;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml807 {
    private static final HashMap<String, XmlKeyword> xmlKeywords = new HashMap();
    private static Schema schema;
    public static DistanceContext EMPTY_CONTEXT;

    private Xml807() {
    }

    private static synchronized void loadTechnologySchema() throws SAXException {
        if (schema != null) {
            return;
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL technologySchemaUrl = Technology.class.getResource("xml/Technology807.xsd");
        if (technologySchemaUrl != null) {
            schema = schemaFactory.newSchema(technologySchemaUrl);
        } else {
            System.err.println("Schema file Technology807.xsd, working without XML schema");
            System.out.println("Schema file Technology807.xsd, working without XML schema");
        }
    }

    public static Technology parseTechnology(URL fileURL) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            if (schema == null) {
                Xml807.loadTechnologySchema();
            }
            factory.setSchema(schema);
            long startTime = System.currentTimeMillis();
            SAXParser parser = factory.newSAXParser();
            URLConnection urlCon = fileURL.openConnection();
            InputStream inputStream = urlCon.getInputStream();
            XMLReader handler = new XMLReader();
            parser.parse(inputStream, (DefaultHandler)handler);
            if (Job.getDebug()) {
                long stopTime = System.currentTimeMillis();
                System.out.println("Loading technology " + fileURL + " ... " + (stopTime - startTime) + " msec");
            }
            return handler.tech;
        }
        catch (SAXParseException e) {
            String msg = "Error parsing Xml technology:\n" + e.getMessage() + "\n" + " Line " + e.getLineNumber() + " column " + e.getColumnNumber() + " of " + fileURL;
            msg = msg.replaceAll("\"http://electric.sun.com/Technology\":", "");
            System.out.println(msg);
            Job.getUserInterface().showErrorMessage(msg, "Error parsing Xml technology");
        }
        catch (Exception e) {
            String msg = "Error loading Xml technology " + fileURL + " :\n" + e.getMessage() + "\n";
            System.out.println(msg);
            Job.getUserInterface().showErrorMessage(msg, "Error loading Xml technology");
        }
        return null;
    }

    public static MenuPalette parseComponentMenuXMLTechEdit(String xml, List<PrimitiveNode> nodes, List<ArcProto> arcs) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            SAXParser parser = factory.newSAXParser();
            InputSource is = new InputSource(new StringReader(xml));
            XMLReader handler = new XMLReader(nodes, arcs);
            parser.parse(is, (DefaultHandler)handler);
            return ((XMLReader)handler).tech.menuPalette;
        }
        catch (Exception e) {
            System.out.println("Error parsing XML component menu data");
            e.printStackTrace();
            return null;
        }
    }

    static {
        for (XmlKeyword k : (XmlKeyword[])XmlKeyword.class.getEnumConstants()) {
            xmlKeywords.put(k.name(), k);
        }
        schema = null;
        EMPTY_CONTEXT = new DistanceContext(){

            public double getRule(String ruleName) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class OneLineWriter
    extends Writer {
        private OneLineWriter(PrintWriter out) {
            super(out);
        }

        protected void p(String s) {
            for (int i = 0; i < s.length(); ++i) {
                this.out.print(s.charAt(i));
            }
        }

        protected void checkIndent() {
            this.indentEmitted = true;
        }

        protected void l() {
            this.indentEmitted = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Writer {
        private static final int INDENT_WIDTH = 4;
        protected final PrintWriter out;
        private int indent;
        protected boolean indentEmitted;

        private Writer(PrintWriter out) {
            this.out = out;
        }

        private void writeTechnology(Technology t) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            this.header();
            this.pl("");
            this.out.println("<!--");
            this.pl(" *");
            this.pl(" * Electric(tm) VLSI Design System");
            this.pl(" *");
            this.pl(" * File: " + t.techName + ".xml");
            this.pl(" * " + t.techName + " technology description");
            this.pl(" * Generated automatically from a library");
            this.pl(" *");
            this.pl(" * Copyright (c) " + cal.get(1) + " Sun Microsystems and Static Free Software");
            this.pl(" *");
            this.pl(" * Electric(tm) is free software; you can redistribute it and/or modify");
            this.pl(" * it under the terms of the GNU General Public License as published by");
            this.pl(" * the Free Software Foundation; either version 3 of the License, or");
            this.pl(" * (at your option) any later version.");
            this.pl(" *");
            this.pl(" * Electric(tm) is distributed in the hope that it will be useful,");
            this.pl(" * but WITHOUT ANY WARRANTY; without even the implied warranty of");
            this.pl(" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
            this.pl(" * GNU General Public License for more details.");
            this.pl(" *");
            this.pl(" * You should have received a copy of the GNU General Public License");
            this.pl(" * along with Electric(tm); see the file COPYING.  If not, write to");
            this.pl(" * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,");
            this.pl(" * Boston, Mass 02111-1307, USA.");
            this.pl(" */");
            this.out.println("-->");
            this.l();
            this.b(XmlKeyword.technology);
            this.a("name", t.techName);
            this.a("class", t.className);
            this.l();
            this.a("xmlns", "http://electric.sun.com/Technology");
            this.l();
            this.a("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.l();
            this.a("xsi:schemaLocation", "http://electric.sun.com/Technology ../../technology/xml/Technology807.xsd");
            this.cl();
            this.l();
            this.bcpel(XmlKeyword.shortName, t.shortTechName);
            this.bcpel(XmlKeyword.description, t.description);
            this.b(XmlKeyword.numMetals);
            this.a("min", t.minNumMetals);
            this.a("max", t.maxNumMetals);
            this.a("default", t.defaultNumMetals);
            this.el();
            this.b(XmlKeyword.scale);
            this.a("value", t.scaleValue);
            this.a("relevant", t.scaleRelevant);
            this.el();
            this.b(XmlKeyword.defaultFoundry);
            this.a("value", t.defaultFoundry);
            this.el();
            this.b(XmlKeyword.minResistance);
            this.a("value", t.minResistance);
            this.el();
            this.b(XmlKeyword.minCapacitance);
            this.a("value", t.minCapacitance);
            this.el();
            this.l();
            this.comment("**************************************** LAYERS ****************************************");
            for (Layer li : t.layers.values()) {
                this.writeXml(li);
            }
            this.comment("******************** ARCS ********************");
            for (ArcProto ai : t.arcs) {
                this.writeXml(ai);
                this.l();
            }
            this.comment("******************** NODES ********************");
            for (PrimitiveNode ni : t.nodes) {
                this.writeXml(ni);
                this.l();
            }
            for (SpiceHeader spiceHeader : t.spiceHeaders) {
                this.writeSpiceHeaderXml(spiceHeader);
            }
            for (DisplayStyle displayStyle : t.displayStyles) {
                this.writeDisplayStyleXml(displayStyle);
            }
            this.writeMenuPaletteXml(t.menuPalette);
            for (RuleSet ruleSet : t.ruleSets.values()) {
                this.writeXml(ruleSet);
            }
            for (Foundry foundry : t.foundries) {
                this.writeFoundryXml(foundry);
            }
            this.el(XmlKeyword.technology);
        }

        private void writeXml(Layer li) {
            String funString = null;
            int funExtra = li.extraFunction;
            if (funExtra != 0) {
                int deplEnhMask = 768;
                if ((funExtra & 0x300) != 0) {
                    funString = Layer.Function.getExtraName(funExtra & 0x300);
                    if ((funExtra &= 0xFFFFFCFF) != 0) {
                        funString = funString + "_" + Layer.Function.getExtraName(funExtra);
                    }
                } else {
                    funString = Layer.Function.getExtraName(funExtra);
                }
            }
            this.b(XmlKeyword.layer);
            this.a("name", li.name);
            this.a("fun", li.function.name());
            this.a("extraFun", funString);
            this.cl();
            if (li.cif != null && li.cif.length() > 0) {
                this.b(XmlKeyword.cifLayer);
                this.a("cif", li.cif);
                this.el();
            }
            if (li.skill != null && li.skill.length() > 0) {
                this.b(XmlKeyword.skillLayer);
                this.a("skill", li.skill);
                this.el();
            }
            if (li.resistance != 0.0 || li.capacitance != 0.0 || li.edgeCapacitance != 0.0) {
                this.b(XmlKeyword.parasitics);
                this.a("resistance", li.resistance);
                this.a("capacitance", li.capacitance);
                this.a("edgeCapacitance", li.edgeCapacitance);
                this.el();
            }
            if (li.pureLayerNode != null) {
                String nodeName = li.pureLayerNode.name;
                Poly.Type style = li.pureLayerNode.style;
                String styleStr = style == Poly.Type.FILLED ? null : style.name();
                String portName = li.pureLayerNode.port;
                this.b(XmlKeyword.pureLayerNode);
                this.a("name", nodeName);
                this.a("style", styleStr);
                this.a("port", portName);
                if (li.pureLayerNode.oldName == null && li.pureLayerNode.portArcs.isEmpty()) {
                    this.el();
                } else {
                    this.cl();
                    this.bcpel(XmlKeyword.oldName, li.pureLayerNode.oldName);
                    for (String portArc : li.pureLayerNode.portArcs) {
                        this.bcpel(XmlKeyword.portArc, portArc);
                    }
                    this.el(XmlKeyword.pureLayerNode);
                }
            }
            this.el(XmlKeyword.layer);
            this.l();
        }

        private void writeXml(ArcProto ai) {
            this.b(XmlKeyword.arcProto);
            this.a("name", ai.name);
            this.a("fun", ai.function.getConstantName());
            this.cl();
            this.bcpel(XmlKeyword.oldName, ai.oldName);
            if (ai.wipable) {
                this.bel(XmlKeyword.wipable);
            }
            if (ai.curvable) {
                this.bel(XmlKeyword.curvable);
            }
            if (ai.special) {
                this.bel(XmlKeyword.special);
            }
            if (ai.notUsed) {
                this.bel(XmlKeyword.notUsed);
            }
            if (ai.skipSizeInPalette) {
                this.bel(XmlKeyword.skipSizeInPalette);
            }
            this.bcpel(XmlKeyword.extended, ai.extended);
            this.bcpel(XmlKeyword.fixedAngle, ai.fixedAngle);
            this.bcpel(XmlKeyword.angleIncrement, ai.angleIncrement);
            if (ai.antennaRatio != 0.0) {
                this.bcpel(XmlKeyword.antennaRatio, ai.antennaRatio);
            }
            if (ai.elibWidthOffset != 0.0) {
                this.bcpel(XmlKeyword.elibWidthOffset, ai.elibWidthOffset);
            }
            for (ArcLayer al : ai.arcLayers) {
                String style = al.style == Poly.Type.FILLED ? "FILLED" : "CLOSED";
                this.b(XmlKeyword.arcLayer);
                this.a("layer", al.layer);
                this.a("style", style);
                if (al.extend.isEmpty()) {
                    this.el();
                    continue;
                }
                this.cl();
                this.writeDistance(al.extend);
                this.el(XmlKeyword.arcLayer);
            }
            if (ai.arcPin != null) {
                this.b(XmlKeyword.arcPin);
                this.a("name", ai.arcPin.name);
                this.a("port", ai.arcPin.portName);
                this.a("elibSize", ai.arcPin.elibSize);
                if (ai.arcPin.portArcs.isEmpty()) {
                    this.el();
                } else {
                    this.cl();
                    for (String portArc : ai.arcPin.portArcs) {
                        this.bcpel(XmlKeyword.portArc, portArc);
                    }
                    this.el(XmlKeyword.arcPin);
                }
            }
            this.el(XmlKeyword.arcProto);
        }

        private void writeXml(PrimitiveNode ni) {
            int j;
            this.b(XmlKeyword.primitiveNode);
            this.a("name", ni.name);
            this.a("fun", ni.function.name());
            this.cl();
            this.bcpel(XmlKeyword.oldName, ni.oldName);
            if (ni.shrinkArcs) {
                this.bel(XmlKeyword.shrinkArcs);
            }
            if (ni.square) {
                this.bel(XmlKeyword.square);
            }
            if (ni.canBeZeroSize) {
                this.bel(XmlKeyword.canBeZeroSize);
            }
            if (ni.wipes) {
                this.bel(XmlKeyword.wipes);
            }
            if (ni.lockable) {
                this.bel(XmlKeyword.lockable);
            }
            if (ni.edgeSelect) {
                this.bel(XmlKeyword.edgeSelect);
            }
            if (ni.skipSizeInPalette) {
                this.bel(XmlKeyword.skipSizeInPalette);
            }
            if (ni.notUsed) {
                this.bel(XmlKeyword.notUsed);
            }
            if (ni.lowVt) {
                this.bel(XmlKeyword.lowVt);
            }
            if (ni.highVt) {
                this.bel(XmlKeyword.highVt);
            }
            if (ni.nativeBit) {
                this.bel(XmlKeyword.nativeBit);
            }
            if (ni.od18) {
                this.bel(XmlKeyword.od18);
            }
            if (ni.od25) {
                this.bel(XmlKeyword.od25);
            }
            if (ni.od33) {
                this.bel(XmlKeyword.od33);
            }
            if (ni.diskOffset != null) {
                this.b(XmlKeyword.diskOffset);
                this.a("x", ni.diskOffset.getLambdaX());
                this.a("y", ni.diskOffset.getLambdaY());
                this.el();
            }
            if (!ni.defaultWidth.isEmpty()) {
                this.bcl(XmlKeyword.defaultWidth);
                this.writeDistance(ni.defaultWidth);
                this.el(XmlKeyword.defaultWidth);
            }
            if (!ni.defaultHeight.isEmpty()) {
                this.bcl(XmlKeyword.defaultHeight);
                this.writeDistance(ni.defaultHeight);
                this.el(XmlKeyword.defaultHeight);
            }
            if (ni.nodeBase != null) {
                double lx = ni.nodeBase.getLambdaMinX();
                double hx = ni.nodeBase.getLambdaMaxX();
                double ly = ni.nodeBase.getLambdaMinY();
                double hy = ni.nodeBase.getLambdaMaxY();
                this.b(XmlKeyword.nodeBase);
                this.a("lx", lx);
                this.a("hx", hx);
                this.a("ly", ly);
                this.a("hy", hy);
                this.el();
            }
            for (j = 0; j < ni.nodeLayers.size(); ++j) {
                NodeLayer nl = ni.nodeLayers.get(j);
                this.b(XmlKeyword.nodeLayer);
                this.a("layer", nl.layer);
                this.a("style", nl.style.name());
                if (nl.portNum != 0) {
                    this.a("portNum", nl.portNum);
                }
                if (!nl.inLayers || !nl.inElectricalLayers) {
                    this.a("electrical", nl.inElectricalLayers);
                }
                this.cl();
                switch (nl.representation) {
                    case 1: {
                        if (ni.specialType == 1) {
                            this.writeBox(XmlKeyword.serpbox, nl.lx, nl.hx, nl.ly, nl.hy);
                            this.a("lWidth", nl.lWidth);
                            this.a("rWidth", nl.rWidth);
                            this.a("tExtent", nl.tExtent);
                            this.a("bExtent", nl.bExtent);
                            this.cl();
                            this.writeLambdaBox(nl.lx, nl.hx, nl.ly, nl.hy);
                            this.el(XmlKeyword.serpbox);
                            break;
                        }
                        this.writeBox(XmlKeyword.box, nl.lx, nl.hx, nl.ly, nl.hy);
                        this.cl();
                        this.writeLambdaBox(nl.lx, nl.hx, nl.ly, nl.hy);
                        this.el(XmlKeyword.box);
                        break;
                    }
                    case 0: {
                        this.b(XmlKeyword.points);
                        this.el();
                        break;
                    }
                    case 3: {
                        this.writeBox(XmlKeyword.multicutbox, nl.lx, nl.hx, nl.ly, nl.hy);
                        this.a("sizeRule", nl.sizeRule);
                        this.a("sepRule", nl.sepRule);
                        this.a("sepRule2D", nl.sepRule2D);
                        if (nl.lx.isEmpty() && nl.hx.isEmpty() && nl.ly.isEmpty() && nl.hy.isEmpty()) {
                            this.el();
                            break;
                        }
                        this.cl();
                        this.writeLambdaBox(nl.lx, nl.hx, nl.ly, nl.hy);
                        this.el(XmlKeyword.multicutbox);
                    }
                }
                for (Technology.TechPoint tp : nl.techPoints) {
                    double xm = tp.getX().getMultiplier();
                    double xa = tp.getX().getAdder();
                    double ym = tp.getY().getMultiplier();
                    double ya = tp.getY().getAdder();
                    this.b(XmlKeyword.techPoint);
                    this.a("xm", xm);
                    this.a("xa", xa);
                    this.a("ym", ym);
                    this.a("ya", ya);
                    this.el();
                }
                this.el(XmlKeyword.nodeLayer);
            }
            for (j = 0; j < ni.ports.size(); ++j) {
                PrimitivePort pd = ni.ports.get(j);
                this.b(XmlKeyword.primitivePort);
                this.a("name", pd.name);
                this.cl();
                this.b(XmlKeyword.portAngle);
                this.a("primary", pd.portAngle);
                this.a("range", pd.portRange);
                this.el();
                this.bcpel(XmlKeyword.portTopology, pd.portTopology);
                this.writeBox(XmlKeyword.box, pd.lx, pd.hx, pd.ly, pd.hy);
                this.cl();
                this.writeLambdaBox(pd.lx, pd.hx, pd.ly, pd.hy);
                this.el(XmlKeyword.box);
                for (String portArc : pd.portArcs) {
                    this.bcpel(XmlKeyword.portArc, portArc);
                }
                this.el(XmlKeyword.primitivePort);
            }
            switch (ni.specialType) {
                case 2: {
                    this.bel(XmlKeyword.polygonal);
                    break;
                }
                case 1: {
                    this.b(XmlKeyword.serpTrans);
                    this.cl();
                    for (int i = 0; i < 6; ++i) {
                        this.bcpel(XmlKeyword.specialValue, ni.specialValues[i]);
                    }
                    this.el(XmlKeyword.serpTrans);
                }
            }
            if (ni.nodeSizeRule != null) {
                NodeSizeRule r = ni.nodeSizeRule;
                this.b(XmlKeyword.minSizeRule);
                this.a("width", r.width);
                this.a("height", r.height);
                this.a("rule", r.rule);
                this.el();
            }
            if (ni.spiceTemplate != null) {
                this.b(XmlKeyword.spiceTemplate);
                this.a("value", ni.spiceTemplate);
                this.el();
            }
            this.el(XmlKeyword.primitiveNode);
        }

        private void writeDistance(Distance d) {
            d.writeXml(this, true);
        }

        private void writeBox(XmlKeyword keyword, Distance lx, Distance hx, Distance ly, Distance hy) {
            this.b(keyword);
            if (lx.k != -1.0) {
                this.a("klx", lx.k);
            }
            if (hx.k != 1.0) {
                this.a("khx", hx.k);
            }
            if (ly.k != -1.0) {
                this.a("kly", ly.k);
            }
            if (hy.k != 1.0) {
                this.a("khy", hy.k);
            }
        }

        private void writeLambdaBox(Distance lx, Distance hx, Distance ly, Distance hy) {
            double lxv = lx.getLambda(EMPTY_CONTEXT);
            double hxv = hx.getLambda(EMPTY_CONTEXT);
            double lyv = ly.getLambda(EMPTY_CONTEXT);
            double hyv = hy.getLambda(EMPTY_CONTEXT);
            this.b(XmlKeyword.lambdaBox);
            this.a("klx", lxv);
            this.a("khx", hxv);
            this.a("kly", lyv);
            this.a("khy", hyv);
            this.el();
        }

        private void writeSpiceHeaderXml(SpiceHeader spiceHeader) {
            this.b(XmlKeyword.spiceHeader);
            this.a("level", spiceHeader.level);
            this.cl();
            for (String line : spiceHeader.spiceLines) {
                this.b(XmlKeyword.spiceLine);
                this.a("line", line);
                this.el();
            }
            this.el(XmlKeyword.spiceHeader);
            this.l();
        }

        private void writeDisplayStyleXml(DisplayStyle displayStyle) {
            this.b(XmlKeyword.displayStyle);
            this.a("name", displayStyle.name);
            this.cl();
            if (displayStyle.transparentLayers.size() != 0) {
                this.comment("Transparent layers");
                for (int i = 0; i < displayStyle.transparentLayers.size(); ++i) {
                    Color color = displayStyle.transparentLayers.get(i);
                    this.b(XmlKeyword.transparentLayer);
                    this.a("transparent", i + 1);
                    this.cl();
                    this.bcpel(XmlKeyword.r, color.getRed());
                    this.bcpel(XmlKeyword.g, color.getGreen());
                    this.bcpel(XmlKeyword.b, color.getBlue());
                    this.el(XmlKeyword.transparentLayer);
                }
                this.l();
            }
            for (LayerDisplayStyle l : displayStyle.layerStyles.values()) {
                this.b(XmlKeyword.layer);
                this.a("name", l.layer.name);
                this.cl();
                EGraphics desc = l.desc;
                if (desc.getTransparentLayer() > 0) {
                    this.b(XmlKeyword.transparentColor);
                    this.a("transparent", desc.getTransparentLayer());
                    this.el();
                } else {
                    Color color = desc.getColor();
                    this.b(XmlKeyword.opaqueColor);
                    this.a("r", color.getRed());
                    this.a("g", color.getGreen());
                    this.a("b", color.getBlue());
                    this.el();
                }
                this.bcpel(XmlKeyword.patternedOnDisplay, desc.isPatternedOnDisplay());
                this.bcpel(XmlKeyword.patternedOnPrinter, desc.isPatternedOnPrinter());
                int[] pattern = desc.getPattern();
                for (int j = 0; j < 16; ++j) {
                    String p = "";
                    for (int k = 0; k < 16; ++k) {
                        p = p + ((pattern[j] & 1 << 15 - k) != 0 ? (char)'X' : ' ');
                    }
                    this.bcpel(XmlKeyword.pattern, p);
                }
                if (desc.getOutlined() != null) {
                    this.bcpel(XmlKeyword.outlined, desc.getOutlined().getConstName());
                }
                this.bcpel(XmlKeyword.opacity, desc.getOpacity());
                this.bcpel(XmlKeyword.foreground, desc.getForeground());
                if (l.mode3D != null) {
                    this.b(XmlKeyword.display3D);
                    this.a("mode", l.mode3D);
                    this.a("factor", l.factor3D);
                    this.el();
                }
                this.el(XmlKeyword.layer);
            }
            this.el(XmlKeyword.displayStyle);
            this.l();
        }

        public void writeMenuPaletteXml(MenuPalette menuPalette) {
            if (menuPalette == null) {
                return;
            }
            this.b(XmlKeyword.menuPalette);
            this.a("numColumns", menuPalette.numColumns);
            this.cl();
            for (int i = 0; i < menuPalette.menuBoxes.size(); ++i) {
                if (i % menuPalette.numColumns == 0) {
                    this.l();
                }
                this.writeMenuBoxXml(menuPalette.menuBoxes.get(i));
            }
            this.l();
            this.el(XmlKeyword.menuPalette);
            this.l();
        }

        private void writeMenuBoxXml(List<Object> list) {
            this.b(XmlKeyword.menuBox);
            if (list.size() == 0) {
                this.el();
                return;
            }
            this.cl();
            for (Object o : list) {
                if (o instanceof ArcProto) {
                    this.bcpel(XmlKeyword.menuArc, ((ArcProto)o).name);
                    continue;
                }
                if (o instanceof PrimitiveNode) {
                    this.bcpel(XmlKeyword.menuNode, ((PrimitiveNode)o).name);
                    continue;
                }
                if (o instanceof MenuCell) {
                    MenuCell cell = (MenuCell)o;
                    this.b(XmlKeyword.menuCell);
                    this.a("cellName", cell.cellName);
                    this.el();
                    continue;
                }
                if (o instanceof MenuNodeInst) {
                    MenuNodeInst ni = (MenuNodeInst)o;
                    this.b(XmlKeyword.menuNodeInst);
                    this.a("protoName", ni.protoName);
                    this.a("function", ni.function.name());
                    if (ni.rotation != 0) {
                        this.a("rotation", ni.rotation);
                    }
                    if (ni.text == null) {
                        this.el();
                        continue;
                    }
                    this.cl();
                    this.b(XmlKeyword.menuNodeText);
                    this.a("text", ni.text);
                    this.a("size", ni.fontSize);
                    this.el();
                    this.el(XmlKeyword.menuNodeInst);
                    continue;
                }
                if (o == null) {
                    this.bel(XmlKeyword.menuText);
                    continue;
                }
                this.bcpel(XmlKeyword.menuText, o);
            }
            this.el(XmlKeyword.menuBox);
        }

        private void writeXml(RuleSet ruleSet) {
            this.b(XmlKeyword.ruleSet);
            this.a("name", ruleSet.name);
            this.cl();
            for (Map.Entry<String, Map<Layer, Distance>> e : ruleSet.layerRules.entrySet()) {
                this.writeLayerRuleXml(e.getKey(), e.getValue());
            }
            this.el(XmlKeyword.ruleSet);
            this.l();
        }

        private void writeLayerRuleXml(String ruleName, Map<Layer, Distance> sizes) {
            if (sizes.isEmpty()) {
                return;
            }
            this.b(XmlKeyword.layerRule);
            this.a("ruleName", ruleName);
            this.cl();
            int maxNameLength = 0;
            for (Layer layer : sizes.keySet()) {
                maxNameLength = Math.max(maxNameLength, layer.name.length());
            }
            for (Map.Entry entry : sizes.entrySet()) {
                String layerName = ((Layer)entry.getKey()).name;
                Distance d = (Distance)entry.getValue();
                this.b(XmlKeyword.layer);
                this.a("name", layerName);
                this.c();
                this.s(maxNameLength - layerName.length());
                d.writeXml(this, false);
                this.el(XmlKeyword.layer);
            }
            this.el(XmlKeyword.layerRule);
        }

        private void writeFoundryXml(Foundry foundry) {
            this.b(XmlKeyword.Foundry);
            this.a("name", foundry.name);
            this.cl();
            this.l();
            for (Map.Entry<String, String> e : foundry.layerGds.entrySet()) {
                this.b(XmlKeyword.layerGds);
                this.a("layer", e.getKey());
                this.a("gds", e.getValue());
                this.el();
            }
            this.l();
            for (DRCTemplate rule : foundry.rules) {
                DRCTemplate.exportDRCRule(this.out, rule);
            }
            this.el(XmlKeyword.Foundry);
        }

        private void header() {
            this.checkIndent();
            this.out.print("<?xml");
            this.a("version", "1.0");
            this.a("encoding", "UTF-8");
            this.out.println("?>");
        }

        private void comment(String s) {
            this.checkIndent();
            this.out.print("<!-- ");
            this.p(s);
            this.out.print(" -->");
            this.l();
        }

        private void a(String name, Object value) {
            this.checkIndent();
            if (value == null) {
                return;
            }
            this.out.print(" " + name + "=\"");
            this.p(value.toString());
            this.out.print("\"");
        }

        private void bcpe(XmlKeyword key, Object v) {
            if (v == null) {
                return;
            }
            this.b(key);
            this.c();
            this.p(v.toString());
            this.e(key);
        }

        private void bcpel(XmlKeyword key, Object v) {
            if (v == null) {
                return;
            }
            this.b(key);
            this.c();
            this.p(v.toString());
            this.el(key);
        }

        private void bcl(XmlKeyword key) {
            this.b(key);
            this.cl();
        }

        private void bel(XmlKeyword key) {
            this.b(key);
            this.el();
        }

        private void pl(String s) {
            this.checkIndent();
            this.p(s);
            this.l();
        }

        protected void p(String s) {
            assert (this.indentEmitted);
            block7: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '<': {
                        this.out.print("&lt;");
                        continue block7;
                    }
                    case '>': {
                        this.out.print("&gt;");
                        continue block7;
                    }
                    case '&': {
                        this.out.print("&amp;");
                        continue block7;
                    }
                    case '\'': {
                        this.out.print("&apos;");
                        continue block7;
                    }
                    case '\"': {
                        this.out.print("quot;");
                        continue block7;
                    }
                    default: {
                        this.out.print(c);
                    }
                }
            }
        }

        private void b(XmlKeyword key) {
            this.checkIndent();
            this.out.print('<');
            this.out.print(key.name());
            this.indent += 4;
        }

        private void cl() {
            assert (this.indentEmitted);
            this.out.print('>');
            this.l();
        }

        private void c() {
            assert (this.indentEmitted);
            this.out.print('>');
        }

        private void el() {
            this.e();
            this.l();
        }

        private void el(XmlKeyword key) {
            this.e(key);
            this.l();
        }

        private void e() {
            assert (this.indentEmitted);
            this.out.print("/>");
            this.indent -= 4;
        }

        private void e(XmlKeyword key) {
            this.indent -= 4;
            this.checkIndent();
            this.out.print("</");
            this.out.print(key.name());
            this.out.print(">");
        }

        protected void checkIndent() {
            if (this.indentEmitted) {
                return;
            }
            this.s(this.indent);
            this.indentEmitted = true;
        }

        protected void s(int numSpaces) {
            for (int i = 0; i < numSpaces; ++i) {
                this.out.print(' ');
            }
        }

        protected void l() {
            this.out.println();
            this.indentEmitted = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XMLReader
    extends DefaultHandler {
        private static boolean DEBUG = false;
        private Locator locator;
        private Technology tech = new Technology();
        private Layer curLayer;
        private ArcProto curArc;
        private PrimitiveNode curNode;
        private NodeLayer curNodeLayer;
        private PrimitivePort curPort;
        private int curSpecialValueIndex;
        private ArrayList<Object> curMenuBox;
        private MenuNodeInst curMenuNodeInst;
        private MenuCell curMenuCell;
        private Distance curDistance;
        private SpiceHeader curSpiceHeader;
        private DisplayStyle curDisplayStyle;
        private int curTransparent = 0;
        private int curR;
        private int curG;
        private int curB;
        private LayerDisplayStyle curLayerDisplayStyle;
        private boolean patternedOnDisplay;
        private boolean patternedOnPrinter;
        private final int[] pattern = new int[16];
        private int curPatternIndex;
        private EGraphics.Outline outline;
        private double opacity;
        private boolean foreground;
        private RuleSet curRuleSet;
        private Map<Layer, Distance> curLayerRule;
        private Foundry curFoundry;
        private boolean acceptCharacters;
        private StringBuilder charBuffer = new StringBuilder();
        private Attributes attributes;

        XMLReader() {
        }

        XMLReader(List<PrimitiveNode> nodes, List<ArcProto> arcs) {
            for (ArcProto xap : arcs) {
                this.tech.arcs.add(xap);
            }
            for (PrimitiveNode xnp : nodes) {
                this.tech.nodes.add(xnp);
            }
        }

        private void beginCharacters() {
            assert (!this.acceptCharacters);
            this.acceptCharacters = true;
            assert (this.charBuffer.length() == 0);
        }

        private String endCharacters() {
            assert (this.acceptCharacters);
            String s = this.charBuffer.toString();
            this.charBuffer.setLength(0);
            this.acceptCharacters = false;
            return s;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            return null;
        }

        @Override
        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private void printLocator() {
            System.out.println("publicId=" + this.locator.getPublicId() + " systemId=" + this.locator.getSystemId() + " line=" + this.locator.getLineNumber() + " column=" + this.locator.getColumnNumber());
        }

        @Override
        public void startDocument() throws SAXException {
            if (DEBUG) {
                System.out.println("startDocument");
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (DEBUG) {
                System.out.println("endDocument");
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (DEBUG) {
                System.out.println("startPrefixMapping prefix=" + prefix + " uri=" + uri);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            if (DEBUG) {
                System.out.println("endPrefixMapping prefix=" + prefix);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            boolean dump = false;
            XmlKeyword key = (XmlKeyword)((Object)xmlKeywords.get(localName));
            this.attributes = attributes;
            switch (key) {
                case technology: {
                    this.tech.techName = this.a("name");
                    this.tech.className = this.a_("class");
                    break;
                }
                case numMetals: {
                    this.tech.minNumMetals = Integer.parseInt(this.a("min"));
                    this.tech.maxNumMetals = Integer.parseInt(this.a("max"));
                    this.tech.defaultNumMetals = Integer.parseInt(this.a("default"));
                    break;
                }
                case scale: {
                    this.tech.scaleValue = Double.parseDouble(this.a("value"));
                    this.tech.scaleRelevant = Boolean.parseBoolean(this.a("relevant"));
                    break;
                }
                case defaultFoundry: {
                    this.tech.defaultFoundry = this.a("value");
                    break;
                }
                case minResistance: {
                    this.tech.minResistance = Double.parseDouble(this.a("value"));
                    break;
                }
                case minCapacitance: {
                    this.tech.minCapacitance = Double.parseDouble(this.a("value"));
                    break;
                }
                case layer: {
                    if (this.curDisplayStyle != null) {
                        this.curLayerDisplayStyle = this.curDisplayStyle.newLayer(this.tech.findLayer(this.a("name")));
                        this.curTransparent = 0;
                        this.curB = 0;
                        this.curG = 0;
                        this.curR = 0;
                        this.patternedOnDisplay = false;
                        this.patternedOnPrinter = false;
                        Arrays.fill(this.pattern, 0);
                        this.curPatternIndex = 0;
                        break;
                    }
                    if (this.curLayerRule != null) {
                        this.curDistance = new Distance();
                        Distance old = this.curLayerRule.put(this.tech.findLayer(this.a("name")), this.curDistance);
                        if (old != null) break;
                        throw new IllegalArgumentException("Duplicate layer " + this.a("name"));
                    }
                    this.curLayer = this.tech.newLayer(this.a("name"));
                    this.curLayer.function = Layer.Function.valueOf(this.a("fun"));
                    String extraFunStr = this.a_("extraFun");
                    if (extraFunStr == null) break;
                    if (extraFunStr.equals("depletion_heavy")) {
                        this.curLayer.extraFunction = 2304;
                        break;
                    }
                    if (extraFunStr.equals("depletion_light")) {
                        this.curLayer.extraFunction = 1280;
                        break;
                    }
                    if (extraFunStr.equals("enhancement_heavy")) {
                        this.curLayer.extraFunction = 2560;
                        break;
                    }
                    if (extraFunStr.equals("enhancement_light")) {
                        this.curLayer.extraFunction = 1536;
                        break;
                    }
                    this.curLayer.extraFunction = Layer.Function.parseExtraName(extraFunStr);
                    break;
                }
                case cifLayer: {
                    this.curLayer.cif = this.a("cif");
                    break;
                }
                case skillLayer: {
                    this.curLayer.skill = this.a("skill");
                    break;
                }
                case parasitics: {
                    this.curLayer.resistance = Double.parseDouble(this.a("resistance"));
                    this.curLayer.capacitance = Double.parseDouble(this.a("capacitance"));
                    this.curLayer.edgeCapacitance = Double.parseDouble(this.a("edgeCapacitance"));
                    break;
                }
                case pureLayerNode: {
                    this.curLayer.pureLayerNode = new PureLayerNode();
                    this.curLayer.pureLayerNode.name = this.a("name");
                    String styleStr = this.a_("style");
                    this.curLayer.pureLayerNode.style = styleStr != null ? Poly.Type.valueOf(styleStr) : Poly.Type.FILLED;
                    this.curLayer.pureLayerNode.port = this.a("port");
                    break;
                }
                case arcProto: {
                    this.curArc = new ArcProto();
                    this.curArc.name = this.a("name");
                    this.curArc.function = ArcProto.Function.valueOf(this.a("fun"));
                    break;
                }
                case wipable: {
                    this.curArc.wipable = true;
                    break;
                }
                case curvable: {
                    this.curArc.curvable = true;
                    break;
                }
                case special: {
                    this.curArc.special = true;
                    break;
                }
                case notUsed: {
                    if (this.curArc != null) {
                        this.curArc.notUsed = true;
                    }
                    if (this.curNode == null) break;
                    this.curNode.notUsed = true;
                    break;
                }
                case skipSizeInPalette: {
                    if (this.curArc != null) {
                        this.curArc.skipSizeInPalette = true;
                    }
                    if (this.curNode == null) break;
                    this.curNode.skipSizeInPalette = true;
                    break;
                }
                case arcLayer: {
                    ArcLayer arcLay = new ArcLayer();
                    arcLay.layer = this.a("layer");
                    this.curDistance = arcLay.extend;
                    arcLay.style = Poly.Type.valueOf(this.a("style"));
                    this.curArc.arcLayers.add(arcLay);
                    break;
                }
                case arcPin: {
                    this.curArc.arcPin = new ArcPin();
                    this.curArc.arcPin.name = this.a("name");
                    this.curArc.arcPin.portName = this.a("port");
                    this.curArc.arcPin.elibSize = Double.valueOf(this.a("elibSize"));
                    break;
                }
                case primitiveNode: {
                    this.curNode = new PrimitiveNode();
                    this.curNode.name = this.a("name");
                    this.curNode.function = PrimitiveNode.Function.valueOf(this.a("fun"));
                    break;
                }
                case shrinkArcs: {
                    this.curNode.shrinkArcs = true;
                    break;
                }
                case square: {
                    this.curNode.square = true;
                    break;
                }
                case canBeZeroSize: {
                    this.curNode.canBeZeroSize = true;
                    break;
                }
                case wipes: {
                    this.curNode.wipes = true;
                    break;
                }
                case lockable: {
                    this.curNode.lockable = true;
                    break;
                }
                case edgeSelect: {
                    this.curNode.edgeSelect = true;
                    break;
                }
                case lowVt: {
                    this.curNode.lowVt = true;
                    break;
                }
                case highVt: {
                    this.curNode.highVt = true;
                    break;
                }
                case nativeBit: {
                    this.curNode.nativeBit = true;
                    break;
                }
                case od18: {
                    this.curNode.od18 = true;
                    break;
                }
                case od25: {
                    this.curNode.od25 = true;
                    break;
                }
                case od33: {
                    this.curNode.od33 = true;
                    break;
                }
                case diskOffset: {
                    this.curNode.diskOffset = EPoint.fromLambda(Double.parseDouble(this.a("x")), Double.parseDouble(this.a("y")));
                    break;
                }
                case defaultWidth: {
                    this.curDistance = this.curNode.defaultWidth;
                    break;
                }
                case defaultHeight: {
                    this.curDistance = this.curNode.defaultHeight;
                    break;
                }
                case nodeBase: {
                    double lx = Double.parseDouble(this.a("lx"));
                    double hx = Double.parseDouble(this.a("hx"));
                    double ly = Double.parseDouble(this.a("ly"));
                    double hy = Double.parseDouble(this.a("hy"));
                    this.curNode.nodeBase = ERectangle.fromLambda(lx, ly, hx - lx, hy - ly);
                    break;
                }
                case nodeLayer: {
                    String electrical;
                    this.curNodeLayer = new NodeLayer();
                    this.curNodeLayer.layer = this.a("layer");
                    this.curNodeLayer.style = Poly.Type.valueOf(this.a("style"));
                    String portNum = this.a_("portNum");
                    if (portNum != null) {
                        this.curNodeLayer.portNum = Integer.parseInt(portNum);
                    }
                    if ((electrical = this.a_("electrical")) != null) {
                        if (Boolean.parseBoolean(electrical)) {
                            this.curNodeLayer.inElectricalLayers = true;
                            break;
                        }
                        this.curNodeLayer.inLayers = true;
                        break;
                    }
                    this.curNodeLayer.inLayers = true;
                    this.curNodeLayer.inElectricalLayers = true;
                    break;
                }
                case box: {
                    if (this.curNodeLayer != null) {
                        this.curNodeLayer.representation = 1;
                        this.curNodeLayer.lx.k = this.da_("klx", -1.0);
                        this.curNodeLayer.hx.k = this.da_("khx", 1.0);
                        this.curNodeLayer.ly.k = this.da_("kly", -1.0);
                        this.curNodeLayer.hy.k = this.da_("khy", 1.0);
                    }
                    if (this.curPort == null) break;
                    this.curPort.lx.k = this.da_("klx", -1.0);
                    this.curPort.hx.k = this.da_("khx", 1.0);
                    this.curPort.ly.k = this.da_("kly", -1.0);
                    this.curPort.hy.k = this.da_("khy", 1.0);
                    break;
                }
                case points: {
                    this.curNodeLayer.representation = 0;
                    break;
                }
                case multicutbox: {
                    this.curNodeLayer.representation = 3;
                    this.curNodeLayer.lx.k = this.da_("klx", -1.0);
                    this.curNodeLayer.hx.k = this.da_("khx", 1.0);
                    this.curNodeLayer.ly.k = this.da_("kly", -1.0);
                    this.curNodeLayer.hy.k = this.da_("khy", 1.0);
                    this.curNodeLayer.sizeRule = this.a("sizeRule");
                    this.curNodeLayer.sepRule = this.a("sepRule");
                    this.curNodeLayer.sepRule2D = this.a_("sepRule2D");
                    break;
                }
                case serpbox: {
                    this.curNodeLayer.representation = 1;
                    this.curNodeLayer.lx.k = this.da_("klx", -1.0);
                    this.curNodeLayer.hx.k = this.da_("khx", 1.0);
                    this.curNodeLayer.ly.k = this.da_("kly", -1.0);
                    this.curNodeLayer.hy.k = this.da_("khy", 1.0);
                    this.curNodeLayer.lWidth = Double.parseDouble(this.a("lWidth"));
                    this.curNodeLayer.rWidth = Double.parseDouble(this.a("rWidth"));
                    this.curNodeLayer.tExtent = Double.parseDouble(this.a("tExtent"));
                    this.curNodeLayer.bExtent = Double.parseDouble(this.a("bExtent"));
                    break;
                }
                case lambdaBox: {
                    if (this.curNodeLayer != null) {
                        this.curNodeLayer.lx.addLambda(Double.parseDouble(this.a("klx")));
                        this.curNodeLayer.hx.addLambda(Double.parseDouble(this.a("khx")));
                        this.curNodeLayer.ly.addLambda(Double.parseDouble(this.a("kly")));
                        this.curNodeLayer.hy.addLambda(Double.parseDouble(this.a("khy")));
                    }
                    if (this.curPort == null) break;
                    this.curPort.lx.addLambda(Double.parseDouble(this.a("klx")));
                    this.curPort.hx.addLambda(Double.parseDouble(this.a("khx")));
                    this.curPort.ly.addLambda(Double.parseDouble(this.a("kly")));
                    this.curPort.hy.addLambda(Double.parseDouble(this.a("khy")));
                    break;
                }
                case techPoint: {
                    double xm = Double.parseDouble(this.a("xm"));
                    double xa = Double.parseDouble(this.a("xa"));
                    double ym = Double.parseDouble(this.a("ym"));
                    double ya = Double.parseDouble(this.a("ya"));
                    Technology.TechPoint p = new Technology.TechPoint(new EdgeH(xm, xa), new EdgeV(ym, ya));
                    if (this.curNodeLayer == null) break;
                    this.curNodeLayer.techPoints.add(p);
                    break;
                }
                case primitivePort: {
                    this.curPort = new PrimitivePort();
                    this.curPort.name = this.a("name");
                    break;
                }
                case portAngle: {
                    this.curPort.portAngle = Integer.parseInt(this.a("primary"));
                    this.curPort.portRange = Integer.parseInt(this.a("range"));
                    break;
                }
                case polygonal: {
                    this.curNode.specialType = 2;
                    break;
                }
                case serpTrans: {
                    this.curNode.specialType = 1;
                    this.curNode.specialValues = new double[6];
                    this.curSpecialValueIndex = 0;
                    break;
                }
                case minSizeRule: {
                    this.curNode.nodeSizeRule = new NodeSizeRule();
                    this.curNode.nodeSizeRule.width = Double.parseDouble(this.a("width"));
                    this.curNode.nodeSizeRule.height = Double.parseDouble(this.a("height"));
                    this.curNode.nodeSizeRule.rule = this.a("rule");
                    break;
                }
                case spiceTemplate: {
                    this.curNode.spiceTemplate = this.a("value");
                    break;
                }
                case spiceHeader: {
                    this.curSpiceHeader = new SpiceHeader();
                    this.curSpiceHeader.level = Integer.parseInt(this.a("level"));
                    this.tech.spiceHeaders.add(this.curSpiceHeader);
                    break;
                }
                case spiceLine: {
                    this.curSpiceHeader.spiceLines.add(this.a("line"));
                    break;
                }
                case displayStyle: {
                    this.curDisplayStyle = new DisplayStyle();
                    this.curDisplayStyle.name = this.a("name");
                    this.tech.displayStyles.add(this.curDisplayStyle);
                    break;
                }
                case transparentLayer: {
                    this.curTransparent = Integer.parseInt(this.a("transparent"));
                    this.curB = 0;
                    this.curG = 0;
                    this.curR = 0;
                    break;
                }
                case transparentColor: {
                    this.curTransparent = Integer.parseInt(this.a("transparent"));
                    if (this.curTransparent <= 0) break;
                    Color color = this.curDisplayStyle.transparentLayers.get(this.curTransparent - 1);
                    this.curR = color.getRed();
                    this.curG = color.getGreen();
                    this.curB = color.getBlue();
                    break;
                }
                case opaqueColor: {
                    this.curR = Integer.parseInt(this.a("r"));
                    this.curG = Integer.parseInt(this.a("g"));
                    this.curB = Integer.parseInt(this.a("b"));
                    break;
                }
                case display3D: {
                    this.curLayerDisplayStyle.mode3D = this.a("mode");
                    this.curLayerDisplayStyle.factor3D = Double.parseDouble(this.a("factor"));
                    break;
                }
                case menuPalette: {
                    this.tech.menuPalette = new MenuPalette();
                    this.tech.menuPalette.numColumns = Integer.parseInt(this.a("numColumns"));
                    break;
                }
                case menuBox: {
                    this.curMenuBox = new ArrayList();
                    this.tech.menuPalette.menuBoxes.add(this.curMenuBox);
                    break;
                }
                case menuCell: {
                    this.curMenuCell = new MenuCell();
                    this.curMenuCell.cellName = this.a("cellName");
                    break;
                }
                case menuNodeInst: {
                    this.curMenuNodeInst = new MenuNodeInst();
                    this.curMenuNodeInst.protoName = this.a("protoName");
                    this.curMenuNodeInst.function = PrimitiveNode.Function.valueOf(this.a("function"));
                    String rotField = this.a_("rotation");
                    if (rotField == null) break;
                    this.curMenuNodeInst.rotation = Integer.parseInt(rotField);
                    break;
                }
                case menuNodeText: {
                    this.curMenuNodeInst.text = this.a("text");
                    this.curMenuNodeInst.fontSize = Double.parseDouble(this.a("size"));
                    break;
                }
                case rule: {
                    String layerStr2;
                    String kStr = this.a_("k");
                    Layer layer = null;
                    Layer layer2 = null;
                    String layerStr = this.a_("layer");
                    if (layerStr != null) {
                        layer = this.tech.findLayer(layerStr);
                        assert (layer != null);
                    }
                    String string = layerStr2 = layerStr != null ? this.a_("layer2") : null;
                    if (layerStr2 != null) {
                        layer2 = this.tech.findLayer(layerStr2);
                        assert (layer2 != null);
                    }
                    this.curDistance.addRule(this.a("ruleName"), layer, layer2, kStr != null ? Double.valueOf(kStr) : 1.0);
                    break;
                }
                case ruleSet: {
                    this.curRuleSet = this.tech.newRuleSet(this.a("ruleName"));
                    break;
                }
                case layerRule: {
                    this.curLayerRule = this.curRuleSet.newLayerRule(this.a("ruleName"));
                    break;
                }
                case Foundry: {
                    this.curFoundry = new Foundry();
                    this.curFoundry.name = this.a("name");
                    this.tech.foundries.add(this.curFoundry);
                    break;
                }
                case layerGds: {
                    this.curFoundry.layerGds.put(this.a("layer"), this.a("gds"));
                    break;
                }
                case LayerRule: 
                case LayersRule: 
                case NodeLayersRule: 
                case NodeRule: {
                    DRCTemplate.parseXmlElement(this.curFoundry.rules, key.name(), attributes);
                    break;
                }
                default: {
                    assert (key.hasText);
                    this.beginCharacters();
                    return;
                }
            }
            assert (!key.hasText);
            if (dump) {
                System.out.println("startElement uri=" + uri + " localName=" + localName + " qName=" + qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    System.out.println("\tattribute " + i + " uri=" + attributes.getURI(i) + " localName=" + attributes.getLocalName(i) + " QName=" + attributes.getQName(i) + " type=" + attributes.getType(i) + " value=<" + attributes.getValue(i) + ">");
                }
            }
        }

        private double da_(String attrName, double defaultValue) {
            String s = this.a_(attrName);
            return s != null ? Double.parseDouble(s) : defaultValue;
        }

        private String a(String attrName) {
            String v = this.attributes.getValue(attrName);
            return v;
        }

        private String a_(String attrName) {
            String v = this.attributes.getValue(attrName);
            if (v == null) {
                return null;
            }
            return v;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XmlKeyword key = (XmlKeyword)((Object)xmlKeywords.get(localName));
            if (key.hasText) {
                String text = this.endCharacters();
                switch (key) {
                    case shortName: {
                        this.tech.shortTechName = text;
                        break;
                    }
                    case description: {
                        this.tech.description = text;
                        break;
                    }
                    case oldName: {
                        if (this.curLayer != null) {
                            this.curLayer.pureLayerNode.oldName = text;
                        }
                        if (this.curArc != null) {
                            this.curArc.oldName = text;
                        }
                        if (this.curNode == null) break;
                        this.curNode.oldName = text;
                        break;
                    }
                    case extended: {
                        this.curArc.extended = Boolean.parseBoolean(text);
                        break;
                    }
                    case fixedAngle: {
                        this.curArc.fixedAngle = Boolean.parseBoolean(text);
                        break;
                    }
                    case wipable: {
                        this.curArc.wipable = Boolean.parseBoolean(text);
                        break;
                    }
                    case angleIncrement: {
                        this.curArc.angleIncrement = Integer.parseInt(text);
                        break;
                    }
                    case antennaRatio: {
                        this.curArc.antennaRatio = Double.parseDouble(text);
                        break;
                    }
                    case elibWidthOffset: {
                        this.curArc.elibWidthOffset = Double.parseDouble(text);
                        break;
                    }
                    case portTopology: {
                        this.curPort.portTopology = Integer.parseInt(text);
                        break;
                    }
                    case portArc: {
                        if (this.curLayer != null && this.curLayer.pureLayerNode != null) {
                            this.curLayer.pureLayerNode.portArcs.add(text);
                        }
                        if (this.curArc != null && this.curArc.arcPin != null) {
                            this.curArc.arcPin.portArcs.add(text);
                        }
                        if (this.curPort == null) break;
                        this.curPort.portArcs.add(text);
                        break;
                    }
                    case specialValue: {
                        this.curNode.specialValues[this.curSpecialValueIndex++] = Double.parseDouble(text);
                        break;
                    }
                    case r: {
                        this.curR = Integer.parseInt(text);
                        break;
                    }
                    case g: {
                        this.curG = Integer.parseInt(text);
                        break;
                    }
                    case b: {
                        this.curB = Integer.parseInt(text);
                        break;
                    }
                    case patternedOnDisplay: {
                        this.patternedOnDisplay = Boolean.parseBoolean(text);
                        break;
                    }
                    case patternedOnPrinter: {
                        this.patternedOnPrinter = Boolean.parseBoolean(text);
                        break;
                    }
                    case pattern: {
                        int p = 0;
                        assert (text.length() == 16);
                        for (int j = 0; j < text.length(); ++j) {
                            if (text.charAt(text.length() - j - 1) == ' ') continue;
                            p |= 1 << j;
                        }
                        this.pattern[this.curPatternIndex++] = p;
                        break;
                    }
                    case outlined: {
                        this.outline = EGraphics.Outline.valueOf(text);
                        break;
                    }
                    case opacity: {
                        this.opacity = Double.parseDouble(text);
                        break;
                    }
                    case foreground: {
                        this.foreground = Boolean.parseBoolean(text);
                        break;
                    }
                    case menuArc: {
                        this.curMenuBox.add(this.tech.findArc(text));
                        break;
                    }
                    case menuNode: {
                        this.curMenuBox.add(this.tech.findNode(text));
                        break;
                    }
                    case menuText: {
                        this.curMenuBox.add(text);
                        break;
                    }
                    case lambda: {
                        this.curDistance.addLambda(Double.parseDouble(text));
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                return;
            }
            switch (key) {
                case technology: {
                    break;
                }
                case layer: {
                    if (this.curDisplayStyle != null) {
                        assert (this.curPatternIndex == this.pattern.length);
                        this.curLayerDisplayStyle.desc = new EGraphics(this.patternedOnDisplay, this.patternedOnPrinter, this.outline, this.curTransparent, this.curR, this.curG, this.curB, this.opacity, this.foreground, (int[])this.pattern.clone());
                        this.curLayerDisplayStyle = null;
                        break;
                    }
                    if (this.curLayerRule != null) {
                        this.curDistance = null;
                        break;
                    }
                    this.curLayer = null;
                    break;
                }
                case arcProto: {
                    this.tech.arcs.add(this.curArc);
                    this.curArc = null;
                    break;
                }
                case primitiveNode: {
                    this.tech.nodes.add(this.curNode);
                    this.curNode = null;
                    break;
                }
                case nodeLayer: {
                    this.curNode.nodeLayers.add(this.curNodeLayer);
                    this.curNodeLayer = null;
                    break;
                }
                case primitivePort: {
                    this.curNode.ports.add(this.curPort);
                    this.curPort = null;
                    break;
                }
                case menuNodeInst: {
                    this.curMenuBox.add(this.curMenuNodeInst);
                    this.curMenuNodeInst = null;
                    break;
                }
                case displayStyle: {
                    this.curDisplayStyle = null;
                    break;
                }
                case transparentLayer: {
                    while (this.curTransparent > this.curDisplayStyle.transparentLayers.size()) {
                        this.curDisplayStyle.transparentLayers.add(null);
                    }
                    Color oldColor = this.curDisplayStyle.transparentLayers.set(this.curTransparent - 1, new Color(this.curR, this.curG, this.curB));
                    assert (oldColor == null);
                    break;
                }
                case menuCell: {
                    this.curMenuBox.add("LOADCELL " + this.curMenuCell.cellName);
                    this.curMenuCell = null;
                    break;
                }
                case ruleSet: {
                    this.curRuleSet = null;
                    break;
                }
                case layerRule: {
                    this.curLayerRule = null;
                    break;
                }
                case numMetals: 
                case scale: 
                case defaultFoundry: 
                case minResistance: 
                case minCapacitance: 
                case cifLayer: 
                case skillLayer: 
                case parasitics: 
                case pureLayerNode: 
                case wipable: 
                case curvable: 
                case special: 
                case notUsed: 
                case skipSizeInPalette: 
                case arcLayer: 
                case arcPin: 
                case shrinkArcs: 
                case square: 
                case canBeZeroSize: 
                case wipes: 
                case lockable: 
                case edgeSelect: 
                case lowVt: 
                case highVt: 
                case nativeBit: 
                case od18: 
                case od25: 
                case od33: 
                case diskOffset: 
                case defaultWidth: 
                case defaultHeight: 
                case nodeBase: 
                case box: 
                case points: 
                case multicutbox: 
                case serpbox: 
                case lambdaBox: 
                case techPoint: 
                case portAngle: 
                case polygonal: 
                case serpTrans: 
                case minSizeRule: 
                case spiceTemplate: 
                case spiceHeader: 
                case spiceLine: 
                case transparentColor: 
                case opaqueColor: 
                case display3D: 
                case menuPalette: 
                case menuBox: 
                case menuNodeText: 
                case rule: 
                case Foundry: 
                case layerGds: 
                case LayerRule: 
                case LayersRule: 
                case NodeLayersRule: 
                case NodeRule: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.acceptCharacters) {
                this.charBuffer.append(ch, start, length);
            } else {
                int i;
                boolean nonBlank = false;
                for (i = 0; i < length; ++i) {
                    char c = ch[start + i];
                    nonBlank = nonBlank || c != ' ' && c != '\n';
                }
                if (nonBlank) {
                    System.out.print("characters size=" + ch.length + " start=" + start + " length=" + length + " {");
                    for (i = 0; i < length; ++i) {
                        System.out.print(ch[start + i]);
                    }
                    System.out.println("}");
                }
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            System.out.println("warning publicId=" + e.getPublicId() + " systemId=" + e.getSystemId() + " line=" + e.getLineNumber() + " column=" + e.getColumnNumber() + " message=" + e.getMessage() + " exception=" + e.getException());
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum XmlKeyword {
        technology,
        shortName(true),
        description(true),
        numMetals,
        scale,
        defaultFoundry,
        minResistance,
        minCapacitance,
        layer,
        display3D,
        cifLayer,
        skillLayer,
        parasitics,
        pureLayerNode,
        arcProto,
        oldName(true),
        wipable,
        curvable,
        special,
        notUsed,
        skipSizeInPalette,
        extended(true),
        fixedAngle(true),
        angleIncrement(true),
        antennaRatio(true),
        elibWidthOffset(true),
        arcLayer,
        arcPin,
        primitiveNode,
        shrinkArcs,
        square,
        canBeZeroSize,
        wipes,
        lockable,
        edgeSelect,
        lowVt,
        highVt,
        nativeBit,
        od18,
        od25,
        od33,
        diskOffset,
        defaultWidth,
        defaultHeight,
        nodeBase,
        nodeLayer,
        box,
        multicutbox,
        serpbox,
        lambdaBox,
        points,
        techPoint,
        primitivePort,
        portAngle,
        portTopology(true),
        portArc(true),
        polygonal,
        serpTrans,
        specialValue(true),
        minSizeRule,
        spiceTemplate,
        spiceHeader,
        spiceLine,
        displayStyle,
        transparentLayer,
        r(true),
        g(true),
        b(true),
        transparentColor,
        opaqueColor,
        patternedOnDisplay(true),
        patternedOnPrinter(true),
        pattern(true),
        outlined(true),
        opacity(true),
        foreground(true),
        menuPalette,
        menuBox,
        menuArc(true),
        menuNode(true),
        menuCell,
        menuText(true),
        menuNodeInst,
        menuNodeText,
        lambda(true),
        rule,
        ruleSet,
        layerRule,
        Foundry,
        layerGds,
        LayerRule,
        LayersRule,
        NodeLayersRule,
        NodeRule;

        private final boolean hasText;

        private XmlKeyword() {
            this.hasText = false;
        }

        private XmlKeyword(boolean hasText) {
            this.hasText = hasText;
        }
    }

    public static class Foundry
    implements Serializable {
        public String name;
        public final Map<String, String> layerGds = new LinkedHashMap<String, String>();
        public final List<DRCTemplate> rules = new ArrayList<DRCTemplate>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuleSet
    implements Serializable {
        public final String name;
        public final Map<String, Map<Layer, Distance>> layerRules = new LinkedHashMap<String, Map<Layer, Distance>>();

        private RuleSet(String name) {
            this.name = name;
        }

        public Map<Layer, Distance> newLayerRule(String ruleName) {
            if (ruleName == null) {
                throw new NullPointerException();
            }
            if (this.layerRules.containsKey(ruleName)) {
                throw new IllegalArgumentException("Duplicate LayerRule " + ruleName);
            }
            LinkedHashMap<Layer, Distance> layerRule = new LinkedHashMap<Layer, Distance>();
            this.layerRules.put(ruleName, layerRule);
            return layerRule;
        }
    }

    public static class DistanceRule
    implements Serializable,
    Cloneable {
        final String ruleName;
        final Layer layer;
        final Layer layer2;
        final double k;

        public DistanceRule(Technology.DistanceRule oldRule) {
            this(oldRule.ruleName, null, null, oldRule.k);
        }

        private DistanceRule(String ruleName, Layer layer, Layer layer2, double k) {
            this.ruleName = ruleName;
            this.layer = layer;
            this.layer2 = layer2;
            this.k = k;
        }

        public DistanceRule clone() {
            try {
                return (DistanceRule)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        private void writeXml(Writer writer) {
            writer.b(XmlKeyword.rule);
            writer.a("ruleName", this.ruleName);
            if (this.layer != null) {
                writer.a("layer", this.layer.name);
                if (this.layer2 != null) {
                    writer.a("layer2", this.layer2.name);
                }
            }
            if (this.k != 1.0) {
                writer.a("k", this.k);
            }
            writer.e();
        }

        private double getLambda(DistanceContext context) {
            return context.getRule(this.ruleName) * this.k;
        }
    }

    public static interface DistanceContext {
        public double getRule(String var1);
    }

    public static class Distance
    implements Serializable {
        public double k;
        public double lambdaValue;
        public final List<DistanceRule> terms = new ArrayList<DistanceRule>();

        public void assign(Distance d) {
            this.k = d.k;
            this.lambdaValue = d.lambdaValue;
            for (DistanceRule term : d.terms) {
                this.terms.add(term.clone());
            }
        }

        public void assign(Technology.Distance d) {
            this.k = d.k;
            this.lambdaValue = d.lambdaValue;
            for (Technology.DistanceRule term : d.terms) {
                this.terms.add(new DistanceRule(term));
            }
        }

        public Distance clone() {
            Distance d = new Distance();
            d.assign(this);
            return d;
        }

        public double getLambda(DistanceContext context) {
            double value = this.lambdaValue;
            for (DistanceRule term : this.terms) {
                value += term.getLambda(context);
            }
            return value;
        }

        private void writeXml(Writer writer, boolean multiLine) {
            for (DistanceRule term : this.terms) {
                term.writeXml(writer);
                if (!multiLine) continue;
                writer.l();
            }
            if (this.lambdaValue != 0.0) {
                writer.bcpe(XmlKeyword.lambda, this.lambdaValue);
                if (multiLine) {
                    writer.l();
                }
            }
        }

        public void addLambda(double value) {
            this.lambdaValue += value;
        }

        public void addRule(String ruleName, double k) {
            this.addRule(ruleName, null, k);
        }

        public void addRule(String ruleName, Layer layer, double k) {
            this.addRule(ruleName, layer, null, k);
        }

        public void addRule(String ruleName, Layer layer, Layer layer2, double k) {
            this.terms.add(new DistanceRule(ruleName, layer, layer2, k));
        }

        public boolean isEmpty() {
            return this.lambdaValue == 0.0 && this.terms.isEmpty();
        }
    }

    public static class MenuCell
    implements Serializable {
        public String cellName;
    }

    public static class MenuNodeInst
    implements Serializable {
        public String protoName;
        public PrimitiveNode.Function function;
        public String text;
        public double fontSize;
        public int rotation;
    }

    public static class MenuPalette
    implements Serializable {
        public int numColumns;
        public List<List<Object>> menuBoxes = new ArrayList<List<Object>>();

        public String writeXml() {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            OneLineWriter writer = new OneLineWriter(out);
            writer.writeMenuPaletteXml(this);
            out.close();
            return sw.getBuffer().toString();
        }
    }

    public static class LayerDisplayStyle
    implements Serializable {
        public final Layer layer;
        public EGraphics desc;
        public String mode3D;
        public double factor3D;

        private LayerDisplayStyle(Layer layer) {
            this.layer = layer;
        }
    }

    public static class DisplayStyle
    implements Serializable {
        public String name;
        public final List<Color> transparentLayers = new ArrayList<Color>();
        private final LinkedHashMap<Layer, LayerDisplayStyle> layerStylesInternal = new LinkedHashMap();
        public final Map<Layer, LayerDisplayStyle> layerStyles = Collections.unmodifiableMap(this.layerStylesInternal);

        public LayerDisplayStyle newLayer(Layer layer) {
            LayerDisplayStyle lds = new LayerDisplayStyle(layer);
            LayerDisplayStyle old = this.layerStylesInternal.put(layer, lds);
            assert (old == null);
            return lds;
        }
    }

    public static class SpiceHeader
    implements Serializable {
        public int level;
        public final List<String> spiceLines = new ArrayList<String>();
    }

    public static class PrimitivePort
    implements Serializable {
        public String name;
        public int portAngle;
        public int portRange;
        public int portTopology;
        public final Distance lx = new Distance();
        public final Distance hx = new Distance();
        public final Distance ly = new Distance();
        public final Distance hy = new Distance();
        public final List<String> portArcs = new ArrayList<String>();
    }

    public static class NodeSizeRule
    implements Serializable {
        public double width;
        public double height;
        public String rule;
    }

    public static class NodeLayer
    implements Serializable {
        public String layer;
        public Poly.Type style;
        public int portNum;
        public boolean inLayers;
        public boolean inElectricalLayers;
        public int representation;
        public final Distance lx = new Distance();
        public final Distance hx = new Distance();
        public final Distance ly = new Distance();
        public final Distance hy = new Distance();
        public final List<Technology.TechPoint> techPoints = new ArrayList<Technology.TechPoint>();
        public double sizex;
        public double sizey;
        public double sep1d;
        public double sep2d;
        public String sizeRule;
        public String sepRule;
        public String sepRule2D;
        public double lWidth;
        public double rWidth;
        public double tExtent;
        public double bExtent;
    }

    public static class PrimitiveNode
    implements Serializable {
        public String name;
        public String oldName;
        public boolean shrinkArcs;
        public boolean square;
        public boolean canBeZeroSize;
        public boolean wipes;
        public boolean lockable;
        public boolean edgeSelect;
        public boolean skipSizeInPalette;
        public boolean notUsed;
        public boolean lowVt;
        public boolean highVt;
        public boolean nativeBit;
        public boolean od18;
        public boolean od25;
        public boolean od33;
        public PrimitiveNode.Function function;
        public EPoint diskOffset;
        public final Distance defaultWidth = new Distance();
        public final Distance defaultHeight = new Distance();
        public ERectangle nodeBase;
        public final List<NodeLayer> nodeLayers = new ArrayList<NodeLayer>();
        public final List<PrimitivePort> ports = new ArrayList<PrimitivePort>();
        public int specialType;
        public double[] specialValues;
        public NodeSizeRule nodeSizeRule;
        public String spiceTemplate;
    }

    public static class ArcLayer
    implements Serializable {
        public String layer;
        public final Distance extend = new Distance();
        public Poly.Type style;
    }

    public static class ArcPin
    implements Serializable {
        public String name;
        public String portName;
        public double elibSize;
        public final List<String> portArcs = new ArrayList<String>();
    }

    public static class ArcProto
    implements Serializable {
        public String name;
        public String oldName;
        public ArcProto.Function function;
        public boolean wipable;
        public boolean curvable;
        public boolean special;
        public boolean notUsed;
        public boolean skipSizeInPalette;
        public boolean extended;
        public boolean fixedAngle;
        public int angleIncrement;
        public double antennaRatio;
        public double elibWidthOffset;
        public final List<ArcLayer> arcLayers = new ArrayList<ArcLayer>();
        public ArcPin arcPin;
    }

    public static class PureLayerNode
    implements Serializable {
        public String name;
        public String oldName;
        public Poly.Type style;
        public String port;
        public final List<String> portArcs = new ArrayList<String>();
    }

    public static class Layer
    implements Serializable {
        public final String name;
        public Layer.Function function;
        public int extraFunction;
        public String cif;
        public String skill;
        public double resistance;
        public double capacitance;
        public double edgeCapacitance;
        public PureLayerNode pureLayerNode;

        private Layer(String name) {
            this.name = name;
        }
    }

    public static class Technology
    implements Serializable {
        public String techName;
        public String className;
        public String shortTechName;
        public String description;
        public int minNumMetals;
        public int maxNumMetals;
        public int defaultNumMetals;
        public double scaleValue;
        public boolean scaleRelevant;
        public String defaultFoundry;
        public double minResistance;
        public double minCapacitance;
        private final LinkedHashMap<String, Layer> layers = new LinkedHashMap();
        public final List<ArcProto> arcs = new ArrayList<ArcProto>();
        public final List<PrimitiveNode> nodes = new ArrayList<PrimitiveNode>();
        public final List<SpiceHeader> spiceHeaders = new ArrayList<SpiceHeader>();
        public final List<DisplayStyle> displayStyles = new ArrayList<DisplayStyle>();
        public MenuPalette menuPalette;
        public final LinkedHashMap<String, RuleSet> ruleSets = new LinkedHashMap();
        public final List<Foundry> foundries = new ArrayList<Foundry>();

        public Layer newLayer(String name) {
            if (name == null) {
                throw new NullPointerException();
            }
            if (this.layers.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate Layer " + name);
            }
            Layer layer = new Layer(name);
            this.layers.put(name, layer);
            return layer;
        }

        public RuleSet newRuleSet(String name) {
            if (name == null) {
                throw new NullPointerException();
            }
            if (this.ruleSets.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate RuleSet " + name);
            }
            RuleSet ruleSet = new RuleSet(name);
            this.ruleSets.put(name, ruleSet);
            return ruleSet;
        }

        public Layer findLayer(String name) {
            return this.layers.get(name);
        }

        public ArcProto findArc(String name) {
            for (ArcProto arc : this.arcs) {
                if (!arc.name.equals(name)) continue;
                return arc;
            }
            return null;
        }

        public PrimitiveNode findNode(String name) {
            for (PrimitiveNode node : this.nodes) {
                if (!node.name.equals(name)) continue;
                return node;
            }
            return null;
        }

        public void writeXml(String fileName) {
            try {
                PrintWriter out = new PrintWriter(fileName);
                Writer writer = new Writer(out);
                writer.writeTechnology(this);
                out.close();
                System.out.println("Wrote " + fileName);
                System.out.println(" (Add this file to the 'Added Technologies' Project Settings to install it in Electric)");
            }
            catch (IOException e) {
                System.out.println("Error creating " + fileName);
            }
        }
    }
}

