/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.WeakReferences;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.tree.MutableTreeNode;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextWindow
implements WindowContent {
    private Cell cell;
    private WindowFrame wf;
    private JPanel overall;
    private boolean finishing;
    private boolean reloading;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private UndoManager undo = new UndoManager();
    private static WeakReferences<PropertyChangeListener> undoListeners = new WeakReferences();
    private static WeakReferences<PropertyChangeListener> redoListeners = new WeakReferences();
    private String searchString = null;
    private boolean searchCaseSensitive = false;

    public TextWindow(Cell cell, WindowFrame wf) {
        this.wf = wf;
        this.finishing = false;
        this.reloading = false;
        this.textArea = new JTextArea();
        this.scrollPane = new JScrollPane(this.textArea);
        this.overall = new JPanel();
        this.overall.setLayout(new BorderLayout());
        this.overall.add((Component)this.scrollPane, "Center");
        this.setCell(cell, VarContext.globalContext, null);
        TextWindowDocumentListener twDocumentListener = new TextWindowDocumentListener(this);
        this.textArea.getDocument().addDocumentListener(twDocumentListener);
        this.textArea.getDocument().addUndoableEditListener(new MyUndoableEditListener());
        this.textArea.addFocusListener(twDocumentListener);
    }

    @Override
    public void setCursor(Cursor cursor) {
    }

    private void setCellFont(Cell cell) {
        String fontName = User.getDefaultTextCellFont();
        int fontSize = User.getDefaultTextCellSize();
        if (cell != null) {
            fontName = cell.getVarValue(Cell.TEXT_CELL_FONT_NAME, String.class, fontName);
            fontSize = cell.getVarValue(Cell.TEXT_CELL_FONT_SIZE, Integer.class, fontSize);
        }
        this.textArea.setFont(new Font(fontName, 0, fontSize));
    }

    public static void addTextUndoListener(PropertyChangeListener l) {
        undoListeners.add(l);
    }

    public static void addTextRedoListener(PropertyChangeListener l) {
        redoListeners.add(l);
    }

    public static void removeTextUndoListener(PropertyChangeListener l) {
        undoListeners.remove(l);
    }

    public static void removeTextRedoListener(PropertyChangeListener l) {
        redoListeners.remove(l);
    }

    private void updateUndoRedo() {
    }

    public void undo() {
        try {
            this.undo.undo();
            this.updateUndoRedo();
        }
        catch (CannotUndoException e) {
            System.out.println("Cannot undo");
        }
    }

    public void redo() {
        try {
            this.undo.redo();
            this.updateUndoRedo();
        }
        catch (CannotRedoException e) {
            System.out.println("Cannot redo");
        }
    }

    public void paint(Graphics g) {
        if (this.cell != null && this.cell == WindowFrame.getCurrentCell()) {
            this.textArea.requestFocus();
        }
        this.textArea.paint(g);
    }

    public void updateFontInformation() {
        this.textArea.setFont(new Font(User.getDefaultTextCellFont(), 0, User.getDefaultTextCellSize()));
    }

    private void textWindowContentChanged() {
        if (!this.reloading) {
            new SaveCellText(this);
        }
    }

    @Override
    public List<MutableTreeNode> loadExplorerTrees() {
        return this.wf.loadDefaultExplorerTree();
    }

    @Override
    public JPanel getPanel() {
        return this.overall;
    }

    @Override
    public void finished() {
    }

    @Override
    public void setWindowTitle() {
        if (this.wf == null) {
            return;
        }
        this.wf.setTitle(this.wf.composeTitle(this.cell, "", 0));
    }

    @Override
    public Cell getCell() {
        return this.cell;
    }

    @Override
    public Highlighter getHighlighter() {
        return null;
    }

    @Override
    public void setCell(Cell cell, VarContext context, WindowFrame.DisplayAttributes displayAttributes) {
        String oneLine;
        this.cell = cell;
        String[] lines = cell != null ? cell.getTextViewContents() : null;
        oneLine = lines != null ? (oneLine = TextWindow.makeOneString(lines)) : "";
        this.setCellFont(cell);
        this.reloading = true;
        this.textArea.setText(oneLine);
        this.textArea.setSelectionStart(0);
        this.textArea.setSelectionEnd(0);
        this.reloading = false;
        this.setWindowTitle();
    }

    public static void readTextCell() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        WindowContent content = wf.getContent();
        if (!(content instanceof TextWindow)) {
            Job.getUserInterface().showErrorMessage("You must first be editing a text cell (a cell whose view is textual, such as 'doc').", "Cannot import text file");
            return;
        }
        TextWindow tw = (TextWindow)content;
        String fileName = OpenFile.chooseInputFile(FileType.TEXT, null);
        if (fileName == null) {
            return;
        }
        tw.readTextCell(fileName);
    }

    public void readTextCell(String fileName) {
        if (fileName == null) {
            System.out.println("Bad file name: " + fileName);
            return;
        }
        URL fileURL = TextUtils.makeURLToFile(fileName);
        InputStream stream = TextUtils.getURLStream(fileURL);
        if (stream == null) {
            System.out.println("Could not open file: " + fileURL.getFile());
            return;
        }
        try {
            fileURL.openConnection();
        }
        catch (IOException e) {
            System.out.println("Could not find file: " + fileURL.getFile());
            return;
        }
        this.textArea.setText("");
        int READ_BUFFER_SIZE = 65536;
        char[] buf = new char[65536];
        InputStreamReader is = new InputStreamReader(stream);
        try {
            int amtRead;
            while ((amtRead = is.read(buf, 0, 65536)) > 0) {
                String addString = new String(buf, 0, amtRead);
                this.textArea.append(addString);
            }
            stream.close();
        }
        catch (IOException e) {
            System.out.println("Error reading the file");
        }
    }

    public static void writeTextCell() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        WindowContent content = wf.getContent();
        if (!(content instanceof TextWindow)) {
            Job.getUserInterface().showErrorMessage("You must first be editing a text cell (a cell whose view is textual, such as 'doc').", "Cannot import text file");
            return;
        }
        TextWindow tw = (TextWindow)content;
        String fileName = OpenFile.chooseInputFile(FileType.TEXT, null);
        if (fileName == null) {
            return;
        }
        tw.readTextCell(fileName);
    }

    public boolean writeTextCell(String fileName) {
        if (fileName == null) {
            System.out.println("Bad filename: " + fileName);
            return false;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            Document doc = this.textArea.getDocument();
            Element paragraph = doc.getDefaultRootElement();
            int lines = paragraph.getElementCount();
            for (int i = 0; i < lines; ++i) {
                Element e = paragraph.getElement(i);
                int startPos = e.getStartOffset();
                int endPos = e.getEndOffset();
                try {
                    String line = this.textArea.getText(startPos, endPos - startPos);
                    printWriter.print(line);
                    continue;
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
            printWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error saving " + fileName);
            return false;
        }
        System.out.println("Wrote " + fileName);
        return true;
    }

    public void goToLineNumber(int lineNumber) {
        Document doc = this.textArea.getDocument();
        Element paragraph = doc.getDefaultRootElement();
        int lines = paragraph.getElementCount();
        if (lineNumber <= 0 || lineNumber > lines) {
            System.out.println("Line numbers must be between 1 and " + lines);
            return;
        }
        Element e = paragraph.getElement(lineNumber - 1);
        int startPos = e.getStartOffset();
        int endPos = e.getEndOffset();
        this.textArea.setSelectionStart(startPos);
        this.textArea.setSelectionEnd(endPos);
    }

    private void updateText(String[] strings) {
        this.textArea.setText(TextWindow.makeOneString(strings));
    }

    public static void updateText(Cell cell) {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof TextWindow) || content.getCell() != cell) continue;
            TextWindow tw = (TextWindow)content;
            if (tw.finishing) continue;
            String[] strings = cell.getTextViewContents();
            tw.updateText(strings);
        }
    }

    private static String makeOneString(String[] strings) {
        StringBuffer sb = new StringBuffer();
        int len = strings.length;
        for (int i = 0; i < len; ++i) {
            sb.append(strings[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getLineCount() {
        Document doc = this.textArea.getDocument();
        Element paragraph = doc.getDefaultRootElement();
        int lines = paragraph.getElementCount();
        return lines;
    }

    public String[] convertToStrings() {
        Document doc = this.textArea.getDocument();
        Element paragraph = doc.getDefaultRootElement();
        int lines = paragraph.getElementCount();
        String[] strings = new String[lines];
        for (int i = 0; i < lines; ++i) {
            Element e = paragraph.getElement(i);
            int startPos = e.getStartOffset();
            int endPos = e.getEndOffset();
            try {
                strings[i] = this.textArea.getText(startPos, endPos - startPos - 1);
                continue;
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        return strings;
    }

    @Override
    public void rightScrollChanged(int value) {
    }

    @Override
    public void bottomScrollChanged(int value) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void fullRepaint() {
    }

    @Override
    public void fillScreen() {
    }

    @Override
    public void zoomOutContents() {
    }

    @Override
    public void zoomInContents() {
    }

    @Override
    public void focusOnHighlighted() {
    }

    @Override
    public void initTextSearch(String search, boolean caseSensitive, boolean regExp, Set<TextUtils.WhatToSearch> whatToSearch, boolean highlightedOnly) {
        if (regExp) {
            System.out.println("Text windows don't yet implement Regular Expression matching");
        }
        this.searchString = search;
        this.searchCaseSensitive = caseSensitive;
    }

    @Override
    public boolean findNextText(boolean reverse) {
        Document doc = this.textArea.getDocument();
        Element paragraph = doc.getDefaultRootElement();
        int lines = paragraph.getElementCount();
        int lineNo = 0;
        int searchPoint = this.textArea.getSelectionEnd();
        if (reverse) {
            searchPoint = this.textArea.getSelectionStart();
        }
        try {
            lineNo = this.textArea.getLineOfOffset(searchPoint);
        }
        catch (BadLocationException e) {
            return false;
        }
        for (int i = 0; i <= lines; ++i) {
            int index = lineNo + i;
            if (reverse) {
                index = lineNo - i + lines;
            }
            Element e = paragraph.getElement(index % lines);
            int startPos = e.getStartOffset();
            int endPos = e.getEndOffset();
            if (i == 0) {
                if (reverse) {
                    endPos = searchPoint + 1;
                } else {
                    startPos = searchPoint;
                }
            }
            String theLine = null;
            try {
                theLine = this.textArea.getText(startPos, endPos - startPos - 1);
            }
            catch (BadLocationException ex) {
                return false;
            }
            int foundPos = TextUtils.findStringInString(theLine, this.searchString, 0, this.searchCaseSensitive, reverse);
            if (foundPos < 0) continue;
            this.textArea.setSelectionStart(startPos + foundPos);
            this.textArea.setSelectionEnd(startPos + foundPos + this.searchString.length());
            return true;
        }
        return false;
    }

    @Override
    public void replaceText(String replace) {
        int startSelection = this.textArea.getSelectionStart();
        int endSelection = this.textArea.getSelectionEnd();
        this.textArea.replaceRange(replace, startSelection, endSelection);
    }

    @Override
    public void replaceAllText(String replace) {
        Document doc = this.textArea.getDocument();
        Element paragraph = doc.getDefaultRootElement();
        int lines = paragraph.getElementCount();
        for (int i = 0; i < lines; ++i) {
            int foundPos;
            Element e = paragraph.getElement(i);
            int startPos = e.getStartOffset();
            int endPos = e.getEndOffset() - 1;
            String theLine = null;
            try {
                theLine = this.textArea.getText(startPos, endPos - startPos);
            }
            catch (BadLocationException ex) {
                return;
            }
            boolean found = false;
            int scanPos = 0;
            while ((foundPos = TextUtils.findStringInString(theLine, this.searchString, scanPos, this.searchCaseSensitive, false)) >= 0) {
                theLine = theLine.substring(0, foundPos) + replace + theLine.substring(foundPos + this.searchString.length());
                scanPos = foundPos + replace.length();
                found = true;
            }
            if (!found) continue;
            this.textArea.replaceRange(theLine, startPos, endPos);
        }
    }

    @Override
    public void writeImage(ElectricPrinter ep, String filePath) {
        System.out.println("TextWindow:writeImage not implemented");
    }

    @Override
    public boolean initializePrinting(ElectricPrinter ep, PageFormat pageFormat) {
        int pageWid = (int)pageFormat.getImageableWidth() * ep.getDesiredDPI() / 72;
        int pageHei = (int)pageFormat.getImageableHeight() * ep.getDesiredDPI() / 72;
        this.overall.setSize(pageWid, pageHei);
        this.overall.validate();
        this.overall.repaint();
        return true;
    }

    @Override
    public BufferedImage getPrintImage(ElectricPrinter ep) {
        return null;
    }

    @Override
    public void panXOrY(int direction, double[] panningAmounts, int ticks) {
    }

    @Override
    public void centerCursor() {
    }

    private static class SaveCellText
    extends Job {
        private Cell cell;
        private String[] strings;

        private SaveCellText(TextWindow tw) {
            super("Save Cell Text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = tw.cell;
            this.strings = tw.convertToStrings();
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (this.cell != null) {
                this.cell.setTextViewContents(this.strings);
            }
            return true;
        }
    }

    private static class TextWindowDocumentListener
    implements DocumentListener,
    FocusListener {
        private TextWindow tw;

        TextWindowDocumentListener(TextWindow tw) {
            this.tw = tw;
        }

        public void changedUpdate(DocumentEvent e) {
            this.tw.textWindowContentChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.tw.textWindowContentChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.tw.textWindowContentChanged();
        }

        public void focusGained(FocusEvent e) {
            TopLevel top = TopLevel.getCurrentJFrame();
            top.getTheMenuBar().setIgnoreTextEditKeys(true);
        }

        public void focusLost(FocusEvent e) {
            TopLevel top = TopLevel.getCurrentJFrame();
            top.getTheMenuBar().setIgnoreTextEditKeys(false);
        }
    }

    private class MyUndoableEditListener
    implements UndoableEditListener {
        private MyUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            TextWindow.this.undo.addEdit(e.getEdit());
            TextWindow.this.updateUndoRedo();
        }
    }
}

