/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.router;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.flag.router.ToConnect;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SogRouterAdapter {
    private static final boolean SORT_UNROUTED_ARCS = true;
    private static final boolean DUMP_UNROUTED_ARCS = false;
    private final Job job;
    private final SeaOfGatesEngine seaOfGates = null;
    private final Technology generic = Technology.findTechnology("Generic");
    private final ArcProto unroutedArc = this.generic.findArcProto("Unrouted");

    private Cell findParent(List<ToConnect> toConns) {
        for (ToConnect tc : toConns) {
            Iterator<PortInst> i$ = tc.getPortInsts().iterator();
            if (!i$.hasNext()) continue;
            PortInst pi = i$.next();
            return pi.getNodeInst().getParent();
        }
        return null;
    }

    private List<ArcInst> addUnroutedArcs(Cell cell, List<ToConnect> toConns) {
        Netlist nl = cell.getNetlist();
        ArrayList<ArcInst> unroutedArcs = new ArrayList<ArcInst>();
        for (ToConnect tc : toConns) {
            PortInst firstPi = null;
            Network firstNet = null;
            for (PortInst pi : tc.getPortInsts()) {
                if (firstPi == null) {
                    firstPi = pi;
                    firstNet = nl.getNetwork(firstPi);
                    continue;
                }
                Network net = nl.getNetwork(pi);
                if (firstNet == net) continue;
                ArcInst ai = ArcInst.newInstanceBase(this.unroutedArc, 1.0, firstPi, pi);
                unroutedArcs.add(ai);
            }
        }
        return unroutedArcs;
    }

    public SogRouterAdapter(Job job) {
        this.job = job;
    }

    public void route(List<ToConnect> toConns, SeaOfGates.SeaOfGatesOptions prefs) {
        Cell cell = this.findParent(toConns);
        if (cell == null) {
            return;
        }
        List<ArcInst> arcsToRoute = this.addUnroutedArcs(cell, toConns);
        this.seaOfGates.setPrefs(prefs);
        SeaOfGates.seaOfGatesRoute(cell, this.seaOfGates);
    }
}

