/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.sctiming;

import com.sun.electric.tool.simulation.sctiming.PinEdge;
import com.sun.electric.tool.simulation.sctiming.Table2D;
import com.sun.electric.tool.simulation.sctiming.TableData;
import java.util.ArrayList;
import java.util.List;

public class Arc {
    List<PinEdge> stableInputs = new ArrayList<PinEdge>();
    PinEdge input;
    PinEdge output;
    TableData data;
    Table2D data2d_inbuf_outload;
    Table2D data2d_clkbuf_outload;
    Table2D data2d_inbuf_clkbuf;
    PinEdge clk = null;
    PinEdge clkFalse = null;
    List<PinEdge> initialConditions = new ArrayList<PinEdge>();
    String outputLoadSweep = null;
    String inputBufferSweep = null;
    List<String> unusedOutputs = new ArrayList<String>();
    List<PinEdge> dependentStableInputs = new ArrayList<PinEdge>();
    PinEdge glitchNode = null;

    public void setInputTransition(String pin, PinEdge.Transition transition) {
        if (this.input != null) {
            System.out.println("Warning: specified singular input pin twice, ignoring second assingment");
            return;
        }
        this.input = new PinEdge(pin, transition);
    }

    public void setOutputTransition(String pin, PinEdge.Transition transition) {
        if (this.output != null) {
            System.out.println("Warning: specified singular output pin twice, ignoring second assingment");
            return;
        }
        this.output = new PinEdge(pin, transition);
    }

    public void addStableInput(String pin, PinEdge.Transition transition) {
        this.stableInputs.add(new PinEdge(pin, transition));
    }

    public void addDependentStableInput(String pin, PinEdge.Transition transition) {
        this.stableInputs.add(new PinEdge(pin, transition));
        this.dependentStableInputs.add(new PinEdge(pin, transition));
    }

    public void addStableInput(String pin, double voltage) {
        this.stableInputs.add(new PinEdge(pin, voltage));
    }

    public void setClkTransition(String pin, PinEdge.Transition transition) {
        if (this.clk != null) {
            System.out.println("Warning: specified singular clk pin twice, ignoring second assingment");
            return;
        }
        this.clk = new PinEdge(pin, transition);
    }

    public void setClkFalseTransition(String pin, PinEdge.Transition transition) {
        if (this.clkFalse != null) {
            System.out.println("Warning: specified singular clkFalse pin twice, ignoring second assingment");
            return;
        }
        this.clkFalse = new PinEdge(pin, transition);
    }

    public void addDUTInitialCondition(String node, double value2) {
        this.initialConditions.add(new PinEdge(node, value2));
    }

    public void setHoldTimeGlitchNode(String node, PinEdge.Transition transition) {
        if (this.glitchNode != null) {
            System.out.println("Warning: specified singular glitch node twice, ignoring second assingment");
            return;
        }
        this.glitchNode = new PinEdge(node, transition);
    }

    public void addUnusedOutput(String pin) {
        if (this.unusedOutputs.contains(pin)) {
            return;
        }
        this.unusedOutputs.add(pin);
    }

    public String toString() {
        StringBuffer desc = new StringBuffer();
        for (PinEdge in : this.stableInputs) {
            this.appendDesc(desc, in);
        }
        this.appendDesc(desc, this.input);
        if (this.clk != null) {
            this.appendDesc(desc, this.clk);
        }
        desc.append(this.output.pin);
        desc.append("_");
        desc.append(Arc.descTran(this.output.transition));
        String str = desc.toString().replaceAll("[\\[\\]]", "");
        return str;
    }

    private void appendDesc(StringBuffer buf, PinEdge pin) {
        buf.append(pin.pin);
        buf.append("_");
        buf.append(Arc.descTran(pin.transition));
        buf.append("_");
    }

    public static String descTran(PinEdge.Transition tran) {
        switch (tran) {
            case STABLE0: {
                return "0";
            }
            case STABLE1: {
                return "1";
            }
            case RISE: {
                return "R";
            }
            case FALL: {
                return "F";
            }
            case STABLEV: {
                return "V";
            }
        }
        return "";
    }

    public void setOutputLoadSweep(String sweep) {
        this.outputLoadSweep = sweep;
    }

    public String getOutputLoadSweep() {
        return this.outputLoadSweep;
    }

    public void setInputBufferSweep(String sweep) {
        this.inputBufferSweep = sweep;
    }

    public String getInputBufferSweep() {
        return this.inputBufferSweep;
    }
}

