/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CIFTab
extends PreferencePanel {
    private JList cifLayersList;
    private DefaultListModel cifLayersModel;
    private boolean changingCIF = false;
    private Setting cifOutMimicsDisplaySetting = IOTool.getCIFOutMimicsDisplaySetting();
    private Setting cifOutMergesBoxesSetting = IOTool.getCIFOutMergesBoxesSetting();
    private Setting cifOutInstantiatesTopLevleSetting = IOTool.getCIFOutInstantiatesTopLevelSetting();
    private Setting cifOutScaleFactorSetting = IOTool.getCIFOutScaleFactorSetting();
    private JCheckBox cifInputSquaresWires;
    private JTextField cifLayer;
    private JScrollPane cifLayers;
    private JCheckBox cifOutputInstantiatesTopLevel;
    private JCheckBox cifOutputMergesBoxes;
    private JCheckBox cifOutputMimicsDisplay;
    private JTextField cifScale;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JPanel preferences;
    private JPanel projSettings;
    private JComboBox technologySelection;

    public CIFTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.cifLayer);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.preferences;
    }

    @Override
    public JPanel getProjectPreferencesPanel() {
        return this.projSettings;
    }

    @Override
    public String getName() {
        return "CIF";
    }

    @Override
    public void init() {
        this.cifInputSquaresWires.setSelected(IOTool.isCIFInSquaresWires());
        this.cifOutputMimicsDisplay.setSelected(this.getBoolean(this.cifOutMimicsDisplaySetting));
        this.cifOutputMergesBoxes.setSelected(this.getBoolean(this.cifOutMergesBoxesSetting));
        this.cifOutputInstantiatesTopLevel.setSelected(this.getBoolean(this.cifOutInstantiatesTopLevleSetting));
        this.cifScale.setText(Integer.toString(this.getInt(this.cifOutScaleFactorSetting)));
        this.cifLayersModel = new DefaultListModel();
        this.cifLayersList = new JList(this.cifLayersModel);
        this.cifLayersList.setSelectionMode(0);
        this.cifLayers.setViewportView(this.cifLayersList);
        this.cifLayersList.clearSelection();
        this.cifLayersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CIFTab.this.cifClickLayer();
            }
        });
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            this.technologySelection.addItem(tech.getTechName());
        }
        this.technologySelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CIFTab.this.techChanged();
            }
        });
        this.cifLayer.getDocument().addDocumentListener(new CIFDocumentListener(this));
        this.technologySelection.setSelectedItem(Technology.getCurrent().getTechName());
    }

    @Override
    public void term() {
        boolean currentValue = this.cifInputSquaresWires.isSelected();
        if (currentValue != IOTool.isCIFInSquaresWires()) {
            IOTool.setCIFInSquaresWires(currentValue);
        }
        this.setBoolean(this.cifOutMimicsDisplaySetting, this.cifOutputMimicsDisplay.isSelected());
        this.setBoolean(this.cifOutMergesBoxesSetting, this.cifOutputMergesBoxes.isSelected());
        this.setBoolean(this.cifOutInstantiatesTopLevleSetting, this.cifOutputInstantiatesTopLevel.isSelected());
        this.setInt(this.cifOutScaleFactorSetting, TextUtils.atoi(this.cifScale.getText()));
    }

    @Override
    public void refresh() {
        this.techChanged();
    }

    @Override
    public void reset() {
        Technology tech;
        if (IOTool.isFactoryCIFInSquaresWires() != IOTool.isCIFInSquaresWires()) {
            IOTool.setCIFInSquaresWires(IOTool.isFactoryCIFInSquaresWires());
        }
        if ((tech = Technology.findTechnology((String)this.technologySelection.getSelectedItem())) != null) {
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                Setting set = layer.getCIFLayerSetting();
                Object factoryObj = set.getFactoryValue();
                if (!(factoryObj instanceof String)) continue;
                this.setString(set, (String)factoryObj);
            }
        }
        this.setBoolean(this.cifOutMimicsDisplaySetting, (Boolean)this.cifOutMimicsDisplaySetting.getFactoryValue());
        this.setBoolean(this.cifOutMergesBoxesSetting, (Boolean)this.cifOutMergesBoxesSetting.getFactoryValue());
        this.setBoolean(this.cifOutInstantiatesTopLevleSetting, (Boolean)this.cifOutInstantiatesTopLevleSetting.getFactoryValue());
        this.setInt(this.cifOutScaleFactorSetting, (Integer)this.cifOutScaleFactorSetting.getFactoryValue());
    }

    private void techChanged() {
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.cifLayersModel.clear();
        List<Layer> list2 = tech.getLayersSortedByUserPreference();
        for (Layer layer : list2) {
            String str = layer.getName();
            String cifLayer = this.getString(layer.getCIFLayerSetting());
            if (cifLayer == null) {
                cifLayer = "";
            }
            if (cifLayer.length() > 0) {
                str = str + " (" + cifLayer + ")";
            }
            this.cifLayersModel.addElement(str);
        }
        this.cifLayersList.setSelectedIndex(0);
        this.cifClickLayer();
    }

    private void cifClickLayer() {
        this.changingCIF = true;
        String str = (String)this.cifLayersList.getSelectedValue();
        if (str != null) {
            this.cifLayer.setText(this.cifGetLayerName(str));
        }
        this.changingCIF = false;
    }

    private String cifGetLayerName(String str) {
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            return "";
        }
        int closeParen = str.lastIndexOf(41);
        if (closeParen < 0) {
            return "";
        }
        String cifLayer = str.substring(openParen + 1, closeParen);
        return cifLayer;
    }

    private Layer cifGetLayer(String str) {
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return null;
        }
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            openParen = str.length() + 1;
        }
        String layerName = str.substring(0, openParen - 1);
        Layer layer = tech.findLayer(layerName);
        return layer;
    }

    private void cifLayerChanged() {
        if (this.changingCIF) {
            return;
        }
        String str = (String)this.cifLayersList.getSelectedValue();
        Layer layer = this.cifGetLayer(str);
        if (layer == null) {
            return;
        }
        String newLine = layer.getName();
        String newLayer = this.cifLayer.getText().trim();
        if (newLayer.length() > 0) {
            newLine = newLine + " (" + newLayer + ")";
        }
        int index = this.cifLayersList.getSelectedIndex();
        this.cifLayersModel.set(index, newLine);
        this.setString(layer.getCIFLayerSetting(), newLayer);
    }

    private void initComponents() {
        this.projSettings = new JPanel();
        this.jLabel1 = new JLabel();
        this.cifLayers = new JScrollPane();
        this.cifOutputMimicsDisplay = new JCheckBox();
        this.cifOutputMergesBoxes = new JCheckBox();
        this.cifOutputInstantiatesTopLevel = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.cifLayer = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.technologySelection = new JComboBox();
        this.jLabel4 = new JLabel();
        this.cifScale = new JTextField();
        this.preferences = new JPanel();
        this.cifInputSquaresWires = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CIFTab.this.closeDialog(evt);
            }
        });
        this.projSettings.setLayout(new GridBagLayout());
        this.jLabel1.setText("CIF Layer:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.cifLayers.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projSettings.add((Component)this.cifLayers, gridBagConstraints);
        this.cifOutputMimicsDisplay.setText("Output Mimics Display");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projSettings.add((Component)this.cifOutputMimicsDisplay, gridBagConstraints);
        this.cifOutputMergesBoxes.setText("Output Merges Boxes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.projSettings.add((Component)this.cifOutputMergesBoxes, gridBagConstraints);
        this.cifOutputInstantiatesTopLevel.setText("Output Instantiates Top Level");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 8, 4);
        this.projSettings.add((Component)this.cifOutputInstantiatesTopLevel, gridBagConstraints);
        this.jLabel2.setText("(time consuming)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.projSettings.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projSettings.add((Component)this.cifLayer, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.projSettings.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel3.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projSettings.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projSettings.add((Component)this.technologySelection, gridBagConstraints);
        this.jLabel4.setText("Output scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projSettings.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projSettings.add((Component)this.cifScale, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.projSettings, gridBagConstraints);
        this.preferences.setLayout(new GridBagLayout());
        this.cifInputSquaresWires.setText("Input Squares Wires");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.preferences.add((Component)this.cifInputSquaresWires, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.preferences, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class CIFDocumentListener
    implements DocumentListener {
        CIFTab dialog;

        CIFDocumentListener(CIFTab dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.dialog.cifLayerChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.dialog.cifLayerChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.dialog.cifLayerChanged();
        }
    }
}

