/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UnitsTab
extends PreferencePanel {
    private static final boolean OTHERUNITS = false;
    private static final int DISTANCE_OFFSET = TextUtils.UnitScale.MILLI.getIndex();
    private static final int RESISTANCE_OFFSET = TextUtils.UnitScale.GIGA.getIndex();
    private static final int CAPACITANCE_OFFSET = TextUtils.UnitScale.NONE.getIndex();
    private static final int INDUCTANCE_OFFSET = TextUtils.UnitScale.NONE.getIndex();
    private static final int CURRENT_OFFSET = TextUtils.UnitScale.NONE.getIndex();
    private static final int VOLTAGE_OFFSET = TextUtils.UnitScale.KILO.getIndex();
    private static final int TIME_OFFSET = TextUtils.UnitScale.NONE.getIndex();
    private TextUtils.UnitScale initialUnitsDistance;
    private TextUtils.UnitScale initialUnitsResistance;
    private TextUtils.UnitScale initialUnitsCapacitance;
    private TextUtils.UnitScale initialUnitsInductance;
    private TextUtils.UnitScale initialUnitsAmperage;
    private TextUtils.UnitScale initialUnitsVoltage;
    private TextUtils.UnitScale initialUnitsTime;
    private JLabel jLabel1;
    private JLabel jLabel66;
    private JLabel labelCapacitance;
    private JLabel labelCurrent;
    private JLabel labelDistance;
    private JLabel labelInductance;
    private JLabel labelResistance;
    private JLabel labelTime;
    private JLabel labelVoltage;
    private JPanel units;
    private JComboBox unitsCapacitance;
    private JComboBox unitsCurrent;
    private JComboBox unitsDistance;
    private JComboBox unitsInductance;
    private JComboBox unitsResistance;
    private JComboBox unitsTime;
    private JComboBox unitsVoltage;

    public UnitsTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.units;
    }

    @Override
    public String getName() {
        return "Units";
    }

    @Override
    public void init() {
        this.unitsDistance.addItem("Units (scalable)");
        this.unitsDistance.addItem("Millimeters");
        this.unitsDistance.addItem("Microns");
        this.unitsDistance.addItem("Nanometers");
        this.unitsDistance.addItem("Picometers");
        this.initialUnitsDistance = User.getDistanceUnits();
        int index = 0;
        if (this.initialUnitsDistance != null) {
            index = this.initialUnitsDistance.getIndex() - DISTANCE_OFFSET + 1;
            if (index < 0) {
                index = 0;
            }
            if (index >= this.unitsDistance.getItemCount()) {
                index = this.unitsDistance.getItemCount() - 1;
            }
        }
        this.unitsDistance.setSelectedIndex(index);
        this.units.remove(this.unitsResistance);
        this.units.remove(this.labelResistance);
        this.units.remove(this.unitsCapacitance);
        this.units.remove(this.labelCapacitance);
        this.units.remove(this.unitsInductance);
        this.units.remove(this.labelInductance);
        this.units.remove(this.unitsCurrent);
        this.units.remove(this.labelCurrent);
        this.units.remove(this.unitsVoltage);
        this.units.remove(this.labelVoltage);
        this.units.remove(this.unitsTime);
        this.units.remove(this.labelTime);
    }

    @Override
    public void term() {
        int distanceIndex = this.unitsDistance.getSelectedIndex();
        TextUtils.UnitScale currentDistance = null;
        if (distanceIndex != 0) {
            currentDistance = TextUtils.UnitScale.findFromIndex(distanceIndex + DISTANCE_OFFSET - 1);
        }
        if (currentDistance != this.initialUnitsDistance) {
            User.setDistanceUnits(currentDistance);
        }
    }

    @Override
    public void reset() {
        if (User.getFactoryDistanceUnits() != User.getDistanceUnits()) {
            User.setDistanceUnits(User.getFactoryDistanceUnits());
        }
    }

    private void initComponents() {
        this.units = new JPanel();
        this.labelDistance = new JLabel();
        this.unitsDistance = new JComboBox();
        this.labelResistance = new JLabel();
        this.unitsResistance = new JComboBox();
        this.labelCapacitance = new JLabel();
        this.unitsCapacitance = new JComboBox();
        this.labelInductance = new JLabel();
        this.unitsInductance = new JComboBox();
        this.labelCurrent = new JLabel();
        this.unitsCurrent = new JComboBox();
        this.labelVoltage = new JLabel();
        this.unitsVoltage = new JComboBox();
        this.labelTime = new JLabel();
        this.unitsTime = new JComboBox();
        this.jLabel66 = new JLabel();
        this.jLabel1 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                UnitsTab.this.closeDialog(evt);
            }
        });
        this.units.setLayout(new GridBagLayout());
        this.labelDistance.setText("Distance:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.labelDistance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsDistance, gridBagConstraints);
        this.labelResistance.setText("Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.labelResistance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsResistance, gridBagConstraints);
        this.labelCapacitance.setText("Capacitance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.labelCapacitance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsCapacitance, gridBagConstraints);
        this.labelInductance.setText("Inductance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.labelInductance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsInductance, gridBagConstraints);
        this.labelCurrent.setText("Current:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.labelCurrent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsCurrent, gridBagConstraints);
        this.labelVoltage.setText("Voltage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.labelVoltage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsVoltage, gridBagConstraints);
        this.labelTime.setText("Time:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.labelTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.units.add((Component)this.unitsTime, gridBagConstraints);
        this.jLabel66.setText("When real units are specified,");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.units.add((Component)this.jLabel66, gridBagConstraints);
        this.jLabel1.setText("they are used in display and in dialogs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.units.add((Component)this.jLabel1, gridBagConstraints);
        this.getContentPane().add((Component)this.units, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

