/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ManipulatePorts
extends EDialog
implements HighlightListener,
DatabaseChangeListener {
    private static final String[] columnNames = new String[]{"Check", "Name", "Characteristic", "Connections", "Arcs", "Exports"};
    private static int sortColumn = 1;
    private static boolean sortAscending = true;
    private PortsTable portTable;
    private ColumnListener columnListener;
    private NodeInst currentNode;
    private List<Export> exportsOnNode = new ArrayList<Export>();
    private JButton deleteExports;
    private JButton deselectAll;
    private JButton done;
    private JButton highlightPorts;
    private JSeparator jSeparator1;
    private JScrollPane portPane;
    private JButton reExportPorts;
    private JButton selectAll;
    private JButton showPorts;
    private JLabel title;
    private JButton toggleSelection;

    public static void showDialog() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter h = wnd.getHighlighter();
        NodeInst ni = (NodeInst)h.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        new ManipulatePorts((Frame)TopLevel.getCurrentJFrame(), ni);
    }

    private ManipulatePorts(Frame parent, NodeInst ni) {
        super(parent, false);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.done);
        this.portTable = new PortsTable(ni);
        JTableHeader header = this.portTable.getTableHeader();
        this.columnListener = new ColumnListener();
        header.addMouseListener(this.columnListener);
        this.portPane.setViewportView(this.portTable);
        this.finishInitialization();
        this.setVisible(true);
        UserInterfaceMain.addDatabaseChangeListener(this);
        Highlighter.addHighlightListener(this);
    }

    @Override
    public void highlightChanged(Highlighter h) {
        List<Geometric> geoms = h.getHighlightedEObjs(true, false);
        if (geoms.size() != 1) {
            this.portTable.loadPorts(null);
        } else {
            NodeInst ni = (NodeInst)geoms.get(0);
            this.portTable.loadPorts(ni);
        }
    }

    @Override
    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        boolean changed = false;
        if (e.objectChanged(this.currentNode)) {
            changed = true;
        }
        for (Export ex : this.exportsOnNode) {
            if (!e.objectChanged(ex)) continue;
            changed = true;
        }
        if (changed) {
            this.portTable.loadPorts(this.currentNode);
        }
    }

    @Override
    protected void escapePressed() {
        this.doneActionPerformed(null);
    }

    private void initComponents() {
        this.done = new JButton();
        this.title = new JLabel();
        this.portPane = new JScrollPane();
        this.selectAll = new JButton();
        this.deselectAll = new JButton();
        this.reExportPorts = new JButton();
        this.jSeparator1 = new JSeparator();
        this.deleteExports = new JButton();
        this.showPorts = new JButton();
        this.toggleSelection = new JButton();
        this.highlightPorts = new JButton();
        this.setTitle("Manipulate Ports");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ManipulatePorts.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.doneActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.title.setText("Ports on node");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.title, gridBagConstraints);
        this.portPane.setMinimumSize(new Dimension(200, 200));
        this.portPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.portPane, gridBagConstraints);
        this.selectAll.setText("Check All Ports");
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.selectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.selectAll, gridBagConstraints);
        this.deselectAll.setText("Uncheck All Ports");
        this.deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.deselectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.deselectAll, gridBagConstraints);
        this.reExportPorts.setText("ReExport Checked Ports");
        this.reExportPorts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.reExportPortsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.reExportPorts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.deleteExports.setText("Delect Exports on Checked Ports");
        this.deleteExports.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.deleteExportsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.deleteExports, gridBagConstraints);
        this.showPorts.setText("Show Checked Ports");
        this.showPorts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.showPortsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showPorts, gridBagConstraints);
        this.toggleSelection.setText("Toggle Check");
        this.toggleSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.toggleSelectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.toggleSelection, gridBagConstraints);
        this.highlightPorts.setText("Highlight Checked Ports");
        this.highlightPorts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManipulatePorts.this.highlightPortsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.highlightPorts, gridBagConstraints);
        this.pack();
    }

    private void toggleSelectionActionPerformed(ActionEvent evt) {
        this.portTable.toggleChecks();
    }

    private void showPortsActionPerformed(ActionEvent evt) {
        this.portTable.showChecked();
    }

    private void deleteExportsActionPerformed(ActionEvent evt) {
        this.portTable.unExportChecked();
    }

    private void reExportPortsActionPerformed(ActionEvent evt) {
        this.portTable.reExportChecked();
    }

    private void deselectAllActionPerformed(ActionEvent evt) {
        this.portTable.uncheckAll();
    }

    private void selectAllActionPerformed(ActionEvent evt) {
        this.portTable.checkAll();
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        JTableHeader header = this.portTable.getTableHeader();
        header.removeMouseListener(this.columnListener);
        UserInterfaceMain.removeDatabaseChangeListener(this);
        Highlighter.removeHighlightListener(this);
        this.dispose();
    }

    private void highlightPortsActionPerformed(ActionEvent evt) {
        this.portTable.highlightChecked();
    }

    private class PortEntry {
        private boolean selected;
        private PortInst pi;

        public PortEntry(PortInst pi) {
            this.pi = pi;
        }

        public PortInst getPort() {
            return this.pi;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean s2) {
            this.selected = s2;
        }

        public String getConnections(NodeInst ni) {
            ArcProto[] conns = this.pi.getPortProto().getBasePort().getConnections();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < conns.length; ++i) {
                if (conns[i].getTechnology() == Generic.tech() && ni.getProto().getTechnology() != Generic.tech()) continue;
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(conns[i].getName());
            }
            return buf.toString();
        }

        public int getNumArcs() {
            int num = 0;
            Iterator<Connection> it = this.pi.getNodeInst().getConnections();
            while (it.hasNext()) {
                Connection con = it.next();
                if (con.getPortInst() != this.pi) continue;
                ++num;
            }
            return num;
        }

        public String getExports() {
            StringBuffer buf = new StringBuffer();
            Iterator<Export> it = this.pi.getNodeInst().getExports();
            while (it.hasNext()) {
                Export e = it.next();
                if (e.getOriginalPort() != this.pi) continue;
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(e.getName());
            }
            return buf.toString();
        }
    }

    private class PortTableModel
    extends AbstractTableModel {
        private NodeInst ni;
        private List<PortEntry> ports;

        private PortTableModel(NodeInst ni) {
            this.ni = ni;
            this.ports = new ArrayList<PortEntry>();
        }

        public void clearAll() {
            this.ports.clear();
        }

        public void newVar(PortInst pi) {
            PortEntry ve = new PortEntry(pi);
            this.ports.add(ve);
        }

        public void sortTable() {
            Collections.sort(this.ports, new PortEntrySort());
            this.fireTableDataChanged();
        }

        public void checkAll() {
            int i = 0;
            for (PortEntry pe : this.ports) {
                pe.setSelected(true);
                this.fireTableCellUpdated(i++, 0);
            }
        }

        public void uncheckAll() {
            int i = 0;
            for (PortEntry pe : this.ports) {
                pe.setSelected(false);
                this.fireTableCellUpdated(i++, 0);
            }
        }

        public void reExportChecked() {
            ArrayList<PortInst> queuedExports = new ArrayList<PortInst>();
            for (PortEntry pe : this.ports) {
                if (!pe.isSelected()) continue;
                queuedExports.add(pe.getPort());
            }
            new ExportChanges.ReExportPorts(this.ni.getParent(), queuedExports, true, true, true, false, User.isIncrementRightmostIndex(), null);
        }

        public void unExportChecked() {
            ArrayList<Export> queuedExports = new ArrayList<Export>();
            for (PortEntry pe : this.ports) {
                if (!pe.isSelected()) continue;
                Iterator<Export> eIt = pe.getPort().getExports();
                while (eIt.hasNext()) {
                    Export e = eIt.next();
                    queuedExports.add(e);
                }
            }
            ExportChanges.deleteExports(this.ni.getParent(), queuedExports);
        }

        public void showChecked() {
            ArrayList<PortInst> portList = new ArrayList<PortInst>();
            for (PortEntry pe : this.ports) {
                if (!pe.isSelected()) continue;
                portList.add(pe.getPort());
            }
            ExportChanges.showPorts(portList);
        }

        public void highlightChecked() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            wnd.clearHighlighting();
            for (PortEntry pe : this.ports) {
                if (!pe.isSelected()) continue;
                wnd.addElectricObject(pe.getPort(), this.ni.getParent());
            }
            wnd.finishedHighlighting();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public int getRowCount() {
            return this.ports.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PortEntry pe = this.ports.get(rowIndex);
            if (pe == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return pe.isSelected();
                }
                case 1: {
                    return pe.getPort().getPortProto().getName();
                }
                case 2: {
                    return pe.getPort().getPortProto().getCharacteristic().getName();
                }
                case 3: {
                    return pe.getConnections(this.ni);
                }
                case 4: {
                    return Integer.toString(pe.getNumArcs());
                }
                case 5: {
                    return pe.getExports();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            String colName = columnNames[col];
            if (col == sortColumn) {
                colName = sortAscending ? colName + " \u21d3" : colName + " \u21d1";
            }
            return colName;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            PortEntry ve = this.ports.get(row);
            if (ve == null) {
                return;
            }
            if (col != 0) {
                return;
            }
            Boolean b = (Boolean)aValue;
            if (ve.isSelected() != b.booleanValue()) {
                ve.setSelected(b);
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        private class PortEntrySort
        implements Comparator<PortEntry> {
            private PortEntrySort() {
            }

            @Override
            public int compare(PortEntry p1, PortEntry p2) {
                if (!sortAscending) {
                    PortEntry swap = p1;
                    p1 = p2;
                    p2 = swap;
                }
                String s1 = null;
                String s2 = null;
                switch (sortColumn) {
                    case 0: {
                        boolean b1 = p1.isSelected();
                        boolean b2 = p2.isSelected();
                        if (b1 == b2) {
                            return 0;
                        }
                        if (b1) {
                            return 1;
                        }
                        return -1;
                    }
                    case 1: {
                        s1 = p1.getPort().getPortProto().getName();
                        s2 = p2.getPort().getPortProto().getName();
                        break;
                    }
                    case 2: {
                        s1 = p1.getPort().getPortProto().getCharacteristic().getName();
                        s2 = p2.getPort().getPortProto().getCharacteristic().getName();
                        return s1.compareTo(s2);
                    }
                    case 3: {
                        s1 = p1.getConnections(PortTableModel.this.ni);
                        s2 = p2.getConnections(PortTableModel.this.ni);
                        break;
                    }
                    case 4: {
                        int i1 = p1.getNumArcs();
                        int i2 = p2.getNumArcs();
                        if (i1 == 12) {
                            return 0;
                        }
                        if (i1 < i2) {
                            return 1;
                        }
                        return -1;
                    }
                    case 5: {
                        s1 = p1.getExports();
                        s2 = p2.getExports();
                    }
                }
                return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
            }
        }
    }

    private class PortsTable
    extends JTable {
        private PortTableModel model;

        public PortsTable(NodeInst ni) {
            this.model = new PortTableModel(ni);
            this.setModel(this.model);
            TableColumn tc = this.getColumn(this.getColumnName(0));
            if (tc != null) {
                tc.setPreferredWidth(60);
            }
            if ((tc = this.getColumn(this.getColumnName(1))) != null) {
                tc.setPreferredWidth(120);
            }
            if ((tc = this.getColumn(this.getColumnName(2))) != null) {
                tc.setPreferredWidth(100);
            }
            if ((tc = this.getColumn(this.getColumnName(3))) != null) {
                tc.setPreferredWidth(90);
            }
            if ((tc = this.getColumn(this.getColumnName(4))) != null) {
                tc.setPreferredWidth(50);
            }
            if ((tc = this.getColumn(this.getColumnName(5))) != null) {
                tc.setPreferredWidth(120);
            }
            this.loadPorts(ni);
        }

        public void loadPorts(NodeInst ni) {
            ManipulatePorts.this.currentNode = ni;
            ManipulatePorts.this.exportsOnNode.clear();
            this.model.clearAll();
            if (ni == null) {
                ManipulatePorts.this.title.setText("Port list (no selected node)");
            } else {
                ManipulatePorts.this.title.setText("Ports on node " + ni.describe(false));
                Iterator<ElectricObject> it = ni.getExports();
                while (it.hasNext()) {
                    ManipulatePorts.this.exportsOnNode.add(it.next());
                }
                it = ni.getPortInsts();
                while (it.hasNext()) {
                    PortInst pi = (PortInst)it.next();
                    this.model.newVar(pi);
                }
            }
            this.model.sortTable();
        }

        public void toggleChecks() {
            int[] rows = this.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                Boolean b = (Boolean)this.model.getValueAt(rows[i], 0);
                this.model.setValueAt(b == false, rows[i], 0);
            }
        }

        @Override
        public PortTableModel getModel() {
            return this.model;
        }

        public void checkAll() {
            this.model.checkAll();
        }

        public void uncheckAll() {
            this.model.uncheckAll();
        }

        public void reExportChecked() {
            this.model.reExportChecked();
        }

        public void unExportChecked() {
            this.model.unExportChecked();
        }

        public void showChecked() {
            this.model.showChecked();
        }

        public void highlightChecked() {
            this.model.highlightChecked();
        }
    }

    private class ColumnListener
    extends MouseAdapter {
        private ColumnListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int colNumber;
            TableColumnModel colModel = ManipulatePorts.this.portTable.getColumnModel();
            int modelIndex = colModel.getColumn(colNumber = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (sortColumn == modelIndex) {
                sortAscending = !sortAscending;
            } else {
                sortColumn = modelIndex;
                sortAscending = true;
            }
            PortTableModel model = ManipulatePorts.this.portTable.getModel();
            model.sortTable();
            model.fireTableStructureChanged();
        }
    }
}

