<-- This file is part 22 of the GNU version of
    The Collaborative International Dictionary of English (GCIDE)

    Copyright (C) 1992-2012 Patrick J. Cassidy
    Copyright (C) 2012-2024 Sergey Poznyakoff

    GCIDE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3, or (at your option)
    any later version.

    GCIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this copy of GCIDE.  If not, see <http://www.gnu.org/licenses/>.
-->

<p><centered><point26>V.</point26></centered><br/
[<source>1913 Webster</source>]</p>

<p><ent>V</ent><br/
<hw>V</hw> <pr>(v<emac/)</pr>. <sn>1.</sn> <def>V, the twenty-second
letter of the English alphabet, is a vocal consonant. V and U are only
varieties of the same character, U being the cursive form, while V is
better adapted for engraving, as in stone. The two letters were formerly
used indiscriminately, and till a comparatively recent date words
containing them were often classed together in dictionaries and other
books of reference (see <er>U</er>). The letter V is from the Latin
alphabet, where it was used both as a consonant (about like English
<it>w</it>) and as a vowel. The Latin derives it from a form (V) of the
Greek vowel <UPSILON/ (see <er>Y</er>), this Greek letter being either
from the same Semitic letter as the digamma <universbold>F</universbold>
(see <er>F</er>), or else added by the Greeks to the alphabet which they
took from the Semitic. Etymologically <xex>v</xex> is most nearly
related to <xex>u</xex>, <xex>w</xex>, <xex>f</xex>, <xex>b</xex>,
<xex>p</xex>; as in <xex>v</xex>ine, <xex>w</xex>ine;
a<xex>v</xex>oirdupois, ha<xex>b</xex>it, ha<xex>v</xex>e;
sa<xex>f</xex>e, sa<xex>v</xex>e; tro<xex>v</xex>er,
trou<xex>b</xex>adour, tro<xex>p</xex>e. See U, F, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p>See <xex>Guide to Pronunciation</xex>, <sect/ 265; also <sect/<sect/
155, 169, 178-179, etc.<br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>As a numeral, V stands for five, in English and
Latin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaagmer</ent><br/
<hw>Vaag"mer</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Icel.
<ets>v<amac/gmeri</ets> a kind of flounder, literally, wave mare.]</ety>
<fld>(Zool.)</fld> <def>The dealfish.</def> <altsp>[Written also
<asp>vaagmaer</asp>, and <asp>vaagmar</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacancy</ent><br/
<hw>Va"can*cy</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vacancies</plw> <pr>(#)</pr>.</plu> <ety>[Cf. F.
<ets>vacance</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The quality or state of being vacant; emptiness;
hence, freedom from employment; intermission; leisure; idleness;
listlessness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>All dispositions to idleness or <qex>vacancy</qex>, even before
they are habits, are dangerous.</q> <rj><qau>Sir H.
Wotton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is vacant.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>Empty space; vacuity; vacuum.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>How is't with you,<br/
That you do bend your eye on <qex>vacancy</qex>?</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>An open or unoccupied space between bodies or
things; an interruption of continuity; chasm; gap; <as>as, a
<ex>vacancy</ex> between buildings; a <ex>vacancy</ex> between sentences
or thoughts</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>Unemployed time; interval of leisure; time of
intermission; vacation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Time lost partly in too oft idle <qex>vacancies</qex> given both
to schools and universities.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>No interim, not a minute's <qex>vacancy</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Those little <qex>vacancies</qex> from toil are sweet.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <def>A place or post unfilled; an unoccupied office;
<as>as, a <ex>vacancy</ex> in the senate, in a school, etc.</as></def>
<-- an unrented apartment, room in a hotel, motel, etc. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacant</ent><br/
<hw>Va"cant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F., fr. L.
<ets>vacans</ets>, <ets>-antis</ets>, p. pr. of <ets>vacare</ets> to be
empty, to be free or unoccupied, to have leisure, also
<ets>vocare</ets>; akin to <ets>vacuus</ets> empty, and probably to E.
<ets>void</ets>. Cf. <er>Evacuate</er>, <er>Void</er>,
<pos>a.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Deprived of contents; not filled; empty; <as>as, a
<ex>vacant</ex> room</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Stuffs out his <qex>vacant</qex> garments with his form.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Being of those virtues <qex>vacant</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>There is no fireside, howsoe'er defended,<br/
But has one <qex>vacant</qex> chair.</q>
<rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Unengaged with business or care; unemployed;
unoccupied; disengaged; free; <as>as, <ex>vacant</ex>
hours</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Religion is the interest of all; but philosophy of those . . . at
leisure, and <qex>vacant</qex> from the affairs of the world.</q>
<rj><qau>Dr. H. More.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>There was not a minute of the day which he left
<qex>vacant</qex>.</q> <rj><qau>Bp. Fell.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Not filled or occupied by an incumbent, possessor,
or officer; unoccupied; <as>as, a <ex>vacant</ex> throne; a
<ex>vacant</ex> house; a <ex>vacant</ex> apartment; a <ex>vacant</ex>
parish</as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><q>Special dignities which <qex>vacant</qex> lie<br/
For thy best use and wearing.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Empty of thought; thoughtless; not occupied with
study or reflection; <as>as, a <ex>vacant</ex> mind</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The duke had a pleasant and <qex>vacant</qex> face.</q>
<rj><qau>Sir H. Wotton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>When on my couch I lie<br/
In <qex>vacant</qex> or in pensive mood.</q>
<rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Law)</fld> <def>Abandoned; having no heir,
possessor, claimant, or occupier; <as>as, a <ex>vacant</ex>
estate</as>.</def> <rj><au>Bouvier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vacant succession</b></col> <fld>(Law)</fld>, <cd>one
that is claimed by no person, or where all the heirs are unknown, or
where all the known heirs to it have renounced it.</cd>
<rj><au>Burrill.</au></rj> </cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Empty; void; devoid; free; unemployed;
disengaged; unincumbered; uncrowded; idle.</syn> <usage> --
<er>Vacant</er>, <er>Empty</er>. A thing is <xex>empty</xex> when there
is nothing in it; <as>as, an <ex>empty</ex> room, or an <ex>empty</ex>
noddle</as>. <xex>Vacant</xex> adds the idea of having been previously
filled, or intended to be filled or occupied; <as>as, a <ex>vacant</ex>
seat at table; a <ex>vacant</ex> office; <ex>vacant</ex> hours</as>.
When we speak of a <xex>vacant</xex> look or a <xex>vacant</xex> mind,
we imply the absence of the intelligence naturally to be expected
there.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacantly</ent><br/
<hw>Va"cant*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a vacant
manner; inanely.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacate</ent><br/
<hw>Va"cate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Vacated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vacating</conjf>.]</vmorph> <ety>[L. <ets>vacare</ets>,
<ets>vacatum</ets>, to be empty. See <er>Vacant</er>.]</ety> <sn>1.</sn>
<def>To make vacant; to leave empty; to cease from filling or occupying;
<as>as, it was resolved by Parliament that <persfn>James</persfn> had
<ex>vacated</ex> the throne of England; the tenant <ex>vacated</ex> the
house.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To annul; to make void; to deprive of force; to make
of no authority or validity; <as>as, to <ex>vacate</ex> a commission or
a charter; to <ex>vacate</ex> proceedings in a cause.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>That after act <qex>vacating</qex> the authority of the
precedent.</q> <rj><qau>Eikon Basilike.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The necessity of observing the Jewish Sabbath was
<qex>vacated</qex> by the apostolical institution of the Lord's Day.</q>
<rj><qau>R. Nelson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To defeat; to put an end to.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>vacates</qex> my revenge.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacation</ent><br/
<hw>Va*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L.
<ets>vacatio</ets> a being free from a duty, service, etc., fr.
<ets>vacare</ets>. See <er>Vacate</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The act of vacating; a making void or of no force;
<as>as, the <ex>vacation</ex> of an office or a charter</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Intermission of a stated employment, procedure, or
office; a period of intermission; rest; leisure.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It was not in his nature, however, at least till years had
chastened it, to take any <qex>vacation</qex> from controversy.</q>
<rj><qau>Palfrey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>Hence, specifically: -<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <fld>(Law)</fld> <def>Intermission of judicial
proceedings; the space of time between the end of one term and the
beginning of the next; nonterm; recess.</def> <ldquo/With lawyers in the
<xex>vacation</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>A period of intermission of regular paid work or
employment, or of studies and exercises at an educational institution;
the time during which a person temporarily ceases regular duties of any
kind and performs other activites, usually some form of liesure;
holidays; recess (at a school); <as>as, the spring <ex>vacation</ex>; to
spend one's <ex>vacation</ex> travelling; to paint the house while on
<ex>vacation</ex></as>. <ex>Vacation</ex> is typically used for rest,
travel, or recreation, but may be used for any purpose. In Britain this
sense of <ex>vacation</ex> is usually referred to as
<altname>holiday</altname>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sd>(c)</sd> <def>The time when an office is vacant;</def>
<specif>esp.</specif> <fld>(Eccl.)</fld>, <def>the time when a see, or
other spiritual dignity, is vacant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacatur</ent><br/
\'d8<hw>Va*ca"tur</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., it is made
void, fr. L. <ets>vacare</ets> to be empty. See <er>Vacant</er>.]</ety>
<fld>(Law)</fld> <def>An order of court by which a proceeding is set
aside or annulled.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vaccary</ent><br/
<hw>Vac"ca*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL.
<ets>vaccarium</ets>, from L. <ets>vacca</ets> cow. Cf.
<er>Vachery</er>.]</ety> <def>A cow house, dairy house, or cow
pasture.</def> <mark>[Obs. or Prov. Eng.]</mark>
<rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaccina</ent><br/
\'d8<hw>Vac*ci"na</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.]</ety>
<fld>(Med.)</fld> <def>Vaccinia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaccinal</ent><br/
<hw>Vac"ci*nal</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Med.)</fld>
<def>Of or pertaining to vaccinia or vaccination.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaccinate</ent><br/
<hw>Vac"ci*nate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vaccinated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vaccinating</conjf>.]</vmorph> <ety>[See
<er>Vaccine</er>.]</ety> <def>To inoculate with the cowpox by means of a
virus, called <xex>vaccine</xex>, taken either directly or indirectly
from cows; now, generally, to administer (by injection or otherwise) any
vaccine with the objective of rendering the recipient immune to an
infectious disease. One who has been thus immunized by vaccination is
said to be <col>vaccinated against</col> a particular disease. One may
be thus immunized (vaccinated) also by oral ingestion or inhalation of a
vaccine.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Vaccination</ent><br/
<hw>Vac`ci*na"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
act, art, or practice of vaccinating, or inoculating with the cowpox, in
order to prevent or mitigate an attack of smallpox. Cf.
<er>Inoculation</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In recent use, <xex>vaccination</xex> sometimes includes
inoculation with any virus as a preventive measure; <as>as,
<ex>vaccination</ex> against cholera</as>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any inoculation intended to raise immunity to a
disease.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vaccinator</ent><br/
<hw>Vac"ci*na`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that
which, vaccinates.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaccine</ent><br/
<hw>Vac"cine</hw> <pr>(v<acr/k"s<imac/n <it>or</it> v<acr/k"s<icr/n;
277)</pr>, <pos>a.</pos> <ety>[L. <ets>vaccinus</ets>, fr.
<ets>vacca</ets> a cow; cf. Skr. <ets>v<amac/<cced/</ets> to bellow, to
groan.]</ety> <sn>1.</sn> <def>Of or pertaining to cows; pertaining to,
derived from, or caused by, vaccinia; <as>as, <ex>vaccine</ex> virus;
the <ex>vaccine</ex> disease</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to a vaccine or
vaccination.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vaccine</ent><br/
<hw>Vac"cine</hw> <pr>(v<acr/k*s<emac/n" <it>or</it>
v<acr/k"s<emac/n)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The virus of
vaccinia used in vaccination.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>any preparation used to render an organism immune to
some disease, by inducing or increasing the natural immunity mechanisms.
Prior to 1995, such preparations usually contained killed organisms of
the type for which immunity was desired, and sometimes used live
organisms having attenuated virulence. Since that date, preparations
containing only specific antigenic portions of the pathogenic organism
have also been used. Some of these are prepared by genetic engineering
techniques.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <fld>(Computers)</fld> <def>A program designed to protect
a computer from software viruses, by detecting and or eliminating
them.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vaccine point</ent><br/
<hw>Vac"cine point`</hw> <pr>(?)</pr>. <fld>(Med.)</fld> <def>See
<er>Point</er>, <pos>n.</pos>, 26.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vaccinia</ent><br/
\'d8<hw>Vac*cin"i*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See
<er>Vaccine</er>.]</ety> <fld>(Med.)</fld> <def>Cowpox; vaccina. See
<er>Cowpox</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaccinist</ent><br/
<hw>Vac"ci*nist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A
vaccinator.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaccinium</ent><br/
\'d8<hw>Vac*cin"i*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., the
blueberry, or whortleberry.]</ety> <fld>(Bot.)</fld> <def>A genus of
ericaceous shrubs including the various kinds of blueberries and the
true cranberries.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacher</ent><br/
\'d8<hw>Va`cher"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., from
<ets>vache</ets> a cow. Cf. <er>Vaquero</er>.]</ety> <def>A keeper of
stock or cattle; a herdsman.</def> <mark>[Southwestern U. S.]</mark><--
a cowboy --> <rj><au>Bartlett.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vachery</ent><br/
<hw>Vach"er*y</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vacherie</ets>, from <ets>vache</ets> a cow, L. <ets>vacca</ets>.
Cf. <er>Vaccary</er>.]</ety> <sn>1.</sn> <def>An inclosure for
cows.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A dairy.</def> <mark>[Obs. or Prov. Eng.]</mark>
<rj><au>Prompt. Parv.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vachette clasp</ent><br/
<hw>Va`chette" clasp</hw> <pr>(?)</pr>. <ety>[Cf. F. <ets>vachette</ets>
cowhide leather used for ligatures.]</ety> <fld>(Veter.)</fld> <def>A
piece of strong steel wire with the ends curved and pointed, used on toe
or quarter cracks to bind the edges together and prevent motion. It is
clasped into two notches, one on each side of the crack, burned into the
wall with a cautery iron.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vacillancy</ent><br/
<hw>Vac"il*lan*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being vacillant, or wavering.</def> <mark>[R.]</mark>
<rj><au>Dr. H. More.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacillant</ent><br/
<hw>Vac"il*lant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vacillans</ets>, p. pr. of <ets>vacillare</ets>: cf. F.
<ets>vacillant</ets>. See <er>Vacillate</er>.]</ety> <def>Vacillating;
wavering; fluctuating; irresolute.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacillate</ent><br/
<hw>Vac"il*late</hw> <pr>(v<acr/s"<icr/l*l<amac/t)</pr>, <pos>v.
i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Vacillated</conjf>
<pr>(v<acr/s"<icr/l*l<amac/`t<ecr/d)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vacillating</conjf>.]</vmorph> <ety>[L. <ets>vacillare</ets>,
<ets>vacillatum</ets>; cf. Skr. <ets>va<ntil/c</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To move one way and the other; to reel or stagger;
to waver.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[A spheroid] is always liable to shift and
<qex>vacillate</qex>from one axis to another.</q>
<rj><qau>Paley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To fluctuate in mind or opinion; to be unsteady or
inconstant; to waver.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- See <er>Fluctuate</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacillating</ent><br/
<hw>Vac"il*la`ting</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Inclined to
fluctuate; wavering.</def> <au>Tennyson.</au> --
<wordforms><wf>Vac"il*la`ting*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacillation</ent><br/
<hw>Vac`il*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vacillatio</ets>: cf. F. <ets>vacillation</ets>.]</ety> <sn>1.</sn>
<def>The act of vacillating; a moving one way and the other; a
wavering.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His <qex>vacillations</qex>, always exhibited most pitiably in
emergencies.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Unsteadiness of purpose; changeableness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There is a <qex>vacillation</qex>, or an alternation of knowledge
and doubt.</q> <rj><qau>Jer. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacillatory</ent><br/
<hw>Vac"il*la*to*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Inclined to
vacillate; wavering; irresolute.</def> <rj><au>Hawthorne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuate</ent><br/
<hw>Vac"u*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L.
<ets>vacuatus</ets>, p. p. of <ets>vacuare</ets> to empty, from
<ets>vacuus</ets> empty. See <er>Vacant</er>.]</ety> <def>To make void,
or empty.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuation</ent><br/
<hw>Vac`u*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of
emptying; evacuation.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuist</ent><br/
<hw>Vac"u*ist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vacuiste</ets>.]</ety> <def>One who holds the doctrine that the
space between the bodies of the universe, or the molecules and atoms of
matter, is a vacuum; -- opposed to <contr>plenist</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuity</ent><br/
<hw>Va*cu"i*ty</hw> <pr>(v<adot/*k<umac/"<icr/*t<ycr/)</pr>,
<pos>n.</pos> <ety>[L. <ets>vacuitas</ets>. See <er>Vacuous</er>.]</ety>
<sn>1.</sn> <def>The quality or state of being vacuous, or not filled;
emptiness; vacancy; <as>as, <ex>vacuity</ex> of mind; <ex>vacuity</ex>
of countenance</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Hunger is such a state of <qex>vacuity</qex> as to require a fresh
supply of aliment.</q> <rj><qau>Arbuthnot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Space unfilled or unoccupied, or occupied with an
invisible fluid only; emptiness; void; vacuum.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>vacuity</qex> is interspersed among the particles of
matter.</q> <rj><qau>Bentley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>God . . . alone can answer all our longings and fill every
<qex>vacuity</qex> of our soul.</q> <rj><qau>Rogers.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Want of reality; inanity; nihility.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Their expectations will meet with <qex>vacuity</qex>.</q>
<rj><qau>Glanvill.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuna</ent><br/
\'d8<hw>Va*cu"na</hw> <pr>(v<adot/*k<umac/"n<adot/)</pr>, <pos>prop.
n.</pos> <ety>[L. fr. <ets>vacuus</ets> unoccupied.]</ety> <fld>(Rom.
Myth.)</fld> <def>The goddess of rural leisure, to whom the husbandmen
sacrificed at the close of the harvest. She was especially honored by
the Sabines.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuolated</ent><br/
<hw>Vac"u*o*la`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Biol.)</fld>
<def>Full of vacuoles, or small air cavities; <as>as,
<ex>vacuolated</ex> cells</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuolation</ent><br/
<hw>Vac"u*o*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Biol.)</fld>
<def>Formation into, or multiplication of, vacuoles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuole</ent><br/
<hw>Vac"u*ole</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vacuus</ets> empty: cf. F. <ets>vacuole</ets>.]</ety>
<fld>(Biol.)</fld> <def>A small air cell, or globular space, in the
interior of organic cells, either containing air, or a pellucid watery
liquid, or some special chemical secretions of the cell
protoplasm.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Contractile vacuole</b></col>. <fld>(Zool.)</fld> <cd>See
under <er>Contractile</er>, and see <xex>Illusts</xex>. of
<er>Infusoria</er>, and <er>Lobosa</er>.</cd> -- <col><b>Food
vacuole</b></col>. <fld>(Zool.)</fld> <cd>See under <er>Food</er>, and
see <xex>Illust.</xex> of <er>Infusoria</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuometer</ent><br/
<hw>Vac`u*om"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Vacuum</ets> + <ets>-meter</ets>.]</ety> <fld>(Physics)</fld>
<sd>(a)</sd> <def>An instrument for the comparison of barometers.</def>
<sd>(b)</sd> <def>An apparatus for the measurement of low
pressures.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vacuous</ent><br/
<hw>Vac"u*ous</hw> <pr>(v<acr/k"<usl/*<ucr/s)</pr>, <pos>a.</pos>
<ety>[L. <ets>vacuus</ets>. See <er>Vacant</er>.]</ety> <def>Empty;
unfilled; void; vacant.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Boundless the deep, because I am who fill<br/
Infinitude; nor <qex>vacuous</qex> the space.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>That the few may lead selfish and <qex>vacuous</qex> days.</q>
<rj><qau>J. Morley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuousness</ent><br/
<hw>Vac"u*ous*ness</hw>, <pos>n.</pos> <def>The quality or state of
being vacuous; emptiness; vacuity.</def> <rj><au>W.
Montagu.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuum</ent><br/
<hw>Vac"u*um</hw> <pr>(v<acr/k"<usl/*<ucr/m)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> E. <plw>Vacuums</plw>
<pr>(v<acr/k"<usl/*<ucr/mz)</pr>, L. <plw>Vacua</plw>
<pr>(v<acr/k"<usl/*<adot/)</pr>.</plu> <ety>[L., fr. <ets>vacuus</ets>
empty. See <er>Vacuous</er>.]</ety> <sn>1.</sn> <fld>(Physics)</fld>
<def>A space entirely devoid of matter (called also, by way of
distinction, <xex>absolute vacuum</xex>); hence, in a more general
sense, a space, as the interior of a closed vessel, which has been
exhausted to a high or the highest degree by an air pump or other
artificial means; <as>as, water boils at a reduced temperature in a
<ex>vacuum</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1591 pr=PI--><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The condition of rarefaction, or reduction of
pressure below that of the atmosphere, in a vessel, as the condenser of
a steam engine, which is nearly exhausted of air or steam, etc.; <as>as,
a <ex>vacuum</ex> of 26 inches of mercury, or 13 pounds per square
inch</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vacuum brake</b></col>, <cd>a kind of continuous brake
operated by exhausting the air from some appliance under each car, and
so causing the pressure of the atmosphere to apply the brakes.</cd> --
<col><b>Vacuum pan</b></col> <fld>(Technol.)</fld>, <cd>a kind of large
closed metallic retort used in sugar making for boiling down sirup. It
is so connected with an exhausting apparatus that a partial vacuum is
formed within. This allows the evaporation and concentration to take
place at a lower atmospheric pressure and hence also at a lower
temperature, which largely obviates the danger of burning the sugar, and
shortens the process.</cd> -- <col><b>Vacuum pump</b></col>. <cd>Same as
<er>Pulsometer</er>, 1.</cd> -- <col><b>Vacuum tube</b></col>
<fld>(Phys.)</fld>, <sd>(a)</sd> <cd>a glass tube provided with platinum
electrodes and exhausted, for the passage of the electrical discharge; a
Geissler tube.</cd> <sd>(a)</sd> <cd>any tube used in electronic
devices, containing a vacuum and used to control the flow of electrons
in a circuit, as a vacuum diode, triode, tetrode, or pentode.</cd> --
<col><b>Vacuum valve</b></col>, <cd>a safety valve opening inward to
admit air to a vessel in which the pressure is less than that of the
atmosphere, in order to prevent collapse.</cd> -- <col><b>Torricellian
vacuum</b></col>. <cd>See under <er>Torricellian</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vacuum cleaner</ent><br/
<hw>Vac"u*um clean"er</hw>. <def>A machine for cleaning carpets,
tapestry, upholstered work, etc., by suction; -- sometimes called a
<altname>vacuum</altname>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vadantes</ent><br/
\'d8<hw>Va*dan"tes</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., from
L. <ets>vadans</ets>, p. pr. of <ets>vadare</ets> to wade, to
ford.]</ety> <fld>(Zool.)</fld> <def>An extensive artificial group of
birds including the wading, swimming, and cursorial birds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vade</ent><br/
<hw>Vade</hw> <pr>(v<amac/d)</pr>, <pos>v. i.</pos> <ety>[For
<ets>fade</ets>.]</ety> <def>To fade; hence, to vanish.</def>
<mark>[Obs.]</mark> <ldquo/ Summer leaves all <xex>vaded</xex>.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They into dust shall <qex>vade</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vade mecum</ent><br/
<hw>Va`de me"cum</hw> <pr>(?)</pr>. <ety>[L., go with me.]</ety> <def>A
book or other thing that a person carries with him as a constant
companion; a manual; a handbook.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vadimony</ent><br/
<hw>Vad"i*mo*ny</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vadimonium</ets>.]</ety> <fld>(Law)</fld> <def>A bond or pledge for
appearance before a judge on a certain day.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vadium</ent><br/
\'d8<hw>Va"di*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL., from L.
<ets>vas</ets>, <ets>vadis</ets>, bail.]</ety> <fld>(Law)</fld>
<def>Pledge; security; bail. See <er>Mortgage</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vadium vivum</b></col> <ety>[LL.]</ety> <fld>(Law)</fld>,
<cd>a living pledge, which exists where an estate is granted until a
debt is paid out of its proceeds.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vae</ent><br/
<hw>Vae</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Voe</er>.</def>
<mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vafrous</ent><br/
<hw>Va"frous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vafer</ets>.]</ety> <def>Crafty; cunning; sly; <as>as,
<ex>vafrous</ex> tricks</as>.</def> <mark>[Obs.]</mark>
<rj><au>Feltham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagabond</ent><br/
<hw>Vag"a*bond</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F., fr. L.
<ets>vagabundus</ets>, from <ets>vagari</ets> to stroll about, from
<ets>vagus</ets> strolling. See <er>Vague</er>.]</ety> <sn>1.</sn>
<def>Moving from place to place without a settled habitation;
wandering.</def> <ldquo/<xex>Vagabond</xex> exile.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Floating about without any certain direction; driven
to and fro.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To heaven their prayers<br/
Flew up, nor missed the way, by envious winds<br/
Blown <qex>vagabond</qex> or frustrate.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Being a vagabond; strolling and idle or
vicious.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagabond</ent><br/
<hw>Vag"a*bond</hw>, <pos>n.</pos> <def>One who wanders from place to
place, having no fixed dwelling, or not abiding in it, and usually
without the means of honest livelihood; a vagrant; a tramp; hence, a
worthless person; a rascal.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A fugitive and a <qex>vagabond</qex> shalt thou be.</q>
<rj><qau>Gen. iv. 12.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In English and American law, <xex>vagabond</xex> is used
in bad sense, denoting one who is without a home; a strolling, idle,
worthless person. <xex>Vagabonds</xex> are described in old English
statutes as <ldquo/such as wake on the night and sleep on the day, and
haunt customable taverns and alehouses, and routs about; and no man wot
from whence they came, nor whither they go.<rdquo/ In American law, the
term <xex>vagrant</xex> is employed in the same sense. Cf
<er>Rogue</er>, <pos>n.</pos>, 1. <rj><au>Burrill.</au>
<au>Bouvier.</au></rj> </note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagabond</ent><br/
<hw>Vag"a*bond</hw>, <pos>v. i.</pos> <def>To play the vagabond; to
wander like a vagabond; to stroll.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>On every part my <qex>vagabonding</qex> sight<br/
Did cast, and drown mine eyes in sweet delight.</q>
<rj><qau>Drummond.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagabondage</ent><br/
<hw>Vag"a*bond`age</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vagabondage</ets>.]</ety> <def>The condition of a vagabond; a state
or habit of wandering about in idleness; vagrancy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagabondism</ent><br/
<hw>Vag"a*bond`ism</hw> <pr>(?)</pr>, <pos>n.</pos>
<def>Vagabondage.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagabondize</ent><br/
<hw>Vag"a*bond`ize</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To play the
vagabond; to wander about in idleness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagabondry</ent><br/
<hw>Vag"a*bond`ry</hw> <pr>(?)</pr>, <pos>n.</pos>
<def>Vagabondage.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagal</ent><br/
<hw>Va"gal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Vagus</er>.]</ety> <fld>(Anat.)</fld> <def>Of or pertaining to the
vagus, or pneumogastric nerves; pneumogastric.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagancy</ent><br/
<hw>Va"gan*cy</hw> <pr>(v<amac/"g<ait/n*s<ycr/)</pr>, <pos>n.</pos>
<ety>[From L. <ets>vagans</ets>, p. pr. See <er>Vagantes</er>.]</ety>
<def>A wandering; vagrancy.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>A thousand <qex>vagancies</qex> of glory and delight.</q>
<rj><qau>Milton.</qau></rj><br/
<-- note -- in the original Webster, <i>delight</i> was misspelled
<i>desight</i>, a rare typographical error -->
[<source>1913 Webster</source>]</p>

<p><ent>Vagantes</ent><br/
\'d8<hw>Va*gan"tes</hw> <pr>(v<adot/*g<acr/n"t<emac/z)</pr>, <pos>prop.
n. pl.</pos> <ety>[NL., fr. L. <ets>vagans</ets>, p. pr. of
<ets>vagari</ets> to stroll or wander.]</ety> <fld>(Zool.)</fld> <def>A
tribe of spiders, comprising some of those which take their prey in a
web, but which also frequently run with agility, and chase and seize
their prey.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagarious</ent><br/
<hw>Va*ga"ri*ous</hw> <pr>(v<adot/*g<amac/"r<icr/*<ucr/s)</pr>,
<pos>a.</pos> <def>Given to, or characterized by, vagaries; capricious;
whimsical; crochety.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagary</ent><br/
<hw>Va*ga"ry</hw> <pr>(v<adot/*g<amac/"r<ycr/ or
v<acr/g"<adot/*r<esl/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vagaries</plw> <pr>(v<adot/*g<amac/"r<icr/z or
v<acr/g"<adot/*r<esl/z)</pr>.</plu> <ety>[L. <ets>vagari</ets> to stroll
about. See <er>Vague</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A wandering or strolling.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, a wandering of the thoughts; a wild or
fanciful freak; a whim; a whimsical purpose.</def> <ldquo/The
<xex>vagaries</xex> of a child.<rdquo/ <rj><au>Spectator.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They changed their minds,<br/
Flew off, and into strange <qex>vagaries</qex> fell.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagient</ent><br/
<hw>Va"gi*ent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vagiens</ets>, p. pr. of <ets>vagire</ets> to cry like a young
child.]</ety> <def>Crying like a child.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagina</ent><br/
<hw>Va*gi"na</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vaginae</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>vagina</ets> a
scabbard or sheath.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Anat.)</fld> <sd>(a)</sd> <def>A sheath; a theca;
<as>as, the <ex>vagina</ex> of the portal vein</as>.</def> <sd>(b)</sd>
<def>Specifically, the canal which leads from the uterus to the external
orifice of the genital canal, or to the cloaca.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The terminal part of the oviduct
in insects and various other invertebrates. See <xex>Illust.</xex>, of
<er>Spermatheca</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Bot.)</fld> <def>The basal expansion of certain
leaves, which inwraps the stem; a sheath.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Arch.)</fld> <def>The shaft of a terminus, from
which the bust or figure seems to issue or arise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaginal</ent><br/
<hw>Vag"i*nal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vaginal</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Of or pertaining to a vagina; resembling a vagina,
or sheath; thecal; <as>as, a <ex>vaginal</ex> synovial membrane; the
<ex>vaginal</ex> process of the temporal bone.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat.)</fld> <def>Of or pertaining to the vagina of
the genital canal; <as>as, the <ex>vaginal</ex> artery</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaginant</ent><br/
<hw>Vag"i*nant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vaginant</ets>. See <er>Vagina</er>.]</ety> <def>Serving to invest,
or sheathe; sheathing.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vaginant leaf</b></col> <fld>(Bot.)</fld>, <cd>a leaf
investing the stem or branch by its base, which has the form of a
tube.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaginated</ent><br/
<ent>Vaginate</ent><br/
<mhw>{ <hw>Vag"i*nate</hw> <pr>(?)</pr>, <hw>Vag"i*na`ted</hw>
<pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[See <er>Vagina</er>.]</ety>
<def>Invested with, or as if with, a sheath; <as>as, a <ex>vaginate</ex>
stem, or one invested by the tubular base of a leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaginati</ent><br/
\'d8<hw>Vag`i*na"ti</hw> <pr>(?)</pr>, <pos>n. pl.</pos>
<ety>[NL.]</ety> <fld>(Zool.)</fld> <def>A tribe of birds comprising the
sheathbills.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaginervose</ent><br/
<hw>Vag`i*ner*vose"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vagus</ets> wandering + E. <ets>nervose</ets>.]</ety>
<fld>(Bot.)</fld> <def>Having the nerves, or veins, placed in apparent
disorder.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaginicola</ent><br/
\'d8<hw>Vag`i*nic"o*la</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <ety>[NL.,
from L. <ets>vagina</ets> sheath + <ets>colere</ets> to inhabit.]</ety>
<fld>(Zool.)</fld> <def>A genus of Infusoria which form minute vaselike
or tubular cases in which they dwell.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaginismus</ent><br/
\'d8<hw>Vag`i*nis"mus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.]</ety>
<fld>(Med.)</fld> <def>A painful spasmodic contraction of the vagina,
often rendering copulation impossible.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaginitis</ent><br/
\'d8<hw>Vag`i*ni"tis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See
<er>Vagina</er>, and <er>-itis</er>.]</ety> <fld>(Med.)</fld>
<def>Inflammation of the vagina, or the genital canal, usually of its
mucous lining membrane.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaginopennous</ent><br/
\'d8<hw>Vag`i*no*pen"nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vagina</ets> a sheath + <ets>penna</ets> a feather, pl.
<ets>pennae</ets> a wing.]</ety> <fld>(Zool.)</fld> <def>Having elytra;
sheath-winged.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaginula</ent><br/
\'d8<hw>Va*gin"u*la</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., dim. of
<ets>vagina</ets> sheath.]</ety> <fld>(Bot.)</fld> <sd>(a)</sd> <def>A
little sheath, as that about the base of the pedicel of most
mosses.</def> <sd>(b)</sd> <def>One of the tubular florets in composite
flowers.</def> <rj><au>Henslow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaginule</ent><br/
<hw>Vag"i*nule</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A
vaginula.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagissate</ent><br/
<hw>Vag"is*sate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[L.
<ets>vagari</ets> to stroll or wander.]</ety> <def>To caper or
frolic.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagous</ent><br/
<hw>Va"gous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>vagus</ets>.
See <er>Vague</er>.]</ety> <def>Wandering; unsettled.</def>
<mark>[Obs.]</mark> <rj><au>Ayliffe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagrancy</ent><br/
<hw>Va"gran*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being a vagrant; a wandering without a settled home; an
unsettled condition; vagabondism.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Threatened away into banishment and <qex>vagrancy</qex>.</q>
<rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagrant</ent><br/
<hw>Va"grant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Probably fr. OF.
<ets>waucrant</ets>, <ets>wacrant</ets>, p. p. of <ets>waucrer</ets>,
<ets>wacrer</ets>, <ets>walcrer</ets>, to wander (probably of Teutonic
origin), but influenced by F. <ets>vagant</ets>, p. pr. of
<ets>vaguer</ets> to stray, L. <ets>vagari</ets>. Cf.
<er>Vagary</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Moving without certain direction; wandering;
erratic; unsettled.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That beauteous Emma <qex>vagrant</qex> courses took.</q>
<rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>While leading this <qex>vagrant</qex> and miserable life, Johnson
fell in love.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Wandering from place to place without any settled
habitation; <as>as, a <ex>vagrant</ex> beggar</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagrant</ent><br/
<hw>Va"grant</hw>, <pos>n.</pos> <def>One who strolls from place to
place; one who has no settled habitation; an idle wanderer; a sturdy
beggar; an incorrigible rogue; a vagabond.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vagrants</qex> and outlaws shall offend thy view.</q>
<rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagrantly</ent><br/
<hw>Va"grant*ly</hw>, <pos>adv.</pos> <def>In a vagrant
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagrantness</ent><br/
<hw>Va"grant*ness</hw>, <pos>n.</pos> <def>State of being vagrant;
vagrancy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vague</ent><br/
<hw>Vague</hw> <pr>(v<amac/g)</pr>, <pos>a.</pos>
<amorph>[<pos>Compar.</pos> <adjf>Vaguer</adjf>
<pr>(v<amac/g"<etil/r)</pr>; <pos>superl.</pos>
<adjf>Vaguest</adjf>.]</amorph> <ety>[F. <ets>vague</ets>, or L.
<ets>vagus</ets>. See <er>Vague</er>, <pos>v. i.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Wandering; vagrant; vagabond.</def>
<mark>[Archaic]</mark> <ldquo/To set upon the <xex>vague</xex>
villains.<rdquo/ <rj><au>Hayward.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>She danced along with <qex>vague</qex>, regardless eyes.</q>
<rj><qau>Keats.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Unsettled; unfixed; undetermined; indefinite;
ambiguous; <as>as, a <ex>vague</ex> idea; a <ex>vague</ex>
proposition</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This faith is neither a mere fantasy of future glory, nor a
<qex>vague</qex> ebullition of feeling.</q> <rj><qau>I.
Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The poet turned away, and gave himself up to a sort of
<qex>vague</qex> revery, which he called thought.</q>
<rj><qau>Hawthorne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Proceeding from no known authority; unauthenticated;
uncertain; flying; <as>as, a <ex>vague</ex> report</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Some legend strange and <qex>vague</qex>.</q>
<rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vague year</b></col>. <cd>See <cref>Sothiac year</cref>,
under <er>Sothiac</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Unsettled; indefinite; unfixed; ill-defined;
ambiguous; hazy; loose; lax; uncertain.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vague</ent><br/
<hw>Vague</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>vague</ets>.]</ety>
<def>An indefinite expanse.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The gray <qex>vague</qex> of unsympathizing sea.</q>
<rj><qau>Lowell.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vague</ent><br/
<hw>Vague</hw>, <pos>v. i.</pos> <ety>[F. <ets>vaguer</ets>, L.
<ets>vagari</ets>, fr. <ets>vagus</ets> roaming.]</ety> <def>To wander;
to roam; to stray.</def> <mark>[Obs.]</mark> <ldquo/[The soul] doth
<xex>vague</xex> and wander.<rdquo/ <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vague</ent><br/
<hw>Vague</hw>, <pos>n.</pos> <def>A wandering; a vagary.</def>
<mark>[Obs.]</mark> <rj><au>Holinshed.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaguely</ent><br/
<hw>Vague"ly</hw>, <pos>adv.</pos> <def>In a vague manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>What he <qex>vaguely</qex> hinted at, but dared not speak.</q>
<rj><qau>Hawthorne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagueness</ent><br/
<hw>Vague"ness</hw>, <pos>n.</pos> <def>The quality or state of being
vague.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vagus</ent><br/
\'d8<hw>Va"gus</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.,
wandering.]</ety> <fld>(Anat.)</fld> <def>Wandering; -- applied
especially to the pneumogastric nerve.</def> -- <def2><pos>n.</pos>
<def>The vagus, or pneumogastric, nerve.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vail</ent><br/
<hw>Vail</hw> <pr>(v<amac/l)</pr>, <pos>n. & v. t.</pos> <def>Same as
<er>Veil</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vail</ent><br/
<hw>Vail</hw>, <pos>n.</pos> <ety>[Aphetic form of <ets>avail</ets>,
<pos>n.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Avails; profit; return; proceeds.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>My house is as 'twere the cave where the young outlaw hoards the
stolen <qex>vails</qex> of his occupation.</q>
<rj><qau>Chapman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An unexpected gain or acquisition; a casual
advantage or benefit; a windfall.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Money given to servants by visitors; a gratuity; --
usually in the plural.</def> <altsp>[Written also
<asp>vale</asp>.]</altsp> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vail</ent><br/
<hw>Vail</hw>, <pos>v. t.</pos> <ety>[Aphetic form of <ets>avale</ets>.
See <er>Avale</er>, <er>Vale</er>.]</ety> <altsp>[Written also
<asp>vale</asp>, and <asp>veil</asp>.]</altsp> <sn>1.</sn> <def>To let
fall; to allow or cause to sink.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vail</qex> your regard<br/
Upon a wronged, I would fain have said, a maid!</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To lower, or take off, in token of inferiority,
reverence, submission, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>France must <qex>vail</qex> her lofty-plumed crest!</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Without <qex>vailing</qex> his bonnet or testifying any reverence
for the alleged sanctity of the relic.</q> <rj><qau>Sir. W.
Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vail</ent><br/
<hw>Vail</hw> <pr>(v<amac/l)</pr>, <pos>v. i.</pos> <def>To yield or
recede; to give place; to show respect by yielding, uncovering, or the
like.</def> <altsp>[Written also <asp>vale</asp>, and
<asp>veil</asp>.]</altsp> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Thy convenience must <qex>vail</qex> to thy neighbor's
necessity.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vail</ent><br/
<hw>Vail</hw>, <pos>n.</pos> <def>Submission; decline; descent.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vailer</ent><br/
<hw>Vail"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who vails.</def>
<mark>[Obs.]</mark> <rj><au>Overbury.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaimure</ent><br/
<hw>Vai"mure</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An outer, or
exterior, wall. See <er>Vauntmure</er>.</def> <mark>[Obs.]</mark>
<rj><au>Hakluyt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vain</ent><br/
<hw>Vain</hw> <pr>(v<amac/n)</pr>, <pos>a.</pos>
<amorph>[<pos>Compar.</pos> <adjf>Vainer</adjf> <pr>(?)</pr>;
<pos>superl.</pos> <adjf>Vainest</adjf>.]</amorph> <ety>[F.
<ets>vain</ets>, L. <ets>vanus</ets> empty, void, vain. Cf.
<er>Vanish</er>, <er>Vanity</er>, <er>Vaunt</er> to boast.]</ety>
<sn>1.</sn> <def>Having no real substance, value, or importance; empty;
void; worthless; unsatisfying.</def> <ldquo/Thy <xex>vain</xex>
excuse.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Every man walketh in a <qex>vain</qex> show.</q> <rj><qau>Ps.
xxxix. 6.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Let no man deceive you with <qex>vain</qex> words.</q>
<rj><qau>Eph. v. 6.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vain</qex> pomp, and glory of this world, I hate ye!</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vain</qex> wisdom all, and false philosophy.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Destitute of force or efficacy; effecting no
purpose; fruitless; ineffectual; <as>as, <ex>vain</ex> toil; a
<ex>vain</ex> attempt</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Bring no more <qex>vain</qex> oblations.</q> <rj><qau>Isa. i.
13.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vain</qex> is the force of man<br/
To crush the pillars which the pile sustain.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Proud of petty things, or of trifling attainments;
having a high opinion of one's own accomplishments with slight reason;
conceited; puffed up; inflated.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>But wilt thou know, O <qex>vain</qex> man, that faith apart from
works is barren?</q> <rj><qau>James ii. 20 (Rev. Ver.).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The minstrels played on every side,<br/
<qex>Vain</qex> of their art.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Showy; ostentatious.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Load some <qex>vain</qex> church with old theatric state.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Empty; worthless; fruitless; ineffectual; idle;
unreal; shadowy; showy; ostentatious; light; inconstant; deceitful;
delusive; unimportant; trifling.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vain</ent><br/
<hw>Vain</hw>, <pos>n.</pos> <def>Vanity; emptiness; -- now used only in
the phrase <col>in vain</col>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>For vain</b></col>. <cd>See <cref>In vain</cref>.</cd>
<mark>[Obs.]</mark> <au>Shak.</au> -- <col><b>In vain</b></col>, <cd>to
no purpose; without effect; ineffectually.</cd> <ldquo/ <xex>In
vain</xex> doth valor bleed.<rdquo/ <au>Milton.</au> <ldquo/ <xex>In
vain</xex> they do worship me.<rdquo/ <au>Matt. xv. 9.</au> --
<col><b>To take the name of God in vain</b></col>, <cd>to use the name
of God with levity or profaneness.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vainglorious</ent><br/
<hw>Vain`glo"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Feeling or
indicating vainglory; elated by vanity; boastful.</def> <ldquo/Arrogant
and <xex>vainglorious</xex> expression.<rdquo/ <au>Sir M. Hale.</au> --
<wordforms><wf>Vain`glo"ri*ous*ly</wf>, <pos>adv.</pos> --
<wf>Vain`glo"ri*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vainglory</ent><br/
<hw>Vain`glo"ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Vain</ets> +
<ets>glory</ets>.]</ety> <def>Excessive vanity excited by one's own
performances; empty pride; undue elation of mind; vain show;
boastfulness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He had nothing of <qex>vainglory</qex>.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The man's undone forever; for if Hector break not his neck i' the
combat, he'll break't himself in <qex>vainglory</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vainly</ent><br/
<hw>Vain"ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a vain manner; in
vain.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vainness</ent><br/
<hw>Vain"ness</hw>, <pos>n.</pos> <def>The quality or state of being
vain.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vair</ent><br/
<hw>Vair</hw> <pr>(v<acir/r)</pr>, <pos>n.</pos> <ety>[F.
<ets>vair</ets>, from OF. <ets>vair</ets>, a., L. <ets>varius</ets>
various, variegated. See <er>Various</er>, and cf.
<er>Meniver</er>.]</ety> <def>The skin of the squirrel, much used in the
fourteenth century as fur for garments, and frequently mentioned by
writers of that period in describing the costly dresses of kings,
nobles, and prelates. It is represented in heraldry by a series of small
shields placed close together, and alternately white and blue.</def>
<rj><au>Fairholt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>No <qex>vair</qex> or ermine decked his garment.</q> <rj><qau>Sir
W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Counter vair</b></col> <fld>(Her.)</fld>, <cd>a fur
resembling vair, except in the arrangement of the patches or
figures.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vairy</ent><br/
<hw>Vair"y</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F.
<ets>vair<eacute/</ets>. See <er>Vair</er>, <pos>n.</pos>]</ety>
<fld>(Her.)</fld> <def>Charged with vair; variegated with shield-shaped
figures. See <er>Vair</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaishnava</ent><br/
<hw>Vaish"na*va</hw> <pr>(v<imac/sh"n<adot/*v<adot/)</pr>, <pos>n.</pos>
<ety>[Skr. <ets>vaish<nsdot/ava</ets>.]</ety> <fld>(Hindu Myth.)</fld>
<def>A worshiper of the god <persfn>Vishnu</persfn> in any of his
incarnations.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaishnavism</ent><br/
<hw>Vaish"na*vism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The worship of
Vishnu.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaisya</ent><br/
\'d8<hw>Vais"ya</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Skr.
<ets>vai<cced/ya</ets>.]</ety> <def>The third of the four great original
castes among the Hindus, now either extinct or partially represented by
the mercantile class of Banyas. See the Note under <er>Caste</er>,
1.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaivode</ent><br/
<hw>Vai"vode</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vayvode</ets>. See <er>Waywode</er>.]</ety> <def>See
<er>Waywode</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vakeel</ent><br/
\'d8<hw>Va*keel"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Ar.
<ets>wak<imac/l</ets>.]</ety> <def>A native attorney or agent; also, an
ambassador.</def> <mark>[India]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valance</ent><br/
<hw>Val"ance</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Perhaps fr. OF.
<ets>avalant</ets> descending, hanging down, p. pr. of <ets>avaler</ets>
to go down, let down, descend (cf. <er>Avalanche</er>); but probably
from the town of <etsep>Valence</etsep> in France.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Hanging drapery for a bed, couch, window, or the
like, especially that which hangs around a bedstead, from the bed to the
floor.</def> <altsp>[Written also <asp>valence</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Valance</qex> of Venice gold in needlework.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The drooping edging of the lid of a trunk, which
covers the joint when the lid is closed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valance</ent><br/
<hw>Val"ance</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Valanced</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Valancing</conjf> <pr>(?)</pr>.]</vmorph> <def>To furnish with a
valance; to decorate with hangings or drapery.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His old fringed chair <qex>valanced</qex> around with
party-colored worsted bobs.</q> <rj><qau>Sterne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vale</ent><br/
<hw>Vale</hw> <pr>(v<amac/l)</pr>, <pos>n.</pos> <ety>[OE.
<ets>val</ets>, F. <ets>val</ets>, L. <ets>vallis</ets>; perhaps akin to
Gr. <grk>'e`los</grk> low ground, marsh meadow. Cf. <er>Avalanche</er>,
<er>Vail</er> to lower, <er>Valley</er>.]</ety> <def>A tract of low
ground, or of land between hills; a valley.</def> <ldquo/ Make me a
cottage in the <xex>vale</xex>.<rdquo/ <rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Beyond this <qex>vale</qex> of tears there is a life above.</q>
<rj><qau>Montgomery.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In those fair <qex>vales</qex>, by nature formed to please.</q>
<rj><qau>Harte.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Vale</xex> is more commonly used in poetry, and
<xex>valley</xex> in prose and common discourse.</note><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Valley; dingle; dell; dale.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vale</ent><br/
<hw>Vale</hw>, <pos>n.</pos> <def>See 2d <er>Vail</er>, 3.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valediction</ent><br/
<hw>Val`e*dic"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.,
<ets>valedicere</ets>, <ets>valedictum</ets>, to say farewell;
<ets>vale</ets> farewell (imperative of <ets>valere</ets> to be strong
or well) + <ets>dicere</ets> to say. See <er>Valiant</er>,
<er>Diction</er>.]</ety> <def>A farewell; a bidding farewell.</def>
<rj><au>Donne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1592 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valedictorian</ent><br/
<hw>Val`e*dic*to"ri*an</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who
pronounces a valedictory address; especially, in American colleges, the
student who pronounces the valedictory of the graduating class at the
annual commencement, usually the student who ranks first in
scholarship.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valedictory</ent><br/
<hw>Val`e*dic"to*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Bidding
farewell; suitable or designed for an occasion of leave-taking; <as>as,
a <ex>valedictory</ex> oration</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valedictory</ent><br/
<hw>Val`e*dic"to*ry</hw>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Valedictories</plw> <pr>(<?/)</pr>.</plu> <def>A valedictory
oration or address spoken at commencement in American colleges or
seminaries by one of the graduating class, usually by the leading
scholar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valence</ent><br/
<hw>Va"lence</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From L.
<ets>valens</ets>, <ets>-entis</ets>, p. pr. of <ets>valere</ets> to
have power, to be strong. See <er>Valiant</er>.]</ety>
<fld>(Chem.)</fld> <def>The degree of combining power of an atom (or
radical) as shown by the number of atoms of hydrogen (or of other
monads, as chlorine, sodium, etc.) with which it will combine, or for
which it can be substituted, or with which it can be compared; thus, an
atom of hydrogen is a monad, and has a <xex>valence</xex> of one; the
atoms of oxygen, nitrogen, and carbon are respectively dyads, triads,
and tetrads, and have a <xex>valence</xex> respectively of two, three,
and four.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The valence of certain elements varies in different
compounds. Valence in degree may extend as high as seven or eight, as in
the cases of iodine and osmium respectively. The doctrine of valence has
been of fundamental importance in distinguishing the equivalence from
the atomic weight, and is an essential factor in explaining the chemical
structures of compounds.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valencia</ent><br/
<hw>Va*len"ci*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Perhaps fr.
<ets>Valence</ets> in France.]</ety> <def>A kind of woven fabric for
waistcoats, having the weft of wool and the warp of silk or
cotton.</def> <altsp>[Written also <asp>valentia</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valenciennes lace</ent><br/
<hw>Va*len`ci*ennes" lace"</hw> <pr>(?)</pr>. <ety>[F.; -- so called
after the town of <ets>Valenciennes</ets>.]</ety> <def>A rich kind of
lace made at Valenciennes, in France. Each piece is made throughout,
ground and pattern, by the same person and with the same thread, the
pattern being worked in the net.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valency</ent><br/
<hw>Val"en*cy</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Valencies</plw> <pr>(<?/)</pr>.</plu> <fld>(Chem.)</fld>
<sd>(a)</sd> <def>See <er>Valence</er>.</def> <sd>(b)</sd> <def>A unit
of combining power; a so-called bond of affinity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valentia</ent><br/
<hw>Va*len"ti*a</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Valencia</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valentine</ent><br/
<hw>Val"en*tine</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A
sweetheart chosen on St. Valentine's Day.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A letter containing professions of love, or a
missive of a sentimental, comic, or burlesque character, sent on St.
Valentine's Day.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>St. Valentine's Day</b></col>, <cd>a day sacred to St.
Valentine; the 14th of February. It was a very old notion, alluded to by
Shakespeare, that on this day birds begin to mate. Hence, perhaps, arose
the custom of sending love tokens at that time.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valentinian</ent><br/
<hw>Val`en*tin"i*an</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Eccl.
Hist.)</fld> <def>One of a school of Judaizing Gnostics in the second
century; -- so called from <ets>Valentinus</ets>, the founder.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valeramide</ent><br/
<hw>Val`er*am"ide</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Valer</ets>ic + <ets>amide</ets>.]</ety> <fld>(Chem.)</fld>
<def>The acid amide derivative of valeric acid, obtained as a white
crystalline substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valerate</ent><br/
<hw>Val"er*ate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A salt of valeric acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valerian</ent><br/
<hw>Va*le"ri*an</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL.
<ets>valeriana</ets>, perhaps from some person named
<etsep>Valerius</etsep>, or fr. L. <ets>valere</ets> to be strong.
powerful, on account of its medicinal virtues: cf. F.
<ets>val<eacute/riane</ets>.]</ety> <fld>(Bot.)</fld> <def>Any plant of
the genus <gen>Valeriana</gen>. The root of the officinal valerian
(<spn>Valeriana officinalis</spn>) has a strong smell, and is much used
in medicine as an antispasmodic.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Greek valerian</b></col> <fld>(Bot.)</fld>, <cd>a plant
(<spn>Polemonium caeruleum</spn>) with blue or white flowers, and leaves
resembling those of the officinal valerian.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valerianaceous</ent><br/
<hw>Va*le`ri*an*a"ceous</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Bot.)</fld> <def>Of, pertaining to, or resembling, plants of a
natural order (<ord>Valerianaceae</ord>) of which the valerian is the
type. The order includes also the corn salads and the oriental
spikenard.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valerianate</ent><br/
<hw>Va*le"ri*an*ate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A valerate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valerianic</ent><br/
<hw>Va*le`ri*an"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld>
<def>Pertaining to, or obtained from, valerian root; specifically,
designating an acid which is usually called <xex>valeric
acid</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valeric</ent><br/
<hw>Va*ler"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld>
<def>Valerianic; specifically, designating any one of three metameric
acids, of which the typical one (called also <stype>inactive valeric
acid</stype>), <chform>C4H9CO2H</chform>, is obtained from
<xex>valerian</xex> root and other sources, as a corrosive, mobile, oily
liquid, having a strong acid taste, and an odor of old cheese.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Active valeric acid</b></col>, <cd>a metameric variety
which turns the plane of polarization to the right, although formed by
the oxidation of a levorotatory amyl alcohol.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valeridine</ent><br/
<hw>Va*ler"i*dine</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A base, <chform>C10H19N</chform>, produced by heating valeric
aldehyde with ammonia. It is probably related to the conine
alkaloids.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valerin</ent><br/
<hw>Val"er*in</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Valer</ets>ic
+ glycer<ets>in</ets>.]</ety> <fld>(Chem.)</fld> <def>A salt of valeric
acid with glycerin, occurring in butter, dolphin oil, etc., and forming
an oily liquid with a slightly unpleasant odor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valeritrine</ent><br/
<hw>Va*ler"i*trine</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Valer</ets>ic + <ets>tro</ets>pine + <ets>-ine</ets>.]</ety>
<fld>(Chem.)</fld> <def>A base, <chform>C15H27N</chform>, produced
together with valeridine, which it resembles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valero-</ent><br/
<hw>Val"er*o-</hw>. <fld>(Chem.)</fld> <def>A combining form (also used
adjectively) indicating <xex>derivation from</xex>, or <xex>relation
to</xex>, <xex>valerian</xex> or <xex>some of its products</xex>, as
valeric acid; as in <xex>valero</xex>lactone, a colorless oily liquid
produced as the anhydride of an hydroxy valeric acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valerone</ent><br/
<hw>Val"er*one</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A ketone of valeric acid obtained as an oily liquid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valeryl</ent><br/
<hw>Val"er*yl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Valeric</ets>
+ <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld> <def>The hypothetical
radical <chform>C5H9O</chform>, regarded as the essential nucleus of
certain valeric acid derivatives.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valerylene</ent><br/
<hw>Val`er*yl*ene</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A liquid hydrocarbon, <chform>C5H8</chform>; -- called also
<altname>pentine</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valet</ent><br/
<hw>Val"et</hw> <pr>(v<acr/l"<ecr/t <it>or</it> v<acr/l"<asl/;
277)</pr>, <pos>n.</pos> <ety>[F. <ets>valet</ets>, OF.
<ets>vallet</ets>, <ets>varlet</ets>, <ets>vaslet</ets>. See
<er>Varlet</er>, and <er>Vassal</er>.]</ety> <sn>1.</sn> <def>A male
waiting servant; a servant who attends on a gentleman's person; a body
servant.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Man.)</fld> <def>A kind of goad or stick with a
point of iron.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs>\'d8<col><b>Valet de chambre</b></col> <pr>(<?/)</pr>
<ety>[F.]</ety>, <cd>a body servant, or personal
attendant.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valetudinarian</ent><br/
<hw>Val`e*tu`di*na"ri*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>valetudinarius</ets>, from <ets>valetudo</ets> state of health,
health, ill health, fr. <ets>valere</ets> to be strong or well: cf. F.
<ets>val<eacute/tudinaire</ets>. See <er>Valiant</er>.]</ety> <def>Of
infirm health; seeking to recover health; sickly; weakly;
infirm.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>My feeble health and <qex>valetudinarian</qex> stomach.</q>
<rj><qau>Coleridge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The virtue which the world wants is a healthful virtue, not a
<qex>valetudinarian</qex> virtue.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valetudinarian</ent><br/
<hw>Val`e*tu`di*na"ri*an</hw>, <pos>n.</pos> <def>A person of a weak or
sickly constitution; one who is seeking to recover health.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Valetudinarians</qex> must live where they can command and
scold.</q> <rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valetudinarianism</ent><br/
<hw>Val`e*tu`di*na"ri*an*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The
condition of a valetudinarian; a state of feeble health;
infirmity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valetudinary</ent><br/
<hw>Val`e*tu"di*na*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Infirm;
sickly; valetudinarian.</def> --
<wordforms><wf>Val`e*tu"di*na*ri*ness</wf>,
<pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>It renders the habit of society dangerously
<qex>valetudinary</qex>.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valetudinary</ent><br/
<hw>Val`e*tu"di*na*ry</hw>, <pos>n.</pos> <def>A
valetudinarian.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valetudinous</ent><br/
<hw>Val`e*tu"di*nous</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Valetudinarian.</def> <mark>[Obs.]</mark> <ldquo/The
<xex>valetudinous</xex> condition of King Edward.<rdquo/
<rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valhalla</ent><br/
<hw>Val*hal"la</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Icel.
<ets>valh<oum/ll</ets>, literally, hall of the slain; <ets>valr</ets>
the slain (akin to AS. <ets>w<ae/l</ets>, OHG. <ets>wal</ets>
battlefield, <ets>wuol</ets> defeat, slaughter, AS. <ets>w<omac/l</ets>
pestilence) + <ets>h<oum/ll</ets> a royal hall. See <er>Hall</er>, and
cf. <er>Walhalla</er>.]</ety> <altsp>[Written also
<asp>walhalla</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Scand. Myth.)</fld> <def>The palace of immortality,
inhabited by the souls of heroes slain in battle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: A hall or temple adorned with statues and
memorials of a nation's heroes; specifically, the Pantheon near
Ratisbon, in Bavaria, consecrated to the illustrious dead of all
Germany.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valiancy</ent><br/
<ent>Valiance</ent><br/
<mhw>{ <hw>Val"iance</hw> <pr>(?)</pr>, <hw>Val"ian*cy</hw>
<pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[Cf. F. <ets>vaillance</ets>.
See <er>Valiant</er>.]</ety> <def>The quality or state of being valiant;
bravery; valor.</def> <mark>[Obs.]</mark> <ldquo/His doughty
<xex>valiance</xex>.<rdquo/ <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valiant</ent><br/
<hw>Val"iant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OE.
<ets>valiant</ets>, F. <ets>vaillant</ets>, OF. <ets>vaillant</ets>,
<ets>valant</ets>, originally p. pr. of OF. & F. <ets>valoir</ets> to be
worth, L. <ets>valere</ets> to be strong. See <er>Wield</er>, and cf.
<er>Avail</er>, <er>Convalesce</er>, <er>Equivalent</er>,
<er>Prevail</er>, <er>Valid</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Vigorous in body; strong; powerful; <as>as, a
<ex>valiant</ex> fencer</as>.</def> <mark>[Obs.]</mark>
<rj><au>Walton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Intrepid in danger; courageous; brave.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>valiant</qex> and most expert gentleman.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And Saul said to David . . . be thou <qex>valiant</qex> for me,
and fight the Lord's battles.</q> <rj><qau>1 Sam. xviii.
17.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Performed with valor or bravery; heroic.</def>
<ldquo/Thou bearest the highest name for <xex>valiant</xex> acts.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>[The saints] have made such <qex>valiant</qex> confessions.</q>
<rj><qau>J. H. Newman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Val"iant*ly</wf>, <pos>adv.</pos> --
<wf>Val"iant*ness</wf>, <wf>n</wf>.</wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valid</ent><br/
<hw>Val"id</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F. <ets>valide</ets>,
L. <ets>validus</ets> strong, from <ets>valere</ets> to be strong. See
<er>Valiant</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Strong; powerful; efficient.</def>
<mark>[Obs.]</mark> <ldquo/Perhaps more <xex>valid</xex> arms . . . may
serve to better us.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Having sufficient strength or force; founded in
truth; capable of being justified, defended, or supported; not weak or
defective; sound; good; efficacious; <as>as, a <ex>valid</ex> argument;
a <ex>valid</ex> objection</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>An answer that is open to no <qex>valid</qex> exception.</q>
<rj><qau>I. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Law)</fld> <def>Having legal strength or force;
executed with the proper formalities; incapable of being rightfully
overthrown or set aside; <as>as, a <ex>valid</ex> deed; a <ex>valid</ex>
covenant; a <ex>valid</ex> instrument of any kind; a <ex>valid</ex>
claim or title; a <ex>valid</ex> marriage</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Prevalent; available; efficacious; just; good;
weighty; sufficient; sound; well-grounded.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Validate</ent><br/
<hw>Val"i*date</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[See
<er>Valid</er>.]</ety> <def>To confirm; to render valid; to give legal
force to.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The chamber of deputies . . . refusing to <qex>validate</qex> at
once the election of an official candidate.</q> <rj><qau>London
Spectator.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Validation</ent><br/
<hw>Val`i*da"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>validation</ets>.]</ety> <def>The act of giving validity.</def>
<mark>[R.]</mark> <rj><au>Knowles.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Validity</ent><br/
<hw>Va*lid"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>validit<eacute/</ets>, L. <ets>validitas</ets> strength.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The quality or state of being valid; strength;
force; especially, power to convince; justness; soundness; <as>as, the
<ex>validity</ex> of an argument or proof; the <ex>validity</ex> of an
objection</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>Legal strength, force, or
authority; that quality of a thing which renders it supportable in law,
or equity; <as>as, the <ex>validity</ex> of a will; the
<ex>validity</ex> of a contract, claim, or title</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Value.</def> <mark>[Obs.]</mark> <ldquo/Rich
<xex>validity</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Validly</ent><br/
<hw>Val"id*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a valid manner;
so as to be valid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Validness</ent><br/
<hw>Val"id*ness</hw>, <pos>n.</pos> <def>The quality or state of being
valid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valinch</ent><br/
<hw>Val"inch</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>avaler</ets> to let down, drink up. Cf. <er>Avalanche</er>.]</ety>
<def>A tube for drawing liquors from a cask by the bunghole.</def>
<altsp>[Written also <asp>velinche</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valise</ent><br/
<hw>Va*lise"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>valise</ets>; cf. It. <ets>valigia</ets>, Sp. <ets>balija</ets>,
LL. <ets>valisia</ets>, <ets>valesia</ets>; of uncertain origin, perhaps
through (assumed) LL. <ets>vidulitia</ets>, from L. <ets>vidulus</ets> a
leathern trunk; a knapsack.]</ety> <def>A small sack or case, usually of
leather, but sometimes of other material, for containing the clothes,
toilet articles, etc., of a traveler; a traveling bag; a
portmanteau.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valkyria</ent><br/
<hw>Val*kyr"i*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Icel.
<ets>valkyrja</ets> (akin to AS. <ets>w<ae/lcyrie</ets>);
<ets>valr</ets> the slain + <ets>kj<omac/sa</ets> to choose. See
<er>Valhalla</er>, and <er>Choose</er>.]</ety> <fld>(Scand. Myth.)</fld>
<def>One of the maidens of Odin, represented as awful and beautiful, who
presided over battle and marked out those who were to be slain, and who
also ministered at the feasts of heroes in Valhalla. Now commonly
written <altname>Valkyrie</altname>.</def> <altsp>[Written also
<asp>Valkyr</asp>, <asp>Valkyrie</asp>, <asp>Walkyrie</asp> and
<asp>Walkyr</asp>.]</altsp><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Valkyrian</ent><br/
<hw>Val*kyr"i*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to the Valkyries; hence, relating to battle.</def> <ldquo/Ourself have
often tried <xex>Valkyrian</xex> hymns.<rdquo/
<rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vallancy</ent><br/
<hw>Val*lan"cy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From
<er>Valance</er>.]</ety> <def>A large wig that shades the face.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vallar</ent><br/
<hw>Val"lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vallaris</ets>.]</ety> <def>Of or pertaining to a
rampart.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vallar crown</b></col> <fld>(Rom. Antiq.)</fld>, <cd>a
circular gold crown with palisades, bestowed upon the soldier who first
surmounted the rampart and broke into the enemy's camp.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vallar</ent><br/
<hw>Val"lar</hw>, <pos>n.</pos> <def>A vallar crown.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vallary</ent><br/
<hw>Val"la*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Same as
<er>Vallar</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vallation</ent><br/
<hw>Val*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vallatio</ets>, fr. <ets>vallare</ets> to surround with a rampart,
fr. <ets>vallum</ets> rampart. See <er>Wall</er>, <pos>n.</pos>]</ety>
<def>A rampart or intrenchment.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vallatory</ent><br/
<hw>Val"la*to*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to a vallation; used for a vallation; <as>as, <ex>vallatory</ex>
reeds</as>.</def> <mark>[Obs.]</mark> <rj><au>Sir T.
Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vallecula</ent><br/
\'d8<hw>Val*lec"u*la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Valleculae</plw> <pr>(#)</pr>.</plu> <ety>[NL., dim. fr. L.
<ets>vallis</ets>, <ets>valles</ets>, a valley.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Anat.)</fld> <def>A groove; a fossa; <as>as, the
<ex>vallecula</ex>, or fossa, which separates the hemispheres of the
cerebellum</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>One of the grooves, or hollows,
between the ribs of the fruit of umbelliferous plants.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vallet's pills</ent><br/
<hw>Val`let's pills"</hw> <pr>(?)</pr>. <ety>[From Dr. <ets>Vallet</ets>
of Paris.]</ety> <fld>(Med.)</fld> <def>Pills containing sulphate of
iron and carbonate of sodium, mixed with saccharine matter; -- called
also <altname>Vallet's mass</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valley</ent><br/
<hw>Val"ley</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Valleys</plw> <pr>(#)</pr>.</plu> <ety>[OE. <ets>vale</ets>,
<ets>valeie</ets>, OF. <ets>val<eacute/e</ets>, <ets>valede</ets>, F.
<ets>vall<eacute/e</ets>, LL. <ets>vallata</ets>, L. <ets>vallis</ets>,
<ets>valles</ets>. See <er>Vale</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The space inclosed between ranges of hills or
mountains; the strip of land at the bottom of the depressions
intersecting a country, including usually the bed of a stream, with
frequently broad alluvial plains on one or both sides of the stream.
Also used figuratively.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>valley</qex> of the shadow of death.</q> <rj><qau>Ps.
xxiii. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Sweet interchange<br/
Of hill and <qex>valley</qex>, rivers, woods, and plains.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Deep and narrow <xex>valleys</xex> with abrupt sides are
usually the results of erosion by water, and are called
<stype>gorges</stype>, <stype>ravines</stype>, <stype>canyons</stype>,
<stype>gulches</stype>, etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <sd>(a)</sd> <def>The place of meeting
of two slopes of a roof, which have their plates running in different
directions, and form on the plan a reentrant angle.</def> <sd>(b)</sd>
<def>The depression formed by the meeting of two slopes on a flat
roof.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Valley board</b></col> <fld>(Arch.)</fld>, <cd>a board
for the reception of the lead gutter in the valley of a roof. The valley
board and lead gutter are not usual in the United States.</cd> --
<mcol><col><b>Valley rafter</b></col>, <it>or</it> <col><b>Valley
piece</b></col></mcol> <fld>(Arch.)</fld>, <cd>the rafter which supports
the valley.</cd> -- <col><b>Valley roof</b></col> <fld>(Arch.)</fld>,
<cd>a roof having one or more valleys. See <er>Valley</er>, 2,
above.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vallum</ent><br/
\'d8<hw>Val"lum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L.
<plw>Valla</plw> <pr>(#)</pr>, E. <plw>Vallums</plw> <pr>(#)</pr>.</plu>
<ety>[L. See <er>Wall</er>.]</ety> <fld>(Rom. Antiq.)</fld> <def>A
rampart; a wall, as in a fortification.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valonia</ent><br/
<hw>Va*lo"ni*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It.
<ets>vallonia</ets>, <ets>vallonea</ets>, fr. NGr. <grk>balania`</grk>,
<grk>balanidia`</grk>, the holm oak, <grk>bala`ni</grk>,
<grk>balani`di</grk>, an acorn, Gr. <grk>ba`lanos</grk>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The acorn cup of two kinds of oak (<spn>Quercus
macrolepis</spn>, and <spn>Quercus vallonea</spn>) found in Eastern
Europe. It contains an abundance of tannin, and is much used by tanners
and dyers.</def><-- ##sic. better "an abundance"? --><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[Perhaps named from its resemblance to an
acorn.]</ety> <fld>(Bot.)</fld> <def>A genus of marine green algae, in
which the whole frond consists of a single oval or cylindrical cell,
often an inch in length.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valor</ent><br/
<hw>Val"or</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>valour</ets>,
OF. <ets>valor</ets>, <ets>valur</ets>, <ets>valour</ets>, F.
<ets>valeur</ets>, LL. <ets>valor</ets>, fr. L. <ets>valere</ets> to be
strong, or worth. See <er>Valiant</er>.]</ety> <altsp>[Written also
<asp>valour</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Value; worth.</def> <mark>[Obs.]</mark> <ldquo/The
<xex>valor</xex> of a penny.<rdquo/ <rj><au>Sir T. More.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Strength of mind in regard to danger; that quality
which enables a man to encounter danger with firmness; personal bravery;
courage; prowess; intrepidity.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>For contemplation he and <qex>valor</qex> formed.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>When <qex>valor</qex> preys on reason,<br/
It eats the sword it fights with.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Fear to do base, unworthy things is <qex>valor</qex>.</q>
<rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A brave man; a man of valor.</def> <mark>[R.]</mark>
<rj><au>Ld. Lytton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Courage; heroism; bravery; gallantry; boldness;
fearlessness. See <er>Courage</er>, and <er>Heroism</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valorization</ent><br/
<hw>Val`or*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Pg.
<ets>valorizac<atil/o</ets>.]</ety> <def>Act or process of attempting to
give an arbitrary market value or price to a commodity by governmental
interference, as by maintaining a purchasing fund, making loans to
producers to enable them to hold their products, etc.; -- used chiefly
of such action by Brazil.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Valorous</ent><br/
<hw>Val"or*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>valeureux</ets>, LL. <ets>valorosus</ets>.]</ety> <def>Possessing
or exhibiting valor; brave; courageous; valiant; intrepid.</def> --
<wordforms><wf>Val"or*ous*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valsalvian</ent><br/
<hw>Val*sal"vi*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to <etsep>Valsalva</etsep>, an Italian anatomist of the 17th
century.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Valsalvian experiment</b></col> <fld>(Med.)</fld>,
<cd>the process of inflating the middle ear by closing the mouth and
nostrils, and blowing so as to puff out the cheeks.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valuable</ent><br/
<hw>Val"u*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Having
value or worth; possessing qualities which are useful and esteemed;
precious; costly; <as>as, a <ex>valuable</ex> horse; <ex>valuable</ex>
land; a <ex>valuable</ex> cargo.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Worthy; estimable; deserving esteem; <as>as, a
<ex>valuable</ex> friend; a <ex>valuable</ex> companion.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Valuable consideration</b></col> <fld>(Law)</fld>, <cd>an
equivalent or compensation having value given for a thing purchased, as
money, marriage, services, etc.</cd> <rj><au>Blackstone.</au>
<au>Bouvier.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valuable</ent><br/
<hw>Val"u*a*ble</hw>, <pos>n.</pos> <def>A precious possession; a thing
of value, especially a small thing, as an article of jewelry; -- used
mostly in the plural.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The food and <qex>valuables</qex> they offer to the gods.</q>
<rj><qau>Tylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valuableness</ent><br/
<hw>Val"u*a*ble*ness</hw>, <pos>n.</pos> <def>The quality of being
valuable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valuably</ent><br/
<hw>Val"u*a*bly</hw>, <pos>adv.</pos> <def>So as to be of
value.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valuation</ent><br/
<hw>Val`u*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
act of valuing, or of estimating value or worth; the act of setting a
price; estimation; appraisement; <as>as, a <ex>valuation</ex> of lands
for the purpose of taxation</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Value set upon a thing; estimated value or worth;
<as>as, the goods sold for more than their
<ex>valuation</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Since of your lives you set<br/
So slight a <qex>valuation</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valuator</ent><br/
<hw>Val"u*a`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who assesses,
or sets a value on, anything; an appraiser.</def>
<rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Value</ent><br/
<hw>Val"ue</hw> <pr>(v<acr/l"<umac/)</pr>, <pos>n.</pos> <ety>[OF.
<ets>value</ets>, fr. <ets>valoir</ets>, p. p. <ets>valu</ets>, to be
worth, fr. L. <ets>valere</ets> to be strong, to be worth. See
<er>Valiant</er>.]</ety> <sn>1.</sn> <def>The property or aggregate
properties of a thing by which it is rendered useful or desirable, or
the degree of such property or sum of properties; worth; excellence;
utility; importance.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1593 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><q>Ye are all physicians of no <qex>value</qex>.</q> <rj><qau>Job
xiii. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Ye are of more <qex>value</qex> than many sparrows.</q>
<rj><qau>Matt. x. 31.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Caesar is well acquainted with your virtue,<br/
And therefore sets this <qex>value</qex> on your life.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Before events shall have decided on the <qex>value</qex> of the
measures.</q> <rj><qau>Marshall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Trade & Polit. Econ.)</fld> <def>Worth estimated by
any standard of purchasing power, especially by the market price, or the
amount of money agreed upon as an equivalent to the utility and cost of
anything.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>An article may be possessed of the highest degree of utility, or
power to minister to our wants and enjoyments, and may be universally
made use of, without possessing exchangeable <qex>value</qex>.</q>
<rj><qau>M'Culloch.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Value</qex> is the power to command commodities
generally.</q> <rj><qau>A. L. Chapin (Johnson's Cys.).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Value</qex> is the generic term which expresses power in
exchange.</q> <rj><qau>F. A. Walker.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>His design was not to pay him the <qex>value</qex> of his
pictures, because they were above any price.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In political economy, <xex>value</xex> is often
distinguished as <xex>intrinsic</xex> and <xex>exchangeable</xex>.
<xex>Intrinsic value</xex> is the same as utility or adaptation to
satisfy the desires or wants of men. <xex>Exchangeable value</xex> is
that in an article or product which disposes individuals to give for it
some quantity of labor, or some other article or product obtainable by
labor; as, pure air has an <xex>intrinsic value</xex>, but generally not
an <xex>exchangeable value</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Precise signification; import; <as>as, the
<ex>value</ex> of a word; the <ex>value</ex> of a legal
instrument</as></def> <rj><au>Mitford.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Esteem; regard.</def> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>My relation to the person was so near, and my <qex>value</qex> for
him so great</q> <rj><qau>Bp. Burnet.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Mus.)</fld> <def>The relative length or duration of
a tone or note, answering to <xex>quantity</xex> in prosody; thus, a
quarter note [<?/] has the <xex>value</xex> of two eighth notes
[<?/].</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>In an artistical composition, the character of any
one part in its relation to other parts and to the whole; -- often used
in the plural; <as>as, the <ex>values</ex> are well given, or well
maintained</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Valor.</def> <altsp>[Written also
<asp>valew</asp>.]</altsp> <mark>[Obs.]</mark>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <sd>(a)</sd> <def>That property of a color by which it is
distinguished as bright or dark; luminosity.</def> <sd>(b)</sd>
<def>Degree of lightness as conditioned by the presence of white or pale
color, or their opposites.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>9.</sn> <fld>(Math.)</fld> <def>Any particular quantitative
determination; <as>as, a function's <ex>value</ex> for some special
value of its argument</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>10.</sn> [<pluf>pl.</pluf>] <def>The valuable ingredients to be
obtained by treatment from any mass or compound; specif., the precious
metals contained in rock, gravel, or the like; <as>as, the vein carries
good <ex>values</ex>; the <ex>values</ex> on the hanging
walls</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><col><b>Value received</b></col>, <cd>a phrase usually employed
in a bill of exchange or a promissory note, to denote that a
consideration has been given for it.</cd>
<rj><au>Bouvier.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Value</ent><br/
<hw>Val"ue</hw> <pr>(v<acr/l"<umac/)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Valued</conjf>
<pr>(v<acr/l"<umac/d)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Valuing</conjf>.]</vmorph><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To estimate the value, or worth, of; to rate at a
certain price; to appraise; to reckon with respect to number, power,
importance, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The mind doth <qex>value</qex> every moment.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The queen is <qex>valued</qex> thirty thousand strong.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The king must take it ill,<br/
That he's so slightly <qex>valued</qex> in his messenger.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Neither of them <qex>valued</qex> their promises according to
rules of honor or integrity.</q> <rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To rate highly; to have in high esteem; to hold in
respect and estimation; to appreciate; to prize; <as>as, to
<ex>value</ex> one for his works or his virtues</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Which of the dukes he <qex>values</qex> most.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To raise to estimation; to cause to have value,
either real or apparent; to enhance in value.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Some <qex>value</qex> themselves to their country by jealousies of
the crown.</q> <rj><qau>Sir W. Temple.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To be worth; to be equal to in value.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The peace between the French and us not <qex>values</qex><br/
The cost that did conclude it.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To compute; rate; appraise; esteem; respect;
regard; estimate; prize; appreciate.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valued</ent><br/
<hw>Val"ued</hw> <pr>(v<acr/l"<umac/d)</pr>, <pos>a.</pos> <def>Highly
regarded; esteemed; prized; <as>as, a <ex>valued</ex> contributor; a
<ex>valued</ex> friend</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valued policy</ent><br/
<hw>Val"ued pol"i*cy</hw>. <fld>(Fire Insurance)</fld> <def>A policy in
which the value of the goods, property, or interest insured is
specified; -- opposed to <contr>open policy</contr>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Valued-policy law</ent><br/
<hw>Valued-policy law</hw>. <fld>(Fire Insurance)</fld> <def>A law
requiring insurance companies to pay to the insured, in case of total
loss, the full amount of the insurance, regardless of the actual value
of the property at the time of the loss.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Valueless</ent><br/
<hw>Val"ue*less</hw>, <pos>a.</pos> <def>Being of no value; having no
worth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valuer</ent><br/
<hw>Val"u*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who values; an
appraiser.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valure</ent><br/
<hw>Val"ure</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Value.</def>
<mark>[Obs.]</mark> <rj><au>Ld. Berners.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valvar</ent><br/
<ent>Valval</ent><br/
<mhw>{ <hw>Valv"al</hw> <pr>(?)</pr>, <hw>Valv"ar</hw> <pr>(?)</pr>
}</mhw>, <pos>a.</pos> <fld>(Biol.)</fld> <def>Valvular.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Valvasor</ent><br/
<hw>Val"va*sor</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Feud. Law)</fld>
<def>See <er>Vavasor</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valvata</ent><br/
\'d8<hw>Val*va"ta</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.; cf. L.
<ets>valvatus</ets> having folding doors. See <er>Valve</er>.]</ety>
<fld>(Zool.)</fld> <def>A genus of small spiral fresh-water gastropods
having an operculum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valvate</ent><br/
<hw>Valv"ate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>valvatus</ets> having folding doors.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Resembling, or serving as, a valve; consisting of,
or opening by, a valve or valves; valvular.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <sd>(a)</sd> <def>Meeting at the edges
without overlapping; -- said of the sepals or the petals of flowers in
aestivation, and of leaves in vernation.</def> <sd>(b)</sd> <def>Opening
as if by doors or valves, as most kinds of capsules and some
anthers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valve</ent><br/
<hw>Valve</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>valva</ets> the
leaf, fold, or valve of a door: cf. F. <ets>valve</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A door; especially, one of a pair of folding doors,
or one of the leaves of such a door.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Swift through the <qex>valves</qex> the visionary fair<br/
Repassed.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Heavily closed, . . . the <qex>valves</qex> of the barn doors.</q>
<rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A lid, plug, or cover, applied to an aperture so
that by its movement, as by swinging, lifting and falling, sliding,
turning, or the like, it will open or close the aperture to permit or
prevent passage, as of a fluid.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A <xex>valve</xex> may act automatically so as to be
opened by the effort of a fluid to pass in one direction, and closed by
the effort to pass in the other direction, as a <xex>clack valve</xex>;
or it may be opened or closed by hand or by mechanism, as a <xex>screw
valve</xex>, or a <xex>slide valve</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Anat.)</fld> <def>One or more membranous
partitions, flaps, or folds, which permit the passage of the contents of
a vessel or cavity in one direction, but stop or retard the flow in the
opposite direction; <as>as, the ileocolic, mitral, and semilunar
<ex>valves</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Bot.)</fld> <sd>(a)</sd> <def>One of the pieces
into which a capsule naturally separates when it bursts.</def>
<sd>(b)</sd> <def>One of the two similar portions of the shell of a
diatom.</def> <sd>(c)</sd> <def>A small portion of certain anthers,
which opens like a trapdoor to allow the pollen to escape, as in the
barberry.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Zool.)</fld> <def>One of the pieces or divisions of
bivalve or multivalve shells.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Air valve</b></col>, <col><b>Ball valve</b></col>,
<col><b>Check valve</b></col></mcol>, <cd>etc. See under <er>Air</er>.
<er>Ball</er>, <er>Check</er>, etc.</cd> -- <col><b>Double-beat
valve</b></col>, <cd>a kind of balance valve usually consisting of a
movable, open-ended, turban-shaped shell provided with two faces of
nearly equal diameters, one above another, which rest upon two
corresponding seats when the valve is closed.</cd> --
<col><b>Equilibrium valve</b></col>. <sd>(a)</sd> <cd>A balance valve.
See under <er>Balance</er>.</cd> <sd>(b)</sd> <cd>A valve for permitting
air, steam, water, etc., to pass into or out of a chamber so as to
establish or maintain equal pressure within and without.</cd> --
<col><b>Valve chest</b></col> <fld>(Mach.)</fld>, <cd>a chamber in which
a valve works; especially <fld>(Steam Engine)</fld>, the steam chest; --
called in England <altname>valve box</altname>, and <altname>valve
casing</altname>. See <cref>Steam chest</cref>, under
<er>Steam</er>.</cd> -- <col><b>Valve face</b></col> <fld>(Mach.)</fld>,
<cd>that part of the surface of a valve which comes in contact with the
<cref>valve seat</cref>.</cd> -- <mcol><col><b>Valve gear</b></col>,
<it>or</it> <col><b>Valve motion</b></col></mcol> <fld>(Steam
Engine)</fld>, <cd>the system of parts by which motion is given to the
valve or valves for the distribution of steam in the cylinder. For an
illustration of one form of <ex>valve gear</ex>, see <er>Link
motion</er>.</cd> -- <col><b>Valve seat</b></col>. <fld>(Mach.)</fld>
<sd>(a)</sd> <cd>The fixed surface on which a valve rests or against
which it presses.</cd> <sd>(b)</sd> <cd>A part or piece on which such a
surface is formed.</cd> -- <col><b>Valve stem</b></col>
<fld>(Mach.)</fld>, <cd>a rod attached to a valve, for moving it.</cd>
-- <col><b>Valve yoke</b></col> <fld>(Mach.)</fld>, <cd>a strap
embracing a slide valve and connecting it to the valve
stem.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valved</ent><br/
<hw>Valved</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having a valve or
valves; valvate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valvelet</ent><br/
<hw>Valve"let</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A little valve; a
valvule; especially, one of the pieces which compose the outer covering
of a pericarp.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valve-shell</ent><br/
<hw>Valve"-shell`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>Any fresh-water gastropod of the genus
<gen>Valvata</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valvula</ent><br/
\'d8<hw>Val"vu*la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Valvulae</plw> <pr>(#)</pr>.</plu> <ety>[NL., dim. fr. L.
<ets>valva</ets> fold, valve of a door.]</ety> <fld>(Anat.)</fld> <def>A
little valve or fold; a valvelet; a valvule.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valvular</ent><br/
<hw>Valv"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>valvulaire</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Of or pertaining to a valve or valves; specifically
<fld>(Med.)</fld>, of or pertaining to the valves of the heart; <as>as,
<ex>valvular</ex> disease</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Containing valves; serving as a valve; opening by
valves; valvate; <as>as, a <ex>valvular</ex> capsule</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valvule</ent><br/
<hw>Valv"ule</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>valvule</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A little valve; a valvelet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A small valvelike
process.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Valylene</ent><br/
<hw>Val"yl*ene</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Vale</ets>rian + <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld>
<def>A volatile liquid hydrocarbon, <chform>C5H6</chform>, related to
ethylene and acetylene, but possessing the property of unsaturation in
the third degree. It is the only known member of a distinct series of
compounds. It has a garlic odor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vambrace</ent><br/
<hw>Vam"brace</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Vantbrass</er>.]</ety> <fld>(Anc. Armor)</fld> <def>The piece
designed to protect the arm from the elbow to the wrist.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>vamoose</ent><br/
<hw>va*moose"</hw> <pr>(v<acr/*m<oomac/s")</pr>, <pos>v. i. & t.</pos>
<ety>[Sp. <ets>vamos</ets> let us go.]</ety> <def>To depart quickly; to
depart from.</def> <altsp>[Written also <asp>vamos</asp>, and
<asp>vamose</asp>.]</altsp> <mark>[Slang, Eng. & U. S.]</mark><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>vamose</ent><br/
<hw>va*mose"</hw> <pr>(v<adot/*m<omac/s")</pr>, <pos>v. i. & t.</pos>
<ety>[Sp. <ets>vamos</ets> let us go.]</ety> <def>To vamoose; -- an
older spelling and pronunciation variant.</def> <altsp>[Written also
<asp>vamos</asp>, and <asp>vamoose</asp>.]</altsp> <mark>[Slang, Eng. &
U. S.]</mark><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Vamp</ent><br/
<hw>Vamp</hw> <pr>(v<acr/mp)</pr>, <pos>v. i.</pos> <def>To advance; to
travel.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vamp</ent><br/
<hw>Vamp</hw>, <pos>n.</pos> <ety>[OE. <ets>vampe</ets>,
<ets>vaumpe</ets>, <ets>vauntpe</ets>, F. <ets>avantpied</ets> the
forefoot, vamp; <ets>avant</ets> before, fore + <ets>pied</ets> foot, L.
<ets>pes</ets>. See <er>Advance</er>, <er>Van</er> of an army, and
<er>Foot</er>.]</ety> <sn>1.</sn> <def>The part of a boot or shoe above
the sole and welt, and in front of the ankle seam; an upper.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any piece added to an old thing to give it a new
appearance. See <er>Vamp</er>, <pos>v. t.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Music)</fld> <def>A usually improvized Jazz
accompaniment, consisting of simple chords in sucession.</def><br/
[<source>PJC</source>]</p>

<p><ent>vamp</ent><br/
<hw>vamp</hw>, <pos>n.</pos> <def>A woman who seduces men with her charm
and wiles, in order to exploit them.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vamp</ent><br/
<hw>Vamp</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Vamped</conjf> <pr>(?; 215)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vamping</conjf>.]</vmorph> <sn>1.</sn> <def>To provide, as a
shoe, with new upper leather; hence, to to piece, as any old thing, with
a new part; to repair; to patch; -- often followed by
<ptcl>up</ptcl>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I had never much hopes of your <qex>vamped</qex> play.</q>
<rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To create with little skill; to concoct; to invent;
-- usually with <ptcl>up</ptcl>; <as>as, he <ex>vamped</ex> up an
implausible excuse</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>vamp</ent><br/
<hw>vamp</hw>, <pos>v. t. & i.</pos> <def>To seduce (a man) sexually for
purpose of exploitation.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vamper</ent><br/
<hw>Vamp"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who
vamps; one who pieces an old thing with something new; a
cobbler.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Same as 2nd <er>vamp</er>, <pos>n.</pos></def><br/
[<source>PJC</source>]</p>

<p><ent>Vamper</ent><br/
<hw>Vamp"er</hw>, <pos>v. i.</pos> <ety>[Cf. <er>Vaunt</er>.]</ety>
<def>To swagger; to make an ostentatious show.</def> <mark>[Prov. Eng. &
Scot.]</mark> <rj><au>Jamieson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vampire</ent><br/
<hw>Vam"pire</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vampire</ets> (cf. It. <ets>vampiro</ets>, G. & D.
<ets>vampir</ets>), fr. Servian <ets>vampir</ets>.]</ety>
<altsp>[Written also <asp>vampyre</asp>.]</altsp> <sn>1.</sn> <def>A
blood-sucking ghost; a soul of a dead person superstitiously believed to
come from the grave and wander about by night sucking the blood of
persons asleep, thus causing their death. This superstition was once
prevalent in parts of Eastern Europe, and was especially current in
Hungary about the year 1730. The <ex>vampire</ex> was often said to have
the ability to transform itself into the form of a bat, as presented in
the novel depicting the legend of <persfn>Dracula</persfn> published by
<person>Bram Stoker</person> in 1897, which has inspired several
movies.</def><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><q>The persons who turn <qex>vampires</qex> are generally wizards,
witches, suicides, and persons who have come to a violent end, or have
been cursed by their parents or by the church,</q> <rj><qau>Encyc.
Brit.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: One who lives by preying on others; an
extortioner; a bloodsucker.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>Either one of two or more species
of South American blood-sucking bats belonging to the genera
<gen>Desmodus</gen> and <gen>Diphylla</gen>; also called
<altname>vampire bat</altname>. These bats are destitute of molar teeth,
but have strong, sharp cutting incisors with which they make punctured
wounds from which they suck the blood of horses, cattle, and other
animals, as well as man, chiefly during sleep. They have a caecal
appendage to the stomach, in which the blood with which they gorge
themselves is stored.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>Any one of several species of
harmless tropical American bats of the genus <gen>Vampyrus</gen>,
especially <spn>Vampyrus spectrum</spn>. These bats feed upon insects
and fruit, but were formerly erroneously supposed to suck the blood of
man and animals. Called also <altname>false vampire</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vampire bat</b></col> <fld>(Zool.)</fld>, <cd>a vampire,
3.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- illustr. Head of False Vampire. (Vampyrus spectrum) --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vampirism</ent><br/
<hw>Vam"pir*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vampirisme</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Belief in the existence of vampires.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The actions of a vampire; the practice of
bloodsucking.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Fig.: The practice of extortion.</def>
<rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vamplate</ent><br/
<hw>Vam"plate`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>avant</ets> before, fore + E. <ets>plate</ets>.]</ety> <def>A round
plate of iron on the shaft of a tilting spear, to protect the
hand.</def> <altsp>[Written also <asp>vamplet</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vamure</ent><br/
<hw>Va"mure</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Vauntmure</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Van</ent><br/
<hw>Van</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Abbrev. fr.
<ets>vanguard</ets>.]</ety> <def>The front of an army; the first line or
leading column; also, the front line or foremost division of a fleet,
either in sailing or in battle.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Standards and gonfalons, twixt <qex>van</qex> and rear,<br/
Stream in the air.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Van</ent><br/
<hw>Van</hw>, <pos>n.</pos> <ety>[Cornish.]</ety> <fld>(Mining)</fld>
<def>A shovel used in cleansing ore.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Van</ent><br/
<hw>Van</hw>, <pos>v. t.</pos> <fld>(Mining)</fld> <def>To wash or
cleanse, as a small portion of ore, on a shovel.</def>
<rj><au>Raymond.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Van</ent><br/
<hw>Van</hw>, <pos>n.</pos> <ety>[Abbreviated from
<ets>caravan</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A light wagon, either covered or open, used by
tradesmen and others for the transportation of goods.</def>
<mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A large covered wagon for moving furniture, etc.,
also for conveying wild beasts, etc., for exhibition.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A closed railway car for baggage. See the Note under
<er>Car</er>, 2.</def> <mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Van</ent><br/
<hw>Van</hw>, <pos>n.</pos> <ety>[L. <ets>vannus</ets> a van, or fan for
winnowing grain: cf. F. <ets>van</ets>. Cf. <er>Fan</er>, <er>Van</er> a
wing <er>Winnow</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A fan or other contrivance, as a sieve, for
winnowing grain.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[OF. <ets>vanne</ets>, F. <ets>vanneau</ets> beam
feather (cf. It. <ets>vanno</ets> a wing) fr. L. <ets>vannus</ets>. See
Etymology above.]</ety> <def>A wing with which the air is beaten.</def>
<mark>[Archaic]</mark> <ldquo/[/Angels] on their plumy <xex>vans</xex>
received him. <rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He wheeled in air, and stretched his <qex>vans</qex> in vain;<br/
His <qex>vans</qex> no longer could his flight sustain.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Van</ent><br/
<hw>Van</hw>, <pos>v. t.</pos> <ety>[Cf. F. <ets>vanner</ets> to winnow,
to fan. See <er>Van</er> a winnowing machine.]</ety> <def>To fan, or to
cleanse by fanning; to winnow.</def> <mark>[Obs.]</mark>
<rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanadate</ent><br/
<hw>Van"a*date</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vanadate</ets>.]</ety> <fld>(Chem.)</fld> <def>A salt of vanadic
acid.</def> <altsp>[Formerly also <asp>vanadiate</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanadic</ent><br/
<hw>Va*nad"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld>
<def>Pertaining to, or obtained from, vanadium; containing vanadium;
specifically, designating those compounds in which vanadium has a
relatively higher valence as contrasted with the <contr>vanadous</contr>
compounds; <as>as, <ex>vanadic</ex> oxide</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vanadic acid</b></col> <fld>(Chem.)</fld>, <cd>an acid
analogous to phosphoric acid, not known in the free state but forming a
well-known series of salts.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanadinite</ent><br/
<hw>Va*nad"i*nite</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Min.)</fld>
<def>A mineral occurring in yellowish, brownish, and ruby-red hexagonal
crystals. It consists of lead vanadate with a small proportion of lead
chloride.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanadious</ent><br/
<hw>Va*na"di*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld>
<def>Pertaining to, or containing, vanadium; specifically, designating
those compounds in which vanadium has a lower valence as contrasted with
the <contr>vanadic</contr> compounds; <as>as, <ex>vanadious</ex>
acid</as>. Usually written <altname>vanadous</altname>.</def>
<altsp>[Sometimes written also <asp>vanadous</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanadite</ent><br/
<hw>Van"a*dite</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A salt of vanadious acid, analogous to a nitrite or a
phosphite.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanadium</ent><br/
<hw>Va*na"di*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Icel.
<ets>Vanad<imac/s</ets>, a surname of the Scandinavian goddess
Freya.]</ety> <fld>(Chem.)</fld> <def>A rare element of the
nitrogen-phosphorus group, found combined, in vanadates, in certain
minerals, and reduced as an infusible, grayish-white metallic powder. It
is intermediate between the metals and the non-metals, having both basic
and acid properties. Symbol V (or Vd, rarely). Atomic weight 50.94
(C12=12.000).</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Vanadium bronze</ent><br/
<hw>Va*na"di*um bronze`</hw> <pr>(?)</pr>. <fld>(Chem.)</fld> <def>A
yellow pigment consisting of a compound of vanadium.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vanadous</ent><br/
<hw>Van"a*dous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld>
<def>Of or pertaining to vanadium; obtained from vanadium; -- said of an
acid containing one equivalent of vanadium and two of oxygen;
specifically, designating those compounds in which vanadium has a lower
valence as contrasted with the <contr>vanadic</contr> compounds; <as>as,
<ex>vanadous</ex> acid</as></def> <altsp>[Sometimes written also
<asp>vanadious</asp>.]</altsp>.<br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Vanadyl</ent><br/
<hw>Van"a*dyl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Vanad</ets>ium
+ <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld> <def>The hypothetical
radical <chform>VO</chform>, regarded as a characteristic residue of
certain vanadium compounds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Van-courier</ent><br/
<hw>Van"-cou`ri*er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>avant-courrier</ets>. See <er>Avant</er>, <er>Van</er> of an army,
and <er>Courier</er>, and cf. <er>Avant-courier</er>,
<er>Vaunt-courier</er>.]</ety> <def>One sent in advance; an
avant-courier; a precursor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vandal</ent><br/
<hw>Van"dal</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>Vandalus</ets>, <ets>Vandalius</ets>; of Teutonic origin, and
probably originally signifying, a wanderer. Cf.
<er>Wander</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Anc. Hist.)</fld> <def>One of a Teutonic race,
formerly dwelling on the south shore of the Baltic, the most barbarous
and fierce of the northern nations that plundered Rome in the 5th
century, notorious for destroying the monuments of art and
literature.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, one who willfully destroys or defaces any
work of art or literature, or anything valluable.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>Vandals</qex> of our isle,<br/
Sworn foes to sense and law.</q> <rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vandalic</ent><br/
<ent>Vandal</ent><br/
<mhw>{ <hw>Van"dal</hw> <pr>(?)</pr>, <hw>Van*dal"ic</hw> <pr>(?)</pr>,
}</mhw> <pos>a.</pos> <def>Of or pertaining to the Vandals; resembling
the Vandals in barbarism and destructiveness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vandalism</ent><br/
<hw>Van"dal*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The spirit or
conduct of the Vandals; ferocious cruelty; hostility to the arts and
literature, or willful destruction or defacement of any object of beauty
or value.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vandyke</ent><br/
<hw>Van*dyke"</hw> <pr>(v<acr/n*d<imac/k")</pr>, <pos>a.</pos> <def>Of
or pertaining to the style of <persfn>Vandyke</persfn> the painter; used
or represented by <persfn>Vandyke</persfn>.</def> <ldquo/His
<xex>Vandyke</xex> dress.<rdquo/ <au>Macaulay.</au> <altsp>[Written also
<asp>Vandyck</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vandyke brown</b></col> <fld>(Paint.)</fld>, <cd>a
pigment of a deep semitransparent brown color, supposed to be the color
used by <persfn>Vandyke</persfn> in his pictures.</cd> --
<mcol><col><b>Vandyke collar</b></col> <it>or</it> <col><b>Vandyke
cape</b></col></mcol>, <cd>a broad collar or cape of linen and lace with
a deep pointed or scalloped edge, worn lying on the shoulders; -- so
called from its appearance in pictures by <persfn>Vandyke</persfn>.</cd>
-- <col><b>Vandyke edge</b></col>, <cd>an edge having ornamental
triangular points.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vandyke</ent><br/
<hw>Van*dyke"</hw>, <pos>prop. n.</pos> <def>A picture by
<persfn>Vandyke</persfn>. Also, a Vandyke collar, or a Vandyke
edge.</def> <altsp>[Written also <asp>Vandyck</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vandyke</ent><br/
<hw>Van*dyke"</hw>, <pos>v. t.</pos> <def>To fit or furnish with a
Vandyke; to form with points or scallops like a Vandyke.</def>
<mark>[R.]</mark> <altsp>[Written also <asp>Vandyck</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vandyke beard</ent><br/
<hw>Van*dyke" beard`</hw>. <def>A trim, pointed beard, such as those
often seen in pictures by <etsep>Vandyke</etsep>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vane</ent><br/
<hw>Vane</hw> <pr>(v<amac/n)</pr>, <pos>n.</pos> <ety>[OE. & Prov. E.
<ets>fane</ets> weathercock, banner, AS. <ets>fana</ets> a banner, flag;
akin to D. <ets>vaan</ets>, G. <ets>fahne</ets>, OHG. <ets>fano</ets>
cloth, gund <ets>fano</ets> flag, Icel. <ets>f<amac/ni</ets>, Sw.
<ets>fana</ets>, Dan. <ets>fane</ets>, Goth. <ets>fana</ets> cloth, L.
<ets>pannus</ets>, and perhaps to Gr. <grk>ph^nos</grk> a web,
<grk>phni`on</grk> a bobbin, spool. Cf. <er>Fanon</er>, <er>Pane</er> a
compartment, panel.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1594 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A contrivance attached to some elevated object for
the purpose of showing which way the wind blows; a weathercock. It is
usually a plate or strip of metal, or slip of wood, often cut into some
fanciful form, and placed upon a perpendicular axis around which it
moves freely.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Aye undiscreet, and changing as a <qex>vane</qex>.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any flat, extended surface attached to an axis and
moved by the wind; <as>as, the <ex>vane</ex> of a windmill</as>; hence,
a similar fixture of any form moved in or by water, air, or other fluid;
<as>as, the <ex>vane</ex> of a screw propeller, a fan blower, an
anemometer, etc</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>The rhachis and web of a feather
taken together.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>One of the sights of a compass, quadrant,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vane of a leveling staff</b></col>. <fld>(Surv.)</fld>
<cd>Same as <er>Target</er>, 3.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanessa</ent><br/
\'d8<hw>Van*es"sa</hw> <pr>(v<acr/n*<ecr/s"s<adot/)</pr>, <pos>n.</pos>
<ety>[Probably from Swift's poem of Cadenus and <etsep>Vanessa</etsep>.
See <er>Vanessa</er>, in the Dictionary of Noted Names in
Fiction.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous species of
handsomely colored butterflies belonging to <gen>Vanessa</gen> and
allied genera. Many of these species have the edges of the wings
irregularly scalloped.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanessian</ent><br/
<hw>Van*es"si*an</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>A vanessa.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanfoss</ent><br/
<hw>Van"foss`</hw> <pr>(v<acr/n"f<ocr/s`)</pr>, <pos>n.</pos> <ety>[F.
<ets>avant-foss<eacute/</ets>; <ets>avant</ets> before +
<ets>foss<eacute/</ets> ditch. Cf. <er>Fosse</er>.]</ety>
<fld>(Fort.)</fld> <def>A ditch on the outside of the counterscarp,
usually full of water.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vang</ent><br/
<hw>Vang</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[D. <ets>vangen</ets> to
catch, seize. See <er>Fang</er>.]</ety> <fld>(Naut.)</fld> <def>A rope
to steady the peak of a gaff.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanglo</ent><br/
<hw>Van"glo</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>Benne (<spn>Sesamum orientale</spn>); also, its seeds; -- so called
in the West Indies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanguard</ent><br/
<hw>Van"guard`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[For
<ets>vantguard</ets>, <ets>avantguard</ets>, F. <ets>avant-garde</ets>;
<ets>avant</ets> before, fore + <ets>garde</ets> guard. See
<er>Avant</er>, <er>Ab-</er>,<er>Ante-</er>, and <er>Guard</er>, and cf.
<er>Advance</er>, <er>Vamp</er>, <er>Van</er> of an army,
<er>Vaward</er>.]</ety> <fld>(Mil.)</fld> <def>The troops who march in
front of an army; the advance guard; the van.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanilla</ent><br/
<hw>Va*nil"la</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Sp.
<ets>vainilla</ets>, dim. of Sp. <ets>vaina</ets> a sheath, a pod, L.
<ets>vagina</ets>; because its grains, or seeds, are contained in little
pods.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Bot.)</fld> <def>A genus of climbing orchidaceous
plants, natives of tropical America.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The long podlike capsules of <spn>Vanilla
planifolia</spn>, and <spn>Vanilla claviculata</spn>, remarkable for
their delicate and agreeable odor, for the volatile, odoriferous oil
extracted from them; also, the flavoring extract made from the capsules,
extensively used in confectionery, perfumery, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ As a medicine, <xex>vanilla</xex> is supposed to possess
powers analogous to valerian, while, at the same time, it is far more
grateful.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Cuban vanilla</b></col>, <cd>a sweet-scented West Indian
composite shrub (<spn>Eupatorium Dalea</spn>).</cd> -- <col><b>Vanilla
bean</b></col>, <cd>the long capsule of the vanilla plant.</cd> --
<col><b>Vanilla grass</b></col>. <cd>Same as <cref>Holy grass</cref>,
under <er>Holy</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanillate</ent><br/
<hw>Va*nil"late</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A salt of vanillic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanillic</ent><br/
<hw>Va*nil"lic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld>
<def>Pertaining to, or derived from, vanilla or vanillin; resembling
vanillin; specifically, designating an alcohol and an acid respectively,
vanillin being the intermediate aldehyde.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanillin</ent><br/
<hw>Va*nil"lin</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A white crystalline aldehyde having a burning taste and
characteristic odor of vanilla. It is extracted from vanilla pods, and
is also obtained by the decomposition of coniferin, and by the oxidation
of eugenol.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanilloes</ent><br/
<hw>Va*nil"loes</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>An inferior
kind of vanilla, the pods of <spn>Vanilla Pompona</spn>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanillyl</ent><br/
<hw>Va*nil"lyl</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Vanill</ets>ic + <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld>
<def>The hypothetical radical characteristic of vanillic
alcohol.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaniloquence</ent><br/
<hw>Va*nil"o*quence</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vaniloquentia</ets>; <ets>vanus</ets> vain + <ets>loquentia</ets>
talk, <ets>loqui</ets> to speak.]</ety> <def>Vain or foolish talk.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaniloquent</ent><br/
<hw>Va*nil"o*quent</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Talking
foolishly.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanish</ent><br/
<hw>Van"ish</hw> <pr>(v<acr/n"<icr/sh)</pr>, <pos>v. i.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Vanished</conjf>
<pr>(v<acr/n"<icr/sht)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vanishing</conjf>.]</vmorph> <ety>[OE. <ets>vanissen</ets>, OF.
<ets>vanir</ets> (in comp.): cf. OF. <ets>envanir</ets>,
<ets>esvanir</ets>, <ets>esvanu<ium/r</ets>, F.
<ets>s'<eacute/vanouir</ets>; fr. L. <ets>vanus</ets> empty, vain; cf.
L. <ets>vanescere</ets>, <ets>evanescere</ets>, to vanish. See
<er>Vain</er>, and cf. <er>Evanescent</er>,<er>-ish</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To pass from a visible to an invisible state; to go
out of sight; to disappear; to fade; <as>as, vapor <ex>vanishes</ex>
from the sight by being dissipated; a ship <ex>vanishes</ex> from the
sight of spectators on land</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The horse <qex>vanished</qex> . . . out of sight.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Go; <qex>vanish</qex> into air; away!</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The champions <qex>vanished</qex> from their posts with the speed
of lightning.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Gliding from the twilight past to <qex>vanish</qex> among
realities.</q> <rj><qau>Hawthorne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To be annihilated or lost; to pass away.</def>
<ldquo/All these delights will <xex>vanish</xex>.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanish</ent><br/
<hw>Van"ish</hw> <pr>(v<acr/n"<icr/sh)</pr>, <pos>n.</pos>
<fld>(Phon.)</fld> <def>The brief terminal part of a vowel or vocal
element, differing more or less in quality from the main part; <as>as,
<ex>a</ex> as in <ex>ale</ex> ordinarily ends with a <ex>vanish</ex> of
<ex>i</ex> as in <ex>ill</ex>, <ex>o</ex> as in <ex>old</ex> with a
vanish of <ex>oo</ex> as in <ex>foot</ex></as>.</def>
<rj><au>Rush.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>vanish</xex> is included by Mr. Bell under the
general term <xex>glide</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanishing</ent><br/
<hw>Van"ish*ing</hw> <pr>(?)</pr>, <def><pos>a. & n.</pos> from
<er>Vanish</er>, <pos>v.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vanishing fraction</b></col> <fld>(Math.)</fld>, <cd>a
fraction which reduces to the form <frac00/ for a particular value of
the variable which enters it, usually in consequence of the existence of
a common factor in both terms of the fraction, which factor becomes 0
for this particular value of the variable.</cd> <au>Math. Dict.</au> --
<col><b>Vanishing line</b></col> <fld>(Persp.)</fld>, <cd>the
intersection of the parallel of any original plane and the picture; one
of the lines converging to the vanishing point.</cd> --
<col><b>Vanishing point</b></col> <fld>(Persp.)</fld>, <cd>the point to
which all parallel lines in the same plane tend in the
representation.</cd> <au>Gwilt.</au> -- <col><b>Vanishing
stress</b></col> <fld>(Phon.)</fld>, <cd>stress of voice upon the
closing portion of a syllable.</cd> <au>Rush.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanishment</ent><br/
<hw>Van"ish*ment</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A
vanishing.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanity</ent><br/
<hw>Van"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vanities</plw> <pr>(#)</pr>.</plu> <ety>[OE. <ets>vanite</ets>, F.
<ets>vanit<eacute/</ets>, L. <ets>vanitas</ets>, fr. <ets>vanus</ets>
empty, vain. See <er>Vain</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The quality or state of being vain; want of
substance to satisfy desire; emptiness; unsubstantialness; unrealness;
falsity.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vanity</qex> of vanities, saith the Preacher,
<qex>vanity</qex> of vanities; all is <qex>vanity</qex>.</q>
<rj><qau>Eccl. i. 2.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Here I may well show the <qex>vanity</qex> of that which is
reported in the story of Walsingham.</q> <rj><qau>Sir J.
Davies.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An inflation of mind upon slight grounds; empty
pride inspired by an overweening conceit of one's personal attainments
or decorations; an excessive desire for notice or approval; pride;
ostentation; conceit.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The exquisitely sensitive <qex>vanity</qex> of Garrick was
galled.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That which is vain; anything empty, visionary,
unreal, or unsubstantial; fruitless desire or effort; trifling labor
productive of no good; empty pleasure; vain pursuit; idle show;
unsubstantial enjoyment.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Vanity of <qex>vanities</qex>, saith the Preacher.</q>
<rj><qau>Eccl. i. 2.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vanity</qex> possesseth many who are desirous to know the
certainty of things to come.</q> <rj><qau>Sir P. Sidney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>[Sin] with <qex>vanity</qex> had filled the works of men.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Think not, when woman's transient breath is fled,<br/
That all her <qex>vanities</qex> at once are dead;<br/
Succeeding <qex>vanities</qex> she still regards.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>One of the established characters in the old
moralities and puppet shows. See <er>Morality</er>, <pos>n.</pos>,
5.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>You . . . take <qex>vanity</qex> the puppet's part.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>same as <er>dressing table</er>.</def><br/
[<source>PJC</source>]</p>

<p><sn>6.</sn> <def>A cabinet built around a bathroom sink, usually with
a countertop and sometimes drawers.</def><br/
[<source>PJC</source>]</p>

<p><syn><b>Syn.</b> -- Egotism; pride; emptiness; worthlessness;
self-sufficiency. See <er>Egotism</er>, and <er>Pride</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanity box</ent><br/
<hw>Van"i*ty box</hw>. <def>A small box, usually jeweled or of precious
metal and worn on a chain, containing a mirror, powder puff, and other
small toilet articles for a woman.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vanjas</ent><br/
<hw>Van"jas</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The
Australian pied crow shrike (<spn>Strepera graculina</spn>). It is
glossy bluish black, with the under tail coverts and the tips and bases
of the tail feathers white.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanner</ent><br/
<hw>Van"ner</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Mining)</fld> <def>A
machine for concentrating ore. See <er>Frue vanner</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanner hawk</ent><br/
<hw>Van"ner hawk`</hw> <pr>(?)</pr>. <def>The kestrel.</def>
<mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanning</ent><br/
<hw>Van"ning</hw>, <pos>n.</pos> <fld>(Mining)</fld> <def>A process by
which ores are washed on a shovel, or in a vanner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanquish</ent><br/
<hw>Van"quish</hw> <pr>(v<acr/<nsm/"kw<icr/sh)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Vanquished</conjf>
<pr>(v<acr/<nsm/"kw<icr/sht)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vanquishing</conjf>.]</vmorph> <ety>[OE. <ets>venquishen</ets>,
<ets>venquissen</ets>, <ets>venkisen</ets>, F. <ets>vaincre</ets>, pret.
<ets>vainquis</ets>, OF. <ets>veintre</ets>, pret. <ets>venqui</ets>,
<ets>venquis</ets> (cf. an OF. infin. <ets>vainquir</ets>), fr. L.
<ets>vincere</ets>; akin to AS. <ets>w<imac/g</ets> war, battle,
<ets>w<imac/gend</ets> a warrior, <ets>w<imac/gan</ets> to contend,
fight, OHG. <ets>w<imac/gant</ets> a warrior, <ets>w<imac/gan</ets> to
fight, Icel. <ets>v<imac/g</ets> battle, Goth. <ets>weihan</ets> to
fight, contend. Cf. <er>Convince</er>, <er>Evict</er>,
<er>Invincible</er>, <er>Victor</er>.]</ety> <sn>1.</sn> <def>To
conquer, overcome, or subdue in battle, as an enemy.</def>
<rj><au>Hakluyt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They . . . <qex>vanquished</qex> the rebels in all encounters.</q>
<rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, to defeat in any contest; to get the better
of; to put down; to refute.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This bold assertion has been fully <qex>vanquished</qex> in a late
reply to the Bishop of Meaux's treatise.</q>
<rj><qau>Atterbury.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>For e'en though <qex>vanquished</qex>, he could argue still.</q>
<rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To conquer; surmount; overcome; confute; silence.
See <er>Conquer</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanquish</ent><br/
<hw>Van"quish</hw>, <pos>n.</pos> <fld>(Far.)</fld> <def>A disease in
sheep, in which they pine away.</def> <altsp>[Written also
<asp>vinquish</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanquishable</ent><br/
<hw>Van"quish*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>That may be
vanquished.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanquisher</ent><br/
<hw>Van"quish*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that
which, vanquishes.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vanquishment</ent><br/
<hw>Van"quish*ment</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of
vanquishing, or the state of being vanquished.</def> <rj><au>Bp.
Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vansire</ent><br/
<hw>Van"sire</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[The native name: cf.
F. <ets>vansire</ets>.]</ety> <fld>(Zool.)</fld> <def>An ichneumon
(<spn>Herpestes galera</spn>) native of Southern Africa and Madagascar.
It is reddish brown or dark brown, grizzled with white. Called also
<altname>vondsira</altname>, and <altname>marsh
ichneumon</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vant</ent><br/
<hw>Vant</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>See
<er>Vaunt</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vantage</ent><br/
<hw>Van"tage</hw> <pr>(v<adot/n"t<asl/j; 48)</pr>, <pos>n.</pos>
<ety>[Aphetic form of OE. <ets>avantage</ets>, fr. F.
<ets>avantage</ets>. See <er>Advantage</er>.]</ety> <sn>1.</sn>
<def>Superior or more favorable situation or opportunity; gain; profit;
advantage.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>O happy <qex>vantage</qex> of a kneeling knee!</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A position offering a superior view of a scene or
situation; -- used literally and figuratively; <as>as, from the
<ex>vantage</ex> of hindsight</as>; also called <altname>vantage
point</altname>.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <fld>(Tennis)</fld> <def>The first point scored after
deuce; advantage{5}.</def> <mark>[Brit.]</mark> <br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ When the server wins this point, it is called
<xex>vantage in</xex>; when the receiver, or striker out, wins, it is
called <xex>vantage out</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To have at vantage</b></col>, <cd>to have the advantage
of; to be in a more favorable condition than.</cd> <ldquo/He
<xex>had</xex> them <xex>at vantage</xex>, being tired and harassed with
a long march.<rdquo/ <au>Bacon.</au> -- <col><b>Vantage
ground</b></col>, <cd>superiority of state or place; the place or
condition which gives one an advantage over another.</cd> <ldquo/The
<xex>vantage ground</xex> of truth.<rdquo/ <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It is these things that give him his actual standing, and it is
from this <qex>vantage ground</qex> that he looks around him.</q>
<rj><qau>I. Taylor.</qau></rj> </cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vantage</ent><br/
<hw>Van"tage</hw>, <pos>v. t.</pos> <def>To profit; to aid.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vantage game</ent><br/
<hw>Van"tage game</hw>. <fld>(Lawn Tennis)</fld> <def>The first game
after the set is deuce. See <er>Set</er>, <pos>n.</pos>, 9.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vantage point</ent><br/
<hw>Vantage point</hw>. <def>A point giving advantage; vantage
ground.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vantbrass</ent><br/
<ent>Vantbrace</ent><br/
<mhw>{ <hw>Vant"brace</hw> <pr>(v<adot/nt"br<amac/s)</pr>,
<hw>Vant"brass</hw> <pr>(v<adot/nt"br<adot/s)</pr>, }</mhw>
<pos>n.</pos> <ety>[F. <ets>avant</ets> fore + <ets>bras</ets> arm: cf.
F. <ets>brassard</ets> armor for the arm, brace, forearm. Cf.
<er>Vambrace</er>.]</ety> <fld>(Anc. Armor)</fld> <def>Armor for the
arm; vambrace.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vant-courier</ent><br/
<hw>Vant"-cou`ri*er</hw> <pr>(v<adot/nt"k<oomac/`r<icr/*<etil/r)</pr>,
<pos>n.</pos> <def>An avant-courier. See <er>Van-courier</er>.</def>
<mark>[Obs.]</mark> <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Van't Hoff's law</ent><br/
<hw>Van't Hoff's law</hw> <pr>(?)</pr>. <ety>[After <person>J. H.
<etsep>van't Hoff</etsep></person>, Dutch physical chemist.]</ety>
<fld>(Phys. Chem.)</fld> <def>The generalization that: when a system is
in equilibrium, of the two opposed interactions the endothermic is
promoted by raising the temperature, the exothermic by lowering
it.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vanward</ent><br/
<hw>Van"ward</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Being on, or towards,
the van, or front.</def> <ldquo/The <xex>vanward</xex> frontier.<rdquo/
<rj><au>De Quincey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vap</ent><br/
<hw>Vap</hw> <pr>(v<acr/p)</pr>, <pos>n.</pos> <ety>[See
<er>Vapid</er>.]</ety> <def>That which is vapid, insipid, or lifeless;
especially, the lifeless part of liquor or wine.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>In vain it is to wash a goblet, if you mean to put into it nothing
but the dead lees and <qex>vap</qex> of wine.</q> <rj><qau>Jer.
Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vapid</ent><br/
<hw>Vap"id</hw> <pr>(v<acr/p"<icr/d)</pr>, <pos>a.</pos> <ety>[L.
<ets>vapidus</ets> having lost its life and spirit, vapid; akin to
<ets>vappa</ets> vapid wine, <ets>vapor</ets> vapor. See
<er>Vapor</er>.]</ety> <def>Having lost its life and spirit; dead;
spiritless; insipid; flat; dull; unanimated; <as>as, <ex>vapid</ex>
beer; a <ex>vapid</ex> speech; <ex>a vapid</ex> state of the
blood</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A cheap, bloodless reformation, a guiltless liberty, appear flat
and <qex>vapid</qex> to their taste.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vap"id*ly</wf> <pr>(#)</pr>, <pos>adv.</pos> --
<wf>Vap"id*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vapidity</ent><br/
<hw>Va*pid"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being vapid; vapidness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vapor</ent><br/
<hw>Va"por</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>vapour</ets>,
OF. <ets>vapour</ets>, <ets>vapor</ets>, <ets>vapeur</ets>, F.
<ets>vapeur</ets>, L. <ets>vapor</ets>; probably for <ets>cvapor</ets>,
and akin to Gr. <?/ smoke, <?/ to breathe forth, Lith. <ets>kvepti</ets>
to breathe, smell, Russ. <ets>kopote</ets> fine soot. Cf.
<er>Vapid</er>.]</ety> <altsp>[Written also
<asp>vapour</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Physics)</fld> <def>Any substance in the gaseous,
or aeriform, state, the condition of which is ordinarily that of a
liquid or solid.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The term <xex>vapor</xex> is sometimes used in a more
extended sense, as identical with <xex>gas</xex>; and the difference
between the two is not so much one of kind as of degree, the latter
being applied to all permanently elastic fluids except atmospheric air,
the former to those elastic fluids which lose that condition at ordinary
temperatures. The atmosphere contains more or less <xex>vapor</xex> of
water, a portion of which, on a reduction of temperature, becomes
condensed into liquid water in the form of rain or dew. The
<xex>vapor</xex> of water produced by boiling, especially in its
economic relations, is called <xex>steam</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vapor</qex> is any substance in the gaseous condition at the
maximum of density consistent with that condition. This is the strict
and proper meaning of the word <qex>vapor</qex>.</q>
<rj><qau>Nichol.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In a loose and popular sense, any visible diffused
substance floating in the atmosphere and impairing its transparency, as
smoke, fog, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>vapour</qex> which that fro the earth glood [glided].</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Fire and hail; snow and <qex>vapors</qex>; stormy wind fulfilling
his word.</q> <rj><qau>Ps. cxlviii. 8.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Wind; flatulence.</def> <mark>[Obs.]</mark>
<rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Something unsubstantial, fleeting, or transitory;
unreal fancy; vain imagination; idle talk; boasting.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>For what is your life? It is even a <qex>vapor</qex>, that
appeareth for a little time, and then vanisheth away.</q> <rj><qau>James
iv. 14.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <pluf>pl.</pluf> <def>An old name for hypochondria, or
melancholy; the blues.</def> <ldquo/A fit of <xex>vapors</xex>.<rdquo/
<rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Pharm.)</fld> <def>A medicinal agent designed for
administration in the form of inhaled vapor.</def> <rj><au>Brit.
Pharm.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vapor bath</b></col>. <sd>(a)</sd> <cd>A bath in vapor;
the application of vapor to the body, or part of it, in a close place;
also, the place itself.</cd> <sd>(b)</sd> <fld>(Chem.)</fld> <cd>A small
metallic drying oven, usually of copper, for drying and heating filter
papers, precipitates, etc.; -- called also <altname>air bath</altname>.
A modified form is provided with a jacket in the outside partition for
holding water, or other volatile liquid, by which the temperature may be
limited exactly to the required degree.</cd> -- <col><b>Vapor
burner</b></col>, <cd>a burner for burning a vaporized hydrocarbon.</cd>
-- <col><b>Vapor density</b></col> <fld>(Chem.)</fld>, <cd>the relative
weight of gases and vapors as compared with some specific standard,
usually hydrogen, but sometimes air. The vapor density of gases and
vaporizable substances as compared with hydrogen, when multiplied by
two, or when compared with air and multiplied by 28.8, gives the
molecular weight.</cd> -- <col><b>Vapor engine</b></col>, <cd>an engine
worked by the expansive force of a vapor, esp. a vapor other than
steam.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vapor</ent><br/
<hw>Va"por</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Vapored</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vaporing</conjf>.]</vmorph> <ety>[From <er>Vapor</er>,
<pos>n.</pos>: cf. L. <ets>vaporare</ets>.]</ety> <altsp>[Written also
<asp>vapour</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To pass off in fumes, or as a moist, floating
substance, whether visible or invisible, to steam; to be exhaled; to
evaporate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To emit vapor or fumes.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Running waters <qex>vapor</qex> not so much as standing
waters.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To talk idly; to boast or vaunt; to brag.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Poets used to <qex>vapor</qex> much after this manner.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>We <qex>vapor</qex> and say, By this time Matthews has beaten
them.</q> <rj><qau>Walpole.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vapor</ent><br/
<hw>Va"por</hw>, <pos>v. t.</pos> <def>To send off in vapor, or as if in
vapor; <as>as, to <ex>vapor</ex> away a heated fluid</as>.</def>
<altsp>[Written also <asp>vapour</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><q>He'd laugh to see one throw his heart away,<br/
Another, sighing, <qex>vapor</qex> forth his soul.</q> <rj><qau>B.
Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporability</ent><br/
<hw>Vap`o*ra*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality
or state of being vaporable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporable</ent><br/
<hw>Vap"o*ra*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being
converted into vapor by the agency of heat; vaporizable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporate</ent><br/
<hw>Vap"o*rate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[L.
<ets>vaporare</ets>, <ets>vaporatum</ets>. See <er>Vapor</er>.]</ety>
<def>To emit vapor; to evaporate.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporation</ent><br/
<hw>Vap`o*ra"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vaporation</ets>, L. <ets>vaporatio</ets>.]</ety> <def>The act or
process of converting into vapor, or of passing off in vapor;
evaporation.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vapored</ent><br/
<hw>Va"pored</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Wet with
vapors; moist.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Affected with the vapors. See <er>Vapor</er>,
<pos>n.</pos>, 5.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporer</ent><br/
<hw>Va"por*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who vapors; a
braggart.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vaporer moth</b></col>. <fld>(Zool.)</fld> <cd>See
<er>Orgyia</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vapor galvanizing</ent><br/
<hw>Va"por gal"va*niz`ing</hw>. <fld>(Metal.)</fld> <def>A process for
coating metal (usually iron or steel) surfaces with zinc by exposing
them to the vapor of zinc instead of, as in ordinary galvanizing, to
molten zinc; -- called also <altname>Sherardizing</altname>. Vapor
galvanizing is accomplished by heating the articles to be galvanized
together with zinc dust in an air tight receptacle to a temperature of
about 600<deg/ F., which is 188<deg/ below the melting point of zinc, or
by exposing the articles to vapor from molten zinc in a separate
receptacle, using hydrogen or other reducing gas to prevent
oxidation.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vaporiferous</ent><br/
<hw>Vap`o*rif"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vaporifer</ets>; <ets>vapor + ferre</ets> to bear.]</ety>
<def>Conveying or producing vapor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporific</ent><br/
<hw>Vap`o*rif"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vapor</ets> vapor + <ets>facere</ets> to make.]</ety>
<fld>(Chem.)</fld> <def>Producing vapor; tending to pass, or to cause to
pass, into vapor; <as>thus, volatile fluids are <ex>vaporific</ex>; heat
is a <ex>vaporific</ex> agent</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporiform</ent><br/
<hw>Va*por"i*form</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Existing in a
vaporous form or state; <as>as, steam is a <ex>vaporiform</ex>
substance</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporimeter</ent><br/
<hw>Vap`o*rim"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Vapor</ets> + <ets>-meter</ets>.]</ety> <def>An instrument
for measuring the volume or the tension of any vapor; specifically, an
instrument of this sort used as an alcoholometer in testing spirituous
liquors.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporing</ent><br/
<hw>Va"por*ing</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Talking idly;
boasting; vaunting.</def> -- <wordforms><wf>Va"por*ing*ly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporish</ent><br/
<hw>Va"por*ish</hw>, <pos>a.</pos> <sn>1.</sn> <def>Full of vapors;
vaporous.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hypochondriacal; affected by hysterics; splenetic;
peevish; humorsome.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Pallas grew <qex>vap'rish</qex> once and odd.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporizable</ent><br/
<hw>Vap"o*ri`za*ble</hw> <pr>(v<acr/p"<osl/*r<imac/`z<adot/*b'l
<it>or</it> v<amac/"p<etil/r*<imac/`z<adot/*b'l; 110)</pr>,
<pos>a.</pos> <def>Capable of being vaporized, or converted into
vapor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporization</ent><br/
<hw>Vap`o*ri*za"tion</hw> <pr>(v<acr/p`<osl/*r<imac/*z<adot/"sh<ucr/n
<it>or</it> v<amac/`p<etil/r*<imac/*z<adot/"sh<ucr/n)</pr>,
<pos>n.</pos> <ety>[Cf. F. <ets>vaporisation</ets>.]</ety> <def>The act
or process of vaporizing, or the state of being converted into vapor;
the artificial formation of vapor; specifically, the conversion of water
into steam, as in a steam boiler.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1595 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporize</ent><br/
<hw>Vap"o*rize</hw> <pr>(v<acr/p"<osl/*r<imac/z <it>or</it>
v<amac/"p<etil/r*<imac/z)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Vaporized</conjf> <pr>(-r<imac/zd)</pr>; <pos>p. pr. &
vb. n.</pos> <conjf>Vaporizing</conjf>
<pr>(-r<imac/`z<icr/ng)</pr>.]</vmorph> <ety>[Cf. F.
<ets>vaporiser</ets>.]</ety> <def>To convert into vapor, as by the
application of heat, whether naturally or artificially.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vaporizing surface</b></col>. <fld>(Steam Boilers)</fld>
<cd>See <cref>Evaporating surface</cref>, under <er>Evaporate</er>,
<pos>v. t.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporize</ent><br/
<hw>Vap"o*rize</hw>, <pos>v. i.</pos> <def>To pass off in
vapor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporizer</ent><br/
<hw>Vap"o*ri`zer</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that
which, vaporizes, or converts into vapor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporose</ent><br/
<hw>Va"por*ose`</hw> <pr>(v<amac/"p<etil/r*<omac/s`)</pr>, <pos>a.</pos>
<def>Full of vapor; vaporous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporous</ent><br/
<hw>Va"por*ous</hw> <pr>(v<amac/"p<etil/r*<ucr/s`)</pr>, <pos>a.</pos>
<ety>[L. <ets>vaporosus</ets>: cf. F. <ets>vaporeux</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Having the form or nature of vapor.</def>
<rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Full of vapors or exhalations.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The warmer and more <qex>vaporous</qex> air of the valleys.</q>
<rj><qau>Derham.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Producing vapors; hence, windy; flatulent.</def>
<rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The food which is most <qex>vaporous</qex> and perspirable is the
most easily digested.</q> <rj><qau>Arbuthnot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Unreal; unsubstantial; vain; whimsical.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Such <qex>vaporous</qex> speculations were inevitable.</q>
<rj><qau>Carlyle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaporousness</ent><br/
<hw>Va"por*ous*ness</hw>, <pos>n.</pos> <def>The quality of being
vaporous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vapor tension</ent><br/
<ent>Vapor pressure</ent><br/
<mhw>{ <hw>Vapor pressure</hw> <it>or</it> <hw>Vapor tension</hw>
}</mhw>. <fld>(Physics)</fld> <def>The pressure or tension of a confined
body of vapor of a chemical substance in equilibrium with the solid or
liquid form of the substance. The pressure of a given saturated vapor is
a function of the temperature only, and may be measured by introducing a
small quantity of the substance into a barometer and noting the
depression of the column of mercury.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Vapory</ent><br/
<hw>Va"por*y</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Full of
vapors; vaporous.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hypochondriacal; splenetic; peevish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vapulation</ent><br/
<hw>Vap`u*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vapulare</ets> to be flogged.]</ety> <def>The act of beating or
whipping.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaquero</ent><br/
\'d8<hw>Va*que"ro</hw> <pr>(v<aum/*k<asl/"r<osl/)</pr>, <pos>n.</pos>
<ety>[Sp., cowherd, fr. <ets>vaca</ets> a cow, L. <ets>vacca</ets>. Cf.
<er>Vacher</er>.]</ety> <def>One who has charge of cattle, horses, etc.;
a herdsman; a cowboy.</def> <mark>[Southwestern U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vara</ent><br/
\'d8<hw>Va"ra</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. See 1st
<er>Vare</er>.]</ety> <def>A Spanish measure of length equal to about
one yard. The vara now in use equals 33.385 inches.</def>
<rj><au>Johnson's Cyc.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varan</ent><br/
<hw>Va"ran</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<fld>(Zool.)</fld> <def>The monitor. See <er>Monitor</er>, 3.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varangian</ent><br/
<hw>Va*ran"gi*an</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One of the
Northmen who founded a dynasty in Russia in the 9th century; also, one
of the Northmen composing, at a later date, the imperial bodyguard at
Constantinople.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varanus</ent><br/
\'d8<hw>Va*ra"nus</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <ety>[NL., fr.
Ar. <ets>uaran</ets>, <ets>uaral</ets>; cf. F. <ets>varan</ets>, from
the Arabic.]</ety> <fld>(Zool.)</fld> <def>A genus of very large lizards
native of Asia and Africa. It includes the monitors. See
<er>Monitor</er>, 3.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vare</ent><br/
<hw>Vare</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. <ets>vara</ets>
staff, wand, L. <ets>vara</ets> forked pole.]</ety> <def>A wand or staff
of authority or justice.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>His hand a <qex>vare</qex> of justice did uphold.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vare</ent><br/
<hw>Vare</hw>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A weasel.</def>
<mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vare widgeon</b></col> <fld>(Zool.)</fld>, <cd>a female
or young male of the smew; a weasel duck; -- so called from the
resemblance of the head to that of a <xex>vare</xex>, or weasel.</cd>
<mark>[Prov. Eng.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varec</ent><br/
<hw>Var"ec</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>varech</ets>;
of Teutonic origin. See <er>Wrack</er> seaweed, wreck.]</ety> <def>The
calcined ashes of any coarse seaweed used for the manufacture of soda
and iodine; also, the seaweed itself; fucus; wrack.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vargueno</ent><br/
<hw>Var*gue"no</hw> <pr>(v<aum/r*g<amac/"n<omac/)</pr>, <pos>n.</pos>
<ety>[Said to be fr. <ets>Vargas</ets>, name of a village in
Spain.]</ety> <fld>(Art)</fld> <def>A decorative cabinet, of a form
originating in Spain, the body being rectangular and supported on legs
or an ornamental framework and the front opening downwards on hinges to
serve as a writing desk.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vari</ent><br/
\'d8<hw>Va"ri</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vari</ets>.]</ety> <fld>(Zool.)</fld> <def>The ringtailed lemur
(<spn>Lemur catta</spn>) of Madagascar. Its long tail is annulated with
black and white.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variability</ent><br/
<hw>Va`ri*a*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>variabilit<eacute/</ets>.]</ety> <sn>1.</sn> <def>The quality or
state of being variable; variableness.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Biol.)</fld> <def>The power possessed by living
organisms, both animal and vegetable, of adapting themselves to
modifications or changes in their environment, thus possibly giving rise
to ultimate variation of structure or function.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variable</ent><br/
<hw>Va"ri*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>variabilis</ets>: cf. F. <ets>variable</ets>.]</ety> <sn>1.</sn>
<def>Having the capacity of varying or changing; capable of alternation
in any manner; changeable; <as>as, <ex>variable</ex> winds or seasons; a
<ex>variable</ex> quantity.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Liable to vary; too susceptible of change; mutable;
fickle; unsteady; inconstant; <as>as, the affections of men are
<ex>variable</ex>; passions are <ex>variable</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Lest that thy love prove likewise <qex>variable</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>His heart, I know, how <qex>variable</qex> and vain!</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Variable exhaust</b></col> <fld>(Steam Eng.)</fld>, <cd>a
blast pipe with an adjustable opening.</cd> -- <col><b>Variable
quantity</b></col> <fld>(Math.)</fld>, <cd>a variable.</cd> --
<col><b>Variable-rate mortgage</b></col> <fld>(Finance)</fld>, <cd>a
mortgage whose percentage interest rate varies depending on some agreed
standard, such as the prime rate; -- used often in financing the
purchase of a home. Such a mortgage usually has a lower initial interest
rate than a <contr>fixed-rate mortgage</contr>, and this permits buyers
of a home to finance the purchase a house of higher price than would be
possible with a fixed-rate loan.</cd> -- <col><b>Variable
stars</b></col> <fld>(Astron.)</fld>, <cd>fixed stars which vary in
their brightness, usually in more or less uniform periods.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Changeable; mutable; fickle; wavering; unsteady;
versatile; inconstant.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variable</ent><br/
<hw>Va"ri*a*ble</hw>, <pos>n.</pos> <sn>1.</sn> <def>That which is
variable; that which varies, or is subject to change.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Math.)</fld> <def>A quantity which may increase or
decrease; a quantity which admits of an infinite number of values in the
same expression; a variable quantity; <as>as, in the equation
<mathex>x<exp>2</exp> - y<exp>2</exp> = R<exp>2</exp></mathex>,
<it>x</it> and <it>y</it> are <ex>variables</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Naut.)</fld> <sd>(a)</sd> <def>A shifting wind, or
one that varies in force.</def> <sd>(b)</sd> <pluf>pl.</pluf> <def>Those
parts of the sea where a steady wind is not expected, especially the
parts between the trade-wind belts.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Independent variable</b></col> <fld>(Math.)</fld>,
<cd>that one of two or more variables, connected with each other in any
way whatever, to which changes are supposed to be given at will.
<as>Thus, in the equation <mathex>x<exp>2</exp> - y<exp>2</exp> =
R<exp>2</exp></mathex>, if arbitrary changes are supposed to be given to
<it>x</it>, then <it>x</it> is the <ex>independent variable</ex>, and
<it>y</it> is called a <it>function</it> of <it>x</it>.</as> There may
be two or more independent variables in an equation or problem. Cf.
<cref>Dependent variable</cref>, under <er>Dependent</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variableness</ent><br/
<hw>Va"ri*a*ble*ness</hw>, <pos>n.</pos> <def>The quality or state of
being variable; variability.</def> <rj><au>James i. 17.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variably</ent><br/
<hw>Va"ri*a*bly</hw>, <pos>adv.</pos> <def>In a variable
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variance</ent><br/
<hw>Va"ri*ance</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>variantia</ets>.]</ety> <sn>1.</sn> <def>The quality or state of
being variant; change of condition; variation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Difference that produces dispute or controversy;
disagreement; dissension; discord; dispute; quarrel.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That which is the strength of their amity shall prove the
immediate author of their <qex>variance</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Law)</fld> <def>A disagreement or difference
between two parts of the same legal proceeding, which, to be effectual,
ought to agree, -- as between the writ and the declaration, or between
the allegation and the proof.</def> <rj><au>Bouvier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Statistics)</fld> <def>The expected value of the
square of the deviation from the mean of a randomly distributed
variable; the second moment about the mean. This is also the square of
the <contr>standard deviation</contr>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>At variance</b></col>, <cd>in disagreement; in a state of
dissension or controversy; at enmity.</cd> <ldquo/What cause brought him
so soon <xex>at variance</xex> with himself?<rdquo/
<rj><au>Milton.</au></rj> </cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variant</ent><br/
<hw>Va"ri*ant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>varians</ets>, p. pr. of <ets>variare</ets> to change: cf. F.
<ets>variant</ets>. See <er>Vary</er>.]</ety> <sn>1.</sn> <def>Varying
in form, character, or the like; variable; different; diverse.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Changeable; changing; fickle.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He is so <qex>variant</qex>, he abit [abides] nowhere.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variant</ent><br/
<hw>Va"ri*ant</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>variante</ets>.]</ety> <def>Something which differs in form from
another thing, though really the same; <as>as, a <ex>variant</ex> from a
type in natural history; a <ex>variant</ex> of a story or a
word.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variate</ent><br/
<hw>Va"ri*ate</hw> <pr>(?)</pr>, <pos>v. t. & i.</pos> <ety>[L.
<ets>variatus</ets>, p. p. of <ets>variare</ets>. See
<er>Vary</er>.]</ety> <def>To alter; to make different; to
vary.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variation</ent><br/
<hw>Va`ri*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>variatioun</ets>, F. <ets>variation</ets>, L. <ets>variatio</ets>.
See <er>Vary</er>.]</ety> <sn>1.</sn> <def>The act of varying; a partial
change in the form, position, state, or qualities of a thing;
modification; alteration; mutation; diversity; deviation; <as>as, a
<ex>variation</ex> of color in different lights; a <ex>variation</ex> in
size; <ex>variation</ex> of language.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The essences of things are conceived not capable of any such
<qex>variation</qex>.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Extent to which a thing varies; amount of departure
from a position or state; amount or rate of change.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Gram.)</fld> <def>Change of termination of words,
as in declension, conjugation, derivation, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Mus.)</fld> <def>Repetition of a theme or melody
with fanciful embellishments or modifications, in time, tune, or
harmony, or sometimes change of key; the presentation of a musical
thought in new and varied aspects, yet so that the essential features of
the original shall still preserve their identity.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Alg.)</fld> <def>One of the different arrangements
which can be made of any number of quantities taking a certain number of
them together.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Annual variation</b></col> <fld>(Astron.)</fld>, <cd>the
yearly change in the right ascension or declination of a star, produced
by the combined effects of the precession of the equinoxes and the
proper motion of the star.</cd> -- <col><b>Calculus of
variations</b></col>. <cd>See under <er>Calculus</er>.</cd> --
<col><b>Variation compass</b></col>. <cd>See under
<er>Compass</er>.</cd> -- <col><b>Variation of the moon</b></col>
<fld>(Astron.)</fld>, <cd>an inequality of the moon's motion, depending
on the angular distance of the moon from the sun. It is greater at the
octants, and zero at the quadratures.</cd> -- <col><b>Variation of the
needle</b></col> <fld>(Geog. & Naut.)</fld>, <cd>the angle included
between the true and magnetic meridians of a place; the deviation of the
direction of a magnetic needle from the true north and south line; --
called also <altname>declination of the needle</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Change; vicissitude; variety;
deviation.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varicella</ent><br/
<hw>Var`i*cel"la</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., dim. of LL.
<ets>variola</ets> smallpox.]</ety> <fld>(Med.)</fld> <def>Chicken
pox.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varices</ent><br/
\'d8<hw>Var"i*ces</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>See
<er>Varix</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variciform</ent><br/
<hw>Va*ric"i*form</hw> <pr>(?)</pr>, <pos>a.</pos>
<ety>[<ets>Varix</ets> + <ets>-form</ets>.]</ety> <fld>(Med.)</fld>
<def>Resembling a varix.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varicocele</ent><br/
<hw>Var"i*co*cele</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Varix</ets> a dilated vein + Gr. <?/ tumor: cf. F.
<ets>varicoc<egrave/le</ets>.]</ety> <fld>(Med.)</fld> <def>A varicose
enlargement of the veins of the spermatic cord; also, a like enlargement
of the veins of the scrotum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varicose</ent><br/
<hw>Var"i*cose`</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>varicosus</ets>, from <ets>varix</ets>, <ets>-icis</ets>, a dilated
vein; cf. <ets>varus</ets> bent, stretched, crooked.]</ety> <sn>1.</sn>
<def>Irregularly swollen or enlarged; affected with, or containing,
varices, or varicosities; of or pertaining to varices, or varicosities;
<as>as, a <ex>varicose</ex> nerve fiber; a <ex>varicose</ex> vein;
<ex>varicose</ex> ulcers</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <def>Intended for the treatment of
varicose veins; -- said of elastic stockings, bandages, and the
like.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varicosis</ent><br/
\'d8<hw>Var`i*cos"is</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See
<er>Varix</er>, and <er>-osis</er>.]</ety> <fld>(Med.)</fld> <def>The
formation of varices; varicosity.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Varicosity</ent><br/
<hw>Var`i*cos"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
quality or state of being varicose.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An enlargement or swelling in a vessel, fiber, or
the like; a varix; <as>as, the <ex>varicosities</ex> of nerve
fibers</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varicotomy</ent><br/
<hw>Var`i*cot"o*my</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Varix</er>; <er>-tomy</er>.]</ety> <fld>(Surg.)</fld> <def>Excision
of a varicosity.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Varicous</ent><br/
<hw>Var"i*cous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Varicose.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varied</ent><br/
<hw>Va"ried</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Changed; altered;
various; diversified; <as>as, a <ex>varied</ex> experience;
<ex>varied</ex> interests; <ex>varied</ex> scenery.</as></def> --
<wordforms><wf>Va"ried*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>varied</qex> fields of science, ever new.</q>
<rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variegate</ent><br/
<hw>Va"ri*e*gate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Variegated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Variegating</conjf>.]</vmorph> <ety>[L.
<ets>variegatus</ets>, p. p. of <ets>variegare</ets> to variegate;
<ets>varius</ets> various + <ets>agere</ets> to move, make. See
<er>Various</er>, and <er>Agent</er>.]</ety> <def>To diversify in
external appearance; to mark with different colors; to dapple; to
streak; <as>as, to <ex>variegate</ex> a floor with marble of different
colors</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The shells are filled with a white spar, which
<qex>variegates</qex> and adds to the beauty of the stone.</q>
<rj><qau>Woodward.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variegated</ent><br/
<hw>Va"ri*e*ga`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having marks or
patches of different colors; <as>as, <ex>variegated</ex> leaves, or
flowers</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ladies like <qex>variegated</qex> tulips show.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variegation</ent><br/
<hw>Va`ri*e*ga"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of
variegating or diversifying, or the state of being diversified, by
different colors; diversity of colors.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varier</ent><br/
<hw>Va"ri*er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From
<er>Vary</er>.]</ety> <def>A wanderer; one who strays in search of
variety.</def> <mark>[Poetic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Pious <qex>variers</qex> from the church.</q>
<rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varietal</ent><br/
<hw>Va*ri"e*tal</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to a variety; characterizing a variety; constituting a variety, in
distinction from an individual or species.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Perplexed in determining what differences to consider as specific,
and what as <qex>varietal</qex>.</q> <rj><qau>Darwin.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varietas</ent><br/
\'d8<hw>Va*ri"e*tas</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety>
<def>A variety; -- used in giving scientific names, and often
abbreviated to <abbr>var.</abbr></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variety</ent><br/
<hw>Va*ri"e*ty</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Varieties</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>varietas</ets>:
cf. F. <ets>vari<eacute/t<eacute/</ets>. See
<er>Various</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The quality or state of being various; intermixture
or succession of different things; diversity;
multifariousness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Variety</qex> is nothing else but a continued novelty.</q>
<rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>variety</qex> of colors depends upon the composition of
light.</q> <rj><qau>Sir I. Newton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>For earth hath this <qex>variety</qex> from heaven.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>There is a <qex>variety</qex> in the tempers of good men.</q>
<rj><qau>Atterbury.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is various.</def>
<specif>Specifically:</specif> --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>A number or collection of different things; a
varied assortment; <as>as, a <ex>variety</ex> of cottons and
silks</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He . . . wants more time to do that <qex>variety</qex> of good
which his soul thirsts after.</q> <rj><qau>Law.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>Something varying or differing from others of the
same general kind; one of a number of things that are akin; a sort;
<as>as, <ex>varieties</ex> of wood, land, rocks, etc</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <fld>(Biol.)</fld> <def>An individual, or group of
individuals, of a species differing from the rest in some one or more of
the characteristics typical of the species, and capable either of
perpetuating itself for a period, or of being perpetuated by artificial
means; hence, a subdivision, or peculiar form, of a species.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Varieties</xex> usually differ from
<xex>species</xex> in that any two, however unlike, will generally
propagate indefinitely (unless they are in their nature unfertile, as
some varieties of rose and other cultivated plants); in being a result
of climate, food, or other extrinsic conditions or influences, but
generally by a sudden, rather than a gradual, development; and in
tending in many cases to lose their distinctive peculiarities when the
individuals are left to a state of nature, and especially if restored to
the conditions that are natural to typical individuals of the species.
Many varieties of domesticated animals and of cultivated plants have
been directly produced by man.</note><br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <def>In inorganic nature, one of those forms in which a
species may occur, which differ in minor characteristics of structure,
color, purity of composition, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ These may be viewed as variations from the typical
species in its most perfect and purest form, or, as is more commonly the
case, all the forms, including the latter, may rank as Varieties. Thus,
the sapphire is a blue variety, and the ruby a red variety, of corundum;
again, calcite has many Varieties differing in form and structure, as
Iceland spar, dogtooth spar, satin spar, and also others characterized
by the presence of small quantities of magnesia, iron, manganese, etc.
Still again, there are varieties of granite differing in structure, as
graphic granite, porphyritic granite, and other varieties differing in
composition, as albitic granite, hornblendic, or syenitic, granite,
etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Theaters)</fld> <def>Such entertainment as in given
in variety shows; the production of, or performance in, variety
shows.</def> <mark>[Cant]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><col><b>Geographical variety</b></col> <fld>(Biol.)</fld>, <cd>a
variety of any species which is coincident with a geographical region,
and is usually dependent upon, or caused by, peculiarities of
climate.</cd> -- <col><b>Variety hybrid</b></col> <fld>(Biol.)</fld>,
<cd>a cross between two individuals of different varieties of the same
species; a mongrel.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Diversity; difference; kind.</syn> <usage> --
<er>Variety</er>, <er>Diversity</er>. A man has a <xex>variety</xex> of
employments when he does many things which are not a mere repetition of
the same act; he has a <xex>diversity</xex> of employments when the
several acts performed are unlike each other, that is,
<xex>diverse</xex>. In most cases, where there is <xex>variety</xex>
there will be more or less of <xex>diversity</xex>, but not always. One
who sells railroad tickets performs a great <xex>variety</xex> of acts
in a day, while there is but little <xex>diversity</xex> in his
employment.</usage><br/
[<source>1913 Webster</source>]</p>

<p><q>All sorts are here that all the earth yields!<br/
<qex>Variety</qex> without end.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>But see in all corporeal nature's scene,<br/
What changes, what <qex>diversities</qex>, have been!</q>
<rj><qau>Blackmore.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variety show</ent><br/
<hw>Variety show</hw>. <def>A stage entertainment, live or televised, of
successive separate performances, usually songs, dances, acrobatic
feats, dramatic sketches, exhibitions of trained animals, or any
specialties. When performed live in a theater, it was often called a
<altname>vaudeville show</altname>, but when television became a
dominant form of entertainment live vaudeville performances almost
completely ceased.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Variety store</ent><br/
<hw>Variety store</hw>. <def>a retail store selling a wide variety of
items, especially of low price, as in a <stype>five and
ten</stype>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Variform</ent><br/
<hw>Va"ri*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>varius</ets> various + <ets>-form</ets>.]</ety> <def>Having
different shapes or forms.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variformed</ent><br/
<hw>Va"ri*formed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Formed with
different shapes; having various forms; variform.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varify</ent><br/
<hw>Va"ri*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L.
<ets>varius</ets> various + <ets>-fy</ets>.]</ety> <def>To make
different; to vary; to variegate.</def> <mark>[R.]</mark>
<rj><au>Sylvester.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variola</ent><br/
<hw>Va*ri"o*la</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL., fr. L.
<ets>varius</ets> various. See <er>Various</er>.]</ety>
<fld>(Med.)</fld> <def>The smallpox.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variolar</ent><br/
<hw>Va*ri"o*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Med.)</fld>
<def>Variolous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variolation</ent><br/
<hw>Va`ri*o*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Med.)</fld>
<def>Inoculation with smallpox.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variole</ent><br/
<hw>Va"ri*ole</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>variole</ets> smallpox. See <er>Variola</er>.]</ety> <sn>1.</sn>
<def>A foveola.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <fld>(Geol.)</fld> <def>A spherule of a
variolite.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Variolic</ent><br/
<hw>Va`ri*ol"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Med.)</fld>
<def>Variolous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variolite</ent><br/
<hw>Va"ri*o*lite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>varius</ets> various + <ets>-lite</ets>: cf. F.
<ets>variolite</ets>.]</ety> <fld>(Geol.)</fld> <def>A kind of diorite
or diabase containing imbedded whitish spherules, which give the rock a
spotted appearance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variolitic</ent><br/
<hw>Va`ri*o*lit"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From
<er>Variola</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Thickly marked with small, round specks;
spotted.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Geol.)</fld> <def>Of, pertaining to, or resembling,
variolite.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varioloid</ent><br/
<hw>Va"ri*o*loid</hw> <pr>(?; 277)</pr>, <pos>a.</pos>
<ety>[<ets>Variola</ets> + <ets>-oid</ets>: cf. F.
<ets>variolo<ium/de</ets>.]</ety> <fld>(Med.)</fld> <def>Resembling
smallpox; pertaining to the disease called varioloid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varioloid</ent><br/
<hw>Va"ri*o*loid</hw>, <pos>n.</pos> <ety>[Cf. F.
<ets>variolo<ium/de</ets>. See <er>Varioloid</er>, <pos>a.</pos>]</ety>
<fld>(Med.)</fld> <def>The smallpox as modified by previous inoculation
or vaccination.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It is almost always a milder disease than smallpox, and
this circumstance, with its shorter duration, exhibits the salutary
effects of previous vaccination or inoculation.</note>
<rj><au>Dunglison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variolous</ent><br/
<hw>Va*ri"o*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[LL.
<ets>variolosus</ets>, fr. <ets>variola</ets> the smallpox: cf. F.
<ets>varioleux</ets>.]</ety> <fld>(Med.)</fld> <def>Of or pertaining to
the smallpox; having pits, or sunken impressions, like those of the
smallpox; variolar; variolic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variometer</ent><br/
<hw>Va`ri*om"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>varius</ets> various + <ets>-meter</ets>.]</ety> <fld>(Elec.)</fld>
<def>An instrument for comparing magnetic forces, esp. in the earth's
magnetic field.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Variorum</ent><br/
\'d8<hw>Va`ri*o"rum</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L., abbrev.
fr. <ets>cum notis variorum</ets> with notes of various persons.]</ety>
<def>Containing notes by different persons; -- applied to a publication;
<as>as, a <ex>variorum</ex> edition of a book</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Various</ent><br/
<hw>Va"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>varius</ets>. Cf. <er>Vair</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Different; diverse; several; manifold; <as>as, men
of <ex>various</ex> names; <ex>various</ex> occupations;
<ex>various</ex> colors</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>So many and so <qex>various</qex> laws are given.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A wit as <qex>various</qex>, gay, grave, sage, or wild.</q>
<rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Changeable; uncertain; inconstant;
variable.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A man so <qex>various</qex>, that he seemed to be<br/
Not one, but all mankind's epitome.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The names of mixed modes . . . are very <qex>various</qex>.</q>
<rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Variegated; diversified; not monotonous.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A happy rural seat of <qex>various</qex> view.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variously</ent><br/
<hw>Va"ri*ous*ly</hw>, <pos>adv.</pos> <def>In various or different
ways.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Variscite</ent><br/
<hw>Var"is*cite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So called from
<ets>Variscia</ets> in Germany.]</ety> <fld>(Min.)</fld> <def>An
apple-green mineral occurring in reniform masses. It is a hydrous
phosphate of alumina.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varisse</ent><br/
<hw>Va*risse"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>varice</ets> varix. Cf. <er>Varix</er>.]</ety> <fld>(Far.)</fld>
<def>An imperfection on the inside of the hind leg in horses, different
from a curb, but at the same height, and often growing to an unsightly
size.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Varix</ent><br/
\'d8<hw>Va"rix</hw> <pr>(v<amac/"r<icr/ks)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Varices</plw>
<pr>(v<acr/r"<icr/*s<emac/z)</pr>.</plu> <ety>[L.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Med.)</fld> <def>A uneven, permanent dilatation of
a vein.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Varices are owing to local retardation of the venous
circulation, and in some cases to relaxation of the parietes of the
veins. They are very common in the superficial veins of the lower
limbs.</note> <rj><au>Dunglison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1596 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>One of the prominent ridges or
ribs extending across each of the whorls of certain univalve
shells.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The varices usually indicate stages of growth, each one
showing a former position of the outer lip of the aperture.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vark</ent><br/
\'d8<hw>Vark</hw> <pr>(v<aum/rk)</pr>, <pos>n.</pos> <ety>[D.
<ets>varken</ets> a pig.]</ety> <fld>(Zool.)</fld> <def>The bush hog, or
boshvark.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varlet</ent><br/
<hw>Var"let</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF.
<ets>varlet</ets>, <ets>vaslet</ets>, <ets>vallet</ets>, servant, young
man, young noble, dim. of <ets>vassal</ets>. See <er>Vassal</er>, and
cf. <er>Valet</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A servant, especially to a knight; an attendant; a
valet; a footman.</def> <mark>[Obs.]</mark> <rj><au>Spenser.
Tusser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, a low fellow; a scoundrel; a rascal; <as>as,
an impudent <ex>varlet</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>What a brazen-faced <qex>varlet</qex> art thou !</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>In a pack of playing cards, the court card now
called the <altname>knave</altname>, or <altname>jack</altname>.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varletry</ent><br/
<hw>Var"let*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. OF.
<ets>valeterie</ets> the young unmarried nobles.]</ety> <def>The rabble;
the crowd; the mob.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Shall they hoist me up,<br/
And show me to the shouting <qex>varletry</qex><br/
Of censuring Rome.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varnish</ent><br/
<hw>Var"nish</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vernish</ets>, F. <ets>vernis</ets>, LL. <ets>vernicium</ets>; akin
to F. <ets>vernir</ets> to varnish, fr. (assumed) LL.
<ets>vitrinire</ets> to glaze, from LL. <ets>vitrinus</ets> glassy, fr.
L. <ets>vitrum</ets> glass. See <er>Vitreous</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A viscid liquid, consisting of a solution of
resinous matter in an oil or a volatile liquid, laid on work with a
brush, or otherwise. When applied the varnish soon dries, either by
evaporation or chemical action, and the resinous part forms thus a
smooth, hard surface, with a beautiful gloss, capable of resisting, to a
greater or less degree, the influences of air and moisture.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ According to the sorts of solvents employed, the
ordinary kinds of varnish are divided into three classes:
<xex>spirit</xex>, <xex>turpentine</xex>, and <xex>oil</xex>
varnishes.</note> <rj><au>Encyc. Brit</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which resembles varnish, either naturally or
artificially; a glossy appearance.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>varnish</qex> of the holly and ivy.</q>
<rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An artificial covering to give a fair appearance to
any act or conduct; outside show; gloss.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And set a double <qex>varnish</qex> on the fame<br/
The Frenchman gave you.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Varnish tree</b></col> <fld>(Bot.)</fld>, <cd>a tree or
shrub from the juice or resin of which varnish is made, as some species
of the genus <gen>Rhus</gen>, especially <spn>Rhus vernicifera</spn> of
Japan. The black varnish of Burmah is obtained from the
<spn>Melanorrh<oe/a usitatissima</spn>, a tall East Indian tree of the
Cashew family. See <er>Copal</er>, and <er>Mastic</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varnish</ent><br/
<hw>Var"nish</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Varnished</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Varnishing</conjf>.]</vmorph> <ety>[Cf. F. <ets>vernir</ets>,
<ets>vernisser</ets>. See <er>Varnish</er>, <pos>n.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To lay varnish on; to cover with a liquid which
produces, when dry, a hard, glossy surface; <as>as, to <ex>varnish</ex>
a table; to <ex>varnish</ex> a painting</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To cover or conceal with something that gives a fair
appearance; to give a fair coloring to by words; to gloss over; to
palliate; <as>as, to <ex>varnish</ex> guilt</as>.</def> <ldquo/Beauty
doth <xex>varnish</xex> age.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Close ambition, <qex>varnished</qex> o'er with zeal.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Cato's voice was ne'er employed<br/
To clear the guilty and to <qex>varnish</qex> crimes.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varnisher</ent><br/
<hw>Var"nish*er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One
who varnishes; one whose occupation is to varnish.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who disguises or palliates; one who gives a fair
external appearance.</def> <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varnishing</ent><br/
<hw>Var"nish*ing</hw>, <pos>n.</pos> <def>The act of laying on varnish;
also, materials for varnish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varsity</ent><br/
<hw>Var"si*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn>
<def>Colloquial contraction of <er>University</er>.</def>
<mark>[Brit.]</mark> <br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>the team with the best players of a school or club,
being the main representative of the organization in competitive play
between schools or organizations. In schools, contrasted with
<contr>junior varsity</contr>. Also used attributively, <as>as, the
<ex>varsity</ex> football team</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Varsovienne</ent><br/
\'d8<hw>Var`so`vienne"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., prop.
fem. of <ets>varsovien</ets> pertaining to Warsaw, fr.
<ets>Varsovie</ets> Warsaw, Pol. <ets>Warszawa</ets>.]</ety>
<sd>(a)</sd> <def>A kind of Polish dance.</def> <sd>(b)</sd> <def>Music
for such a dance or having its slow triple time characteristic strong
accent beginning every second measure.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vartabed</ent><br/
<hw>Var"ta*bed</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Armen., a doctor,
master, preceptor.]</ety> <fld>(Eccl.)</fld> <def>A doctor or teacher in
the Armenian church. Members of this order of ecclesiastics frequently
have charge of dioceses, with episcopal functions.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varuna</ent><br/
\'d8<hw>Va*ru"na</hw> <pr>(v<adot/*r<udd/"n<adot/)</pr>, <pos>n.</pos>
<ety>[Skr. <ets>Varu<nsdot/a</ets>.]</ety> <fld>(Hindu Myth.)</fld>
<def>The god of the waters; the Indian Neptune. He is regarded as regent
of the west, and lord of punishment, and is represented as riding on a
sea monster, holding in his hand a snaky cord or noose with which to
bind offenders, under water.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varus</ent><br/
\'d8<hw>Va"rus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. L., bent,
grown inwards.]</ety> <fld>(Med.)</fld> <def>A deformity in which the
foot is turned inward. See <er>Talipes</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Varvel</ent><br/
<hw>Var"vel</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vervelle</ets>.]</ety> <def>In falconry, one of the rings secured
to the ends of the jesses.</def> <altsp>[Written also
<asp>vervel</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varveled</ent><br/
<hw>Var"veled</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having varvels, or
rings.</def> <altsp>[Written also <asp>varvelled</asp>, and
<asp>vervelled</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In heraldry, when the jesses attached to the legs of
hawks hang loose, or have pendent ends with rings at the tips, the
blazon is a <xex>hawk</xex> (<xex>or a hawk's leg</xex>) <xex>jessed and
varveled</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vary</ent><br/
<hw>Va"ry</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Varied</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Varying</conjf>.]</vmorph> <ety>[OE. <ets>varien</ets>, F.
<ets>varier</ets>, L. <ets>variare</ets>, fr. <ets>varius</ets> various.
See <er>Various</er>, and cf. <er>Variate</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To change the aspect of; to alter in form,
appearance, substance, position, or the like; to make different by a
partial change; to modify; <as>as, to <ex>vary</ex> the properties,
proportions, or nature of a thing; to <ex>vary</ex> a posture or an
attitude; to <ex>vary</ex> one's dress or opinions.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Shall we <qex>vary</qex> our device at will,<br/
Even as new occasion appears?</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To change to something else; to transmute; to
exchange; to alternate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Gods, that never change their state,<br/
<qex>Vary</qex> oft their love and hate.</q>
<rj><qau>Waller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>We are to <qex>vary</qex> the customs according to the time and
country where the scene of action lies.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To make of different kinds; to make different from
one another; to diversify; to variegate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>God hath <qex>varied</qex> their inclinations.</q> <rj><qau>Sir T.
Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>God hath here<br/
<qex>Varied</qex> his bounty so with new delights.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Mus.)</fld> <def>To embellish; to change
fancifully; to present under new aspects, as of form, key, measure, etc.
See <er>Variation</er>, 4.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vary</ent><br/
<hw>Va"ry</hw> <pr>(?)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>To alter,
or be altered, in any manner; to suffer a partial change; to become
different; to be modified; <as>as, colors <ex>vary</ex> in different
lights</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That each from other differs, first confess;<br/
Next, that he <qex>varies</qex> from himself no less.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To differ, or be different; to be unlike or diverse;
<as>as, the laws of France <ex>vary</ex> from those of
England</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To alter or change in succession; to alternate;
<as>as, one mathematical quantity <ex>varies</ex> inversely as
another</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>While fear and anger, with alternate grace,<br/
Pant in her breast, and <qex>vary</qex> in her face.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To deviate; to depart; to swerve; -- followed by
<ptcl>from</ptcl>; <as>as, to <ex>vary</ex> from the law, or from
reason</as>.</def> <rj><au> Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To disagree; to be at variance or in dissension;
<as>as, men <ex>vary</ex> in opinion</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The rich jewel which we <qex>vary</qex> for.</q> <rj><qau>Webster
(1623).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vary</ent><br/
<hw>Va"ry</hw>, <pos>n.</pos> <def>Alteration; change.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Varying</ent><br/
<hw>Va"ry*ing</hw>, <def><pos>a. & n.</pos> from
<er>Vary</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Varying hare</b></col> <fld>(Zool.)</fld>, <cd>any hare
or rabbit which becomes white in winter, especially the common hare of
the Northern United States and Canada.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vas</ent><br/
\'d8<hw>Vas</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vasa</plw> <pr>(#)</pr>.</plu> <ety>[L., a vessel. See
<er>Vase</er>.]</ety> <fld>(Anat.)</fld> <def>A vessel; a
duct.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs>\'d8<col><b>Vas deferens</b></col>; <plu><it>pl.</it> <plw>Vasa
deferentia</plw>.</plu> <ety>[L. <ets>vas</ets> vessel +
<ets>deferens</ets> carrying down.]</ety> <fld>(Anat.)</fld> <cd>The
excretory duct of a testicle; a spermatic duct.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vascular</ent><br/
<hw>Vas"cu*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vasculum</ets> a small vessel, dim. of <ets>vas</ets> vessel: cf.
F. <ets>vasculaire</ets>. See <er>Vase</er>, and cf.
<ets>Vessel</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Biol.)</fld> <sd>(a)</sd> <def>Consisting of, or
containing, vessels as an essential part of a structure; full of
vessels; specifically <fld>(Bot.)</fld>, pertaining to, or containing,
special ducts, or tubes, for the circulation of sap.</def> <sd>(b)</sd>
<def>Operating by means of, or made up of an arrangement of, vessels;
<as>as, the <ex>vascular</ex> system in animals, including the arteries,
veins, capillaries, lacteals, etc.</as></def> <sd>(c)</sd> <def>Of or
pertaining to the vessels of animal and vegetable bodies; <as>as, the
<ex>vascular</ex> functions</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Of or pertaining to the higher
division of plants, that is, the phaenogamous plants, all of which are
vascular, in distinction from the cryptogams, which to a large extent
are cellular only.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vascular plants</b></col> <fld>(Bot.)</fld>, <cd>plants
composed in part of vascular tissue, as all flowering plants and the
higher cryptogamous plants, or those of the class
<class>Pteridophyta</class>. Cf. <cref>Cellular plants</cref>, under
<er>Cellular</er>.</cd> -- <col><b>Vascular system</b></col>
<fld>(Bot.)</fld>, <cd>the body of associated ducts and woody fiber; the
fibrovascular part of plants.</cd> -- <col><b>Vascular tissue</b></col>
<fld>(Bot.)</fld>, <cd>vegetable tissue composed partly of ducts, or sap
tubes.</cd> -- <col><b>Water vascular system</b></col>
<fld>(Zool.)</fld>, <cd>a system of vessels in annelids, nemerteans, and
many other invertebrates, containing a circulating fluid analogous to
blood, but not of the same composition. In annelids the fluid which they
contain is usually red, but in some it is green, in others yellow, or
whitish.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vascularity</ent><br/
<hw>Vas`cu*lar"i*ty</hw> <pr>(v<acr/s`k<usl/*l<acr/r"<icr/*t<ycr/)</pr>,
<pos>n.</pos>; <plu><it>pl.</it> <plw>Vascularities</plw>
<pr>(v<acr/s`k<usl/*l<acr/r"<icr/*t<icr/z)</pr>.</plu>
<fld>(Biol.)</fld> <def>The quality or state of being
vascular.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vascularization</ent><br/
<hw>Vas`cu*lar*i*za"tion</hw>
<pr>(v<acr/s`k<usl/*l<etil/r*<icr/*z<amac/"sh<ucr/n)</pr>, <pos>n.</pos>
<fld>(Physiol.)</fld> <def>The process of becoming vascular, or the
condition of being vascular; as, the <ex>vascularization</ex> of
cartilege.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasculose</ent><br/
<hw>Vas"cu*lose`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>One of the substances of which vegetable tissue is composed,
differing from cellulose in respect to its solubility in certain
media.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasculum</ent><br/
\'d8<hw>Vas"cu*lum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vascula</plw> <pr>(#)</pr>.</plu> <ety>[L., a small vessel.]</ety>
<sn>1.</sn> <fld>(Bot.)</fld> <def>Same as <er>Ascidium</er>,
<pos>n.</pos>, 1.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A tin box, commonly cylindrical or flattened, used
in collecting plants.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vase</ent><br/
<hw>Vase</hw> <pr>(v<amac/s <it>or</it> v<aum/z; 277)</pr>,
<pos>n.</pos> <ety>[F. <ets>vase</ets>; cf. Sp. & It. <ets>vaso</ets>;
fr. L. <ets>vas</ets>, <ets>vasum</ets>. Cf. <er>Vascular</er>,
<er>Vessel</er>.]</ety> <sn>1.</sn> <def>A vessel adapted for various
domestic purposes, and anciently for sacrificial uses; especially, a
vessel of antique or elegant pattern used for ornament; <as>as, a
porcelain <ex>vase</ex>; a gold <ex>vase</ex>; a Grecian
<ex>vase</ex>.</as> See <xex>Illust.</xex> of <cref>Portland
vase</cref>, under <er>Portland</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>No chargers then were wrought in burnished gold,<br/
Nor silver <qex>vases</qex> took the forming mold.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <sd>(a)</sd> <def>A vessel similar to
that described in the first definition above, or the representation of
one in a solid block of stone, or the like, used for an ornament, as on
a terrace or in a garden. See <xex>Illust.</xex> of
<er>Niche</er>.</def> <sd>(b)</sd> <def>The body, or naked ground, of
the Corinthian and Composite capital; -- called also
<altname>tambour</altname>, and <altname>drum</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Until the time of Walker (1791), <ex>vase</ex> was made
to rhyme with <xex>base</xex>, <xex>case</xex>, etc., and it is still
commonly so pronounced in the United States. Walker made it to rhyme
with <xex>phrase</xex>, <xex>maze</xex>, etc. Of modern English
practice, <person>Mr. A. J. Ellis</person> (1874) says:
<ldquo/<xex>Vase</xex> has four pronunciations in English:
<pr><it>v<add/z</it></pr>, which I most commonly say, is going out of
use, <pr><it>v<aum/z</it></pr> I hear most frequently,
<pr><it>v<amac/z</it></pr> very rarely, and <pr><it>v<amac/s</it></pr> I
only know from Cull's marking. On the analogy of <xex>case</xex>,
however, it should be the regular sound.<rdquo/<br/
The Merriam-Webster's 10th Colletgiate Dictionary says: <ldquo/U. S.
oftenest v<amac/s; Canada usu. and U. S. also v<amac/z; Canada also & U.
S. sometimes v<aum/z.<rdquo/<br/
One wit has noted that <ldquo/a v<aum/z is a v<amac/z that costs more
than $100.<rdquo/, suggesting that the former is considered a
higher-class pronunciation.</note><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><sn>3.</sn> <fld>(Bot.)</fld> <def>The calyx of a plant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vase clock</ent><br/
<hw>Vase clock</hw>. <fld>(Art)</fld> <def>A clock whose decorative case
has the general form of a vase, esp. one in which there is no ordinary
dial, but in which a part of a vase revolves while a single stationary
indicator serves as a hand.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vasectomy</ent><br/
<hw>Vas*ec"to*my</hw> <pr>(v<acr/s*<ecr/k"t<osl/*m<ycr/)</pr>,
<pos>n.</pos> <ety>[<ets>Vas</ets> + <ets>-ecmoty</ets>.]</ety>
<fld>(Surg.)</fld> <def>Resection or excision of the vas
deferens.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vaseline</ent><br/
<hw>Vas"e*line</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Said by the
manufacturer to be derived from G. <ets>wasser</ets> water + Gr.
<grk>'e`laion</grk> olive oil.]</ety> <def>A yellowish translucent
substance, almost odorless and tasteless, obtained as a residue in the
purification of crude petroleum, and consisting essentially of a mixture
of several of the higher members of the paraffin series. It is used as
an unguent, and for various purposes in the arts. See the Note under
<er>Petrolatum</er>.</def> <altsp>[Written also
<asp>vaselin</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vase-shaped</ent><br/
<hw>Vase"-shaped`</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Formed like a
vase, or like a common flowerpot.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasiform</ent><br/
<hw>Vas"i*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>vas</ets>
a vessel + <ets>-form</ets>.]</ety> <fld>(Biol.)</fld> <def>Having the
form of a vessel, or duct.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vasiform tissue</b></col> <fld>(Bot.)</fld>, <cd>tissue
containing vessels, or ducts.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasoconstrictor</ent><br/
<hw>Vas`o*con*strict"or</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Physiol.)</fld> <def>Causing constriction of the blood vessels;
<as>as, the <ex>vasoconstrictor</ex> nerves, stimulation of which causes
constriction of the blood vessels to which they go.</as> These nerves
are also called <altname>vasohypertonic</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasoconstrictor</ent><br/
<hw>Vas`o*con*strict"or</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Medicine,
Physiology)</fld> <def>A substance which causes constriction of the
blood vessels. Such substances are used in medicine to raise abnormally
low blood pressure.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vasodentine</ent><br/
<hw>Vas`o*den"tine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vas</ets> a vessel + E. <ets>dentine</ets>.]</ety>
<fld>(Anat.)</fld> <def>A modified form of dentine, which is permeated
by blood capillaries; vascular dentine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasodilator</ent><br/
<hw>Vas`o*di*lat"or</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vas</ets> a vessel + <ets>dilator</ets>.]</ety>
<fld>(Physiol.)</fld> <def>Causing dilation or relaxation of the blood
vessels; <as>as, the <ex>vasodilator</ex> nerves, stimulation of which
causes dilation of the blood vessels to which they go</as>. These nerves
are also called <altname>vaso-inhibitory</altname>, and
<altname>vasohypotonic</altname> nerves, since their stimulation causes
relaxation and rest.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasodilator</ent><br/
<hw>Vas`o*di*lat"or</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vas</ets> a vessel + <ets>dilator</ets>.]</ety> <fld>(Medicine &
Physiology)</fld> <def>A substance which causes dilation of blood
vessels.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vasoformative</ent><br/
<hw>Vas`o*form"a*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vas</ets> a vessel + <ets>formative</ets>.]</ety>
<fld>(Physiol.)</fld> <def>Concerned in the development and formation of
blood vessels and blood corpuscles; <as>as, the <ex>vasoformative</ex>
cells</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasohypertonic</ent><br/
<hw>Vas`o*hy`per*ton"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Hyper-</er>, and <er>Tonic</er>.]</ety> <def>See
<er>Vasoconstrictor</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasohypotonic</ent><br/
<hw>Vas`o*hy`po*ton"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Hypo-</er>, and <er>Tonic</er>.]</ety> <def>See
<er>Vasodilator</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaso-inhibitory</ent><br/
<hw>Vas`o-in*hib"i*to*ry</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Physiol.)</fld> <def>See <er>Vasodilator</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasomotor</ent><br/
<hw>Vas`o*mo"tor</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vas</ets> a vessel + <ets>motor</ets> that which moves fr.
<ets>movere</ets> to move.]</ety> <fld>(Physiol.)</fld> <def>Causing
movement in the walls of vessels; <as>as, the <ex>vasomotor</ex>
mechanisms; the <ex>vasomotor</ex> nerves, a system of nerves
distributed over the muscular coats of the blood vessels.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vasomotor center</b></col>, <cd>the chief dominating or
general center which supplies all the unstriped muscles of the arterial
system with motor nerves, situated in a part of the medulla oblongata; a
center of reflex action by the working of which afferent impulses are
changed into efferent, -- vasomotor impulses leading either to dilation
or constriction of the blood vessels.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vassal</ent><br/
<hw>Vas"sal</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. LL.
<ets>vassallus</ets>, <ets>vassus</ets>; of Celtic origin; cf. W. &
Corn. <ets>gwas</ets> a youth, page, servant, Arm. <ets>gwaz</ets> a
man, a male. Cf. <er>Valet</er>, <er>Varlet</er>,
<er>Vavasor</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Feud. Law)</fld> <def>The grantee of a fief, feud,
or fee; one who holds land of a superior, and who vows fidelity and
homage to him; a feudatory; a feudal tenant.</def>
<rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A subject; a dependent; a servant; a bondman; a
slave.</def> <ldquo/The <xex>vassals</xex> of his anger.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Rear vassal</b></col>, <cd>the vassal of a vassal; an
arriere vassal.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vassal</ent><br/
<hw>Vas"sal</hw>, <pos>a.</pos> <def>Resembling a vassal; slavish;
servile.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The sun and every <qex>vassal</qex> star.</q>
<rj><qau>Keble.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vassal</ent><br/
<hw>Vas"sal</hw>, <pos>v. t.</pos> <def>To treat as a vassal; to subject
to control; to enslave.</def> <mark>[Obs.]</mark> <rj><au>Beau. &
Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vassalage</ent><br/
<hw>Vas"sal*age</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vassalage</ets>, F. <ets>vasselage</ets>, LL.
<ets>vassallaticum</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The state of being a vassal, or feudatory.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Political servitude; dependence; subjection;
slavery; <as>as, the Greeks were held in <ex>vassalage</ex> by the
Turks</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A territory held in vassalage.</def> <ldquo/The
Countship of Foix, with six territorial <xex>vassalages</xex>.<rdquo/
<rj><au>Milman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Vassals, collectively; vassalry.</def>
<mark>[R.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Valorous service, such as that performed by a
vassal; valor; prowess; courage.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vassaless</ent><br/
<hw>Vas"sal*ess</hw>, <pos>n.</pos> <def>A female vassal.</def>
<mark>[R.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vassalry</ent><br/
<hw>Vas"sal*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The body of
vassals.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vast</ent><br/
<hw>Vast</hw> <pr>(v<adot/st)</pr>, <pos>a.</pos>
<amorph>[<pos>Compar.</pos> <adjf>Vaster</adjf>
<pr>(v<adot/st"<etil/r)</pr>; <pos>superl.</pos>
<adjf>Vastest</adjf>.]</amorph> <ety>[L. <ets>vastus</ets> empty, waste,
enormous, immense: cf. F. <ets>vaste</ets>. See <er>Waste</er>, and cf.
<er>Devastate</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Waste; desert; desolate; lonely.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The empty, <qex>vast</qex>, and wandering air.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of great extent; very spacious or large; also, huge
in bulk; immense; enormous; <as>as, the <ex>vast</ex> ocean;
<ex>vast</ex> mountains; the <ex>vast</ex> empire of
Russia</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Through the <qex>vast</qex> and boundless deep.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Very great in numbers, quantity, or amount; <as>as,
a <ex>vast</ex> army; a <ex>vast</ex> sum of money</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Very great in force; mighty; <as>as, <ex>vast</ex>
labor</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Very great in importance; <as>as, a subject of
<ex>vast</ex> concern</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Enormous; huge; immense; mighty.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vast</ent><br/
<hw>Vast</hw>, <pos>n.</pos> <def>A waste region; boundless space;
immensity.</def> <ldquo/The watery <xex>vast</xex>.<rdquo/
<rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Michael bid sound<br/
The archangel trumpet. Through the <qex>vast</qex> of heaven<br/
It sounded.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vastation</ent><br/
<hw>Vas*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vastatio</ets>, fr. <ets>vastare</ets> to lay waste, fr.
<ets>vastus</ets> empty, waste.]</ety> <def>A laying waste; waste;
depopulation; devastation.</def> <mark>[Obs.]</mark> <rj><au>Bp.
Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vastel</ent><br/
<hw>Vas"tel</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Wastel</er>.</def> <mark>[Obs.]</mark> <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vastidity</ent><br/
<hw>Vas*tid"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. OF.
<ets>vastit<eacute/</ets>, L. <ets>vastitas</ets>.]</ety> <def>Vastness;
immensity.</def> <mark>[Obs.]</mark> <ldquo/All the world's
<xex>vastidity</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vastitude</ent><br/
<hw>Vas"ti*tude</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vastitudo</ets>.]</ety> <sn>1.</sn> <def>Vastness; immense
extent.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Destruction; vastation.</def> <mark>[Obs.]</mark>
<rj><au>Joye.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vastity</ent><br/
<hw>Vast"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vastitas</ets>.]</ety> <def>Vastness.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The huge <qex>vastity</qex> of the world.</q>
<rj><qau>Holland.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vastly</ent><br/
<hw>Vast"ly</hw>, <pos>adv.</pos> <def>To a vast extent or degree; very
greatly; immensely.</def> <rj><au>Jer. Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vastness</ent><br/
<hw>Vast"ness</hw>, <pos>n.</pos> <def>The quality or state of being
vast.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasty</ent><br/
<hw>Vas"ty</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From
<er>Vast</er>.]</ety> <def>Vast; immense.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I can call spirits from the <qex>vasty</qex> deep.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vasum</ent><br/
\'d8<hw>Va"sum</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a vase. See
<er>Vase</er>.]</ety> <fld>(Zool.)</fld> <def>A genus including several
species of large marine gastropods having massive pyriform shells, with
conspicuous folds on the columella.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vat</ent><br/
<hw>Vat</hw> <pr>(v<acr/t)</pr>, <pos>n.</pos> <ety>[A dialectic form
for <ets>fat</ets>, OE. <ets>fat</ets>, AS. <ets>f<ae/t</ets>; akin to
D. <ets>vat</ets>, OS. <ets>fat</ets>, G. <ets>fass</ets>, OHG.
<ets>faz</ets>, Icel. & Sw. <ets>fat</ets>, Dan. <ets>fad</ets>, Lith.
<ets>p<uring/das</ets> a pot, and probably to G. <ets>fassen</ets> to
seize, to contain, OHG. <ets>fazz<omac/n</ets>, D. <ets>vatten</ets>.
Cf. <er>Fat</er> a vat.]</ety> <br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1597 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A large vessel, cistern, or tub, especially one used
for holding liquors in an immature state, chemical preparations for
dyeing, or for tanning, or for tanning leather, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Let him produce his <qex>vats</qex> and tubs, in opposition to
heaps of arms and standards.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A measure for liquids, and also a dry measure;
especially, a liquid measure in Belgium and Holland, corresponding to
the hectoliter of the metric system, which contains 22.01 imperial
gallons, or 26.4 standard gallons in the United States.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The old Dutch grain vat averaged 0.762 Winchester
bushel. The old London coal vat contained 9 bushels. The
solid-measurement vat of Amsterdam contains 40 cubic feet; the wine vat,
241.57 imperial gallons, and the vat for olive oil, 225.45 imperial
gallons.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Metal.)</fld> <sd>(a)</sd> <def>A wooden tub for
washing ores and mineral substances in.</def> <sd>(b)</sd> <def>A
square, hollow place on the back of a calcining furnace, where tin ore
is laid to dry.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(R. C. Ch.)</fld> <def>A vessel for holding holy
water.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vat</ent><br/
<hw>Vat</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Vatted</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vatting</conjf>.]</vmorph> <def>To put or transfer into a
vat.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vatful</ent><br/
<hw>Vat"ful</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vatfuls</plw> <pr>(<?/)</pr>.</plu> <def>As much as a vat will
hold; enough to fill a vat.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vatical</ent><br/
<hw>Vat"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>vates</ets>
a prophet.]</ety> <def>Of or pertaining to a prophet; prophetical.</def>
<rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vatican</ent><br/
<hw>Vat"i*can</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>Vaticanus</ets>, <ets>mons</ets>, or <ets>collis</ets>,
<ets>Vaticanus</ets>, the Vatican hill, in Rome, on the western bank of
the Tiber: cf. F. <ets>Vatican</ets>, It. <ets>Vaticano</ets>.]</ety>
<def>A magnificent assemblage of buildings at Rome, near the church of
St. Peter, including the pope's palace, a museum, a library, a famous
chapel, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The word is often used to indicate the papal
authority.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Thunders of the Vatican</b></col>, <cd>the anathemas, or
denunciations, of the pope.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vatican Council</ent><br/
<hw>Vat"i*can Coun"cil</hw>. <fld>(R. C. Ch.)</fld> <def>The council
held under Pope Pius IX. in Vatican at Rome, in 1870, which promulgated
the dogma of papal infallibility.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vaticanism</ent><br/
<hw>Vat"i*can*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The doctrine of
papal supremacy; extreme views in support of the authority of the pope;
ultramontanism; -- a term used only by persons who are not Roman
Catholics.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaticanist</ent><br/
<hw>Vat"i*can*ist</hw>, <pos>n.</pos> <def>One who strongly adheres to
the papal authority; an ultramontanist.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaticide</ent><br/
<hw>Vat"i*cide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vates</ets> a prophet + <ets>caedere</ets> to kill.]</ety> <def>The
murder, or the murderer, of a prophet.</def> <ldquo/The caitiff
<xex>vaticide</xex>.<rdquo/ <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaticinal</ent><br/
<hw>Va*tic"i*nal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Vaticinate</er>.]</ety> <def>Of or pertaining to prophecy;
prophetic.</def> <rj><au>T. Warton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaticinate</ent><br/
<hw>Va*tic"i*nate</hw> <pr>(?)</pr>, <pos>v. i. & t.</pos> <ety>[L.
<ets>vaticinatus</ets>, p. p. of <ets>vaticinari</ets> to prophesy, fr.
<ets>vaticinus</ets> prophetical, fr. <ets>vates</ets> a prophet.]</ety>
<def>To prophesy; to foretell; to practice prediction; to utter
prophecies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaticination</ent><br/
<hw>Va*tic`i*na"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vaticinatio</ets>.]</ety> <def>Prediction; prophecy.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It is not a false utterance; it is a true, though an impetuous,
<qex>vaticination</qex>.</q> <rj><qau>I. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaticinator</ent><br/
<hw>Va*tic"i*na`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety>
<def>One who vaticinates; a prophet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaticine</ent><br/
<hw>Vat"i*cine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vaticinium</ets>.]</ety> <def>A prediction; a vaticination.</def>
<mark>[Obs.]</mark> <rj><au>Holinshed.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaudeville</ent><br/
\'d8<hw>Vaude"ville</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr.
<ets>Vau-de-vire</ets>, a village in Normandy, where Olivier Basselin,
at the end of the 14th century, composed such songs.]</ety>
<altsp>[Written also <asp>vaudevil</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A kind of song of a lively character, frequently
embodying a satire on some person or event, sung to a familiar air in
couplets with a refrain; a street song; a topical song.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A theatrical piece, usually a comedy, the dialogue
of which is intermingled with light or satirical songs, set to familiar
airs.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The early <qex>vaudeville</qex>, which is the forerunner of the
opera bouffe, was light, graceful, and piquant.</q> <rj><qau>Johnson's
Cyc.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>a <er>variety show</er> when performed live in a
theater (see above); <as>as, to play in <ex>vaudeville</ex>; a
<ex>vaudeville</ex> actor</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vaudois</ent><br/
\'d8<hw>Vau*dois"</hw> <pr>(v<omac/*dw<aum/")</pr>, <pos>n. sing. &
pl.</pos> <ety>[F.]</ety> <sn>1.</sn> <def>An inhabitant, or the
inhabitants, of the Swiss canton of Vaud.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A modern name of the Waldenses.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaudoux</ent><br/
<hw>Vau*doux"</hw> <pr>(?)</pr>, <pos>n. & a.</pos> <def>See
<er>Voodoo</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vault</ent><br/
<hw>Vault</hw> <pr>(v<add/lt; <it>see Note, below</it>)</pr>,
<pos>n.</pos> <ety>[OE. <ets>voute</ets>, OF. <ets>voute</ets>,
<ets>volte</ets>, F. <ets>vo<ucir/te</ets>, LL. <ets>volta</ets>, for
<ets>voluta</ets>, <ets>volutio</ets>, fr. L. <ets>volvere</ets>,
<ets>volutum</ets>, to roll, to turn about. See <er>Voluble</er>, and
cf. <er>Vault</er> a leap, <er>Volt</er> a turn,
<er>Volute</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Arch.)</fld> <def>An arched structure of masonry,
forming a ceiling or canopy.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The long-drawn aisle and fretted <qex>vault</qex>.</q>
<rj><qau>Gray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An arched apartment; especially, a subterranean
room, used for storing articles, for a prison, for interment, or the
like; a cell; a cellar.</def> <ldquo/Charnel <xex>vaults</xex>.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The silent <qex>vaults</qex> of death.</q>
<rj><qau>Sandys.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To banish rats that haunt our <qex>vault</qex>.</q>
<rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The canopy of heaven; the sky.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That heaven's <qex>vault</qex> should crack.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <ety>[F. <ets>volte</ets>, It. <ets>volta</ets>,
originally, a turn, and the same word as <ets>volta</ets> an arch. See
the Etymology above.]</ety> <def>A leap or bound.</def> Specifically: --
<sd>(a)</sd> <fld>(Man.)</fld> <def>The bound or leap of a horse; a
curvet.</def> <sd>(b)</sd> <def>A leap by aid of the hands, or of a
pole, springboard, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>l</xex> in this word was formerly often
suppressed in pronunciation.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Barrel vault</b></col>, <col><b>Cradle
vault</b></col>, <col><b>Cylindrical vault</b></col>, <it>or</it>
<col><b>Wagon vault</b></col></mcol> <fld>(Arch.)</fld>, <cd>a kind of
vault having two parallel abutments, and the same section or profile at
all points. It may be <xex>rampant</xex>, as over a staircase (see
<cref>Rampant vault</cref>, under <er>Rampant</er>), or curved in plan,
as around the apse of a church.</cd> -- <col><b>Coved vault</b></col>.
<fld>(Arch.)</fld> <cd>See under 1st <er>Cove</er>, <pos>v.
t.</pos></cd> -- <col><b>Groined vault</b></col> <fld>(Arch.)</fld>,
<cd>a vault having groins, that is, one in which different cylindrical
surfaces intersect one another, as distinguished from a
<xex>barrel</xex>, or <xex>wagon</xex>, <xex>vault</xex>.</cd> --
<col><b>Rampant vault</b></col>. <fld>(Arch.)</fld> <cd>See under
<er>Rampant</er>.</cd> -- <col><b>Ribbed vault</b></col>
<fld>(Arch.)</fld>, <cd>a vault differing from others in having solid
ribs which bear the weight of the vaulted surface. True Gothic vaults
are of this character.</cd> -- <col><b>Vault light</b></col>, <cd>a
partly glazed plate inserted in a pavement or ceiling to admit light to
a vault below.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vault</ent><br/
<hw>Vault</hw> <pr>(v<add/lt)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Vaulted</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Vaulting</conjf>.]</vmorph> <ety>[OE. <ets>vouten</ets>, OF.
<ets>volter</ets>, <ets>vouter</ets>, F. <ets>vo<ucir/ter</ets>. See
<er>Vault</er> an arch.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To form with a vault, or to cover with a vault; to
give the shape of an arch to; to arch; <as>as, to <ex>vault</ex> a roof;
to <ex>vault</ex> a passage to a court</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The shady arch that <qex>vaulted</qex> the broad green alley.</q>
<rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[See <er>Vault</er>, <pos>v. i.</pos>]</ety> <def>To
leap over; esp., to leap over by aid of the hands or a pole; <as>as, to
<ex>vault</ex> a fence</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I will <qex>vault</qex> credit, and affect high pleasures.</q>
<rj><qau>Webster (1623).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vault</ent><br/
<hw>Vault</hw>, <pos>v. i.</pos> <ety>[Cf. OF. <ets>volter</ets>, F.
<ets>voltiger</ets>, It. <ets>voltare</ets> to turn. See <er>Vault</er>,
<pos>n.</pos>, 4.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To leap; to bound; to jump; to spring.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vaulting</qex> ambition, which o'erleaps itself.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Leaning on his lance, he <qex>vaulted</qex> on a tree.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Lucan <qex>vaulted</qex> upon Pegasus with all the heat and
intrepidity of youth.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To exhibit feats of tumbling or leaping; to
tumble.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaultage</ent><br/
<hw>Vault"age</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Vaulted work; also,
a vaulted place; an arched cellar.</def> <mark>[Obs.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaulted</ent><br/
<hw>Vault"ed</hw>, <pos>a.</pos> <sn>1.</sn> <def>Arched; concave;
<as>as, a <ex>vaulted</ex> roof</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Covered with an arch, or vault.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Bot.)</fld> <def>Arched like the roof of the mouth,
as the upper lip of many ringent flowers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaulter</ent><br/
<hw>Vault"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who vaults; a
leaper; a tumbler.</def> <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaulting</ent><br/
<hw>Vault"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of
constructing vaults; a vaulted construction.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Act of one who vaults or leaps.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaulty</ent><br/
<hw>Vault"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Arched; concave.</def>
<mark>[Obs.]</mark> <ldquo/The <xex>vaulty</xex> heaven.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaunce</ent><br/
<hw>Vaunce</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[See
<er>Advance</er>.]</ety> <def>To advance.</def> <mark>[Obs.]</mark>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaunt</ent><br/
<hw>Vaunt</hw> <pr>(v<aum/nt <it>or</it> v<add/nt; 277)</pr>, <pos>v.
i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Vaunted</conjf>;
<pos>p. pr. & vb. n.</pos> <conjf>Vaunting</conjf>.]</vmorph> <ety>[F.
<ets>vanter</ets>, LL. <ets>vanitare</ets>, fr. L. <ets>vanus</ets>
vain. See <er>Vain</er>.]</ety> <def>To boast; to make a vain display of
one's own worth, attainments, decorations, or the like; to talk
ostentatiously; to brag.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Pride, which prompts a man to <qex>vaunt</qex> and overvalue what
he is, does incline him to disvalue what he has.</q> <rj><qau>Gov. of
Tongue.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaunt</ent><br/
<hw>Vaunt</hw>, <pos>v. t.</pos> <def>To boast of; to make a vain
display of; to display with ostentation. In the latter sense, the term
usually used is <contr>flaunt</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Charity <qex>vaunteth</qex> not itself, is not puffed up.</q>
<rj><qau>1 Cor. xiii. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>My vanquisher, spoiled of his <qex>vaunted</qex> spoil.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaunt</ent><br/
<hw>Vaunt</hw>, <pos>n.</pos> <def>A vain display of what one is, or
has, or has done; ostentation from vanity; a boast; a brag.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The spirits beneath, whom I seduced<br/
With other promises and other <qex>vaunts</qex>.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaunt</ent><br/
<hw>Vaunt</hw>, <pos>n.</pos> <ety>[F. <ets>avant</ets> before, fore.
See <er>Avant</er>, <er>Vanguard</er>.]</ety> <def>The first part.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaunt</ent><br/
<hw>Vaunt</hw>, <pos>v. t.</pos> <ety>[See <er>Avant</er>,
<er>Advance</er>.]</ety> <def>To put forward; to display.</def>
<mark>[Obs.]</mark> <ldquo/<xex>Vaunted</xex> spear.<rdquo/
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And what so else his person most may <qex>vaunt</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaunt-courier</ent><br/
<hw>Vaunt"-cou`ri*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Van-courier</er>.</def> <mark>[Obs.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaunter</ent><br/
<hw>Vaunt"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who vaunts; a
boaster.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vauntful</ent><br/
<hw>Vaunt"ful</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Given to vaunting or
boasting; vainly ostentatious; boastful; vainglorious.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vauntingly</ent><br/
<hw>Vaunt"ing*ly</hw>, <pos>adv.</pos> <def>In a vaunting
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vauntmure</ent><br/
<hw>Vaunt"mure`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>avant-mur</ets>. See <er>Vanguard</er>, and <er>Mure</er>.]</ety>
<fld>(Fort.)</fld> <def>A false wall; a work raised in front of the main
wall.</def> <altsp>[Written also <asp>vaimure</asp>, and
<asp>vamure</asp>.]</altsp> <rj><au>Camden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vauquelinite</ent><br/
<hw>Vauque"lin*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So called
after the French chemist <etsep>Vauquelin</etsep>, who died in 1829: cf.
F. <ets>vauquelinite</ets>.]</ety> <fld>(Min.)</fld> <def>Chromate of
copper and lead, of various shades of green.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaut</ent><br/
<hw>Vaut</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To vault; to
leap.</def> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaut</ent><br/
<hw>Vaut</hw>, <pos>n.</pos> <def>A vault; a leap.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vauty</ent><br/
<hw>Vaut"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Vaulted.</def>
<ldquo/The haughty <xex>vauty</xex> welkin.<rdquo/ <mark>[Obs.]</mark>
<rj><au>Taylor (1611).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vavasor</ent><br/
<hw>Vav"a*sor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vavasour</ets>, OF. <ets>vavassor</ets>, <ets>vavassour</ets>, F.
<ets>vavasseur</ets>, LL. <ets>vavassor</ets>, probably contr. from
<ets>vassus vassorum</ets> vassal of the vassals. See
<er>Vassal</er>.]</ety> <fld>(Feud. Law)</fld> <def>The vassal or tenant
of a baron; one who held under a baron, and who also had tenants under
him; one in dignity next to a baron; a title of dignity next to a
baron.</def> <au>Burrill.</au> <ldquo/A worthy
<xex>vavasour</xex>.<rdquo/ <au>Chaucer.</au> <altsp>[Also written
<asp>vavasour</asp>, <asp>vavassor</asp>, <asp>valvasor</asp>,
etc.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vavasours</qex> subdivide again to vassals, exchanging land
and cattle, human or otherwise, against fealty.</q>
<rj><qau>Motley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vavasory</ent><br/
<hw>Vav"a*so*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vavassorie</ets>.]</ety> <fld>(Feud. Law)</fld> <def>The quality or
tenure of the fee held by a vavasor; also, the lands held by a
vavasor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaward</ent><br/
<hw>Va"ward`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[For
<ets>vanward</ets>, equivalent to <ets>vanguard</ets>. See
<er>Vanguard</er>, <er>Ward</er> guard.]</ety> <def>The fore part;
van.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Since we have the <qex>vaward</qex> of the day.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vaza parrot</ent><br/
<hw>Va"za par`rot</hw> <pr>(?)</pr>. <fld>(Zool.)</fld> <def>Any one of
several species of parrots of the genus <gen>Coracopsis</gen>, native of
Madagascar; -- called also <altname>vasa parrot</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>VCR</ent><br/
<hw>VCR</hw> <pr>(v<emac/"s<emac/*<aum/r`)</pr>, <pos>n.</pos> <def>a
<er>videocasette recorder</er>.</def> <mark>[acronym]</mark><br/
[<source>PJC</source>]</p>

<p><ent>Veadar</ent><br/
<hw>Ve"a*dar</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The thirteenth, or
intercalary, month of the Jewish ecclesiastical calendar, which is added
about every third year.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veal</ent><br/
<hw>Veal</hw> <pr>(v<emac/l)</pr>, <pos>n.</pos><ety>[OE.
<ets>veel</ets>, OF. <ets>veel</ets>, F. <ets>veau</ets>, L.
<ets>vitellus</ets>, dim. of <ets>vitulus</ets> a calf; akin to E.
<ets>wether</ets>. See <er>Wether</er>, and cf. <er>Vellum</er>,
<er>Vituline</er>.]</ety> <def>The flesh of a calf when killed and used
for food.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vection</ent><br/
<hw>Vec"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vectio</ets>, from <ets>vehere</ets>, <ets>vectum</ets>, to
carry.]</ety> <def>Vectitation.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vectitation</ent><br/
<hw>Vec`ti*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vectitatus</ets> borne about, fr. <ets>vectare</ets>, v. intens.
fr. <ets>vehere</ets>, <ets>vectum</ets>, to carry.]</ety> <def>The act
of carrying, or state of being carried.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vector</ent><br/
<hw>Vec"tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a bearer,
carrier. fr. <ets>vehere</ets>, <ets>vectum</ets>, to carry.]</ety>
<sn>1.</sn> <def>Same as <er>Radius vector</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Math.)</fld> <def>A directed quantity, as a
straight line, a force, or a velocity. Vectors are said to be equal when
their directions are the same and their magnitudes equal. Cf.
<er>Scalar</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In a triangle, either side is the <xex>vector sum</xex>
of the other two sides taken in proper order; the process finding the
vector sum of two or more vectors is <xex>vector addition</xex> (see
under <er>Addition</er>).</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vecture</ent><br/
<hw>Vec"ture</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vectura</ets>, from <ets>vehere</ets>, <ets>vectum</ets>, to carry.
Cf. <er>Vettura</er>, <er>Voiture</er>.]</ety> <def>The act of carrying;
conveyance; carriage.</def> <mark>[Obs.]</mark>
<rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veda</ent><br/
<hw>Ve"da</hw> <pr>(v<amac/"d<adot/<it>or</it> v<emac/"d<adot/;
277)</pr>, <pos>n.</pos> <ety>[Skr. <ets>v<emac/da</ets>, properly,
knowledge, from <ets>vid</ets> to know. See <er>Wit</er>.]</ety>
<def>The ancient sacred literature of the Hindus; also, one of the four
collections, called <stype>Rig-Veda</stype>, <stype>Yajur-Veda</stype>,
<stype>Sama-Veda</stype>, and <stype>Atharva-Veda</stype>, constituting
the most ancient portions of that literature.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The language of the Vedas is usually called <col>Vedic
Sanskrit</col>, as distinguished from the later and more settled form
called <col>classical Sanskrit</col>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vedanta</ent><br/
<hw>Ve*dan"ta</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Skr.
<ets>V<emac/danta</ets>.]</ety> <def>A system of philosophy among the
Hindus, founded on scattered texts of the Vedas, and thence termed the
<ldquo/Anta,<rdquo/ or end or substance.</def> <rj><au>Balfour (Cyc. of
India.)</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vedantic</ent><br/
<hw>Ve*dan"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to
the Vedas.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vedantist</ent><br/
<hw>Ve*dan"tist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One versed in the
doctrines of the Vedantas.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veddahs</ent><br/
<hw>Ved"dahs</hw> <pr>(v<ecr/d"d<adot/z)</pr>, <pos>n. pl.</pos>
(Ethnol.) <def>A primitive people of Ceylon.</def> <altsp>[Written also
<asp>Weddars</asp>.]</altsp> <rj><au>Encyc Brit.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vedette</ent><br/
<hw>Ve*dette"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vedette</ets>, It. <ets>vedetta</ets>, for <ets>veletta</ets>
(influenced by <ets>vedere</ets> to see, L. <ets>videre</ets>), from It.
<ets>veglia</ets> watch, L. <ets>vigilia</ets>. See
<er>Vigil</er>.]</ety> <def>A sentinel, usually on horseback, stationed
on the outpost of an army, to watch an enemy and give notice of danger;
a vidette.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vedic</ent><br/
<hw>Ve"dic</hw> <pr>(v<amac/"d<icr/k <it>or</it> v<emac/"-)</pr>,
<pos>a. </pos> <def>Of or pertaining to the Vedas or one of the
Vedas.</def> <rj><au>Max M<uum/ller)</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vedro</ent><br/
<hw>Ve"dro</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Russ., pail.]</ety>
<def>A Russian liquid measure, equal to 3.249 gallons of U. S. standard
measure, or 2.706 imperial gallons.</def>
<rj><au>McElrath.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veer</ent><br/
<hw>Veer</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Veered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Veering</conjf>.]</vmorph> <ety>[F. <ets>virer</ets> (cf. Sp.
<ets>virar</ets>, <ets>birar</ets>), LL. <ets>virare</ets>; perhaps fr.
L. <ets>vibrare</ets> to brandish, vibrate (cf. <er>Vibrate</er>); or
cf. L. <ets>viriae</ets> armlets, bracelets, <ets>viriola</ets> a little
bracelet (cf. <er>Ferrule</er>). Cf. <er>Environ</er>.]</ety> <def>To
change direction; to turn; to shift; <as>as, wind <ex>veers</ex> to the
west or north</as>.</def> <ldquo/His <xex>veering</xex> gait.<rdquo/
<rj><au>Wordsworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And as he leads, the following navy <qex>veers</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>an ordinary community which is hostile or friendly as passion or
as interest may <qex>veer</qex> about.</q>
<rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To veer and haul</b></col> <fld>(Naut.)</fld>, <cd>to
vary the course or direction; -- said of the wind, which
<xex>veers</xex> aft and <xex>hauls</xex> forward. The wind is also said
to <xex>veer</xex> when it shifts with the sun.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veer</ent><br/
<hw>Veer</hw>, <pos>v. t.</pos> <def>To direct to a different course; to
turn; to wear; <as>as, to <ex>veer</ex>, or wear, a
vessel</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To veer and haul</b></col> <fld>(Naut.)</fld>, <cd>to
pull tight and slacken alternately.</cd> <au>Totten.</au> --
<mcol><col><b>To veer away</b></col> <it>or</it> <col><b>To veer
out</b></col></mcol> <fld>(Naut.)</fld>, <cd>to let out; to slacken and
let run; to pay out; <as>as, <ex>to veer away</ex> the cable; <ex>to
veer out</ex> a rope</as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veerable</ent><br/
<hw>Veer"a*ble</hw> <pr>(-<adot/*b'l)</pr>, <pos>a.</pos>
<def>Changeable; shifting; as, winds <ex>veerable</ex> to
southwest.</def> <rj><au>Dampier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veering</ent><br/
<hw>Veer"ing</hw>, <pos>a.</pos> <def>Shifting.</def> --
<wordforms><wf>Veer"ing*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veery</ent><br/
<hw>Veer"y</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>An
American thrush (<spn>Turdus fuscescens</spn>) common in the Northern
United States and Canada. It is light tawny brown above. The breast is
pale buff, thickly spotted with brown. Called also <altname>Wilson's
thrush</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Sometimes I hear the <qex>veery's</qex> clarion.</q>
<rj><qau>Thoreau.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vega</ent><br/
<hw>Ve"ga</hw> <pr>(v<emac/"g<adot/)</pr>, <pos>n.</pos>
<fld>(Astron.)</fld> <ety>[Ar. <ets>w<amac/gi'</ets>, properly, falling:
cf. F. <ets>W<eacute/ga</ets>.]</ety> <def>A brilliant star of the first
magnitude, the brightest of those constituting the constellation
Lyra.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vega</ent><br/
\'d8<hw>Ve"ga</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp.]</ety> <def>An
open tract of ground; a plain, esp. one which is moist and fertile, as
those used for tobacco fields.</def> <mark>[Sp. Amer. & Phil.
Islands]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>vegan</ent><br/
<hw>ve"gan</hw> <pr>(v<emac/"g<ucr/n <it>or</it> v<emac/j"<ucr/n)</pr>,
<pos>n.</pos> <def>A vegetarian who does not eat any animal products,
not even fish, eggs, or milk.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vegetability</ent><br/
<hw>Veg`e*ta*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality
or state of being vegetable.</def> <mark>[Obs.]</mark> <rj><au>Sir T.
Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetable</ent><br/
<hw>Veg`e*ta*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F.
<ets>v<eacute/g<eacute/table</ets> growing, capable of growing, formerly
also, as a noun, a vegetable, from L. <ets>vegetabilis</ets> enlivening,
from <ets>vegetare</ets> to enliven, invigorate, quicken,
<ets>vegetus</ets> enlivened, vigorous, active, <ets>vegere</ets> to
quicken, arouse, to be lively, akin to <ets>vigere</ets> to be lively,
to thrive, <ets>vigil</ets> watchful, awake, and probably to E.
<ets>wake</ets>, v. See <er>Vigil</er>, <er>Wake</er>,
<pos>v.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Of or pertaining to plants; having the nature of, or
produced by, plants; <as>as, a <ex>vegetable</ex> nature;
<ex>vegetable</ex> growths, juices, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Blooming ambrosial fruit<br/
Of <qex>vegetable</qex> gold.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Consisting of, or comprising, plants; <as>as, the
<ex>vegetable</ex> kingdom</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vegetable alkali</b></col> <fld>(Chem.)</fld>, <cd>an
alkaloid.</cd> -- <col><b>Vegetable brimstone</b></col>.
<fld>(Bot.)</fld> <cd>See <cref>Vegetable sulphur</cref>, below.</cd> --
<col><b>Vegetable butter</b></col> <fld>(Bot.)</fld>, <cd>a name of
several kinds of concrete vegetable oil; as that produced by the Indian
butter tree, the African shea tree, and the <spn>Pentadesma
butyracea</spn>, a tree of the order <ord>Guttiferae</ord>, also
African. Still another kind is pressed from the seeds of cocoa
(<gen>Theobroma</gen>).</cd> -- <col><b>Vegetable flannel</b></col>,
<cd>a textile material, manufactured in Germany from pine-needle wool, a
down or fiber obtained from the leaves of the <spn>Pinus
sylvestris</spn>.</cd> -- <col><b>Vegetable ivory</b></col>. <cd>See
<cref>Ivory nut</cref>, under <er>Ivory</er>.</cd> -- <col><b>Vegetable
jelly</b></col>. <cd>See <er>Pectin</er>.</cd> -- <col><b>Vegetable
kingdom</b></col>. <fld>(Nat. Hist.)</fld> <cd>See the last Phrase,
below.</cd> -- <col><b>Vegetable leather</b></col>. <sd>(a)</sd>
<fld>(Bot.)</fld> <cd>A shrubby West Indian spurge (<spn>Euphorbia
punicea</spn>), with leathery foliage and crimson bracts.</cd>
<sd>(b)</sd> <cd>See <cref>Vegetable leather</cref>, under
<er>Leather</er>.</cd> -- <col><b>Vegetable marrow</b></col>
<fld>(Bot.)</fld>, <cd>an egg-shaped gourd, commonly eight to ten inches
long. It is noted for the very tender quality of its flesh, and is a
favorite culinary vegetable in England. It has been said to be of
Persian origin, but is now thought to have been derived from a form of
the American pumpkin.</cd> -- <col><b>Vegetable oyster</b></col>
<fld>(Bot.)</fld>, <cd>the oyster plant. See under <er>Oyster</er>.</cd>
-- <col><b>Vegetable parchment</b></col>, <cd>papyrine.</cd> --
<col><b>Vegetable sheep</b></col> <fld>(Bot.)</fld>, <cd>a white woolly
plant (<spn>Raoulia eximia</spn>) of New Zealand, which grows in the
form of large fleecy cushions on the mountains.</cd> --
<col><b>Vegetable silk</b></col>, <cd>a cottonlike, fibrous material
obtained from the coating of the seeds of a Brazilian tree
(<spn>Chorisia speciosa</spn>). It is used for various purposes, as for
stuffing cushions, and the like, but is incapable of being spun on
account of a want of cohesion among the fibers.</cd> --
<col><b>Vegetable sponge</b></col>. <cd>See 1st <er>Loof</er>.</cd> --
<col><b>Vegetable sulphur</b></col>, <cd>the fine and highly inflammable
spores of the club moss (<spn>Lycopodium clavatum</spn>); witch
meal.</cd> -- <col><b>Vegetable tallow</b></col>, <cd>a substance
resembling tallow, obtained from various plants; as, <cref>Chinese
vegetable tallow</cref>, obtained from the seeds of the tallow tree.
<cref>Indian vegetable tallow</cref> is a name sometimes given to piney
tallow.</cd> -- <col><b>Vegetable wax</b></col>, <cd>a waxy excretion on
the leaves or fruits of certain plants, as the bayberry.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1598 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vegetable kingdom</b></col> <fld>(Nat. Hist.)</fld>,
<cd>that primary division of living things which includes all plants.
The classes of the vegetable kingdom have been grouped differently by
various botanists. The following is one of the best of the many
arrangements of the principal subdivisions.</cd><br/
[<source>1913 Webster</source>]</p>

<p><--- Note: this section was divided into two columns, the right-hand
column being delimited and separated from the left-hand column by a long
brace on its left side. The portion in the right-hand column of each of
these two divisions is instead included here within braces {}. The
definitions of the divisions were in the left-hand column, centered on
the right-hand segments. --> I.
<subclass><er>Phaenogamia</er></subclass> (called also
<er>Phanerogamia</er>). <def>Plants having distinct flowers and true
seeds.</def> { 1. <er>Dicotyledons</er> (called also <er>Exogens</er>).
-- Seeds with two or more cotyledons. Stems with the pith, woody fiber,
and bark concentrically arranged. Divided into two subclasses:
<er>Angiosperms</er>, having the woody fiber interspersed with dotted or
annular ducts, and the seeds contained in a true ovary;
<er>Gymnosperms</er>, having few or no ducts in the woody fiber, and the
seeds naked. 2. <er>Monocotyledons</er> (called also <er>Endogens</er>).
-- Seeds with single cotyledon. Stems with slender bundles of woody
fiber not concentrically arranged, and with no true bark.}<br/
[<source>1913 Webster</source>]</p>

<p>II. <subclass><er>Cryptogamia</er></subclass>. <def>Plants without
true flowers, and reproduced by minute spores of various kinds, or by
simple cell division.</def> { 1. <er>Acrogens</er>. -- Plants usually
with distinct stems and leaves, existing in two alternate conditions,
one of which is nonsexual and sporophoric, the other sexual and
oophoric. Divided into <er>Vascular Acrogens</er>, or
<er>Pteridophyta</er>, having the sporophoric plant conspicuous and
consisting partly of vascular tissue, as in Ferns, Lycopods, and
Equiseta, and <er>Cellular Acrogens</er>, or <er>Bryophyta</er>, having
the sexual plant most conspicuous, but destitute of vascular tissue, as
in Mosses and Scale Mosses. 2. <er>Thallogens</er>. -- Plants without
distinct stem and leaves, consisting of a simple or branched mass of
cellular tissue, or reduced to a single cell. Reproduction effected
variously. Divided into <er>Algae</er>, which contain chlorophyll or its
equivalent, and which live upon air and water, and <er>Fungi</er>, which
contain no chlorophyll, and live on organic matter. (Lichens are now
believed to be fungi parasitic on included algae.} </cs><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Many botanists divide the Phaenogamia primarily into
Gymnosperms and Angiosperms, and the latter into Dicotyledons and
Monocotyledons. Others consider Pteridophyta and Bryophyta to be
separate classes. Thallogens are variously divided by different writers,
and the places for diatoms, slime molds, and stoneworts are altogether
uncertain.<br/
[<source>1913 Webster</source>]</p>

<p> For definitions, see these names in the Vocabulary.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetable</ent><br/
<hw>Veg"e*ta*ble</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn>
<fld>(Biol.)</fld> <def>A plant. See <er>Plant</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A plant used or cultivated for food for man or
domestic animals, as the cabbage, turnip, potato, bean, dandelion, etc.;
also, the edible part of such a plant, as prepared for market or the
table.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A person who has permanently lost consciousness, due
to damage to the brain, but remains alive; sometimes continued life
requires support by machinery such as breathing tubes. Such a person is
said to be in a vegetative state.</def><br/
[<source>PJC</source>]</p>

<p><note><hand/ <xex>Vegetables</xex> and <xex>fruits</xex> are
sometimes loosely distinguished by the usual need of cooking the former
for the use of man, while the latter may be eaten raw; but the
distinction often fails, as in the case of quinces, barberries, and
other fruits, and lettuce, celery, and other vegetables. Tomatoes if
cooked are vegetables, if eaten raw are fruits.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetal</ent><br/
<hw>Veg"e*tal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F.
<ets>v<eacute/g<eacute/tal</ets>. See <er>Vegetable</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Of or pertaining to vegetables, or the vegetable
kingdom; of the nature of a vegetable; vegetable.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>All creatures <qex>vegetal</qex>, sensible, and rational.</q>
<rj><qau>Burton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Biol.)</fld> <def>Of, pertaining to, or
designating, that class of vital phenomena, such as digestion,
absorption, assimilation, secretion, excretion, circulation, generation,
etc., which are common to plants and animals, in distinction from
<xex>sensation</xex> and <xex>volition</xex>, which are peculiar to
animals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetal</ent><br/
<hw>Veg"e*tal</hw>, <pos>n.</pos> <ety>[F.]</ety> <def>A
vegetable.</def> <mark>[R.]</mark> <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetality</ent><br/
<hw>Veg`e*tal"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
quality or state of being vegetal, or vegetable.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Biol.)</fld> <def>The quality or state of being
vegetal, or exhibiting those physiological phenomena which are common to
plants and animals. See <er>Vegetal</er>, <pos>a.</pos>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetarian</ent><br/
<hw>Veg`e*ta"ri*an</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who holds
that vegetables and fruits are the only proper food for man. Strict
vegetarians eat no meat, eggs, or milk, and are sometimes referred to as
<stype>vegans</stype>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetarian</ent><br/
<hw>Veg`e*ta"ri*an</hw>, <pos>a.</pos> <def>Of or pertaining to
vegetarianism; <as>as, a <ex>vegetarian</ex> diet</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetarianism</ent><br/
<hw>Veg`e*ta"ri*an*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The theory
or practice of living upon vegetables and fruits.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetate</ent><br/
<hw>Veg"e*tate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vegetated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vegetating</conjf>.]</vmorph> <ety>[L.
<ets>vegetatus</ets>, p. p. of <ets>vegetare</ets> to enliven. See
<er>Vegetable</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To grow, as plants, by nutriment imbibed by means of
roots and leaves; to start into growth; to sprout; to
germinate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>See dying vegetables life sustain,<br/
See life dissolving <qex>vegetate</qex> again.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: To lead a life too low for an animate
creature; to do nothing but eat and grow.</def>
<rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Persons who . . . would have <qex>vegetated</qex> stupidly in the
places where fortune had fixed them.</q>
<rj><qau>Jeffrey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Med.)</fld> <def>To grow exuberantly; to produce
fleshy or warty outgrowths; <as>as, a <ex>vegetating</ex>
papule</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetation</ent><br/
<hw>Veg`e*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>v<eacute/g<eacute/tation</ets>, L. <ets>vegetatio</ets> an
enlivening. See <er>Vegetable</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The act or process of vegetating, or growing as a
plant does; vegetable growth.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The sum of vegetable life; vegetables or plants in
general; <as>as, luxuriant <ex>vegetation</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Med.)</fld> <def>An exuberant morbid outgrowth upon
any part, especially upon the valves of the heart.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vegetation of salts</b></col> <fld>(Old Chem.)</fld>,
<cd>a crystalline growth of an arborescent form.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetative</ent><br/
<hw>Veg"e*ta*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>v<eacute/g<eacute/tatif</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Growing, or having the power of growing, as plants;
capable of vegetating.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Having the power to produce growth in plants;
<as>as, the <ex>vegetative</ex> properties of soil</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Biol.)</fld> <def>Having relation to growth or
nutrition; partaking of simple growth and enlargement of the systems of
nutrition, apart from the sensorial or distinctively animal functions;
vegetal.</def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Veg"e*ta*tive*ly</wf>, <pos>adv.</pos> --
<wf>Veg"e*ta*tive*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegete</ent><br/
<hw>Ve*gete"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vegetus</ets>. See <er>Vegetable</er>.]</ety> <def>Lively; active;
sprightly; vigorous.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Even her body was made airy and <qex>vegete</qex>.</q>
<rj><qau>Jer. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetism</ent><br/
<hw>Veg"e*tism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Vegetal state or
characteristic.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vegetive</ent><br/
<hw>Veg"e*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Vegetate</er>, and <er>Vegetative</er>.]</ety> <def>Having the
nature of a plant; vegetable; <as>as, <ex>vegetive</ex> life</as>.</def>
<mark>[R.]</mark> <rj><au>Tusser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetive</ent><br/
<hw>Veg"e*tive</hw>, <pos>n.</pos> <def>A vegetable.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The blest infusions<br/
That dwell in <qex>vegetives</qex>, in metals, stones.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegeto-animal</ent><br/
<hw>Veg"e*to-an"i*mal</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Biol.)</fld> <def>Partaking of the nature both of vegetable and
animal matter; -- a term sometimes applied to vegetable albumen and
gluten, from their resemblance to similar animal products.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vegetous</ent><br/
<hw>Veg"e*tous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vegetus</ets>. See <er>Vegete</er>.]</ety> <def>Vigorous; lively;
active; vegete.</def> <mark>[Obs.]</mark> <rj><au>B.
Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vehemence</ent><br/
<hw>Ve"he*mence</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vehementia</ets>: cf. F.
<ets>v<eacute/h<eacute/mence</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The quality or state of being vehement; impetuous
force; impetuosity; violence; fury; <as>as, the <ex>vehemence</ex> of
the wind; to speak with <ex>vehemence</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Violent ardor; great heat; animated fervor; <as>as,
the <ex>vehemence</ex> of love, anger, or other passions</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I . . . tremble at his <qex>vehemence</qex> of temper.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vehemency</ent><br/
<hw>Ve"he*men*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Vehemence.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>vehemency</qex> of your affection.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vehement</ent><br/
<hw>Ve"he*ment</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vehemens</ets>, the first part of which is perhaps akin to
<ets>vehere</ets> to carry, and the second <ets>mens</ets> mind: cf. F.
<ets>v<eacute/h<eacute/ment</ets>. Cf. <er>Vehicle</er>, and
<er>Mental</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Acting with great force; furious; violent;
impetuous; forcible; mighty; <as>as, a <ex>vehement</ex> wind; a
<ex>vehement</ex> torrent; a <ex>vehement</ex> fire or
heat</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Very ardent; very eager or urgent; very fervent;
passionate; <as>as, a <ex>vehement</ex> affection or passion</as>.</def>
<ldquo/<xex>Vehement</xex> instigation.<rdquo/ <au>Shak.</au>
<ldquo/<xex>Vehement</xex> desire.<rdquo/ <au>Milton.</au><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Furious; violent; raging; impetuous; passionate;
ardent; eager; hot; fervid; burning.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vehemently</ent><br/
<hw>Ve"he*ment*ly</hw>, <pos>adv.</pos> <def>In a vehement
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vehicle</ent><br/
<hw>Ve"hi*cle</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vehiculum</ets>, fr. <ets>vehere</ets> to carry; akin to E.
<ets>way</ets>, <ets>wain</ets>. See <er>Way</er>, <pos>n.</pos>, and
cf. <er>Convex</er>, <er>Inveigh</er>, <er>Veil</er>,
<er>Vex</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>That in or on which any person or thing is, or may
be, carried, as a coach, carriage, wagon, cart, car, sleigh, bicycle,
etc.; a means of conveyance; specifically, a means of conveyance upon
land.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is used as the instrument of conveyance
or communication; <as>as, matter is the <ex>vehicle</ex> of
energy</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A simple style forms the best <qex>vehicle</qex> of thought to a
popular assembly.</q> <rj><qau>Wirt.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Pharm.)</fld> <def>A substance in which medicine is
taken.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Paint.)</fld> <def>Any liquid with which a pigment
is applied, including whatever gum, wax, or glutinous or adhesive
substance is combined with it.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Water is used in fresco and in water-color painting, the
colors being consolidated with gum arabic; size is used in distemper
painting. In oil painting, the fixed oils of linseed, nut, and poppy,
are used; in encaustic, wax is the vehicle.</note>
<rj><au>Fairholt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Chem.)</fld> <def>A liquid used to spread sensitive
salts upon glass and paper for use in photography.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vehicled</ent><br/
<hw>Ve"hi*cled</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Conveyed in a
vehicle; furnished with a vehicle.</def> <rj><au>M. Green.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vehicular</ent><br/
<hw>Ve*hic"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vehicularis</ets>: cf. F. <ets>v<eacute/hiculaire</ets>.]</ety>
<def>Of or pertaining to a vehicle; serving as a vehicle; <as>as, a
<ex>vehicular</ex> contrivance</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vehiculary</ent><br/
<hw>Ve*hic"u*la*ry</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Vehicular.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vehiculate</ent><br/
<hw>Ve*hic"u*late</hw>, <pos>v. t. & i.</pos> <def>To convey by means of
a vehicle; to ride in a vehicle.</def> <rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vehiculation</ent><br/
<hw>Ve*hic`u*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Movement of
vehicles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vehiculatory</ent><br/
<hw>Ve*hic"u*la*to*ry</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Vehicular.</def> <rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vehme</ent><br/
<ent>Vehm</ent><br/
<mhw>{ \'d8<hw>Vehm</hw>, \'d8<hw>Vehme</hw> }</mhw> <pr>(?)</pr>,
<pos>n.</pos>; <plu>pl. <plw>Vehme</plw> <pr>(#)</pr></plu>. <ety>[See
<er>Vehmgericht</er>.]</ety> <def>A vehmic court.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vehmgericht</ent><br/
\'d8<hw>Vehm"ge*richt</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu>pl.
<plw>Vehmgerichte</plw> <pr>(#)</pr></plu>. <ety>[G. <ets>vefm</ets>,
<ets>fehm</ets> criminal tribunal + <ets>gerichte</ets> court, judgment.
Cf. <er>Vehmic</er>.]</ety> <def>A vehmic court.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vehmic</ent><br/
<hw>Veh"mic</hw> <pr>(v<emac/"m<icr/k <it>or</it> v<amac/"m<icr/k;
277)</pr>, <pos>a.</pos> <ety>[G. <ets>vehm</ets>, <ets>fehm</ets>,
<ets>fehme</ets>, a secret tribunal of punishment, MHG.
<ets>veime</ets>, <ets>veme</ets>: cf. F. <ets>vehmique</ets>.]</ety>
<def>Of, pertaining to, or designating, certain secret tribunals which
flourished in Germany from the end of the 12th century to the middle of
the 16th, usurping many of the functions of the governments which were
too weak to maintain law and order, and inspiring dread in all who came
within their jurisdiction.</def> <rj><au>Encyc. Brit.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veil</ent><br/
<hw>Veil</hw> <pr>(v<amac/l)</pr>, <pos>n.</pos> <ety>[OE.
<ets>veile</ets>, OF. <ets>veile</ets>, F. <ets>voile</ets>, L.
<ets>velum</ets> a sail, covering, curtain, veil, probably fr.
<ets>vehere</ets> to bear, carry, and thus originally, that which bears
the ship on. See <er>Vehicle</er>, and cf. <er>Reveal</er>.]</ety>
<altsp>[Written also <asp>vail</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Something hung up, or spread out, to intercept the
view, and hide an object; a cover; a curtain; esp., a screen, usually of
gauze, crape, or similar diaphanous material, to hide or protect the
face.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>veil</qex> of the temple was rent in twain.</q>
<rj><qau>Matt. xxvii. 51.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>She, as a <qex>veil</qex> down to the slender waist,<br/
Her unadorn<eacute/d golden tresses wore.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A cover; a disguise; a mask; a pretense.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[I will] pluck the borrowed <qex>veil</qex> of modesty from the so
seeming Mistress Page.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Bot.)</fld> <sd>(a)</sd> <def>The calyptra of
mosses.</def> <sd>(b)</sd> <def>A membrane connecting the margin of the
pileus of a mushroom with the stalk; -- called also
<altname>velum</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Eccl.)</fld> <def>A covering for a person or thing;
<as>as, a nun's <ex>veil</ex>; a paten <ex>veil</ex>; an altar
<ex>veil</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Zool.)</fld> <def>Same as <er>Velum</er>,
3.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To take the veil</b></col> <fld>(Eccl.)</fld>, <cd>to
receive or be covered with, a veil, as a nun, in token of retirement
from the world; to become a nun.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veil</ent><br/
<hw>Veil</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Veiled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Veiling</conjf>.]</vmorph> <ety>[Cf. OF. <ets>veler</ets>, F.
<ets>voiler</ets>, L. <ets>velarc</ets>. See <er>Veil</er>,
<pos>n.</pos>]</ety> <altsp>[Written also <asp>vail</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To throw a veil over; to cover with a
veil.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Her face was <qex>veiled</qex>; yet to my fancied sight,<br/
Love, sweetness, goodness, in her person shined.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: To invest; to cover; to hide; to
conceal.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To keep your great pretenses <qex>veiled</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veiled</ent><br/
<hw>Veiled</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Covered by, or as by, a
veil; hidden.</def> <ldquo/Words used to convey a <xex>veiled</xex>
meaning.<rdquo/ <rj><au>Earle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veiled plate</ent><br/
<hw>Veiled plate</hw>. <fld>(Photog.)</fld> <def>A fogged
plate.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Veiling</ent><br/
<hw>Veil"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A veil; a thin
covering; also, material for making veils.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veilless</ent><br/
<hw>Veil"less</hw>, <pos>a.</pos> <def>Having no veil.</def>
<rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vein</ent><br/
<hw>Vein</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>veine</ets>, F.
<ets>veine</ets>, L. <ets>vena</ets>.]</ety> <sn>1.</sn>
<fld>(Anat.)</fld> <def>One of the vessels which carry blood, either
venous or arterial, to the heart. See <er>Artery</er>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>One of the similar branches of the
framework of a leaf.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>One of the ribs or nervures of
the wings of insects. See <er>Venation</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Geol. or Mining)</fld> <def>A narrow mass of rock
intersecting other rocks, and filling inclined or vertical fissures not
corresponding with the stratification; a lode; a dike; -- often limited,
in the language of miners, to a mineral vein or lode, that is, to a vein
which contains useful minerals or ores.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A fissure, cleft, or cavity, as in the earth or
other substance.</def> <ldquo/Down to the <xex>veins</xex> of
earth.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Let the glass of the prisms be free from <qex>veins</qex>.</q>
<rj><qau>Sir I. Newton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A streak or wave of different color, appearing in
wood, and in marble and other stones; variegation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>A train of associations, thoughts, emotions, or the
like; a current; a course; <as>as, reasoning in the same
<ex>vein</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He can open a <qex>vein</qex> of true and noble thinking.</q>
<rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>Peculiar temper or temperament; tendency or turn of
mind; a particular disposition or cast of genius; humor; strain;
quality; also, manner of speech or action; <as>as, a rich <ex>vein</ex>
of humor; a satirical <ex>vein</ex></as>.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Certain discoursing wits which are of the same
<qex>veins</qex>.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Invoke the Muses, and improve my <qex>vein</qex>.</q>
<rj><qau>Waller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vein</ent><br/
<hw>Vein</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Veined</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Veining</conjf>.]</vmorph> <def>To form or mark with veins; to
fill or cover with veins.</def> <rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veinal</ent><br/
<hw>Vein"al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Pertaining to veins;
venous.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veined</ent><br/
<hw>Veined</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Full of
veins; streaked; variegated; <as>as, <ex>veined</ex> marble</as>.</def>
<ldquo/<xex>Veined</xex> follies.<rdquo/ <rj><au>Ford.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Having fibrovascular threads
extending throughout the lamina; <as>as, a <ex>veined</ex>
leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veinless</ent><br/
<hw>Vein"less</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having no veins;
<as>as, a <ex>veinless</ex> leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veinlet</ent><br/
<hw>Vein"let</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A small
vein.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veinous</ent><br/
<hw>Vein"ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Marked with veins;
veined; veiny.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The excellent old gentleman's nails are long and leaden, and his
hands lean and <qex>veinous</qex>.</q> <rj><qau>Dickens.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vein quartz</ent><br/
<hw>Vein quartz</hw>. <def>Quartz occurring as gangue in a
vein.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Veinstone</ent><br/
<hw>Vein"stone`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Mining)</fld>
<def>The valueless nonmetalliferous mineral or rock material which
surrounds the ores in a vein, as quartz, calcite, barite, fluor spar,
etc.; gangue; matrix; -- called also
<altname>veinstuff</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veiny</ent><br/
<hw>Vein"y</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From <er>Vein</er>:
cf. F. <ets>vein<eacute/</ets>.]</ety> <def>Full of veins; veinous;
veined; <as>as, <ex>veiny</ex> marble</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velar</ent><br/
<hw>Ve"lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Velum</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Of or pertaining to a velum; esp. <fld>(Anat.)</fld>
of or pertaining to the soft palate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Phon.)</fld> <def>Having the place of articulation
on the soft palate; guttural; <as>as, the <ex>velar</ex> consonants,
such as <it>k</it> and hard <it>g</it></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velarium</ent><br/
\'d8<hw>Ve*la"ri*um</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Velaria</plw> <pr>(#)</pr>.</plu> <ety>[L., a covering.]</ety>
<fld>(Zool.)</fld> <def>The marginal membrane of certain medusae
belonging to the Discophora.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velate</ent><br/
<hw>Ve"late</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>velatus</ets>, p. p. of <ets>velare</ets> to veil. See
<er>Veil</er>.]</ety> <fld>(Bot.)</fld> <def>Having a veil;
veiled.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veldt</ent><br/
\'d8<hw>Veldt</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[D. <ets>veld</ets>.
Cf. <er>Field</er>, <pos>n.</pos>]</ety> <def>A region or tract of land;
esp., the open field, thinly forested or with bushes and shrubs; grass
country.</def> <mark>[South Africa]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Veldt sore</ent><br/
<hw>Veldt sore</hw>. <fld>(Med.)</fld> <def>An infective sore mostly on
the hands and feet, often contracted in walking on the veldt and
apparently due to a specific microorganism.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vele</ent><br/
<hw>Vele</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A veil.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velella</ent><br/
\'d8<hw>Ve*lel"la</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., dim. from
L. <ets>velum</ets> a veil, a sail.]</ety> <fld>(Zool.)</fld> <def>Any
species of oceanic Siphonophora belonging to the genus
<gen>Velella</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ These creatures are brilliantly colored and float at the
surface of the sea. They have an oblong, disklike body, supported by a
thin chitinous plate, from which rises a thin diagonal crest which acts
as a sail. The feeding and reproductive zooids hang down from the under
side of the disk.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veliferous</ent><br/
<hw>Ve*lif"er*ous</hw> <pr>(v<esl/*l<icr/f"<etil/r*<ucr/s)</pr>,
<pos>a.</pos> <ety>[L. <ets>velifer</ets>; <ets>velum</ets> a sail +
<ets>ferre</ets> to bear.]</ety> <def>Carrying or bearing sails.</def>
<mark>[Obs.]</mark> <ldquo/<xex>Veliferous</xex> chariots.<rdquo/
<rj><au>Evelyn.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1599 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veliger</ent><br/
\'d8<hw>Vel"i*ger</hw> <pr>(v<ecr/l"<icr/*j<etil/r)</pr>, <pos>n.</pos>
<ety>[NL., fr. L. <ets>velum</ets> a veil + <ets>gerere</ets>
bear.]</ety> <fld>(Zool.)</fld> <def>Any larval gastropod or bivalve
mollusk in the stage when it is furnished with one or two ciliated
membranes for swimming.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velitation</ent><br/
<hw>Vel`i*ta"tion</hw> <pr>(v<ecr/l`<icr/*t<amac/"sh<ucr/n)</pr>,
<pos>n.</pos> <ety>[L. <ets>velitatio</ets>, fr. <ets>velitari</ets>,
<ets>velitatus</ets>, to skirmish, from <ets>veles</ets>,
<ets>-itis</ets>, a light-armed soldier.]</ety> <def>A dispute or
contest; a slight contest; a skirmish.</def> <mark>[R.]</mark>
<rj><au>Sir M. Hale.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>After a short <qex>velitation</qex> we parted.</q>
<rj><qau>Evelyn.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velivolant</ent><br/
<hw>Ve*liv"o*lant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>velivolans</ets>; <ets>velum</ets> a sail + <ets>volare</ets> to
fly.]</ety> <def>Flying with sails; passing under full sail.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vell</ent><br/
<hw>Vell</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. L. <ets>vellus</ets>
the skin of a sheep with the wool on it, a fleece, a hide or pelt, or E.
<ets>fell</ets> a hide.]</ety> <def>The salted stomach of a calf, used
in making cheese; a rennet bag.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vell</ent><br/
<hw>Vell</hw>, <pos>v. i.</pos> <ety>[Cf. <er>Vell</er>,
<pos>n.</pos>]</ety> <def>To cut the turf from, as for burning.</def>
<mark>[Prov. Eng.]</mark> <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velleity</ent><br/
<hw>Vel*le"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vell<eacute/it<eacute/</ets> (cf. It. <ets>velleit<agrave/</ets>),
fr. L. <ets>velle</ets> to will, to be willing.]</ety> <def>The lowest
degree of desire; imperfect or incomplete volition.</def>
<rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vellet</ent><br/
<hw>Vel"let</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Velvet.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vellicate</ent><br/
<hw>Vel"li*cate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vellicated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vellicating</conjf>.]</vmorph> <ety>[L.
<ets>vellicatus</ets>, p. p. of <ets>vellicare</ets> to twitch, fr.
<ets>vellere</ets> to pluck, pull.]</ety> <def>To twitch; to cause to
twitch convulsively.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Convulsions, arising from something <qex>vellicating</qex> a nerve
in its extremity, are not very dangerous.</q>
<rj><qau>Arbuthnot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vellicate</ent><br/
<hw>Vel"li*cate</hw>, <pos>v. i.</pos> <def>To move spasmodically; to
twitch; <as>as, a nerve <ex>vellicates</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vellication</ent><br/
<hw>Vel`li*ca"tion</hw> <pr>(?)</pr>, <ety>[L.
<ets>vellicatio</ets>.]</ety> <sn>1.</sn> <def>The act of twitching, or
of causing to twitch.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <def>A local twitching, or convulsive
motion, of a muscular fiber, especially of the face.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vellicative</ent><br/
<hw>Vel"li*ca*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having the
power of vellicating, plucking, or twitching; causing
vellication.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vellon</ent><br/
\'d8<hw>Vel*lon"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp.]</ety>
<def>A word occurring in the phrase <cref>real vellon</cref>. See the
Note under 1st <er>Real</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vellum</ent><br/
<hw>Vel"lum</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>velim</ets>,
F. <ets>v<eacute/lin</ets>, fr. L. <ets>vitulinus</ets> of a calf, fr.
<ets>vitulus</ets> a calf. See <er>Veal</er>.]</ety> <def>A fine kind of
parchment, usually made from calfskin, and rendered clear and white, --
used as for writing upon, and for binding books.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vellum cloth</b></col>, <cd>a fine kind of cotton fabric,
made very transparent, and used as a tracing cloth.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vellumy</ent><br/
<hw>Vel"lum*y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Resembling
vellum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velocimeter</ent><br/
<hw>Vel`o*cim"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>velox</ets>, <ets>-ocis</ets>, rapid + <ets>-meter</ets>.]</ety>
<def>An apparatus for measuring speed, as of machinery or vessels, but
especially of projectiles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velocipede</ent><br/
<hw>Ve*loc"i*pede</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>velox</ets>, <ets>-ocis</ets>, swift + <ets>pes</ets>,
<ets>pedis</ets>, a foot. See <er>Velocity</er>, and
<er>Foot</er>.]</ety> <def>A light road carriage propelled by the feet
of the rider. Originally it was propelled by striking the tips of the
toes on the roadway, but commonly now by the action of the feet on a
pedal or pedals connected with the axle of one or more of the wheels,
and causing their revolution. They are made in many forms, with two,
three, or four wheels. See <er>Bicycle</er>, and
<er>Tricycle</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velocipedist</ent><br/
<hw>Ve*loc"i*pe`dist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who rides
on a velocipede; a cyclist.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Velocity</ent><br/
<hw>Ve*loc"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Velocities</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>velocitas</ets>,
from <ets>velox</ets>, <ets>-ocis</ets>, swift, quick; perhaps akin to
<ets>volare</ets> to fly (see <er>Volatile</er>): cf. F.
<ets>v<eacute/locit<eacute/</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Quickness of motion; swiftness; speed; celerity;
rapidity; <as>as, the <ex>velocity</ex> of wind; the <ex>velocity</ex>
of a planet or comet in its orbit or course; the <ex>velocity</ex> of a
cannon ball; the <ex>velocity</ex> of light.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In such phrases, <xex>velocity</xex> is more generally
used than <xex>celerity</xex>. We apply <xex>celerity</xex> to animals;
as, a horse or an ostrich runs with <xex>celerity</xex>; but bodies
moving in the air or in ethereal space move with greater or less
<xex>velocity</xex>, not <xex>celerity</xex>. This usage is arbitrary,
and perhaps not universal.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mech.)</fld> <def>Rate of motion; the relation of
motion to time, measured by the number of units of space passed over by
a moving body or point in a unit of time, usually the number of feet
passed over in a second. See the Note under <er>Speed</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Angular velocity</b></col>. <cd>See under
<er>Angular</er>.</cd> -- <col><b>Initial velocity</b></col>, <cd>the
velocity of a moving body at starting; especially, the velocity of a
projectile as it leaves the mouth of a firearm from which it is
discharged.</cd> -- <col><b>Relative velocity</b></col>, <cd>the
velocity with which a body approaches or recedes from another body,
whether both are moving or only one.</cd> -- <col><b>Uniform
velocity</b></col>, <cd>velocity in which the same number of units of
space are described in each successive unit of time.</cd> --
<col><b>Variable velocity</b></col>, <cd>velocity in which the space
described varies from instant to instant, either increasing or
decreasing; -- in the former case called <xex>accelerated
velocity</xex>, in the latter, <xex>retarded velocity</xex>; the
acceleration or retardation itself being also either <xex>uniform</xex>
or <xex>variable</xex>.</cd> -- <col><b>Virtual velocity</b></col>.
<cd>See under <er>Virtual</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In <xex>variable velocity</xex>, the velocity, strictly,
at any given instant, is the rate of motion at that instant, and is
expressed by the units of space, which, if the velocity at that instant
were continued uniform during a unit of time, would be described in the
unit of time; thus, the velocity of a falling body at a given instant is
the number of feet which, if the motion which the body has at that
instant were continued uniformly for one second, it would pass through
in the second. The scientific sense of <xex>velocity</xex> differs from
the popular sense in being applied to all rates of motion, however slow,
while the latter implies more or less rapidity or quickness of
motion.</note><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Swiftness; celerity; rapidity; fleetness;
speed.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velours</ent><br/
<hw>Ve*lours"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See
<er>Velure</er>.]</ety> <def>One of many textile fabrics having a pile
like that of velvet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Sauce veloute</ent><br/
<ent>Veloute</ent><br/
<mhw>{ \'d8<hw>Ve*lou`t<eacute/"</hw> <pr>(?)</pr>, <pos>n.</pos>,
<it>or</it> <hw>Sauce velout<eacute/</hw> <pr>(?)</pr> }</mhw>. <ety>[F.
<ets>velout<eacute/</ets>, lit., velvety.]</ety> <fld>(Cookery)</fld>
<def>A white sauce or stock made by boiling down ham, veal, beef, fowl,
bouillon, etc., then adding soup stock, seasoning, vegetables, and
thickening, and again boiling and straining.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Veltfare</ent><br/
<hw>Velt"fare</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Fieldfare</er>.]</ety> <fld>(Zool.)</fld> <def>The fieldfare.</def>
<mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velum</ent><br/
\'d8<hw>Ve"lum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vela</plw> <pr>(#)</pr>.</plu> <ety>[L., an awning, a veil. See
<er>Veil</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Anat.)</fld> <def>A curtain or covering; -- applied
to various membranous partitions, especially to the soft palate. See
under <er>Palate</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <sd>(a)</sd> <def>See <er>Veil</er>,
<pos>n.</pos>, 3 <sd>(b)</sd>.</def> <sd>(b)</sd> <def>A thin membrane
surrounding the sporocarps of quillworts <gen>Isoetes</gen>).</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>A veil-like organ or part.</def>
Especially: <sd>(a)</sd> <def>The circular membrane that partially
incloses the space beneath the umbrella of hydroid medusae.</def>
<sd>(b)</sd> <def>A delicate funnel-like membrane around the flagellum
of certain Infusoria. See <xex>Illust.</xex> <it>a</it> of
<er>Protozoa</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velure</ent><br/
<hw>Vel"ure</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>velours</ets>, OF. <ets>velous</ets>, from L. <ets>villosus</ets>
hairy. See <er>Velvet</er>.]</ety> <sn>1.</sn> <def>Velvet.</def>
<mark>[Obs.]</mark> <ldquo/A woman's crupper of
<xex>velure</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A substance resembling velvet.</def><br/
[<source>PJC</source>]</p>

<p><ent>Velutina</ent><br/
<hw>Vel`u*ti"na</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See
<er>Velvet</er>.]</ety> <fld>(Zool.)</fld> <def>Any one of several
species of marine gastropods belonging to <gen>Velutina</gen> and allied
genera.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velutinous</ent><br/
<hw>Ve*lu"ti*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[It.
<ets>velluto</ets> velvet. See <er>Velvet</er>.]</ety> <fld>(Bot.)</fld>
<def>Having the surface covered with a fine and dense silky pubescence;
velvety; <as>as, a <ex>velutinous</ex> leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velverd</ent><br/
<hw>Vel"verd</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The veltfare.</def>
<mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velveret</ent><br/
<hw>Vel`ver*et"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A kind of velvet
having cotton back.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velvet</ent><br/
<hw>Vel"vet</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>velouette</ets>, <ets>veluet</ets>, <ets>velwet</ets>; cf. OF.
<ets>velluau</ets>, LL. <ets>velluetum</ets>, <ets>vellutum</ets>, It.
<ets>velluto</ets>, Sp. <ets>velludo</ets>; all fr. (assumed) LL.
<ets>villutus</ets> shaggy, fr L. <ets>villus</ets> shaggy hair; akin to
<ets>vellus</ets> a fleece, and E. <ets>wool</ets>. See <er>Wool</er>,
and cf. <er>Villous</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A silk fabric, having a short, close nap of erect
threads. Inferior qualities are made with a silk pile on a cotton or
linen back, or with other soft fibers such as nylon, acetate, or
rayon.</def><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><sn>2.</sn> <def>The soft and highly vascular deciduous skin which
envelops and nourishes the antlers of deer during their rapid
growth.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Something likened to velvet{1} in being soft or
luxurious; <as>as, a lawn of <ex>velvet</ex></as>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Cotton velvet</b></col>, <cd>an imitation of velvet, made
of cotton.</cd> -- <col><b>Velvet cork</b></col>, <cd>the best kind of
cork bark, supple, elastic, and not woody or porous.</cd> --
<col><b>Velvet crab</b></col> <fld>(Zool.)</fld>, <cd>a European crab
(<spn>Portunus puber</spn>). When adult the black carapace is covered
with a velvety pile. Called also <altname>lady crab</altname>, and
<altname>velvet fiddler</altname>.</cd> -- <col><b>Velvet dock</b></col>
<fld>(Bot.)</fld>, <cd>the common mullein.</cd> -- <col><b>Velvet
duck</b></col>. <fld>(Zool.)</fld> <sd>(a)</sd> <cd>A large European sea
duck, or scoter (<spn>Oidemia fusca</spn>). The adult male is glossy,
velvety black, with a white speculum on each wing, and a white patch
behind each eye.</cd> <sd>(b)</sd> <cd>The American whitewinged scoter.
See <er>Scoter</er>.</cd> -- <col><b>Velvet flower</b></col>
<fld>(Bot.)</fld>, <cd>love-lies-bleeding. See under <er>Love</er>.</cd>
-- <col><b>Velvet grass</b></col> <fld>(Bot.)</fld>, <cd>a tall grass
(<spn>Holcus lanatus</spn>) with velvety stem and leaves; -- called also
<altname>soft grass</altname>.</cd> -- <col><b>Velvet runner</b></col>
<fld>(Zool.)</fld>, <cd>the water rail; -- so called from its quiet,
stealthy manner of running.</cd> <mark>[Prov. Eng.]</mark> --
<col><b>Velvet scoter</b></col>. <fld>(Zool.)</fld> <cd>Same as
<cref>Velvet duck</cref>, above.</cd> -- <col><b>Velvet
sponge</b></col>. <fld>(Zool.)</fld> <cd>See under <er>Sponge</er>.</cd>
-- <col><b>in velvet</b></col> <cd>having a coating of velvet{2} over
the antlers; in the annual stage where the antlers are still growing; --
of deer.</cd> </cs><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><ent>Velvet</ent><br/
<hw>Vel"vet</hw>, <pos>a.</pos> <def>Made of velvet; soft and delicate,
like velvet; velvety.</def> <ldquo/ The cowslip's <xex>velvet</xex>
head.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velvet</ent><br/
<hw>Vel"vet</hw>, <pos>v. i.</pos> <def>To pain velvet.</def>
<mark>[R.]</mark> <rj><au>Peacham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velvet</ent><br/
<hw>Vel"vet</hw>, <pos>v. t.</pos> <def>To make like, or cover with,
velvet.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velvetbreast</ent><br/
<hw>Vel"vet*breast`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>The goosander.</def> <mark>[Local, U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velveteen</ent><br/
<hw>Vel`vet*een"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>velvantine</ets>. See <er>Velvet</er>.]</ety> <def>A kind of cloth,
usually cotton, made in imitation of velvet; cotton velvet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velveting</ent><br/
<hw>Vel"vet*ing</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The fine shag or
nap of velvet; a piece of velvet; velvet goods.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velvetleaf</ent><br/
<hw>Vel"vet*leaf`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>A name given to several plants which have soft, velvety leaves, as
the <spn>Abutilon Avicennae</spn>, the <spn>Cissampelos Pareira</spn>,
and the <spn>Lavatera arborea</spn>, and even the common
mullein.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Velvety</ent><br/
<hw>Vel"vet*y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Made of velvet, or
like velvet; soft; smooth; delicate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vena</ent><br/
\'d8<hw>Ve"na</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Venae</plw> <pr>(#)</pr>.</plu> <ety>[L. See <er>Vein</er>.]</ety>
<def>A vein.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vena cava</b></col>; <plu><it>pl.</it> <plw>Venae
cavae</plw>.</plu> <ety>[L., literally, hollow vein.]</ety>
<fld>(Anat.)</fld> <cd>Any one of the great systemic veins connected
directly with the heart.</cd>-- <col><b>Vena contracta</b></col>.
<ety>[L., literally, contracted vein.]</ety> <fld>(Hydraulics)</fld>
<cd>The contracted portion of a liquid jet at and near the orifice from
which it issues.</cd> -- <col><b>Vena portae</b></col>;
<plu><it>pl.</it> <plw>Venae portae</plw>.</plu> <ety>[L., literally,
vein of the entrance.]</ety> <fld>(Anat.)</fld> <cd>The portal vein of
the liver. See under <er>Portal</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venada</ent><br/
<hw>Ve*na"da</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Sp.
<ets>venado</ets> a deer, stag.]</ety> <fld>(Zool.)</fld> <def>The
pudu.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venal</ent><br/
<hw>Ve"nal</hw> <pr>(v<emac/"n<ait/l)</pr>, <pos>a.</pos> <ety>[L.
<ets>vena</ets> a vein.]</ety> <def>Of or pertaining to veins; venous;
<as>as, <ex>venal</ex> blood</as>.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venal</ent><br/
<hw>Ve"nal</hw>, <pos>a.</pos> <ety>[L. <ets>venalis</ets>, from
<ets>venus</ets> sale; akin to Gr. <grk>'w^nos</grk> price, Skr.
<ets>vasna</ets>: cf. F. <ets>v<eacute/nal</ets>.]</ety> <def>Capable of
being bought or obtained for money or other valuable consideration; made
matter of trade or barter; held for sale; salable; mercenary;
purchasable; hireling; <as>as, <ex>venal</ex> services</as>.</def>
<ldquo/ Paid court to <xex>venal</xex> beauties.<rdquo/
<rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>venal</qex> cry and prepared vote of a passive
senate.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Mercenary; hireling; vendible.</syn> <usage> --
<er>Venal</er>, <er>Mercenary</er>. One is <xex>mercenary</xex> who is
either actually a hireling (as, <xex>mercenary</xex> soldiers, a
<xex>mercenary</xex> judge, etc.), or is governed by a sordid love of
gain; hence, we speak of <xex>mercenary</xex> motives, a
<xex>mercenary</xex> marriage, etc. <xex>Venal</xex> goes further, and
supposes either an actual <xex>purchase</xex>, or a readiness to be
purchased, which places a person or thing wholly in the power of the
purchaser; <as>as, a <ex>venal</ex> press</as>. Brissot played
ingeniously on the latter word in his celebrated saying, <ldquo/ My pen
is <xex>venal</xex> that it may not be <xex>mercenary</xex>,<rdquo/
meaning that he wrote books, and sold them to the publishers, in order
to avoid the necessity of being the hireling of any political
party.</usage><br/
[<source>1913 Webster</source>]</p>

<p><q>Thus needy wits a vile revenue made,<br/
And verse became a <qex>mercenary</qex> trade.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>This verse be thine, my friend, nor thou refuse<br/
This, from no <qex>venal</qex> or ungrateful muse.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venality</ent><br/
<hw>Ve*nal"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>venalitas</ets>: cf. F. <ets>v<eacute/nalit<eacute/</ets>.]</ety>
<def>The quality or state of being venal, or purchasable; mercenariness;
prostitution of talents, offices, or services, for money or reward;
<as>as, the <ex>venality</ex> of a corrupt court; the <ex>venality</ex>
of an official.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Complaints of Roman <qex>venality</qex> became louder.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venally</ent><br/
<hw>Ve"nal*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a venal
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venantes</ent><br/
\'d8<hw>Ve*nan"tes</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr.
L. <ets>venans</ets>, p. pr. of <ets>venari</ets> to hunt.]</ety>
<fld>(Zool.)</fld> <def>The hunting spiders, which run after, or leap
upon, their prey.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venary</ent><br/
<hw>Ven"a*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[LL.
<ets>venarius</ets>, fr. L. <ets>venari</ets>, p. p. <ets>venatus</ets>,
to hunt.]</ety> <def>Of or, pertaining to hunting.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venatical</ent><br/
<ent>Venatic</ent><br/
<mhw>{<hw>Ve*nat"ic</hw> <pr>(?)</pr>, <hw>Ve*nat"ic*al</hw>
<pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>venaticus</ets>, fr.
<ets>venatus</ets> hunting, fr. <ets>venari</ets>, p. p.
<ets>venatus</ets>, to hunt.]</ety> <def>Of or pertaining to hunting;
used in hunting.</def> <mark>[R.]</mark> <ldquo/ <xex>Venatical</xex>
pleasure.<rdquo/ <rj><au>Howell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venatica</ent><br/
<hw>Ve*nat"i*ca</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Vinatico</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venation</ent><br/
<hw>Ve*na"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>vena</ets>
a vein.]</ety> <def>The arrangement or system of veins, as in the wing
of an insect, or in the leaves of a plant. See <xex>Illust.</xex> in
Appendix.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venation</ent><br/
<hw>Ve*na"tion</hw>, <pos>n.</pos> <ety>[L. <ets>venatio</ets>, fr.
<ets>venari</ets>, p. p. <ets>venatus</ets>, to hunt. See
<er>Venison</er>.]</ety> <def>The act or art of hunting, or the state of
being hunted.</def> <mark>[Obs.]</mark> <rj><au>Sir T.
Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venatorial</ent><br/
<hw>Ven`a*to"ri*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>venatorius</ets>.]</ety> <def>Or or pertaining to hunting;
venatic.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vend</ent><br/
<hw>Vend</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Vended</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Vending</conjf>.]</vmorph> <ety>[F. <ets>vendre</ets>, L.
<ets>vendere</ets>, from <ets>venum dare</ets>; <ets>venus</ets> sale +
<ets>dare</ets> to give. See 2d <er>Venal</er>, <er>Date</er>,
time.]</ety> <def>To transfer to another person for a pecuniary
equivalent; to make an object of trade; to dispose of by sale; to sell;
<as>as, to <ex>vend</ex> goods; to <ex>vend</ex>
vegetables</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Vend</xex> differs from <xex>barter</xex>. We
<xex>vend</xex> for money; we <xex>barter</xex> for commodities.
<xex>Vend</xex> is used chiefly of wares, merchandise, or other small
articles, not of lands and tenements.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vend</ent><br/
<hw>Vend</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of vending or
selling; a sale.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The total sales of coal from a colliery.</def>
<mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vendace</ent><br/
<hw>Ven"dace</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A
European lake whitefish (<spn>Coregonus Willughbii</spn>, or
<spn>Coregonus Vandesius</spn>) native of certain lakes in Scotland and
England. It is regarded as a delicate food fish. Called also
<altname>vendis</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vendee</ent><br/
<hw>Vend*ee"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The person to whom a
thing is vended, or sold; -- the correlative of
<inv>vendor</inv>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vendemiaire</ent><br/
\'d8<hw>Ven`d<eacute/`miaire"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.,
fr. L. <ets>vindemia</ets> vintage.]</ety> <def>The first month of the
French republican calendar, dating from September 22, 1792.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This calendar was substituted for the ordinary calendar,
dating from the Christian era, by a decree of the National Convention in
1793. The 22d of September, 1792, which had been fixed upon as the day
of the foundation of the republic, was also the date of the new
calendar. In this calendar, the year, which began at midnight of the day
of the autumnal equinox, was divided into twelve months of thirty days,
with five additional days for festivals, and every fourth year six. Each
month was divided into three decades of ten days each, the week being
abolished. The names of the months in their order were,
<xex>Vend<eacute/miaire</xex>, <xex>Brumaire</xex>, <xex>Frimaire</xex>
<xex>Nivose</xex>, <xex>Pluviose</xex>, <xex>Ventose</xex>,
<xex>Germinal</xex>, <xex>Flor<eacute/al</xex>, <xex>Prairial</xex>,
<xex>Messidor</xex>, <xex>Thermidor</xex> (sometimes called
<xex>Fervidor</xex>), and <xex>Fructidor</xex>. This calendar was
abolished December 31, 1805, and the ordinary one restored January 1,
1806.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vender</ent><br/
<hw>Vend"er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <er>Vend</er>:
cf. F. <ets>vendeur</ets>, OF. <ets>vendeor</ets>. Cf.
<er>Vendor</er>.]</ety> <def>One who vends; one who transfers the
exclusive right of possessing a thing, either his own, or that of
another as his agent, for a price or pecuniary equivalent; a seller; a
vendor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vendetta</ent><br/
\'d8<hw>Ven*det"ta</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It.]</ety>
<sn>1.</sn> <def>A blood feud; private revenge for the murder of a
kinsman.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any feud or contention that is bitter and prolonged;
however, the deep enmity may be held by only one party to the dispute;
<as>as, the former Mayor nurtured a lifelong <ex>vendetta</ex> against
the candidate who defeated him</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vendibility</ent><br/
<hw>Vend`i*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being vendible, or salable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vendible</ent><br/
<hw>Vend"i*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vendibilis</ets>: cf. OF. <ets>vendible</ets>, F.
<ets>vendable</ets>.]</ety> <def>Capable of being vended, or sold; that
may be sold; salable.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The regulating of prices of things <qex>vendible</qex>.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Vendible</xex> differs from <xex>marketable</xex>;
the latter signifies <xex>proper</xex> or <xex>fit for market</xex>,
according to the laws or customs of a place. <xex>Vendible</xex> has no
reference to such legal fitness.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vendible</ent><br/
<hw>Vend"i*ble</hw>, <pos>n.</pos> <def>Something to be sold, or offered
for sale.</def> -- <wordforms><wf>Vend"i*ble*ness</wf>, <pos>n.</pos> --
<wf>Vend"i*bly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venditate</ent><br/
<hw>Ven"di*tate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[See
<er>Venditation</er>.]</ety> <def>To cry up. as if for sale; to
blazon.</def> <mark>[Obs.]</mark> <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venditation</ent><br/
<hw>Ven`di*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>venditatio</ets>, fr. <ets>venditare</ets>, <ets>venditatum</ets>,
to offer again and again for sale, v. freq. of <ets>vendere</ets>. See
<er>Vend</er>.]</ety> <def>The act of setting forth ostentatiously; a
boastful display.</def> <mark>[Obs.]</mark> <rj><au>B.
Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vendition</ent><br/
<hw>Ven*di"tion</hw> <pr>(v<ecr/n*d<icr/sh"<ucr/n)</pr>, <pos>n.</pos>
<ety>[L. <ets>venditio</ets>: cf. F. <ets>vendition</ets>.]</ety>
<def>The act of vending, or selling; sale.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1600 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vendor</ent><br/
<hw>Vend"or</hw> <pr>(v<ecr/nd"<ocr/r)</pr>, <pos>n.</pos> <ety>[See
<er>Vender</er>.]</ety> <def>A vender; a seller; the correlative of
<inv>vendee</inv>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vendor's lien</ent><br/
<hw>Vend"or's lien</hw>. <fld>(Law)</fld> <def>An implied lien (that is,
one not created by mortgage or other express agreement) given in equity
to a vendor of lands for the unpaid purchase money.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vends</ent><br/
<hw>Vends</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <fld>(Ethnol.)</fld>
<def>See <er>Wends</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vendue</ent><br/
<hw>Ven*due"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF.
<ets>vendue</ets>, from F. <ets>vendre</ets>, p. p. <ets>vendu</ets>,
<ets>vendue</ets>, to sell.]</ety> <def>A public sale of anything, by
outcry, to the highest bidder; an auction.</def>
<mark>[Obsoles.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vendue master</b></col>, <cd>one who is authorized to
sell any property by vendue; an auctioneer.</cd>
<mark>[Obsoles.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veneer</ent><br/
<hw>Ve*neer"</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Veneered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Veneering</conjf>.]</vmorph> <ety>[G.
<ets>furnieren</ets>, <ets>fourniren</ets>, fr. F. <ets>fournir</ets> to
furnish. See <er>Furnish</er>.]</ety> <def>To overlay or plate with a
thin layer of wood or other material for outer finish or decoration;
<as>as, to <ex>veneer</ex> a piece of furniture with mahogany</as>. Used
also figuratively.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>As a rogue in grain<br/
<qex>Veneered</qex> with sanctimonious theory.</q>
<rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veneer</ent><br/
<hw>Ve*neer"</hw>, <pos>n.</pos> <ety>[Cf. G. <ets>furnier</ets> or
<ets>fournier</ets>. See <er>Veneer</er>, <pos>v. t.</pos>]</ety> <def>A
thin leaf or layer of a more valuable or beautiful material for
overlaying an inferior one, especially such a thin leaf of wood to be
glued to a cheaper wood; hence, external show; gloss; false
pretense.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Veneer moth</b></col> <fld>(Zool.)</fld>, <cd>any moth of
the genus <gen>Chilo</gen>; -- so called because the mottled colors
resemble those of veneering.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veneering</ent><br/
<hw>Ve*neer"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act or art of
one who veneers.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Thin wood or other material used as a
veneer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venefical</ent><br/
<hw>Ve*nef"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>veneficus</ets>.]</ety> <def>Veneficial.</def> <mark>[Obs.]</mark>
<ldquo/<xex>Venefical</xex> instruments.<rdquo/ <rj><au>B.
Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venefice</ent><br/
<hw>Ven"e*fice</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>veneficium</ets>, fr. <ets>veneficus</ets> poisoning;
<ets>venenum</ets> poison + <ets>facere</ets> to make: cf. F.
<ets>v<eacute/n<eacute/fice</ets>.]</ety> <def>The act or practice of
poisoning.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veneficious</ent><br/
<ent>Veneficial</ent><br/
<mhw>{ <hw>Ven`e*fi"cial</hw> <pr>(?)</pr>, <hw>Ven`e*fi"cious</hw>
<pr>(?)</pr>, }</mhw> <pos>a.</pos> <def>Acting by poison; used in
poisoning or in sorcery.</def> <mark>[Obs.]</mark> <ldquo/An old
<xex>veneficious</xex> practice.<rdquo/ <au>Sir T. Browne.</au> --
<wordforms><wf>Ven`e*fi"cious*ly</wf>, <pos>adv.</pos>
<mark>[Obs.]</mark></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venemous</ent><br/
<hw>Ven"e*mous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Venomous.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venenate</ent><br/
<hw>Ven"e*nate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L.
<ets>venenatus</ets>, p. p. <ets>venenare</ets> to poison, from
<ets>venenum</ets> poison. Cf. <er>Venom</er>.]</ety> <def>To poison; to
infect with poison.</def> <mark>[R.]</mark>
<rj><au>Harvey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venenate</ent><br/
<hw>Ven"e*nate</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Poisoned.</def>
<rj><au>Woodward.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venenation</ent><br/
<hw>Ven`e*na"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
act of poisoning.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Poison; venom.</def> <mark>[Obs.]</mark> <rj><au>Sir
T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venene</ent><br/
<hw>Ve*nene"</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Poisonous;
venomous.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venenose</ent><br/
<hw>Ven"e*nose`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>venenosus</ets>, fr. <ets>venenum</ets> poison. Cf.
<er>Venomous</er>.]</ety> <def>Poisonous.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venerability</ent><br/
<hw>Ven`er*a*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality
or state of being venerable; venerableness.</def> <rj><au>Dr. H.
More.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venerable</ent><br/
<hw>Ven"er*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>venerabilis</ets>: cf. F.
<ets>v<eacute/n<eacute/rable</ets>.]</ety> <sn>1.</sn> <def>Capable of
being venerated; worthy of veneration or reverence; deserving of honor
and respect; -- generally implying an advanced age; <as>as, a
<ex>venerable</ex> magistrate; a <ex>venerable</ex>
parent</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He was a man of eternal self-sacrifice, and that is always
<qex>venerable</qex>.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Venerable</qex> men! you have come down to us from a former
generation.</q> <rj><qau>D. Webster.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Rendered sacred by religious or other associations;
that should be regarded with awe and treated with reverence; <as>as, the
<ex>venerable</ex> walls of a temple or a church</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This word is employed in the Church of England as a
title for an archdeacon. In the Roman Catholic Church,
<xex>venerable</xex> is applied to those who have attained to the lowest
of the three recognized degrees of sanctity, but are not among the
<xex>beatified</xex>, nor the <xex>canonized</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Ven"er*a*ble*ness</wf>, <pos>n.</pos> --
<wf>Ven"er*a*bly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veneracea</ent><br/
\'d8<hw>Ven`e*ra"ce*a</hw> <pr>(?)</pr>, <pos>prop. n. pl.</pos>
<ety>[NL. See <er>Venus</er>.]</ety> <fld>(Zool.)</fld> <def>An
extensive tribe of bivalve mollusks of which the genus <gen>Venus</gen>
is the type. The shells are usually oval, or somewhat heartshaped, with
a conspicuous lunule. See <er>Venus</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venerate</ent><br/
<hw>Ven"er*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Venerated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Venerating</conjf>.]</vmorph> <ety>[L.
<ets>veneratus</ets>, p. p. of <ets>venerari</ets> to venerate; akin to
<ets>Venus</ets> Venus, Skr. <ets>van</ets> to like, to wish, and E.
<ets>win</ets>some. See <er>Winsome</er>.]</ety> <def>To regard with
reverential respect; to honor with mingled respect and awe; to
reverence; to revere; <as>as, we <ex>venerate</ex> parents and
elders</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And seemed to <qex>venerate</qex> the sacred shade.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I do not know a man more to be <qex>venerated</qex> for
uprightness of heart and loftiness of genius.</q> <rj><qau>Sir W.
Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To reverence; revere; adore; respect.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veneration</ent><br/
<hw>Ven`er*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>veneratio</ets>: cf. F. <ets>v<eacute/n<eacute/ration</ets>.]</ety>
<def>The act of venerating, or the state of being venerated; the highest
degree of respect and reverence; respect mingled with awe; a feeling or
sentiment excited by the dignity, wisdom, or superiority of a person, by
sacredness of character, by consecration to sacred services, or by
hallowed associations.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We find a secret awe and <qex>veneration</qex> for one who moves
about us in a regular and illustrious course of virtue.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Awe; reverence; respect. See
<er>Reverence</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venerator</ent><br/
<hw>Ven"er*a`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety>
<def>One who venerates.</def> <rj><au>Jer. Taylor</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venereal</ent><br/
<hw>Ve*ne"re*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>venereus</ets>, <ets>venerius</ets>, fr. <ets>Venus</ets>,
<ets>Veneris</ets>, Venus, the goddess of love. See
<er>Venerate</er>.]</ety> <sn>1.</sn> <def>Of or pertaining to venery,
or sexual love; relating to sexual intercourse.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Into the snare I fell<br/
Of fair, fallacious looks, <qex>venereal</qex> trains,<br/
Softened with pleasure and voluptuous life.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <sd>(a)</sd> <def>Arising from sexual
intercourse; <as>as, a <ex>venereal</ex> disease; <ex>venereal</ex>
virus or poison.</as></def> <sd>(b)</sd> <def>Adapted to the cure of
venereal diseases; <as>as, <ex>venereal</ex> medicines</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Adapted to excite venereal desire;
aphrodisiac.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Consisting of, or pertaining to, copper, formerly
called by chemists <xex>Venus</xex>.</def> <mark>[Obs.]</mark>
<rj><au>Boyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venereal</ent><br/
<hw>Ve*ne"re*al</hw>, <pos>n.</pos> <fld>(Med.)</fld> <def>The venereal
disease; syphilis.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venerean</ent><br/
<hw>Ve*ne"re*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>v<eacute/n<eacute/rien</ets>.]</ety> <def>Devoted to the offices of
Venus, or love; venereal.</def> <mark>[Obs.]</mark> <ldquo/I am all
<xex>venerean</xex> in feeling.<rdquo/ <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venereous</ent><br/
<hw>Ve*ne"re*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>venereus</ets>.]</ety> <sn>1.</sn> <def>Venereal; exciting lust;
aphrodisiac.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Lustful; lascivious; libidinous.</def>
<mark>[R.]</mark> <rj><au>Derham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venerous</ent><br/
<hw>Ven"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Venereous.</def>
<mark>[Obs.]</mark> <rj><au>Burton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venery</ent><br/
<hw>Ven"er*y</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>Venus</ets>,
<ets>Veneris</ets>, the goddess of love.]</ety> <def>Sexual love; sexual
intercourse; coition.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Contentment, without the pleasure of lawful <qex>venery</qex>, is
continence; of unlawful, chastity.</q> <rj><qau>Grew.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venery</ent><br/
<hw>Ven"er*y</hw>, <pos>n.</pos> <ety>[OE. <ets>venerie</ets>, F.
<ets>v<eacute/nerie</ets>, fr. OF. <ets>vener</ets> to hunt, L.
<ets>venari</ets>. See <er>Venison</er>.]</ety> <def>The art, act, or
practice of hunting; the sports of the chase.</def> <ldquo/Beasts of
<xex>venery</xex> and fishes.<rdquo/ <rj><au>Sir T.
Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I love hunting and <qex>venery</qex>.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venesection</ent><br/
<hw>Ve`ne*sec"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.
<ets>venaesectio</ets>; L. <ets>vena</ets> vein + <ets>sectio</ets>
section.]</ety> <fld>(Med.)</fld> <def>The act or operation of opening a
vein for letting blood; bloodletting; phlebotomy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venetian</ent><br/
<hw>Ve*ne"tian</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. It.
<ets>Veneziano</ets>, L. <ets>Venetianus</ets>.]</ety> <def>Of or
pertaining to Venice in Italy.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Venetian blind</b></col>, <cd>a blind for windows, doors,
etc., made of thin slats, either fixed at a certain angle in the
shutter, or movable, and in the latter case so disposed as to overlap
each other when closed, and to show a series of open spaces for the
admission of air and light when in other positions.</cd> --
<col><b>Venetian carpet</b></col>, <cd>an inexpensive carpet, used for
passages and stairs, having a woolen warp which conceals the weft; the
pattern is therefore commonly made up of simple stripes.</cd> --
<col><b>Venetian chalk</b></col>, <cd>a white compact talc or steatite,
used for marking on cloth, etc.</cd> -- <col><b>Venetian door</b></col>
<fld>(Arch.)</fld>, <cd>a door having long, narrow windows or panes of
glass on the sides.</cd> -- <col><b>Venetian glass</b></col>, <cd>a kind
of glass made by the Venetians, for decorative purposes, by the
combination of pieces of glass of different colors fused together and
wrought into various ornamental patterns.</cd> -- <col><b>Venetian
red</b></col>, <cd>a brownish red color, prepared from sulphate of iron;
-- called also <altname>scarlet ocher</altname>.</cd> --
<col><b>Venetian soap</b></col>. <cd>See <cref>Castile soap</cref>,
under <er>Soap</er>.</cd> -- <col><b>Venetian sumac</b></col>
<fld>(Bot.)</fld>, <cd>a South European tree (<spn>Rhus Cotinus</spn>)
which yields the yellow dyewood called <prod>fustet</prod>; -- also
called <altname>smoke tree</altname>.</cd> -- <col><b>Venetian
window</b></col> <fld>(Arch.)</fld>, <cd>a window consisting of a main
window with an arched head, having on each side a long and narrow window
with a square head.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venetian</ent><br/
<hw>Ve*ne"tian</hw>, <pos>n.</pos> <sn>1.</sn> <def>A native or
inhabitant of Venice.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <pluf>pl.</pluf> <def>Galligaskins.</def>
<mark>[Obs.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn> <def>A Venetian blind.</def> <mark>[Colloq.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Venew</ent><br/
<hw>Ven"ew</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>venue</ets>,
lit., an arrival, from <ets>venir</ets>, p. p. <ets>venu</ets>,
<ets>venue</ets>, to come. See <er>Venue</er>.]</ety> <def>A bout, or
turn, as at fencing; a thrust; a hit; a veney.</def> <mark>[Obs.]</mark>
<rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veney</ent><br/
<hw>Ven"ey</hw> <pr>(?; 277)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Venew</er> or <er>Visne</er>.]</ety> <def>A bout; a thrust; a
venew.</def> <mark>[Obs.]</mark> <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Three <qex>veneys</qex> for a dish of stewed prunes.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venge</ent><br/
<hw>Venge</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[F.
<ets>venger</ets>. See <er>Vengeance</er>.]</ety> <def>To avenge; to
punish; to revenge.</def> <mark>[Obs.]</mark> <see>See <er>Avenge</er>,
and <er>Revenge</er>.</see> <au>Chaucer</au>. <ldquo/To <xex>venge</xex>
me, as I may.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vengeable</ent><br/
<hw>Venge"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Revengeful;
deserving revenge.</def> <mark>[Obs.]</mark> <au>Spenser.</au> --
<wordforms><wf>Venge"a*bly</wf>, <pos>adv.</pos>
<mark>[Obs.]</mark></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vengeance</ent><br/
<hw>Venge"ance</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vengeance</ets>, fr. <ets>venger</ets> to avenge, L.
<ets>vindicare</ets> to lay claim to, defend, avenge, fr.
<ets>vindex</ets> a claimant, defender, avenger, the first part of which
is of uncertain origin, and the last part akin to <ets>dicere</ets> to
say. See <er>Diction</er>, and cf. <er>Avenge</er>, <er>Revenge</er>,
<er>Vindicate</er>.]</ety> <sn>1.</sn> <def>Punishment inflicted in
return for an injury or an offense; retribution; -- often, in a bad
sense, passionate or unrestrained revenge.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To me belongeth <qex>vengeance</qex> and recompense.</q>
<rj><qau>Deut. xxxii. 35.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To execute fierce <qex>vengeance</qex> on his foes.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Harm; mischief.</def> <mark>[Obs.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>What a vengeance</b></col>, <it>or</it>
<col><b>What the vengeance</b></col></mcol>, <cd>what! --
emphatically.</cd> <mark>[Obs.]</mark> <ldquo/But <xex>what a
vengeance</xex> makes thee fly!<rdquo/ <au>Hudibras.</au>
<ldquo/<xex>What the vengeance</xex>! Could he not speak 'em
fair?<rdquo/ <au>Shak.</au> -- <col><b>With a vengeance</b></col>,
<sd>(a)</sd> <cd>with great violence; <as>as, to strike <ex>with a
vengeance</ex></as>.</cd> <mark>[Colloq.]</mark> <sd>(b)</sd> <cd>with
even greater intensity; <as>as, to return one's insult <ex>with a
vengeance</ex></as>.</cd></cs><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><ent>Vengeancely</ent><br/
<hw>Venge"ance*ly</hw>, <pos>adv.</pos> <def>Extremely;
excessively.</def> <mark>[Obs.]</mark> <ldquo/He loves that
<xex>vengeancely</xex>.<rdquo/ <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vengeful</ent><br/
<hw>Venge"ful</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Vindictive;
retributive; revengeful.</def> <ldquo/<xex>Vengeful</xex> ire.<rdquo/
<au>Milton.</au> -- <wordforms><wf>Venge"ful*ly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vengement</ent><br/
<hw>Venge"ment</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF.
<ets>vengement</ets>.]</ety> <def>Avengement; penal retribution;
vengeance.</def> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venger</ent><br/
<hw>Ven"ger</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An avenger.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veniable</ent><br/
<hw>Ve"ni*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>veniabilis</ets>, fr. <ets>venia</ets> forgiveness, pardon.]</ety>
<def>Venial; pardonable.</def> <mark>[Obs.]</mark> <au>Sir T.
Browne.</au> -- <wordforms><wf>Ve"ni*a*bly</wf>, <pos>adv.</pos>
<mark>[Obs.]</mark></wordforms> <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venial</ent><br/
<hw>Ve"ni*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OF.
<ets>venial</ets>, F. <ets>v<eacute/niel</ets>, L. <ets>venialis</ets>,
from <ets>venia</ets> forgiveness, pardon, grace, favor, kindness; akin
to <ets>venerari</ets> to venerate. See <er>Venerate</er>.]</ety>
<sn>1.</sn> <def>Capable of being forgiven; not heinous; excusable;
pardonable; <as>as, a <ex>venial</ex> fault or
transgression</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>So they do nothing, 't is a <qex>venial</qex> slip.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Allowed; permitted.</def> <mark>[Obs.]</mark>
<ldquo/Permitting him the while <xex>venial</xex> discourse
unblamed.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Venial sin</b></col> <fld>(R. C. Theol.)</fld>, <cd>a sin
which weakens, but does not wholly destroy, sanctifying grace, as do
mortal, or deadly, sins.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Ve"ni*al*ly</wf>, <pos>adv.</pos> --
<wf>Ve"ni*al*ness</wf>, <pos>n.</pos></wordforms> <rj><au>Bp.
Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veniality</ent><br/
<hw>Ve`ni*al"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being venial; venialness.</def> <rj><au>Jer.
Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venin</ent><br/
<hw>Ven"in</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>venenum</ets>
poison.]</ety> <fld>(Physiol. Chem.)</fld> <def>A toxic substance
contained in the venom of poisonous snakes; also, a (supposedly
identical) toxic substance obtained by the cleavage of an
albumose.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Venire facias</ent><br/
\'d8<hw>Ve*ni"re fa"ci*as</hw> <pr>(?)</pr>. <ety>[L., make, or cause,
to come.]</ety> <fld>(Law)</fld> <sd>(a)</sd> <def>A judicial writ or
precept directed to the sheriff, requiring him to cause a certain number
of qualified persons to appear in court at a specified time, to serve as
jurors in said court.</def> <sd>(b)</sd> <def>A writ in the nature of a
summons to cause the party indicted on a penal statute to appear. Called
also <altname>venire</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venison</ent><br/
<hw>Ven"i*son</hw> <pr>(?; 277)</pr>, <pos>n.</pos> <ety>[OE.
<ets>veneison</ets>, <ets>veneson</ets>, <ets>venison</ets>, OF.
<ets>veneison</ets>, F. <ets>venaison</ets>, L. <ets>venatio</ets>
hunting, the chase, game, fr. <ets>venari</ets>, p. p.
<ets>venatus</ets>, to hunt; perhaps akin to OHG.
<ets>weidin<omac/n</ets>, <ets>weidenen</ets>, to pasture, to hunt, G.
<ets>weide</ets> pasturage. Cf. <er>Gain</er> to acquire,
<er>Venation</er>.]</ety> <sn>1.</sn> <def>Beasts of the chase.</def>
<mark>[Obs.]</mark> <rj><au>Fabyan.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Formerly, the flesh of any of the edible beasts of
the chase, also of game birds; now, the flesh of animals of the deer
kind exclusively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venite</ent><br/
\'d8<hw>Ve*ni"te</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., come,
imperative 2d person pl. So called from its opening word in the Latin
version.]</ety> <fld>(Eccl.)</fld> <def>The 95th Psalm, which is said or
sung regularly in the public worship of many churches. Also, a musical
composition adapted to this Psalm.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venom</ent><br/
<hw>Ven"om</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>venim</ets>,
OF. <ets>venim</ets>, <ets>venin</ets>, F. <ets>venin</ets>, L.
<ets>venenum</ets>. Cf. <er>Venenate</er>.]</ety> <sn>1.</sn>
<def>Matter fatal or injurious to life; poison; particularly, the
poisonous matter which certain animals, such as serpents, scorpions,
bees, etc., secrete in a state of health, and communicate by biting or
stinging.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Or hurtful worm with cankered <qex>venom</qex> bites.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Spite; malice; malignity; evil quality.</def>
<au>Chaucer.</au> <ldquo/The <xex>venom</xex> of such looks.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Venom; virus; bane. See
<er>Poison</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venom</ent><br/
<hw>Ven"om</hw>, <pos>v. t.</pos> <ety>[OE. <ets>venimen</ets>, OF.
<ets>venimer</ets>, L. <ets>venenare</ets>. See <er>Venom</er>,
<pos>n.</pos>]</ety> <def>To infect with venom; to envenom; to
poison.</def> <mark>[R.]</mark> <ldquo/<xex>Venomed</xex>
vengeance.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venomous</ent><br/
<hw>Ven"om*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OE.
<ets>venemous</ets>, <ets>venimous</ets>, F. <ets>venimeux</ets>, L.
<ets>venenosus</ets>, fr. <ets>venenum</ets> poison. See <er>Venom</er>,
and cf. <er>Venenose</er>.]</ety> <sn>1.</sn> <def>Full of venom;
noxious to animal life; poisonous; <as>as, the bite of a serpent may be
<ex>venomous</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>Having a poison gland or glands
for the secretion of venom, as certain serpents and insects.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Noxious; mischievous; malignant; spiteful; <as>as, a
<ex>venomous</ex> progeny; a <ex>venomous</ex> writer</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Venomous snake</b></col> <fld>(Zool.)</fld>, <cd>any
serpent which has poison glands and fangs, whether dangerous to man or
not. These serpents constitute two tribes, the viperine serpents, or
Solenoglypha, and the cobralike serpents, or Proteroglypha. The former
have perforated, erectile fangs situated in the front part of the upper
jaw, and are without ordinary teeth behind the fangs; the latter have
permanently erect and grooved fangs, with ordinary maxillary teeth
behind them.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Ven"om*ous*ly</wf>, <pos>adv.</pos> --
<wf>Ven"om*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venose</ent><br/
<hw>Ve*nose"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Venous</er>.]</ety> <def>Having numerous or conspicuous veins;
veiny; <as>as, a <ex>venose</ex> frond</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venosity</ent><br/
<hw>Ve*nos"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
quality or state of being venous.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <def>A condition in which the
circulation is retarded, and the entire mass of blood is less oxygenated
than it normally is.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venous</ent><br/
<hw>Ven"ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>venosus</ets>, from <ets>vena</ets> a vein. See
<er>Vein</er>.]</ety> <sn>1.</sn> <fld>(Anat.)</fld> <def>Of or
pertaining to a vein or veins; <as>as, the <ex>venous</ex> circulation
of the blood</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Contained in the veins, or having the same qualities
as if contained in the veins, that is, having a dark bluish color and
containing an insufficient amount of oxygen so as no longer to be fit
for oxygenating the tissues; -- said of the blood, and opposed to
<xex>arterial</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Marked with veins; veined; <as>as, a <ex>venous</ex>
leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Venous leaf</b></col> <fld>(Bot.)</fld>, <cd>a leaf
having vessels branching, or variously divided, over its surface.</cd>
-- <col><b>Venous hum</b></col> <fld>(Med.)</fld>, <cd>a humming sound,
or bruit, heard during auscultation of the veins of the neck in
anaemia.</cd> -- <col><b>Venous pulse</b></col> <fld>(Physiol.)</fld>,
<cd>the pulse, or rhythmic contraction, sometimes seen in a vein, as in
the neck, when there is an obstruction to the passage of blood from the
auricles to the ventricles, or when there is an abnormal rigidity in the
walls of the greater vessels. There is normally no pulse in a
vein.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vent</ent><br/
<hw>Vent</hw> <pr>(v<ecr/nt)</pr>, <pos>n.</pos> <ety>[F.
<ets>vente</ets>, fr. L. <ets>vendere</ets>, <ets>-itum</ets>, to sell;
perh. confused with E. <ets>vent</ets> an opening. See
<er>Vend</er>.]</ety> <def>Sale; opportunity to sell; market.</def>
<mark>[Obs.]</mark> <rj><au>Shelton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>There is no <qex>vent</qex> for any commodity but of wool.</q>
<rj><qau>Sir W. Temple.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vent</ent><br/
<hw>Vent</hw>, <pos>v. t.</pos> <def>To sell; to vend.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Therefore did those nations <qex>vent</qex> such spice.</q>
<rj><qau>Sir W. Raleigh.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vent</ent><br/
<hw>Vent</hw>, <pos>n.</pos> <ety>[Sp. <ets>venta</ets> a poor inn,
sale, market. See <er>Vent</er> sale.]</ety> <def>A baiting place; an
inn.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vent</ent><br/
<hw>Vent</hw>, <pos>v. i.</pos> <ety>[Cf. F. <ets>venter</ets> to blow,
<ets>vent</ets> wind (see <er>Ventilate</er>); but prob influenced by E.
<ets>vent</ets> an opening.]</ety> <def>To snuff; to breathe or puff
out; to snort.</def> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vent</ent><br/
<hw>Vent</hw> <pr>(v<ecr/nt)</pr>, <pos>n.</pos> <ety>[OE.
<ets>fent</ets>, <ets>fente</ets>, a slit, F. <ets>fente</ets> a slit,
cleft, fissure, from <ets>fendre</ets> to split, L. <ets>findere</ets>;
but probably confused with F. <ets>vent</ets> wind, L.
<ets>ventus</ets>. See <er>Fissure</er>, and cf. <ets>Vent</ets> to
snuff.]</ety> <sn>1.</sn> <def>A small aperture; a hole or passage for
air or any fluid to escape; <as>as, the <ex>vent</ex> of a cask; the
<ex>vent</ex> of a mold; a volcanic <ex>vent</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Look, how thy wounds do bleed at many <qex>vents</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Long 't was doubtful, both so closely pent,<br/
Which first should issue from the narrow <qex>vent</qex>.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <fld>(Zool.)</fld> <def>The anal opening of certain
invertebrates and fishes; also, the external cloacal opening of
reptiles, birds, amphibians, and many fishes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <fld>(Gun.)</fld> <def>The opening at the breech of a
firearm, through which fire is communicated to the powder of the charge;
touchhole.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <fld>(Steam Boilers)</fld> <def>Sectional area of the
passage for gases divided by the length of the same passage in
feet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Fig.: Opportunity of escape or passage from
confinement or privacy; outlet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Emission; escape; passage to notice or expression;
publication; utterance.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Without the <qex>vent</qex> of words.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou didst make tolerable <qex>vent</qex> of thy travel.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To give vent to</b></col>, <cd>to suffer to escape; to
let out; to pour forth; as, <xex>to give vent to</xex> anger.</cd> --
<col><b>To take vent</b></col>, <cd>to escape; to be made public.</cd>
<mark>[R.]</mark> -- <col><b>Vent feather</b></col> <fld>(Zool.)</fld>,
<cd>one of the anal, or crissal, feathers of a bird.</cd> --
<col><b>Vent field</b></col> <fld>(Gun.)</fld>, <cd>a flat raised
surface around a vent.</cd> -- <col><b>Vent piece</b></col>.
<fld>(Gun.)</fld> <sd>(a)</sd> <cd>A bush. See 4th <er>Bush</er>,
<pos>n.</pos>, 2.</cd> <sd>(b)</sd> <cd>A breech block.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vent</ent><br/
<hw>Vent</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Vented</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Venting</conjf>.]</vmorph> <sn>1.</sn> <def>To let out at a vent,
or small aperture; to give passage or outlet to.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To suffer to escape from confinement; to let out; to
utter; to pour forth; <as>as, to <ex>vent</ex> passion or
complaint</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The queen of heaven did thus her fury <qex>vent</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To utter; to report; to publish.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>By mixing somewhat true to <qex>vent</qex> more lies.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou hast framed and <qex>vented</qex> very curious orations.</q>
<rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To scent, as a hound.</def> <mark>[Obs.]</mark>
<rj><au>Turbervile.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To furnish with a vent; to make a vent in; <as>as,
to <ex>vent</ex></as>. a mold.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1601 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventage</ent><br/
<hw>Vent"age</hw> <pr>(v<ecr/nt"<asl/j)</pr>, <pos>n.</pos> <def>A small
hole, as the stop in a flute; a vent.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventail</ent><br/
<hw>Vent"ail</hw> <pr>(v<ecr/nt"<amac/l)</pr>, <pos>n.</pos> <ety>[OF.
<ets>ventaille</ets>, F. <ets>ventail</ets>. See <er>Ventilate</er>, and
cf. <er>Aventail</er>.]</ety> <def>That part of a helmet which is
intended for the admission of air, -- sometimes in the visor.</def>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Her <qex>ventail</qex> up so high that he descried<br/
Her goodly visage and her beauty's pride.</q>
<rj><qau>Fairfax.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venter</ent><br/
<hw>Vent"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who vents; one who
utters, reports, or publishes.</def> <mark>[R.]</mark>
<rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venter</ent><br/
\'d8<hw>Vent"er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety>
<sn>1.</sn> <fld>(Anat.)</fld> <sd>(a)</sd> <def>The belly; the abdomen;
-- sometimes applied to any large cavity containing viscera.</def>
<sd>(b)</sd> <def>The uterus, or womb.</def> <sd>(c)</sd> <def>A belly,
or protuberant part; a broad surface; <as>as, the <ex>venter</ex> of a
muscle; the <ex>venter</ex>, or anterior surface, of the
scapula.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The lower part of the abdomen in
insects.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Rom. & O. E. Law)</fld> <def>A pregnant woman; a
mother; <as>as, A has a son B by one <ex>venter</ex>, and a daughter C
by another <ex>venter</ex>; children by different
<ex>venters</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venthole</ent><br/
<hw>Vent"hole</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A touchhole; a
vent.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventiduct</ent><br/
<hw>Ven"ti*duct</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>ventus</ets> wind + <ets>ductus</ets> a leading, conduit, fr.
<ets>ducere</ets>, <ets>ductum</ets>, to lead.]</ety> <def>A passage for
wind or air; a passage or pipe for ventilating apartments.</def>
<rj><au>Gwilt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventilate</ent><br/
<hw>Ven"ti*late</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Ventilated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Ventilating</conjf>.]</vmorph> <ety>[L.
<ets>ventilatus</ets>, p. p. of <ets>ventilare</ets> to toss, brandish
in the air, to fan, to winnow, from <ets>ventus</ets> wind; akin to E.
<ets>wind</ets>. See <er>Wind</er> rushing air.]</ety> <sn>1.</sn>
<def>To open and expose to the free passage of air; to supply with fresh
air, and remove impure air from; to air; <as>as, to <ex>ventilate</ex> a
room; to <ex>ventilate</ex> a cellar; to <ex>ventilate</ex> a
mine.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To provide with a vent, or escape, for air, gas,
etc.; <as>as, to <ex>ventilate</ex> a mold, or a water-wheel
bucket</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To change or renew, as the air of a room.</def>
<rj><au>Harvey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To winnow; to fan; <as>as, to <ex>ventilate</ex>
wheat</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To sift and examine; to bring out, and subject to
penetrating scrutiny; to expose to examination and discussion; <as>as,
to <ex>ventilate</ex> questions of policy</as>.</def>
<rj><au>Ayliffe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To give vent to; to utter; to make public.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Macaulay took occasion to <qex>ventilate</qex> one of those
startling, but not very profound, paradoxes.</q> <rj><qau>J. C.
Shairp.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventilation</ent><br/
<hw>Ven`ti*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>ventilatio</ets>: cf. F. <ets>ventilation</ets>.]</ety> <sn>1.</sn>
<def>The act of ventilating, or the state of being ventilated; the art
or process of replacing foul air by that which is pure, in any inclosed
place, as a house, a church, a mine, etc.; free exposure to
air.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Insuring, for the laboring man, better <qex>ventilation</qex>.</q>
<rj><qau>F. W. Robertson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The act of refrigerating, or cooling; refrigeration;
<as>as, <ex>ventilation</ex> of the blood</as>.</def>
<mark>[Obs.]</mark> <rj><au>Harvey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The act of fanning, or winnowing, for the purpose of
separating chaff and dust from the grain.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The act of sifting, and bringing out to view or
examination; free discussion; public exposure.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>ventilation</qex> of these points diffused them to the
knowledge of the world.</q> <rj><qau>Bp. Hall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The act of giving vent or expression.</def>
<ldquo/<xex>Ventilation</xex> of his thoughts.<rdquo/ <rj><au>Sir H.
Wotton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventilative</ent><br/
<hw>Ven"ti*la*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or
pertaining to ventilation; adapted to secure ventilation; ventilating;
<as>as, <ex>ventilative</ex> apparatus</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventilator</ent><br/
<hw>Ven"ti*la`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>ventilateur</ets>, L. <ets>ventilator</ets> a winnower.]</ety>
<def>A contrivance for effecting ventilation; especially, a contrivance
or machine for drawing off or expelling foul or stagnant air from any
place or apartment, or for introducing that which is fresh and
pure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventose</ent><br/
<hw>Ven*tose"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A ventouse.</def>
<mark>[Obs.]</mark> <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventose</ent><br/
<hw>Ven*tose"</hw>, <pos>a.</pos> <ety>[L. <ets>ventosus</ets> windy.
See <er>Ventilate</er>.]</ety> <def>Windy; flatulent.</def>
<rj><au>Richardson (Dict.).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventose</ent><br/
\'d8<hw>Ven`tose"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vent<ocir/se</ets>. See <er>Ventose</er>, <pos>a.</pos>]</ety>
<def>The sixth month of the calendar adopted by the first French
republic. It began February 19, and ended March 20. See
<er>Vend<eacute/miaire</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventosity</ent><br/
<hw>Ven*tos"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>ventositas</ets>: cf. F. <ets>ventosit<eacute/</ets>. See
<er>Ventose</er>, <pos>n.</pos>]</ety> <def>Quality or state of being
ventose; windiness; hence, vainglory; pride.</def>
<rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventouse</ent><br/
<hw>Ven"touse</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A
cupping glass.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventouse</ent><br/
<hw>Ven"touse</hw>, <pos>v. t. & i.</pos> <def>To cup; to use a cupping
glass.</def> <mark>[Obs.]</mark> <altsp>[Written also
<asp>ventuse</asp>.]</altsp> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventrad</ent><br/
<hw>Ven"trad</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[L.
<ets>venter</ets> belly + <ets>ad</ets> to.]</ety> <fld>(Anat.)</fld>
<def>Toward the ventral side; on the ventral side; ventrally; -- opposed
to <xex>dorsad</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventral</ent><br/
<hw>Ven"tral</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>ventralis</ets>, fr. <ets>venter</ets> the belly; perhaps akin to
G. <ets>wanst</ets>: cf. F. <ets>ventral</ets>.]</ety> <sn>1.</sn>
<fld>(Anat.)</fld> <def>Of, pertaining to, or situated near, the belly,
or ventral side, of an animal or of one of its parts; hemal; abdominal;
<as>as, the <ex>ventral</ex> fin of a fish; the <ex>ventral</ex> root of
a spinal nerve</as>; -- opposed to <ant>dorsal</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <sd>(a)</sd> <def>Of or pertaining to
that surface of a carpel, petal, etc., which faces toward the center of
a flower.</def> <sd>(b)</sd> <def>Of or pertaining to the lower side or
surface of a creeping moss or other low flowerless plant. Opposed to
<ant>dorsal</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ventral fins</b></col> <fld>(Zool.)</fld>, <cd>the
posterior pair of fins of a fish. They are often situated beneath the
belly, but sometimes beneath the throat.</cd> -- <col><b>Ventral
segment</b></col>. <fld>(Acoustics)</fld> <cd>See <er>Loop</er>,
<pos>n.</pos>, 5.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventricle</ent><br/
<hw>Ven"tri*cle</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>ventriculus</ets> the stomach, a ventricle, dim. of
<ets>venter</ets> the belly: cf. F. <ets>ventricule</ets>. See
<er>Ventral</er>.]</ety> <sn>1.</sn> <fld>(Anat.)</fld> <def>A cavity,
or one of the cavities, of an organ, as of the larynx or the brain;
specifically, the posterior chamber, or one of the two posterior
chambers, of the heart, which receives the blood from the auricle and
forces it out from the heart. See <er>Heart</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The principal ventricles of the brain are the
<xex>fourth</xex> in the medulla, the <xex>third</xex> in the midbrain,
the <xex>first</xex> and <xex>second</xex>, or <xex>lateral</xex>,
ventricles in the cerebral hemispheres, all of which are connected with
each other, and the <xex>fifth</xex>, or <xex>pseudoc<oe/le</xex>,
situated between the hemispheres, in front of, or above, the fornix, and
entirely disconnected with the other cavities. See <er>Brain</er>, and
<er>C<oe/lia</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The stomach.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Whether I will or not, while I live, my heart beats, and my
<qex>ventricle</qex> digests what is in it.</q> <rj><qau>Sir M.
Hale.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Fig.: Any cavity, or hollow place, in which any
function may be conceived of as operating.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>These [ideas] are begot on the <qex>ventricle</qex> of memory.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventricous</ent><br/
<ent>Ventricose</ent><br/
<mhw>{ <hw>Ven"tri*cose`</hw> <pr>(?)</pr>, <hw>Ven"tri*cous</hw>
<pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[NL. <ets>ventricosus</ets>,
fr. L. <ets>venter</ets> belly.]</ety> <fld>(Nat. Hist.)</fld>
<def>Swelling out on one side or unequally; bellied; ventricular;
<as>as, a <ex>ventricose</ex> corolla</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ventricose shell</b></col>. <fld>(Zool.)</fld>
<sd>(a)</sd> <cd>A spiral shell having the body whorls rounded or
swollen in the middle.</cd> <sd>(b)</sd> <cd>A bivalve shell in which
the valves are strongly convex.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventricular</ent><br/
<hw>Ven*tric"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>ventriculaire</ets>.]</ety> <def>Of or pertaining to a ventricle;
bellied.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventriculite</ent><br/
\'d8<hw>Ven*tric"u*lite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Ventriculus</er>.]</ety> <fld>(Paleon.)</fld> <def>Any one of
numerous species of siliceous fossil sponges belonging to
<gen>Ventriculites</gen> and allied genera, characteristic of the
Cretaceous period.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Many of them were shaped like vases, others like
mushrooms. They belong to the hexactinellids, and are allied to the
Venus's basket of modern seas.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventriculous</ent><br/
<hw>Ven*tric"u*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>ventriculosus</ets> of the belly.]</ety> <def>Somewhat distended in
the middle; ventricular.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventriculus</ent><br/
\'d8<hw>Ven*tric"u*lus</hw> <pr>(?)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Ventriculi</plw> <pr>(#)</pr>.</plu> <ety>[L.,
belly, dim. fr. <ets>venter</ets> belly.]</ety> <fld>(Zool.)</fld>
<sd>(a)</sd> <def>One of the stomachs of certain insects.</def>
<sd>(b)</sd> <def>The body cavity of a sponge.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventrilocution</ent><br/
<hw>Ven`tri*lo*cu"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Ventriloquous</er>.]</ety> <def>Ventriloquism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventriloquial</ent><br/
<hw>Ven`tri*lo"qui*al</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Ventriloquous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventriloquism</ent><br/
<hw>Ven*tril"o*quism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Ventriloquous</er>.]</ety> <def>The act, art, or practice of
speaking in such a manner that the voice appears to come, not from the
person speaking, but from some other source, as from a dummy held by the
ventriloquist, from the opposite side of the room, from the cellar,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventriloquist</ent><br/
<hw>Ven*tril"o*quist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who
practices, or is skilled in, ventriloquism.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ventriloquist monkey</b></col> <fld>(Zool.)</fld>,
<cd>the onappo; -- so called from the character of its
cry.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventriloquize</ent><br/
<hw>Ven*tril"o*quize</hw> <pr>(?)</pr>, <pos>v. i.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Ventriloquized</conjf>
<pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Ventriloquizing</conjf>.]</vmorph> <def>To practice
ventriloquism; to speak like a ventriloquist.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventriloquous</ent><br/
<hw>Ven*tril"o*quous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>ventriloquus</ets> a ventriloquist; <ets>venter</ets> the belly +
<ets>loqui</ets>, p. p. <ets>locutus</ets>, to speak. See
<er>Ventral</er>, and <er>Loquacious</er>.]</ety> <def>Of or pertaining
to a ventriloquist or ventriloquism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventriloquy</ent><br/
<hw>Ven*tril"o*quy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>ventriloquie</ets>.]</ety> <def>Same as
<er>Ventriloquism</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventrimeson</ent><br/
\'d8<hw>Ven`tri*mes"on</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See
<er>Venter</er>, and <er>Meson</er>.]</ety> <fld>(Anat.)</fld> <def>See
<er>Meson</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventro-</ent><br/
<hw>Ven"tro-</hw> <pr>(<?/)</pr>. <ety>[L. <ets>venter</ets>
belly.]</ety> <def>A combining form used in anatomy to indicate
<xex>connection with</xex>, or <xex>relation to</xex>, <xex>the
abdomen</xex>; also, <xex>connection with</xex>, <xex>relation to</xex>,
or <xex>direction toward</xex>, <xex>the ventral side</xex>; <as>as,
<ex>ventro</ex>lateral; <ex>ventro</ex>-inguinal.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventro-inguinal</ent><br/
<hw>Ven`tro-in"gui*nal</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Anat.)</fld> <def>Pertaining both to the abdomen and groin, or to
the abdomen and inguinal canal; <as>as, <ex>ventro-inguinal</ex>
hernia</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venture</ent><br/
<hw>Ven"ture</hw> <pr>(?; 135)</pr>, <pos>n.</pos> <ety>[Aphetic form of
OE. <ets>aventure</ets>. See <er>Adventure</er>.]</ety> <sn>1.</sn>
<def>An undertaking of chance or danger; the risking of something upon
an event which can not be foreseen with certainty; a hazard; a risk; a
speculation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I, in this <qex>venture</qex>, double gains pursue.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An event that is not, or can not be, foreseen; an
accident; chance; hap; contingency; luck.</def>
<rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The thing put to hazard; a stake; a risk;
especially, something sent to sea in trade.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>My <qex>ventures</qex> are not in one bottom trusted.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>At a venture</b></col>, <cd>at hazard; without seeing the
end or mark; without foreseeing the issue; at random.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>A certain man drew a bow <qex>at a venture</qex>.</q> <rj><qau>1
Kings xxii. 34.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A bargain <qex>at a venture</qex> made.</q>
<rj><qau>Hudibras.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The phrase <xex>at a venture</xex> was originally
<xex>at aventure</xex>, that is, <xex>at adventure</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venture</ent><br/
<hw>Ven"ture</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Ventured</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Venturing</conjf>.]</vmorph> <sn>1.</sn> <def>To hazard one's
self; to have the courage or presumption to do, undertake, or say
something; to dare.</def> <rj><au>Bunyan.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To make a venture; to run a hazard or risk; to take
the chances.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Who freights a ship to <qex>venture</qex> on the seas.</q>
<rj><qau>J. Dryden, Jr.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>To venture at</b></col>, <it>or</it> <col><b>To
venture on</b></col> <it>or</it> <col><b>To venture
upon</b></col></mcol>, <cd>to dare to engage in; to attempt without any
certainty of success; <as>as, it is rash <ex>to venture upon</ex> such a
project</as>.</cd> <ldquo/When I <xex>venture at</xex> the comic
style.<rdquo/ <rj><au>Waller.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venture</ent><br/
<hw>Ven"ture</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To expose to
hazard; to risk; to hazard; <as>as, to <ex>venture</ex> one's person in
a balloon</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I am afraid; and yet I'll <qex>venture</qex> it.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To put or send on a venture or chance; <as>as, to
<ex>venture</ex> a horse to the West Indies</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To confide in; to rely on; to trust.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q> A man would be well enough pleased to buy silks of one whom he
would not <qex>venture</qex> to feel his pulse.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venturer</ent><br/
<hw>Ven"tur*er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who
ventures, or puts to hazard; an adventurer.</def> <rj><au>Beau. &
Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A strumpet; a prostitute.</def> <mark>[R.]</mark>
<rj><au>J. Webster (1607).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venturesome</ent><br/
<hw>Ven"ture*some</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Inclined to
venture; not loth to run risk or danger; venturous; bold; daring;
adventurous; <as>as, a <ex>venturesome</ex> boy or act</as>.</def> --
<wordforms><wf>Ven"ture*some*ly</wf>, <pos>adv.</pos> --
<wf>Ven"ture*some*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venturine</ent><br/
<hw>Ven"tur*ine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Aventurine</er>.]</ety> <fld>(Japanning)</fld> <def>Gold powder for
covering varnished surfaces.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venturous</ent><br/
<hw>Ven"tur*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Aphetic form of
OE. <ets>aventurous</ets>. See <er>Adventurous</er>, <er>Venture</er>,
<pos>n.</pos>]</ety> <def>Daring; bold; hardy; fearless; venturesome;
adventurous; <as>as, a <ex>venturous</ex> soldier</as>.</def>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>This said, he paused not, but with <qex>venturous</qex> arm<br/
He plucked, he tasted.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Ven"tur*ous*ly</wf>, <pos>adv.</pos> --
<wf>Ven"tur*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ventuse</ent><br/
<hw>Ven"tuse</hw> <pr>(?)</pr>, <pos>v. t. & i.</pos> <def>See
<er>Ventouse</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venue</ent><br/
<hw>Ven"ue</hw> <pr>(v<ecr/n"<usl/)</pr>, <pos>n.</pos> <ety>[F.
<ets>venue</ets> a coming, arrival, fr. <ets>venir</ets> to come, L.
<ets>venire</ets>; hence, in English, the place whither the jury are
summoned to come. See <er>Come</er>, and cf. <er>Venew</er>,
<er>Veney</er>.]</ety> <sn>1.</sn> <fld>(Law)</fld> <def>A neighborhood
or near place; the place or county in which anything is alleged to have
happened; also, the place where an action is laid.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The twelve men who are to try the cause must be of the same
<qex>venue</qex> where the demand is made.</q>
<rj><qau>Blackstone.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In certain cases, the court has power to change the
<xex>venue</xex>, which is to direct the trial to be had in a different
county from that where the <xex>venue</xex> is laid.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A bout; a hit; a turn. See <er>Venew</er>.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To lay a venue</b></col> <fld>(Law)</fld>, <cd>to allege
a place.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venule</ent><br/
<hw>Ven"ule</hw> <pr>(v<ecr/n"<usl/l)</pr>, <pos>n.</pos> <ety>[L.
<ets>venula</ets>, dim. from <ets>vena</ets> vein.]</ety> <def>A small
vein; a veinlet; specifically <fld>(Zool.)</fld>, one of the small
branches of the veins of the wings in insects.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venulose</ent><br/
<hw>Ven"u*lose`</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Full of venules,
or small veins.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venus</ent><br/
<hw>Ve"nus</hw> <pr>(v<emac/"n<ucr/s)</pr>, <pos>n.</pos> <ety>[L.
<ets>Venus</ets>, <ets>-eris</ets>, the goddess of love, the planet
Venus.]</ety> <sn>1.</sn> <fld>(Class. Myth.)</fld> <def>The goddess of
beauty and love, that is, beauty or love deified.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat.)</fld> <def>One of the planets, the second in
order from the sun, its orbit lying between that of Mercury and that of
the Earth, at a mean distance from the sun of about 67,000,000 miles.
Its diameter is 7,700 miles, and its sidereal period 224.7 days. As the
morning star, it was called by the ancients <altname>Lucifer</altname>;
as the evening star, <altname>Hesperus</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Alchem.)</fld> <def>The metal copper; -- probably
so designated from the ancient use of the metal in making mirrors, a
mirror being still the astronomical symbol of the planet Venus.</def>
<mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>Any one of numerous species of
marine bivalve shells of the genus <gen>Venus</gen> or family
<fam>Veneridae</fam>. Many of these shells are large, and ornamented
with beautiful frills; others are smooth, glossy, and handsomely
colored. Some of the larger species, as the round clam, or quahog, are
valued for food.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Venus's basin</b></col> <fld>(Bot.)</fld>, <cd>the wild
teasel; -- so called because the connate leaf bases form a kind of
receptacle for water, which was formerly gathered for use in the toilet.
Also called <altname>Venus's bath</altname>.</cd> -- <col><b>Venus's
basket</b></col> <fld>(Zool.)</fld>, <cd>an elegant, cornucopia-shaped,
hexactinellid sponge (<spn>Euplectella speciosa</spn>) native of the
East Indies. It consists of glassy, transparent, siliceous fibers
interwoven and soldered together so as to form a firm network, and has
long, slender, divergent anchoring fibers at the base by means of which
it stands erect in the soft mud at the bottom of the sea. Called also
<altname>Venus's flower basket</altname>, and <altname>Venus's
purse</altname>.</cd> -- <col><b>Venus's comb</b></col>. <sd>(a)</sd>
<fld>(Bot.)</fld> <cd>Same as <er>Lady's comb</er>.</cd> <sd>(b)</sd>
<fld>(Zool.)</fld> <cd>A species of <gen>Murex</gen> (<spn>Murex
tenuispinus</spn>). It has a long, tubular canal, with a row of long,
slender spines along both of its borders, and rows of similar spines
covering the body of the shell. Called also <altname>Venus's
shell</altname>.</cd> -- <col><b>Venus's fan</b></col>
<fld>(Zool.)</fld>, <cd>a common reticulated, fanshaped gorgonia
(<spn>Gorgonia flabellum</spn>) native of Florida and the West Indies.
When fresh the color is purple or yellow, or a mixture of the two.</cd>
-- <col><b>Venus's flytrap</b></col>. <fld>(Bot.)</fld> <cd>See
<er>Flytrap</er>, 2.</cd> -- <col><b>Venus's girdle</b></col>
<fld>(Zool.)</fld>, <cd>a long, flat, ribbonlike, very delicate,
transparent and iridescent ctenophore (<spn>Cestum Veneris</spn>) which
swims in the open sea. Its form is due to the enormous development of
two spheromeres. See <xex>Illust.</xex> in Appendix.</cd> --
<col><b>Venus's hair</b></col> <fld>(Bot.)</fld>, <cd>a delicate and
graceful fern (<spn>Adiantum Capillus-Veneris</spn>) having a slender,
black and shining stem and branches.</cd> -- <col><b>Venus's hair
stone</b></col> <fld>(Min.)</fld>, <cd>quartz penetrated by acicular
crystals of rutile.</cd> -- <col><b>Venus's looking-glass</b></col>
<fld>(Bot.)</fld>, <cd>an annual plant of the genus
<gen>Specularia</gen> allied to the bellflower; -- also called
<altname>lady's looking-glass</altname>.</cd> -- <col><b>Venus's
navelwort</b></col> <fld>(Bot.)</fld>, <cd>any one of several species of
<gen>Omphalodes</gen>, low boraginaceous herbs with small blue or white
flowers.</cd> -- <col><b>Venus's pride</b></col> <fld>(Bot.)</fld>,
<cd>an old name for Quaker ladies. See under <er>Quaker</er>.</cd> --
<col><b>Venus's purse</b></col>. <fld>(Zool.)</fld> <cd>Same as
<cref>Venus's basket</cref>, above.</cd> -- <col><b>Venus's
shell</b></col>. <fld>(Zool.)</fld> <sd>(a)</sd> <cd>Any species of
Cypraea; a cowrie.</cd> <sd>(b)</sd> <cd>Same as <cref>Venus's
comb</cref>, above.</cd> <sd>(c)</sd> <cd>Same as <er>Venus</er>,
4.</cd> -- <col><b>Venus's slipper</b></col>. <sd>(a)</sd>
<fld>(Bot.)</fld> <cd>Any plant of the genus <gen>Cypripedium</gen>. See
<er>Lady's slipper</er>. <sd>(b)</sd> <fld>(Zool.)</fld> Any heteropod
shell of the genus <gen>Carinaria</gen>. See
<er>Carinaria</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1602 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Venust</ent><br/
<hw>Ve*nust"</hw> <pr>(v<esl/*n<ucr/st")</pr>, <pos>a.</pos> <ety>[L.
<ets>venustus</ets>, from <ets>Venus</ets> the goddess of love.]</ety>
<def>Beautiful.</def> <mark>[R.]</mark> <rj><au>E.
Waterhouse.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veracious</ent><br/
<hw>Ve*ra"cious</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>verax</ets>, <ets>-acis</ets>, fr. <ets>verus</ets> true. See
<er>Very</er>.]</ety> <sn>1.</sn> <def>Observant of truth; habitually
speaking truth; truthful; <as>as, <ex>veracious</ex>
historian</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Spirit is most perfectly and absolutely
<qex>veracious</qex>.</q> <rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Characterized by truth; true; not false; <as>as, a
<ex>veracious</ex> account or narrative</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The young, ardent soul that enters on this world with heroic
purpose, with <qex>veracious</qex> insight, will find it a mad one.</q>
<rj><qau>Carlyle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veraciously</ent><br/
<hw>Ve*ra"cious*ly</hw>, <pos>adv.</pos> <def>In a veracious
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veracity</ent><br/
<hw>Ve*rac"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>v<eacute/racit<eacute/</ets>.]</ety> <def>The quality or state of
being veracious; habitual observance of truth; truthfulness; truth;
<as>as, a man of <ex>veracity</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veranda</ent><br/
<hw>Ve*ran"da</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[A word brought by
the English from India; of uncertain origin; cf. Skr.
<ets>vara<nsdot/<dsdot/a</ets>, Pg. <ets>varanda</ets>, Sp.
<ets>baranda</ets>, Malay <ets>baranda</ets>.]</ety> <fld>(Arch.)</fld>
<def>An open, roofed gallery or portico, adjoining a dwelling house,
forming an out-of-door sitting room. See <er>Loggia</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The house was of adobe, low, with a wide <qex>veranda</qex> on the
three sides of the inner court.</q> <rj><qau>Mrs. H. H.
Jackson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veratralbine</ent><br/
<hw>Ver`a*tral"bine</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A yellowish amorphous alkaloid extracted from the rootstock of
<xex>Veratrum album</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veratrate</ent><br/
<hw>Ve*ra"trate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A salt of veratric acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veratria</ent><br/
\'d8<hw>Ve*ra"tri*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.]</ety>
<fld>(Chem.)</fld> <def>Veratrine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veratric</ent><br/
<hw>Ve*ra"tric</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld>
<def>Pertaining to, or derived from, plants of the genus
Veratrum.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Veratric acid</b></col> <fld>(Chem.)</fld>, <cd>an acid
occurring, together with veratrine, in the root of white hellebore
(<spn>Veratrum album</spn>), and in sabadilla seed; -- extracted as a
white crystalline substance which is related to protocatechuic
acid.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veratrina</ent><br/
\'d8<hw>Ver`a*tri"na</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.]</ety>
<fld>(Chem.)</fld> <def>Same as <er>Veratrine</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veratrine</ent><br/
<hw>Ve*ra"trine</hw> <pr>(?; 277)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>v<eacute/ratrine</ets>. See <er>Veratrum</er>.]</ety>
<fld>(Chem.)</fld> <def>A poisonous alkaloid obtained from the root of
hellebore (<gen>Veratrum</gen>) and from sabadilla seeds as a white
crystalline powder, having an acrid, burning taste. It is sometimes used
externally, as in ointments, in the local treatment of neuralgia and
rheumatism. Called also <altname>veratria</altname>, and
<altname>veratrina</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veratrol</ent><br/
<hw>Ve*ra"trol</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Veratric</ets> + <ets>ol</ets>.]</ety> <fld>(Chem.)</fld>
<def>A liquid hydrocarbon obtained by the decomposition of veratric
acid, and constituting the dimethyl ether of pyrocatechin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veratrum</ent><br/
\'d8<hw>Ve*ra"trum</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <ety>[L.
<ets>veratrum</ets> hellebore.]</ety> <fld>(Bot.)</fld> <def>A genus of
coarse liliaceous herbs having very poisonous qualities.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Veratrum album</xex> of Europe, and <xex>Veratrum
viride</xex> of America, are both called <xex>hellebore</xex>. They grow
in wet land, have large, elliptical, plicate leaves in three vertical
ranks, and bear panicles of greenish flowers.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verb</ent><br/
<hw>Verb</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>verbe</ets>, L.
<ets>verbum</ets> a word, verb. See <er>Word</er>.]</ety> <sn>1.</sn>
<def>A word; a vocable.</def> <mark>[Obs.]</mark>
<rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Gram.)</fld> <def>A word which affirms or
predicates something of some person or thing; a part of speech
expressing being, action, or the suffering of action.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A verb is a word whereby the chief action of the mind
[the assertion or the denial of a proposition] finds expression.
<rj><au>Earle.</au></rj> </note><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Active verb</b></col>, <col><b>Auxiliary
verb</b></col>, <col><b>Neuter verb</b></col></mcol>, <cd>etc. See
<er>Active</er>, <er>Auxiliary</er>, <er>Neuter</er>, etc.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbal</ent><br/
<hw>Ver"bal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F., fr. L.
<ets>verbalis</ets>. See <er>Verb</er>.]</ety> <sn>1.</sn>
<def>Expressed in words, whether spoken or written, but commonly in
spoken words; hence, spoken; oral; not written; <as>as, a
<ex>verbal</ex> contract; <ex>verbal</ex> testimony.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Made she no <qex>verbal</qex> question?</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>We subjoin an engraving . . . which will give the reader a far
better notion of the structure than any <qex>verbal</qex> description
could convey to the mind.</q> <rj><qau>Mayhew.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Consisting in, or having to do with, words only;
dealing with words rather than with the ideas intended to be conveyed;
<as>as, a <ex>verbal</ex> critic; a <ex>verbal</ex>
change</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And loses, though but <qex>verbal</qex>, his reward.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Mere <qex>verbal</qex> refinements, instead of substantial
knowledge.</q> <rj><qau>Whewell.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Having word answering to word; word for word;
literal; <as>as, a <ex>verbal</ex> translation</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Abounding with words; verbose.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Gram.)</fld> <def>Of or pertaining to a verb;
<as>as, a <ex>verbal</ex> group</as>; derived directly from a verb;
<as>as, a <ex>verbal</ex> noun</as>; used in forming verbs; <as>as, a
<ex>verbal</ex> prefix</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Verbal inspiration</b></col>. <cd>See under
<er>Inspiration</er>.</cd> -- <col><b>Verbal noun</b></col>
<fld>(Gram.)</fld>, <cd>a noun derived directly from a verb or verb
stem; a verbal. The term is specifically applied to infinitives, and
nouns ending in <xex>-ing</xex>, esp. to the latter. See
<er>Gerund</er>, and <er>-ing</er>, 2. See also, <cref>Infinitive
mood</cref>, under <er>Infinitive</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbal</ent><br/
<hw>Ver"bal</hw>, <pos>n.</pos> <fld>(Gram.)</fld> <def>A noun derived
from a verb.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbalism</ent><br/
<hw>Ver"bal*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Something
expressed verbally; a verbal remark or expression.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbalist</ent><br/
<hw>Ver"bal*ist</hw>, <pos>n.</pos> <def>A literal adherent to, or a
minute critic of, words; a literalist.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbality</ent><br/
<hw>Ver*bal"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being verbal; mere words; bare literal expression.</def>
<mark>[R.]</mark> <ldquo/More <xex>verbality</xex> than matter.<rdquo/
<rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbalization</ent><br/
<hw>Ver`bal*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of
verbalizing, or the state of being verbalized.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbalize</ent><br/
<hw>Ver"bal*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Verbalized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Verbalizing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[Cf. F.
<ets>verbaliser</ets>.]</ety> <sn>1.</sn> <def>To convert into a verb;
to verbify.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To express in words.</def><br/
[<source>PJC</source>]</p>

<p><ent>Verbalize</ent><br/
<hw>Ver"bal*ize</hw>, <pos>v. i.</pos> <def>To be verbose.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbally</ent><br/
<hw>Ver"bal*ly</hw>, <pos>adv.</pos> <sn>1.</sn> <def>In a verbal
manner; orally.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Word for word; verbatim.</def>
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbarian</ent><br/
<hw>Ver*ba"ri*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to words; verbal.</def> <mark>[R.]</mark>
<rj><au>Coleridge.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbarian</ent><br/
<hw>Ver*ba"ri*an</hw>, <pos>n.</pos> <def>One who coins words; a
neologist.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Southey gives himself free scope as a <qex>verbarian</qex>.</q>
<rj><qau>Fitzed. Hall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbarium</ent><br/
<hw>Ver*ba"ri*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. L.
<ets>verbum</ets> word.]</ety> <def>A game in word making. See
<er>Logomachy</er>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbatim</ent><br/
\'d8<hw>Ver*ba"tim</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[LL., fr. L.
<ets>verbum</ets> word.]</ety> <def>Word for word; in the same words;
verbally; <as>as, to tell a story <ex>verbatim</ex> as another has
related it</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Verbatim et literatim</b></col> <ety>[LL.]</ety>,
<cd>word for word, and letter for letter.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbena</ent><br/
<hw>Ver*be"na</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. See
<er>Vervain</er>.]</ety> <fld>(Bot.)</fld> <def>A genus of herbaceous
plants of which several species are extensively cultivated for the great
beauty of their flowers; vervain.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Verbena, or vervain, was used by the Greeks, the Romans,
and the Druids, in their sacred rites. <rj><au>Brewer.</au></rj>
</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Essence of verbena</b></col>, <col><b>Oil of
verbena</b></col></mcol>, <cd>a perfume prepared from the lemon verbena;
also, a similar perfume properly called <altname>grass oil</altname>.
See <cref>Grass oil</cref>, under <er>Grass</er>.</cd> --
<mcol><col><b>Lemon verbena</b></col>, <it>or</it> <col><b>Sweet
verbena</b></col></mcol>, <cd>a shrubby verbenaceous plant (<spn>Lippia
citriodora</spn>), with narrow leaves which exhale a pleasant, lemonlike
fragrance when crushed.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbenaceous</ent><br/
<hw>Ver`be*na"ceous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Bot.)</fld>
<def>Of or pertaining to a natural order (<ord>Verbenaceae</ord>) of
gamopetalous plants of which Verbena is the type. The order includes
also the black and white mangroves, and many plants noted for medicinal
use or for beauty of bloom.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbenate</ent><br/
<hw>Ver"be*nate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Verbenated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Verbenating</conjf>.]</vmorph> <ety>[L.
<ets>verbenatus</ets> crowned with a wreath of sacred boughs. See
<er>Verbena</er>.]</ety> <def>To strew with verbena, or vervain, as in
ancient sacrifices and rites.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verberate</ent><br/
<hw>Ver"ber*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L.
<ets>verberatus</ets>, p. p. of <ets>verberare</ets> to beat, from
<ets>verber</ets> a lash, a whip.]</ety> <def>To beat; to strike.</def>
<mark>[Obs.]</mark> <ldquo/The sound . . . rebounds again and
<xex>verberates</xex> the skies.<rdquo/ <rj><au>Mir. for
Mag.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verberation</ent><br/
<hw>Ver`ber*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>verberatio</ets>: cf. F. <ets>verb<eacute/ration</ets>.]</ety>
<sn>1.</sn> <def>The act of verberating; a beating or striking.</def>
<rj><au>Arbuthnot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The impulse of a body, which causes sound.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbiage</ent><br/
<hw>Ver"bi*age</hw> <pr>(?; 48)</pr>, <pos>n.</pos> <ety>[F.
<ets>verbiage</ets>, from OF. <ets>verbe</ets> a word. See
<er>Verb</er>.]</ety> <def>The use of many words without necessity, or
with little sense; a superabundance of words; verbosity;
wordiness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Verbiage</qex> may indicate observation, but not
thinking.</q> <rj><qau>W. Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>This barren <qex>verbiage</qex> current among men.</q>
<rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbify</ent><br/
<hw>Verb"i*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[<ets>Verb</ets>
+ <ets>-fy</ets>.]</ety> <def>To make into a verb; to use as a verb; to
verbalize.</def> <mark>[R.]</mark> <rj><au>Earle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbigerate</ent><br/
<hw>Ver*big"er*ate</hw> <pr>(?)</pr>, <pos>v. i.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>verbigerated</conjf>
<pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>verbigerating</conjf>
<pr>(?)</pr>.]</vmorph> <ety>[L. <ets>verbigerate</ets>,
<ets>-atum</ets>, to talk.]</ety> <sn>1.</sn> <def>To talk; chat.</def>
<mark>[Obs.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <def>To repeat a word or sentence, in
speaking or writing, without wishing to do so or in spite of efforts to
cease.</def> -- <wordforms><wf>Ver*big`er*a"tion</wf> <pr>(#)</pr>,
<pos>n.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Verbose</ent><br/
<hw>Ver*bose"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>verbosus</ets>, from <ets>verbum</ets> a word. See
<er>Verb</er>.]</ety> <def>Abounding in words; using or containing more
words than are necessary; tedious by a multiplicity of words; prolix;
wordy; <as>as, a <ex>verbose</ex> speaker; a <ex>verbose</ex>
argument</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Too <qex>verbose</qex> in their way of speaking.</q>
<rj><qau>Ayliffe.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Ver*bose"ly</wf>, <pos>adv.</pos> --
<wf>Ver*bose"ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verbosity</ent><br/
<hw>Ver*bos"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Verbosities</plw> <pr>(#)</pr>.</plu> <ety>[L.
<ets>verbositas</ets>: cf. F. <ets>verbosit<eacute/</ets>.]</ety>
<def>The quality or state of being verbose; the use of more words than
are necessary; prolixity; wordiness; verbiage.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The worst fault, by far, is the extreme diffuseness and
<qex>verbosity</qex> of his style.</q> <rj><qau>Jeffrey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verd</ent><br/
<hw>Verd</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Vert</er>,
<er>Verdant</er>.]</ety> <sn>1.</sn> <fld>(Eng. Forest Law)</fld>
<sd>(a)</sd> <def>The privilege of cutting green wood within a forest
for fuel.</def> <sd>(b)</sd> <def>The right of pasturing animals in a
forest.</def> <rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Greenness; freshness.</def> <mark>[Obs.]</mark>
<rj><au>Nares.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdancy</ent><br/
<hw>Ver"dan*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being verdant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdant</ent><br/
<hw>Ver"dant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F.
<ets>verdoyant</ets>, p. pr. of <ets>verdoyer</ets> to be verdant, to
grow green, OF. <ets>verdoier</ets>, <ets>verdeier</ets>, fr.
<ets>verd</ets>, <ets>vert</ets>, green, fr. L. <ets>viridis</ets>
green, fr. <ets>virere</ets> to be green: cf. OF. <ets>verdant</ets>
verdant, L. <ets>viridans</ets>, p. pr. of <ets>viridare</ets> to make
green. Cf. <er>Farthingale</er>, <er>Verjuice</er>,
<er>Vert</er>.]</ety> <sn>1.</sn> <def>Covered with growing plants or
grass; green; fresh; flourishing; <as>as, <ex>verdant</ex> fields; a
<ex>verdant</ex> lawn.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Let the earth<br/
Put forth the <qex>verdant</qex> grass.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Unripe in knowledge or judgment; unsophisticated;
raw; green; <as>as, a <ex>verdant</ex> youth</as>.</def>
<mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verd antique</ent><br/
<hw>Verd` an*tique"</hw> <pr>(?)</pr>. <ety>[F. <ets>vert antique</ets>
a kind of marble; <ets>verd</ets>, <ets>vert</ets>, green +
<ets>antique</ets> ancient: cf. It. <ets>verde antico</ets>.]</ety>
<fld>(Min.)</fld> <sd>(a)</sd> <def>A mottled-green serpentine
marble.</def> <sd>(b)</sd> <def>A green porphyry called
<altname>oriental verd antique</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdantly</ent><br/
<hw>Ver"dant*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a verdant
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verderor</ent><br/
<ent>Verderer</ent><br/
<mhw>{ <hw>Ver"der*er</hw> <pr>(?)</pr>, <hw>Ver"der*or</hw>
<pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[F. <ets>verdier</ets>, LL.
<ets>viridarius</ets>, fr. L. <ets>viridis</ets> green.]</ety>
<fld>(Eng. Forest Law)</fld> <def>An officer who has the charge of the
king's forest, to preserve the vert and venison, keep the assizes, view,
receive, and enroll attachments and presentments of all manner of
trespasses.</def> <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdict</ent><br/
<hw>Ver"dict</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>verdit</ets>, OF. <ets>verdit</ets>, <ets>veirdit</ets>, LL.
<ets>verdictum</ets>, <ets>veredictum</ets>; L. <ets>vere</ets> truly
(fr. <ets>verus</ets> true) + <ets>dictum</ets> a saying, a word, fr.
<ets>dicere</ets>, dictum, to say. See <er>Very</er>, and
<er>Dictum</er>.]</ety> <sn>1.</sn> <fld>(Law)</fld> <def>The answer of
a jury given to the court concerning any matter of fact in any cause,
civil or criminal, committed to their examination and determination; the
finding or decision of a jury on the matter legally submitted to them in
the course of the trial of a cause.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The decision of a judge or referee, upon an issue of
fact, is not called a <xex>verdict</xex>, but a <xex>finding</xex>, or a
<xex>finding of fact</xex>. <au>Abbott.</au></note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Decision; judgment; opinion pronounced; <as>as, to
be condemned by the <ex>verdict</ex> of the public</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>These were enormities condemned by the most natural
<qex>verdict</qex> of common humanity.</q>
<rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Two generations have since confirmed the <qex>verdict</qex> which
was pronounced on that night.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdigris</ent><br/
<hw>Ver"di*gris</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vert-de-gris</ets>, apparently from <ets>verd</ets>,
<ets>vert</ets>, green + <ets>de</ets> of + <ets>gris</ets> gray, but
really a corruption of LL. <ets>viride aeris</ets> (equivalent to L.
<ets>aerugo</ets>), from L. <ets>viridis</ets> green + <ets>aes</ets>,
<ets>aeris</ets>, brass. See <er>Verdant</er>, and 2d
<er>Ore</er>.]</ety> <sn>1.</sn> <fld>(Chem.)</fld> <def>A green
poisonous substance used as a pigment and drug, obtained by the action
of acetic acid on copper, and consisting essentially of a complex
mixture of several basic copper acetates.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The green rust formed on copper.</def>
<mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This rust is a carbonate of copper, and should not be
confounded with true verdigris.</note> <rj><au>U. S. Disp.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Blue verdigris</b></col> <fld>(Chem.)</fld>, <cd>a
verdigris having a blue color, used as a pigment, etc.</cd> --
<col><b>Distilled verdigris</b></col> <fld>(Old Chem.)</fld>, <cd>an
acid copper acetate; -- so called because the acetic acid used in making
it was obtained from <ets>distilled</ets> vinegar.</cd> --
<col><b>Verdigris green</b></col>, <cd>clear bluish green, the color of
verdigris.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdigris</ent><br/
<hw>Ver"di*gris</hw>, <pos>v. t.</pos> <def>To cover, or coat, with
verdigris.</def> <mark>[R.]</mark> <ldquo/An old <xex>verdigrised</xex>
brass bugle.<rdquo/ <rj><au>Hawthorne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdin</ent><br/
<hw>Ver"din</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Sp.
<ets>verdino</ets> bright green, F. <ets>verdin</ets> the
yellow-hammer.]</ety> <fld>(Zool.)</fld> <def>A small yellow-headed bird
(<spn>Auriparus flaviceps</spn>) of Lower California, allied to the
titmice; -- called also <altname>goldtit</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdine</ent><br/
<hw>Ver"dine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>verd</ets>,
<ets>vert</ets>, green.]</ety> <fld>(Chem.)</fld> <def>A commercial name
for a green aniline dye.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdingale</ent><br/
<hw>Ver"din*gale</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Farthingale</er>.</def> <altsp>[Spelled also
<asp>verdingall</asp>.]</altsp> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdit</ent><br/
<hw>Ver"dit</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Verdict.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verditer</ent><br/
<hw>Ver"di*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vert-de-terre</ets>, literally, green of earth.]</ety>
<fld>(Chem.)</fld> <sd>(a)</sd> <def>Verdigris.</def>
<mark>[Obs.]</mark> <sd>(b)</sd> <def>Either one of two pigments (called
<stype>blue verditer</stype>, and <stype>green verditer</stype>) which
are made by treating copper nitrate with calcium carbonate (in the form
of lime, whiting, chalk, etc.) They consist of hydrated copper
carbonates analogous to the minerals azurite and malachite.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Verditer blue</b></col>, <cd>a pale greenish blue color,
like that of the pigment verditer.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verditure</ent><br/
<hw>Ver"di*ture</hw> <pr>(?; 135)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Verditer</er>.]</ety> <def>The faintest and palest green.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdoy</ent><br/
<hw>Ver"doy</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F.
<ets>verdoyer</ets> to become green. See <er>Verdant</er>.]</ety>
<fld>(Her.)</fld> <def>Charged with leaves, fruits, flowers, etc.; --
said of a border.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdure</ent><br/
<hw>Ver"dure</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L.
<ets>viridis</ets> green. See <er>Verdant</er>.]</ety> <def>Green;
greenness; freshness of vegetation; <as>as, the <ex>verdure</ex> of the
meadows in June</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A wide expanse of living <qex>verdure</qex>, cultivated gardens,
shady groves, fertile cornfields, flowed round it like a sea.</q>
<rj><qau>Motley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdured</ent><br/
<hw>Ver"dured</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Covered with
verdure.</def> <rj><au>Poe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdureless</ent><br/
<hw>Ver"dure*less</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Destitute of
verdure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verdurous</ent><br/
<hw>Ver"dur*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Covered with
verdure; clothed with the fresh green of vegetation; verdured; verdant;
<as>as, <ex>verdurous</ex> pastures</as>.</def>
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verecund</ent><br/
<hw>Ver"e*cund</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>verecundus</ets>, fr. <ets>vereri</ets> to feel awe.]</ety>
<def>Bashful; modest.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verecundious</ent><br/
<hw>Ver`e*cun"di*ous</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Verecund.</def> <mark>[Obs.]</mark> <ldquo/<xex>Verecundious</xex>
generosity.<rdquo/ <rj><au>Sir H. Wotton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verecundity</ent><br/
<hw>Ver`e*cun"di*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being verecund; modesty.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verein</ent><br/
\'d8<hw>Ver*ein"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[G.]</ety> <def>A
union, association, or society; -- used in names of German
organizations.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Veretillum</ent><br/
\'d8<hw>Ver`e*til"lum</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., dim. of
<ets>veretrum</ets> the private parts.]</ety> <fld>(Zool.)</fld>
<def>Any one of numerous species of club-shaped, compound Alcyonaria
belonging to <gen>Veretillum</gen> and allied genera, of the tribe
<fam>Pennatulacea</fam>. The whole colony can move about as if it were a
simple animal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vergaloo</ent><br/
<ent>Vergalieu</ent><br/
<mhw>{ <hw>Ver"ga*lieu</hw>, <hw>Ver"ga*loo</hw> }</mhw>
<pr>(v<etil/r"g<adot/*l<oomac/)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Virgouleuse</er>.]</ety> <fld>(Bot.)</fld> <def>See
<er>Virgalieu</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verge</ent><br/
<hw>Verge</hw> <pr>(v<etil/rj)</pr>, <pos>n.</pos> <ety>[F.
<ets>verge</ets>, L. <ets>virga</ets>; perhaps akin to E.
<ets>wisp</ets>.]</ety> <sn>1.</sn> <def>A rod or staff, carried as an
emblem of authority; <as>as, the <ex>verge</ex>, carried before a
dean</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The stick or wand with which persons were formerly
admitted tenants, they holding it in the hand, and swearing fealty to
the lord. Such tenants were called <xex>tenants by the
verge</xex>.</def> <mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Eng. Law)</fld> <def>The compass of the court of
Marshalsea and the Palace court, within which the lord steward and the
marshal of the king's household had special jurisdiction; -- so called
from the verge, or staff, which the marshal bore.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A virgate; a yardland.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A border, limit, or boundary of a space; an edge,
margin, or brink of something definite in extent.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Even though we go to the extreme <qex>verge</qex> of possibility
to invent a supposition favorable to it, the theory . . . implies an
absurdity.</q> <rj><qau>J. S. Mill.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>But on the horizon's <qex>verge</qex> descried,<br/
Hangs, touched with light, one snowy sail.</q> <rj><qau>M.
Arnold.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A circumference; a circle; a ring.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The inclusive <qex>verge</qex><br/
Of golden metal that must round my brow.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Arch.)</fld> <sd>(a)</sd> <def>The shaft of a
column, or a small ornamental shaft.</def> <au>Oxf. Gloss.</au>
<sd>(b)</sd> <def>The edge of the tiling projecting over the gable of a
roof.</def> <rj><au>Encyc. Brit.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Horol.)</fld> <def>The spindle of a watch balance,
especially one with pallets, as in the old vertical escapement. See
under <er>Escapement</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Hort.)</fld> <sd>(a)</sd> <def>The edge or outside
of a bed or border.</def> <sd>(b)</sd> <def>A slip of grass adjoining
gravel walks, and dividing them from the borders in a
parterre.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <def>The penis.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <fld>(Zool.)</fld> <def>The external male organ of
certain mollusks, worms, etc. See <xex>Illustration</xex> in
Appendix.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Border; edge; rim; brim; margin; brink.</syn><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1603 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verge</ent><br/
<hw>Verge</hw> <pr>(v<etil/rj)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Verged</conjf> <pr>(v<etil/rjd)</pr>; <pos>p. pr. &
vb. n.</pos> <conjf>Verging</conjf>
<pr>(v<etil/r"j<icr/ng)</pr>.]</vmorph> <ety>[L. <ets>vergere</ets> to
bend, turn, incline; cf. Skr. <ets>v<rsdot/j</ets> to turn.]</ety>
<sn>1.</sn> <def>To border upon; to tend; to incline; to come near; to
approach.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To tend downward; to bend; to slope; <as>as, a hill
<ex>verges</ex> to the north</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Our soul, from original instinct, <qex>vergeth</qex> towards him
as its center.</q> <rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I find myself <qex>verging</qex> to that period of life which is
to be labor and sorrow.</q> <rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vergeboard</ent><br/
<hw>Verge"board`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Verge</ets>
+ <ets>board.</ets> Cf. <er>Bargeboard</er>.]</ety> <fld>(Arch.)</fld>
<def>The ornament of woodwork upon the gable of a house, used
extensively in the 15th century. It was generally suspended from the
edge of the projecting roof (see <er>Verge</er>, <pos>n.</pos>, 4), and
in a position parallel to the gable wall. Called also
<xex>bargeboard</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vergency</ent><br/
<hw>Ver"gen*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act
of verging or approaching; tendency; approach.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Opt.)</fld> <def>The reciprocal of the focal
distance of a lens, used as measure of the divergence or convergence of
a pencil of rays.</def> <mark>[R.]</mark> <rj><au>Humphrey
Lloyd.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verger</ent><br/
<hw>Ver"ger</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>verger</ets>,
from <ets>verge</ets> a rod. See 1st <er>Verge</er>.]</ety> <def>One who
carries a verge, or emblem of office.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>An attendant upon a dignitary, as on a bishop, a
dean, a justice, etc.</def> <mark>[Eng.]</mark>
<rj><au>Strype.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>The official who takes care of the interior of a
church building.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verger</ent><br/
<hw>Ver"ger</hw>, <pos>n.</pos> <ety>[F.]</ety> <def>A garden or
orchard.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vergette</ent><br/
<hw>Ver`get`t<eacute/"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>verget<eacute/</ets>.]</ety> <def>Divided by pallets, or pales;
paly.</def> <rj><au>W. Berry.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vergette</ent><br/
<hw>Ver*gette"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Her.)</fld> <def>A
small pale.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veridical</ent><br/
<hw>Ve*rid"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>veridicus</ets>; <ets>verus</ets> true + <ets>dicere</ets> to say,
tell.]</ety> <def>Truth-telling; truthful; veracious.</def>
<mark>[R.]</mark> <rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verifiable</ent><br/
<hw>Ver"i*fi`a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of
being verified; confirmable.</def> <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verification</ent><br/
<hw>Ver`i*fi*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>v<eacute/rification</ets>.]</ety> <sn>1.</sn> <def>The act of
verifying, or the state of being verified; confirmation;
authentication.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <sd>(a)</sd> <def>Confirmation by
evidence.</def> <sd>(b)</sd> <def>A formal phrase used in concluding a
plea.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Verification of an equation</b></col> <fld>(Math.)</fld>,
<cd>the operation of testing the equation of a problem, to see whether
it expresses truly the conditions of the problem.</cd> <rj><au>Davies &
Peck. (Math. Dict.)</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verificative</ent><br/
<hw>Ver"i*fi*ca*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Serving to
verify; verifying; authenticating; confirming.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verifier</ent><br/
<hw>Ver"i*fi`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that
which, verifies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verify</ent><br/
<hw>Ver"i*fy</hw> <pr>(v<ecr/r"<icr/*f<imac/)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Verified</conjf> <pr>(?)</pr>;
<pos>p. pr. & vb. n.</pos> <conjf>Verifying</conjf>.]</vmorph> <ety>[F.
<ets>v<eacute/rifier</ets>, LL. <ets>verificare</ets>, from L.
<ets>verus</ets> true + <ets>-ficare</ets> to make. See <er>Very</er>,
and <ets>-fy</ets>.]</ety> <sn>1.</sn> <def>To prove to be true or
correct; to establish the truth of; to confirm; to
substantiate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This is <qex>verified</qex> by a number of examples.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>So shalt thou best fulfill, best <qex>verify</qex>.<br/
The prophets old, who sung thy endless reign.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To confirm or establish the authenticity of by
examination or competent evidence; to authenticate; <as>as, to
<ex>verify</ex> a written statement; to <ex>verify</ex> an account, a
pleading, or the like</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To <qex>verify</qex> our title with their lives.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To maintain; to affirm; to support.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veriloquent</ent><br/
<hw>Ve*ril"o*quent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>verus</ets> true + <ets>loquens</ets> speaking.]</ety>
<def>Speaking truth; truthful.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verily</ent><br/
<hw>Ver"i*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[From
<er>Very</er>.]</ety> <def>In very truth; beyond doubt or question; in
fact; certainly.</def> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Trust in the Lord and do good; so shalt thou dwell in the land,
and <qex>verily</qex> thou shalt be fed.</q> <rj><qau>Ps. xxxvii.
3.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verine</ent><br/
<hw>Ver"ine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Contr. from
<ets>ver</ets>atr<ets>ine</ets>.]</ety> <fld>(Chem.)</fld> <def>An
alkaloid obtained as a yellow amorphous substance by the decomposition
of veratrine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verisimilar</ent><br/
<hw>Ver`i*sim"i*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>verisimilis</ets>; <ets>verus</ets> true + <ets>similis</ets> like,
similar. See <er>Very</er>, and <er>Similar</er>.]</ety> <def>Having the
appearance of truth; probable; likely.</def> <ldquo/How
<xex>verisimilar</xex> it looks.<rdquo/ <rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verisimilitude</ent><br/
<hw>Ver`i*si*mil"i*tude</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>verisimilitudo</ets>: cf. OF. <ets>verisimilitude</ets>. See
<er>Verisimilar</er>.]</ety> <def>The quality or state of being
verisimilar; the appearance of truth; probability; likelihood.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Verisimilitude</qex> and opinion are an easy purchase; but
true knowledge is dear and difficult.</q>
<rj><qau>Glanvill.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>All that gives <qex>verisimilitude</qex> to a narrative.</q>
<rj><qau>Sir. W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verisimility</ent><br/
<hw>Ver`i*si*mil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos>
<def>Verisimilitude.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>verisimility</qex> or probable truth.</q> <rj><qau>Sir T.
Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verisimilous</ent><br/
<hw>Ver`i*sim"i*lous</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Verisimilar.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veritable</ent><br/
<hw>Ver"i*ta*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F.
<ets>v<eacute/ritable</ets>. See <er>Verity</er>.]</ety> <def>Agreeable
to truth or to fact; actual; real; true; genuine.</def> <ldquo/The
<xex>veritable</xex> Deity.<rdquo/ <au>Sir W. Hamilton.</au> --
<wordforms><wf>Ver"i*ta*bly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veritas</ent><br/
<hw>Ver"i*tas</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>v<eacute/ritas</ets>. See <er>Verity</er>.]</ety> <def>The Bureau
Veritas. See under <er>Bureau</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verity</ent><br/
<hw>Ver"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Verities</plw> <pr>(#)</pr>.</plu> <ety>[F.
<ets>v<eacute/rit<eacute/</ets>, L. <ets>veritas</ets>, fr.
<ets>verus</ets> true. See <er>Very</er>.]</ety> <sn>1.</sn> <def>The
quality or state of being true, or real; consonance of a statement,
proposition, or other thing, with fact; truth; reality.</def> <ldquo/The
<xex>verity</xex> of certain words.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It is a proposition of eternal <qex>verity</qex>, that none can
govern while he is despised.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is true; a true assertion or tenet; a
truth; a reality.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Mark what I say, which you shall find<br/
By every syllable a faithful <qex>verity</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verjuice</ent><br/
<hw>Ver"juice`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vergeous</ets>, F. <ets>verjus</ets>, that is, the juice of green
fruits; <ets>verd</ets>, <ets>vert</ets>, green + <ets>jus</ets> juice.
See <er>Verdant</er>, and <er>Juice</er>.]</ety> <sn>1.</sn> <def>The
sour juice of crab apples, of green or unripe grapes, apples, etc.;
also, an acid liquor made from such juice.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Tartness; sourness, as of disposition.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermeil</ent><br/
<hw>Ver"meil</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., vermilion, fr.
LL. <ets>vermiculus</ets>, fr. L. <ets>vermiculus</ets> a little worm,
the coccus Indicus, from <ets>vermis</ets> a worm. See <er>Worm</er>,
and cf. <er>Vermicule</er>.]</ety> <sn>1.</sn> <def>Vermilion; also, the
color of vermilion, a bright, beautiful red.</def> <mark>[Poetic &
R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>In her cheeks the <qex>vermeill</qex> red did show<br/
Like roses in a bed of lilies shed.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Silver gilt or gilt bronze.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A liquid composition applied to a gilded surface to
give luster to the gold.</def> <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermeologist</ent><br/
<hw>Ver`me*ol"o*gist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who
treats of vermes, or worms; a helminthologist.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermeology</ent><br/
<hw>Ver`me*ol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vermes</ets> worms + <ets>-logy</ets>.]</ety> <fld>(Zool.)</fld>
<def>A discourse or treatise on worms; that part of Zoology which treats
of worms; helminthology.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermes</ent><br/
\'d8<hw>Ver"mes</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[L.
<ets>vermes</ets>, pl. of <ets>vermis</ets> a worm.]</ety>
<fld>(Zool.)</fld> <sd>(a)</sd> <def>An extensive artificial division of
the animal kingdom, including the parasitic worms, or helminths,
together with the nemerteans, annelids, and allied groups. By some
writers the branchiopods, the bryzoans, and the tunicates are also
included. The name was used in a still wider sense by Linnaeus and his
followers.</def> <sd>(b)</sd> <def>A more restricted group, comprising
only the helminths and closely allied orders.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermetid</ent><br/
<hw>Ver"me*tid</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>Any species of vermetus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermetus</ent><br/
\'d8<hw>Ver*me"tus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., from L.
<ets>vermis</ets> worm.]</ety> <fld>(Zool.)</fld> <def>Any one of many
species of marine gastropods belonging to <gen>Vermetus</gen> and allied
genera, of the family <fam>Vermetidae</fam>. Their shells are regularly
spiral when young, but later in life the whorls become separate, and the
shell is often irregularly bent and contorted like a worm
tube.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermicelli</ent><br/
<hw>Ver`mi*cel"li</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It., pl. of
<ets>vermicello</ets>, literally, a little worm, dim. of
<ets>verme</ets> a worm, L. <ets>vermis</ets>. See <er>Worm</er>, and
cf. <er>Vermicule</er>, <er>Vermeil</er>.]</ety> <def>The flour of a
hard and small-grained wheat made into dough, and forced through small
cylinders or pipes till it takes a slender, wormlike form, whence the
Italian name. When the paste is made in larger tubes, it is called
<xex>macaroni</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermicide</ent><br/
<hw>Ver"mi*cide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vermis</ets> a worm + <ets>caedere</ets> to kill.]</ety> <def>A
medicine which destroys intestinal worms; a worm killer.</def>
<rj><au>Pereira.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermicious</ent><br/
<hw>Ver*mi"cious</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vermis</ets> a worm.]</ety> <def>Of or pertaining to worms;
wormy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermicular</ent><br/
<hw>Ver*mic"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vermiculus</ets> a little worm, dim. of <ets>vermis</ets> a worm:
cf. F. <ets>vermiculaire</ets>. See <er>Vermicelli</er>.]</ety> <def>Of
or pertaining to a worm or worms; resembling a worm; shaped like a worm;
especially, resembling the motion or track of a worm; <as>as, the
<ex>vermicular</ex>, or peristaltic, motion of the intestines</as>. See
<er>Peristaltic</er>.</def> <ldquo/A twisted form
<xex>vermicular</xex>.<rdquo/ <rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vermicular work</b></col>. <cd>See under
<er>Vermiculated</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermiculate</ent><br/
<hw>Ver*mic"u*late</hw> <pr>(?)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Vermiculated</conjf>
<pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vermiculating</conjf>.]</vmorph> <ety>[L. <ets>vermiculatus</ets>
inlaid so as to resemble the tracks of worms, p. p. of
<ets>vermiculari</ets> to be full of worms, <ets>vermiculus</ets> a
little worm. See <er>Vermicular</er>.]</ety> <def>To form or work, as by
inlaying, with irregular lines or impressions resembling the tracks of
worms, or appearing as if formed by the motion of worms.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermiculate</ent><br/
<hw>Ver*mic"u*late</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn>
<def>Wormlike in shape; covered with wormlike elevations; marked with
irregular fine lines of color, or with irregular wavy impressed lines
like worm tracks; <as>as, a <ex>vermiculate</ex> nut</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Crawling or creeping like a worm; hence,
insinuating; sophistical.</def> <ldquo/<xex>Vermiculate</xex>
questions.<rdquo/ <au>Bacon.</au> <ldquo/<xex>Vermiculate</xex>
logic.<rdquo/ <au>R. Choate.</au><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermiculated</ent><br/
<hw>Ver*mic"u*la`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Made or
marked with irregular wavy lines or impressions; vermiculate.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Vermiculated work</b></col>, <it>or</it>
<col><b>Vermicular work</b></col></mcol> <fld>(Arch.)</fld>, <cd>rustic
work so wrought as to have the appearance of convoluted worms, or of
having been eaten into by, or covered with tracks of, worms.</cd>
<rj><au>Gwilt.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermiculation</ent><br/
<hw>Ver*mic`u*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vermiculatio</ets> a being worm-eaten.]</ety> <sn>1.</sn> <def>The
act or operation of moving in the manner of a worm; continuation of
motion from one part to another; <as>as, the <ex>vermiculation</ex>, or
peristaltic motion, of the intestines</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The act of vermiculating, or forming or inlaying so
as to resemble the motion, track, or work of a worm.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Penetration by worms; the state of being
wormeaten.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>A very fine wavy crosswise color
marking, or a patch of such markings, as on the feathers of
birds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermicule</ent><br/
<hw>Ver"mi*cule</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vermiculus</ets>, dim. of <ets>vermis</ets> a worm. See
<er>Vermicular</er>.]</ety> <def>A small worm or insect larva; also, a
wormlike body.</def> <mark>[R.]</mark> <rj><au>Derham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermiculite</ent><br/
<hw>Ver*mic"u*lite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vermiculus</ets>, dim. of <ets>vermis</ets> worm.]</ety>
<fld>(Min.)</fld> <def>A group of minerals having, a micaceous
structure. They are hydrous silicates, derived generally from the
alteration of some kind of mica. So called because the scales, when
heated, open out into wormlike forms.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermiculous</ent><br/
<ent>Vermiculose</ent><br/
<mhw>{ <hw>Ver*mic"u*lose`</hw> <pr>(?)</pr>, <hw>Ver*mic"u*lous</hw>
<pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>vermiculosus</ets>.
See <er>Vermicule</er>.]</ety> <def>Containing, or full of, worms;
resembling worms.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermiform</ent><br/
<hw>Ver"mi*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vermis</ets> a worm + <ets>-form</ets>.]</ety> <def>Resembling a
worm in form or motions; vermicular; <as>as, the <ex>vermiform</ex>
process of the cerebellum</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vermiform appendix</b></col> <fld>(Anat.)</fld>, <cd>a
slender blind process of the caecum in man and some other animals; --
called also <altname>vermiform appendage</altname>, and
<altname>vermiform process</altname>. Small solid bodies, such as grape
seeds or cherry stones, sometimes lodge in it, causing serious, or even
fatal, inflammation. See <xex>Illust.</xex> under
<er>Digestion</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermiformia</ent><br/
\'d8<hw>Ver`mi*for"mi*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos>
<ety>[NL.]</ety> <fld>(Zool.)</fld> <def>A tribe of worms including
Phoronis. See <er>Phoronis</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermifugal</ent><br/
<hw>Ver*mif"u*gal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vermis</ets> a worm + <ets>fugare</ets> to drive away, fr.
<ets>fugere</ets> to flee. See <er>Worm</er>, and
<er>Fugitive</er>.]</ety> <fld>(Med.)</fld> <def>Tending to prevent,
destroy, or expel, worms or vermin; anthelmintic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermifuge</ent><br/
<hw>Ver"mi*fuge</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vermifuge</ets>. See <er>Vermifugal</er>.]</ety> <fld>(Med.)</fld>
<def>A medicine or substance that expels worms from animal bodies; an
anthelmintic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermil</ent><br/
<hw>Ver"mil</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Vermeil</er>.</def> <mark>[Obs.]</mark>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermilinguia</ent><br/
\'d8<hw>Ver`mi*lin"gui*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL.,
fr. L. <ets>vermis</ets> worm + <ets>lingua</ets> tongue.]</ety> [Called
also <altname>Vermilingues</altname>.] <fld>(Zool.)</fld> <sd>(a)</sd>
<def>A tribe of edentates comprising the South American ant-eaters. The
tongue is long, slender, exsertile, and very flexible, whence the
name.</def> <sd>(b)</sd> <def>A tribe of Old World lizards which
comprises the chameleon. They have long, flexible tongues.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermilion</ent><br/
<hw>Ver*mil"ion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vermillon</ets>. See <er>Vermeil</er>.]</ety> <sn>1.</sn>
<fld>(Chem.)</fld> <def>A bright red pigment consisting of mercuric
sulphide, obtained either from the mineral cinnabar or artificially. It
has a fine red color, and is much used in coloring sealing wax, in
printing, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The kermes insect has long been used for dyeing red or
scarlet. It was formerly known as the <xex>worm dye</xex>,
<xex>vermiculus</xex>, or <xex>vermiculum</xex>, and the cloth was
called <xex>vermiculatia</xex>. Hence came the French <xex>vermeil</xex>
for any red dye, and hence the modern name <xex>vermilion</xex>,
although the substance it denotes is very different from the kermes,
being a compound of mercury and sulphur.</note> <rj><au>R.
Hunt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, a red color like the pigment; a lively and
brilliant red; <as>as, cheeks of <ex>vermilion</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermilion</ent><br/
<hw>Ver*mil"ion</hw>, <pos>v. t.</pos> <def>To color with vermilion, or
as if with vermilion; to dye red; to cover with a delicate
red.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermily</ent><br/
<hw>Ver"mi*ly</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Vermeil.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermin</ent><br/
<hw>Ver"min</hw> <pr>(?)</pr>, <pos>n. sing. & pl.</pos>; used chiefly
as plural. <ety>[OE. <ets>vermine</ets>, F. <ets>vermine</ets>, from L.
<ets>vermis</ets> a worm; cf. LL. <ets>vermen</ets> a worm, L.
<ets>verminosus</ets> full of worms. See <er>Vermicular</er>,
<er>Worm</er>.]</ety> <sn>1.</sn> <def>An animal, in general.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Wherein were all manner of fourfooted beasts of the earth, and
<qex>vermin</qex>, and worms, and fowls.</q> <rj><qau>Acts x. 12.
(Geneva Bible).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>This crocodile is a mischievous fourfooted beast, a dangerous
<qex>vermin</qex>, used to both elements.</q>
<rj><qau>Holland.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A noxious or mischievous animal; especially, noxious
little animals or insects, collectively, as squirrels, rats, mice,
worms, flies, lice, bugs, etc.</def> <ldquo/Cruel hounds or some foul
<xex>vermin</xex>.<rdquo/ <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Great injuries these <qex>vermin</qex>, mice and rats, do in the
field.</q> <rj><qau>Mortimer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They disdain such <qex>vermin</qex> when the mighty boar of the
forest . . . is before them.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Hence, in contempt, noxious human beings.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>You are my prisoners, base <qex>vermin</qex>.</q>
<rj><qau>Hudibras.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verminate</ent><br/
<hw>Ver"mi*nate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[L.
<ets>verminare</ets> to have worms, fr. <ets>vermis</ets> a worm.]</ety>
<def>To breed vermin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermination</ent><br/
<hw>Ver`mi*na"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>verminatio</ets> the worms, a disease of animals, a crawling,
itching pain.]</ety> <sn>1.</sn> <def>The generation or breeding of
vermin.</def> <rj><au>Derham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A griping of the bowels.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verminly</ent><br/
<hw>Ver"min*ly</hw> <pr>(?)</pr>, <pos>a. & adv.</pos> <def>Resembling
vermin; in the manner of vermin.</def> <mark>[Obs.]</mark>
<rj><au>Gauden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verminous</ent><br/
<hw>Ver"min*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>verminosus</ets>, fr. <ets>vermis</ets> a worm: cf. F.
<ets>vermineux</ets>.]</ety> <sn>1.</sn> <def>Tending to breed vermin;
infested by vermin.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Some . . . <qex>verminous</qex> disposition of the body.</q>
<rj><qau>Harvey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Caused by, or arising from the presence of, vermin;
<as>as, <ex>verminous</ex> disease</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verminously</ent><br/
<hw>Ver"min*ous*ly</hw>, <pos>adv.</pos> <def>In a verminous
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermiparous</ent><br/
<hw>Ver*mip"a*rous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vermis</ets> a worm + <ets>parere</ets> to bring forth.]</ety>
<def>Producing or breeding worms.</def> <ldquo/<xex>Vermiparous</xex>
animals.<rdquo/ <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermivorous</ent><br/
<hw>Ver*miv"o*rous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vermis</ets> a worm + <ets>vorare</ets> to devour: cf. F.
<ets>vermivore</ets>.]</ety> <fld>(Zool.)</fld> <def>Devouring worms;
feeding on worms; <as>as, <ex>vermivorous</ex> birds</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vermuth</ent><br/
<hw>Ver"muth</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vermout</ets>.]</ety> <def>A liqueur made of white wine, absinthe,
and various aromatic drugs, used to excite the appetite.</def>
<altsp>[Written also <asp>vermouth</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernacle</ent><br/
<hw>Ver"na*cle</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Veronica</er>, 1.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernacular</ent><br/
<hw>Ver*nac"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vernaculus</ets> born in one's house, native, fr. <ets>verna</ets>
a slave born in his master's house, a native, probably akin to Skr.
<ets>vas</ets> to dwell, E. <ets>was</ets>.]</ety> <def>Belonging to the
country of one's birth; one's own by birth or nature; native;
indigenous; -- now used chiefly of language; <as>as, English is our
<ex>vernacular</ex> language</as>.</def> <ldquo/A <xex>vernacular</xex>
disease.<rdquo/ <rj><au>Harvey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>His skill in the <qex>vernacular</qex> dialect of the Celtic
tongue.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Which in our <qex>vernacular</qex> idiom may be thus
interpreted.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernacular</ent><br/
<hw>Ver*nac"u*lar</hw>, <pos>n.</pos> <def>The vernacular language;
one's mother tongue; often, the common forms of expression in a
particular locality, opposed to <contr>literary</contr> or
<contr>learned</contr> forms.</def><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><ent>Vernacularism</ent><br/
<hw>Ver*nac"u*lar*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A vernacular
idiom.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernacularization</ent><br/
<hw>Ver*nac"u*lar*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The
act or process of making vernacular, or the state of being made
vernacular.</def> <rj><au>Fitzed. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernacularly</ent><br/
<hw>Ver*nac"u*lar*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a
vernacular manner; in the vernacular.</def> <rj><au>Earle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernaculous</ent><br/
<hw>Ver*nac"u*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vernaculus</ets>. See <er>Vernacular</er>.]</ety> <sn>1.</sn>
<def>Vernacular.</def> <mark>[Obs.]</mark> <rj><au>Sir T.
Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[L. <ets>vernaculi</ets>, pl., buffoons,
jesters.]</ety> <def>Scoffing; scurrilous.</def> <mark>[A Latinism.
Obs.]</mark> <ldquo/Subject to the petulancy of every
<xex>vernaculous</xex> orator.<rdquo/ <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernage</ent><br/
<hw>Ver"nage</hw> <pr>(v<etil/r"n<asl/j)</pr>, <pos>n.</pos> <ety>[It.
<ets>vernaccia</ets>.]</ety> <def>A kind of sweet wine from Italy.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>vernal</ent><br/
<hw>ver"nal</hw> <pr>(v<etil/r"n<ait/l)</pr>, <pos>a.</pos> <ety>[L.
<ets>vernalis</ets>, fr. <ets>vernus</ets> vernal, <ets>ver</ets>
spring; akin to Gr. <grk>'e`ar</grk>, Skr. <ets>vasanta</ets>, Icel.
<ets>v<amac/r</ets>, and E. <ets>Easter</ets>, <ets>east</ets>.]</ety>
<sn>1.</sn> <def>Of or pertaining to the spring; appearing in the
spring; <as>as, <ex>vernal</ex> bloom</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And purple all the ground with <qex>vernal</qex> flowers.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: Belonging to youth, the spring of
life.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When after the long <qex>vernal</qex> day of life.</q>
<rj><qau>Thomson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And seems it hard thy <qex>vernal</qex> years<br/
Few <qex>vernal</qex> joys can show?</q> <rj><qau>Keble.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1604 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vernal equinox</b></col> <fld>(Astron.)</fld>, <cd>the
point of time in each year when the sun crosses the equator when
proceeding northward, about March 21, when day and night are of
approximately equal duration. The beginning of the Spring season.</cd>
-- <col><b>Vernal grass</b></col> <fld>(Bot.)</fld>, <cd>a low, soft
grass (<spn>Anthoxanthum odoratum</spn>), producing in the spring narrow
spikelike panicles, and noted for the delicious fragrance which it gives
to new-mown hay; -- also called <altname>sweet vernal grass</altname>.
See <xex>Illust.</xex> in Appendix.</cd> -- <col><b>Vernal
signs</b></col> <fld>(Astron.)</fld>, <cd>the signs, Aries, Taurus, and
Gemini, in which the sun appears between the vernal equinox and summer
solstice.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernant</ent><br/
<hw>Ver"nant</hw> <pr>(v<etil/r"n<ait/nt)</pr>, <pos>a.</pos> <ety>[L.
<ets>vernans</ets>, p. pr. <ets>vernare</ets> to flourish, from
<ets>ver</ets> spring.]</ety> <def>Flourishing, as in spring;
vernal.</def> <mark>[Obs.]</mark> <ldquo/<xex>Vernant</xex>
flowers.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernate</ent><br/
<hw>Ver"nate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[See
<er>Vernant</er>.]</ety> <def>To become young again.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernation</ent><br/
<hw>Ver*na"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vernation</ets>: cf. L. <ets>vernatio</ets> the sloughing of the
skin of snakes.]</ety> <fld>(Bot.)</fld> <def>The arrangement of the
leaves within the leaf bud, as regards their folding, coiling, rolling,
etc.; prefoliation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verner's law</ent><br/
<hw>Ver"ner's law</hw> <pr>(?)</pr>. <fld>(Philol.)</fld> <def>A
statement, propounded by the Danish philologist <person>Karl
Verner</person> in 1875, which explains certain apparent exceptions to
Grimm's law by the original position of the accent. Primitive
Indo-European <xex>k</xex>, <xex>t</xex>, <xex>p</xex>, became first in
Teutonic <xex>h</xex>, <xex>th</xex>, <xex>f</xex>, and appear without
further change in old Teutonic, if the accent rested on the preceding
syllable; but these sounds became voiced and produced <xex>g</xex>,
<xex>d</xex>, <xex>b</xex>, if the accent was originally on a different
syllable. Similarly <xex>s</xex> either remained unchanged, or it became
<xex>z</xex> and later <xex>r</xex>. Example: Skt. sa<it>p</it>t<amac/
(accent on ultima), Gr. <grk>'e`pta</grk>, Gothic si<it>b</it>un
(seven). Examples in English are <xex>dead</xex> by the side of
<xex>death</xex>, to <xex>rise</xex> and to <xex>rear</xex>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vernicle</ent><br/
<hw>Ver"ni*cle</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A Veronica. See
<er>Veronica</er>, 1.</def> <mark>[Obs.]</mark> <rj><au>Piers
Plowman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>vernicle</qex> had he sowed upon his cap.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernicose</ent><br/
<hw>Ver"ni*cose`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Varnish</er>.]</ety> <fld>(Bot.)</fld> <def>Having a brilliantly
polished surface, as some leaves.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernier</ent><br/
<hw>Ver"ni*er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So named after the
inventor, Pierre <etsep>Vernier</etsep>.]</ety> <def>A short scale made
to slide along the divisions of a graduated instrument, as the limb of a
sextant, or the scale of a barometer, for indicating parts of divisions.
It is so graduated that a certain convenient number of its divisions are
just equal to a certain number, either one less or one more, of the
divisions of the instrument, so that parts of a division are determined
by observing what line on the vernier coincides with a line on the
instrument.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Vernier calipers</b></col>, <col><b>Vernier
gauge</b></col></mcol>, <cd>a gauge with a graduated bar and a sliding
jaw bearing a vernier, used for accurate measurements.</cd> --
<col><b>Vernier compass</b></col>, <cd>a surveyor's compass with a
vernier for the accurate adjustment of the zero point in accordance with
magnetic variation.</cd> -- <col><b>Vernier transit</b></col>, <cd>a
surveyor's transit instrument with a vernier compass.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernile</ent><br/
<hw>Ver"nile</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vernilis</ets> servile. See <er>Vernacular</er>.]</ety>
<def>Suiting a slave; servile; obsequious.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The example . . . of <qex>vernile</qex> scurrility.</q>
<rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernility</ent><br/
<hw>Ver*nil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vernilitas</ets>.]</ety> <def>Fawning or obsequious behavior;
servility.</def> <mark>[R.]</mark> <rj><au>Bailey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernine</ent><br/
<hw>Ver"nine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Vern</ets>al +
<ets>-ine</ets>.]</ety> <fld>(Chem.)</fld> <def>An alkaloid extracted
from the shoots of the vetch, red clover, etc., as a white crystalline
substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernish</ent><br/
<hw>Ver"nish</hw> <pr>(?)</pr>, <pos>n. & v.</pos> <def>Varnish.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vernonin</ent><br/
<hw>Ver"no*nin</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A glucoside extracted from the root of a South African plant of the
genus <gen>Vernonia</gen>, as a deliquescent powder, and used as a mild
heart tonic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veronese</ent><br/
\'d8<hw>Ver`o*nese"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[It.
<ets>Veronese</ets>.]</ety> <def>Of or pertaining to Verona, in
Italy.</def> -- <def2><pos>n. sing. & pl.</pos> <def>A native of Verona;
collectively, the people of Verona.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veronica</ent><br/
<hw>Ve*ron"i*ca</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL.; -- so called
from <ets>Veronica</ets>, a woman who, according to an old legend, as
Christ was carrying the cross, wiped his face with a cloth, which
received an impression of his countenance; <ets>Veronica</ets> is fr.
MGr. <grk>Beroni`kh</grk>, fr. Macedonian <grk>Bereni`kh</grk>, for Gr.
<grk>Fereni`kh</grk>, literally, carrying off victory,
victorious.]</ety> <sn>1.</sn> <def>A portrait or representation of the
face of our Savior on the alleged handkerchief of Saint Veronica,
preserved at Rome; hence, a representation of this portrait, or any
similar representation of the face of the Savior. Formerly called also
<altname>Vernacle</altname>, and <altname>Vernicle</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>A genus of scrophulariaceous
plants; the speedwell. See <er>Speedwell</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Several herbaceous species are common in both Europe and
America, most of which have small blue flowers. A few shrubby species
from New Zealand are sometimes found in cultivation.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verray</ent><br/
<hw>Ver"ray</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Very; true.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verrayment</ent><br/
<hw>Ver"ray*ment</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[OF.
<ets>veraiement</ets>. See <er>Very</er>.]</ety> <def>Verily;
truly.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verrel</ent><br/
<hw>Ver"rel</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Ferrule</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verriculate</ent><br/
<hw>Ver*ric"u*late</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>verriculum</ets> a net, seine.]</ety> <fld>(Zool.)</fld>
<def>Having thickset tufts of parallel hairs, bristles, or
branches.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verruca</ent><br/
\'d8<hw>Ver*ru"ca</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu>pl.
<plw>Verrucae</plw> <pr>(#)</pr></plu>. <ety>[L. Cf.
<er>Verrugas</er>.]</ety> <sn>1.</sn> <fld>(Med.)</fld> <def>A
wart.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A wartlike elevation or
roughness.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Verruciform</ent><br/
<hw>Ver*ru"ci*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>verruca</ets> wart + <ets>-form</ets>.]</ety> <def>Shaped like a
wart or warts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verrucose</ent><br/
<hw>Ver"ru*cose`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>verrucosus</ets>, fr. <ets>verruca</ets> a wart.]</ety>
<def>Covered with wartlike elevations; tuberculate; warty; verrucous;
<as>as, a <ex>verrucose</ex> capsule</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verrucous</ent><br/
<hw>Ver"ru*cous</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Verrucose.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verruculose</ent><br/
<hw>Ver*ru"cu*lose`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>verrucula</ets>, dim. of <ets>verruca</ets> a wart.]</ety>
<def>Minutely verrucose; <as>as, a <ex>verruculose</ex> leaf or
stalk</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verrugas</ent><br/
\'d8<hw>Ver*ru"gas</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp., warts.
Cf. <er>Verruca</er>.]</ety> <fld>(Med.)</fld> <def>An endemic disease
occurring in the Andes in Peru, characterized by warty tumors which
ulcerate and bleed. It is probably due to a special bacillus, and is
often fatal.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vers</ent><br/
<hw>Vers</hw> <pr>(?)</pr>, <pos>n. sing. & pl.</pos> <def>A verse or
verses. See <er>Verse</er>, <pos>n.</pos></def> <mark>[Obs.]</mark>
<ldquo/Ten <xex>vers</xex> or twelve.<rdquo/
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versability</ent><br/
<hw>Ver`sa*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being versable.</def> <mark>[R.]</mark>
<rj><au>Sterne</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versable</ent><br/
<hw>Ver"sa*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>versabilis</ets>: cf. F. <ets>versable</ets>. See
<er>Versatile</er>.]</ety> <def>Capable of being turned.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versableness</ent><br/
<hw>Ver"sa*ble*ness</hw>, <pos>n.</pos> <def>Versability.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versal</ent><br/
<hw>Ver"sal</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Universal.</def>
<mark>[Obs. or Colloq.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versant</ent><br/
<hw>Ver"sant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>versans</ets>, p. pr. of <ets>versare</ets> to turn about
frequently, to turn over in the mind, to meditate. See
<er>Versatile</er>.]</ety> <def>Familiar; conversant.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Men not <qex>versant</qex> with courts of justice.</q>
<rj><qau>Sydney Smith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versant</ent><br/
<hw>Ver"sant</hw>, <pos>n.</pos> <ety>[F.]</ety> <def>The slope of a
side of a mountain chain; hence, the general slope of a country;
aspect.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versatile</ent><br/
<hw>Ver"sa*tile</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>versatilis</ets>, fr. <ets>versare</ets> to turn around, v. freq.
of <ets>vertere</ets>: cf. F. <ets>versatile</ets>. See
<er>Verse</er>.]</ety> <sn>1.</sn> <def>Capable of being turned
round.</def> <rj><au>Harte.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Liable to be turned in opinion; changeable;
variable; unsteady; inconstant; <as>as, a <ex>versatile</ex>
disposition</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Turning with ease from one thing to another; readily
applied to a new task, or to various subjects; many-sided; <as>as,
<ex>versatile</ex> genius; a <ex>versatile</ex>
politician</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Conspicuous among the youths of high promise . . . was the quick
and <qex>versatile</qex> [Charles] Montagu.</q>
<rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Nat. Hist.)</fld> <def>Capable of turning; freely
movable; <as>as, a <ex>versatile</ex> anther, which is fixed at one
point to the filament, and hence is very easily turned around; a
<ex>versatile</ex> toe of a bird.</as></def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Ver"sa*tile*ly</wf>, <pos>adv.</pos> -- --
<wf>Ver"sa*tile*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versatility</ent><br/
<hw>Ver`sa*til"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>versatilit<eacute/</ets>.]</ety> <def>The quality or state of being
versatile; versatileness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vers de societe</ent><br/
\'d8<hw>Vers` de so`ci<eacute/`t<eacute/"</hw> <pr>(?)</pr>.
<ety>[F.]</ety> <def>See <cref>Society verses</cref>, under
<er>Society</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verse</ent><br/
<hw>Verse</hw> <pr>(v<etil/rs)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vers</ets>, AS. <ets>fers</ets>, L. <ets>versus</ets> a line in
writing, and, in poetry, a verse, from <ets>vertere</ets>,
<ets>versum</ets>, to turn, to turn round; akin to E. <ets>worth</ets>
to become: cf. F. <ets>vers</ets>. See <er>Worth</er> to become, and cf.
<er>Advertise</er>, <er>Averse</er>, <er>Controversy</er>,
<er>Convert</er>, <er>Divers</er>, <er>Invert</er>, <er>Obverse</er>,
<er>Prose</er>, <er>Suzerain</er>, <er>Vortex</er>.]</ety> <sn>1.</sn>
<def>A line consisting of a certain number of metrical feet (see
<er>Foot</er>, <pos>n.</pos>, 9) disposed according to metrical
rules.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Verses are of various kinds, as
<stype>hexameter</stype>, <stype>pentameter</stype>,
<stype>tetrameter</stype>, etc., according to the number of feet in
each. A verse of twelve syllables is called an
<stype>Alexandrine</stype>. Two or more verses form a
<partof>stanza</partof> or <partof>strophe</partof>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Metrical arrangement and language; that which is
composed in metrical form; versification; poetry.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Such prompt eloquence<br/
Flowed from their lips in prose or numerous <qex>verse</qex>.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Virtue was taught in <qex>verse</qex>.</q>
<rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Verse</qex> embalms virtue.</q>
<rj><qau>Donne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A short division of any composition.</def>
Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>A stanza; a stave; <as>as, a hymn of four
<ex>verses</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Although this use of <xex>verse</xex> is common, it is
objectionable, because not always distinguishable from the stricter use
in the sense of a line.</note><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <fld>(Script.)</fld> <def>One of the short divisions of
the chapters in the Old and New Testaments.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The author of the division of the Old Testament into
<xex>verses</xex> is not ascertained. The New Testament was divided into
<xex>verses</xex> by Robert Stephens [or <xex>Estienne</xex>], a French
printer. This arrangement appeared for the first time in an edition
printed at Geneva, in 1551.</note><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <fld>(Mus.)</fld> <def>A portion of an anthem to be
performed by a single voice to each part.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A piece of poetry.</def> <ldquo/This
<xex>verse</xex> be thine.<rdquo/ <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Blank verse</b></col>, <cd>poetry in which the lines do
not end in rhymes.</cd> -- <col><b>Heroic verse</b></col>. <cd>See under
<er>Heroic</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verse</ent><br/
<hw>Verse</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Versed</conjf> <pr>(v<etil/rst)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Versing</conjf>.]</vmorph> <def>To tell in verse, or
poetry.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Playing on pipes of corn and <qex>versing</qex> love.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verse</ent><br/
<hw>Verse</hw>, <pos>v. i.</pos> <def>To make verses; to versify.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>It is not rhyming and <qex>versing</qex> that maketh a poet.</q>
<rj><qau>Sir P. Sidney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versed</ent><br/
<hw>Versed</hw> <pr>(v<etil/rst)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vers<eacute/</ets>, L. <ets>versatus</ets>, p. p. of
<ets>versari</ets> to turn about frequently, to turn over, to be engaged
in a thing, passive of <ets>versare</ets>. See <er>Versant</er>,
<pos>a.</pos>]</ety> <def>Acquainted or familiar, as the result of
experience, study, practice, etc.; skilled; practiced; knowledgeable;
expert.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Deep <qex>versed</qex> in books and shallow in himself.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Opinions . . . derived from studying the Scriptures, wherein he
was <qex>versed</qex> beyond any person of his age.</q>
<rj><qau>Southey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>These men were <qex>versed</qex> in the details of business.</q>
<rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versed</ent><br/
<hw>Versed</hw>, <pos>a.</pos> <ety>[L. <ets>versus</ets> turned, p. p.
<ets>vertere</ets>. See 1st <er>Versed</er>.]</ety> <fld>(Math.)</fld>
<def>Turned.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Versed sine</b></col>. <cd>See under <er>Sine</er>, and
<xex>Illust.</xex> of <er>Functions</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verseman</ent><br/
<hw>Verse"man</hw> <pr>(v<etil/rs"m<ait/n)</pr>, <pos>n.</pos> <def>Same
as <er>Versemonger</er>.</def> <rj><au>Prior.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versemonger</ent><br/
<hw>Verse"mon`ger</hw> <pr>(v<etil/rs"m<ucr/<nsm/`g<etil/r)</pr>,
<pos>n.</pos> <def>A writer of verses; especially, a writer of
commonplace poetry; a poetaster; a rhymer; -- used humorously or in
contempt.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verser</ent><br/
<hw>Vers"er</hw> <pr>(v<etil/rs"<etil/r)</pr>, <pos>n.</pos> <def>A
versifier.</def> <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verset</ent><br/
<hw>Vers"et</hw> <pr>(v<etil/rs"<ecr/t)</pr>, <pos>n.</pos>
<ety>[F.]</ety> <def>A verse.</def> <mark>[Obs.]</mark>
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versicle</ent><br/
<hw>Ver"si*cle</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>versiculus</ets>, dim. of <ets>versus</ets>. See
<er>Verse</er>.]</ety> <def>A little verse; especially, a short verse or
text said or sung in public worship by the priest or minister, and
followed by a response from the people.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The psalms were in number fifteen, . . . being digested into
<qex>versicles</qex>.</q> <rj><qau>Strype.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versicolored</ent><br/
<ent>Versicolor</ent><br/
<mhw>{ <hw>Ver"si*col`or</hw> <pr>(?)</pr>, <hw>Ver"si*col`ored</hw>
<pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>versicolor</ets>;
<ets>versare</ets> to change + <ets>color</ets> color.]</ety>
<def>Having various colors; changeable in color.</def>
<ldquo/<xex>Versicolor</xex>, sweet-smelling flowers.<rdquo/
<rj><au>Burton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versicular</ent><br/
<hw>Ver*sic"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Versicle</er>.]</ety> <def>Of or pertaining to verses; designating
distinct divisions of a writing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versification</ent><br/
<hw>Ver`si*fi*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>versificatio</ets>: cf. F. <ets>versification</ets>.]</ety>
<def>The act, art, or practice, of versifying, or making verses; the
construction of poetry; metrical composition.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versificator</ent><br/
<hw>Ver"si*fi*ca`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety>
<def>A versifier.</def> <mark>[R.]</mark> <ldquo/The best
<xex>versificator</xex> next Virgil.<rdquo/
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versifier</ent><br/
<hw>Ver"si*fi`er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One
who versifies, or makes verses; <as>as, not every <ex>versifier</ex> is
a poet</as>.</def> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who converts into verse; one who expresses in
verse the ideas of another written in prose; <as>as, Dr</as>. Watts was
a <xex>versifier</xex> of the Psalms.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versify</ent><br/
<hw>Ver"si*fy</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Versified</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Versifying</conjf> <pr>(?)</pr>.]</vmorph> <ety>[OE.
<ets>versifien</ets>, F. <ets>versifier</ets>, L.
<ets>versificare</ets>; <ets>versus</ets> a verse + <ets>-ficare</ets>
to make. See <er>Verse</er>, and <er>-fy</er>.]</ety> <def>To make
verses.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I'll <qex>versify</qex> in spite, and do my best.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versify</ent><br/
<hw>Ver"si*fy</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To relate or
describe in verse; to compose in verse.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I'll <qex>versify</qex> the truth, not poetize.</q>
<rj><qau>Daniel.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To turn into verse; to render into metrical form;
<as>as, to <ex>versify</ex> the Psalms</as>.</def>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Version</ent><br/
<hw>Ver"sion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., from L.
<ets>vertere</ets>, <ets>versum</ets>, to turn, to change, to translate.
See <er>Verse</er>.]</ety> <sn>1.</sn> <def>A change of form, direction,
or the like; transformation; conversion; turning.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>version</qex> of air into water.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <def>A condition of the uterus in which
its axis is deflected from its normal position without being bent upon
itself. See <er>Anteversion</er>, and <er>Retroversion</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The act of translating, or rendering, from one
language into another language.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A translation; that which is rendered from another
language; <as>as, the Common, or Authorized, <ex>Version</ex> of the
Scriptures (see under <er>Authorized</er>); the Septuagint
<ex>Version</ex> of the Old Testament</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>An account or description from a particular point of
view, especially as contrasted with another account; <as>as, he gave
another <ex>version</ex> of the affair</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versionist</ent><br/
<hw>Ver"sion*ist</hw>, <pos>n.</pos> <def>One who makes or favors a
version; a translator.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verso</ent><br/
<hw>Ver"so</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>versus</ets>,
p. p. of <ets>vertere</ets> to turn: cf. F. <ets>verso</ets>.]</ety>
<fld>(Print.)</fld> <def>The reverse, or left-hand, page of a book or a
folded sheet of paper; -- opposed to <ant>recto</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versor</ent><br/
<hw>Ver"sor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. L.
<ets>vertere</ets>, <ets>versus</ets>, to turn. See
<er>Version</er>.]</ety> <fld>(Geom.)</fld> <def>The turning factor of a
quaternion.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The change of one vector into another is considered in
quaternions as made up of two operations; 1st, the rotation of the first
vector so that it shall be parallel to the second; 2d, the change of
length so that the first vector shall be equal to the second. That which
expresses in amount and kind the first operation is a <xex>versor</xex>,
and is denoted geometrically by a line at right angles to the plane in
which the rotation takes place, the length of this line being
proportioned to the amount of rotation. That which expresses the second
operation is a <xex>tensor</xex>. The product of the versor and tensor
expresses the total operation, and is called a <xex>quaternion</xex>.
See <er>Quaternion</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quadrantal versor</b></col>. <cd>See under
<er>Quadrantal</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verst</ent><br/
<hw>Verst</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Russ.
<ets>versta</ets>: cf. F. <ets>verste</ets>.]</ety> <def>A Russian
measure of length containing 3,500 English feet.</def> <altsp>[Written
also <asp>werst</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versual</ent><br/
<hw>Ver"su*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to
a verse.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versus</ent><br/
\'d8<hw>Ver"sus</hw> <pr>(?)</pr>, <pos>prep.</pos> <ety>[L., toward,
turned in the direction of, from <ets>vertere</ets>, <ets>versum</ets>,
to turn. See <er>Verse</er>.]</ety> <def>Against; <as>as, John Doe
<ex>versus</ex> Richard Roe</as>; -- chiefly used in legal language, and
abbreviated to <abbr>v.</abbr> or <abbr>vs.</abbr></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Versute</ent><br/
<hw>Ver*sute"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>versutus</ets>, fr. <ets>vertere</ets>, <ets>versum</ets>, to
turn.]</ety> <def>Crafty; wily; cunning; artful.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vert</ent><br/
<hw>Vert</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., green, from L.
<ets>viridis</ets>. See <er>Verdant</er>, and cf. <er>Verd</er>.]</ety>
<sn>1.</sn> <fld>(Eng. Forest Law)</fld> <sd>(a)</sd> <def>Everything
that grows, and bears a green leaf, within the forest; <as>as, to
preserve <ex>vert</ex> and venison is the duty of the
verderer</as>.</def> <sd>(b)</sd> <def>The right or privilege of cutting
growing wood.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Her.)</fld> <def>The color green, represented in a
drawing or engraving by parallel lines sloping downward toward the
right.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verteber</ent><br/
<hw>Ver"te*ber</hw> <pr>(v<etil/r"t<esl/*b<etil/r)</pr>, <pos>n.</pos>
<def>A vertebra.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertebra</ent><br/
\'d8<hw>Ver"te*bra</hw> <pr>(v<etil/r"t<esl/*br<adot/)</pr>,
<pos>n.</pos>; <plu><it>pl.</it> <plw>Vertebrae</plw>
<pr>(#)</pr>.</plu> <ety>[L. <ets>vertebra</ets>, fr. <ets>vertere</ets>
to turn, change. See <er>Verse</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Anat.)</fld> <def>One of the serial segments of the
spinal column.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In many fishes the <xex>vertebrae</xex> are simple
cartilaginous disks or short cylinders, but in the higher vertebrates
they are composed of many parts, and the vertebrae in different portions
of the same column vary very greatly. A well-developed vertebra usually
consists of a more or less cylindrical and solid body, or
<xex>centrum</xex>, which is surmounted dorsally by an arch, leaving an
opening which forms a part of the canal containing the spinal cord. From
this dorsal, or neural, arch spring various processes, or
<xex>apophyses</xex>, which have received special names: a dorsal, or
neural, spine, <xex>spinous process</xex>, or <xex>neurapophysis</xex>,
on the middle of the arch; two anterior and two posterior <xex>articular
processes</xex>, or <xex>zygapophyses</xex>; and one or two
<xex>transverse processes</xex> on each side. In those vertebrae which
bear well-developed ribs, a tubercle near the end of the rib articulates
at a <xex>tubercular facet</xex> on the transverse process
(<xex>diapophysis</xex>), while the end, or head, of the rib articulates
at a more ventral <xex>capitular facet</xex> which is sometimes
developed into a second, or ventral, transverse process
(<xex>parapophysis</xex>). In vertebrates with well-developed hind
limbs, the spinal column is divided into five regions in each of which
the vertebrae are specially designated: those vertebrae in front of, or
anterior to, the first vertebra which bears ribs connected with the
sternum are <xex>cervical</xex>; all those which bear ribs and are back
of the cervicals are <xex>dorsal</xex>; the one or more directly
supporting the pelvis are sacral and form the sacrum; those between the
sacral and dorsal are <xex>lumbar</xex>; and all those back of the
sacral are <xex>caudal</xex>, or <xex>coccygeal</xex>. In man there are
seven cervical vertebrae, twelve dorsal, five lumbar, five sacral, and
usually four, but sometimes five and rarely three, coccygeal.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>One of the central ossicles in
each joint of the arms of an ophiuran.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1605 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertebral</ent><br/
<hw>Ver"te*bral</hw> <pr>(v<etil/r"t<esl/*br<ait/l)</pr>, <pos>a.</pos>
<ety>[Cf. F. <ets>vert<eacute/bral</ets>.]</ety> <sn>1.</sn>
<fld>(Anat.)</fld> <def>Of or pertaining to a vertebra, vertebrae, or
the vertebral column; spinal; rachidian.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Vertebrate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertebral</ent><br/
<hw>Ver"te*bral</hw>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A
vertebrate.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertebrally</ent><br/
<hw>Ver"te*bral*ly</hw>, <pos>adv.</pos> <fld>(Anat.)</fld> <def>At or
within a vertebra or vertebrae; -- distinguished from
<xex>interverterbrally</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertebrarterial</ent><br/
<hw>Ver`te*brar*te"ri*al</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Anat.)</fld> <def>Of or pertaining to a vertebra or vertebrae and
an artery; -- said of the foramina in the transverse processes of
cervical vertebrae and of the canal which they form for the vertebral
artery and vein.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertebrata</ent><br/
\'d8<hw>Ver`te*bra"ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos>
<ety>[NL.]</ety> <fld>(Zool.)</fld> <def>One of the grand divisions of
the animal kingdom, comprising all animals that have a backbone composed
of bony or cartilaginous vertebrae, together with Amphioxus in which the
backbone is represented by a simple undivided notochord. The Vertebrata
always have a dorsal, or neural, cavity above the notochord or backbone,
and a ventral, or visceral, cavity below it. The subdivisions or classes
of Vertebrata are Mammalia, Aves, Reptilia, Amphibia, Pisces,
Marsipobranchia, and Leptocardia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertebrate</ent><br/
<hw>Ver"te*brate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>One of the Vertebrata.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertebrated</ent><br/
<ent>Vertebrate</ent><br/
<mhw>{ <hw>Ver"te*brate</hw> <pr>(?)</pr>, <hw>Ver"te*bra`ted</hw>
<pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L.
<ets>vertebratus</ets>.]</ety> <sn>1.</sn> <fld>(Anat.)</fld>
<def>Having a backbone, or vertebral column, containing the spinal
marrow, as man, quadrupeds, birds, amphibia, and fishes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Contracted at intervals, so as to
resemble the spine in animals.</def> <rj><au>Henslow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>Having movable joints resembling
vertebrae; -- said of the arms of ophiurans.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>Of or pertaining to the
Vertebrata; -- used only in the form <ex>vertebrate</ex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertebre</ent><br/
<hw>Ver"te*bre</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Anat.)</fld>
<def>A vertebra.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertebro-</ent><br/
<hw>Ver"te*bro-</hw> <pr>(?)</pr>. <def>A combining form used in anatomy
to indicate <xex>connection with</xex>, or <xex>relation to</xex>,
<xex>a vertebra</xex>, <xex>vertebrae</xex>, or <xex>the vertebral
column</xex>; as in <ex>vertebro</ex>costal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertebro-iliac</ent><br/
<hw>Ver"te*bro-il"i*ac</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Anat.)</fld> <def>Iliolumbar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertex</ent><br/
<hw>Ver"tex</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> E.
<plw>Vertexes</plw> <pr>(#)</pr>, L. <plw>Vertices</plw>
<pr>(#)</pr>.</plu> <ety>[L. <ets>vertex</ets>, <ets>-icis</ets>, a
whirl, top of the head, top, summit, from <ets>vertere</ets> to turn.
See <er>Verse</er>, and cf. <er>Vortex</er>.]</ety> <def>A turning
point; the principal or highest point; top; summit; crown; apex.</def>
Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <fld>(Anat.)</fld> <def>The top, or crown, of the
head.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <fld>(Astron.)</fld> <def>The zenith, or the point of
the heavens directly overhead.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <fld>(Math.)</fld> <def>The point in any figure opposite
to, and farthest from, the base; the terminating point of some
particular line or lines in a figure or a curve; the top, or the point
opposite the base.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>principal vertex</xex> of a conic section is,
in the parabola, the vertex of the axis of the curve: in the ellipse,
either extremity of either axis, but usually the left-hand vertex of the
transverse axis; in the hyperbola, either vertex, but usually the
right-hand vertex of the transverse axis.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vertex of a curve</b></col> <fld>(Math.)</fld>, <cd>the
point in which the axis of the curve intersects it.</cd> --
<col><b>Vertex of an angle</b></col> <fld>(Math.)</fld>, <cd>the point
in which the sides of the angle meet.</cd> -- <mcol><col><b>Vertex of a
solid</b></col>, <it>or</it> <col><b>Vertex of a surface of
revolution</b></col></mcol> <fld>(Math.)</fld>, <cd>the point in which
the axis pierces the surface.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertical</ent><br/
<hw>Ver"ti*cal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vertical</ets>. See <er>Vertex</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Of or pertaining to the vertex; situated at the
vertex, or highest point; directly overhead, or in the zenith;
perpendicularly above one.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Charity . . . is the <qex>vertical</qex> top of all religion.</q>
<rj><qau>Jer. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Perpendicular to the plane of the horizon; upright;
plumb; <as>as, a <ex>vertical</ex> line</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vertical angle</b></col> <fld>(Astron. & Geod.)</fld>,
<cd>an angle measured on a vertical circle, called an angle of
<xex>elevation</xex>, or <xex>altitude</xex>, when reckoned from the
horizon upward, and of <xex>depression</xex> when downward below the
horizon.</cd> -- <col><b>Vertical anthers</b></col> <fld>(Bot.)</fld>,
<cd>such anthers as stand erect at the top of the filaments.</cd> --
<col><b>Vertical circle</b></col> <fld>(Astron.)</fld>, <cd>an azimuth
circle. See under <er>Azimuth</er>.</cd> -- <col><b>Vertical
drill</b></col>, <cd>an upright drill. See under <er>Upright</er>.</cd>
-- <col><b>Vertical fire</b></col> <fld>(Mil.)</fld>, <cd>the fire, as
of mortars, at high angles of elevation.</cd> -- <col><b>Vertical
leaves</b></col> <fld>(Bot.)</fld>, <cd>leaves which present their edges
to the earth and the sky, and their faces to the horizon, as in the
Australian species of Eucalyptus.</cd> -- <col><b>Vertical
limb</b></col>, <cd>a graduated arc attached to an instrument, as a
theodolite, for measuring vertical angles.</cd> -- <col><b>Vertical
line</b></col>. <sd>(a)</sd> <fld>(Dialing)</fld> <cd>A line
perpendicular to the horizon.</cd> <sd>(b)</sd> <fld>(Conic
Sections)</fld> <cd>A right line drawn on the vertical plane, and
passing through the vertex of the cone.</cd> <sd>(c)</sd>
<fld>(Surv.)</fld> <cd>The direction of a plumb line; a line normal to
the surface of still water.</cd> <sd>(d)</sd> <fld>(Geom., Drawing,
etc.)</fld> <cd>A line parallel to the sides of a page or sheet, in
distinction from a <xex>horizontal line</xex> parallel to the top or
bottom.</cd> -- <col><b>Vertical plane</b></col>. <sd>(a)</sd>
<fld>(Conic Sections)</fld> <cd>A plane passing through the vertex of a
cone, and through its axis.</cd> <sd>(b)</sd> <fld>(Projections)</fld>
<cd>Any plane which passes through a vertical line.</cd> <sd>(c)</sd>
<fld>(Persp.)</fld> <cd>The plane passing through the point of sight,
and perpendicular to the ground plane, and also to the picture.</cd> --
<col><b>Vertical sash</b></col>, <cd>a sash sliding up and down. Cf.
<cref>French sash</cref>, under 3d <er>Sash</er>.</cd> --
<col><b>Vertical steam engine</b></col>, <cd>a steam engine having the
crank shaft vertically above or below a vertical cylinder.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertical</ent><br/
<hw>Ver"ti*cal</hw>, <pos>n.</pos> <sn>1.</sn> <def>Vertical position;
zenith.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Math.)</fld> <def>A vertical line, plane, or
circle.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Prime vertical</b></col>, <col><b>Prime vertical
dial</b></col></mcol>. <cd>See under <er>Prime</er>,
<pos>a.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verticality</ent><br/
<hw>Ver`ti*cal"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being vertical; verticalness.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The different points of the <qex>verticality</qex>.</q>
<rj><qau>Sir T. Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertically</ent><br/
<hw>Ver"ti*cal*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a vertical
manner, position, or direction; perpendicularly; <as>as, to look down
<ex>vertically</ex>; to raise a thing
<ex>vertically</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verticalness</ent><br/
<hw>Ver"ti*cal*ness</hw>, <pos>n.</pos> <def>Quality or state of being
vertical.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verticil</ent><br/
<hw>Ver"ti*cil</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>verticillus</ets>, dim. of <ets>vertex</ets> a whirl: cf. F.
<ets>verticille</ets>. See <er>Vertex</er>.]</ety> <fld>(Bot.)</fld>
<def>A circle either of leaves or flowers about a stem at the same node;
a whorl.</def> <altsp>[Written also <asp>verticel</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verticillaster</ent><br/
<hw>Ver`ti*cil*las"ter</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[NL., fr.
L. <ets>verticillus</ets> a whirl + <ets>aster</ets> a star.]</ety>
<fld>(Bot.)</fld> <def>A whorl of flowers apparently of one cluster, but
composed of two opposite axillary cymes, as in mint. See
<xex>Illust.</xex> of <er>Whorl</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verticillated</ent><br/
<ent>Verticillate</ent><br/
<mhw>{ <hw>Ver*tic"il*late</hw> <pr>(?; 277)</pr>,
<hw>Ver*tic"il*la`ted</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[See
<er>Verticil</er>.]</ety> <fld>(Bot. & Zool.)</fld> <def>Arranged in a
transverse whorl or whorls like the rays of a wheel; <as>as,
<ex>verticillate</ex> leaves of a plant; a <ex>verticillate</ex>
shell</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verticillus</ent><br/
\'d8<hw>Ver`ti*cil"lus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a
whirl.]</ety> <fld>(Bot.)</fld> <def>A whorl; a verticil.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verticity</ent><br/
<hw>Ver*tic"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>verticit<eacute/</ets>. See <er>Vertex</er>.]</ety> <def>The
quality or power of turning; revolution; rotation.</def>
<mark>[R.]</mark> <rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I hardly believe he hath from elder times unknown the
<qex>verticity</qex> of the loadstone.</q> <rj><qau>Sir T.
Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verticle</ent><br/
<hw>Ver"ti*cle</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>verticula</ets> a joint.]</ety> <def>An axis; a hinge; a turning
point.</def> <rj><au>E. Waterhouse.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertiginate</ent><br/
<hw>Ver*tig"i*nate</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Turned round;
giddy.</def> <mark>[R.]</mark> <rj><au>Coleridge.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertiginous</ent><br/
<hw>Ver*tig"i*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vertiginosus</ets>, fr. <ets>vertigo</ets> a whirling around,
giddiness: cf. F. <ets>vertigineux</ets>. See <er>Vertigo</er>.]</ety>
<sn>1.</sn> <def>Turning round; whirling; rotary; revolving; <as>as, a
<ex>vertiginous</ex> motion</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Some <qex>vertiginous</qex> whirl of fortune.</q> <rj><qau>De
Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Affected with vertigo; giddy; dizzy.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They [the angels] grew <qex>vertiginous</qex>, and fell from the
battlements of heaven.</q> <rj><qau>Jer. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Ver*tig"i*nous*ly</wf>, <pos>adv.</pos> --
<wf>Ver*tig"i*nous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertigo</ent><br/
<hw>Ver"ti*go</hw> <pr>(?; 277)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
E. <plw>Vertigoes</plw> <pr>(#)</pr>, L. <plw>Vertigines</plw>
<pr>(#)</pr>.</plu> <ety>[L., fr. <ets>vertere</ets> to turn. See
<er>Verse</er>.]</ety> <sn>1.</sn> <fld>(Med.)</fld> <def>Dizziness or
swimming of the head; an affection of the head in which objects, though
stationary, appear to move in various directions, and the person
affected finds it difficult to maintain an erect posture;
giddiness.</def> <rj><au>Quain.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>Any one of numerous species of
small land snails belonging to the genus <gen>Vertigo</gen>, having an
elongated or conical spiral shell and usually teeth in the
aperture.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertilinear</ent><br/
<hw>Ver`ti*lin"e*ar</hw> <pr>(?)</pr>, <pos>a.</pos>
<ety>[<ets>Verti</ets>cal + <ets>linear</ets>.]</ety> <def>Straight;
rectilinear.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertu</ent><br/
<hw>Ver"tu</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>Virtue;
power. See <er>Virtue</er>.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>See <er>Virtu</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vertuous</ent><br/
<hw>Ver"tu*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Virtuous;
powerful.</def> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verumontanum</ent><br/
\'d8<hw>Ver`u*mon*ta"num</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[NL.]</ety> <fld>(Anat.)</fld> <def>An elevation, or crest, in the
wall of the urethra where the seminal ducts enter it.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This is sometimes written <altsp>veru
montanum</altsp>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vervain</ent><br/
<hw>Ver"vain</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>verveine</ets>, F. <ets>verveine</ets>, fr. L. <ets>verbena</ets>,
pl. <ets>verbenae</ets> sacred boughs of laurel, olive, or myrtle, a
class of plants; cf. <ets>verbenaca</ets> vervain. Cf.
<er>Verbena</er>.]</ety> <fld>(Bot.)</fld> <def>Any plant of the genus
<gen>Verbena</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vervain mallow</b></col> <fld>(Bot.)</fld>, <cd>a species
of mallow (<spn>Malva Alcea</spn>) with rose-colored
flowers.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Verve</ent><br/
\'d8<hw>Verve</hw>, <pos>n.</pos> <ety>[F.]</ety> <def>Excitement of
imagination such as animates a poet, artist, or musician, in composing
or performing; rapture; enthusiasm; spirit; energy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vervel</ent><br/
<hw>Ver"vel</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Varvel</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vervet</ent><br/
<hw>Ver"vet</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A
South African monkey (<spn>Cercopithecus pygerythrus</spn> syn.
<spn>Cercopithecus Lelandii</spn>). The upper parts are grayish green,
finely specked with black. The cheeks and belly are reddish
white.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Very</ent><br/
<hw>Ver"y</hw> <pr>(v<ecr/r"<ycr/)</pr>, <pos>a.</pos>
<amorph>[<pos>Compar.</pos> <adjf>Verier</adjf>
<pr>(v<ecr/r"<icr/*<etil/r)</pr>; <pos>superl.</pos>
<adjf>Veriest</adjf>.]</amorph> <ety>[OE. <ets>verai</ets>,
<ets>verray</ets>, OF. <ets>verai</ets>, <ets>vrai</ets>, F.
<ets>vrai</ets>, (assumed) LL. <ets>veracus</ets>, for L.
<ets>verax</ets> true, veracious, fr. <ets>verus</ets> true; akin to
OHG. & OS. <ets>w<amac/r</ets>, G. <ets>wahr</ets>, D. <ets>waar</ets>;
perhaps originally, that is or exists, and akin to E. <ets>was</ets>.
Cf. <er>Aver</er>, <pos>v. t.</pos>, <er>Veracious</er>,
<er>Verdict</er>, <er>Verity</er>.]</ety> <def>True; real; actual;
veritable.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Whether thou be my <qex>very</qex> son Esau or not.</q>
<rj><qau>Gen. xxvii. 21.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He that covereth a transgression seeketh love; but he that
repeateth a matter separateth <qex>very</qex> friends.</q>
<rj><qau>Prov. xvii. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>very</qex> essence of truth is plainness and
brightness.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I looked on the consideration of public service or public ornament
to be real and <qex>very</qex> justice.</q>
<rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Very</xex> is sometimes used to make the word with
which it is connected emphatic, and may then be paraphrased by
<xex>same</xex>, <xex>self-same</xex>, <xex>itself</xex>, and the like.
<ldquo/The <xex>very</xex> hand, the <xex>very</xex> words.<rdquo/
<au>Shak.</au> <ldquo/The <xex>very</xex> rats instinctively have quit
it.<rdquo/ <au>Shak.</au> <ldquo/Yea, there where <xex>very</xex>
desolation dwells.<rdquo/ <au>Milton.</au> <xex>Very</xex> is used
occasionally in the comparative degree, and more frequently in the
superlative. <ldquo/Was not my lord the <xex>verier</xex> wag of the
two?<rdquo/ <au>Shak.</au> <ldquo/The <xex>veriest</xex> hermit in the
nation.<rdquo/ <au>Pope.</au> <ldquo/He had spoken the very truth, and
transformed it into the <xex>veriest</xex> falsehood.<rdquo/
<au>Hawthorne.</au></note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Very Reverend</b></col>. <cd>See the Note under
<er>Reverend</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Very</ent><br/
<hw>Ver"y</hw> <pr>(v<ecr/r"<ycr/)</pr>, <pos>adv.</pos> <def>In a high
degree; to no small extent; exceedingly; excessively; extremely; <as>as,
a <ex>very</ex> great mountain; a <ex>very</ex> bright sun; a
<ex>very</ex> cold day; the river flows <ex>very</ex> rapidly; he was
<ex>very</ex> much hurt</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Very night signals</ent><br/
<ent>Very's night signals</ent><br/
<mhw>{ <hw>Ver"y's night signals</hw>, <it>or</it> <hw>Ver"y night
signals</hw> }</mhw> <pr>(?)</pr>. <ety>[After Lieut. <person>Samuel W.
<etsep>Very</etsep></person>, who invented the system in 1877.]</ety>
<fld>(Naut.)</fld> <def>A system of signaling in which balls of red and
green fire are fired from a pistol, the arrangement in groups denoting
numbers having a code significance. The pistol used to fire the signal
flare is called a <col><b>Very pistol</b></col>.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Vesbium</ent><br/
<hw>Ves"bi*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., from L.
<ets>Vesuvius</ets>, contr. <ets>Vesbius</ets>, Vesuvius.]</ety>
<fld>(Chem.)</fld> <def>A rare metallic element of which little is
known. It is said by Scacchi to have been extracted from a yellowish
incrustation from the cracks of a Vesuvian lava erupted in 1631.</def>
<note>It is not a recognized element. Actual identity?</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vese</ent><br/
<hw>Vese</hw> <pr>(v<emac/z)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Feese</er>, <pos>n.</pos>]</ety> <def>Onset; rush; violent draught
or wind.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesica</ent><br/
\'d8<hw>Ve*si"ca</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <def>A
bladder.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vesica piscis</b></col>. <ety>[L., fish bladder.]</ety>
<fld>(Eccl. Art)</fld> <cd>A glory, or aureole, of oval shape, or
composed of two arcs of circles usually represented as surrounding a
divine personage. More rarely, an oval composed of two arcs not
representing a glory; a solid oval, etc.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesical</ent><br/
<hw>Ves"i*cal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vesica</ets> bladder.]</ety> <fld>(Anat.)</fld> <def>Of or
pertaining to the bladder.</def> <rj><au>Dunglison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesicant</ent><br/
<hw>Ves"i*cant</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vesica</ets> blister: cf. F. <ets>v<eacute/sicant</ets>.]</ety>
<fld>(Med.)</fld> <def>A vesicatory.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesicate</ent><br/
<hw>Ves"i*cate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vesicated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vesicating</conjf>.]</vmorph> <ety>[See
<er>Vesicant</er>.]</ety> <fld>(Med.)</fld> <def>To raise little
bladders or blisters upon; to inflame and separate the cuticle of; to
blister.</def> <rj><au>Wiseman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesication</ent><br/
<hw>Ves`i*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>v<eacute/sication</ets>.]</ety> <fld>(Med.)</fld> <def>The process
of vesicating, or of raising blisters.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesicatory</ent><br/
<hw>Ves"i*ca*to*ry</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>v<eacute/sicatoire</ets>.]</ety> <fld>(Med.)</fld> <def>Tending, or
having power, to raise a blister.</def> -- <def2><pos>n.</pos> <def>A
blistering application or plaster; a vesicant; an
epispastic.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesicle</ent><br/
<hw>Ves"i*cle</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vesicula</ets>, dim. of <ets>vesica</ets> a bladder, blister; akin
to Skr. <ets>vasti</ets> bladder: cf. F.
<ets>v<eacute/sicule</ets>.]</ety> <def>A bladderlike vessel; a
membranous cavity; a cyst; a cell.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <fld>(Bot.)</fld> <def>A small bladderlike body in the
substance of a vegetable, or upon the surface of a leaf.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <fld>(Med.)</fld> <def>A small, and more or less
circular, elevation of the cuticle, containing a clear watery
fluid.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <fld>(Anat.)</fld> <def>A cavity or sac, especially one
filled with fluid; <as>as, the umbilical
<ex>vesicle</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <fld>(Zool.)</fld> <def>A small convex hollow prominence
on the surface of a shell or a coral.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(e)</sd> <fld>(Geol.)</fld> <def>A small cavity, nearly spherical
in form, and usually of the size of a pea or smaller, such as are common
in some volcanic rocks. They are produced by the liberation of watery
vapor in the molten mass.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesico-</ent><br/
<hw>Ves"i*co-</hw> <pr>(?)</pr>. <def>A combining form used in anatomy
to indicate <xex>connection with</xex>, or <xex>relation to</xex>,
<xex>the bladder</xex>; as in <xex>vesico</xex>prostatic,
<xex>vesico</xex>vaginal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesicoprostatic</ent><br/
<hw>Ves`i*co*pro*stat"ic</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Anat.)</fld> <def>Of or pertaining to the bladder and the prostate
gland.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesicouterine</ent><br/
<hw>Ves`i*co*u"ter*ine</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Anat.)</fld> <def>Of or pertaining to the bladder and the
uterus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesicovaginal</ent><br/
<hw>Ves`i*co*vag"i*nal</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Anat.)</fld> <def>Of or pertaining to the bladder and the
vagina.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesicula</ent><br/
\'d8<hw>Ve*sic"u*la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vesiculae</plw> .</plu> <ety>[L., dim. of <ets>vesica</ets>.]</ety>
<fld>(Anat. & Med.)</fld> <def>A vesicle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesicular</ent><br/
<hw>Ve*sic"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>v<eacute/siculaire</ets>.]</ety> <sn>1.</sn> <def>Of or pertaining
to vesicles; esp., of or pertaining to the air vesicles, or air cells,
of the lungs; <as>as, <ex>vesicular</ex> breathing, or normal breathing,
in which the air enters freely the air vesicles of the
lungs</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Containing, or composed of, vesicles or vesiclelike
structures; covered with vesicles or bladders; vesiculate; <as>as, a
<ex>vesicular</ex> coral; <ex>vesicular</ex> lava; a <ex>vesicular</ex>
leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Having the form or structure of a vesicle; <as>as, a
<ex>vesicular</ex> body</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vesicular column</b></col> <fld>(Anat.)</fld>, <cd>a
series of nerve cells forming one of the tracts distinguished in the
spinal cord; -- also called the <altname>ganglionic
column</altname>.</cd> -- <col><b>Vesicular emphysema</b></col>
<fld>(Med.)</fld>, <cd>emphysema of the lungs, in which the air vesicles
are distended and their walls ruptured.</cd> -- <col><b>Vesicular
murmur</b></col> <fld>(Med.)</fld>, <cd>the sound, audible on
auscultation of the chest, made by the air entering and leaving the air
vesicles of the lungs in respiration.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesicularia</ent><br/
\'d8<hw>Ve*sic`u*la"ri*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See
<er>Vesicle</er>.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous
species of marine Bryozoa belonging to <gen>Vesicularia</gen> and allied
genera. They have delicate tubular cells attached in clusters to slender
flexible stems.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesiculata</ent><br/
\'d8<hw>Ve*sic`u*la"ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL.
See <er>Vesicle</er>.]</ety> <fld>(Zool.)</fld> <def>The campanularian
medusae.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesiculate</ent><br/
<hw>Ve*sic"u*late</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Bladdery; full
of, or covered with, bladders; vesicular.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesiculate</ent><br/
<hw>Ve*sic"u*late</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To form
vesicles in, as lava.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesiculation</ent><br/
<hw>Ve*sic`u*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Geol.)</fld>
<def>The state of containing vesicles, or the process by which vesicles
are formed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesiculitis</ent><br/
\'d8<hw>Ve*sic`u*li"tis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.;
<ets>vesicula</ets> + <ets>-itis</ets>.]</ety> <def>Inflammation of a
vesicle.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vesiculous</ent><br/
<ent>Vesiculose</ent><br/
<mhw>{ <hw>Ve*sic"u*lose`</hw> <pr>(?)</pr>, <hw>Ve*sic"u*lous</hw>
<pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>vesiculosus</ets>: cf.
F. <ets>v<eacute/siculeux</ets>.]</ety> <def>Bladdery; vesicular;
vesiculate; composed of vesicles; covered with vesicles; <as>as, a
<ex>vesiculose</ex> shell</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vespa</ent><br/
\'d8<hw>Ves"pa</hw> <pr>(v<ecr/s"p<adot/)</pr>, <pos>prop. n.</pos>
<ety>[L., wasp.]</ety> <fld>(Zool.)</fld> <def>A genus of Hymenoptera
including the common wasps and hornets.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1606 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesper</ent><br/
<hw>Ves"per</hw> <pr>(v<ecr/s"p<etil/r)</pr>, <pos>n.</pos> <ety>[L.,
the evening, the evening star, the west; akin to Gr.
<grk>"e`speros</grk>, <grk>"espe`ra</grk>, and perhaps to E.
<ets>west</ets>. Cf. <er>Hesperian</er>, <er>Vespers</er>.]</ety>
<def>The evening star; Hesper; Venus, when seen after sunset; hence, the
evening.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesper</ent><br/
<hw>Ves"per</hw>, <pos>a.</pos> <def>Of or pertaining to the evening, or
to the service of vespers; <as>as, a <ex>vesper</ex> hymn;
<ex>vesper</ex> bells</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vesper sparrow</b></col>, <cd>the grass finch. See under
<er>Grass</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesperal</ent><br/
<hw>Ves"per*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Vesper;
evening.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vespers</ent><br/
<hw>Ves"pers</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[OF.
<ets>vespres</ets>, F. <ets>v<ecir/pres</ets>, LL. <ets>vesperae</ets>,
fr. L. <ets>vespera</ets> evening. See <er>Vesper</er>,
<pos>n.</pos>]</ety> <fld>(R. C. Ch.)</fld> <sd>(a)</sd> <def>One of the
little hours of the Breviary.</def> <sd>(b)</sd> <def>The evening song
or service.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Sicilian vespers</b></col>. <cd>See under
<er>Sicilian</er>, <pos>a.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vespertilio</ent><br/
\'d8<hw>Ves`per*til"i*o</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a
bat.]</ety> <fld>(Zool.)</fld> <def>A genus of bats including some of
the common small insectivorous species of North America and
Europe.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vespertiliones</ent><br/
<hw>Ves`per*til`i*o"nes</hw> <pr>(?)</pr>, <pos>n. pl.</pos>
<ety>[NL.]</ety> <fld>(Zool.)</fld> <def>A tribe of bats including the
common insectivorous bats of America and Europe, belonging to
<gen>Vespertilio</gen> and allied genera. They lack a nose
membrane.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vespertilionine</ent><br/
<hw>Ves`per*til`i*o"nine</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Zool.)</fld> <def>Of or pertaining to the
Vespertiliones.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vespertinal</ent><br/
<hw>Ves"per*ti`nal</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Vespertine.</def> <rj><au>Lowell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vespertine</ent><br/
<hw>Ves"per*tine</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vespertinus</ets>. See <er>Vesper</er>.]</ety> <sn>1.</sn> <def>Of
or pertaining to the evening; happening or being in the evening.</def>
<rj><au>Gray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Blossoming in the
evening.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vespiary</ent><br/
<hw>Ves"pi*a*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vespa</ets> a wasp.]</ety> <def>A nest, or habitation, of insects
of the wasp kind.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vespillo</ent><br/
<hw>Ves*pil"lo</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vespilloes</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <fld>(Rom.
Antiq.)</fld> <def>One who carried out the dead bodies of the poor at
night for burial.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Like <qex>vespilloes</qex> or grave makers.</q> <rj><qau>Sir T.
Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vessel</ent><br/
<hw>Ves"sel</hw>, <pos>n.</pos> <ety>[OF. <ets>vessel</ets>,
<ets>veissel</ets>, <ets>vaissel</ets>, <ets>vaissiel</ets>, F.
<ets>vaisseau</ets>, fr. L. <ets>vascellum</ets>, dim. of
<ets>vasculum</ets>, dim. of <ets>vas</ets> a vessel. Cf.
<er>Vascular</er>, <er>Vase</er>.]</ety> <sn>1.</sn> <def>A hollow or
concave utensil for holding anything; a hollow receptacle of any kind,
as a hogshead, a barrel, a firkin, a bottle, a kettle, a cup, a bowl,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[They drank] out of these noble <qex>vessels</qex>.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A general name for any hollow structure made to
float upon the water for purposes of navigation; especially, one that is
larger than a common rowboat; <as>as, a war <ex>vessel</ex>; a passenger
<ex>vessel</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>[He] began to build a <qex>vessel</qex> of huge bulk.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Fig.: A person regarded as receiving or containing
something; esp. <fld>(Script.)</fld>, one into whom something is
conceived as poured, or in whom something is stored for use; <as>as,
<ex>vessels</ex> of wrath or mercy</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He is a chosen <qex>vessel</qex> unto me.</q> <rj><qau>Acts ix.
15.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>[The serpent] fit <qex>vessel</qex>, fittest imp of fraud, in
whom<br/
To enter.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Anat.)</fld> <def>Any tube or canal in which the
blood or other fluids are contained, secreted, or circulated, as the
arteries, veins, lymphatics, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Bot.)</fld> <def>A continuous tube formed from
superposed large cylindrical or prismatic cells (tracheae), which have
lost their intervening partitions, and are usually marked with dots,
pits, rings, or spirals by internal deposition of secondary membranes; a
duct.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Acoustic vessels</b></col>. <cd>See under
<er>Acoustic</er>.</cd> -- <col><b>Weaker vessel</b></col>, <cd>a woman;
-- now applied humorously.</cd> <ldquo/Giving honor unto the wife, as
unto the <xex>weaker vessel</xex>.<rdquo/ <au>1 Peter iii. 7.</au>
<ldquo/You are the <xex>weaker vessel</xex>.<rdquo/
<rj><au>Shak.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vessel</ent><br/
<hw>Ves"sel</hw>, <pos>v. t.</pos> <def>To put into a vessel.</def>
<mark>[Obs.]</mark> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesselful</ent><br/
<hw>Ves"sel*ful</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vesselfuls</plw> <pr>(<?/)</pr>.</plu> <def>As much as a vessel
will hold; enough to fill a vessel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vessets</ent><br/
<ent>Vesses</ent><br/
<mhw>{ <hw>Ves"ses</hw> <pr>(?)</pr>, <hw>Ves"sets</hw> <pr>(?)</pr>,
}</mhw> <pos>n.</pos> <def>A kind of worsted; also, a worsted
cloth.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vessignon</ent><br/
<ent>Vessicnon</ent><br/
<mhw>{ <hw>Ves"sic*non</hw> <pr>(?)</pr>, <hw>Ves"sig*non</hw>
<pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[F. <ets>vessigon</ets>, fr. L.
<ets>vesica</ets> a bladder, blister.]</ety> <fld>(Far.)</fld> <def>A
soft swelling on a horse's leg; a windgall.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vest</ent><br/
<hw>Vest</hw> <pr>(v<ecr/st)</pr>, <pos>n.</pos> <ety>[L.
<ets>vestis</ets> a garment, vesture; akin to Goth. <ets>wasti</ets>,
and E. <ets>wear</ets>: cf. F. <ets>veste</ets>. See <er>Wear</er> to
carry on the person, and cf. <er>Divest</er>, <er>Invest</er>,
<er>Travesty</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>An article of clothing covering the person; an outer
garment; a vestment; a dress; a vesture; a robe.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In state attended by her maiden train,<br/
Who bore the <qex>vests</qex> that holy rites require.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any outer covering; array; garb.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Not seldom clothed in radiant <qex>vest</qex><br/
Deceitfully goes forth the morn.</q> <rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Specifically, a waistcoat, or sleeveless body
garment, for men, worn under the coat.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Garment; vesture; dress; robe; vestment;
waistcoat.</syn> <usage> -- <er>Vest</er>, <er>Waistcoat</er>. In
England, the original word <xex>waistcoat</xex> is generally used for
the body garment worn over the shirt and immediately under the coat. In
the United States this garment is commonly called a <xex>vest</xex>, and
the <xex>waistcoat</xex> is often improperly given to an
under-garment.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vest</ent><br/
<hw>Vest</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Vested</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Vesting</conjf>.]</vmorph> <ety>[Cf. L. <ets>vestire</ets>,
<ets>vestitum</ets>, OF. <ets>vestir</ets>, F. <ets>v<ecir/tir</ets>.
See <er>Vest</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>To clothe with,
or as with, a vestment, or garment; to dress; to robe; to cover,
surround, or encompass closely.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Came <qex>vested</qex> all in white, pure as her mind.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>With ether <qex>vested</qex>, and a purple sky.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To clothe with authority, power, or the like; to put
in possession; to invest; to furnish; to endow; -- followed by
<xex>with</xex> before the thing conferred; <as>as, to <ex>vest</ex> a
court with power to try cases of life and death</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Had I been <qex>vested</qex> with the monarch's power.</q>
<rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To place or give into the possession or discretion
of some person or authority; to commit to another; -- with <xex>in</xex>
before the possessor; <as>as, the power of life and death is
<ex>vested</ex> in the king, or in the courts</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Empire and dominion was [were] <qex>vested</qex> in him.</q>
<rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To invest; to put; <as>as, to <ex>vest</ex> money in
goods, land, or houses</as>.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Law)</fld> <def>To clothe with possession; <as>as,
to <ex>vest</ex> a person with an estate</as>; also, to give a person an
immediate fixed right of present or future enjoyment of; <as>as, an
estate is <ex>vested</ex> in possession</as>.</def>
<rj><au>Bouvier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vest</ent><br/
<hw>Vest</hw> <pr>(v<ecr/st)</pr>, <pos>v. i.</pos> <def>To come or
descend; to be fixed; to take effect, as a title or right; -- followed
by <xex>in</xex>; <as>as, upon the death of the ancestor, the estate, or
the right to the estate, <ex>vests</ex> in the heir at
law</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesta</ent><br/
<hw>Ves"ta</hw> <pr>(v<ecr/s"t<adot/)</pr>, <pos>n.</pos> <ety>[L.
<ets>Vesta</ets>, akin to Gr. <grk>"Esti`a</grk> Vesta,
<grk>"esti`a</grk> the hearth of the house, and perhaps to Skr.
<ets>ush</ets> to burn (see <ets>East</ets>), or perhaps to Skr.
<ets>vas</ets> to dwell, and E. <ets>was</ets>.]</ety> <sn>1.</sn>
<fld>(Rom. Myth.)</fld> <def>One of the great divinities of the ancient
Romans, identical with the Greek <persfn><it>Hestia</it></persfn>. She
was a virgin, and the goddess of the hearth; hence, also, of the fire on
it, and the family round it.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Astron.)</fld> <def>An asteroid, or minor planet,
discovered by <persfn>Olbers</persfn> in 1807.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A wax friction match.</def>
<rj><au>Simmonds.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestal</ent><br/
<hw>Ves"tal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>Vestalis</ets> belonging to Vesta, vestal. See
<er>Vesta</er>.]</ety> <def>Of or pertaining to Vesta, the virgin
goddess of the hearth; hence, pure; chaste.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestal</ent><br/
<hw>Ves"tal</hw>, <pos>n.</pos> <ety>[L. <ets>Vestalis</ets> (sc.
<ets>virgo</ets>): cf. F. <ets>vestale</ets>. See <er>Vestal</er>,
<pos>a.</pos>]</ety> <sn>1.</sn> <fld>(Rom. Antiq.)</fld> <def>A virgin
consecrated to Vesta, and to the service of watching the sacred fire,
which was to be perpetually kept burning upon her altar.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>Vestals</xex> were originally four, but
afterward six, in number. Their term of service lasted thirty years, the
period of admission being from the sixth to the tenth year of the
candidate's age.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A virgin; a woman pure and chaste; also, a
nun.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>How happy is the blameless <qex>vestal's</qex> lot!</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestales</ent><br/
\'d8<hw>Ves*ta"les</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See
<er>Vestal</er>.]</ety> <fld>(Zool.)</fld> <def>A group of butterflies
including those known as virgins, or gossamer-winged
butterflies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vested</ent><br/
<hw>Vest"ed</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Clothed;
robed; wearing vestments.</def> <ldquo/The <xex>vested</xex>
priest.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>Not in a state of contingency or
suspension; fixed; <as>as, <ex>vested</ex> rights; <ex>vested</ex>
interests</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vested legacy</b></col> <fld>(Law)</fld>, <cd>a legacy
the right to which commences <xex>in praesenti</xex>, and does not
depend on a contingency; as, a legacy to one to be paid when he attains
to twenty-one years of age is a <xex>vested legacy</xex>, and if the
legatee dies before the testator, his representative shall receive
it.</cd> <au>Blackstone.</au> -- <col><b>Vested remainder</b></col>
<fld>(Law)</fld>, <cd>an estate settled, to remain to a determined
person, after the particular estate is spent.</cd> <au>Blackstone.</au>
<au>Kent.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vested interest</ent><br/
<hw>Vest"ed interest</hw>. <sn>1.</sn> <def>a special personal interest,
usually financial, in an existing system, law, or institution, which
hinders a person from making objective decisions regarding that system,
law, or institution. A vested interest may be one which benefits a
relative, or, in an extended sense, one which defends a person's own
reputation or previously expressed views.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>a right given to an employee by a pension plan,
which cannot be taken away.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <pluf>pl.</pluf> <def>the persons, corporations, or other
groups which benefit most (usually financially) from the existing system
of institutions, laws, and customs.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vested school</ent><br/
<hw>Vest"ed school</hw>. <def>In Ireland, a national school which has
been built by the aid of grants from the board of Commissioners of
National Education and is secured for educational purposes by leases to
the commissioners themselves, or to the commissioners and the
trustees.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vestiarian</ent><br/
<hw>Ves`ti*a"ri*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Vestiary</er>.]</ety> <def>Of or pertaining to a vestiary or
vestments.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestiary</ent><br/
<hw>Ves"ti*a*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vestiarium</ets>. See <er>Vestry</er>.]</ety> <def>A wardrobe; a
robing room; a vestry.</def> <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestiary</ent><br/
<hw>Ves"ti*a*ry</hw>, <pos>a.</pos> <def>Pertaining to clothes, or
vestments.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestibular</ent><br/
<hw>Ves*tib"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to a vestibule; like a vestibule.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestibule</ent><br/
<hw>Ves"ti*bule</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vestibulum</ets>, of uncertain origin: cf. F.
<ets>vestibule</ets>.]</ety> <def>The porch or entrance into a house; a
hall or antechamber next the entrance; a lobby; a porch; a
hall.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vestibule of the ear</b></col>. <fld>(Anat.)</fld>
<cd>See under <er>Ear</er>.</cd> -- <col><b>Vestibule of the
vulva</b></col> <fld>(Anat.)</fld>, <cd>a triangular space between the
nymphae, in which the orifice of the urethra is situated.</cd> --
<col><b>Vestibule train</b></col> <fld>(Railroads)</fld>, <cd>a train of
passenger cars having the space between the end doors of adjacent cars
inclosed, so as to admit of leaving the doors open to provide for
intercommunication between all the cars.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Hall; passage.</syn> <usage> --
<er>Vestibule</er>, <er>Hall</er>, <er>Passage</er>. A
<xex>vestibule</xex> is a small apartment within the doors of a
building. A <xex>hall</xex> is the first large apartment beyond the
vestibule, and, in the United States, is often long and narrow, serving
as a passage to the several apartments. In England, the <xex>hall</xex>
is generally square or oblong, and a long, narrow space of entrance is
called a <xex>passage</xex>, not a <xex>hall</xex>, as in America.
<xex>Vestibule</xex> is often used in a figurative sense to denote a
place of entrance. <ldquo/The citizens of Rome placed the images of
their ancestors in the <xex>vestibules</xex> of their houses.<rdquo/
<au>Bolingbroke</au></usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestibule</ent><br/
<hw>Ves"ti*bule</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To furnish with
a vestibule or vestibules.</def> <rj><au>Brander Matthews.</au></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vestibuled train</ent><br/
<hw>Vestibuled train</hw>. <fld>(Railroad)</fld> <def>Same as
<cref>Vestibule train</cref>, under <er>Vestibule</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vestibulum</ent><br/
\'d8<hw>Ves*tib"u*lum</hw> <pr>(?)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Vestibula</plw> <pr>(#)</pr>.</plu> <ety>[L.,
vestibule.]</ety> <fld>(Zool.)</fld> <def>A cavity into which, in
certain bryozoans, the esophagus and anus open.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestigate</ent><br/
<hw>Ves"ti*gate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L.
<ets>vestigatus</ets>, p. p. of <ets>vestigare</ets>. See
<er>Vestige</er>.]</ety> <def>To investigate.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestige</ent><br/
<hw>Ves"tige</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., from L.
<ets>vestigium</ets> footprint, trace, sign; the last part
(<ets>-stigium</ets>) is probably akin to E. <ets>sty</ets>, v. i. Cf.
<er>Investigate</er>.]</ety> <sn>1.</sn> <def>The mark of the foot left
on the earth; a track or footstep; a trace; a sign; hence, a faint mark
or visible sign left by something which is lost, or has perished, or is
no longer present; remains; <as>as, the <ex>vestiges</ex> of ancient
magnificence in Palmyra; <ex>vestiges</ex> of former
population</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>What <qex>vestiges</qex> of liberty or property have they
left?</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Ridicule has followed the <qex>vestiges</qex> of Truth, but never
usurped her place.</q> <rj><qau>Landor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Biol.)</fld> <def>A small, degenerate, or
imperfectly developed part or organ which has been more fully developed
in some past generation.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><syn><b>Syn.</b> -- Trace; mark; sign; token.</syn> <usage> --
<er>Vestige</er>, <er>Trace</er>. These words agree in marking some
indications of the past, but differ to some extent in their use and
application. <xex>Vestige</xex> is used chiefly in a figurative sense,
for the remains of something long passed away; <as>as, the
<ex>vestiges</ex> of ancient times; <ex>vestiges</ex> of the
creation</as>. A <xex>trace</xex> is literally something drawn out in a
line, and may be used in this its primary sense, or figuratively, to
denote a sign or evidence left by something that has passed by, or
ceased to exist. <xex>Vestige</xex> usually supposes some definite
object of the past to be left behind; while a <xex>trace</xex> may be a
mere indication that something has been present or is present; <as>as,
<ex>traces</ex> of former population; a <ex>trace</ex> of poison in a
given substance</as>.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestigial</ent><br/
<hw>Ves*tig"i*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to a vestige or remnant; like a vestige.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesting</ent><br/
<hw>Vest"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Cloth for vests; a
vest pattern.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestiture</ent><br/
<hw>Ves"ti*ture</hw> <pr>(?; 135)</pr>, <pos>n.</pos> <ety>[See
<er>Vesture</er>.]</ety> <def>Investiture.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestlet</ent><br/
<hw>Vest"let</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Dim. of
<ets>vest</ets>.]</ety> <fld>(Zool.)</fld> <def>Any one of several
species of actinians belonging to the genus <gen>Cerianthus</gen>. These
animals have a long, smooth body tapering to the base, and two separate
circles of tentacles around the mouth. They form a tough, flexible,
feltlike tube with a smooth internal lining, in which they dwell, whence
the name.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestment</ent><br/
<hw>Vest"ment</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vestement</ets>, <ets>vestiment</ets>, OF. <ets>vestement</ets>,
<ets>vestiment</ets>, F. <ets>v<ecir/tement</ets>, fr. L.
<ets>vestimentum</ets>, fr. <ets>vestire</ets> to clothe, fr.
<ets>vestis</ets> a garment, clothing. See <er>Vest</er>.]</ety> <def>A
covering or garment; some part of clothing or dress</def>; specifically
<fld>(Eccl.)</fld>, <def>any priestly garment.</def> <ldquo/Royal
<xex>vestiment</xex>.<rdquo/ <au>Chaucer.</au> <ldquo/Priests in holy
<xex>vestments</xex>.<rdquo/ <au>Shak.</au><br/
[<source>1913 Webster</source>]</p>

<p><q> The sculptor could not give <qex>vestments</qex> suitable to the
quality of the persons represented.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestry</ent><br/
<hw>Ves"try</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vestries</plw> <pr>(#)</pr>.</plu> <ety>[OE. <ets>vestrye</ets>, F.
<ets>vestiaire</ets>, L. <ets>vestiarium</ets>, fr.
<ets>vestiarius</ets> belonging to clothes, fr. <ets>vestis</ets> a
garment. See <er>Vest</er>, <pos>n.</pos>, and cf.
<er>Vestiary</er>.]</ety> <sn>1.</sn> <def>A room appendant to a church,
in which sacerdotal vestments and sacred utensils are sometimes kept,
and where meetings for worship or parish business are held; a sacristy;
-- formerly called <xex>revestiary</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He said unto him that was over the <qex>vestry</qex>, Bring forth
vestments for all the worshipers of Baal.</q> <rj><qau>2 Kings x.
22.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Ch. of Eng.)</fld> <def>A parochial assembly; an
assembly of persons who manage parochial affairs; -- so called because
usually held in a vestry.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Prot. Epis. Ch.)</fld> <def>A body, composed of
wardens and vestrymen, chosen annually by a parish to manage its
temporal concerns.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Metropolitan vestry</b></col>, <cd>in the city of London,
and certain specified parishes and places in England, a body composed of
householders who pay poor rates. Its duties include the repair of
churches, care of highways, the appointment of certain officers,
etc.</cd> -- <col><b>Select vestry</b></col>, <cd>a select number of
persons chosen in large and populous English parishes to represent and
manage the concerns of the parish for one year.</cd> <au>Mozley &
W.</au> -- <col><b>Vestry board</b></col> <fld>(Ch. of Eng.)</fld>,
<cd>a vestry. See def. 2, above.</cd> -- <col><b>Vestry clerk</b></col>,
<cd>an officer chosen by the vestry, who keeps a record of its
proceedings; also, in England, one who keeps the parish accounts and
books.</cd> -- <col><b>Vestry meeting</b></col>, <cd>the meeting of a
vestry or vestry board; also, a meeting of a parish held in a vestry or
other place.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestryman</ent><br/
<hw>Ves"try*man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vestrymen</plw> <pr>(<?/)</pr>.</plu> <def>A member of a vestry;
especially <fld>(Prot. Epis. Ch.)</fld>, a member other than a warden.
See <er>Vestry</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesture</ent><br/
<hw>Ves"ture</hw> <pr>(?; 135)</pr>, <pos>n.</pos> <ety>[OF.
<ets>vesture</ets>, <ets>vesteure</ets>, F. <ets>v<ecir/ture</ets>, LL.
<ets>vestitura</ets>, from L. <ets>vestire</ets> to clothe, dress. See
<er>Vest</er>, <pos>v. t.</pos>, and cf. <er>Vestiture</er>.]</ety>
<sn>1.</sn> <def>A garment or garments; a robe; clothing; dress;
apparel; vestment; covering; envelope.</def> <rj><au>Piers
Plowman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Approach, and kiss her sacred <qex>vesture's</qex> hem.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Rocks, precipices, and gulfs, appareled with a <qex>vesture</qex>
of plants.</q> <rj><qau>Bentley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>There polished chests embroidered <qex>vestures</qex> graced.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(O. Eng. Law)</fld> <sd>(a)</sd> <def>The corn,
grass, underwood, stubble, etc., with which land was covered; <as>as,
the <ex>vesture</ex> of an acre</as>.</def> <sd>(b)</sd> <def>Seizin;
possession.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vestured</ent><br/
<hw>Ves"tured</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Covered with vesture
or garments; clothed; enveloped.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We be <qex>vestured</qex> with poor cloth.</q> <rj><qau>Ld.
Berners.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesuvian</ent><br/
<hw>Ve*su"vi*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>V<eacute/suvien</ets>, It. <ets>Vesuviano</ets>.]</ety> <def>Of or
pertaining to Vesuvius, a volcano near <city>Naples</city>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesuvian</ent><br/
<hw>Ve*su"vi*an</hw>, <pos>n.</pos> <ety>[G. <ets>vesuvian</ets>. See
<er>Vesuvian</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <fld>(Min.)</fld>
<def>Vesuvianite.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A kind of match or fusee for lighting cigars,
etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vesuvianite</ent><br/
<hw>Ve*su"vi*an*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Min.)</fld>
<def>A mineral occurring in tetragonal crystals, and also massive, of a
brown to green color, rarely sulphur yellow and blue. It is a silicate
of alumina and lime with some iron magnesia, and is common at Vesuvius.
Also called <altname>idocrase</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vesuvine</ent><br/
<hw>Ve*su"vine</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A trade name for a
brown dyestuff obtained from certain basic azo compounds of benzene; --
called also <altname>Bismarck brown</altname>, <altname>Manchester
brown</altname>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vetch</ent><br/
<hw>Vetch</hw> <pr>(v<ecr/ch)</pr>, <pos>n.</pos> <ety>[Also
<ets>fitch</ets>; OE. <ets>ficche</ets>, <ets>feche</ets>, for
<ets>veche</ets>, OF. <ets>veche</ets>, <ets>vecce</ets>,
<ets>vesche</ets>, <ets>vesce</ets>, F. <ets>vesce</ets>, fr. L.
<ets>vicia</ets>.]</ety> <fld>(Bot.)</fld> <def>Any leguminous plant of
the genus <gen>Vicia</gen>, some species of which are valuable for
fodder. The common species is <spn>Vicia sativa</spn>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The name is also applied to many other leguminous plants
of different genera; as the chichling vetch, of the genus
<gen>Lathyrus</gen>; the horse vetch, of the genus
<gen>Hippocrepis</gen>; the kidney vetch (<spn>Anthyllis
vulneraria</spn>); the milk vetch, of the genus <gen>Astragalus</gen>;
the licorice vetch, or wild licorice (<spn>Abrus
precatorius</spn>).</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vetchling</ent><br/
<hw>Vetch"ling</hw> <pr>(v<ecr/ch"l<icr/ng)</pr>, <pos>n.</pos>
<ety>[<ets>Vetch</ets> + <ets>-ling</ets>.]</ety> <fld>(Bot.)</fld>
<def>Any small leguminous plant of the genus <gen>Lathyrus</gen>,
especially <spn>Lathyrus Nissolia</spn>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vetchy</ent><br/
<hw>Vetch"y</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Consisting
of vetches or of pea straw.</def> <ldquo/A <xex>vetchy</xex> bed.<rdquo/
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Abounding with vetches.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veteran</ent><br/
<hw>Vet"er*an</hw> <pr>(v<ecr/t"<etil/r*<ait/n)</pr>, <pos>a.</pos>
<ety>[L. <ets>veteranus</ets>, from <ets>vetus</ets>,
<ets>veteris</ets>, old; akin to Gr. <grk>'e`tos</grk> year, Skr.
<ets>vatsara</ets>. See <er>Wether</er>.]</ety> <def>Long exercised in
anything, especially in military life and the duties of a soldier; long
practiced or experienced; <as>as, a <ex>veteran</ex> officer or soldier;
<ex>veteran</ex> skill.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The insinuating eloquence and delicate flattery of
<qex>veteran</qex> diplomatists and courtiers.</q>
<rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1607 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veteran</ent><br/
<hw>Vet"er*an</hw> <pr>(v<ecr/t"<etil/r*<ait/n)</pr>, <pos>n.</pos>
<ety>[L. <ets>veteranus</ets> (sc. <ets>miles</ets>): cf. F.
<ets>v<eacute/t<eacute/ran</ets>.]</ety> <def>One who has been long
exercised in any service or art, particularly in war; one who has had
much experience, or has grown old or decrepit in service.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ensigns that pierced the foe's remotest lines,<br/
The hardy <qex>veteran</qex> with tears resigns.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the United States, during the civil war, soldiers who
had served through one term of enlistment and had reenlisted were
specifically designated <xex>veterans</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veteranize</ent><br/
<hw>Vet"er*an*ize</hw> <pr>(v<ecr/t"<etil/r*<ait/n*<imac/z)</pr>,
<pos>v. i.</pos> <def>To reenlist for service as a soldier.</def>
<mark>[U. S.]</mark> <rj><au>Gen. W. T. Sherman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>veterinarian</ent><br/
<hw>vet`er*i*na"ri*an</hw>
<pr>(v<ecr/t`<etil/r*<icr/*n<amac/"r<icr/*<ait/n)</pr>, <pos>n.</pos>
<ety>[L. <ets>veterinarius</ets>. See <er>Veterinary</er>.]</ety>
<def>One skilled in the treatment of diseases of cattle or domestic
animals; a veterinary surgeon. Often abbreviated to
<altname>vet</altname>.</def><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><ent>Veterinary</ent><br/
<hw>Vet"er*i*na*ry</hw> <pr>(v<ecr/t"<etil/r*<icr/*n<asl/*r<ycr/)</pr>,
<pos>a.</pos> <ety>[L. <ets>veterinarius</ets> of or belonging to beasts
of burden and draught, fr. <ets>veterinus</ets>, probably originally, of
or pertaining to yearlings: cf. F. <ets>v<eacute/t<eacute/rinaire</ets>.
See <er>Veteran</er>, <er>Wether</er>.]</ety> <def>Of or pertaining to
the art of healing or treating the diseases of domestic animals, as
oxen, horses, sheep, various pets, etc.; <as>as, a <ex>veterinary</ex>
writer or school</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vetiver</ent><br/
<hw>Vet"i*ver</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>An
East Indian grass (<spn>Andropogon muricatus</spn>); also, its fragrant
roots which are much used for making mats and screens. Also called
<altname>kuskus</altname>, and <altname>khuskhus</altname>.</def>
<altsp>[Sometimes written <asp>vetivert</asp>, and
<asp>vitivert</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veto</ent><br/
<hw>Ve"to</hw> <pr>(v<emac/"t<osl/)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Vetoes</plw> <pr>(v<emac/"t<omac/z)</pr>.</plu>
<ety>[L. <ets>veto</ets> I forbid.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>An authoritative prohibition or negative; a
forbidding; an interdiction.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This contemptuous <qex>veto</qex> of her husband's on any intimacy
with her family.</q> <rj><qau>G. Eliot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>A power or right possessed by one department of
government to forbid or prohibit the carrying out of projects attempted
by another department; especially, in a constitutional government, a
power vested in the chief executive to prevent the enactment of measures
passed by the legislature. Such a power may be absolute, as in the case
of the Tribunes of the People in ancient Rome, or limited, as in the
case of the President of the United States. Called also <altname>the
veto power</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>The exercise of such authority; an act of
prohibition or prevention; <as>as, a <ex>veto</ex> is probable if the
bill passes</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>A document or message communicating the reasons of
the executive for not officially approving a proposed law; -- called
also <altname>veto message</altname>.</def> <mark>[U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Veto</xex> is not a term employed in the Federal
Constitution, but seems to be of popular use only.
<au>Abbott.</au></note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Veto</ent><br/
<hw>Ve"to</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Vetoed</conjf> <pr>(v<emac/"t<omac/d)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vetoing</conjf>.]</vmorph> <def>To prohibit; to
negative; also, to refuse assent to, as a legislative bill, and thus
prevent its enactment; <as>as, to <ex>veto</ex> an appropriation
bill</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vetoist</ent><br/
<hw>Ve"to*ist</hw>, <pos>n.</pos> <def>One who uses, or sustains the use
of, the veto.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vettura</ent><br/
\'d8<hw>Vet*tu"ra</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vetture</plw> <pr>(#)</pr>.</plu> <ety>[It. <ets>vettura</ets>, fr.
L. <ets>vectura</ets> conveyance. Cf. <er>Vecture</er>.]</ety> <def>An
Italian four-wheeled carriage, esp. one let for hire; a hackney
coach.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vetturino</ent><br/
\'d8<hw>Vet`tu*ri"no</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vetturini</plw> <pr>(#)</pr>.</plu> <ety>[It.]</ety> <sn>1.</sn>
<def>One who lets or drives a vettura.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A vettura.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vetust</ent><br/
<hw>Ve*tust"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vetustus</ets> old, ancient.]</ety> <def>Venerable from antiquity;
ancient; old.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vex</ent><br/
<hw>Vex</hw> <pr>(v<ecr/ks)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vexed</conjf> <pr>(v<ecr/kst)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vexing</conjf>.]</vmorph> <ety>[F. <ets>vexer</ets>, L.
<ets>vexare</ets>, <ets>vexatum</ets>, to vex, originally, to shake,
toss, in carrying, v. intens. fr. <ets>vehere</ets>, <ets>vectum</ets>,
to carry. See <er>Vehicle</er>.]</ety> <sn>1.</sn> <def>To toss back and
forth; to agitate; to disquiet.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>White curl the waves, and the <qex>vexed</qex> ocean roars.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To make angry or annoyed by little provocations; to
irritate; to plague; to torment; to harass; to afflict; to trouble; to
tease.</def> <ldquo/I will not <xex>vex</xex> your souls.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Ten thousand torments <qex>vex</qex> my heart.</q>
<rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To twist; to weave.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Some English wool, <qex>vexed</qex> in a Belgian loom.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- See <er>Tease</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vex</ent><br/
<hw>Vex</hw>, <pos>v. i.</pos> <def>To be irritated; to fret.</def>
<mark>[R.]</mark> <rj><au>Chapman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vexation</ent><br/
<hw>Vex*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vexatio</ets>: cf. F. <ets>vexation</ets>.]</ety> <sn>1.</sn>
<def>The act of vexing, or the state of being vexed; agitation;
disquiet; trouble; irritation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Passions too violent . . . afford us nothing but
<qex>vexation</qex> and pain.</q> <rj><qau>Sir W. Temple.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Those who saw him after a defeat looked in vain for any trace of
<qex>vexation</qex>.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The cause of trouble or disquiet;
affliction.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Your children were <qex>vexation</qex> to your youth.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A harassing by process of law; a vexing or
troubling, as by a malicious suit.</def> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Chagrin; agitation; mortification; uneasiness;
trouble; grief; sorrow; distress. See <er>Chagrin</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vexatious</ent><br/
<hw>Vex*a"tious</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Vexation</er>.]</ety> <sn>1.</sn> <def>Causing vexation; agitating;
afflictive; annoying; <as>as, a <ex>vexatious</ex> controversy; a
<ex>vexatious</ex> neighbor</as>.</def> <ldquo/Continual
<xex>vexatious</xex> wars.<rdquo/ <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Full of vexation, trouble, or disquiet;
disturbed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He leads a <qex>vexatious</qex> life.</q> <rj><qau>Sir K.
Digby.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vexatious suit</b></col> <fld>(Law)</fld>, <cd>a suit
commenced for the purpose of giving trouble, or without
cause.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vex*a"tious*ly</wf>, <pos>adv.</pos> --
<wf>Vex*a"tious*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vexed</ent><br/
<hw>Vexed</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Annoyed;
harassed; troubled.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Much debated or contested; causing discussion;
<as>as, a <ex>vexed</ex> question</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vexer</ent><br/
<hw>Vex"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who vexes or
troubles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vexil</ent><br/
<hw>Vex"il</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A vexillum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vexillary</ent><br/
<ent>Vexillar</ent><br/
<mhw>{ <hw>Vex"il*lar</hw> <pr>(?)</pr>, <hw>Vex"il*la*ry</hw>
<pr>(?)</pr>, }</mhw><ety>[Cf. F. <ets>vexillaire</ets>, L.
<ets>vexillarius</ets> a standard bearer.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Of or pertaining to an ensign or standard.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Of or pertaining to the vexillum,
or upper petal of papilionaceous flowers.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vexilary aestivation</b></col> <fld>(Bot.)</fld>, <cd>a
mode of aestivation in which one large upper petal folds over, and
covers, the other smaller petals, as in most papilionaceous
plants.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vexillary</ent><br/
<hw>Vex"il*la*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vexillarius</ets>: cf. F. <ets>vexillaire</ets>.]</ety> <def>A
standard bearer.</def> <rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vexillation</ent><br/
<hw>Vex`il*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vexillatio</ets>.]</ety> <fld>(Rom. Antiq.)</fld> <def>A company of
troops under one vexillum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vexillum</ent><br/
\'d8<hw>Vex*il"lum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vexilla</plw> <pr>(#)</pr>.</plu> <ety>[L., a standard, a
flag.]</ety> <sn>1.</sn> <fld>(Rom. Antiq.)</fld> <sd>(a)</sd> <def>A
flag or standard.</def> <sd>(b)</sd> <def>A company of troops serving
under one standard.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Eccl.)</fld> <sd>(a)</sd> <def>A banner.</def>
<sd>(b)</sd> <def>The sign of the cross.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Bot.)</fld> <def>The upper petal of a
papilionaceous flower; the standard.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>The rhachis and web of a feather
taken together; the vane.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vexingly</ent><br/
<hw>Vex"ing*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a vexing
manner; so as to vex, tease, or irritate.</def>
<rj><au>Tatler.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>V hook</ent><br/
<hw>V" hook`</hw> <pr>(?)</pr>. <fld>(Steam Engine)</fld> <def>A gab at
the end of an eccentric rod, with long jaws, shaped like the letter
<universbold>V.</universbold></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Via</ent><br/
\'d8<hw>Vi"a</hw> <pr>(v<imac/"<adot/ <it>or</it> v<emac/"<adot/)</pr>,
<pos>n.</pos> <ety>[L. See <er>Way</er>.]</ety> <def>A road or
way.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Via Lactea</b></col> <ety>[L.]</ety>
<fld>(Astron.)</fld>, <cd>the Milky Way, or Galaxy. See <er>Galaxy</er>,
1.</cd> -- <col><b>Via media</b></col> <ety>[L.]</ety>
<fld>(Theol.)</fld>, <cd>the middle way; -- a name applied to their own
position by the Anglican high-churchmen, as being between the Roman
Catholic Church and what they term extreme Protestantism.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Via</ent><br/
<hw>Vi"a</hw>, <pos>prep.</pos> <ety>[L., ablative of <ets>via</ets>
way. See <er>Way</er>.]</ety> <def>By the way of; <as>as, to send a
letter <ex>via</ex> Queenstown to London</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viability</ent><br/
<hw>Vi`a*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being viable.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <fld>(Law)</fld> <def>The capacity of living after
birth.</def> <rj><au>Bouvier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>The capacity of living, or being distributed, over
wide geographical limits; <as>as, the <ex>viability</ex> of a
species</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viable</ent><br/
<hw>Vi"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F., from
<ets>vie</ets> life, L. <ets>vita</ets>. See <er>Vital</er>.]</ety>
<fld>(Law)</fld> <def>Capable of living; born alive and with such form
and development of organs as to be capable of living; -- said of a
newborn, or a prematurely born, infant.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>VIABLE</qex>, Vitae habilis, capable of living. This is said
of a child who is born alive in such an advanced state of formation as
to be capable of living. Unless be is born <qex>viable</qex> he acquires
no rights and cannot transmit them to his heirs, and is considered as if
he had never been born.</q> <rj><qau>Bouvier (Law Dictionary,
1856).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viaduct</ent><br/
<hw>Vi`a*duct</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>via</ets> a
way + <ets>-duct</ets>, as in <ets>aqueduct</ets>: cf. F.
<ets>viaduc</ets>. See <er>Via</er>, and <er>Aqueduct</er>.]</ety>
<def>A structure of considerable magnitude, usually with arches or
supported on trestles, for carrying a road, as a railroad, high above
the ground or water; a bridge; especially, one for crossing a valley or
a gorge. Cf. <er>Trestlework</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viage</ent><br/
<hw>Vi"age</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Voyage</er>.]</ety> <def>A voyage; a journey.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer. Gower.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vial</ent><br/
<hw>Vi"al</hw> <pr>(v<imac/"<ait/l)</pr>, <pos>n.</pos> <ety>[OE.
<ets>viole</ets>, <ets>fiole</ets>, F. <ets>fiole</ets>. See
<er>Phial</er>.]</ety> <def>A small bottle, usually of glass; a little
glass vessel with a narrow aperture intended to be closed with a
stopper; <as>as, a <ex>vial</ex> of medicine</as>.</def> <altsp>[Written
also <asp>phial</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><q>Take thou this <qex>vial</qex>, being then in bed,<br/
And this distilled liquor drink thou off.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vial</ent><br/
<hw>Vi"al</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Vialed</conjf> <pr>(?)</pr> or <conjf>Vialled</conjf>; <pos>p.
pr. & vb. n.</pos> <conjf>Vialing</conjf> or
<conjf>Vialling</conjf>.]</vmorph> <def>To put in a vial or vials.</def>
<ldquo/Precious <xex>vialed</xex> liquors.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viameter</ent><br/
<hw>Vi*am"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>via</ets>
a way + <ets>-meter</ets>.]</ety> <def>An odometer; -- called also
<altname>viatometer</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viand</ent><br/
<hw>Vi"and</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>viande</ets>
meat, food, LL. <ets>vianda</ets>, <ets>vivanda</ets>,
<ets>vivenda</ets>, properly, things to live on, fr. L.
<ets>vivere</ets> to live; akin to <ets>vivus</ets> living. See
<er>Vivid</er>, and cf. <er>Victuals</er>.]</ety> <def>An article of
food; provisions; food; victuals; -- used chiefly in the plural.</def>
<rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Viands</qex> of various kinds allure the taste.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viander</ent><br/
<hw>Vi"and*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A feeder; an eater;
also, one who provides viands, or food; a host.</def>
<mark>[Obs.]</mark> <rj><au>Holinshed.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vi-apple</ent><br/
<hw>Vi"-ap`ple</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Otaheite
apple</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viary</ent><br/
<hw>Vi"a*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>viarius</ets>, fr. <ets>via</ets> a way, road.]</ety> <def>Of or
pertaining to roads; happening on roads.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viatecture</ent><br/
<hw>Vi"a*tec`ture</hw> <pr>(?; 135)</pr>, <pos>n.</pos> <ety>[L.
<ets>via</ets> way + <ets>-tecture</ets>, as in
<ets>architecture</ets>.]</ety> <def>The art of making roads or ways for
traveling, including the construction of bridges, canals, viaducts,
etc.</def> <mark>[R.]</mark> <rj><au>R. Park.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viatic</ent><br/
<hw>Vi*at"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>viaticus</ets>, fr. <ets>via</ets> a way. See
<er>Voyage</er>.]</ety> <def>Of or pertaining to a journey or
traveling.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viaticum</ent><br/
<hw>Vi*at"i*cum</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., from
<ets>viaticus</ets>, a. See <er>Viatic</er>.]</ety> <sn>1.</sn>
<fld>(Rom. Antiq.)</fld> <def>An allowance for traveling expenses made
to those who were sent into the provinces to exercise any office or
perform any service.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Provisions for a journey.</def> <rj><au>Davies
(Wit's Pilgr.).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(R. C. Ch.)</fld> <def>The communion, or eucharist,
when given to persons in danger of death.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viatometer</ent><br/
<hw>Vi`a*tom"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A
viameter.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibices</ent><br/
\'d8<hw>Vi*bi"ces</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[L., pl. of
<ets>vibex</ets>, <ets>-icis</ets>, the mark of a blow.]</ety>
<fld>(Med.)</fld> <def>More or less extensive patches of subcutaneous
extravasation of blood.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibraculum</ent><br/
\'d8<hw>Vi*brac"u*lum</hw> <pr>(?)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Vibracula</plw> <pr>(#)</pr>.</plu> <ety>[NL.,
dim. from L. <ets>vibrare</ets> to vibrate.]</ety> <fld>(Zool.)</fld>
<def>One of the movable, slender, spinelike organs or parts with which
certain bryozoans are furnished. They are regarded as specially modified
zooids, of nearly the same nature as Avicularia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibrancy</ent><br/
<hw>Vi"bran*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state of being
vibrant; resonance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibrant</ent><br/
<hw>Vi"brant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vibrans</ets>, p. pr.: cf. F. <ets>vibrant</ets>. See
<er>Vibrate</er>.]</ety> <def>Vibrating; tremulous; resonant; <as>as,
<ex>vibrant</ex> drums</as>.</def> <rj><au>Longfellow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibrate</ent><br/
<hw>Vi"brate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Vibrated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vibrating</conjf>.]</vmorph> <ety>[L.
<ets>vibratus</ets>, p. p. of <ets>vibrare</ets>, v. t. & v. i., to
shake, brandish, vibrate; akin to Skr. <ets>vip</ets> to tremble, Icel.
<ets>veifa</ets> to wave, vibrate. See <er>Waive</er> and cf.
<er>Whip</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>To brandish; to
move to and fro; to swing; <as>as, to <ex>vibrate</ex> a sword or a
staff</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To mark or measure by moving to and fro; <as>as, a
pendulum <ex>vibrating</ex> seconds</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To affect with vibratory motion; to set in
vibration.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Breath vocalized, that is, <qex>vibrated</qex> or undulated, may .
. . impress a swift, tremulous motion.</q>
<rj><qau>Holder.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Star to star <qex>vibrates</qex> light.</q>
<rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibrate</ent><br/
<hw>Vi"brate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>To
move to and fro, or from side to side, as a pendulum, an elastic rod, or
a stretched string, when disturbed from its position of rest; to swing;
to oscillate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To have the constituent particles move to and fro,
with alternate compression and dilation of parts, as the air, or any
elastic body; to quiver.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To produce an oscillating or quivering effect of
sound; <as>as, a whisper <ex>vibrates</ex> on the ear</as>.</def>
<rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To pass from one state to another; to waver; to
fluctuate; <as>as, a man <ex>vibrates</ex> between two
opinions</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibratile</ent><br/
<hw>Vi"bra*tile</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vibratile</ets>.]</ety> <def>Adapted to, or used in, vibratory
motion; having the power of vibrating; vibratory; <as>as, the
<ex>vibratile</ex> organs of insects</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibratility</ent><br/
<hw>Vi`bra*til"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vibratilit<eacute/</ets>.]</ety> <def>The quality or state of being
vibratile; disposition to vibration or oscillation.</def>
<rj><au>Rush.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibration</ent><br/
<hw>Vi*bra"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vibratio</ets>: cf. F. <ets>vibration</ets>.]</ety> <sn>1.</sn>
<def>The act of vibrating, or the state of being vibrated, or in
vibratory motion; quick motion to and fro; oscillation, as of a pendulum
or musical string.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>As a harper lays his open palm<br/
Upon his harp, to deaden its <qex>vibrations</qex>.</q>
<rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Physics)</fld> <def>A limited reciprocating motion
of a particle of an elastic body or medium in alternately opposite
directions from its position of equilibrium, when that equilibrium has
been disturbed, as when a stretched cord or other body produces musical
notes, or particles of air transmit sounds to the ear. The path of the
particle may be in a straight line, in a circular arc, or in any curve
whatever.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Vibration</xex> and <xex>oscillation</xex> are both
used, in mechanics, of the swinging, or rising and falling, motion of a
suspended or balanced body; the latter term more appropriately, as
signifying such motion produced by gravity, and of any degree of
slowness, while the former applies especially to the quick, short motion
to and fro which results from elasticity, or the action of molecular
forces among the particles of a body when disturbed from their position
of rest, as in a spring.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Amplitude of vibration</b></col>, <cd>the maximum
displacement of a vibrating particle or body from its position of
rest.</cd> -- <col><b>Phase of vibration</b></col>, <cd>any part of the
path described by a particle or body in making a complete vibration, in
distinction from other parts, as while moving from one extreme to the
other, or on one side of the line of rest, in distinction from the
opposite. Two particles are said to be in the same <xex>phase</xex> when
they are moving in the same direction and with the same velocity, or in
corresponding parts of their paths.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibratiuncle</ent><br/
<hw>Vi*bra"ti*un`cle</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Dim. of
<ets>vibration</ets>.]</ety> <def>A small vibration.</def>
<mark>[R.]</mark> <rj><au>Chambers.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibrative</ent><br/
<hw>Vi"bra*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Vibrating;
vibratory.</def> <ldquo/A <xex>vibrative</xex> motion.<rdquo/
<rj><au>Sir I. Newton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibrator</ent><br/
<hw>Vi"bra*tor</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One that vibrates,
or causes vibration or oscillation of any kind;</def>
<specif>specif.</specif> <sd>(a)</sd> <fld>(Elec.)</fld> (1) <def>A
trembler, as of an electric bell.</def> (2) <def>A vibrating reed for
transmitting or receiving pulsating currents in a harmonic telegraph
system.</def> (3) <def>A device for vibrating the pen of a siphon
recorder to diminish frictional resistance on the paper.</def> (4)
<def>An oscillator.</def> <sd>(b)</sd> <def>An ink-distributing roller
in a printing machine, having an additional vibratory motion.</def>
<sd>(a)</sd> <fld>(Music)</fld> <def>A vibrating reed, esp. in a reed
organ.</def> <sd>(d)</sd> <fld>(Weaving)</fld> <def>Any of various
vibrating devices, as one for slackening the warp as a shed opens.</def>
<sd>(e)</sd> <def>An attachment, usually pneumatic, in a molding machine
to shake the pattern loose.</def> <sd>(f)</sd> <def>a small electrical
device held in the hand, with a motor that causes the device and hand to
vibrate, and is used for vibratory massage.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Vibratory</ent><br/
<hw>Vi"bra*to*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vibratoire</ets>.]</ety> <def>Consisting in, or causing, vibration,
or oscillation; vibrating; <as>as, a <ex>vibratory</ex> motion; a
<ex>vibratory</ex> power</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibrio</ent><br/
\'d8<hw>Vib"ri*o</hw> <pr>(?)</pr>, <pos>prop. n.</pos>;
<plu><it>pl.</it> E. <plw>Vibrios</plw> <pr>(#)</pr>, L.
<plw>Vibriones</plw> <pr>(#)</pr>.</plu> <ety>[NL., fr. L.
<ets>vibrare</ets> to vibrate, to move by undulations.]</ety>
<fld>(Biol.)</fld> <def>A genus of motile bacteria characterized by
short, slightly sinuous filaments and an undulatory motion; also, an
individual of this genus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibrissa</ent><br/
\'d8<hw>Vi*bris"sa</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vibrissae</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>vibrissae</ets>,
pl., the hairs in the nostrils of man, fr. <ets>vibrare</ets> to
vibrate; -- so called because touching them tickles a person, and causes
him to shake his head.]</ety> <sn>1.</sn> <fld>(Anat.)</fld> <def>One of
the specialized or tactile hairs which grow about the nostrils, or on
other parts of the face, in many animals, as the so-called whiskers of
the cat, and the hairs of the nostrils of man.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The bristlelike feathers near the
mouth of many birds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vibrograph</ent><br/
<hw>Vi"bro*graph</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Vibrate</ets> + <ets>-graph</ets>.]</ety> <def>An instrument
to observe and record vibrations.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vibroscope</ent><br/
<hw>Vi"bro*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>An
instrument for observing or tracing vibrations.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An instrument resembling the
phenakistoscope.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viburnum</ent><br/
\'d8<hw>Vi*bur"num</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., the
wayfaring tree.]</ety> <fld>(Bot.)</fld> <def>A genus of shrubs having
opposite, petiolate leaves and cymose flowers, several species of which
are cultivated as ornamental plants, as the laurestine and the
guelder-rose.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicar</ent><br/
<hw>Vic"ar</hw> <pr>(v<icr/k"<etil/r)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vicar</ets>, <ets>viker</ets>, <ets>vicair</ets>, F.
<ets>vicaire</ets>, fr. L. <ets>vicarius</ets>. See
<er>Vicarious</er>.]</ety> <sn>1.</sn> <def>One deputed or authorized to
perform the functions of another; a substitute in office; a
deputy.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Eng. Eccl. Law)</fld> <def>The incumbent of an
appropriated benefice.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The distinction between a <xex>parson</xex> [or
<xex>rector</xex>] and <xex>vicar</xex> is this: The <xex>parson</xex>
has, for the most part, the whole right to the ecclesiastical dues in
his parish; but a <xex>vicar</xex> has generally an appropriator over
him, entitled to the best part of the profits, to whom he is in fact
perpetual curate with a standing salary. <rj><au>Burrill.</au></rj>
</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Apostolic vicar</b></col>, <it>or</it>
<col><b>Vicar apostolic</b></col></mcol>. <fld>(R. C. Ch.)</fld>
<sd>(a)</sd> <cd>A bishop to whom the Roman pontiff delegates a portion
of his jurisdiction.</cd> <sd>(b)</sd> <cd>Any ecclesiastic acting under
a papal brief, commissioned to exercise episcopal authority.</cd>
<sd>(c)</sd> <cd>A titular bishop in a country where there is no
episcopal see, or where the succession has been interrupted.</cd> --
<col><b>Vicar forane</b></col>. <ety>[Cf. LL. <ets>foraneus</ets>
situated outside of the episcopal city, rural. See <er>Vicar</er>, and
<er>Foreign</er>.]</ety> <fld>(R. C. Ch.)</fld> <cd>A dignitary or
parish priest appointed by a bishop to exercise a limited jurisdiction
in a particular town or district of a diocese.</cd> <au>Addis &
Arnold.</au> -- <col><b>Vicar-general</b></col>. <sd>(a)</sd> <fld>(Ch.
of Eng.)</fld> <cd>The deputy of the <person>Archbishop of
Canterbury</person> or York, in whose court the bishops of the province
are confirmed.</cd> <au>Encyc. Brit.</au> <sd>(b)</sd> <fld>(R. C.
Ch.)</fld> <cd>An assistant to a bishop in the discharge of his official
functions.</cd> -- <col><b>Vicar of Jesus Christ</b></col> <fld>(R. C.
Ch.)</fld>, <cd>the pope as representing Christ on earth.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1608 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicarage</ent><br/
<hw>Vic"ar*age</hw> <pr>(v<icr/k"<etil/r*<asl/j; 48)</pr>, <pos>n.</pos>
<sn>1.</sn> <def>The benefice of a vicar.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The house or residence of a vicar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicarial</ent><br/
<hw>Vi*ca"ri*al</hw> <pr>(v<isl/*k<amac/"<icr/*<ait/l)</pr>,
<pos>a.</pos> <ety>[Cf. F. <ets>vicarial</ets>.]</ety> <sn>1.</sn>
<def>Of or pertaining to a vicar; <as>as, <ex>vicarial</ex>
tithes</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Delegated; vicarious; <as>as, <ex>vicarial</ex>
power</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicarian</ent><br/
<hw>Vi*ca"ri*an</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A vicar.</def>
<mark>[Obs.]</mark> <rj><au>Marston.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicariate</ent><br/
<hw>Vi*ca"ri*ate</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having delegated
power, as a vicar; vicarious.</def> <rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicariate</ent><br/
<hw>Vi*ca"ri*ate</hw>, <pos>n.</pos> <ety>[LL. <ets>vicariatus</ets>, or
F. <ets>vicariat</ets>.]</ety> <def>Delegated office or power;
vicarship; the office or oversight of a vicar.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>vicariate</qex> of that part of Germany which is governed
by the Saxon laws devolved on the elector of Saxony.</q>
<rj><qau>Robertson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicarious</ent><br/
<hw>Vi*ca"ri*ous</hw> <pr>(v<isl/*k<amac/"<icr/*<ucr/s)</pr>,
<pos>a.</pos> <ety>[L. <ets>vicarius</ets>, from <ets>vicis</ets>
change, alternation, turn, the position, place, or office of one person
as assumed by another; akin to Gr. <grk>e'i`kein</grk> to yield, give
way, G. <ets>wechsel</ets> a change, and probably also to E.
<ets>weak</ets>. See <er>Weak</er>, and cf. <er>Vice</er>,
<pos>prep.</pos>]</ety> <sn>1.</sn> <def>Of or pertaining to a vicar,
substitute, or deputy; deputed; delegated; <as>as, <ex>vicarious</ex>
power or authority</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Acting or suffering for another; <as>as, a
<ex>vicarious</ex> agent or officer</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The soul in the body is but a subordinate efficient, and
<qex>vicarious</qex> . . . in the hands of the Almighty.</q>
<rj><qau>Sir M. Hale.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Performed ,experienced, or suffered in the place of
another; substituted; <as>as, a <ex>vicarious</ex> sacrifice;
<ex>vicarious</ex> punishment; <ex>vicarious</ex>
pleasure</as>.</def><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><q>The <qex>vicarious</qex> work of the Great Deliverer.</q>
<rj><qau>I. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Med.)</fld> <def>Acting as a substitute; -- said of
abnormal action which replaces a suppressed normal function; <as>as,
<ex>vicarious</ex> hemorrhage replacing menstruation</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicariously</ent><br/
<hw>Vi*ca"ri*ous*ly</hw>, <pos>adv.</pos> <def>In a vicarious
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicarship</ent><br/
<hw>Vic"ar*ship</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The office or
dignity of a vicar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicary</ent><br/
<hw>Vic"ar*y</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vicarius</ets>.]</ety> <def>A vicar.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vice</ent><br/
<hw>Vice</hw> <pr>(v<imac/s)</pr>, <pos>n.</pos> <ety>[F., from L.
<ets>vitium</ets>.]</ety> <sn>1.</sn> <def>A defect; a fault; an error;
a blemish; an imperfection; <as>as, the <ex>vices</ex> of a political
constitution; the <ex>vices</ex> of a horse</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Withouten <qex>vice</qex> of syllable or letter.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Mark the <qex>vice</qex> of the procedure.</q> <rj><qau>Sir W.
Hamilton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A moral fault or failing; especially, immoral
conduct or habit, as in the indulgence of degrading appetites; customary
deviation in a single respect, or in general, from a right standard,
implying a defect of natural character, or the result of training and
habits; a harmful custom; immorality; depravity; wickedness; <as>as, a
life of <ex>vice</ex>; the <ex>vice</ex> of intemperance.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>I do confess the <qex>vices</qex> of my blood.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Ungoverned appetite . . . a brutish <qex>vice</qex>.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>When <qex>vice</qex> prevails, and impious men bear sway,<br/
The post of honor is a private station.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The buffoon of the old English moralities, or moral
dramas, having the name sometimes of one vice, sometimes of another, or
of <xex>Vice</xex> itself; -- called also
<altname>Iniquity</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This character was grotesquely dressed in a cap with
ass's ears, and was armed with a dagger of lath: one of his chief
employments was to make sport with the Devil, leaping on his back, and
belaboring him with the dagger of lath till he made him roar. The Devil,
however, always carried him off in the end.</note>
<rj><au>Nares.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>How like you the <qex>Vice</qex> in the play?<br/
. . . I would not give a rush for a <qex>Vice</qex> that has not a
wooden dagger to snap at everybody.</q> <rj><qau>B.
Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Crime; sin; iniquity; fault. See
<er>Crime</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vice</ent><br/
<hw>Vice</hw>, <pos>n.</pos> <ety>[See <er>Vise</er>.]</ety> <sn>1.</sn>
<fld>(Mech.)</fld> <def>A kind of instrument for holding work, as in
filing. Same as <er>Vise</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A tool for drawing lead into cames, or flat grooved
rods, for casements.</def> <altsp>[Written also
<asp>vise</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A gripe or grasp.</def> <mark>[Obs.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vice</ent><br/
<hw>Vice</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Viced</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vicing</conjf> <pr>(?)</pr>.]</vmorph> <def>To hold or squeeze
with a vice, or as if with a vice.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The coachman's hand was <qex>viced</qex> between his upper and
lower thigh.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vice</ent><br/
\'d8<hw>Vi"ce</hw> <pr>(?)</pr>, <pos>prep.</pos> <ety>[L., abl. of
<ets>vicis</ets> change, turn. See <er>Vicarious</er>.]</ety> <def>In
the place of; in the stead; <as>as, A. B. was appointed postmaster
<ex>vice</ex> C. D. resigned</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vice</ent><br/
<hw>Vice</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>vice-</ets>.
See <er>Vice</er>, <pos>prep.</pos>]</ety> <def>Denoting one who in
certain cases may assume the office or duties of a superior; designating
an officer or an office that is second in rank or authority; <as>as,
<ex>vice</ex> president; <ex>vice</ex> agent; <ex>vice</ex> consul,
etc</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vice admiral</b></col>. <ety>[Cf. F.
<ets>vice-amiral</ets>.]</ety> <sd>(a)</sd> <cd>An officer holding rank
next below an admiral. By the existing laws, the rank of admiral and
vice admiral in the United States Navy will cease at the death of the
present incumbents.</cd> <sd>(b)</sd> <cd>A civil officer, in Great
Britain, appointed by the lords commissioners of the admiralty for
exercising admiralty jurisdiction within their respective
districts.</cd> -- <col><b>Vice admiralty</b></col>, <cd>the office of a
vice admiral.</cd> -- <col><b>Vice-admiralty court</b></col>, <cd>a
court with admiralty jurisdiction, established by authority of
Parliament in British possessions beyond the seas.</cd> <au>Abbott.</au>
-- <col><b>Vice chamberlain</b></col>, <cd>an officer in court next in
rank to the lord chamberlain.</cd> <mark>[Eng.]</mark> -- <col><b>Vice
chancellor</b></col>. <sd>(a)</sd> <fld>(Law)</fld> <cd>An officer next
in rank to a chancellor.</cd> <sd>(b)</sd> <cd>An officer in a
university, chosen to perform certain duties, as the conferring of
degrees, in the absence of the chancellor.</cd> <sd>(c)</sd> <fld>(R. C.
Ch.)</fld> <cd>The cardinal at the head of the Roman Chancery.</cd> --
<col><b>Vice consul</b></col> <ety>[cf. F.
<ets>vice-consul</ets>]</ety>, <cd>a subordinate officer, authorized to
exercise consular functions in some particular part of a district
controlled by a consul.</cd> -- <col><b>Vice king</b></col>, <cd>one who
acts in the place of a king; a viceroy.</cd> -- <col><b>Vice
legate</b></col> <ety>[cf. F. <ets>vice-l<eacute/gat</ets>]</ety>, <cd>a
legate second in rank to, or acting in place of, another legate.</cd> --
<col><b>Vice presidency</b></col>, <cd>the office of vice
president.</cd> -- <col><b>Vice president</b></col> <ety>[cf. F.
<ets>vice-pr<eacute/sident</ets>]</ety>, <cd>an officer next in rank
below a president.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viced</ent><br/
<hw>Viced</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Vicious; corrupt.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicegerency</ent><br/
<hw>Vice*ge"ren*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The office of a
vicegerent.</def> <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicegerent</ent><br/
<hw>Vice*ge"rent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Vice</ets>,
a. + <ets>gerent</ets>: cf. F. <ets>vice-g<eacute/rant</ets>.]</ety>
<def>Having or exercising delegated power; acting by substitution, or in
the place of another.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicegerent</ent><br/
<hw>Vice*ge"rent</hw>, <pos>n.</pos> <def>An officer who is deputed by a
superior, or by proper authority, to exercise the powers of another; a
lieutenant; a vicar.</def> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The symbol and <qex>vicegerent</qex> of the Deity.</q> <rj><qau>C.
A. Young.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viceman</ent><br/
<hw>Vice"man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vicemen</plw> <pr>(<?/)</pr>.</plu> <def>A smith who works at the
vice instead of at the anvil.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicenary</ent><br/
<hw>Vic"e*na*ry</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>vicenarius</ets>, fr. <ets>viceni</ets> twenty each; akin to
<ets>viginti</ets> twenty.]</ety> <def>Of or pertaining to twenty;
consisting of twenty.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicennial</ent><br/
<hw>Vi*cen"ni*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vicennium</ets> a period of twenty years; <ets>viceni</ets> twenty
+ <ets>annus</ets> year.]</ety> <sn>1.</sn> <def>Lasting or comprising
twenty years.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Happening once in twenty years; <as>as, a
<ex>vicennial</ex> celebration</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vice-regal</ent><br/
<hw>Vice`-re"gal</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to a viceroy or viceroyalty.</def> <rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viceroy</ent><br/
<hw>Vice"roy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vice-roi</ets>; pref. <ets>vice-</ets> in the place of (L.
<ets>vice</ets>) + <ets>roi</ets> a king, L. <ets>rex</ets>. See
<er>Vice</er>, <pos>prep.</pos> and Royal.]</ety> <sn>1.</sn> <def>The
governor of a country or province who rules in the name of the sovereign
with regal authority, as the king's substitute; <as>as, the
<ex>viceroy</ex> of India</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A large and handsome American
butterfly (<spn>Basilarchia archippus</spn> syn. <spn>Limenitis
archippus</spn>). Its wings are orange-red, with black lines along the
nervures and a row of white spots along the outer margins. The larvae
feed on willow, poplar, and apple trees.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viceroyalty</ent><br/
<hw>Vice*roy"al*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The dignity,
office, or jurisdiction of a viceroy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viceroyship</ent><br/
<hw>Vice"roy*ship</hw> <pr>(?)</pr>, <pos>n.</pos>
<def>Viceroyalty.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicety</ent><br/
<hw>Vi"ce*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <er>Vice</er> a
fault.]</ety> <def>Fault; defect; coarseness.</def> <mark>[Obs.]</mark>
<rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vichy water</ent><br/
<hw>Vi"chy wa`ter</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <def>A mineral
water found at <etsep>Vichy</etsep>, France. It is essentially an
effervescent <isa>aqueous solution</isa> of sodium, calcium, and
magnesium carbonates, with sodium and potassium chlorides; also, by
extension, any artificial or natural water resembling in composition the
Vichy water proper. Called also, colloquially,
<altname>Vichy</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viciate</ent><br/
<hw>Vi"ci*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>See
<er>Vitiate</er>.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicinage</ent><br/
<hw>Vic"i*nage</hw> <pr>(?; 48)</pr>, <pos>n.</pos> <ety>[OF.
<ets>veisinage</ets>, F. <ets>voisinage</ets>, from OF.
<ets>veisin</ets>, F. <ets>voisin</ets>, neighboring, a neighbor, L.
<ets>vicinus</ets>. See <er>Vicinity</er>.]</ety> <def>The place or
places adjoining or near; neighborhood; vicinity; <as>as, a jury must be
of the <ex>vicinage</ex></as>.</def> <ldquo/To summon the Protestant
gentleman of the <xex>vicinage</xex>.<rdquo/
<rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Civil war had broken up all the usual ties of <qex>vicinage</qex>
and good neighborhood.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicinal</ent><br/
<hw>Vic"i*nal</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>vicinalis</ets>: cf. F. <ets>vicinal</ets>.]</ety> <sn>1.</sn>
<def>Near; vicine.</def> <rj><au>T. Warton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Organic Chem.)</fld> <def>Having the substituted
groups on the same carbon atom.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Vicinal planes</b></col> <fld>(Min.)</fld>,
<cd>subordinate planes on a crystal, which are very near to the
fundamental planes in angles, and sometimes take their place. They have
in general very complex symbols.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicine</ent><br/
<hw>Vic"ine</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vicinus</ets>: cf. F. <ets>voisin</ets>.]</ety> <def>Near;
neighboring; vicinal.</def> <mark>[R.]</mark>
<rj><au>Glanvill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicine</ent><br/
<hw>Vic"ine</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>An
<isa>alkaloid</isa> extracted from the seeds of the vetch
(<prodby><spn>Vicia sativa</spn></prodby>) as a white crystalline
substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicinity</ent><br/
<hw>Vi*cin"i*ty</hw> <pr>(v<icr/*s<icr/n"<icr/*t<ycr/; 277)</pr>,
<pos>n.</pos> <ety>[L. <ets>vicinitas</ets>, from <ets>vicinus</ets>
neighboring, near, from <ets>vicus</ets> a row of houses, a village;
akin to Gr. <grk>o'i^kos</grk> a house, Skr. <ets>v<emac/<cced/a</ets> a
house, <ets>vi<cced/</ets> to enter, Goth. <ets>weihs</ets> town: cf.
OF. <ets>vicinit<eacute/</ets>. Cf. <er>Diocese</er>, <er>Economy</er>,
<er>Parish</er>, <er>Vicinage</er>, <er>Wick</er> a village.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The quality or state of being near, or not remote;
nearness; propinquity; proximity; <as>as, the value of the estate was
increased by the <ex>vicinity</ex> of two country seats</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>vicinity</qex> of disposition and relative tempers.</q>
<rj><qau>Jer. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is near, or not remote; that which is
adjacent to anything; adjoining space or country; neighborhood.</def>
<ldquo/The <xex>vicinity</xex> of the sun.<rdquo/
<rj><au>Bentley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Neighborhood; vicinage. See
<er>Neighborhood</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viciosity</ent><br/
<hw>Vi`ci*os"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Vitiosity.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicious</ent><br/
<hw>Vi"cious</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OF.
<ets>vicious</ets>, F. <ets>vicieux</ets>, fr. L. <ets>vitiosus</ets>,
fr. <ets>vitium</ets> vice. See <er>Vice</er> a fault.]</ety>
<sn>1.</sn> <def>Characterized by vice or defects; defective; faulty;
imperfect.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Though I perchance am <qex>vicious</qex> in my guess.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The title of these lords was <qex>vicious</qex> in its origin.</q>
<rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A charge against Bentley of <qex>vicious</qex> reasoning.</q>
<rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Addicted to vice; corrupt in principles or conduct;
depraved; wicked; <as>as, <ex>vicious</ex> children; <ex>vicious</ex>
examples; <ex>vicious</ex> conduct</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Who . . . heard this heavy curse,<br/
Servant of servants, on his <qex>vicious</qex> race.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Wanting purity; foul; bad; noxious; <as>as,
<ex>vicious</ex> air, water, etc</as>.</def>
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Not correct or pure; corrupt; <as>as,
<ex>vicious</ex> language; <ex>vicious</ex> idioms</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Not well tamed or broken; given to bad tricks;
unruly; refractory; <as>as, a <ex>vicious</ex> horse</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Bitter; spiteful; malignant.</def>
<mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Corrupt; faulty; wicked; depraved.</syn><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vi"cious*ly</wf>, <pos>adv.</pos> --
<wf>Vi"cious*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicissitude</ent><br/
<hw>Vi*cis"si*tude</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vicissitudo</ets>, fr. <ets>vicis</ets> change, turn: cf. F.
<ets>vicissitude</ets>. See <er>Vicarious</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Regular change or succession from one thing to
another; alternation; mutual succession; interchange.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>God made two great lights . . . <br/
To illuminate the earth and rule the day<br/
In their <qex>vicissitude</qex>, and rule the night.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Irregular change; revolution; mutation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> (<it>pl.</it>) <def>Changing conditions of fortune in
one's life; life's ups and downs.</def><br/
[<source>PJC</source>]</p>

<p><q>This man had, after many <qex>vicissitudes</qex> of fortune, sunk
at last into abject and hopeless poverty.</q>
<rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicissitudinary</ent><br/
<hw>Vi*cis`si*tu"di*na*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Subject
to vicissitudes.</def> <rj><au>Donne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicissitudinous</ent><br/
<hw>Vi*cis`si*tu"di*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Full of,
or subject to, changes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicissy duck</ent><br/
<hw>Vi*cis"sy duck`</hw> <pr>(?)</pr>. <fld>(Zool.)</fld> <def>A West
Indian duck, sometimes domesticated.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vickers' gun</ent><br/
<hw>Vick"ers' gun</hw> <pr>(?)</pr>. <fld>(Ordnance)</fld> <def>One of a
system of guns manufactured by the firm of Vickers' Sons, at Sheffield,
Eng. now included in <isa>Vickers-Maxim guns</isa>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vickers-Maxim automatic machine gun</ent><br/
<hw>Vick"ers-Max"im automatic machine gun</hw>. <def>An automatic
machine gun in which the mechanism is worked by the recoil, assisted by
the pressure of gases from the muzzle, which expand in a gas chamber
against a disk attached to the end of the barrel, thus moving the latter
to the rear with increased recoil, and against the front wall of the gas
chamber, checking the recoil of the system.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vickers-Maxim gun</ent><br/
<hw>Vickers-Maxim gun</hw>. <fld>(Ordnance)</fld> <def>One of a system
of ordnance, including machine, quick-fire, coast, and field guns, of
all calibers, manufactured by the combined firms of Vickers' Sons of
Sheffield and Maxim of Birmingham and elsewhere, England.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vicontiel</ent><br/
<hw>Vi*con"ti*el</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From OE.
<ets>vicounte</ets> a viscount. See <er>Viscount</er>.]</ety> <fld>(O.
Eng. Law)</fld> <def>Of or pertaining to the viscount or sheriff of a
county.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vicontiel rents</b></col>. <cd>See
<er>Vicontiels</er>.</cd> -- <col><b>Vicontiel writs</b></col>, <cd>such
writs as were triable in the sheriff, or county, court.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicontiels</ent><br/
<hw>Vi*con"ti*els</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[See
<er>Vicontiel</er>.]</ety> <fld>(O. Eng. Law)</fld> <def>Things
belonging to the sheriff; especially, farms (called also
<altname>vicontiel rents</altname>) for which the sheriff used to pay
rent to the king.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicount</ent><br/
<hw>Vi"count</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Viscount</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victim</ent><br/
<hw>Vic"tim</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>victima</ets>: cf. F. <ets>victime</ets>.]</ety> <sn>1.</sn> <def>A
living being sacrificed to some deity, or in the performance of a
religious rite; a creature immolated, or made an offering of.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Led like a <qex>victim</qex>, to my death I'll go.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A person or thing destroyed or sacrificed in the
pursuit of an object, or in gratification of a passion; <as>as, a
<ex>victim</ex> to jealousy, lust, or ambition</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A person or living creature destroyed by, or
suffering grievous injury from, another, from fortune or from accident;
<as>as, the <ex>victim</ex> of a defaulter; the <ex>victim</ex> of a
railroad accident</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Hence, one who is duped, or cheated; a dupe; a
gull.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victimate</ent><br/
<hw>Vic"tim*ate</hw>, <pos>v. t.</pos> <ety>[L. <ets>victimatus</ets>,
p. p. of <ets>victimare</ets> to sacrifice.]</ety> <def>To make a victim
of; to sacrifice; to immolate.</def> <mark>[Obs.]</mark>
<rj><au>Bullokar.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victimize</ent><br/
<hw>Vic"tim*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Victimized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Victimizing</conjf> <pr>(?)</pr>.]</vmorph> <def>To make
a victim of, esp. by deception; to dupe; to cheat.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victor</ent><br/
<hw>Vic"tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>victor</ets>,
fr. <ets>vincere</ets>, <ets>victum</ets>, to vanquish, to conquer. See
<er>Vanquish</er>.]</ety> <sn>1.</sn> <def>The winner in a contest; one
who gets the better of another in any struggle; esp., one who defeats an
enemy in battle; a vanquisher; a conqueror; -- often followed by
<ptcl>at</ptcl>, rarely by <ptcl>of</ptcl>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In love, the <qex>victors</qex> from the vanquished fly;<br/
They fly that wound, and they pursue that die.</q>
<rj><qau>Waller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A destroyer.</def> <mark>[R. & Poetic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>There, <qex>victor</qex> of his health, of fortune, friends,<br/
And fame, this lord of useless thousands ends.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victor</ent><br/
<hw>Vic"tor</hw>, <pos>a.</pos> <def>Victorious.</def> <ldquo/The
<xex>victor</xex> Greeks.<rdquo/ <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victoress</ent><br/
<hw>Vic"tor*ess</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A victress.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victoria</ent><br/
<hw>Vic*to"ri*a</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <ety>[NL.]</ety>
<sn>1.</sn> <fld>(Bot.)</fld> <def>A genus of aquatic plants named in
honor of Queen <etsep>Victoria</etsep>. The <spn>Victoria regia</spn> is
a native of <country>Guiana</country> and <country>Brazil</country>. Its
large, spreading leaves are often over five feet in diameter, and have a
rim from three to five inches high; its immense rose-white flowers
sometimes attain a diameter of nearly two feet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A kind of low four-wheeled pleasure carriage, with a
calash top, designed for two persons and the driver who occupies a high
seat in front.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Astron.)</fld> <def>An asteroid discovered by Hind
in 1850; -- called also <altname>Clio</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>One of an American breed of medium-sized white hogs
with a slightly dished face and very erect ears.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><col><b>Victoria cross</b></col>, <cd>a bronze Maltese cross,
awarded for valor to members of the British army or navy. It was first
bestowed in 1857, at the close of the Crimean war. The recipients also
have a pension of <pound/10 a year.</cd> -- <col><b>Victoria
green</b></col>. <fld>(Chem.)</fld> <cd>See <cref>Emerald green</cref>,
under <er>Green</er>.</cd> -- <col><b>Victoria lily</b></col>
<fld>(Bot.)</fld>, <cd>the <cref>Victoria regia</cref>. See def. 1,
above.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victoria crape</ent><br/
<hw>Victoria crape</hw>. <def>A kind of cotton crape.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Victorian</ent><br/
<hw>Vic*to"ri*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to the reign of <person>Queen Victoria</person> of England; <as>as, the
<ex>Victorian</ex> poets</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Victorian period</b></col>. <cd>See <cref>Dionysian
period</cref>, under <er>Dyonysian</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victorine</ent><br/
<hw>Vic`tor*ine"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A woman's fur
tippet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victorious</ent><br/
<hw>Vic*to"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>victoriosus</ets>: cf. F. <ets>victorieux</ets>. See
<er>Victory</er>.]</ety> <def>Of or pertaining to victory, or a victor;
being a victor; bringing or causing a victory; conquering; winning;
triumphant; <as>as, a <ex>victorious</ex> general; <ex>victorious</ex>
troops; a <ex>victorious</ex> day</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>But I shall rise <qex>victorious</qex>, and subdue<br/
My vanquisher.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Now are our brows bound with <qex>victorious</qex> wreaths.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vic*to"ri*ous*ly</wf>, <pos>adv.</pos> --
<wf>Vic*to"ri*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victorium</ent><br/
<hw>Vic*to"ri*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. So named
after <etsep>Victoria</etsep>, queen of Great Britain.]</ety>
<fld>(Chem.)</fld> <def>A probable chemical element discovered by Sir
William Crookes in 1898. Its nitrate is obtained by practical
decomposition and crystallization of yttrium nitrate. At. wt., about
117.</def><-- ??? not an element, or renamed?? --><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Victory</ent><br/
<hw>Vic"to*ry</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Victories</plw> <pr>(#)</pr>.</plu> <ety>[OE. <ets>victorie</ets>,
OF. <ets>victorie</ets>, <ets>victoire</ets>, F. <ets>victoire</ets>, L.
<ets>victoria</ets>. See <er>Victor</er>.]</ety> <def>The defeat of an
enemy in battle, or of an antagonist in any contest; a gaining of the
superiority in any struggle or competition; conquest; triumph; -- the
opposite of <ant>defeat</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Death is swallowed up in <qex>victory</qex>.</q> <rj><qau>1 Cor.
xv. 54.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>God on our side, doubt not of <qex>victory</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Victory</qex> may be honorable to the arms, but shameful to
the counsels, of a nation.</q> <rj><qau>Bolingbroke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victress</ent><br/
<hw>Vic"tress</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. L.
<ets>victrix</ets>.]</ety> <def>A woman who wins a victory; a female
victor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victrice</ent><br/
<hw>Vic"trice</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A victress.</def>
<mark>[R.]</mark> <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victrix</ent><br/
<hw>Vic"trix</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <def>A
victress.</def> <rj><au>C. Bront<eacute/.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victual</ent><br/
<hw>Vict"ual</hw> <pr>(v<icr/t"'l)</pr>, <pos>n.</pos> <sn>1.</sn>
<def>Food; -- now used chiefly in the plural. See
<er>Victuals</er>.</def> <rj><au>2 Chron. xi. 23. Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He was not able to keep that place three days for lack of
<qex>victual</qex>.</q> <rj><qau>Knolles.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>There came a fair-hair'd youth, that in his hand<br/
Bare <qex>victual</qex> for the mowers.</q>
<rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Short allowance of <qex>victual</qex>.</q>
<rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Grain of any kind.</def> <mark>[Scot.]</mark>
<rj><au>Jamieson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victual</ent><br/
<hw>Vict"ual</hw> <pr>(v<icr/t"'l)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Victualed</conjf>
<pr>(v<icr/t"'ld)</pr> or <conjf>Victualled</conjf>; <pos>p. pr. & vb.
n.</pos> <conjf>Victualing</conjf> or
<conjf>Victualling</conjf>.]</vmorph> <def>To supply with provisions for
subsistence; to provide with food; to store with sustenance; <as>as, to
<ex>victual</ex> an army; to <ex>victual</ex> a ship</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I must go <qex>victual</qex> Orleans forthwith.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victualage</ent><br/
<hw>Vict"ual*age</hw> <pr>(v<icr/t"'l*<asl/j; 48)</pr>, <pos>n.</pos>
<def>Victuals; food.</def> <mark>[R.]</mark> <ldquo/With my cargo of
<xex>victualage</xex>.<rdquo/ <rj><au>C. Bront<eacute/.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1609 pr=PI --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victualer</ent><br/
<hw>Vict"ual*er</hw> <pr>(v<icr/t"'l*<etil/r)</pr>, <pos>n.</pos>
<ety>[F. <ets>victuailleur</ets>.]</ety> <altsp>[Written also
<asp>victualler</asp>.]</altsp> <sn>1.</sn> <def>One who furnishes
victuals.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who keeps a house of entertainment; a tavern
keeper; an innkeeper.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A vessel employed to carry provisions, usually for
military or naval use; a provision ship.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>One who deals in grain; a corn factor.</def>
<mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Licensed victualer</b></col>. <cd>See under
<er>Licensed</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victualing</ent><br/
<hw>Vict"ual*ing</hw>, <pos>a.</pos> <def>Of or pertaining to victuals,
or provisions; supplying provisions; <as>as, a <ex>victualing</ex>
ship</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victuals</ent><br/
<hw>Vict"uals</hw> <pr>(v<icr/t"'lz)</pr>, <pos>n. pl.</pos> <ety>[OE.
<ets>vitaille</ets>, OF. <ets>vitaille</ets>, F. <ets>victuaille</ets>,
pl. <ets>victuailles</ets>, fr. L. <ets>victualia</ets>, pl. of.
<ets>victualis</ets> belonging to living or nourishment, fr.
<ets>victus</ets> nourishment, from <ets>vivere</ets>,
<ets>victum</ets>, to live; akin to <ets>vivus</ets> living. See
<er>Vivid</er>.]</ety> <def>Food for human beings, esp. when it is
cooked or prepared for the table; that which supports human life;
provisions; sustenance; meat; viands.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Then had we plenty of <qex>victuals</qex>.</q> <rj><qau>Jer. xliv.
17.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Victus</ent><br/
\'d8<hw>Vic"tus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety>
<fld>(Zool.)</fld> <def>Food; diet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vicugna</ent><br/
<ent>Vicuna</ent><br/
<mhw>{ \'d8<hw>Vi*cu"<ntil/a</hw>, \'d8<hw>Vi*cu"gna</hw> }</mhw>
<pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. <ets>vicu<ntil/a</ets>. Cf.
<er>Vigonia</er>.]</ety> <fld>(Zool.)</fld> <def>A South American mammal
(<spn>Auchenia vicunna</spn>) native of the elevated plains of the
Andes, allied to the llama but smaller. It has a thick coat of very fine
reddish brown wool, and long, pendent white hair on the breast and
belly. It is hunted for its wool and flesh.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vida finch</ent><br/
<hw>Vid"a finch`</hw> <pr>(?)</pr>. <fld>(Zool.)</fld> <def>The whidah
bird.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vidame</ent><br/
\'d8<hw>Vi*dame"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. LL.
<ets>vice-dominus</ets>, fr. L. <ets>vice</ets> instead of +
<ets>dominus</ets> master, lord.]</ety> <fld>(Fr. Feud. Law)</fld>
<def>One of a class of temporal officers who originally represented the
bishops, but later erected their offices into fiefs, and became feudal
nobles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vide</ent><br/
\'d8<hw>Vi"de</hw> <pr>(?)</pr>, <def><pos>imperative sing.</pos> of L.
<xex>videre</xex>, to see; -- used to direct attention to something;
<as>as, <ex>vide supra</ex>, see above</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Videlicet</ent><br/
\'d8<hw>Vi*del"i*cet</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[L., contr.
fr. <ets>videre licet</ets>, literally, it is easy to see, one may or
can see.]</ety> <def>To wit; namely; -- often abbreviated to
<abbr>viz.</abbr></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>videocasette</ent><br/
<hw>videocasette</hw> <pos>n.</pos> <def>a cassette containing magnetic
tape, which can be used in a videocassette recorder to record and play
back electronic signals, such as from television programs. The long
magnetic tape in the videocassette is moved between two spindles, and a
small portion of the tape at any one time is passed over a recording or
playback head.</def><br/
[<source>PJC</source>]</p>

<p><ent>videocasette recorder</ent><br/
<hw>videocasette recorder</hw> <pos>n.</pos> <def>an electronic device
which can record electronic signals, as from a television program, on
magnetic tape contained in a videocassette, and can also play back the
recording. It is used, for example, to record television programs
broadcast at some particular time, which can then be viewed at any
subsequent time by attaching the videocassette recorder to a television
receiver and playing the signals through the television receiver. Also
called <altname>VCR</altname>.</def><br/
[<source>PJC</source>]</p>

<p><ent>videotape</ent><br/
<hw>videotape</hw> <pos>n.</pos> <sn>1.</sn> <def>a video recording made
on magnetic tape.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>a relatively wide magnetic tape for use in recording
visual images and associated sound.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Vidette</ent><br/
<hw>Vi*dette"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Mil.)</fld>
<def>Same as <er>Vedette</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vidonia</ent><br/
<hw>Vi*do"ni*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Pg.
<ets>vidonho</ets> the quality of grapes, Sp.
<ets>vedu<ntil/o</ets>.]</ety> <def>A dry white wine, of a tart flavor,
produced in Teneriffe; -- called also
<altname>Teneriffe</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viduage</ent><br/
<hw>Vid"u*age</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Vidual</er>.]</ety> <def>The state of widows or of widowhood; also,
widows, collectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vidual</ent><br/
<hw>Vid"u*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vidualis</ets>, fr. <ets>vidua</ets> a widow, fr. <ets>viduus</ets>
widowed. See <er>Widow</er>.]</ety> <def>Of or pertaining to the state
of a widow; widowed.</def> <mark>[R.]</mark> <rj><au>Jer.
Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viduation</ent><br/
<hw>Vid`u*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state of
being widowed or bereaved; loss; bereavement.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viduity</ent><br/
<hw>Vi*du"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>viduitas</ets>: cf. F. <ets>viduit<eacute/</ets>.]</ety>
<def>Widowhood.</def> <mark>[R.]</mark> <ldquo/Chaste
<xex>viduity</xex>.<rdquo/ <rj><au>Ld. Ellenborough.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vie</ent><br/
<hw>Vie</hw> <pr>(v<imac/)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vied</conjf> <pr>(v<imac/d)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vying</conjf> <pr>(v<imac/"<icr/ng)</pr>.]</vmorph>
<ety>[OE. <ets>vien</ets>, shortened fr. <ets>envien</ets>, OF.
<ets>envier</ets> to invite, to challenge, a word used in gambling, L.
<ets>invitare</ets> to invite; of uncertain origin. Cf. <er>Invite</er>,
<er>Envie</er>.]</ety> <sn>1.</sn> <def>To stake a sum upon a hand of
cards, as in the old game of gleek. See <er>Revie</er>.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To strive for superiority; to contend; to use
emulous effort, as in a race, contest, or competition.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In a trading nation, the younger sons may be placed in such a way
of life as . . . to <qex>vie</qex> with the best of their family.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>While Waterloo with Cannae's carnage <qex>vies</qex>.</q>
<rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vie</ent><br/
<hw>Vie</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To stake; to
wager.</def> <mark>[Obs.]</mark> <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To do or produce in emulation, competition, or
rivalry; to put in competition; to bandy.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>She hung about my neck; and kiss on kiss<br/
She <qex>vied</qex> so fast.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Nor was he set over us to <qex>vie</qex> wisdom with his
Parliament, but to be guided by them.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And <qex>vying</qex> malice with my gentleness,<br/
Pick quarrels with their only happiness.</q>
<rj><qau>Herbert.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vie</ent><br/
<hw>Vie</hw>, <pos>n.</pos> <def>A contest for superiority; competition;
rivalry; strife; also, a challenge; a wager.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>We 'll all to church together instantly,<br/
And then a <qex>vie</qex> for boys.</q> <rj><qau>J.
Fletcher.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vielle</ent><br/
<hw>Vi*elle"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. Cf.
<er>Viol</er>.]</ety> <def>An old stringed instrument played upon with a
wheel; a hurdy-gurdy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vienna paste</ent><br/
<hw>Vi*en"na paste`</hw> <pr>(?)</pr>. <fld>(Pharm.)</fld> <def>A
caustic application made up of equal parts of caustic potash and
quicklime; -- called also <altname>Vienna caustic</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viennese</ent><br/
<hw>Vi`en*nese"</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to Vienna, or the people of Vienna.</def> -- <def2><pos>n. sing. &
pl.</pos> <def>An inhabitant, or the inhabitants, of
Vienna.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vierkleur</ent><br/
\'d8<hw>Vier"kleur`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[D., fr.
<ets>vier</ets> four + <ets>kleur</ets> color, F.
<ets>couleur</ets>.]</ety> <def>The four-colored flag of the South
African Republic, or Transvaal, -- red, white, blue, and
green.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>View</ent><br/
<hw>View</hw> <pr>(v<umac/)</pr>, <pos>n.</pos> <ety>[OF.
<ets>veue</ets>, F. <ets>vue</ets>, fr. OF. <ets>veoir</ets> to see, p.
p. <ets>veu</ets>, F. <ets>voir</ets>, p. p. <ets>vu</ets>, fr. L.
<ets>videre</ets> to see. See <er>Vision</er>, and cf.
<er>Interview</er>, <er>Purview</er>, <er>Review</er>,
<er>Vista</er>.]</ety> <sn>1.</sn> <def>The act of seeing or beholding;
sight; look; survey; examination by the eye; inspection.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thenceforth I thought thee worth my nearer <qex>view</qex>.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Objects near our <qex>view</qex> are thought greater than those of
a larger size that are more remote.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Surveying nature with too nice a <qex>view</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Mental survey; intellectual perception or
examination; <as>as, a just <ex>view</ex> of the arguments or facts in a
case</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I have with exact <qex>view</qex> perused thee, Hector.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Power of seeing, either physically or mentally;
reach or range of sight; extent of prospect.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The walls of Pluto's palace are in <qex>view</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>That which is seen or beheld; sight presented to the
natural or intellectual eye; scene; prospect; <as>as, the <ex>view</ex>
from a window</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>'T is distance lends enchantment to the <qex>view</qex>.</q>
<rj><qau>Campbell.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The pictorial representation of a scene; a sketch,
either drawn or painted; <as>as, a fine <ex>view</ex> of Lake
George</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Mode of looking at anything; manner of apprehension;
conception; opinion; judgment; <as>as, to state one's <ex>views</ex> of
the policy which ought to be pursued</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To give a right <qex>view</qex> of this mistaken part of
liberty.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>That which is looked towards, or kept in sight, as
object, aim, intention, purpose, design; <as>as, he did it with a
<ex>view</ex> of escaping</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>No man sets himself about anything but upon some <qex>view</qex>
or other which serves him for a reason.</q>
<rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>Appearance; show; aspect.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>[Graces] which, by the splendor of her <qex>view</qex><br/
Dazzled, before we never knew.</q> <rj><qau>Waller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Field of view</b></col>. <cd>See under
<er>Field</er>.</cd> -- <col><b>Point of view</b></col>. <cd>See under
<er>Point</er>.</cd> -- <col><b>To have in view</b></col>, <cd>to have
in mind as an incident, object, or aim; <as>as, <ex>to have</ex> one's
resignation <ex>in view</ex></as>.</cd> -- <col><b>View
halloo</b></col>, <cd>the shout uttered by a hunter upon seeing the fox
break cover.</cd> -- <col><b>View of frankpledge</b></col>
<fld>(Law)</fld>, <cd>a court of record, held in a hundred, lordship, or
manor, before the steward of the leet.</cd> <au>Blackstone.</au> --
<col><b>View of premises</b></col> <fld>(Law)</fld>, <cd>the inspection
by the jury of the place where a litigated transaction is said to have
occurred.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>View</ent><br/
<hw>View</hw> <pr>(v<umac/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Viewed</conjf> <pr>(v<umac/d)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Viewing</conjf>.]</vmorph> <sn>1.</sn> <def>To see; to
behold; especially, to look at with attention, or for the purpose of
examining; to examine with the eye; to inspect; to explore.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>O, let me <qex>view</qex> his visage, being dead.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Nearer to <qex>view</qex> his prey, and, unespied,<br/
To mark what of their state he more might learn.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To survey or examine mentally; to consider; <as>as,
to <ex>view</ex> the subject in all its aspects</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The happiest youth, <qex>viewing</qex> his progress through.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viewer</ent><br/
<hw>View"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who
views or examines.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>A person appointed to inspect
highways, fences, or the like, and to report upon the same.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The superintendent of a coal mine.</def>
<mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viewiness</ent><br/
<hw>View"i*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being viewy, or of having unpractical views.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viewless</ent><br/
<hw>View"less</hw>, <pos>a.</pos> <def>Not perceivable by the eye;
invisible; unseen.</def> <ldquo/<xex>Viewless</xex> winds.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Swift through the valves the visionary fair<br/
Repassed, and <qex>viewless</qex> mixed with common air.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viewsome</ent><br/
<ent>Viewly</ent><br/
<mhw>{ <hw>View"ly</hw> <pr>(?)</pr>, <hw>View"some</hw> <pr>(?)</pr>,
}</mhw> <pos>a.</pos> <def>Pleasing to the sight; sightly.</def>
<mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viewy</ent><br/
<hw>View"y</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Having
peculiar views; fanciful; visionary; unpractical; <as>as, a
<ex>viewy</ex> person</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Spectacular; pleasing to the eye or the
imagination.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A government intent on showy absurdities and <qex>viewy</qex>
enterprises rather than solid work.</q> <rj><qau>London
Spectator.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vifda</ent><br/
<hw>Vif"da</hw> <pr>(?)</pr>, <pos>n.</pos> <def>In the Orkney and
Shetland Islands, beef and mutton hung and dried, but not salted.</def>
<mark>[Scot.]</mark> <altsp>[Written also <asp>vivda</asp>.]</altsp>
<rj><au>Jamieson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigesimal</ent><br/
<hw>Vi*ges"i*mal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vigesimus</ets> twentieth, from <ets>viginti</ets> twenty.]</ety>
<def>Twentieth; divided into, or consisting of, twenties or twenty
parts.</def> <rj><au>Tylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigesimation</ent><br/
<hw>Vi*ges`i*ma"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of
putting to death every twentieth man.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigesimo-quarto</ent><br/
<hw>Vi*ges"i*mo-quar"to</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vigesimus quartus</ets> twenty-fourth. Cf.
<er>Duodecimo</er>.]</ety> <def>Having twenty-four leaves to a sheet;
<as>as, a <ex>vigesimo-quarto</ex> form, book, leaf, size,
etc</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigesimo-quarto</ent><br/
<hw>Vi*ges"i*mo-quar"to</hw>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>-tos</plw> <pr>(<?/)</pr>.</plu> <def>A book composed of sheets
each of which is folded into twenty-four leaves; hence, indicating more
or less definitely a size of book so made; -- usually written
<it>24mo</it>, or <it>24<deg/</it>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigil</ent><br/
<hw>Vig"il</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>vigile</ets>,
L. <ets>vigilia</ets>, from <ets>vigil</ets> awake, watchful, probably
akin to E. <ets>wake</ets>: cf. F. <ets>vigile</ets>. See <er>Wake</er>,
<pos>v. i.</pos>, and cf. <er>Reveille</er>, <er>Surveillance</er>,
<er>Vedette</er>, <er>Vegetable</er>, <er>Vigor</er>.]</ety> <sn>1.</sn>
<def>Abstinence from sleep, whether at a time when sleep is customary or
not; the act of keeping awake, or the state of being awake;
sleeplessness; wakefulness; watch.</def> <ldquo/Worn out by the labors
and <xex>vigils</xex> of many months.<rdquo/
<rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Nothing wears out a fine face like the <qex>vigils</qex> of the
card table and those cutting passions which attend them.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, devotional watching; waking for prayer, or
other religious exercises.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>So they in heaven their odes and <qex>vigils</qex> tuned.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Be sober and keep <qex>vigil</qex>,<br/
The Judge is at the gate.</q> <rj><qau>Neale (Rhythm of St.
Bernard).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Eccl.)</fld> <sd>(a)</sd> <def>Originally, the
watch kept on the night before a feast.</def> <sd>(b)</sd> <def>Later,
the day and the night preceding a feast.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He that shall live this day, and see old age,<br/
Will yearly on the <qex>vigil</qex> feast his neighbors,<br/
And say, <ldquo/To-morrow is St. Crispian.<rdquo/</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>A religious service performed in the evening
preceding a feast.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Vigils of flowers</b></col> <it>or</it>
<col><b>Watchings of flowers</b></col></mcol> <fld>(Bot.)</fld>, <cd>a
peculiar faculty belonging to the flowers of certain plants of opening
and closing their petals at certain hours of the day.</cd>
<mark>[R.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigilance</ent><br/
<hw>Vig"i*lance</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vigilantia</ets>: cf. F. <ets>vigilance</ets>.]</ety> <sn>1.</sn>
<def>The quality or state of being vigilant; forbearance of sleep;
wakefulness.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Watchfulness in respect of danger; care; caution;
circumspection.</def> <rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And flaming ministers to watch and tend<br/
Their earthly charge; of these the <qex>vigilance</qex><br/
I dread.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Guard; watch.</def> <mark>[Obs.]</mark> <ldquo/In at
this gate none pass the <xex>vigilance</xex> here placed.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vigilance committee</b></col>, <cd>a volunteer committee
of citizens for the oversight and protection of any interest, esp. one
organized for the summary suppression and punishment of crime, as when
the processes of law appear inadequate.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigilancy</ent><br/
<hw>Vig"i*lan*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Vigilance.</def>
<mark>[Obs.]</mark> <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigilant</ent><br/
<hw>Vig"i*lant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vigilans</ets>, <ets>-antis</ets>, p. pr. of <ets>vigilare</ets> to
watch, fr. <ets>vigil</ets> awake: cf. F. <ets>vigilant</ets>. See
<er>Vigil</er>.]</ety> <def>Attentive to discover and avoid danger, or
to provide for safety; wakeful; watchful; circumspect; wary.</def>
<ldquo/Be sober, be <xex>vigilant</xex>.<rdquo/ <rj><au>1 Pet. v.
8.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Sirs, take your places, and be <qex>vigilant</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigilantly</ent><br/
<hw>Vig"i*lant*ly</hw>, <pos>adv.</pos> <def>In a vigilant
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigily</ent><br/
<hw>Vig"i*ly</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vigilia</ets>.]</ety> <def>A vigil.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigintivirate</ent><br/
<hw>Vi`gin*tiv"i*rate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vigintiviratus</ets>, fr. <ets>vigintiviri</ets>;
<ets>viginti</ets> twenty + <ets>vir</ets> a man.]</ety> <def>The office
of the <xex>vigintiviri</xex>, a body of officers of government
consisting of twenty men; also, the vigintiviri.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vignette</ent><br/
<hw>Vi*gnette"</hw> <pr>(?; 277)</pr>, <pos>n.</pos> <ety>[F.
<ets>vignette</ets>, fr. <ets>vigne</ets> a vine. See <er>Vine</er>, and
cf. <er>Vinette</er>.]</ety> <sn>1.</sn> <fld>(Arch.)</fld> <def>A
running ornament consisting of leaves and tendrils, used in Gothic
architecture.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A decorative design, originally representing vine
branches or tendrils, at the head of a chapter, of a manuscript or
printed book, or in a similar position; hence, by extension, any small
picture in a book; hence, also, as such pictures are often without a
definite bounding line, any picture, as an engraving, a photograph, or
the like, which vanishes gradually at the edge.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A picture, illustration, or depiction in words, esp.
one of a small or dainty kind.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vignette</ent><br/
<hw>Vi*gnette"</hw>, <pos>v. t.</pos> <def>To make, as an engraving or a
photograph, with a border or edge insensibly fading away.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vignetter</ent><br/
<hw>Vi*gnett"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A
device used by photographers in printing vignettes, consisting of a
screen of paper or glass with a central aperture the edges of which
become opaque by insensible gradations.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>A maker of vignettes.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vigonia</ent><br/
<hw>Vi*go"ni*a</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vigogne</ets> vicu<ntil/a. See <er>Vicu<ntil/a</er>.]</ety> <def>Of
or pertaining to the vicu<ntil/a; characterizing the vicu<ntil/a; --
said of the wool of that animal, used in felting hats, and for other
purposes.</def> <rj><au>Prescott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigor</ent><br/
<hw>Vig"or</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>vigour</ets>,
<ets>vigor</ets>, OF. <ets>vigor</ets>, <ets>vigur</ets>,
<ets>vigour</ets>, F. <ets>vigueur</ets>, fr. L. <ets>vigor</ets>, fr.
<ets>vigere</ets> to be lively or strong. See <er>Vegetable</er>,
<er>Vigil</er>.]</ety> <sn>1.</sn> <def>Active strength or force of body
or mind; capacity for exertion, physically, intellectually, or morally;
force; energy.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>vigor</qex> of this arm was never vain.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Strength or force in animal or vegetable nature or
action; <as>as, a plant grows with <ex>vigor</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Strength; efficacy; potency.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>But in the fruithful earth . . . <br/
His beams, unactive else, their <qex>vigor</qex> find.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Vigor</xex> and its derivatives commonly imply
<xex>active</xex> strength, or the power of action and exertion, in
distinction from <xex>passive</xex> strength, or strength to
endure.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigor</ent><br/
<hw>Vig"or</hw>, <pos>v. t.</pos> <def>To invigorate.</def>
<mark>[Obs.]</mark> <rj><au>Feltham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigorite</ent><br/
<hw>Vig"or*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vigor</ets> strength.]</ety> <def>An explosive containing
nitroglycerin. It is used in blasting.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigoroso</ent><br/
\'d8<hw>Vig`o*ro"so</hw> <pr>(?)</pr>, <pos>a. & adv.</pos>
<ety>[It.]</ety> <fld>(Mus.)</fld> <def>Vigorous; energetic; with
energy; -- a direction to perform a passage with energy and
force.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vigorous</ent><br/
<hw>Vig"or*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. OF.
<ets>vigoros</ets>, F. <ets>vigoureux</ets>, LL.
<ets>vigorosus</ets>.]</ety> <sn>1.</sn> <def>Possessing vigor; full of
physical or mental strength or active force; strong; lusty; robust;
<as>as, a <ex>vigorous</ex> youth; a <ex>vigorous</ex>
plant</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Famed for his valor, young,<br/
At sea successful, <qex>vigorous</qex> and strong.</q>
<rj><qau>Waller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Exhibiting strength, either of body or mind;
powerful; strong; forcible; energetic; <as>as, <ex>vigorous</ex>
exertions; a <ex>vigorous</ex> prosecution of a war</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The beginnings of confederacies have been always
<qex>vigorous</qex> and successful.</q>
<rj><qau>Davenant.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vig"or*ous*ly</wf>, <pos>adv.</pos> --
<wf>Vig"or*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viking</ent><br/
<hw>Vi"king</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Icel.
<ets>v<imac/kingr</ets>, fr. <ets>v<imac/k</ets> a bay, inlet.]</ety>
<def>One belonging to the pirate crews from among the Northmen, who
plundered the coasts of Europe in the eighth, ninth, and tenth
centuries.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Of grim <qex>Vikings</qex>, and the rapture<br/
Of the sea fight, and the capture,<br/
And the life of slavery.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Viking</xex> differs in meaning from <xex>sea
king</xex>, with which it is frequently confounded. <ldquo/The <xex>sea
king</xex> was a man connected with a royal race, either of the small
kings of the country, or of the Haarfager family, and who, by right,
received the title of king as soon he took the command of men, although
only of a single ship's crew, and without having any land or kingdom . .
. <xex>Vikings</xex> were merely pirates, alternately peasants and
pirates, deriving the name of <xex>viking</xex> from the
<xex>vicks</xex>, <xex>wicks</xex>, or inlets, on the coast in which
they harbored with their long ships or rowing galleys.<rdquo/</note>
<rj><au>Laing.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vilany</ent><br/
<hw>Vil"a*ny</hw> <pr>(v<icr/l"<adot/*n<ycr/)</pr>, <pos>n.</pos>
<def>Villainy.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vilayet</ent><br/
<hw>Vi`la*yet"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Turk., from Ar.
<ets>wil<amac/yah</ets>.]</ety> <def>One of the chief administrative
divisions or provinces of the Ottoman Empire; -- formerly called
<xex>eyalet</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vild</ent><br/
<hw>Vild</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[As if the p. p. of a
verb to <ets>vile</ets>. See <er>Vile</er>, <pos>a.</pos>]</ety>
<def>Vile.</def> <mark>[Obs.]</mark> <ldquo/That <xex>vild</xex>
race.<rdquo/ <au>Spenser.</au> -- <wordforms><wf>Vild"ly</wf>,
<pos>adv.</pos> <mark>[Obs.]</mark></wordforms>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vile</ent><br/
<hw>Vile</hw> <pr>(v<imac/l)</pr>, <pos>a.</pos>
<amorph>[<pos>Comp.</pos> <adjf>Viler</adjf>
<pr>(v<imac/l"<etil/r)</pr>; <pos>superl.</pos>
<adjf>Vilest</adjf>.]</amorph> <ety>[OE. <ets>vil</ets>, F.
<ets>vil</ets>, from L. <ets>vilis</ets> cheap, worthless, vile,
base.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Low; base; worthless; mean; despicable.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A poor man in <qex>vile</qex> raiment.</q> <rj><qau>James ii.
2.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The craft either of fishing, which was Peter's, or of making
tents, which was Paul's, were [was] more <qex>vile</qex> than the
science of physic.</q> <rj><qau>Ridley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The inhabitants account gold but as a <qex>vile</qex> thing.</q>
<rj><qau>Abp. Abbot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Morally base or impure; depraved by sin; hateful in
the sight of God and men; sinful; wicked; bad.</def> <ldquo/Such
<xex>vile</xex> base practices.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Behold, I am <qex>vile</qex>; what shall I answer thee ?</q>
<rj><qau>Job xl. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- See <er>Base</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vile"ly</wf>, <pos>adv.</pos> --
<wf>Vile"ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viled</ent><br/
<hw>Viled</hw> <pr>(v<imac/ld)</pr>, <pos>a.</pos> <ety>[See
<er>Vild</er>.]</ety> <def>Abusive; scurrilous; defamatory; vile.</def>
<mark>[Obs.]</mark> <ldquo/<xex>Viled</xex> speeches.<rdquo/
<rj><au>Hayward.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vileyns</ent><br/
<hw>Vil"eyns</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Villain</er>.]</ety> <def>Villainous.</def> <mark>[Obs.]</mark>
<ldquo/<xex>Vileyns</xex> sinful deeds make a churl.<rdquo/
<au>Chaucer.</au><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vilification</ent><br/
<hw>Vil`i*fi*ca"tion</hw>
<pr>(v<icr/l`<icr/*f<icr/*k<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <def>The
act of vilifying or defaming; abuse.</def> <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vilifier</ent><br/
<hw>Vil"i*fi`er</hw> <pr>(v<icr/l"<icr/*f<imac/`<etil/r)</pr>,
<pos>n.</pos> <def>One who vilifies or defames.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vilify</ent><br/
<hw>Vil"i*fy</hw> <pr>(v<icr/l"<icr/*f<imac/)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Vilified</conjf> <pr>(?)</pr>;
<pos>p. pr. & vb. n.</pos> <conjf>Vilifying</conjf>.]</vmorph> <ety>[L.
<ets>vilis</ets> vile + <ets>-fy</ets>; cf. L. <ets>vilificare</ets> to
esteem of little value.]</ety> <sn>1.</sn> <def>To make vile; to debase;
to degrade; to disgrace.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>When themselves they <qex>vilified</qex><br/
To serve ungoverned appetite.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To degrade or debase by report; to defame; to
traduce; to calumniate.</def> <rj><au>I. Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Many passions dispose us to depress and <qex>vilify</qex> the
merit of one rising in the esteem of mankind.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To treat as vile; to despise.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I do <qex>vilify</qex> your censure.</q> <rj><qau>Beau. &
Fl.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1610 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vilipend</ent><br/
<hw>Vil"i*pend</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L.
<ets>vilipendere</ets>; <ets>vilis</ets> vile + <ets>pendere</ets> to
weigh, to value: cf. F. <ets>vilipender</ets>.]</ety> <def>To value
lightly; to depreciate; to slight; to despise.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To vilipend the art of portrait painting.</q>
<rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vilipendency</ent><br/
<hw>Vil"i*pend"en*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Disesteem;
slight; disparagement.</def> <mark>[R.]</mark> <rj><au>E.
Waterhouse.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vility</ent><br/
<hw>Vil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vilitas</ets>: cf. F. <ets>vilet<eacute/</ets>,
<ets>vilit<eacute/</ets>, OF. <ets>vilt<eacute/</ets>.]</ety>
<def>Vileness; baseness.</def> <mark>[Obs.]</mark>
<rj><au>Kennet.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vill</ent><br/
<hw>Vill</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>ville</ets>,
<ets>vile</ets>, a village, F. <ets>ville</ets> a town, city. See
<er>Villa</er>.]</ety> <def>A small collection of houses; a
village.</def> <ldquo/Every manor, town, or <xex>vill</xex>.<rdquo/
<rj><au>Sir M. Hale.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Not should e'er the crested fowl<br/
From thorp or <qex>vill</qex> his matins sound for me.</q>
<rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A word of various significations in English, law; as, a
manor; a tithing; a town; a township; a parish; a part of a parish; a
village. The original meaning of <xex>vill</xex>, in England, seems to
have been derived from the Roman sense of the term <xex>villa</xex>, a
<xex>single country residence</xex> or farm; a manor. Later, the term
was applied only to a collection of houses more than two, and hence came
to comprehend towns. <xex>Burrill</xex>. The statute of Exeter, 14
Edward I., mentions <xex>entire-vills</xex>, <xex>demivills</xex>, and
<xex>hamlets</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villa</ent><br/
<hw>Vil"la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Villas</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>villa</ets>, LL.
also village, dim. of L. <ets>vicus</ets> a village: cf. It. & F.
<ets>villa</ets>. See <er>Vicinity</er>, and cf. <er>Vill</er>,
<er>Village</er>, <er>Villain</er>.]</ety> <def>A country seat; a
country or suburban residence of some pretensions to elegance.</def>
<rj><au>Dryden. Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Village</ent><br/
<hw>Vil"lage</hw> <pr>(?; 48)</pr>, <pos>n.</pos> <ety>[F., fr. L.
<ets>villaticus</ets> belonging to a country house or villa. See
<er>Villa</er>, and cf. <er>Villatic</er>.]</ety> <def>A small
assemblage of houses in the country, less than a town or city.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Village cart</b></col>, <cd>a kind of two-wheeled
pleasure carriage without a top.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- <er>Village</er>, <er>Hamlet</er>, <er>Town</er>,
<er>City</er>.</syn> <usage> In England, a <xex>hamlet</xex> denotes a
collection of houses, too small to have a parish church. A
<xex>village</xex> has a church, but no market. A <xex>town</xex> has
both a market and a church or churches. A <xex>city</xex> is, in the
legal sense, an incorporated borough town, which is, or has been, the
place of a bishop's see. In the United States these distinctions do not
hold.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villager</ent><br/
<hw>Vil"la*ger</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An inhabitant of a
village.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Brutus had rather be a <qex>villager</qex><br/
Than to repute himself a son of Rome<br/
Under these hard condition.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villagery</ent><br/
<hw>Vil"lage*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Villages; a
district of villages.</def> <mark>[Obs.]</mark> <ldquo/The maidens of
the <xex>villagery</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villain</ent><br/
<hw>Vil"lain</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vilein</ets>, F. <ets>vilain</ets>, LL. <ets>villanus</ets>, from
<ets>villa</ets> a village, L. <ets>villa</ets> a farm. See
<er>Villa</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Feudal Law)</fld> <def>One who holds lands by a
base, or servile, tenure, or in villenage; a feudal tenant of the lowest
class, a bondman or servant.</def> <altsp>[In this sense written also
<asp>villan</asp>, and <asp>villein</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><q>If any of my ansectors was a tenant, and a servant, and held his
lands as a <qex>villain</qex> to his lord, his posterity also must do
so, though accidentally they become noble.</q> <rj><qau>Jer.
Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Villains</xex> were of two sorts; <xex>villains
regardant</xex>, that is, annexed to the manor (LL. <xex>adscripti
glebae</xex>); and <xex>villains in gross</xex>, that is, annexed to the
person of their lord, and transferable from one to another.
<rj><au>Blackstone.</au></rj> </note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A baseborn or clownish person; a boor.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Pour the blood of the <qex>villain</qex> in one basin, and the
blood of the gentleman in another, what difference shall there be
proved?</q> <rj><qau>Becon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A vile, wicked person; a man extremely depraved, and
capable or guilty of great crimes; a deliberate scoundrel; a knave; a
rascal; a scamp.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Like a <qex>villain</qex> with a smiling cheek.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Calm, thinking <qex>villains</qex>, whom no faith could fix.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villain</ent><br/
<hw>Vil"lain</hw>, <pos>a.</pos> <ety>[F. <ets>vilain</ets>.]</ety>
<def>Villainous.</def> <mark>[R.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villain</ent><br/
<hw>Vil"lain</hw>, <pos>v. t.</pos> <def>To debase; to degrade.</def>
<mark>[Obs.]</mark> <rj><au>Sir T. More.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villainous</ent><br/
<hw>Vil"lain*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Written also
<ets>villanous</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Base; vile; mean; depraved; <as>as, a
<ex>villainous</ex> person or wretch</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Proceeding from, or showing, extreme depravity;
suited to a villain; <as>as, a <ex>villainous</ex>
action</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Sorry; mean; mischievous; -- in a familiar
sense.</def> <ldquo/A <xex>villainous</xex> trick of thine eye.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Villainous judgment</b></col> <fld>(O. E. Law)</fld>,
<cd>a judgment that casts reproach on the guilty person.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p>--- <wordforms><wf>Vil"lain*ous*ly</wf>, <pos>adv.</pos>
<wf>Vil"lain*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villainy</ent><br/
<hw>Vil"lain*y</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Villainies</plw> <pr>(#)</pr>.</plu> <ety>[OE. <ets>vilanie</ets>,
OF. <ets>vilanie</ets>, <ets>vilainie</ets>, <ets>vileinie</ets>,
<ets>vilanie</ets>, LL. <ets>villania</ets>. See <er>Villain</er>,
<pos>n.</pos>]</ety> <altsp>[Written also <asp>villany</asp>.]</altsp>
<sn>1.</sn> <def>The quality or state of being a villain, or villainous;
extreme depravity; atrocious wickedness; <as>as, the <ex>villainy</ex>
of the seducer</as>.</def> <ldquo/Lucre of <xex>vilanye</xex>.<rdquo/
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The commendation is not in his wit, but in his
<qex>villainy</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Abusive, reproachful language; discourteous speech;
foul talk.</def> <mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He never yet not <qex>vileinye</qex> ne said<br/
In all his life, unto no manner wight.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In our modern language, it [foul language] is termed
<qex>villainy</qex>, as being proper for rustic boors, or men of
coarsest education and employment.</q> <rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Villainy</qex> till a very late day expressed words foul and
disgraceful to the utterer much oftener than deeds.</q>
<rj><qau>Trench.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The act of a villain; a deed of deep depravity; a
crime.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Such <qex>villainies</qex> roused Horace into wrath.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>That execrable sum of all <qex>villainies</qex> commonly called a
slave trade.</q> <rj><au>John Wesley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villakin</ent><br/
<hw>Vil"la*kin</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A little
villa.</def> <mark>[R.]</mark> <rj><au>Gay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villan</ent><br/
<hw>Vil"lan</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A villain.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villanage</ent><br/
<hw>Vil"lan*age</hw> <pr>(?; 48)</pr>, <pos>n.</pos> <ety>[OF.
<ets>villenage</ets>, <ets>vilenage</ets>. See <er>Villain</er>.]</ety>
<sn>1.</sn> <fld>(Feudal Law)</fld> <def>The state of a villain, or
serf; base servitude; tenure on condition of doing the meanest services
for the lord.</def> <altsp>[In this sense written also
<asp>villenage</asp>, and <asp>villeinage</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><q>I speak even now as if sin were condemned in a perpetual
<qex>villanage</qex>, never to be manumitted.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Some faint traces of <qex>villanage</qex> were detected by the
curious so late as the days of the Stuarts.</q>
<rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Baseness; infamy; villainy.</def>
<mark>[Obs.]</mark> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villanel</ent><br/
<hw>Vil`la*nel"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Villanelle</er>.]</ety> <def>A ballad.</def> <mark>[Obs.]</mark>
<rj><au>Cotton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villanella</ent><br/
\'d8<hw>Vil`la*nel"la</hw> <pr>(?)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Villanelle</plw> <pr>(#)</pr>.</plu> <ety>[It., a
pretty country girl.]</ety> <fld>(Mus.)</fld> <def>An old rustic dance,
accompanied with singing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villanelle</ent><br/
\'d8<hw>Vil`la*nelle"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<def>A poem written in tercets with but two rhymes, the first and third
verse of the first stanza alternating as the third verse in each
successive stanza and forming a couplet at the close.</def> <rj><au>E.
W. Gosse.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villanette</ent><br/
<hw>Vil`la*nette"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Dim. of
<ets>villa</ets>; formed on the analogy of the French.]</ety> <def>A
small villa.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villanize</ent><br/
<hw>Vil"lan*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Villanized</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Villanizing</conjf> <pr>(?)</pr>.]</vmorph> <def>To make vile; to
debase; to degrade; to revile.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Were virtue by descent, a noble name<br/
Could never <qex>villanize</qex> his father's fame.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villanizer</ent><br/
<hw>Vil"lan*i`zer</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who
villanizes.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villanousness</ent><br/
<ent>Villanously</ent><br/
<ent>Villanous</ent><br/
<mhw><hw>Vil"lan*ous</hw> <pr>(?)</pr>, <pos>a.</pos>
<hw>Vil"lan*ous*ly</hw>, <pos>adv.</pos>, <hw>Vil"lan*ous*ness</hw>,
<pos>n.</pos>,</mhw> <def>See <er>Villainous</er>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villany</ent><br/
<hw>Vil"lan*y</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Villainy</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villatic</ent><br/
<hw>Vil*lat"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>villaticus</ets> belonging to a country house. See
<er>Village</er>.]</ety> <def>Of or pertaining to a farm or a village;
rural.</def> <ldquo/Tame <xex>villatic</xex> fowl.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villein</ent><br/
<hw>Vil"lein</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Feudal Law)</fld>
<def>See <er>Villain</er>, 1.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villenage</ent><br/
<hw>Vil"len*age</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Villanage</er>.]</ety> <fld>(Feudal Law)</fld> <def>Villanage.</def>
<rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villenous</ent><br/
<hw>Vil"len*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to a villein.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villi</ent><br/
\'d8<hw>Vil"li</hw> <pr>(?)</pr>, <pos>n.</pos>, <def><pluf>pl.</pluf>
of <er>Villus</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villiform</ent><br/
<hw>Vil"li*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Villus</ets>
+ <ets>-form</ets>.]</ety> <def>Having the form or appearance of villi;
like close-set fibers, either hard or soft; <as>as, the teeth of perch
are <ex>villiform</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villose</ent><br/
<hw>Vil*lose"</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Bot.)</fld>
<def>See <er>Villous</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villosity</ent><br/
<hw>Vil*los"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>State
of being villous.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>A coating of long, slender
hairs.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Anat.)</fld> <def>A villus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villous</ent><br/
<hw>Vil"lous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>villosus</ets>: cf. F. <ets>villeux</ets>. Cf.
<er>Velvet</er>.]</ety> <sn>1.</sn> <def>Abounding in, or covered with,
fine hairs, or a woolly substance; shaggy with soft hairs;
nappy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat.)</fld> <def>Furnished or clothed with
villi.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Villus</ent><br/
\'d8<hw>Vil"lus</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Villi</plw> <pr>(#)</pr>.</plu> <ety>[L., shaggy hair, a tuft of
hair.]</ety> <sn>1.</sn> <fld>(Anat.)</fld> <def>One of the minute
papillary processes on certain vascular membranes; a villosity; <as>as,
<ex>villi</ex> cover the lining of the small intestines of many animals
and serve to increase the absorbing surface</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <pluf>pl.</pluf> <fld>(Bot.)</fld> <def>Fine hairs on
plants, resembling the pile of velvet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vim</ent><br/
<hw>Vim</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., accusative of
<ets>vis</ets> strength.]</ety> <def>Power; force; energy; spirit;
activity; vigor.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vimen</ent><br/
\'d8<hw>Vi"men</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a twig.]</ety>
<fld>(Bot.)</fld> <def>A long, slender, flexible shoot or
branch.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viminal</ent><br/
<hw>Vim"i*nal</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>viminalis</ets> pertaining to osiers, fr. <ets>vimen</ets> a pliant
twig, osier.]</ety> <def>Of or pertaining to twigs; consisting of twigs;
producing twigs.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vimineous</ent><br/
<hw>Vi*min"e*ous</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>vimineus</ets>, fr. <ets>vimen</ets> pliant twig.]</ety>
<sn>1.</sn> <def>Of or pertaining to twigs; made of pliant twigs.</def>
<ldquo/In the hive's <xex>vimineous</xex> dome.<rdquo/
<rj><au>Prior.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Producing long, slender twigs or
shoots.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinaceous</ent><br/
<hw>Vi*na"ceous</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>vinaceus</ets>. See <er>Vine</er>.]</ety> <sn>1.</sn>
<def>Belonging to, or like, wine or grapes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of the color of wine, especially of red
wine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinaigrette</ent><br/
<hw>Vin`ai*grette"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr.
<ets>vinaigre</ets> vinegar.]</ety> <sn>1.</sn> <fld>(Cookery)</fld>
<def>A sauce, made of vinegar, oil, and other ingredients, -- used esp.
for cold meats.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A small perforated box for holding aromatic vinegar
contained in a sponge, or a smelling bottle for smelling salts; --
called also <altname>vinegarette</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A small, two-wheeled vehicle, like a Bath chair, to
be drawn or pushed by a boy or man.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinaigrous</ent><br/
<hw>Vin"ai*grous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F.
<ets>vinaigre</ets> vinegar.]</ety> <sn>1.</sn> <def>Resembling vinegar;
sour.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <mark>[Fig.]</mark>: <def>Unamiable; morose.</def>
<rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinasse</ent><br/
<hw>Vi*nasse"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<fld>(Chem.)</fld> <def>The waste liquor remaining in the process of
making beet sugar, -- used in the manufacture of potassium
carbonate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinatico</ent><br/
<hw>Vi*nat"i*co</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Pg.
<ets>vinhatico</ets>.]</ety> <def>Madeira mahogany; the coarse,
dark-colored wood of the <spn>Persea Indica</spn>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vincentian</ent><br/
<hw>Vin*cen"tian</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to <person>Saint <etsep>Vincent</etsep> de Paul</person>, or founded by
him.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vincentian</ent><br/
<hw>Vin*cen"tian</hw>, <pos>n.</pos> <fld>(R. C. Ch.)</fld> <sd>(a)</sd>
<def>Same as <er>Lazarist</er>.</def> <sd>(b)</sd> <def>A member of
certain charitable sisterhoods.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vincetoxin</ent><br/
<hw>Vin`ce*tox"in</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>A glucoside extracted from the root of the white swallowwort
(<spn>Vincetoxicum officinale</spn>, a plant of the Asclepias family) as
a bitter yellow amorphous substance; -- called also
<altname>asclepiadin</altname>, and
<altname>cynanchin</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vincibility</ent><br/
<hw>Vin`ci*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being vincible, vincibleness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vincible</ent><br/
<hw>Vin"ci*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vincibilis</ets>, fr. <ets>vincere</ets> to vanquish, conquer: cf.
F. <ets>vincible</ets>. See <er>Victor</er>.]</ety> <def>Capable of
being overcome or subdued; conquerable.</def> <ldquo/He, not
<xex>vincible</xex> in spirit . . . drew his sword.<rdquo/
<au>Hayward.</au> <ldquo/<xex>Vincible</xex> by human aid.<rdquo/
<au>Paley.</au><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vincible ignorance</b></col> <fld>(Theol.)</fld>,
<cd>ignorance within the individual's control and for which, therefore,
he is responsible before God.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vincibleness</ent><br/
<hw>Vin"ci*ble*ness</hw>, <pos>n.</pos> <def>The quality or state of
being vincible.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vincture</ent><br/
<hw>Vinc"ture</hw> <pr>(?; 135)</pr>, <pos>n.</pos> <ety>[L.
<ets>vinctura</ets>, fr. <ets>vincire</ets>, <ets>vinctum</ets>, to
bind.]</ety> <def>A binding.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinculum</ent><br/
\'d8<hw>Vin"cu*lum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
L. <plw>Vincula</plw> <pr>(#)</pr>, E. <plw>Vinculums</plw>
<pr>(#)</pr>.</plu> <ety>[L., from <ets>vincire</ets>,
<ets>vinctum</ets>, to bind.]</ety> <sn>1.</sn> <def>A bond of union; a
tie.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Math.)</fld> <def>A straight, horizontal mark
placed over two or more members of a compound quantity, which are to be
subjected to the same operation, as in the expression
<mathex>x<exp>2</exp> + y<exp>2</exp> - <vinc>x +
y</vinc></mathex>.</def> <-- the same effect is more usually obtained by
enclosing the expression under the vinculum in parentheses. --><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Anat.)</fld> <def>A band or bundle of fibers; a
fraenum.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>A commissure uniting the two main
tendons in the foot of certain birds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vindemial</ent><br/
<hw>Vin*de"mi*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vindemialis</ets>, fr. <ets>vindemia</ets> a vintage. See
<er>Vintage</er>.]</ety> <def>Of or pertaining to a vintage, or grape
harvest.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vindemiate</ent><br/
<hw>Vin*de"mi*ate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[L.
<ets>vindemiare</ets>. See <er>Vindemial</er>.]</ety> <def>To gather the
vintage.</def> <mark>[Obs.]</mark> <rj><au>Evelyn.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vindemiation</ent><br/
<hw>Vin*de`mi*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL.
<ets>vindemiatio</ets>.]</ety> <def>The operation of gathering
grapes.</def> <mark>[Obs.]</mark> <rj><au>Bailey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vindicable</ent><br/
<hw>Vin"di*ca*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being
vindicated.</def> -- <wordforms><wf>Vin`di*ca*bil"i*ty</wf>
<pr>(#)</pr>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vindicate</ent><br/
<hw>Vin"di*cate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vindicated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vindicating</conjf>.]</vmorph> <ety>[L.
<ets>vindicatus</ets>, p. p. of <ets>vindicare</ets> to lay claim to,
defend, avenge. See <er>Vengeance</er>.]</ety> <sn>1.</sn> <def>To lay
claim to; to assert a right to; to claim.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Is thine alone the seed that strews the plain?<br/
The birds of heaven shall <qex>vindicate</qex> their grain.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To maintain or defend with success; to prove to be
valid; to assert convincingly; to sustain against assault; <as>as, to
<ex>vindicate</ex> a right, claim, or title</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To support or maintain as true or correct, against
denial, censure, or objections; to defend; to justify.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When the respondent denies any proposition, the opponent must
directly <qex>vindicate</qex> . . . that proposition.</q> <rj><qau>I.
Watts.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Laugh where we must, be candid where we can,<br/
But <qex>vindicate</qex> the ways of God to man.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To maintain, as a law or a cause, by overthrowing
enemies.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To liberate; to set free; to deliver.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I am confident he deserves much more<br/
That <qex>vindicates</qex> his country from a tyrant<br/
Than he that saves a citizen.</q> <rj><qau>Massinger.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To avenge; to punish; <as>as, a war to
<ex>vindicate</ex> or punish infidelity</as>.</def> <mark>[Obs.]</mark>
<rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>God is more powerful to exact subjection and to
<qex>vindicate</qex> rebellion.</q> <rj><qau>Bp. Pearson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To assert; maintain; claim. See
<er>Assert</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vindication</ent><br/
<hw>Vin`di*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vindicatio</ets> a laying claim, defense, vindication. See
<er>Vindicate</er>.]</ety> <sn>1.</sn> <def>The act of vindicating, or
the state of being vindicated; defense; justification against denial or
censure; <as>as, the <ex>vindication</ex> of opinions; his
<ex>vindication</ex> is complete</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Occasion for the <qex>vindication</qex> of this passage in my
book.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Civil Law)</fld> <def>The claiming a thing as one's
own; the asserting of a right or title in, or to, a thing.</def>
<rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vindicative</ent><br/
<hw>Vin"di*ca*tive</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vindicatif</ets>. Cf. <er>Vindictive</er>.]</ety> <sn>1.</sn>
<def>Tending to vindicate; vindicating; <as>as, a <ex>vindicative</ex>
policy</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Revengeful; vindictive.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vindicative</qex> persons live the life of witches, who, as
they are mischievous, so end they infortunate.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vin"di*ca*tive*ness</wf>,
<pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vindicator</ent><br/
<hw>Vin"di*ca`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL., an
avenger.]</ety> <def>One who vindicates; one who justifies or
maintains.</def> <rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vindicatory</ent><br/
<hw>Vin"di*ca*to*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn>
<def>Tending or serving to vindicate or justify; justificatory;
vindicative.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Inflicting punishment; avenging; punitory.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The afflictions of Job were no <qex>vindicatory</qex> punishments
to take vengeance of his sins.</q> <rj><qau>Abp.
Bramhall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vindictive</ent><br/
<hw>Vin*dic"tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[For
<ets>vindicative</ets>, confused with L. <ets>vindicta</ets> revenge,
punishment, fr. <ets>vindicare</ets> to vindicate. Cf.
<er>Vindicative</er>.]</ety> <sn>1.</sn> <def>Disposed to revenge;
prompted or characterized by revenge; revengeful.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I am <qex>vindictive</qex> enough to repel force by force.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Punitive.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vindictive damages</b></col>. <fld>(Law)</fld> <cd>See
under <er>Damage</er>, <pos>n.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vin*dic"tive*ly</wf>, <pos>adv.</pos> --
<wf>Vin*dic"tive*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vine</ent><br/
<hw>Vine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>vigne</ets>, L.
<ets>vinea</ets> a vineyard, vine from <ets>vineus</ets> of or belonging
to wine, <ets>vinum</ets> wine, grapes. See <er>Wine</er>, and cf.
<er>Vignette</er>.]</ety> <fld>(Bot.)</fld> <sd>(a)</sd> <def>Any woody
climbing plant which bears grapes.</def> <sd>(b)</sd> <def>Hence, a
climbing or trailing plant; the long, slender stem of any plant that
trails on the ground, or climbs by winding round a fixed object, or by
seizing anything with its tendrils, or claspers; a creeper; <as>as, the
hop <ex>vine</ex>; the bean <ex>vine</ex>; the <ex>vines</ex> of melons,
squashes, pumpkins, and other cucurbitaceous plants.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>There shall be no grapes on the <qex>vine</qex>.</q> <rj><qau>Jer.
viii. 13.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And one went out into the field to gather herbs, and found a wild
<qex>vine</qex>, and gathered thereof wild gourds.</q> <rj><qau>2 Kings
iv. 89.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vine apple</b></col> <fld>(Bot.)</fld>, <cd>a small kind
of squash.</cd> <au>Roger Williams.</au> -- <col><b>Vine
beetle</b></col> <fld>(Zool.)</fld>, <cd>any one of several species of
beetles which are injurious to the leaves or branches of the grapevine.
Among the more important species are the grapevine fidia (see
<er>Fidia</er>), the spotted Pelidnota (<spn>Pelidnota punctata</spn>)
(see <er>Rutilian</er>), the vine fleabeetle (<spn>Graptodera
chalybea</spn>), the rose beetle (see under <er>Rose</er>), the vine
weevil, and several species of <gen>Colaspis</gen> and
<gen>Anomala</gen>.</cd> -- <col><b>Vine borer</b></col>.
<fld>(Zool.)</fld> <sd>(a)</sd> <cd>Any one of several species of
beetles whose larvae bore in the wood or pith of the grapevine,
especially <spn>Sinoxylon basilare</spn>, a small species the larva of
which bores in the stems, and <spn>Ampeloglypter sesostris</spn>, a
small reddish brown weevil (called also <altname>vine weevil</altname>),
which produces knotlike galls on the branches.</cd> <sd>(b)</sd> <cd>A
clearwing moth (<spn>Aegeria polistiformis</spn>), whose larva bores in
the roots of the grapevine and is often destructive.</cd> --
<col><b>Vine dragon</b></col>, <cd>an old and fruitless branch of a
vine.</cd> <mark>[Obs.]</mark> <au>Holland.</au> -- <col><b>Vine
forester</b></col> <fld>(Zool.)</fld>, <cd>any one of several species of
moths belonging to <gen>Alypia</gen> and allied genera, whose larvae
feed on the leaves of the grapevine.</cd> -- <col><b>Vine
fretter</b></col> <fld>(Zool.)</fld>, <cd>a plant louse, esp. the
phylloxera that injuries the grapevine.</cd> -- <col><b>Vine
grub</b></col> <fld>(Zool.)</fld>, <cd>any one of numerous species of
insect larvae that are injurious to the grapevine.</cd> -- <col><b>Vine
hopper</b></col> <fld>(Zool.)</fld>, <cd>any one of several species of
leaf hoppers which suck the sap of the grapevine, especially
<spn>Erythroneura vitis</spn>. See <xex>Illust.</xex> of <cref>Grape
hopper</cref>, under <er>Grape</er>.</cd> -- <col><b>Vine
inchworm</b></col> <fld>(Zool.)</fld>, <cd>the larva of any species of
geometrid moths which feed on the leaves of the grapevine, especially
<spn>Cidaria diversilineata</spn>.</cd> -- <col><b>Vine-leaf
rooer</b></col> <fld>(Zool.)</fld>, <cd>a small moth (<spn>Desmia
maculalis</spn>) whose larva makes a nest by rolling up the leaves of
the grapevine. The moth is brownish black, spotted with white.</cd> --
<col><b>Vine louse</b></col> <fld>(Zool.)</fld>, <cd>the
phylloxera.</cd> -- <col><b>Vine mildew</b></col> <fld>(Bot.)</fld>,
<cd>a fungous growth which forms a white, delicate, cottony layer upon
the leaves, young shoots, and fruit of the vine, causing brown spots
upon the green parts, and finally a hardening and destruction of the
vitality of the surface. The plant has been called <spn>Oidium
Tuckeri</spn>, but is now thought to be the conidia-producing stage of
an <gen>Erysiphe</gen>.</cd> -- <col><b>Vine of Sodom</b></col>
<fld>(Bot.)</fld>, <cd>a plant named in the Bible (<au>Deut. xxxii.
32</au>), now thought to be identical with the apple of Sodom. See
<cref>Apple of Sodom</cref>, under <er>Apple</er>.</cd> -- <col><b>Vine
sawfly</b></col> <fld>(Zool.)</fld>, <cd>a small black sawfiy
(<spn>Selandria vitis</spn>) whose larva feeds upon the leaves of the
grapevine. The larvae stand side by side in clusters while feeding.</cd>
-- <col><b>Vine slug</b></col> <fld>(Zool.)</fld>, <cd>the larva of the
vine sawfly.</cd> -- <col><b>Vine sorrel</b></col> <fld>(Bot.)</fld>,
<cd>a climbing plant (<spn>Cissus acida</spn>) related to the grapevine,
and having acid leaves. It is found in Florida and the West Indies.</cd>
-- <col><b>Vine sphinx</b></col> <fld>(Zool.)</fld>, <cd>any one of
several species of hawk moths. The larvae feed on grapevine leaves.</cd>
-- <col><b>Vine weevil</b></col>. <fld>(Zool.)</fld> <cd>See <cref>Vine
borer</cref> <sd>(a)</sd> above, and <cref>Wound gall</cref>, under
<er>Wound</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1611 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vineal</ent><br/
<hw>Vi"ne*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vinealis</ets>.]</ety> <def>Of or pertaining to vines; containing
vines.</def> <mark>[R.]</mark> <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vine-clad</ent><br/
<hw>Vine"-clad`</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Covered with
vines.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vined</ent><br/
<hw>Vined</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having leaves like those
of the vine; ornamented with vine leaves.</def> <ldquo/<xex>Vined</xex>
and figured columns.<rdquo/ <rj><au>Sir H. Wotton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinedresser</ent><br/
<hw>Vine"dress`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who
cultivates, prunes, or cares for, grapevines; a laborer in a
vineyard.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The sons of the shall be your plowmen and your
<qex>vinedressers</qex>.</q> <rj><qau>Isa. lxi. 5.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinegar</ent><br/
<hw>Vin"e*gar</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vinegre</ets>, F. <ets>vinaigre</ets>; vin wine (L.
<ets>vinum</ets>) + <ets>aigre</ets> sour. See <er>Wine</er>, and
<er>Eager</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>A sour liquid used
as a condiment, or as a preservative, and obtained by the spontaneous
(<xex>acetous</xex>) fermentation, or by the artificial oxidation, of
wine, cider, beer, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The characteristic sourness of vinegar is due to acetic
acid, of which it contains from three to five per cent. Wine vinegar
contains also tartaric acid, citric acid, etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, anything sour; -- used also
metaphorically.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Here's the challenge: . . . I warrant there's <qex>vinegar</qex>
and pepper in't.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Aromatic vinegar</b></col>, <cd>strong acetic acid highly
flavored with aromatic substances.</cd> -- <col><b>Mother of
vinegar</b></col>. <cd>See 4th <er>Mother</er>.</cd> -- <col><b>Radical
vinegar</b></col>, <cd>acetic acid.</cd> -- <col><b>Thieves'
vinegar</b></col>. <cd>See under <er>Thief</er>.</cd> -- <col><b>Vinegar
eel</b></col> <fld>(Zool.)</fld>, <cd>a minute nematode worm
(<spn>Leptodera oxophila</spn>, or <spn>Anguillula acetiglutinis</spn>),
commonly found in great numbers in vinegar, sour paste, and other
fermenting vegetable substances; -- called also <altname>vinegar
worm</altname>.</cd> -- <col><b>Vinegar lamp</b></col>
<fld>(Chem.)</fld>, <cd>a fanciful name of an apparatus designed to
oxidize alcohol to acetic acid by means of platinum.</cd> --
<col><b>Vinegar plant</b></col>. <cd>See 4th <er>Mother</er>.</cd> --
<col><b>Vinegar tree</b></col> <fld>(Bot.)</fld>, <cd>the stag-horn
sumac (<spn>Rhus typhina</spn>), whose acid berries have been used to
intensify the sourness of vinegar.</cd> -- <col><b>Wood
vinegar</b></col>. <cd>See under <er>Wood</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinegar</ent><br/
<hw>Vin"e*gar</hw>, <pos>v. t.</pos> <def>To convert into vinegar; to
make like vinegar; to render sour or sharp.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Hoping that he hath <qex>vinegared</qex> his senses<br/
As he was bid.</q> <rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinegarette</ent><br/
<hw>Vin`e*gar*ette"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Vinaigrette</er>, <pos>n.</pos>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinegar fly</ent><br/
<hw>Vin"e*gar fly</hw>. <def>Any of several fruit flies, esp.
<spn>Drosophila ampelopophila</spn>, which breed in imperfectly sealed
preserves and in pickles.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vinegarroon</ent><br/
<hw>Vin`e*gar*roon"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Sp.
<ets>vinagre</ets> vinegar.]</ety> <def>A whip scorpion, esp. a large
Mexican species (<spn>Thelyphonus giganteus</spn>) popularly supposed to
be very venomous; -- from the odor that it emits when alarmed.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vinegary</ent><br/
<hw>Vin"e*gar*y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having the nature
of vinegar; sour; unamiable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viner</ent><br/
<hw>Vin"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A vinedresser.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinery</ent><br/
<hw>Vin"er*y</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A
vineyard.</def> <mark>[Obs.]</mark> <ldquo/The <xex>vinery</xex> of
Ramer.<rdquo/ <rj><au>Fabyan.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A structure, usually inclosed with glass, for
rearing and protecting vines; a grapery.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinette</ent><br/
<hw>Vi*nette"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Vignette</er>.]</ety> <def>A sprig or branch.</def>
<mark>[Archaic]</mark> <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinewed</ent><br/
<hw>Vin"ewed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Same as
<er>Vinnewed</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vineyard</ent><br/
<hw>Vine"yard</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[For OE.
<ets>winyard</ets>, AS. <ets>w<imac/ngeard</ets>; influenced by E.
<ets>vine</ets>. See <er>Wine</er>, and <er>Yard</er> an
inclosure.]</ety> <def>An inclosure or yard for grapevines; a plantation
of vines producing grapes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vineyardist</ent><br/
<hw>Vine"yard*ist</hw>, <pos>n.</pos> <def>One who cultivates a
vineyard.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vingt et un</ent><br/
\'d8<hw>Vingt` et` un"</hw> <pr>(?)</pr>. <ety>[F., twenty and
one.]</ety> <def>A game at cards, played by two or more persons. The
fortune of each player depends upon obtaining from the dealer such cards
that the sum of their pips, or spots, is twenty-one, or a number near to
it; -- also called <altname>blackjack</altname>, or
<altname>twenty-one</altname>.</def> <note>There are several variations
(such as <stype>Caribbean blackjack</stype>). In the most common
variation played in casinos, there is one dealer who plays for the
house, and up to seven players. The players and dealer each receive two
cards, the dealer's cards usually being one face up and one face down.
The players each in turn decide whether they will request additional
cards (<ldquo/hit<rdquo/), the objective being to reach a sum of card
values as close as possible to twenty-one, without exceeding that
number. If, on hitting, the player's total card values exceed 21, he has
<ldquo/busted<rdquo/, and lost his bet. Otherwise, the player wins only
if his total card values exceed those of the dealer. <ldquo/picture
cards<rdquo/ (or <ldquo/face cards<rdquo/, being the jack, queen, and
king) are counted as having a value of ten. The ace may count as one or
eleven, at the player's option. Other than to hit, there are also other
possible actions by the player, such as to <ldquo/double down<rdquo/
(receive only one additional card, while doubling the initial bet), or
to <ldquo/split<rdquo/ (if the first two cards have the same
value).</note><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Vingtun</ent><br/
<hw>Vingt`un"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Contraction for
<er>Vingt et un</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinic</ent><br/
<hw>Vin"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of
or pertaining to wine; <as>as, <ex>vinic</ex> alcohol</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viniculture</ent><br/
<hw>Vin"i*cul`ture</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vinum</ets> wine + <ets>cultura</ets> culture.]</ety> <def>The
cultivation of the vine, esp. for making wine; viticulture.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinification</ent><br/
<hw>Vin`i*fi*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vinum</ets> wine + E. <ets>-fication</ets>.]</ety> <def>The
conversion of a fruit juice or other saccharine solution into alcohol by
fermentation.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vinnewed</ent><br/
<hw>Vin"newed</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Fenowed</er>.]</ety> <def>Moldy; musty.</def> <altsp>[Written also
<asp>vinewed</asp>.]</altsp> <mark>[Obs. or Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vin"newed*ness</wf>, <pos>n.</pos>
<mark>[Obs.]</mark></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>Many of Chaucer's words are become, as it were,
<qex>vinnewed</qex> and hoary with over-long lying.</q> <rj><qau>F.
Beaumont.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinny</ent><br/
<hw>Vin"ny</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Vinnewed.</def>
<mark>[Obs. or Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinolency</ent><br/
<hw>Vin"o*len*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vinolentina</ets>. See <er>Vinolent</er>.]</ety>
<def>Drunkennes.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinolent</ent><br/
<hw>Vin"o*lent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vinolentus</ets>, fr. <ets>vinum</ets> wine.]</ety> <def>Given to
wine; drunken; intemperate.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinometer</ent><br/
<hw>Vin*om"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vinum</ets> vine + <ets>-meter</ets>.]</ety> <def>An instrument for
determining the strength or purity of wine by measuring its
density.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vin ordinaire</ent><br/
\'d8<hw>Vin` or`di`naire"</hw> <pr>(?)</pr>. <ety>[F., lit., common
wine.]</ety> <def>A cheap claret, used as a table wine in
France.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinose</ent><br/
<hw>Vi*nose"</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Vinous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinosity</ent><br/
<hw>Vi*nos"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vinositas</ets>: cf. F. <ets>vinosit<eacute/</ets>.]</ety> <def>The
quality or state of being vinous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinous</ent><br/
<hw>Vi"nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vinosus</ets>, fr. <ets>vinum</ets> wine: cf. F. <ets>vineux</ets>.
See <er>Wine</er>.]</ety> <def>Of or pertaining to wine; having the
qualities of wine; <as>as, a <ex>vinous</ex> taste</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinquish</ent><br/
<hw>Vin"quish</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Far.)</fld>
<def>See <er>Vanquish</er>, <pos>n.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vintage</ent><br/
<hw>Vint"age</hw> <pr>(?; 48)</pr>, <pos>n.</pos> <ety>[Corrupted by
influence of <ets>vintner</ets>, <ets>vintry</ets>, from OE.
<ets>vindage</ets>, <ets>vendage</ets>, for <ets>vendange</ets>, OF.
<ets>vendenge</ets>, F. <ets>vendange</ets>, from L.
<ets>vindemia</ets>; <ets>vinum</ets> wine, grapes + <ets>demere</ets>
to take off; <ets>de + emere</ets>, originally, to take. See
<er>Wine</er>, <er>Redeem</er>, and cf. <er>Vindemial</er>.]</ety>
<sn>1.</sn> <def>The produce of the vine for one season, in grapes or in
wine; <as>as, the <ex>vintage</ex> is abundant; the <ex>vintage</ex> of
1840</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The act or time of gathering the crop of grapes, or
making the wine for a season.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vintage spring</b></col>, <cd>a wine fount.</cd> --
<col><b>Vintage time</b></col>, <cd>the time of gathering grapes and
making wine.</cd> <rj><au>Milton.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vintager</ent><br/
<hw>Vint"a*ger</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From
<er>Vintage</er>: cf. F. <ets>vendangeur</ets>.]</ety> <def>One who
gathers the vintage.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vintaging</ent><br/
<hw>Vint"a*ging</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of
gathering the vintage, or crop of grapes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vintner</ent><br/
<hw>Vint"ner</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vintener</ets>, <ets>viniter</ets>, OF. <ets>vinetier</ets>,
<ets>vinotier</ets>, LL. <ets>vinetarius</ets>, fr. L.
<ets>vinetum</ets> a vineyard, fr. <ets>vinum</ets> wine. See
<er>Wine</er>.]</ety> <def>One who deals in wine; a wine seller, or wine
merchant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vintry</ent><br/
<hw>Vint"ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>viniterie</ets>, from OF. <ets>vinotier</ets>, <ets>vinetier</ets>,
wine merchant. See <er>Vintner</er>.]</ety> <def>A place where wine is
sold.</def> <mark>[Obs.]</mark> <rj><au>Ainsworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinum</ent><br/
\'d8<hw>Vi"num</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu>pl.
<plw>Vina</plw> <pr>(#)</pr></plu>. <ety>[L. See <er>Wine</er>.]</ety>
<def>Wine, -- chiefly used in <fld>Pharmacy</fld> in the name of
solutions of some medicinal substance in wine; as: <col><b>vina
medicata</b></col>, medicated wines; <col><b>vinum opii</b></col>, wine
of opium.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Viny</ent><br/
<hw>Vin"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to
vines; producing, or abounding in, vines.</def> <rj><au>P.
Fletcher.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vinyl</ent><br/
<hw>Vi"nyl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>vinum</ets>
wine + <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld> <def>The hypothetical
radical <chform>C2H3</chform>, regarded as the characteristic residue of
ethylene and that related series of unsaturated hydrocarbons with which
the allyl compounds are homologous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viol</ent><br/
<hw>Vi"ol</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>viole</ets>;
cf. Pr. <ets>viola</ets>, <ets>viula</ets>, Sp., Pg., & It.
<ets>viola</ets>, LL. <ets>vitula</ets>; of uncertain origin; perhaps
from L. <ets>vitulari</ets> to celebrate a festival, keep holiday, be
joyful, perhaps originally, to sacrifice a calf (<ets>vitulus</ets>; cf.
<er>Veal</er>). Cf. <er>Fiddle</er>, <er>Vielle</er>, 2d <er>Viola</er>,
<er>Violin</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Mus.)</fld> <def>A stringed musical instrument
formerly in use, of the same form as the violin, but larger, and having
six strings, to be struck with a bow, and the neck furnished with frets
for stopping the strings.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Me softer airs befit, and softer strings<br/
Of lute, or <qex>viol</qex> still, more apt for mournful things.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The name is now applied as a general term to designate
instruments of the violin kind, as <xex>tenor viol</xex>, <xex>bass
viol</xex>, etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>A large rope sometimes used in
weighing anchor.</def> <altsp>[Written also <asp>voyal</asp>, and
<asp>voyal</asp>.]</altsp> <rj><au>Totten.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viola</ent><br/
\'d8<hw>Vi"o*la</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a violet. See
<er>Violet</er>.]</ety> <fld>(Bot.)</fld> <def>A genus of polypetalous
herbaceous plants, including all kinds of violets.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viola</ent><br/
<hw>Vi"o*la</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It. See
<er>Viol</er>.]</ety> <fld>(Mus.)</fld> <def>An instrument in form and
use resembling the violin, but larger, and a fifth lower in
compass.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs>\'d8<col><b>Viola da braccio</b></col> <ety>[It., viol for the
arm]</ety>, <cd>the tenor viol, or viola, a fifth lower than the violin.
Its part is written in the alto clef, hence it is sometimes called the
<altname>alto</altname>.</cd> -- \'d8<col><b>Viola da gamba</b></col>
<ety>[It., viol for the leg]</ety>, <cd>an instrument resembling the
viola, but larger, and held between the knees. It is now rarely
used.</cd> -- \'d8<col><b>Viola da spalla</b></col> <ety>[It., viol for
the shoulder]</ety>, <cd>an instrument formerly used, resembling the
viola, and intermediate in size between the viola and the viola da
gamba.</cd> -- \'d8<col><b>Viola di amore</b></col> <ety>[It., viol of
love: cf. F. <ets>viole d'amour</ets>]</ety>, <cd>a viol, larger than
the viola, having catgut strings upon, and brass or steel wires under,
the keyboard. These, sounding sympathetically with the strings, yield a
peculiarly soft and silvery sound. It is now seldom used.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violable</ent><br/
<hw>Vi"o*la*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>violabilis</ets>: cf. F. <ets>violable</ets>. See
<er>Violate</er>.]</ety> <def>Capable of being violated, broken, or
injured.</def> -- <wordforms><wf>Vi"o*la*bly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violaceous</ent><br/
<hw>Vi`o*la"ceous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>violaceus</ets>, fr. <ets>viola</ets> a violet.]</ety> <sn>1.</sn>
<def>Resembling violets in color; bluish purple.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Of or pertaining to a natural
order of plants, of which the violet is the type. It contains about
twenty genera and two hundred and fifty species.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violaniline</ent><br/
<hw>Vi`o*lan"i*line</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Viol</ets>et + <ets>aniline</ets>.]</ety> <fld>(Chem.)</fld>
<def>A dyestuff of the induline group, made from aniline, and used as a
substitute for indigo in dyeing wool and silk a violet-blue or a
gray-blue color.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violantin</ent><br/
<hw>Vi`o*lan"tin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Violuric</er>.]</ety> <fld>(Chem.)</fld> <def>A complex nitrogenous
substance, produced as a yellow crystalline substance, and regarded as a
complex derivative of barbituric acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violaquercitrin</ent><br/
<hw>Vi`o*la*quer"cit*rin</hw> <pr>(?)</pr>, <pos>n.</pos>
<fld>(Chem.)</fld> <def>A yellow crystalline glucoside obtained from the
pansy (<spn>Viola tricolor</spn>), and decomposing into glucose and
quercitrin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violascent</ent><br/
<hw>Vi`o*las"cent</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Violescent.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violate</ent><br/
<hw>Vi"o*late</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Violates</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Violating</conjf>.]</vmorph> <ety>[L.
<ets>violatus</ets>, p. p. of <ets>violare</ets> to violate, fr.
<ets>vis</ets> strength, force. See <er>Violent</er>.]</ety> <sn>1.</sn>
<def>To treat in a violent manner; to abuse.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His wife Boadicea <qex>violated</qex> with stripes, his daughters
with rape.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To do violence to, as to anything that should be
held sacred or respected; to profane; to desecrate; to break forcibly;
to trench upon; to infringe.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Violated</qex> vows<br/
'Twixt the souls of friend and friend.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Oft have they <qex>violated</qex><br/
The temple, oft the law, with foul affronts.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To disturb; to interrupt.</def> <ldquo/Employed, it
seems, to <xex>violate</xex> sleep.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To commit rape on; to ravish; to outrage.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To injure; disturb; interrupt; infringe;
transgress; profane; deflour; debauch; dishonor.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violation</ent><br/
<hw>Vi`o*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>violatio</ets>: cf. F. <ets>violation</ets>.]</ety> <def>The act of
violating, treating with violence, or injuring; the state of being
violated.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>Infringement; transgression; nonobservance; as, the
<xex>violation</xex> of law or positive command, of covenants, promises,
etc.</def> <ldquo/The <xex>violation</xex> of my faith.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>An act of irreverence or desecration; profanation
or contemptuous treatment of sacred things; <as>as, the
<ex>violation</ex> of a church</as>.</def> <rj><au>Udall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>Interruption, as of sleep or peace;
disturbance.</def><br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <def>Ravishment; rape; outrage.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violative</ent><br/
<hw>Vi"o*la*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Violating, or
tending to violate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violator</ent><br/
<hw>Vi"o*la`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety>
<def>One who violates; an infringer; a profaner; a ravisher.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viole</ent><br/
<hw>Vi"ole</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A vial.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violence</ent><br/
<hw>Vi"o*lence</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L.
<ets>violentia</ets>. See <er>Violent</er>.]</ety> <sn>1.</sn> <def>The
quality or state of being violent; highly excited action, whether
physical or moral; vehemence; impetuosity; force.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That seal<br/
You ask with such a <qex>violence</qex>, the king,<br/
Mine and your master, with his own hand gave me.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>All the elements<br/
At least had gone to wrack, disturbed and torn<br/
With the <qex>violence</qex> of this conflict.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Injury done to that which is entitled to respect,
reverence, or observance; profanation; infringement; unjust force;
outrage; assault.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Do <qex>violence</qex> to do man.</q> <rj><qau>Luke iii.
14.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>We can not, without offering <qex>violence</qex> to all records,
divine and human, deny an universal deluge.</q> <rj><qau>T.
Burnet.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Looking down, he saw<br/
The whole earth filled with <qex>violence</qex>.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Ravishment; rape; constupration.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To do violence on</b></col>, <cd>to attack; to
murder.</cd> <ldquo/She . . . <xex>did violence on</xex> herself.<rdquo/
<au>Shak.</au> -- <col><b>To do violence to</b></col>, <cd>to outrage;
to injure; <as>as, he <ex>does violence to</ex> his own
opinions</as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Vehemence; outrage; fierceness; eagerness;
violation; infraction; infringement; transgression;
oppression.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violence</ent><br/
<hw>Vi"o*lence</hw>, <pos>v. t.</pos> <def>To assault; to injure; also,
to bring by violence; to compel.</def> <mark>[Obs.]</mark> <rj><au>B.
Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violent</ent><br/
<hw>Vi"o*lent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F., from L.
<ets>violentus</ets>, from <ets>vis</ets> strength, force; probably akin
to Gr. <?/ a muscle, strength.]</ety> <sn>1.</sn> <def>Moving or acting
with physical strength; urged or impelled with force; excited by strong
feeling or passion; forcible; vehement; impetuous; fierce; furious;
severe; <as>as, a <ex>violent</ex> blow; the <ex>violent</ex> attack of
a disease.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Float upon a wild and <qex>violent</qex> sea.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>violent</qex> cross wind from either coast.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Acting, characterized, or produced by unjust or
improper force; outrageous; unauthorized; <as>as, a <ex>violent</ex>
attack on the right of free speech</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To bring forth more <qex>violent</qex> deeds.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Some <qex>violent</qex> hands were laid on Humphrey's life.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Produced or effected by force; not spontaneous;
unnatural; abnormal.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>These <qex>violent</qex> delights have <qex>violent</qex>
ends.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>No <qex>violent</qex> state can be perpetual.</q> <rj><qau>T.
Burnet.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Ease would recant<br/
Vows made in pain, as <qex>violent</qex> and void.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Violent presumption</b></col> <fld>(Law)</fld>,
<cd>presumption of a fact that arises from proof of circumstances which
necessarily attend such facts.</cd> -- <col><b>Violent profits</b></col>
<fld>(Scots Law)</fld>, <cd>rents or profits of an estate obtained by a
tenant wrongfully holding over after warning. They are recoverable in a
process of removing.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Fierce; vehement; outrageous; boisterous;
turbulent; impetuous; passionate; severe; extreme.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violent</ent><br/
<hw>Vi"o*lent</hw>, <pos>n.</pos> <def>An assailant.</def>
<mark>[Obs.]</mark> <rj><au>Dr. H. More.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violent</ent><br/
<hw>Vi"o*lent</hw>, <pos>v. t.</pos> <ety>[Cf. F.
<ets>violenter</ets>.]</ety> <def>To urge with violence.</def>
<mark>[Obs.]</mark> <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violent</ent><br/
<hw>Vi"o*lent</hw>, <pos>v. i.</pos> <def>To be violent; to act
violently.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The grief is fine, full, perfect, that I taste,<br/
And <qex>violenteth</qex> in a sense as strong<br/
As that which causeth it.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violently</ent><br/
<hw>Vi"o*lent*ly</hw>, <pos>adv.</pos> <def>In a violent
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violescent</ent><br/
<hw>Vi`o*les"cent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>viola</ets> a violet.]</ety> <def>Tending to a violet color;
violascent.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violet</ent><br/
<hw>Vi"o*let</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>violette</ets> a violet (cf. <ets>violet</ets> violet-colored),
dim. of OF. <ets>viole</ets> a violet, L. <ets>viola</ets>; akin to Gr.
<?/. Cf. <er>Iodine</er>.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>Any
plant or flower of the genus <gen>Viola</gen>, of many species. The
violets are generally low, herbaceous plants, and the flowers of many of
the species are blue, while others are white or yellow, or of several
colors, as the pansy (<spn>Viola tricolor</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The cultivated sweet violet is <spn>Viola odorata</spn>
of Europe. The common blue violet of the eastern United States is
<spn>Viola cucullata</spn>; the sand, or bird-foot, violet is <spn>Viola
pedata</spn>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The color of a violet, or that part of the spectrum
farthest from red. It is the most refrangible part of the
spectrum.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>In art, a color produced by a combination of red and
blue in equal proportions; a bluish purple color.</def>
<rj><au>Mollett.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>Any one of numerous species of
small violet-colored butterflies belonging to <gen>Lycaena</gen>, or
<gen>Rusticus</gen>, and allied genera.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1612 --><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Corn violet</b></col>. <cd>See under <er>Corn</er>.</cd>
-- <col><b>Dame's violet</b></col>. <fld>(Bot.)</fld> <cd>See
<er>Damewort</er>.</cd> -- <col><b>Dogtooth violet</b></col>.
<fld>(Bot.)</fld> <cd>See under <er>Dogtooth</er>.</cd> -- <col><b>Water
violet</b></col> <fld>(Bot.)</fld>, <cd>an aquatic European herb
(<spn>Hottonia palustris</spn>) with pale purplish flowers and
pinnatifid leaves.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violet</ent><br/
<hw>Vi"o*let</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>violet</ets>. See <er>Violet</er>, <pos>n.</pos>]</ety> <def>Dark
blue, inclining to red; bluish purple; having a color produced by red
and blue combined.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Violet shell</b></col> <fld>(Zool.)</fld>, <cd>any
species of Ianthina; -- called also <altname>violet snail</altname>. See
<er>Ianthina</er>.</cd> -- <col><b>Violet wood</b></col>, <cd>a name
given to several kinds of hard purplish or reddish woods, as king wood,
myall wood, and the wood of the <spn>Andira violacea</spn>, a tree of
Guiana.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violet-ear</ent><br/
<hw>Vi"o*let-ear`</hw>, <pos>n.</pos> <def>Any tropical humming bird of
the genus <gen>Petasophora</gen>, having violet or purplish ear
tufts.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Violet-tip</ent><br/
<hw>Vi"o*let-tip"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>A very handsome American butterfly (<spn>Polygonia
interrogationis</spn>). Its wings are mottled with various shades of red
and brown and have violet tips.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violin</ent><br/
<hw>Vi`o*lin"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It.
<ets>violino</ets>, dim. of <ets>viola</ets>. See <er>Viol</er>.]</ety>
<fld>(Mus.)</fld> <def>A small instrument with four strings, played with
a bow; a fiddle.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The violin is distinguished for the brilliancy and
gayety, as well as the power and variety, of its tones, and in the
orchestra it is the leading and most important instrument.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violine</ent><br/
<hw>Vi"o*line</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<sd>(a)</sd> <def>A pale yellow amorphous substance of alkaloidal nature
and emetic properties, said to have been extracted from the root and
foliage of the violet (<gen>Viola</gen>).</def> <sd>(b)</sd> <def>Mauve
aniline. See under <er>Mauve</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violinist</ent><br/
<hw>Vi`o*lin"ist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>violiniste</ets>, <ets>violoniste</ets>, It.
<ets>violonista</ets>.]</ety> <def>A player on the violin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violist</ent><br/
<hw>Vi"ol*ist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>violiste</ets>.]</ety> <def>A player on the viol.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violoncellist</ent><br/
<hw>Vi`o*lon*cel"list</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>violoncelliste</ets>, It. <ets>violoncellista</ets>.]</ety> <def>A
player on the violoncello.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violoncello</ent><br/
<hw>Vi`o*lon*cel"lo</hw> <pr>(?; 277)</pr>, <pos>n.</pos> <ety>[It.
<ets>violoncello</ets>, dim. of <ets>violone</ets> a bass viol. See
<er>Violone</er>.]</ety> <fld>(Mus.)</fld> <def>A stringed instrument of
music; a bass viol of four strings, or a bass violin with long, large
strings, giving sounds an octave lower than the viola, or tenor or alto
violin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violone</ent><br/
\'d8<hw>Vi`o*lo"ne</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It.
<ets>violone</ets>, augment. of <ets>viola</ets> a viol. See
<er>Viol</er>.]</ety> <fld>(Mus.)</fld> <def>The largest instrument of
the bass-viol kind, having strings tuned an octave below those of the
violoncello; the contrabasso; -- called also <altname>double
bass</altname>.</def> <altsp>[Written also
<asp>violono</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violous</ent><br/
<hw>Vi"o*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Violent.</def>
<mark>[Obs.]</mark> <rj><au>J. Fletcher.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Violuric</ent><br/
<hw>Vi`o*lu"ric</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Viol</ets>et
+ barbit<ets>uric</ets>.]</ety> <fld>(Chem.)</fld> <def>Of, pertaining
to, or designating, a complex nitroso derivative of barbituric acid. It
is obtained as a white or yellow crystalline substance, and forms
characteristic yellow, blue, and violet salts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>VIOXX</ent><br/
<hw>VI`OXX</hw> <pr>(v<imac/"<ocr/ks)</pr>, <pos>prop. n.</pos>
<ety>[Trade name, used by <company>Merck & Co.</company>]</ety>
<fld>(Chem. & Med.)</fld> <def>A trade name for
<er>rofecoxib</er>.</def> <mark>[Trade name]</mark><br/
[<source>PJC</source>]</p>

<p><ent>viper</ent><br/
<hw>vi"per</hw> <pr>(v<imac/"p<etil/r)</pr>, <pos>n.</pos> <ety>[F.
<ets>vip<egrave/re</ets>, L. <ets>vipera</ets>, probably contr. fr.
<ets>vivipera</ets>; <ets>vivus</ets> alive + <ets>parere</ets> to bring
forth, because it was believed to be the only serpent that brings forth
living young. Cf. <er>Quick</er>, <pos>a.</pos>, <er>Parent</er>,
<er>Viviparous</er>, <er>Wivern</er>, <er>Weever</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Zool.)</fld> <def>Any one of numerous species of
Old World venomous snakes belonging to <gen>Vipera</gen>,
<gen>Clotho</gen>, <gen>Daboia</gen>, and other genera of the family
<fam>Viperidae</fam>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There came a <qex>viper</qex> out of the heat, and fastened on his
hand.</q> <rj><qau>Acts xxviii. 3.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Among the best-known species are the European adder
(<spn>Pelias berus</spn>), the European asp (<spn>Vipera aspis</spn>),
the African horned viper (<spn>Vipera cerastes</spn>), and the Indian
viper (<spn>Daboia Russellii</spn>).</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A dangerous, treacherous, or malignant
person.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Who committed<br/
To such a <qex>viper</qex> his most sacred trust<br/
Of secrecy.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Loosely, any venomous or presumed venomous
snake.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Horned viper</b></col>. <fld>(Zool.)</fld> <cd>See
<er>Cerastes</er>.</cd> -- <col><b>Red viper</b></col>
<fld>(Zool.)</fld>, <cd>the copperhead.</cd> -- <col><b>Viper
fish</b></col> <fld>(Zool.)</fld>, <cd>a small, slender, phosphorescent
deep-sea fish (<spn>Chauliodus Sloanii</spn>). It has long ventral and
dorsal fins, a large mouth, and very long, sharp teeth.</cd> --
<col><b>Viper's bugloss</b></col> <fld>(Bot.)</fld>, <cd>a rough-leaved
biennial herb (<spn>Echium vulgare</spn>) having showy purplish blue
flowers. It is sometimes cultivated, but has become a pestilent weed in
fields from New York to Virginia. Also called <altname>blue
weed</altname>.</cd> -- <col><b>Viper's grass</b></col>
<fld>(Bot.)</fld>, <cd>a perennial composite herb (<spn>Scorzonera
Hispanica</spn>) with narrow, entire leaves, and solitary heads of
yellow flowers. The long, white, carrot-shaped roots are used for food
in Spain and some other countries. Called also <altname>viper
grass</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viperina</ent><br/
\'d8<hw>Vi`per*i"na</hw> <pr>(?)</pr>, <pos>n. pl.</pos>
<fld>(Zool.)</fld> <def>See <er>Viperoidea</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viperine</ent><br/
<hw>Vi"per*ine</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>viperinus</ets>: cf. F. <ets>vip<eacute/rin</ets>.]</ety> <def>Of
or pertaining to a viper or vipers; resembling a viper.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Viperine snake</b></col>. <fld>(Zool.)</fld> <sd>(a)</sd>
<cd>Any venomous snake of the family <fam>Viperidae</fam>.</cd>
<sd>(b)</sd> <cd>A harmless snake resembling a viper in form or color,
esp. <spn>Tropidonotus viperinus</spn>, a small European species which
resembles the viper in color.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viperish</ent><br/
<hw>Vi"per*ish</hw>, <pos>a.</pos> <def>Somewhat like a viper;
viperous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viperoid</ent><br/
<hw>Vi"per*oid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Viper</ets> +
<ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Like or pertaining to
the vipers.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Viperoides</ent><br/
<ent>Viperoidea</ent><br/
<mhw>{ \'d8<hw>Vi`per*oi"de*a</hw> <pr>(?)</pr>, <hw>Vi`per*oi"des</hw>
<pr>(?)</pr>, }</mhw> <pos>n. pl.</pos> <ety>[NL. See <er>Viper</er>,
and <er>-oid</er>.]</ety> <fld>(Zool.)</fld> <def>A division of serpents
which includes the true vipers of the Old World and the rattlesnakes and
moccasin snakes of America; -- called also
<altname>Viperina</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viperous</ent><br/
<hw>Vi"per*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having the
qualities of a viper; malignant; venomous; <as>as, a <ex>viperous</ex>
tongue</as>.</def> <ldquo/This <xex>viperous</xex> slander.<rdquo/
<au>Shak.</au> -- <wordforms><wf>Vi"per*ous*ly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viraginian</ent><br/
<hw>Vi`ra*gin"i*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or
pertaining to a virago; having the qualities of a virago.</def>
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viraginity</ent><br/
<hw>Vi`ra*gin"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The qualities
or characteristics of a virago.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virago</ent><br/
<hw>Vi*ra"go</hw> <pr>(?; 277)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Viragoes</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>virago</ets>,
<ets>-intis</ets>, from <ets>vir</ets> a man. See
<er>Virile</er>.]</ety> <sn>1.</sn> <def>A woman of extraordinary
stature, strength, and courage; a woman who has the robust body and
masculine mind of a man; a female warrior.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To arms! to arms! the fierce <qex>virago</qex> cries.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, a mannish woman; a bold, turbulent woman; a
termagant; a vixen.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Virago</qex> . . . serpent under femininity.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vire</ent><br/
<hw>Vire</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>vire</ets>, fr.
<ets>virer</ets> to turn. Cf. <er>Veer</er>, <er>Vireton</er>.]</ety>
<def>An arrow, having a rotary motion, formerly used with the crossbow.
Cf. <er>Vireton</er>.</def> <rj><au>Gower.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virelay</ent><br/
<hw>Vir"e*lay</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>virelai</ets>; <ets>virer</ets> to turn + <ets>lai</ets> a song, a
lay.]</ety> <def>An ancient French song, or short poem, wholly in two
rhymes, and composed in short lines, with a refrain.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Of such matter made he many lays,<br/
Songs, complains, roundels, <qex>virelayes</qex>.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To which a lady sung a <qex>virelay</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <ldquo/The <xex>virelay</xex> admitted only two rhymes,
and, after employing one for some time, the poet was <xex>virer</xex>,
or to turn, to the other.<rdquo/</note> <rj><au>Nares.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virent</ent><br/
<hw>Vi"rent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>virens</ets>,
p. pr. of <ets>virere</ets> to be green.]</ety> <def>Green; not
withered.</def> <mark>[R.]</mark> <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vireo</ent><br/
<hw>Vir"e*o</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a species of
bird.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous species of
American singing birds belonging to <gen>Vireo</gen> and allied genera
of the family <fam>Vireonidae</fam>. In many of the species the back is
greenish, or olive-colored. Called also
<altname>greenlet</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the Eastern United States the most common species are
the white-eyed vireo (<spn>Vireo Noveboracensis</spn>), the red-eyed
vireo (<spn>Vireo olivaceus</spn>), the blue-headed, or solitary, vireo
(<spn>Vireo solitarius</spn>), the warbling vireo (<spn>Vireo
gilvus</spn>), and the yellow-throated vireo (<spn>Vireo
flavifrons</spn>). All these are noted for the sweetness of their
songs.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virescence</ent><br/
<hw>Vi*res"cence</hw> <pr>(?)</pr>, <fld>(Bot.)</fld> <def>The act or
state of becoming green through the formation of chlorophyll.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virescent</ent><br/
<hw>Vi*res"cent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>virescens</ets>, p. pr. of <ets>virescere</ets> to grow green, verb
incho. fr. <ets>virere</ets> to be green.]</ety> <def>Beginning to be
green; slightly green; greenish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vireton</ent><br/
<hw>Vir"e*ton</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See
<er>Vire</er>.]</ety> <def>An arrow or bolt for a crossbow having
feathers or brass placed at an angle with the shaft to make it spin in
flying.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgalieu</ent><br/
<hw>Vir"ga*lieu</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Virgouleuse</er>.]</ety> <fld>(Bot.)</fld> <def>A valuable kind of
pear, of an obovate shape and with melting flesh of delicious flavor; --
more properly called <xex>White Doyenn<eacute/</xex>.</def>
<altsp>[Written also <asp>virgaloo</asp>, <asp>vergalieu</asp>,
<asp>vergaloo</asp>, etc.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgate</ent><br/
<hw>Vir"gate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>virgatus</ets> made of twigs, fr. <ets>virga</ets> a twig, rod. See
<er>Verge</er> a rod.]</ety> <fld>(Bot.)</fld> <def>Having the form of a
straight rod; wand-shaped; straight and slender.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgate</ent><br/
<hw>Vir"gate</hw>, <pos>n.</pos> <ety>[LL. <ets>virgata</ets>,
<ets>virgata terrae</ets>, so much land as <ets>virga terrae</ets>, a
land measure, contains, fr. L. <ets>virga</ets> a twig, rod.]</ety>
<def>A yardland, or measure of land varying from fifteen to forty
acres.</def> <mark>[Obs.]</mark> <rj><au>T. Warton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgated</ent><br/
<hw>Vir"ga*ted</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>virgatus</ets> striped. See <er>Virgate</er>, <pos>a.</pos>]</ety>
<def>Striped; streaked.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virge</ent><br/
<hw>Virge</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A wand. See
<er>Verge</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virger</ent><br/
<hw>Vir"ger</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Verger</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgilian</ent><br/
<hw>Vir*gil"i*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>Virgilianus</ets>, better <ets>Vergilianus</ets>.]</ety> <def>Of or
pertaining to Virgil, the Roman poet; resembling the style of
Virgil.</def> <altsp>[Spelt also <asp>Vergilian</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><q>The rich <qex>Virgilian</qex> rustic measure<br/
Of Lari Maxume.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgin</ent><br/
<hw>Vir"gin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>virgo</ets>,
<ets>-inis</ets>: cf. OF. <ets>virgine</ets>, <ets>virgene</ets>,
<ets>virge</ets>, <ets>vierge</ets>, F. <ets>vierge</ets>.]</ety>
<sn>1.</sn> <def>A woman who has had no carnal knowledge of man; a
maid.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A person of the male sex who has not known sexual
indulgence.</def> <mark>[Archaic]</mark> <rj><au>Wyclif.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>These are they which were not defiled with women; for they are
<qex>virgins</qex>.</q> <rj><qau>Rev. xiv. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He his flesh hath overcome;<br/
He was a <qex>virgin</qex>, as he said.</q>
<rj><qau>Gower.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Astron.)</fld> <def>See <er>Virgo</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>Any one of several species of
gossamer-winged butterflies of the family
<fam>Lycaenidae</fam>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Zool.)</fld> <def>A female insect producing eggs
from which young are hatched, though there has been no fecundation by a
male; a parthenogenetic insect.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>The Virgin</b></col>, <it>or</it> <col><b>The
Blessed Virgin</b></col></mcol>, <cd>the Virgin Mary, the Mother of
<person>Jesus Christ</person>.</cd> -- <col><b>Virgin's bower</b></col>
<fld>(Bot.)</fld>, <cd>a name given to several climbing plants of the
genus <gen>Clematis</gen>, as <spn>Clematis Vitalba</spn> of Europe, and
<spn>Clematis Virginiana</spn> of North America.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgin</ent><br/
<hw>Vir"gin</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Being a
virgin; chaste; of or pertaining to a virgin; becoming a virgin;
maidenly; modest; indicating modesty; <as>as, a <ex>virgin</ex>
blush</as>.</def> <ldquo/<xex>Virgin</xex> shame.<rdquo/
<rj><au>Cowley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Innocence and <qex>virgin</qex> modesty . . . <br/
That would be wooed, and unsought be won.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Pure; undefiled; unmixed; fresh; new; <as>as,
<ex>virgin</ex> soil; <ex>virgin</ex> gold.</as></def>
<ldquo/<xex>Virgin</xex> Dutch.<rdquo/ <rj><au>G. W.
Cable.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The white cold <qex>virgin</qex> snow upon my heart.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A few ounces of mutton, with a little <qex>virgin</qex> oil.</q>
<rj><qau>Landor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Not yet pregnant; impregnant.</def>
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgin</ent><br/
<hw>Vir"gin</hw>, <pos>v. i.</pos> <def>To act the virgin; to be or keep
chaste; -- followed by <xex>it</xex>. See <er>It</er>, 5.</def>
<mark>[Obs.]</mark> <ldquo/My true lip hath <xex>virgined</xex> it e'er
since [that kiss].<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virginal</ent><br/
<hw>Vir"gin*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>virginalis</ets>: cf. F. <ets>virginal</ets>.]</ety> <def>Of or
pertaining to a virgin; becoming a virgin; maidenly.</def>
<ldquo/Chastity and honor <xex>virginal</xex>.<rdquo/
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Virginal generation</b></col> <fld>(Biol.)</fld>,
<cd>parthenogenesis.</cd> -- <col><b>Virginal membrane</b></col>
<fld>(Anat.)</fld>, <cd>the hymen.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virginal</ent><br/
<hw>Vir"gin*al</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>virginale</ets>; --
probably so called from being used by young girls, or
<ets>virgins</ets>.]</ety> <fld>(Mus.)</fld> <def>An instrument somewhat
resembling the spinet, but having a rectangular form, like the small
piano. It had strings and keys, but only one wire to a note. The
instrument was used in the sixteenth century, but is now wholly
obsolete. It was sometimes called a <xex>pair of
virginals</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virginal</ent><br/
<hw>Vir"gin*al</hw>, <pos>v. i.</pos> <def>To play with the fingers, as
if on a virginal; to tap or pat.</def> <mark>[Obs.]</mark> <ldquo/Still
<xex>virginaling</xex> upon his palm!<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virginhood</ent><br/
<hw>Vir"gin*hood</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Virginity;
maidenhood.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virginia</ent><br/
<hw>Vir*gin"i*a</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One of the States
of the United States of America.</def> -- <def2><pos>a.</pos> <def>Of or
pertaining to the State of Virginia.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Virginia cowslip</b></col> <fld>(Bot.)</fld>, <cd>the
American lungwort (<spn>Mertensia Virginica</spn>).</cd> --
<col><b>Virginia creeper</b></col> <fld>(Bot.)</fld>, <cd>a common
ornamental North American woody vine (<spn>Ampelopsis
quinquefolia</spn>), climbing extensively by means of tendrils; --
called also <altname>woodbine</altname>, and <altname>American
ivy</altname>.</cd> <mark>[U. S.]</mark> -- <col><b>Virginia
fence</b></col>. <cd>See <cref>Worm fence</cref>, under
<er>Fence</er>.</cd> -- <col><b>Virginia nightingale</b></col>
<fld>(Zool.)</fld>, <cd>the cardinal bird. See under
<er>Cardinal</er>.</cd> -- <col><b>Virginia quail</b></col>
<fld>(Zool.)</fld>, <cd>the bobwhite.</cd> -- <col><b>Virginia
reel</b></col>, <cd>an old English contradance; -- so called in the
United States.</cd> <au>Bartlett.</au> -- <col><b>Virginia
stock</b></col>. <fld>(Bot.)</fld> <cd>See <er>Mahon
stock</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virginity</ent><br/
<hw>Vir*gin"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>virgintee</ets>, F. <ets>virginit<eacute/</ets>, L.
<ets>virginitas</ets>.]</ety> <sn>1.</sn> <def>The quality or state of
being a virgin; undefiled purity or chastity; maidenhood.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The unmarried life; celibacy.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgo</ent><br/
<hw>Vir"go</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>virgo</ets> a
virgin, the constellation Virgo in the zodiac. See
<er>Virgin</er>.]</ety> <fld>(Astron.)</fld> <sd>(a)</sd> <def>A sign of
the zodiac which the sun enters about the 21st of August, marked thus
[<Virgo/] in almanacs.</def> <sd>(b)</sd> <def>A constellation of the
zodiac, now occupying chiefly the sign Libra, and containing the bright
star Spica.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgouleuse</ent><br/
<hw>Vir"gou*leuse</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>virgouleuse</ets>, from the village of <ets>Virgoul<eacute/e</ets>,
near Limoges.]</ety> <fld>(Bot.)</fld> <def>An old French variety of
pear, of little value.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgularian</ent><br/
<hw>Vir`gu*la"ri*an</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From. L.
<ets>virgula</ets> a small rod.]</ety> <fld>(Zool.)</fld> <def>Any one
of numerous species of long, slender Alcyonaria belonging to
<gen>Virgularia</gen> and allied genera of the family
<fam>Virgularidae</fam>. These corals are allied to the sea-pens, but
have a long rodlike rhachis inclosing a slender, round or square,
calcareous axis. The polyps are arranged in transverse rows or clusters
along each side of the rhachis.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgulate</ent><br/
<hw>Vir"gu*late</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Shaped like a
little twig or rod.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virgule</ent><br/
<hw>Vir"gule</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>virgule</ets>, fr. L. <ets>virgula</ets>, dim. of <ets>virga</ets>.
See <er>Verge</er> a rod.]</ety> <def>A comma.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>In the MSS. of Chaucer, the line is always broken by a caesura in
the middle, which is pointed by a <qex>virgule</qex>.</q>
<rj><qau>Hallam.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virial</ent><br/
<hw>Vir"i*al</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>vis</ets>,
<ets>viris</ets>, force.]</ety> <fld>(Physics)</fld> <def>A certain
function relating to a system of forces and their points of application,
-- first used by Clausius in the investigation of problems in molecular
physics.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virid</ent><br/
<hw>Vir"id</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>viridis</ets>
green. See <er>Verdant</er>.]</ety> <def>Green.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>virid</qex> marjoram<br/
Her sparkling beauty did but see.</q> <rj><qau>Crompton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viridescence</ent><br/
<hw>Vir`i*des"cence</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Quality or
state of being viridescent.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viridescent</ent><br/
<hw>Vir`i*des"cent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>viridescens</ets>, p. pr. of <ets>viridescere</ets> to grow
green.]</ety> <def>Slightly green; greenish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viridine</ent><br/
<hw>Vir"i*dine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>viridis</ets> green.]</ety> <fld>(Chem.)</fld> <def>A greenish,
oily, nitrogenous hydrocarbon, <chform>C12H19N7</chform>, obtained from
coal tar, and probably consisting of a mixture of several metameric
compounds which are higher derivatives of the base pyridine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viridite</ent><br/
<hw>Vir"i*dite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>viridis</ets> green.]</ety> <fld>(Min.)</fld> <def>A greenish
chloritic mineral common in certain igneous rocks, as diabase, as a
result of alternation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viridity</ent><br/
<hw>Vi*rid"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>viriditas</ets>, fr. <ets>viridis</ets> green: cf. F.
<ets>viridit<eacute/</ets>. See <er>Verdant</er>.]</ety> <sn>1.</sn>
<def>Greenness; verdure; the color of grass and foliage.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Freshness; soundness.</def> <mark>[Obs.]</mark>
<rj><au>Evelyn.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viridness</ent><br/
<hw>Vir"id*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Viridity;
greenness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virile</ent><br/
<hw>Vi"rile</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>virilis</ets>, fr. <ets>vir</ets> a man; akin to AS.
<ets>wer</ets>: cf. F. <ets>viril</ets>. See <er>Werewolf</er>,
<er>World</er>, and cf. <er>Decemvir</er>, <er>Virago</er>,
<er>Virtue</er>.]</ety> <def>Having the nature, properties, or
qualities, of an adult man; characteristic of developed manhood; hence,
masterful; forceful; specifically, capable of begetting; -- opposed to
<xex>womanly</xex>, <xex>feminine</xex>, and <xex>puerile</xex>; <as>as,
<ex>virile</ex> age, <ex>virile</ex> power, <ex>virile</ex>
organs</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1613 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virility</ent><br/
<hw>Vi*ril"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>virilitas</ets>: cf. F. <ets>virilit<eacute/</ets>.]</ety> <def>The
quality or state of being virile; developed manhood; manliness; specif.,
the power of procreation; <as>as, exhaustion</as>.</def>
<ldquo/<xex>Virility</xex> of visage.<rdquo/
<rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viripotent</ent><br/
<hw>Vi*rip"o*tent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vir</ets> man + <ets>potens</ets> fit for.]</ety> <def>Developed in
manhood; hence, able to beget; marriageable.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Being not of ripe years, not <qex>viripotent</qex>.</q>
<rj><qau>Holinshed.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virmilion</ent><br/
<hw>Vir*mil"ion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Vermilion</er>.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virole</ent><br/
<hw>Vi*role"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., a ferrule. See
<er>Ferrule</er>.]</ety> <fld>(Her.)</fld> <def>A ring surrounding a
bugle or hunting horn.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viroled</ent><br/
<hw>Vi*roled"</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Her.)</fld>
<def>Furnished with a virole or viroles; -- said of a horn or a bugle
when the rings are of different tincture from the rest of the
horn.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virose</ent><br/
<hw>Vi*rose"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>virosus</ets>. See <er>Virus</er>.]</ety> <def>Having a nauseous
odor; fetid; poisonous.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virtu</ent><br/
<hw>Vir*tu"</hw> <pr>(?; 277)</pr>, <pos>n.</pos> <ety>[It.
<ets>virt<ugrave/</ets> virtue, excellence, from L. <ets>virtus</ets>.
See <er>Virtue</er>.]</ety> <def>A love of the fine arts; a taste for
curiosities.</def> <rj><au>J. Spence.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>An article of virtu</b></col>, <it>or</it>
<col><b>a piece of virtu</b></col>, <col><b></b></col></mcol>, <cd>an
object of art or antiquity; a curiosity, such as those found in museums
or private collections.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>I had thoughts, in my chambers to place it in view,<br/
To be shown to my friends as a piece of <qex>virt<ugrave/</qex>.</q>
<rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virtual</ent><br/
<hw>Vir"tu*al</hw> <pr>(?; 135)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>virtuel</ets>. See <er>Virtue</er>.]</ety> <sn>1.</sn> <def>Having
the power of acting or of invisible efficacy without the agency of the
material or sensible part; potential; energizing.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Heat and cold have a <qex>virtual</qex> transition, without
communication of substance.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Every kind that lives,<br/
Fomented by his <qex>virtual</qex> power, and warmed.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Being in essence or effect, not in fact; <as>as, the
<ex>virtual</ex> presence of a man in his agent or
substitute</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A thing has a <qex>virtual</qex> existence when it has all the
conditions necessary to its actual existence.</q>
<rj><qau>Fleming.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To mask by slight differences in the manners a <qex>virtual</qex>
identity in the substance.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Principle of virtual velocities</b></col>
<fld>(Mech.)</fld>, <cd>the law that when several forces are in
equilibrium, the algebraic sum of their virtual moments is equal to
zero.</cd> -- <col><b>Virtual focus</b></col> <fld>(Opt.)</fld>, <cd>the
point from which rays, having been rendered divergent by reflection of
refraction, appear to issue; the point at which converging rays would
meet if not reflected or refracted before they reach it.</cd> --
<col><b>Virtual image</b></col>. <fld>(Optics)</fld> <cd>See under
<er>Image</er>.</cd> -- <col><b>Virtual moment</b></col> (of a force)
<fld>(Mech.)</fld>, <cd>the product of the intensity of the force
multiplied by the virtual velocity of its point of application; --
sometimes called <altname>virtual work</altname>.</cd> --
<col><b>Virtual velocity</b></col> <fld>(Mech.)</fld>, <cd>a minute
hypothetical displacement, assumed in analysis to facilitate the
investigation of statical problems. With respect to any given force of a
number of forces holding a material system in equilibrium, it is the
projection, upon the direction of the force, of a line joining its point
of application with a new position of that point indefinitely near to
the first, to which the point is conceived to have been moved, without
disturbing the equilibrium of the system, or the connections of its
parts with each other. Strictly speaking, it is not a velocity but a
length.</cd> -- <col><b>Virtual work</b></col>. <fld>(Mech.)</fld>
<cd>See <cref>Virtual moment</cref>, above.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virtuality</ent><br/
<hw>Vir`tu*al"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>virtualit<eacute/</ets>.]</ety> <sn>1.</sn> <def>The quality or
state of being virtual.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Potentiality; efficacy; potential existence.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>In one grain of corn, there lieth dormant a <qex>virtuality</qex>
of many other.</q> <rj><qau>Sir T. Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virtually</ent><br/
<hw>Vir"tu*al*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a virtual
manner; in efficacy or effect only, and not actually; to all intents and
purposes; practically.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virtuate</ent><br/
<hw>Vir"tu*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To make
efficacious; to give virtue of efficacy.</def> <mark>[Obs.]</mark>
<rj><au>Harvey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virtue</ent><br/
<hw>Vir"tue</hw> <pr>(?; 135)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vertu</ets>, F. <ets>vertu</ets>, L. <ets>virtus</ets> strength,
courage, excellence, virtue, fr. <ets>vir</ets> a man. See
<er>Virile</er>, and cf. <er>Virtu</er>.]</ety> <sn>1.</sn> <def>Manly
strength or courage; bravery; daring; spirit; valor.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Built too strong<br/
For force or <qex>virtue</qex> ever to expugn.</q>
<rj><qau>Chapman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Active quality or power; capacity or power adequate
to the production of a given effect; energy; strength; potency;
efficacy; <as>as, the <ex>virtue</ex> of a medicine</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Jesus, immediately knowing in himself that <qex>virtue</qex> had
gone out of him, turned him about.</q> <rj><qau>Mark v.
30.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A man was driven to depend for his security against
misunderstanding, upon the pure <qex>virtue</qex> of his syntax.</q>
<rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>virtue</qex> of his midnight agony.</q>
<rj><qau>Keble.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Energy or influence operating without contact of the
material or sensible substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She moves the body which she doth possess,<br/
Yet no part toucheth, but by <qex>virtue's</qex> touch.</q>
<rj><qau>Sir. J. Davies.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Excellence; value; merit; meritoriousness;
worth.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I made <qex>virtue</qex> of necessity.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In the Greek poets, . . . the economy of poems is better observed
than in Terence, who thought the sole grace and <qex>virtue</qex> of
their fable the sticking in of sentences.</q> <rj><qau>B.
Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Specifically, moral excellence; integrity of
character; purity of soul; performance of duty.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Virtue</qex> only makes our bliss below.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>If there's Power above us,<br/
And that there is all nature cries aloud<br/
Through all her works, he must delight in <qex>virtue</qex>.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A particular moral excellence; <as>as, the
<ex>virtue</ex> of temperance, of charity, etc</as>.</def> <ldquo/The
very <xex>virtue</xex> of compassion.<rdquo/ <au>Shak.</au>
<ldquo/Remember all his <xex>virtues</xex>.<rdquo/ <au>Addison.</au><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Specifically: Chastity; purity; especially, the
chastity of women; virginity.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><it>H.</it> I believe the girl has <qex>virtue</qex>.<br/
<it>M.</it> And if she has, I should be the last man in the world to
attempt to corrupt it.</q> <rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <pluf>pl.</pluf> <def>One of the orders of the celestial
hierarchy.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thrones, dominations, princedoms, <qex>virtues</qex>, powers.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Cardinal virtues</b></col>. <cd>See under
<er>Cardinal</er>, <pos>a.</pos></cd> -- <mcol><col><b>In virtue
of</b></col>, <it>or</it> <col><b>By virtue of</b></col></mcol>,
<cd>through the force of; by authority of.</cd> <ldquo/He used to travel
through Greece <xex>by virtue of</xex> this fable, which procured him
reception in all the towns.<rdquo/ <au>Addison.</au> <ldquo/This they
shall attain, partly <xex>in virtue of</xex> the promise made by God,
and partly <xex>in virtue of</xex> piety.<rdquo/ <au>Atterbury.</au> --
<col><b>Theological virtues</b></col>, <cd>the three virtues, faith,
hope, and charity. See <au>1 Cor. xiii. 13.</au></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virtueless</ent><br/
<hw>Vir"tue*less</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Destitute of
virtue; without efficacy or operating qualities; powerless.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Virtueless</qex> she wished all herbs and charms.</q>
<rj><qau>Fairfax.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virtuosity</ent><br/
<hw>Vir`tu*os"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
quality or state of being a virtuoso; in a bad sense, the character of
one in whom mere artistic feeling or aesthetic cultivation takes the
place of religious character; sentimentalism.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This famous passage . . . over which the <qex>virtuosity</qex> of
modern times, rejoicing in evil, has hung so fondly.</q> <rj><qau>C.
Kingsley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Virtuosos, collectively.</def>
<rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An art or study affected by virtuosos.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virtuoso</ent><br/
<hw>Vir`tu*o"so</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Virtuosos</plw> <pr>(#)</pr>; It. <plw>Virtuosi</plw>
<pr>(#)</pr>.</plu> <ety>[It. See <er>Virtuous</er>.]</ety> <sn>1.</sn>
<def>One devoted to virtu; one skilled in the fine arts, in antiquities,
and the like; a collector or ardent admirer of curiosities,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Virtuoso</qex> the Italians call a man who loves the noble
arts, and is a critic in them.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>A performer on some instrument, as
the violin or the piano, who excels in the technical part of his art; a
brilliant concert player.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virtuosoship</ent><br/
<hw>Vir`tu*o"so*ship</hw>, <pos>n.</pos> <def>The condition, pursuits,
or occupation of a virtuoso.</def> <rj><au>Bp. Hurd.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virtuous</ent><br/
<hw>Vir"tu*ous</hw> <pr>(?; 135)</pr>, <pos>a.</pos> <ety>[OE.
<ets>vertuous</ets>, OF. <ets>vertuos</ets>, <ets>vertuous</ets>, F.
<ets>vertueux</ets>, fr. L. <ets>Virtuous</ets>. See <er>Virtue</er>,
and cf. <er>Virtuoso</er>.]</ety> <sn>1.</sn> <def>Possessing or
exhibiting virtue.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>Exhibiting manly courage and strength; valorous;
valiant; brave.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Old Priam's son, amongst them all, was chiefly
<qex>virtuous</qex>.</q> <rj><qau>Chapman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>Having power or efficacy; powerfully operative;
efficacious; potent.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Lifting up his <qex>virtuous</qex> staff on high,<br/
He smote the sea, which calm<eacute/d was with speed.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Every <qex>virtuous</qex> plant and healing herb.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <def>Having moral excellence; characterized by morality;
upright; righteous; pure; <as>as, a <ex>virtuous</ex>
action</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>virtuous</qex> mind that ever walks attended<br/
By a strong siding champion, conscience.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Chaste; pure; -- applied especially to
women.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Mistress Ford . . . the <qex>virtuous</qex> creature, that hath
the jealous fool to her husband.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vir"tu*ous*ly</wf>, <pos>adv.</pos> --
<wf>Vir"tu*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virulency</ent><br/
<ent>Virulence</ent><br/
<mhw>{ <hw>Vir"u*lence</hw> <pr>(?)</pr>, <hw>Vir"u*len*cy</hw>
<pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[Cf. F. <ets>virulence</ets>,
L. <ets>virulentia</ets> an offensive odor, a stench.]</ety> <sn>1.</sn>
<def>The quality or state of being virulent or venomous; poisonousness;
malignancy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Extreme bitterness or malignity of
disposition.</def> <ldquo/Refuted without satirical
<xex>virulency</xex>.<rdquo/ <rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>virulence</qex> of one declaimer, or the profundities and
sublimities of the other.</q> <rj><qau>I. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virulent</ent><br/
<hw>Vir"u*lent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>virulentus</ets>, fr. <ets>virus</ets> poison: cf. F.
<ets>virulent</ets>. See <er>Virus</er>.]</ety> <sn>1.</sn>
<def>Extremely poisonous or venomous; very active in doing
injury.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A contagious disorder rendered more <qex>virulent</qex> by
uncleanness.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Very bitter in enmity; actuated by a desire to
injure; malignant; <as>as, a <ex>virulent</ex> invective</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virulented</ent><br/
<hw>Vir"u*lent*ed</hw>, <pos>a.</pos> <def>Made virulent;
poisoned.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virulently</ent><br/
<hw>Vir"u*lent*ly</hw>, <pos>adv.</pos> <def>In a virulent
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Virus</ent><br/
<hw>Vi"rus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a slimy liquid, a
poisonous liquid, poison, stench; akin to Gr. <?/ poison, Skr.
<ets>visha</ets>. Cf. <er>Wizen</er>, <pos>v. i.</pos>]</ety>
<sn>1.</sn> <fld>(Med.)</fld> <def>Contagious or poisonous matter, as of
specific ulcers, the bite of snakes, etc.; -- applied to organic
poisons.</def> <mark>[Archaic]</mark><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>the causative agent of a disease, .</def>
<mark>[obsolescent]</mark><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>any of numerous submicroscopic complex organic
objects which have genetic material and may be considered as living
organisms but have no proper cell membrane, and thus cannot by
themselves perform metabolic processes, requiring entry into a host cell
in order to multiply. The simplest viruses have no lipid envelope and
may be considered as complex aggregates of molecules, sometimes only a
nucleic acid (DNA or RNA) and a coat protein. They are sometimes viewed
as being on the borderline between living and nonliving objects. They
are smaller than living cells in size, usually between 20 and 300 nm;
thus they pass through standard filters, and were previously referred to
as <altname>filterable virus</altname>. The manifestations of disease
caused by multiplication of viruses in cells may be due to destruction
of the cells caused by subversion of the cellular metabolic processes by
the virus, or by synthesis of a virus-specific toxin. Viruses may infect
animals, plants, or microorganisms; those infecting bacteria are also
called <stype>bacteriophages</stype>. Certain bacteriophages may be
non-destructive and benign in the host; -- see
<er>bacteriophage</er>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>4.</sn> <def>Fig.: Any morbid corrupting quality in intellectual
or moral conditions; something that poisons the mind or the soul;
<as>as, the <ex>virus</ex> of obscene books</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Computers)</fld> <def>a program or segment of
program code that may make copies of itself (replicate), attach itself
to other programs, and perform unwanted actions within a computer; also
called <altname>computer virus</altname> or <altname>virus
program</altname>. Such programs are almost always introduced into a
computer without the knowledge or assent of its owner, and are often
malicious, causing destructive actions such as erasing data on disk, but
sometime only annoying, causing peculiar objects to appear on the
display. The form of sociopathic mental disease that causes a programmer
to write such a program has not yet been given a name. Compare
<contr>trojan horse{3}</contr>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vis</ent><br/
\'d8<hw>Vis</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>Force;
power.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <sd>(a)</sd> <def>Physical force.</def>
<sd>(b)</sd> <def>Moral power.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Principle of vis viva</b></col> <fld>(Mech.)</fld>,
<cd>the principle that the difference between the aggregate work of the
accelerating forces of a system and that of the retarding forces is
equal to one half the <xex>vis viva</xex> accumulated or lost in the
system while the work is being done.</cd> -- <col><b>Vis
impressa</b></col> <ety>[L.]</ety> <fld>(Mech.)</fld>, <cd>force
exerted, as in moving a body, or changing the direction of its motion;
impressed force.</cd> -- <col><b>Vis inertiae</b></col>. <ety>[L.]</ety>
<sd>(a)</sd> <cd>The resistance of matter, as when a body at rest is set
in motion, or a body in motion is brought to rest, or has its motion
changed, either in direction or in velocity.</cd> <sd>(b)</sd>
<cd>Inertness; inactivity.</cd> <note><xex>Vis intertiae</xex> and
<xex>inertia</xex> are not strictly synonymous. The former implies the
<xex>resistance</xex> itself which is given, while the latter implies
merely the <xex>property</xex> by which it is given.</note> --
<col><b>Vis mortua</b></col> <ety>[L.]</ety> <fld>(Mech.)</fld>,
<cd>dead force; force doing no active work, but only producing
pressure.</cd> -- <mcol><col><b>Vis vitae</b></col>, <it>or</it>
<col><b>Vis vitalis</b></col></mcol> <ety>[L.]</ety>
<fld>(Physiol.)</fld>, <cd>vital force.</cd> -- <col><b>Vis
viva</b></col> <ety>[L.]</ety> <fld>(Mech.)</fld>, <cd>living force; the
force of a body moving against resistance, or doing work, in distinction
from <xex>vis mortua</xex>, or dead force; the kinetic energy of a
moving body; the capacity of a moving body to do work by reason of its
being in motion. See <cref>Kinetic energy</cref>, in the Note under
<er>Energy</er>. The term <xex>vis viva</xex> is not usually understood
to include that part of the kinetic energy of the body which is due to
the vibrations of its molecules.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visa</ent><br/
\'d8<hw>Vi"sa</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A
written stamp or document obtained by a citizen of one country from the
proper authorities of another country, denoting that that person's
passport has been examined, and that the person who bears the visa is
permitted to enter or pass through the second country. It is usually in
the form of an endorsement on the passport of the person seeking
permission to enter a foreign country; however, in some cases a separate
document is issued that does not create a mark in the passport. Same as
<er>Vis<eacute/</er>.</def><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><ent>Visa</ent><br/
<ent>Visa card</ent><br/
<mhw><hw>Vi"sa</hw> <pr>(v<emac/"z<adot/)</pr>, <hw>Vi"sa card`</hw>
<pr>(v<emac/"z<adot/ k<aum/rd`)</pr></mhw>, <pos>prop. n.</pos> <def>A
credit card issued with the Trade Name <ldquo/Visa<rdquo/ on it; <as>as,
he charged the dinner to his <ex>Visa</ex></as>. Visa is a competitor of
<contr>Master Card</contr>, <contr>Discover</contr>,
<contr>MBNA</contr>, and <contr>American Express</contr>, and other
credit card companies.</def><br/
[<source>PJC</source>]</p>

<p><ent>Visa</ent><br/
<hw>Vi"sa</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Visaed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Visaing</conjf>.]</vmorph> <def>To indorse, after examination,
with the word <xex>vis<eacute/</xex>, as a passport; to
vis<eacute/.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visage</ent><br/
<hw>Vis"age</hw> <pr>(?; 48)</pr>, <pos>n.</pos> <ety>[F.
<ets>visage</ets>, from L. <ets>visus</ets> a seeing, a look, fr.
<ets>videre</ets>, <ets>visum</ets>, to see. See <er>Vision</er>.]</ety>
<def>The face, countenance, or look of a person or an animal; -- chiefly
applied to the human face.</def> <au>Chaucer.</au> <ldquo/A
<xex>visage</xex> of demand.<rdquo/ <au>Shak.</au><br/
[<source>1913 Webster</source>]</p>

<p><q>His <qex>visage</qex> was so marred more than any man.</q>
<rj><qau>Isa. lii. 14.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Love and beauty still that <qex>visage</qex> grace.</q>
<rj><qau>Waller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visage</ent><br/
<hw>Vis"age</hw> <pr>(?; 48)</pr>, <pos>v. t.</pos> <def>To face.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visaged</ent><br/
<hw>Vis"aged</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having a
visage.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visard</ent><br/
<hw>Vis"ard</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A mask. See
<er>Visor</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visard</ent><br/
<hw>Vis"ard</hw>, <pos>v. t.</pos> <def>To mask.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vis-a-vis</ent><br/
\'d8<hw>Vis`-a-vis"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., opposite,
face to face.]</ety> <sn>1.</sn> <def>One who, or that which, is face to
face with another; esp., one who faces another in dancing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A carriage in which two persons sit face to face.
Also, a form of sofa with seats for two persons, so arranged that the
occupants are face to face while sitting on opposite sides.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vis-a-vis</ent><br/
<hw>Vis`-a-vis"</hw>, <pos>adv.</pos> <def>Face to face.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visayan</ent><br/
<hw>Vi*sa"yan</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Sp.
<ets>Bisayo</ets> a Visayan.]</ety> <def>A member of the most numerous
of the native races of the Philippines, occupying the Visayan Islands
and the northern coast Mindanao; also, their language. The Visayans
possessed a native culture and alphabet.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Viscacha</ent><br/
<ent>Viz-cacha</ent><br/
<mhw>\'d8<hw>Vis*ca"cha</hw> <pr>(?)</pr>, \'d8<hw>Viz-ca"cha</hw>
<pr>(<?/)</pr></mhw>, <pos>n.</pos> <ety>[Sp.]</ety> <fld>(Zool.)</fld>
<def>A large burrowing South American rodent (<spn>Lagostomus
trichodactylus</spn>) allied to the chinchillas, but much larger. Its
fur is soft and rather long, mottled gray above, white or yellowish
white beneath. There is a white band across the muzzle, and a dark band
on each cheek. It inhabits grassy plains, and is noted for its extensive
burrows and for heaping up miscellaneous articles at the mouth of its
burrows. Called also <altname>biscacha</altname>,
<altname>bizcacha</altname>, <altname>vischacha</altname>,
<altname>vishatscha</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscera</ent><br/
\'d8<hw>Vis"ce*ra</hw> <pr>(?)</pr>, <pos>n.</pos>, <def><pos>pl.</pos>
of <er>Viscus</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visceral</ent><br/
<hw>Vis"cer*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>visc<eacute/ral</ets>, LL. <ets>visceralis</ets>.]</ety>
<sn>1.</sn> <fld>(Anat.)</fld> <def>Of, pertaining to, or affecting the
viscera; splanchnic.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: Having deep sensibility.</def>
<mark>[R.]</mark> <rj><au>Bp. Reynolds.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>proceeding from emotion or instinct rather than from
intellect; deeply emotional; -- <as>as, a <ex>visceral</ex>
reaction</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <def>dealing with coarse or base emotions; -- <as>as, a
<ex>visceral</ex> literary style</as>.</def> <au>[RHUD]</au><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Visceral arches</b></col> <fld>(Anat.)</fld>, <cd>the
bars or ridges between the visceral clefts.</cd> --
<mcol><col><b>Visceral cavity</b></col> <it>or</it> <col><b>Visceral
tube</b></col></mcol> <fld>(Anat.)</fld>, <cd>the ventral cavity of a
vertebrate, which contains the alimentary canal, as distinguished from
the dorsal, or cerebro-spinal, canal.</cd> -- <col><b>Visceral
clefts</b></col> <fld>(Anat.)</fld>, <cd>transverse clefts on the sides
just back of the mouth in the vertebrate embryo, which open into the
pharyngeal portion of the alimentary canal, and correspond to the
branchial clefts in adult fishes.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscerate</ent><br/
<hw>Vis"cer*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Viscerated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Viscerating</conjf>.]</vmorph> <def>To deprive of the
viscera, or entrails; to eviscerate; to disembowel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visceroskeletal</ent><br/
<hw>Vis`cer*o*skel"e*tal</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Anat.)</fld> <def>Of or pertaining to the framework, or skeleton,
or skeleton, of the viscera; <as>as, the <ex>visceroskeletal</ex> system
of muscles</as>.</def> <rj><au>Mivart.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscid</ent><br/
<hw>Vis"cid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>viscidus</ets>, fr. <ets>viscum</ets> the mistletoe, birdlime made
from the berries of the mistletoe; akin to Gr. <?/: cf. F.
<ets>viscide</ets>.]</ety> <def>Sticking or adhering, and having a ropy
or glutinous consistency; viscous; glutinous; sticky; tenacious; clammy;
<as>as, turpentine, tar, gums, etc., are more or less
<ex>viscid</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscidity</ent><br/
<hw>Vis*cid"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>viscidit<eacute/</ets>.]</ety> <def>The quality or state of being
viscid; also, that which is viscid; glutinous concretion;
stickiness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscin</ent><br/
<hw>Vis"cin</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A
clear, viscous, tasteless substance extracted from the mucilaginous sap
of the mistletoe (<spn>Viscum album</spn>), holly, etc., and
constituting an essential ingredient of birdlime.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscoidal</ent><br/
<hw>Vis*coid"al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Somewhat viscous.
Cf. <er>Mobile</er>, <pos>a.</pos>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscosimeter</ent><br/
<hw>Vis`co*sim"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Viscosity</ets> + <ets>-meter</ets>.]</ety> <def>An
instrument for measuring the degree of viscosity of liquids, as
solutions of gum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscosity</ent><br/
<hw>Vis*cos"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>viscosit<eacute/</ets>, LL. <ets>viscositas</ets>.]</ety>
<sn>1.</sn> <def>The quality or state of being viscous.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Physics)</fld> <def>A property possessed by a
viscous fluid, being a resistance to the forces causing a fluid to flow,
caused by interactions between the molecules of the fluid and between
the fluid and the walls of the conduit through which it moves; also, a
measure of such a property.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Viscount</ent><br/
<hw>Vis"count`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vicounte</ets>, OF. <ets>visconte</ets>, <ets>vescunte</ets>, F.
<ets>vicomte</ets>, LL. <ets>vicecomes</ets>; L. <ets>vice</ets> (see
<er>Vice</er>, <pos>a.</pos>) + <ets>comes</ets> a companion, LL., a
count. See <er>Count</er>.]</ety> <sn>1.</sn> <fld>(O. Eng. Law)</fld>
<def>An officer who formerly supplied the place of the count, or earl;
the sheriff of the county.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A nobleman of the fourth rank, next in order below
an earl and next above a baron; also, his degree or title of nobility.
See <er>Peer</er>, <pos>n.</pos>, 3.</def> <mark>[Eng.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscountcy</ent><br/
<hw>Vis"count`cy</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The dignity or
jurisdiction of a viscount.</def> <rj><au>Sir B. Burke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscountess</ent><br/
<hw>Vis"count`ess</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vicomtesse</ets>, LL. <ets>vicecomitissa</ets>.]</ety> <def>The
wife of a viscount.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscounty</ent><br/
<ent>Viscountship</ent><br/
<mhw>{ <hw>Vis"count`ship</hw>, <hw>Vis"count`y</hw> <pr>(?)</pr>,
}</mhw> <pos>n.</pos> <ety>[F. <ets>vicomt<eacute/</ets>.]</ety>
<def>The quality, rank, or office of a viscount.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscous</ent><br/
<hw>Vis"cous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>viscosus</ets>. See <er>Viscid</er>.]</ety> <def>Adhesive or
sticky, and having a ropy or glutinous consistency; viscid; glutinous;
clammy; tenacious; <as>as, a <ex>viscous</ex> juice</as>.</def> --
<wordforms><wf>Vis"cous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ There is no well-defined distinction in meaning between
<xex>viscous</xex> and <xex>viscid</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscum</ent><br/
\'d8<hw>Vis"cum</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety>
<sn>1.</sn> <fld>(Bot.)</fld> <def>A genus of parasitic shrubs,
including the mistletoe of Europe.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Birdlime, which is often made from the berries of
the European mistletoe.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viscus</ent><br/
\'d8<hw>Vis"cus</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Viscera</plw> <pr>(#)</pr>.</plu> <ety>[L., perhaps akin to E.
<ets>viscid</ets>.]</ety> <fld>(Anat.)</fld> <def>One of the organs, as
the brain, heart, or stomach, in the great cavities of the body of an
animal; -- especially used in the plural, and applied to the organs
contained in the abdomen.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vise</ent><br/
<hw>Vise</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>vis</ets> a
screw, winding stairs, OF. <ets>vis</ets>, <ets>viz</ets>, fr. L.
<ets>vitis</ets> a vine; probably akin to E. <ets>withy</ets>.]</ety>
<def>An instrument consisting of two jaws, closing by a screw, lever,
cam, or the like, for holding work, as in filing.</def> <altsp>[Written
also <asp>vice</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vise</ent><br/
\'d8<hw>Vi*s<eacute/"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vis<eacute/</ets>, p. p. of <ets>viser</ets> to put a visa to, fr.
L. <ets>visus</ets> seen, p. p. of <ets>videre</ets> to see.]</ety>
<def>A document or an indorsement made on a passport by the proper
authorities of certain countries, denoting that the passport has been
examined, and that the person who bears it is permitted to proceed on
her journey. Same as <er>visa</er>; -- an older spelling now used less
frequently than <altname>visa</altname>.</def><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><-- p. 1614 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vise</ent><br/
<hw>Vi*s<eacute/"</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Vis<eacute/ed</conjf> <pr>(?)</pr>; <pos>p. pr. &
vb. n.</pos> <conjf>Vis<eacute/ing</conjf>.]</vmorph> <def>To examine
and indorse, as a passport; to visa.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vishnu</ent><br/
\'d8<hw>Vish"nu</hw> <pr>(v<icr/sh"n<oomac/)</pr>, <pos>n.</pos>
<ety>[Skr. <ets>Vish<nsdot/u</ets>, from <ets>vish</ets> to pervade., to
extend through nature.]</ety> <fld>(Hindu Myth.)</fld> <def>A divinity
of the modern Hindu trimurti, or trinity. He is regarded as the
preserver, while Brahma is the creator, and Siva the destroyer of the
creation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visibility</ent><br/
<hw>Vis`i*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>visibilitas</ets>: cf. F. <ets>visibilit<eacute/</ets>.]</ety>
<def>The quality or state of being visible.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visible</ent><br/
<hw>Vis"i*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>visibilis</ets>, fr. <ets>videre</ets>, <ets>visum</ets>, to see:
cf. F. <ets>visible</ets>. See <er>Vision</er>.]</ety> <sn>1.</sn>
<def>Perceivable by the eye; capable of being seen; perceptible; in
view; <as>as, a <ex>visible</ex> star; the least spot is
<ex>visible</ex> on white paper.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Maker of heaven and earth, and of all things <qex>visible</qex>
and invisible.</q> <rj><qau>Bk. of Com. Prayer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Virtue made <qex>visible</qex> in outward grace.</q>
<rj><qau>Young.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Noticeable; apparent; open; conspicuous.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The factions at court were greater, or more <qex>visible</qex>,
than before.</q> <rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Visible church</b></col> <fld>(Theol.)</fld>, <cd>the
apparent church of Christ on earth; the whole body of professed
believers in Christ, as contradistinguished from the
<xex>invisible</xex>, or real, church, consisting of sanctified
persons.</cd> -- <col><b>Visible horizon</b></col>. <cd>Same as
<cref>Apparent horizon</cref>, under <er>Apparent</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vis"i*ble*ness</wf>, <pos>n.</pos> --
<wf>Vis"i*bly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visible speech</ent><br/
<hw>Vis"i*ble speech"</hw>. <fld>(Phon.)</fld> <def>A system of
characters invented by Prof. Alexander Melville Bell to represent all
sounds that may be uttered by the speech organs, and intended to be
suggestive of the position of the organs of speech in uttering
them.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Visigoth</ent><br/
<hw>Vis"i*goth</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>Visegothae</ets>, pl. Cf. <er>West</er>, and <er>Goth</er>.]</ety>
<def>One of the West Goths. See the Note under <er>Goth</er>.</def> --
<wordforms><wf>Vis`i*goth"ic</wf> <pr>(#)</pr>,
<pos>a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vision</ent><br/
<hw>Vi"sion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE.
<ets>visioun</ets>, F. <ets>vision</ets>, fr. L. <ets>visio</ets>, from
<ets>videre</ets>, <ets>visum</ets>, to see: akin to Gr. <?/ to see, <?/
I know, and E. <ets>wit</ets>. See <er>Wit</er>, <pos>v.</pos>, and cf.
<er>Advice</er>, <er>Clairvoyant</er>, <er>Envy</er>, <er>Evident</er>,
<er>Provide</er>, <er>Revise</er>, <er>Survey</er>, <er>View</er>,
<er>Visage</er>, <er>Visit</er>.]</ety> <sn>1.</sn> <def>The act of
seeing external objects; actual sight.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Faith here is turned into <qex>vision</qex> there.</q>
<rj><qau>Hammond.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Physiol.)</fld> <def>The faculty of seeing; sight;
one of the five senses, by which colors and the physical qualities of
external objects are appreciated as a result of the stimulating action
of light on the sensitive retina, an expansion of the optic
nerve.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That which is seen; an object of sight.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Especially, that which is seen otherwise than by the
ordinary sight, or the rational eye; a supernatural, prophetic, or
imaginary sight; an apparition; a phantom; a specter; <as>as, the
<ex>visions</ex> of Isaiah</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The baseless fabric of this <qex>vision</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>No dreams, but <qex>visions</qex> strange.</q> <rj><qau>Sir P.
Sidney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Hence, something unreal or imaginary; a creation of
fancy.</def> <rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Arc of vision</b></col> <fld>(Astron.)</fld>, <cd>the arc
which measures the least distance from the sun at which, when the sun is
below the horizon, a star or planet emerging from his rays becomes
visible.</cd> -- <col><b>Beatific vision</b></col> <fld>(Theol.)</fld>,
<cd>the immediate sight of God in heaven.</cd> -- <col><b>Direct
vision</b></col> <fld>(Opt.)</fld>, <cd>vision when the image of the
object falls directly on the yellow spot (see under <er>Yellow</er>);
also, vision by means of rays which are not deviated from their original
direction.</cd> -- <col><b>Field of vision</b></col>, <cd>field of view.
See under <er>Field</er>.</cd> -- <col><b>Indirect vision</b></col>
<fld>(Opt.)</fld>, <cd>vision when the rays of light from an object fall
upon the peripheral parts of the retina.</cd> -- <mcol><col><b>Reflected
vision</b></col>, <it>or</it> <col><b>Refracted vision</b></col></mcol>,
<cd>vision by rays reflected from mirrors, or refracted by lenses or
prisms, respectively.</cd> -- <col><b>Vision purple</b></col>.
<fld>(Physiol.)</fld> <cd>See <cref>Visual purple</cref>, under
<er>Visual</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vision</ent><br/
<hw>Vi"sion</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Visioned</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Visioning</conjf>.]</vmorph> <def>To see in a vision; to
dream.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>For them no <qex>visioned</qex> terrors daunt,<br/
Their nights no fancied specters haunt.</q> <rj><qau>Sir W.
Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visional</ent><br/
<hw>Vi"sion*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to
a vision.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visionariness</ent><br/
<hw>Vi"sion*a*ri*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality
or state of being visionary.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visionary</ent><br/
<hw>Vi"sion*a*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>visionnaire</ets>.]</ety> <sn>1.</sn> <def>Of or pertaining to a
visions or visions; characterized by, appropriate to, or favorable for,
visions.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>visionary</qex> hour<br/
When musing midnight reigns.</q> <rj><qau>Thomson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Affected by phantoms; disposed to receive
impressions on the imagination; given to reverie; apt to receive, and
act upon, fancies as if they were realities.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Or lull to rest the <qex>visionary</qex> maid.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Existing in imagination only; not real; fanciful;
imaginary; having no solid foundation; <as>as, <ex>visionary</ex>
prospect; a <ex>visionary</ex> scheme or project</as>.</def>
<rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Fanciful; fantastic; unreal. See
<er>Fanciful</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visionary</ent><br/
<hw>Vi"sion*a*ry</hw>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Visionaries</plw> <pr>(<?/)</pr>.</plu> <sn>1.</sn> <def>One whose
imagination is disturbed; one who sees visions or phantoms.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One whose imagination overpowers his reason and
controls his judgment; an unpractical schemer; one who builds castles in
the air; a daydreamer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visioned</ent><br/
<hw>Vi"sioned</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having the power of
seeing visions; inspired; also, seen in visions.</def> <mark>[R.]</mark>
<rj><au>Shelley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visionist</ent><br/
<hw>Vi"sion*ist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A
visionary.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visionless</ent><br/
<hw>Vi"sion*less</hw>, <pos>a.</pos> <def>Destitute of vision;
sightless.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visit</ent><br/
<hw>Vis"it</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Visited</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Visiting</conjf>.]</vmorph> <ety>[F. <ets>visiter</ets>, L.
<ets>visitare</ets>, fr. <ets>visere</ets> to go to see, to visit, fr.
<ets>videre</ets>, <ets>visum</ets> to see. See
<er>Vision.</er>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To go or come to see, as for the purpose of
friendship, business, curiosity, etc.; to attend; to call upon; <as>as,
the physician <ex>visits</ex> his patient</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> Specifically: <def>To go or come to see for inspection,
examination, correction of abuses, etc.; to examine, to inspect; <as>as,
a bishop <ex>visits</ex> his diocese; a superintendent <ex>visits</ex>
persons or works under his charge.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Script.)</fld> <def>To come to for the purpose of
chastising, rewarding, comforting; to come upon with reward or
retribution; to appear before or judge; <as>as, to <ex>visit</ex> in
mercy; to <ex>visit</ex> one in wrath.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>[God] hath <qex>visited</qex> and redeemed his people.</q>
<rj><qau>Like i. 68.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visit</ent><br/
<hw>Vis"it</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To make a visit or
visits; to maintain visiting relations; to practice calling on
others.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visit</ent><br/
<hw>Vis"it</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>visite</ets>. See
<er>Visit</er>, <pos>v. t.</pos>, and cf. <er>Visite</er>.]</ety>
<sn>1.</sn> <def>The act of visiting, or going to see a person or thing;
a brief stay of business, friendship, ceremony, curiosity, or the like,
usually longer than a call; <as>as, a <ex>visit</ex> of civility or
respect; a <ex>visit</ex> to Saratoga; the <ex>visit</ex> of a
physician.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The act of going to view or inspect; an official or
formal inspection; examination; visitation; <as>as, the <ex>visit</ex>
of a trustee or inspector</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Right of visit</b></col> <fld>(Internat. Law)</fld>,
<cd>the right of visitation. See <er>Visitation</er>, 4.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visitable</ent><br/
<hw>Vis"it*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Liable or subject
to be visited or inspected.</def> <ldquo/All hospitals built since the
Reformation are <xex>visitable</xex> by the king or lord
chancellor.<rdquo/ <rj><au>Ayliffe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visitant</ent><br/
<hw>Vis"it*ant</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>visitans</ets>, <ets>-antis</ets>; p. pr.: cf. F.
<ets>visitant</ets>.]</ety> <def>One who visits; a guest; a
visitor.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When the <qex>visitant</qex> comes again, he is no more a
stranger.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visitant</ent><br/
<hw>Vis"it*ant</hw>, <pos>a.</pos> <def>Visiting.</def>
<rj><au>Wordsworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visitation</ent><br/
<hw>Vis`it*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>visitatio</ets>: cf. F. <ets>visitation</ets>.]</ety> <sn>1.</sn>
<def>The act of visiting, or the state of being visited; access for
inspection or examination.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Nothing but peace and gentle <qex>visitation</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Specifically: The act of a superior or
superintending officer who, in the discharge of his office, visits a
corporation, college, etc., to examine into the manner in which it is
conducted, and see that its laws and regulations are duly observed and
executed; <as>as, the <ex>visitation</ex> of a diocese by a
bishop</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The object of a visit.</def> <mark>[Obs.]</mark>
<ldquo/O flowers, . . . my early <xex>visitation</xex> and my
last.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Internat. Law)</fld> <def>The act of a naval
commander who visits, or enters on board, a vessel belonging to another
nation, for the purpose of ascertaining her character and object, but
without claiming or exercising a right of searching the vessel. It is,
however, usually coupled with the <xex>right of search</xex> (see under
<er>Search</er>), visitation being used for the purpose of
search.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Special dispensation; communication of divine favor
and goodness, or, more usually, of divine wrath and vengeance;
retributive calamity; retribution; judgment.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>What will ye do in the day of <qex>visitation</qex>?</q>
<rj><qau>Isa. x. 3.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Eccl.)</fld> <def>A festival in honor of the visit
of the Virgin Mary to Elisabeth, mother of John the Baptist, celebrated
on the second of July.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>The Order of the Visitation of Our Lady</b></col>
<fld>(R. C. Ch.)</fld>, <cd>a religious community of nuns, founded at
Annecy, in Savoy, in 1610, and in 1808 established in the United States.
In America these nuns are devoted to the education of
girls.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visitatorial</ent><br/
<hw>Vis`it*a*to"ri*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. LL.
<ets>visitator</ets> a bishop temporarily put in place of
another.]</ety> <def>Of or pertaining to visitation, or a judicial
visitor or superintendent; visitorial.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>An archdeacon has <qex>visitatorial</qex> power.</q>
<rj><qau>Ayliffe.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The queen, however, still had over the church a
<qex>visitatorial</qex> power of vast and undefined extent.</q>
<rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visite</ent><br/
<hw>Vi*site"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See
<er>Visit</er>, <pos>n.</pos>]</ety> <def>A light cape or short cloak of
silk or lace worn by women in summer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visiter</ent><br/
<hw>Vis"it*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A visitor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visiting</ent><br/
<hw>Vis"it*ing</hw>, <def><pos>a. & vb. n.</pos> from
<er>Visit</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Visiting ant</b></col>. <fld>(Zool.)</fld> <cd>See
<cref>Driver ant</cref>, under <er>Driver</er>.</cd> -- <col><b>Visiting
book</b></col>, <cd>a book in which a record of visits received, made,
and to be made, is kept.</cd> <au>Thackeray.</au> -- <col><b>Visiting
card</b></col>. <cd>See under <er>Card</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visitor</ent><br/
<hw>Vis"it*or</hw> <pr>(?)</pr>. <ety>[Cf. F.
<ets>visiteur</ets>.]</ety> <altsp>[Written also
<asp>visiter</asp>.]</altsp> <sn>1.</sn> <def>One who visits; one who
comes or goes to see another, as in civility or friendship.</def>
<ldquo/This great flood of <xex>visitors</xex>.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A superior, or a person lawfully appointed for the
purpose, who makes formal visits of inspection to a corporation or an
institution. See <er>Visit</er>, <pos>v. t.</pos>, 2, and
<er>Visitation</er>, <pos>n.</pos>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The king is the <qex>visitor</qex> of all lay corporations.</q>
<rj><qau>Blackstone.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visitorial</ent><br/
<hw>Vis`it*o"ri*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Same as
<er>Visitatorial</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visive</ent><br/
<hw>Vi"sive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>visif</ets>, LL. <ets>visivus</ets>. See <er>Vision</er>.]</ety>
<def>Of or pertaining to the sight; visual.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I can not satisfy myself how men should be so little surprised
about this <qex>visive</qex> faculty.</q>
<rj><qau>Berkeley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vis major</ent><br/
\'d8<hw>Vis ma"jor</hw>. <ety>[L. <ets>major</ets> greater.]</ety>
<fld>(Law)</fld> <def>A superior force which under certain circumstances
is held to exempt from contract obligations; inevitable accident; -- a
civil-law term used as nearly equivalent to, but broader than, the
common-law term <cref>act of God</cref> (which see).</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Visne</ent><br/
<hw>Visne</hw> <pr>(?; 277)</pr>, <pos>n.</pos> <ety>[OF.
<ets>visn<eacute/</ets>, <ets>veisin<eacute/</ets>, <ets>visnet</ets>,
neighborhood, LL. <ets>vicinatus</ets>, fr. L. <ets>vicunus</ets>
neighboring, a neighbor. See <er>Vicinity</er>.]</ety> <fld>(Law)</fld>
<def>Neighborhood; vicinity; venue. See <er>Venue</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visnomy</ent><br/
<hw>Vis"no*my</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Contr. fr.
<ets>physiognomy</ets>.]</ety> <def>Face; countenance.</def>
<mark>[Colloq.]</mark> <rj><au>Spenser. Lamb.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vison</ent><br/
<hw>Vi"son</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<fld>(Zool.)</fld> <def>The mink.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visor</ent><br/
<hw>Vis"or</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>visere</ets>,
F. <ets>visi<egrave/re</ets>, fr. OF. <ets>vis</ets>. See
<er>Visage</er>, <er>Vision</er>.]</ety> <altsp>[Written also
<asp>visar</asp>, <asp>visard</asp>, <asp>vizard</asp>, and
<asp>vizor</asp>.]</altsp> <sn>1.</sn> <def>A part of a helmet, arranged
so as to lift or open, and so show the face. The openings for seeing and
breathing are generally in it.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A mask used to disfigure or disguise.</def>
<ldquo/My very <xex>visor</xex> began to assume life.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>My weaker government since, makes you pull off the
<qex>visor</qex>.</q> <rj><qau>Sir P. Sidney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The fore piece of a cap, projecting over, and
protecting the eyes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visored</ent><br/
<hw>Vis"ored</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Wearing a visor;
masked.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Visored</qex> falsehood and base forgery.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vista</ent><br/
<hw>Vis"ta</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vistas</plw> <pr>(#)</pr>.</plu> <ety>[It., sight, view, fr.
<ets>vedere</ets>, p. p. <ets>visto</ets>, <ets>veduto</ets>, to see,
fr. L. <ets>videre</ets>, <ets>visum</ets>. See <er>View</er>,
<er>Vision</er>.]</ety> <def>A view; especially, a view through or
between intervening objects, as trees; a view or prospect through an
avenue, or the like; hence, the trees or other objects that form the
avenue.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The finished garden to the view<br/
Its <qex>vistas</qex> opens, and its alleys green.</q>
<rj><qau>Thomson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In the groves of their academy, at the end of every
<qex>vista</qex>, you see nothing but the gallows.</q>
<rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The shattered tower which now forms a <qex>vista</qex> from his
window.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visto</ent><br/
<hw>Vis"to</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A vista; a
prospect.</def> <mark>[R.]</mark> <rj><au>Gay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Through the long <qex>visto</qex> of a thousand years.</q>
<rj><qau>Young.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visual</ent><br/
<hw>Vis"u*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>visualis</ets>, from <ets>visus</ets> a seeing, sight: cf. F.
<ets>visuel</ets>. See <er>Vision</er>.]</ety> <sn>1.</sn> <def>Of or
pertaining to sight; used in sight; serving as the instrument of seeing;
<as>as, the <ex>visual</ex> nerve</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The air,<br/
Nowhere so clear, sharpened his <qex>visual</qex> ray.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That can be seen; visible.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Visual angle</b></col>. <fld>(Opt.)</fld> <cd>See under
<er>Angle</er>.</cd> -- <col><b>Visual cone</b></col>
<fld>(Persp.)</fld>, <cd>a cone whose vertex is at the point of sight,
or the eye.</cd> -- <col><b>Visual plane</b></col>, <cd>any plane
passing through the point of sight.</cd> -- <col><b>Visual
point</b></col>, <cd>the point at which the visual rays unite; the
position of the eye.</cd> -- <col><b>Visual purple</b></col>
<fld>(Physiol.)</fld>, <cd>a photochemical substance, of a purplish red
color, contained in the retina of human eyes and in the eyes of most
animals. It is quickly bleached by light, passing through the colors,
red, orange, and yellow, and then disappearing. Also called
<altname>rhodopsin</altname>, and <altname>vision purple</altname>. See
<er>Optography</er>.</cd> -- <col><b>Visual ray</b></col>, <cd>a line
from the eye, or point of sight.</cd> -- <col><b>Visual white</b></col>
<fld>(Physiol.)</fld>, <cd>the final product in the action of light on
visual purple. It is reconverted into visual purple by the regenerating
action of the choroidal epithelium.</cd> -- <col><b>Visual
yellow</b></col> <fld>(Physiol.)</fld>, <cd>a product intermediate
between visual purple and visual white, formed in the photochemical
action of light on visual purple.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visualize</ent><br/
<hw>Vis"u*al*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <sn>1.</sn> <def>To
make visual, or visible.</def> <altsp>[Written also
<asp>visualise</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>to see in the imagination; to form a mental image
of.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><q>No one who has not seen them [glaciers] can possibly
<qex>visualize</qex> them.</q> <rj><qau>Lubbock.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Visualize</ent><br/
<hw>Vis"u*al*ize</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To form a
mental image of something not present before the eye at the
time.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Visualizer</ent><br/
<hw>Vis"u*al*iz`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who
visualizes or is proficient in visualization;</def>
<specif>esp.</specif> <fld>(Physiol.)</fld>, <def>one whose mental
imagery is prevailingly visualization.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vitaille</ent><br/
<hw>Vi*taille</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Victuals</er>.]</ety> <def>Food; victuals.</def> <mark>[Obs.]</mark>
<rj><au>Piers Plowman. Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vital</ent><br/
<hw>Vi"tal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F., fr. L.
<ets>vitalis</ets>, fr. <ets>vita</ets> life; akin to <ets>vivere</ets>
to live. See <er>Vivid</er>.]</ety> <sn>1.</sn> <def>Belonging or
relating to life, either animal or vegetable; <as>as, <ex>vital</ex>
energies; <ex>vital</ex> functions; <ex>vital</ex>
actions.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Contributing to life; necessary to, or supporting,
life; <as>as, <ex>vital</ex> blood</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Do the heavens afford him <qex>vital</qex> food?</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And <qex>vital</qex> virtue infused, and <qex>vital</qex>
warmth.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Containing life; living.</def> <ldquo/Spirits that
live throughout, <xex>vital</xex> in every part.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Being the seat of life; being that on which life
depends; mortal.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The dart flew on, and pierced a <qex>vital</qex> part.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Very necessary; highly important;
essential.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A competence is <qex>vital</qex> to content.</q>
<rj><qau>Young.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Capable of living; in a state to live; viable.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Pythagoras and Hippocrates . . . affirm the birth of the seventh
month to be <qex>vital</qex>.</q> <rj><qau>Sir T. Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vital air</b></col>, <cd>oxygen gas; -- so called because
essential to animal life.</cd> <mark>[Obs.]</mark> -- <col><b>Vital
capacity</b></col> <fld>(Physiol.)</fld>, <cd>the breathing capacity of
the lungs; -- expressed by the number of cubic inches of air which can
be forcibly exhaled after a full inspiration.</cd> -- <col><b>Vital
force</b></col>. <fld>(Biol.)</fld> <cd>See under <er>Force</er>. The
vital forces, according to Cope, are nerve force (<xex>neurism</xex>),
growth force (<xex>bathmism</xex>), and thought force
(<xex>phrenism</xex>), all under the direction and control of the vital
principle. Apart from the phenomena of consciousness, vital actions no
longer need to be considered as of a mysterious and unfathomable
character, nor vital force as anything other than a form of physical
energy derived from, and convertible into, other well-known forces of
nature.</cd> -- <col><b>Vital functions</b></col> <fld>(Physiol.)</fld>,
<cd>those functions or actions of the body on which life is directly
dependent, as the circulation of the blood, digestion, etc.</cd> --
<col><b>Vital principle</b></col>, <cd>an immaterial force, to which the
functions peculiar to living beings are ascribed.</cd> -- <col><b>Vital
statistics</b></col>, <cd>statistics respecting the duration of life,
and the circumstances affecting its duration.</cd> -- <col><b>Vital
tripod</b></col>. <fld>(Physiol.)</fld> <cd>See under
<er>Tripod</er>.</cd> -- <col><b>Vital vessels</b></col>
<fld>(Bot.)</fld>, <cd>a name for latex tubes, now disused. See
<er>Latex</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vital</ent><br/
<hw>Vi"tal</hw>, <pos>n.</pos> <def>A vital part; one of the
vitals.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitalic</ent><br/
<hw>Vi*tal"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Pertaining to life;
vital.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitalism</ent><br/
<hw>Vi"tal*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Biol.)</fld>
<def>The doctrine that all the functions of a living organism are due to
an unknown vital principle distinct from all chemical and physical
forces.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitalist</ent><br/
<hw>Vi`tal*ist</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Biol.)</fld>
<def>A believer in the theory of vitalism; -- opposed to
<xex>physicist</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitalistic</ent><br/
<hw>Vi`tal*is"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Biol.)</fld>
<def>Pertaining to, or involving, vitalism, or the theory of a special
vital principle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitality</ent><br/
<hw>Vi*tal"i*ty</hw> <pr>(?; 277)</pr>, <pos>n.</pos> <ety>[L.
<ets>vitalitas</ets>: cf. F. <ets>vitalit<eacute/</ets>.]</ety> <def>The
quality or state of being vital; the principle of life; vital force;
animation; <as>as, the <ex>vitality</ex> of eggs or vegetable seeds; the
<ex>vitality</ex> of an enterprise</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitalization</ent><br/
<hw>Vi`tal*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act or
process of vitalizing, or infusing the vital principle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitalize</ent><br/
<hw>Vi"tal*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vitalized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vitalizing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[Cf. F.
<ets>vitaliser</ets>.]</ety> <def>To endow with life, or vitality; to
give life to; to make alive; <as>as, <ex>vitalized</ex>
blood</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitally</ent><br/
<hw>Vi"tal*ly</hw>, <pos>adv.</pos> <def>In a vital manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitals</ent><br/
<hw>Vi"tals</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <sn>1.</sn> <def>Organs
that are necessary for life; more especially, the heart, lungs, and
brain.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: The part essential to the life or health of
anything; <as>as, the <ex>vitals</ex> of a state</as>.</def> <ldquo/The
<xex>vitals</xex> of the public body.<rdquo/
<rj><au>Glanvill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitamin</ent><br/
<hw>Vit"a*min</hw> <pr>(v<imac/t"<adot/*m<icr/n)</pr>, <pos>n.</pos>
<def>any of several organic chemical substances not synthesized by an
animal and required in small quantities for normal metabolism, present
in and obtained from the natural foods eaten by the animal. Human
vitamins are also produced synthetically, and taken in pure form or in
mixtures, as dietary supplements. Deficiencies of specific vitamins lead
to certain specific disorders, such as scurvy, caused by an
insufficiency of vitamin C (ascorbic acid).</def> <note>Most vitamins
act as coenzymes or precursors to coenzymes, and are not consumed for
energy production or incorporated into structural units of the
cell.</note><br/
[<source>PJC</source>]</p>

<p><ent>vitamin A</ent><br/
<hw>vitamin A</hw> <pos>n.</pos> <def> any of several related
fat-soluble vitamins (such as retinol) essential for normal vision; it
also prevents night blindness or inflammation or dryness of the
eyes.</def><br/
<syn><b>Syn. --</b> antiophthalmic factor, axerophthol.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin A1</ent><br/
<hw>vitamin A1</hw> <pos>n.</pos> <def>retinol
(<chform>C20H30O</chform>), one of the substances also called
<altname>vitamin A</altname>. It is also called more specifically
<altname>vitamin A alcohol</altname>. It is a required factor for human
nutrition. The USP unit of activity is equal to 0.30 micrograms of
retinol.</def><br/
<syn><b>Syn. --</b> retinol.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>vitamin A2</ent><br/
<hw>vitamin A2</hw> <pos>n.</pos> <def>dehydroretinol
(<chform>C20H28O</chform>), one of the substances also called
<altname>vitamin A</altname>. It has about 40% of the bioactivity of
vitamin A1.</def><br/
<syn><b>Syn. --</b> dehydroretinol.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>vitamin B</ent><br/
<hw>vitamin B</hw> <pos>n.</pos> <def>a group of water-soluble vitamins
originally thought to be a single vitamin but now separated into several
B vitamins.</def><br/
<syn><b>Syn. --</b> B-complex vitamin, B complex, vitamin B complex, B
vitamin.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin B1</ent><br/
<hw>vitamin B1</hw> <pos>n.</pos> <def>a B vitamin
<chform>(C12H17N4OS)Cl</chform> that prevents beriberi and maintains
appetite and growth. Same as <er>thiamine</er>.</def><br/
<syn><b>Syn. --</b> thiamin, aneurin, antiberiberi factor.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin B12</ent><br/
<hw>vitamin B12</hw> <pos>n.</pos> <def>a B vitamin that is used to
treat pernicious anemia.</def><br/
<syn><b>Syn. --</b> cobalamin, cyanocobalamin.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin B2</ent><br/
<hw>vitamin B2</hw> <pos>n.</pos> <def>a B vitamin that prevents skin
lesions and weight loss.</def><br/
<syn><b>Syn. --</b> vitamin G, riboflavin, lactoflavin, ovoflavin,
hepatoflavin.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin B3</ent><br/
<hw>vitamin B3</hw> <pos>n.</pos> <def>See
<er>nicotinamide</er>.</def><br/
<syn><b>Syn. --</b> nicotinamide.</syn><br/
[<source>PJC</source>]</p>

<p><ent>vitamin B5</ent><br/
<hw>vitamin B5</hw> <pos>n.</pos> <def>See <er>nicotinic
acid</er>.</def><br/
<syn><b>Syn. --</b> nicotinic acid.</syn><br/
[<source>PJC</source>]</p>

<p><ent>vitamin B6</ent><br/
<hw>vitamin B6</hw> <pos>n.</pos> <def>a B vitamin that is essential for
metabolism of amino acids and starch.</def><br/
<syn><b>Syn. --</b> pyridoxine, pyridoxal, pyridoxamine,
adermin.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin Bc</ent><br/
<hw>vitamin Bc</hw> <pos>n.</pos> <def>a B vitamin that is essential for
cell growth and reproduction. Also called <altname>folic
acid</altname></def><br/
<syn><b>Syn. --</b> vitamin M, folic acid, folacin, pteroylglutamic
acid, pteroylmonoglutamic acid.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin B complex</ent><br/
<hw>vitamin B complex</hw> <pos>n.</pos> <def>a mixture of water-soluble
vitamins originally thought to be a single vitamin but now known to be a
mixture of several compounds with vitaminic activity.</def> <syn><b>Syn.
--</b> B complex, vitamin B complex, vitamin B, B vitamin.</syn>
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin C</ent><br/
<hw>vitamin C</hw> <pos>n.</pos> <def>a vitamin that prevents scurvy.
Also called <altname>ascorbic acid</altname>.</def><br/
<syn><b>Syn. --</b> ascorbic acid.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin D</ent><br/
<hw>vitamin D</hw> <pos>n.</pos> <def>any of several chemically related
fat-soluble vitamins that prevent rickets. It is found in fish-liver
oils, egg yolks and milk. Component vitamin D2 is also called
<stype>calciferol</stype>, and vitamin D3 is called
<stype>cholecalciferol</stype>.</def><br/
<syn><b>Syn. --</b> calciferol, ergocalciferol,
cholecalciferol.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin E</ent><br/
<hw>vitamin E</hw> <pos>n.</pos> <def>a fat-soluble vitamin that is
essential for normal reproduction. It is found in vegetable oils,
butter, and eggs.</def><br/
<syn><b>Syn. --</b> tocopherol, alpha-tocopherol.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin G</ent><br/
<hw>vitamin G</hw> <pos>n.</pos> <def>same as <er>vitamin
B2</er>.</def><br/
<syn><b>Syn. --</b> vitamin B2, riboflavin, lactoflavin, ovoflavin,
hepatoflavin.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin H</ent><br/
<hw>vitamin H</hw> <pos>n.</pos>, <def>a B vitamin that aids in body
growth.</def><br/
<syn><b>Syn. --</b> biotin.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin K</ent><br/
<hw>vitamin K</hw> <pos>n.</pos> <fu>(1929)</fu> <ety>[from G.
<ets>K</ets>oagulationsvitamin.]</ety> <def>either of two fat-soluble
vitamins (vitamin K1 or vitamin K2) that help clot blood by
participating in the formation of prothrombin.</def> <syn><b>Syn. --</b>
naphthoquinone.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>vitamin K1</ent><br/
<hw>vitamin K1</hw> <pos>n.</pos> <def>one of the two K vitamins,
(<chform>C31H46O2</chform>). It is fat-soluble and occurs naturally as
the <it>trans</it> isomer. Chemically it is
<chname>2-methyl-3-phytyl-1,4,-naphthoquinone</chname>.</def><br/
<syn><b>Syn. --</b> phylloquinone, phytonadione, antihemorrhagic
vitamin.</syn>.<br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>vitamins K2</ent><br/
<ent>vitamin K2</ent><br/
<mhw><hw>vitamin K2</hw>, <hw>vitamins K2</hw></mhw> <pos>n.</pos>
<def>one of the two K vitamins, actually a mixture of homologous
fat-soluble substituted naphthoquinones (called
<altname>menaquinones</altname>), (<chform>C11H7O2[C5H8]nH</chform>),
where n may be 1 to 13 but is mostly 7 to 9. The term is also used for
synthetic compounds resembling vitamin K2 and having the same
physiological action. The individual components of vitamin K2 are also
referred to by the number of isoprenyl units in the side chain (the
number n in the formula), as for menadione, having no units at that
position of the naphthaquinone ring, and also called vitamin K2(0) (and
also called <er>vitamin K3</er>).</def> <au>[MI11]</au><br/
<syn><b>Syn. --</b> menaquinones, antihemorrhagic vitamin.</syn>.<br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>vitamin K3</ent><br/
<hw>vitamin K3</hw> <pos>n.</pos> <def>menadione,
(<chform>C11H8O2</chform>) being chemically
<chname>2-methyl-1,4,-naphthoquinone</chname>. Having no side chain in
the 3 position, it cannot exert all functions of a true K vitamin and
the designation as vitamin K3 has been discouraged</def>
<au>[MI11]</au><br/
<syn><b>Syn. --</b> vitaminK2(0); menaphthone.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin M</ent><br/
<hw>vitamin M</hw> <pos>n.</pos> <def>same as <er>vitamin Bc</er>; folic
acid.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>vitamin p</ent><br/
<hw>vitamin p</hw> <pos>n.</pos> <def>a water-soluble vitamin that
maintains the resistance of cell and capillary walls to
permeation.</def><br/
<syn><b>Syn. --</b> bioflavinoid, citrin.</syn>)<br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Vitascope</ent><br/
<hw>Vi"ta*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vita</ets> life + <ets>-scope</ets>.]</ety> <def>A form of machine
for exhibiting animated pictures.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vitellary</ent><br/
<hw>Vit"el*la*ry</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>vitellus</ets> a little calf, the yolk of an egg.]</ety>
<fld>(Biol.)</fld> <def>Vitelline.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitelligenous</ent><br/
<hw>Vit`el*lig"e*nous</hw> <pr>(?)</pr>, <pos>a.</pos>
<fld>(Zool.)</fld> <def>Producing yolk, or vitelline substance; --
applied to certain cells (also called <xex>nutritive</xex>, or
<xex>yolk</xex>, <xex>cells</xex>) formed in the ovaries of many
insects, and supposed to supply nutriment to the developing
ova.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitellin</ent><br/
<hw>Vi*tel"lin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Vitellus</er>.]</ety> <fld>(Physiol. Chem.)</fld> <def>An albuminous
body, belonging to the class of globulins, obtained from yolk of egg, of
which it is the chief proteid constituent, and from the seeds of many
plants. From the latter it can be separated in crystalline
form.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1615 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitelline</ent><br/
<hw>Vi*tel"line</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vitellus</ets> the yolk of an egg.]</ety> <fld>(Biol.)</fld>
<def>Of or pertaining to the yolk of eggs; <as>as, the
<ex>vitelline</ex> membrane, a smooth, transparent membrane surrounding
the vitellus</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitellogene</ent><br/
<hw>Vi*tel"lo*gene</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Vitellus</er>, and <er>-gen</er>.]</ety> <fld>(Zool.)</fld> <def>A
gland secreting the yolk of the eggs in trematodes, turbellarians, and
some other helminths.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitellus</ent><br/
\'d8<hw>Vi*tel"lus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., the yolk
of an egg.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Biol.)</fld> <def>The contents or substance of the
ovum; egg yolk. See <xex>Illust.</xex> of <er>Ovum</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Perisperm in an early
condition.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitiate</ent><br/
<hw>Vi"ti*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vitiated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vitiating</conjf>.]</vmorph> <ety>[L.
<ets>vitiatus</ets>, p. p. <ets>vitiare</ets> to vitiate, fr.
<ets>vitium</ets> a fault, vice. See <er>Vice</er> a fault.]</ety>
<altsp>[Written also <asp>viciate</asp>.]</altsp> <sn>1.</sn> <def>To
make vicious, faulty, or imperfect; to render defective; to injure the
substance or qualities of; to impair; to contaminate; to spoil; <as>as,
exaggeration <ex>vitiates</ex> a style of writing; sewer gas
<ex>vitiates</ex> the air.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>A will <qex>vitiated</qex> and growth out of love with the truth
disposes the understanding to error and delusion.</q>
<rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Without care it may be used to <qex>vitiate</qex> our minds.</q>
<rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>This undistinguishing complaisance will <qex>vitiate</qex> the
taste of readers.</q> <rj><qau>Garth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To cause to fail of effect, either wholly or in
part; to make void; to destroy, as the validity or binding force of an
instrument or transaction; to annul; <as>as, any undue influence exerted
on a jury <ex>vitiates</ex> their verdict; fraud <ex>vitiates</ex> a
contract</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitiation</ent><br/
<hw>Vi`ti*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vitiatio</ets>.]</ety> <def>The act of vitiating, or the state of
being vitiated; depravation; corruption; invalidation; <as>as, the
<ex>vitiation</ex> of the blood; the <ex>vitiation</ex> of a
contract</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>vitiation</qex> that breeds evil acts.</q> <rj><qau>G.
Eliot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viticulose</ent><br/
<hw>Vi*tic"u*lose`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>viticula</ets>, dim. of <ets>vitis</ets> vine.]</ety>
<fld>(Bot.)</fld> <def>Having long and slender trailing stems.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viticultural</ent><br/
<hw>Vit`i*cul"tur*al</hw> <pr>(?; 135)</pr>, <pos>a.</pos> <def>Of or
pertaining to viticulture.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viticulture</ent><br/
<hw>Vit"i*cul`ture</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vitis</ets> vine + E. <ets>culture</ets>.]</ety> <def>The
cultivation of the vine; grape growing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viticulturist</ent><br/
<hw>Vit`i*cul"tur*ist</hw>, <pos>n.</pos> <def>One engaged in
viticulture.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitiligo</ent><br/
\'d8<hw>Vit`i*li"go</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a kind of
tetter, fr. <ets>vitium</ets> blemish, vice.]</ety> <fld>(Med.)</fld>
<def>A rare skin disease consisting in the development of smooth,
milk-white spots upon various parts of the body.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitilitigate</ent><br/
<hw>Vit`i*lit"i*gate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[L.
<ets>vitilitigare</ets> to quarrel disgracefully; <ets>vitium</ets> vice
+ <ets>litigare</ets> to quarrel.]</ety> <def>To contend in law
litigiously or cavilously.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitilitigation</ent><br/
<hw>Vit`i*lit`i*ga"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Cavilous
litigation; cavillation.</def> <mark>[Obs.]</mark>
<rj><au>Hudibras.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitiosity</ent><br/
<hw>Vi`ti*os"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vitiositas</ets>. See <er>Vicious</er>.]</ety> <def>Viciousness;
depravity.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The perverseness and <qex>vitiosity</qex> of man's will.</q>
<rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitiousness</ent><br/
<ent>Vitiously</ent><br/
<ent>Vitious</ent><br/
<mhw><hw>Vi"tious</hw> <pr>(?)</pr>, <pos>a.</pos>,
<hw>Vi"tious*ly</hw>, <pos>adv.</pos>, <hw>Vi"tious*ness</hw>,
<pos>n.</pos></mhw> <def>See <er>Vicious</er>, <er>Viciously</er>,
<er>Viciousness</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitis</ent><br/
\'d8<hw>Vi"tis</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <ety>[L., a
vine.]</ety> <fld>(Bot.)</fld> <def>A genus of plants including all true
grapevines.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitoe</ent><br/
<hw>Vi"to*e</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>See
<er>Durukuli</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrage</ent><br/
<hw>Vit"rage</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., prop., glazing,
glass window.]</ety> <def>A curtain of light and translucent material
intended to be secured directly to the woodwork of a French casement
window or a glazed door.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vitrella</ent><br/
\'d8<hw>Vi*trel"la</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., dim. of
L. <ets>vitrum</ets> glass.]</ety> <fld>(Zool.)</fld> <def>One of the
transparent lenslike cells in the ocelli of certain
arthropods.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitre-o-electic</ent><br/
<hw>Vit`re-o-e*lec"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Vitreous</er>, and <er>Electric</er>.]</ety> <fld>(Physics)</fld>
<def>Containing or exhibiting positive, or vitreous,
electricity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitreous</ent><br/
<hw>Vit"re*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vitreous</ets>, from <ets>vitrum</ets> glass; perhaps akin to
<ets>videre</ets> to see (see <er>Vision</er>). Cf.
<er>Varnish</er>.]</ety> <sn>1.</sn> <def>Consisting of, or resembling,
glass; glassy; <as>as, <ex>vitreous</ex> rocks</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to glass; derived from glass;
<as>as, <ex>vitreous</ex> electricity</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vitreous body</b></col> <fld>(Anat.)</fld>, <cd>the
vitreous humor. See the Note under <er>Eye</er>.</cd> --
<col><b>Vitreous electricity</b></col> <fld>(Elec.)</fld>, <cd>the kind
of electricity excited by rubbing glass with certain substances, as
silk; positive electricity; -- opposed to <xex>resinous</xex>, or
<xex>negative</xex>, electricity.</cd> -- <col><b>Vitreous
humor</b></col>. <fld>(Anat.)</fld> <cd>See the Note under
<er>Eye</er>.</cd> -- <col><b>Vitreous sponge</b></col>
<fld>(Zool.)</fld>, <cd>any one of numerous species of siliceous sponges
having, often fibrous, glassy spicules which are normally six-rayed; a
hexactinellid sponge. See <cref>Venus's basket</cref>, under
<er>Venus</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitreousness</ent><br/
<hw>Vit"re*ous*ness</hw>, <pos>n.</pos> <def>The quality or state of
being vitreous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrescence</ent><br/
<hw>Vi*tres"cence</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being vitreous; glassiness, or the quality of being vitrescent;
capability of conversion into glass; susceptibility of being formed into
glass.</def> <rj><au>Kirwan.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrescent</ent><br/
<hw>Vi*tres"cent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Vitreous</er>.]</ety> <def>Capable of being formed into glass;
tending to become glass.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrescible</ent><br/
<hw>Vi*tres"ci*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vitrescible</ets>.]</ety> <def>That may be vitrified;
vitrifiable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitric</ent><br/
<hw>Vit"ric</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>vitrum</ets>
glass.]</ety> <def>Having the nature and qualities of glass; glasslike;
-- distinguished from <contr>ceramic</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrics</ent><br/
<hw>Vit"rics</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Vitric</er>.]</ety> <sn>1.</sn> <def>The art or study of the
manufacture and decoration of glassware.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <pluf>pl.</pluf> <def>Articles of glassware, glassware in
general.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vitrifaction</ent><br/
<hw>Vit`ri*fac"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Vitrification</er>.]</ety> <def>The act, art, or process of
vitrifying; also, the state of being vitrified.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrifacture</ent><br/
<hw>Vit`ri*fac"ture</hw> <pr>(?; 135)</pr>, <pos>n.</pos> <ety>[L.
<ets>vitrum</ets> glass + <ets>facere</ets>, <ets>factum</ets>, to
make.]</ety> <def>The manufacture of glass and glassware.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrifiable</ent><br/
<hw>Vit"ri*fi`a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vitrifiable</ets>.]</ety> <def>Capable of being vitrified, or
converted into glass by heat and fusion; <as>as, flint and alkalies are
<ex>vitrifiable</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrificable</ent><br/
<hw>Vi*trif"i*ca*ble</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Vitrifiable.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrificate</ent><br/
<hw>Vit"ri*fi*cate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To convert
into glass; to vitrify.</def> <mark>[Obs.]</mark>
<rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrification</ent><br/
<hw>Vit`ri*fi*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Vitrify</er>.]</ety> <def>Same as <er>Vitrifaction</er>.</def>
<rj><au>Sir T. Browne. Ure.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrified</ent><br/
<hw>Vit"ri*fied</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Converted into
glass.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitriform</ent><br/
<hw>Vit"ri*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vitrum</ets> glass + <ets>-form</ets>.]</ety> <def>Having the form
or appearance of glass; resembling glass; glasslike.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrify</ent><br/
<hw>Vit"ri*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vitrified</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vitrifying</conjf> <pr>(?)</pr>.]</vmorph> <ety>[F.
<ets>vitrifier</ets>; L. <ets>vitrum</ets> glass + <ets>-ficare</ets> to
make. See <er>Vitreous</er>, <er>-fy</er>.]</ety> <def>To convert into,
or cause to resemble, glass or a glassy substance, by heat and
fusion.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrify</ent><br/
<hw>Vit"ri*fy</hw>, <pos>v. t.</pos> <def>To become glass; to be
converted into glass.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Chymists make vessels of animal substances, calcined, which will
not <qex>vitrify</qex> in the fire.</q>
<rj><qau>Arbuthnot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrina</ent><br/
\'d8<hw>Vi*tri"na</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. L.
<ets>vitrum</ets> glass.]</ety> <fld>(Zool.)</fld> <def>A genus of
terrestrial gastropods, having transparent, very thin, and delicate
shells, -- whence the name.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrine</ent><br/
<hw>Vit"rine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A
glass show case for displaying fine wares, specimens, etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vitriol</ent><br/
<hw>Vit"ri*ol</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>vitriol</ets>; cf. Pr. <ets>vitriol</ets>, <ets>vetriol</ets>, Sp.
& Pg. <ets>vitriolo</ets>, It. <ets>vitriuolo</ets>; fr. L.
<ets>vitreolus</ets> of glass, <ets>vitreus</ets> vitreous. See
<er>Vitreous</er>.]</ety> <fld>(Chem.)</fld> <sd>(a)</sd> <def>A
sulphate of any one of certain metals, as copper, iron, zinc, cobalt. So
called on account of the glassy appearance or luster.</def> <sd>(b)</sd>
<def>Sulphuric acid; -- called also <altname>oil of vitriol</altname>.
So called because first made by the distillation of green vitriol. See
<cref>Sulphuric acid</cref>, under <er>Sulphuric</er>.</def>
<mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Blue vitriol</b></col>. <cd>See under <er>Blue</er>.</cd>
-- <col><b>Green vitriol</b></col>, <cd>ferrous sulphate; copperas. See
under <er>Green</er>.</cd> -- <col><b>Oil of vitriol</b></col>,
<cd>sulphuric or vitriolic acid; -- popularly so called because it has
the consistency of oil.</cd> -- <col><b>Red vitriol</b></col>, <cd>a
native sulphate of cobalt.</cd> -- <col><b>Vitriol of Mars</b></col>,
<cd>ferric sulphate, a white crystalline substance which dissolves in
water, forming a red solution.</cd> -- <col><b>White vitriol</b></col>,
<cd>zinc sulphate, a white crystalline substance used in medicine and in
dyeing. It is usually obtained by dissolving zinc in sulphuric acid, or
by roasting and oxidizing certain zinc ores. Formerly called also
<altname>vitriol of zinc</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitriol</ent><br/
<hw>Vit"ri*ol</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>-oled</conjf> <pr>(?)</pr> or <conjf>-olled</conjf>;
<pos>p. pr. & vb. n.</pos> <conjf>-oling</conjf> or
<conjf>-olling</conjf>.]</vmorph> <ety>[From <er>Vitriol</er>,
<pos>n.</pos>]</ety> <sn>1.</sn> <fld>(Metal.)</fld> <def>To dip in
dilute sulphuric acid; to pickle.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>To vitriolize.</def> <mark>[Colloq.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vitriolate</ent><br/
<hw>Vit"ri*o*late</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Vitriolated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vitriolating</conjf>.]</vmorph> <fld>(Old Chem.)</fld>
<sd>(a)</sd> <def>To convert into, or change to, a vitriol; to make into
sulphuric acid or a sulphate.</def> <sd>(b)</sd> <def>To subject to the
action of, or impregnate with, vitriol.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitriolate</ent><br/
<hw>Vit"ri*o*late</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Vitriolated.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitriolate</ent><br/
<hw>Vit"ri*o*late</hw>, <pos>n.</pos> <fld>(Old Chem.)</fld> <def>A
sulphate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitriolated</ent><br/
<hw>Vit"ri*o*la`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Old
Chem.)</fld> <def>Changed into a vitriol or a sulphate, or subjected to
the action of sulphuric acid or of a sulphate; <as>as,
<ex>vitriolated</ex> potash, <it>i. e.</it>, potassium
sulphate</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitriolation</ent><br/
<hw>Vit`ri*o*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Old
Chem.)</fld> <def>The act, process, or result of vitriolating.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitriolic</ent><br/
<hw>Vit`ri*ol"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vitriolique</ets>.]</ety> <sn>1.</sn> <fld>(Chem.)</fld> <def>Of or
pertaining to vitriol; derived from, or resembling, vitriol; vitriolous;
<as>as, a <ex>vitriolic</ex> taste</as>. Cf. <er>Vitriol</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Biting, bitter or caustic; having or expressing
strong and unpleasantly negative feelings; -- of speech or feelings;
<as>the <ex>vitriolic</ex> denunciations of opponents by partisan
columnists</as>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Vitriolic acid</b></col> <fld>(Old Chem.)</fld>,
<sd>(a)</sd> <cd>sulphuric acid. See <er>Vitriol</er> <sd>(b)</sd>.</cd>
<mark>[Colloq.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitriolizable</ent><br/
<hw>Vit"ri*ol*i`za*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of
being converted into a vitriol.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitriolization</ent><br/
<hw>Vit`ri*ol*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vitriolisation</ets>.]</ety> <fld>(Old Chem.)</fld> <def>The act of
vitriolizing, or the state of being vitriolized; vitriolation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitriolize</ent><br/
<hw>Vit"ri*ol*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[Cf. F.
<ets>vitrioliser</ets>.]</ety> <sn>1.</sn> <def>To convert into a
vitriol; to vitriolate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To injure (a person) with vitriol, or sulphuric
acid, as by throwing it upon the face.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vitriolous</ent><br/
<hw>Vi*tri"o*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>See
<er>Vitriolic</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitrite</ent><br/
<hw>Vit"rite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>vitrum</ets>
glass.]</ety> <def>A kind of glass which is very hard and difficult to
fuse, used as an insulator in electrical lamps and other
apparatus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitro-di-trina</ent><br/
<hw>Vit"ro-di-tri"na</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It.
<ets>vetro di trina</ets> glass of lace.]</ety> <def>A kind of Venetian
glass or glassware in which white threads are embedded in transparent
glass with a lacelike or netlike effect.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vitruvian</ent><br/
<hw>Vi*tru"vi*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining
to <person><etsep>Vitruvius</etsep></person>, an ancient Roman
architect.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vitruvian scroll</b></col> <fld>(Arch.)</fld>, <cd>a name
given to a peculiar pattern of scrollwork, consisting of convolved
undulations. It is used in classical architecture.</cd> <rj><au>Oxf.
Gloss.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vitta</ent><br/
\'d8<hw>Vit"ta</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vittae</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>vitta</ets> ribbon,
fillet.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>One of the oil tubes
in the fruit of umbelliferous plants.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A band, or stripe, of
color.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vittate</ent><br/
<hw>Vit"tate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vittatus</ets> bound with a fillet, fr. <ets>vitta</ets>
fillet.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>Bearing or containing
vittae.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Striped longitudinally.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vituline</ent><br/
<hw>Vit"u*line</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>vitulinus</ets>, fr. <ets>vitulus</ets> a calf. See
<er>Veal</er>.]</ety> <def>Of or pertaining to a calf or veal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vituperable</ent><br/
<hw>Vi*tu"per*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vituperabilis</ets>: cf. F. <ets>vitup<eacute/rable</ets>.]</ety>
<def>Liable to, or deserving, vituperation, or severe censure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vituperate</ent><br/
<hw>Vi*tu"per*ate</hw> <pr>(?; 277)</pr>, <pos>v. t.</pos> <ety>[L.
<ets>vituperatus</ets>, p. p. of <ets>vituperare</ets> to blame,
vituperate; <ets>vitium</ets> a fault + <ets>parare</ets> to prepare.
See <er>Vice</er> a fault, and <er>Pare</er>, <pos>v. t.</pos>]</ety>
<def>To find fault with; to scold; to overwhelm with wordy abuse; to
censure severely or abusively; to rate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vituperation</ent><br/
<hw>Vi*tu`per*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vituperatio</ets>: cf. OF. <ets>vituperation</ets>. See
<er>Vituperate</er>.]</ety> <def>The act of vituperating; abuse; severe
censure; blame.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When a man becomes untractable and inaccessible by fierceness and
pride, then <qex>vituperation</qex> comes upon him.</q>
<rj><qau>Donne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vituperative</ent><br/
<hw>Vi*tu"per*a*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Uttering or
writing censure; containing, or characterized by, abuse; scolding;
abusive.</def> -- <wordforms><wf>Vi*tu"per*a*tive*ly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vituperative</qex> appellations derived from their real or
supposed ill qualities.</q> <rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vituperator</ent><br/
<hw>Vi*tu"per*a`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety>
<def>One who vituperates, or censures abusively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vituperrious</ent><br/
<hw>Vi`tu*per"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Worthy of
vituperation; shameful; disgraceful.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viva</ent><br/
\'d8<hw>Vi"va</hw> <pr>(?)</pr>, <pos>interj.</pos> <ety>[It.]</ety>
<def>Lit., (long) live; -- an exclamation expressing good will, well
wishing, etc.</def> -- <def2><pos>n.</pos> <def>The word viva, or a
shout or sound made in uttering it.</def></def2><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><q>A wilder burst of <ldquo/<qex>vivas</qex><rdquo/.</q> <rj><qau>R.
H. Davis.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vivace</ent><br/
\'d8<hw>Vi*va"ce</hw> <pr>(?)</pr>, <pos>a. & adv.</pos>
<ety>[It.]</ety> <fld>(Mus.)</fld> <def>Brisk; vivacious; with spirit;
-- a direction to perform a passage in a brisk and lively
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivacious</ent><br/
<hw>Vi*va"cious</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>v<iacute/vax</ets>, <ets>-acis</ets>, fr. <ets>vivere</ets> to
live. See <er>Vivid</er>.]</ety> <sn>1.</sn> <def>Having vigorous powers
of life; tenacious of life; long-lived.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Hitherto the English bishops have been <qex>vivacious</qex> almost
to wonder. . . . But five died for the first twenty years of her [Queen
Elizabeth's] reign.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The faith of Christianity is far more <qex>vivacious</qex> than
any mere ravishment of the imagination can ever be.</q> <rj><qau>I.
Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Sprightly in temper or conduct; lively; merry;
<as>as, a <ex>vivacious</ex> poet</as>.</def>
<ldquo/<xex>Vivacious</xex> nonsense.<rdquo/ <rj><au>V.
Knox.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Bot.)</fld> <def>Living through the winter, or from
year to year; perennial.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Sprightly; active; animated; sportive; gay;
merry; jocund; light-hearted.</syn><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vi*va"cious*ly</wf>, <pos>adv.</pos> --
<wf>Vi*va"cious*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivacity</ent><br/
<hw>Vi*vac"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vivicitas</ets>: cf. F. <ets>vivacit<eacute/</ets>.]</ety> <def>The
quality or state of being vivacious.</def>
<specif>Specifically:</specif> --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>Tenacity of life; vital force; natural vigor.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>vivacity</qex> of some of these pensioners is little less
than a miracle, they lived so long.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>Life; animation; spiritedness; liveliness;
sprightliness; <as>as, the <ex>vivacity</ex> of a discourse; a lady of
great <ex>vivacity</ex>; <ex>vivacity</ex> of
countenance</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Liveliness; gayety. See
<er>Liveliness</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivandier</ent><br/
\'d8<hw>Vi`van`dier"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. & F.
<ets>vivandier</ets>, fr. LL. <ets>vivanda</ets>, <ets>vivenda</ets>,
provisions. Cf. <er>Viand</er>.]</ety> <def>In Continental armies, esp.
the French, a sutler.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vivandiere</ent><br/
\'d8<hw>Vi`van`di<egrave/re"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
See <er>Viand</er>.]</ety> <def>In Continental armies, especially in the
French army, a woman accompanying a regiment, who sells provisions and
liquor to the soldiers; a female sutler.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivant</ent><br/
\'d8<hw>Vi`vant"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., p. pr.,
living.]</ety> <def>In mort, bridge, and similar games, the partner of
dummy.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vivarium</ent><br/
\'d8<hw>Vi*va"ri*um</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
E. <plw>Vivariums</plw> <pr>(#)</pr>, L. <plw>Vivaria</plw>
<pr>(#)</pr>.</plu> <ety>[L., fr. <ets>vivarius</ets> belonging to
living creatures, fr. <ets>vivus</ets> alive, living. See
<er>Vivid</er>.]</ety> <def>A place artificially arranged for keeping or
raising living animals, as a park, a pond, an aquarium, a warren,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivary</ent><br/
<hw>Vi"va*ry</hw> <pr>(v<imac/"v<adot/*r<ycr/)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Vivaries</plw> <pr>(-r<icr/z)</pr>.</plu> <def>A
vivarium.</def> <ldquo/That . . . <xex>vivary</xex> of fowls and
beasts.<rdquo/ <rj><au>Donne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viva voce</ent><br/
\'d8<hw>Vi"va vo"ce</hw> <pr>(v<imac/"v<adot/ v<omac/"s<esl/)</pr>.
<ety>[L.]</ety> <def>By word of mouth; orally.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivda</ent><br/
<hw>Viv"da</hw> <pr>(v<icr/v"d<adot/)</pr>, <pos>n.</pos> <def>See
<er>Vifda</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vive</ent><br/
\'d8<hw>Vive</hw> <pr>(v<emac/v)</pr>. <ety>[F., imperative sing. pres.
fr. <ets>vivre</ets> to live, L. <ets>vivere</ets>.]</ety> <def>Long
live, that is, success to; <as>as, <ex>vive le roi</ex>, long live the
king; <ex>vive la bagatelle</ex>, success to trifles or
sport.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vive</ent><br/
<hw>Vive</hw> <pr>(v<imac/v)</pr>, <pos>a.</pos> <ety>[L.
<ets>vivus</ets>: cf. F. <ets>vif</ets>. See <er>Vivid</er>.]</ety>
<def>Lively; animated; forcible.</def> <mark>[Obs.]</mark>
<rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vively</ent><br/
<hw>Vive"ly</hw>, <pos>adv.</pos> <def>In a lively manner.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>If I see a thing <qex>vively</qex> represented on the stage.</q>
<rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivency</ent><br/
<hw>Vi"ven*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vivens</ets>, p. pr. of <ets>vivere</ets> to live.]</ety>
<def>Manner of supporting or continuing life or vegetation.</def>
<mark>[Obs.]</mark> <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viverra</ent><br/
\'d8<hw>Vi*ver"ra</hw> <pr>(v<icr/*v<ecr/r"r<adot/)</pr>, <pos>prop.
n.</pos> <ety>[L., a ferret.]</ety> <fld>(Zool.)</fld> <def>A genus of
carnivores which comprises the civets.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>viverrine</ent><br/
<hw>vi*ver"rine</hw> <pr>(v<icr/*v<ecr/r"r<imac/n)</pr>, <pos>a.</pos>
<fld>(Zool.)</fld> <def>Of or pertaining to the <fam>Viverridae</fam>,
or Civet family.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>vivers</ent><br/
<hw>vi"vers</hw> <pr>(v<emac/"v<etil/rz)</pr>, <pos>n. pl.</pos>
<ety>[F. <ets>vivres</ets>, pl. of <ets>vivre</ets>, orig., to
live.]</ety> <def>Provisions; victuals.</def> <mark>[Prov. Eng. &
Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I 'll join you at three, if the <qex>vivers</qex> can tarry so
long.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>vives</ent><br/
<hw>vives</hw> <pr>(v<imac/vz)</pr>, <pos>n.</pos> <ety>[OF.
<ets>vives</ets>, F. <ets>avives</ets> (cf. Sp. <ets>abivas</ets>,
<ets>adiva</ets>) fr. Ar. <ets>ad-dh<imac/ba</ets>. Cf. <er>Fives</er>
vives.]</ety> <fld>(Far.)</fld> <def>A disease of brute animals,
especially of horses, seated in the glands under the ear, where a tumor
is formed which sometimes ends in suppuration.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivianite</ent><br/
<hw>Viv"i*an*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So called by
<persfn>Werner</persfn> after the English mineralogist <person>F. G.
<etsep>Vivian</etsep></person>.]</ety> <fld>(Min.)</fld> <def>A hydrous
phosphate of iron of a blue to green color, growing darker on exposure.
It occurs in monoclinic crystals, also fibrous, massive, and
earthy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>vivid</ent><br/
<hw>viv"id</hw> <pr>(v<icr/v"<icr/d)</pr>, <pos>a.</pos> <ety>[L.
<ets>vividus</ets>, from <ets>vivere</ets> to life; akin to
<ets>vivus</ets> living. See <er>Quick</er>, <pos>a.</pos>, and cf.
<er>Revive</er>, <er>Viand</er>, <er>Victuals</er>,
<er>Vital</er>.]</ety> <sn>1.</sn> <def>True to the life; exhibiting the
appearance of life or freshness; animated; spirited; bright; strong;
intense; <as>as, <ex>vivid</ex> colors</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In dazzling streaks the <qex>vivid</qex> lightnings play.</q>
<rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Arts which present, with all the <qex>vivid</qex> charms of
painting, the human face and human form divine.</q> <rj><qau>Bp.
Hobart.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Forming brilliant images, or painting in lively
colors; lively; sprightly; <as>as, a <ex>vivid</ex>
imagination</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Body is a fit workhouse for sprightly, <qex>vivid</qex> faculties
to exercise . . . themselves in.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Clear; lucid; bright; strong; striking; lively;
quick; sprightly; active.</syn><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>viv"id*ly</wf>, <pos>adv.</pos> --
<wf>viv"id*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>vividity</ent><br/
<hw>vi*vid"i*ty</hw> <pr>(v<icr/*v<icr/d"<icr/*t<ycr/)</pr>,
<pos>n.</pos> <def>The quality or state of being vivid; vividness.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>vivifical</ent><br/
<ent>vivific</ent><br/
<mhw>{ <hw>vi*vif"ic</hw> <pr>(v<icr/*v<icr/f"<icr/k)</pr>,
<hw>vi*vif"ic*al</hw> <pr>(v<icr/*v<icr/f"<icr/*k<ait/l)</pr>, }</mhw>
<pos>a.</pos> <ety>[L. <ets>vivificus</ets>: cf. F.
<ets>vivifique</ets>. See <er>Vivify</er>.]</ety> <def>Giving life;
reviving; enlivening.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivificate</ent><br/
<hw>Vi*vif"i*cate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L.
<ets>vivificatus</ets>, p. p. <ets>vivificare</ets>. See
<er>Vivify</er>.]</ety> <sn>1.</sn> <def>To give life to; to animate; to
revive; to vivify.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>God <qex>vivificates</qex> and actuates the whole world.</q>
<rj><qau>Dr. H. More.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Chem.)</fld> <def>To bring back a metal to the
metallic form, as from an oxide or solution; to reduce.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivification</ent><br/
<hw>Viv`i*fi*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vivificatio</ets>: cf. <ets>vivification</ets>.]</ety> <sn>1.</sn>
<def>The act of vivifying, or the state of being vivified; restoration
of life; revival.</def> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Physiol.)</fld> <def>One of the changes of
assimilation, in which proteid matter which has been transformed, and
made a part of the tissue or tissue cells, is endowed with life, and
thus enabled to manifest the phenomena of irritability, contractility,
etc.</def> <rj><au>McKendrick.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Chem.)</fld> <def>The act or process of
vivificating.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivificative</ent><br/
<hw>Viv"i*fi*ca*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Able or
tending to vivify, animate, or give life; vivifying.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivify</ent><br/
<hw>Viv"i*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Vivified</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vivifying</conjf> <pr>(?)</pr>.]</vmorph> <ety>[F.
<ets>vivifier</ets>, L. <ets>vivificare</ets>. See <er>Vivid</er>,
<er>-fy</er>; cf. <er>Vivificate</er>.]</ety> <def>To endue with life;
to make to be living; to quicken; to animate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Sitting on eggs doth <qex>vivify</qex>, not nourish.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivipara</ent><br/
\'d8<hw>Vi*vip"a*ra</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See
<er>Viviparous</er>.]</ety> <fld>(Zool.)</fld> <def>An artificial
division of vertebrates including those that produce their young alive;
-- opposed to <contr>Ovipara</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viviparity</ent><br/
<hw>Viv`i*par"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Biol.)</fld>
<def>The quality or condition of being viviparous.</def> <rj><au>H.
Spencer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1616 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viviparous</ent><br/
<hw>Vi*vip"a*rous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>viviparus</ets>; <ets>vivus</ets> alive + <ets>parere</ets> to
bear, bring forth. Cf. <er>Viper</er>.]</ety> <fld>(Biol.)</fld>
<def>Producing young in a living state, as most mammals, or as those
plants the offspring of which are produced alive, either by bulbs
instead of seeds, or by the seeds themselves germinating on the plant,
instead of falling, as they usually do; -- opposed to
<contr>oviparous</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Viviparous fish</b></col>. <fld>(Zool.)</fld> <cd>See
<er>Embiotocoid</er>.</cd> -- <col><b>Viviparous shell</b></col>
<fld>(Zool.)</fld>, <cd>any one of numerous species of operculated
fresh-water gastropods belonging to <gen>Viviparus</gen>,
<gen>Melantho</gen>, and allied genera. Their young, when born, have a
well-developed spiral shell.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viviparously</ent><br/
<hw>Vi*vip"a*rous*ly</hw>, <pos>adv.</pos> <fld>(Biol.)</fld> <def>In a
viviparous manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viviparousness</ent><br/
<hw>Vi*vip"a*rous*ness</hw>, <pos>n.</pos> <fld>(Biol.)</fld> <def>The
quality of being viviparous; viviparity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivisect</ent><br/
<hw>Viv"i*sect`</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To perform
vivisection upon; to dissect alive.</def> <mark>[Colloq.]</mark>
<rj><au>Pop. Sci. Monthly.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivisection</ent><br/
<hw>Viv`i*sec"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vivus</ets> alive + E. <ets>section</ets>: cf. F.
<ets>vivisection</ets>. See <er>Vivid</er>, and <er>Section</er>.]</ety>
<def>The dissection of an animal while alive, for the purpose of making
physiological investigations.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivisectional</ent><br/
<hw>Viv`i*sec"tion*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or
pertaining to vivisection.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivisectionist</ent><br/
<hw>Viv`i*sec"tion*ist</hw>, <pos>n.</pos> <def>One who practices or
advocates vivisection; a vivisector.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vivisector</ent><br/
<hw>Viv`i*sec"tor</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A
vivisectionist.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vixen</ent><br/
<hw>Vix"en</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>fixen</ets> a
she-fox, for <ets>fyxen</ets>, fem. of <ets>fox</ets>. See
<er>Fox</er>.]</ety> <sn>1.</sn> <def>A female fox.</def> <mark>[Obs. or
Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A cross, ill-tempered person; -- formerly used of
either sex, now only of a woman.</def> <rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>She was a <qex>vixen</qex> when she went to school.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vixenish</ent><br/
<hw>Vix"en*ish</hw>, <pos>a.</pos> <def>Of or pertaining to a vixen;
resembling a vixen.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vixenly</ent><br/
<hw>Vix"en*ly</hw>, <pos>a.</pos> <def>Like a vixen; vixenish.</def>
<rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Viz</ent><br/
<hw>Viz</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[Contr. fr.
<ets>videlicet</ets>.]</ety> <def>To wit; that is; namely.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vizard</ent><br/
<hw>Viz"ard</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Visor</er>.]</ety> <def>A mask; a visor.</def>
<mark>[Archaic]</mark> <ldquo/A grotesque <xex>vizard</xex>.<rdquo/
<rj><au>Sir W. Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To mislead and betray them under the <qex>vizard</qex> of law.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vizarded</ent><br/
<hw>Viz"ard*ed</hw>, <pos>a.</pos> <def>Wearing a vizard.</def>
<mark>[R.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vizcacha</ent><br/
\'d8<hw>Viz*ca"cha</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp.]</ety>
<fld>(Zool.)</fld> <def>Same as <er>Viscacha</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vizier</ent><br/
<hw>Viz"ier</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Ar.
<ets>wez<imac/r</ets>, <ets>waz<imac/r</ets>, properly, a bearer of
burdens, a porter, from <ets>wazara</ets> to bear a burden: cf. F.
<ets>vizir</ets>, <ets>visir</ets>. Cf. <er>Alguazil</er>.]</ety> <def>A
councilor of state; a high executive officer in Turkey and other
Oriental countries.</def> <altsp>[Written also <asp>visier</asp>,
<asp>vizir</asp>, and <asp>vizer</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Grand vizier</b></col>, <cd>the chief minister of the
Turkish empire; -- called also
<altname>vizier-azem</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vizierate</ent><br/
<hw>Viz"ier*ate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vizirat</ets>.]</ety> <def>The office, dignity, or authority of a
vizier.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vizier-azem</ent><br/
\'d8<hw>Vi*zier`-a*zem"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Ar.
<ets>azam</ets> great. See <er>Vizier</er>.]</ety> <def>A grand vizier.
See under <er>Vizier</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vizierial</ent><br/
<hw>Vi*zier"i*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vizirial</ets>.]</ety> <def>Of, pertaining to, or issued by, a
vizier.</def> <altsp>[Written also <asp>vizirial</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vizir</ent><br/
<hw>Vi*zir"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Vizier</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vizor</ent><br/
<hw>Viz"or</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Visor</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vlissmaki</ent><br/
<hw>Vliss*ma"ki</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the native
name.]</ety> <fld>(Zool.)</fld> <def>The diadem indris. See
<er>Indris</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>V moth</ent><br/
<hw>V" moth`</hw> <pr>(?)</pr>. <fld>(Zool.)</fld> <def>A common gray
European moth (<spn>Halia vauaria</spn>) having a
<universbold>V</universbold>-shaped spot of dark brown on each of the
fore wings.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocable</ent><br/
<hw>Vo"ca*ble</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vocabulum</ets> an appellation, designation, name, fr.
<ets>vocare</ets> to call, fr. <ets>vox</ets>, <ets>vocis</ets>, a
voice, a word: cf. F. <ets>vocable</ets>. See <er>Voice</er>.]</ety>
<def>A word; a term; a name; specifically, a word considered as composed
of certain sounds or letters, without regard to its meaning.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Swamped near to drowning in a tide of ingenious
<qex>vocables</qex>.</q> <rj><qau>Carlyle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocabulary</ent><br/
<hw>Vo*cab"u*la*ry</hw> <pr>(v<osl/*k<acr/b"<usl/*l<asl/*r<ycr/)</pr>,
<pos>n.</pos>; <plu><it>pl.</it> <plw>Vocabularies</plw>
<pr>(#)</pr>.</plu> <ety>[LL. <ets>vocabularium</ets>,
<ets>vocabularius</ets>: cf. F. <ets>vocabulaire</ets>. See
<er>Vocable</er>.]</ety> <sn>1.</sn> <def>A list or collection of words
arranged in alphabetical order and explained; a dictionary or lexicon,
either of a whole language, a single work or author, a branch of
science, or the like; a word-book.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>. . .</ent><br/
<note>The <ldquo/vocabulary<rdquo/ of this dictionary referred to within
the definitions of certain collocations are those words serving as
headwords for main entries, and distinguished from word combinations
(<ldquo/collocations<rdquo/) which follow the main part of certain
entries. In the XML-tagged version, these headwords are marked by the
tags <hw>. . .</hw>.</note><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>A sum or stock of words employed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His <qex>vocabulary</qex> seems to have been no larger than was
necessary for the transaction of business.</q>
<rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocabulist</ent><br/
<hw>Vo*cab"u*list</hw> <pr>(v<osl/*k<acr/b"<usl/*l<icr/st)</pr>,
<pos>n.</pos> <ety>[Cf. F. <ets>vocabuliste</ets>.]</ety> <def>The
writer or maker of a vocabulary; a lexicographer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocal</ent><br/
<hw>Vo"cal</hw> <pr>(v<omac/"k<ait/l)</pr>, <pos>a.</pos> <ety>[L.
<ets>vocalis</ets>, fr. <ets>vox</ets>, <ets>vocis</ets>, voice: cf. F.
<ets>vocal</ets>. See <er>Voice</er>, and cf. <er>Vowel</er>.]</ety>
<sn>1.</sn> <def>Of or pertaining to the voice or speech; having voice;
endowed with utterance; full of voice, or voices.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To hill or valley, fountain, or fresh shade,<br/
Made <qex>vocal</qex> by my song.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Uttered or modulated by the voice; oral; <as>as,
<ex>vocal</ex> melody; <ex>vocal</ex> prayer</as>.</def>
<ldquo/<xex>Vocal</xex> worship.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Of or pertaining to a vowel or voice sound; also,
spoken with tone, intonation, and resonance; sonant; sonorous; -- said
of certain articulate sounds.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Phon.)</fld> <sd>(a)</sd> <def>Consisting of, or
characterized by, voice, or tone produced in the larynx, which may be
modified, either by resonance, as in the case of the vowels, or by
obstructive action, as in certain consonants, such as <xex>v</xex>,
<xex>l</xex>, etc., or by both, as in the nasals <xex>m</xex>,
<xex>n</xex>, <xex>ng</xex>; sonant; intonated; voiced. See
<er>Voice</er>, and <er>Vowel</er>, also <xex>Guide to
Pronunciation</xex>, <sect/<sect/ 199-202.</def> <sd>(b)</sd> <def>Of or
pertaining to a vowel; having the character of a vowel; vowel.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Vocal cords</b></col> <it>or</it> <col><b>Vocal
chords</b></col></mcol>. <pos>n. pl.</pos> <fld>(Anat.)</fld> <cd>The
two pairs of mucous membranes that project into the larynx, and which
produce the sounds of speech by vibrating under the influence of air
exhaled from the lungs. See <er>Larynx</er>, and the Note under
<er>Voice</er>, <pos>n.</pos>, 1.</cd> -- <col><b>Vocal
fremitus</b></col> <ety>[L. <ets>fremitus</ets> a dull roaring or
murmuring]</ety> <fld>(Med.)</fld>, <cd>the perceptible vibration of the
chest wall, produced by the transmission of the sonorous vibrations
during the act of using the voice.</cd> -- <col><b>Vocal
music</b></col>, <cd>music made by the voice, in distinction from
<contr>instrumental music</contr>; hence, music or tunes set to words,
to be performed by the human voice.</cd> -- <col><b>Vocal tube</b></col>
<fld>(Anat.)</fld>, <cd>the part of the air passages above the inferior
ligaments of the larynx, including the passages through the nose and
mouth.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocal</ent><br/
<hw>Vo"cal</hw> <pr>(v<omac/"k<ait/l)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vocal</ets>, LL. <ets>vocalis</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Phon.)</fld> <def>A vocal sound; specifically, a
purely vocal element of speech, unmodified except by resonance; a vowel
or a diphthong; a tonic element; a tonic; -- distinguished from a
<xex>subvocal</xex>, and a <xex>nonvocal</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(R. C. Ch.)</fld> <def>A man who has a right to vote
in certain elections.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocalic</ent><br/
<hw>Vo*cal"ic</hw> <pr>(v<osl/*k<acr/l"<icr/k)</pr>, <pos>a.</pos>
<ety>[L. <ets>vocalis</ets> (sc. <ets>littera</ets>) a vowel. See
<er>Vocal</er>, <pos>a.</pos>]</ety> <def>Of or pertaining to vowel
sounds; consisting of the vowel sounds.</def>
<rj><au>Earle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The Gaelic language being uncommonly <qex>vocalic</qex>.</q>
<rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocalism</ent><br/
<hw>Vo"cal*ism</hw> <pr>(v<omac/"k<ait/l*<icr/z'm)</pr>, <pos>n.</pos>
<sn>1.</sn> <def>The exercise of the vocal organs;
vocalization.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A vocalic sound.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocalist</ent><br/
<hw>Vo"cal*ist</hw>, <pos>n.</pos> <ety>[Cf. F.
<ets>vocaliste</ets>.]</ety> <def>A singer, or vocal musician, as
opposed to an <contr>instrumentalist</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocality</ent><br/
<hw>Vo*cal"i*ty</hw> <pr>(v<osl/*k<acr/l"<icr/*t<ycr/)</pr>,
<pos>n.</pos> <ety>[Cf. L. <ets>vocalitas</ets> euphony.]</ety>
<sn>1.</sn> <def>The quality or state of being vocal; utterableness;
resonance; <as>as, the <ex>vocality</ex> of the letters</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The quality of being a vowel; vocalic
character.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocalization</ent><br/
<hw>Vo`cal*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn>
<def>The act of vocalizing, or the state of being vocalized.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The formation and utterance of vocal
sounds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocalize</ent><br/
<hw>Vo"cal*ize</hw> <pr>(v<omac/"k<ait/l*<imac/z)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Vocalized</conjf>
<pr>(v<omac/"k<ait/l*<imac/zd)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vocalizing</conjf>
<pr>(v<omac/"k<ait/l*<imac/*z<icr/ng)</pr>.]</vmorph> <ety>[Cf. F.
<ets>vocaliser</ets>.]</ety> <sn>1.</sn> <def>To form into voice; to
make vocal or sonant; to give intonation or resonance to.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It is one thing to give an impulse to breath alone, another thing
to <qex>vocalize</qex> that breath.</q> <rj><qau>Holder.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To practice singing on the vowel sounds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocally</ent><br/
<hw>Vo"cal*ly</hw>, <pos>adv.</pos> <sn>1.</sn> <def>In a vocal manner;
with voice; orally; with audible sound.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In words; verbally; <as>as, to express desires
<ex>vocally</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocalness</ent><br/
<hw>Vo"cal*ness</hw>, <pos>n.</pos> <def>The quality of being vocal;
vocality.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocation</ent><br/
<hw>Vo*ca"tion</hw> <pr>(v<osl/*k<amac/"sh<ucr/n)</pr>, <pos>n.</pos>
<ety>[L. <ets>vocatio</ets> a bidding, invitation, fr. <ets>vocare</ets>
to call, fr. <ets>vox</ets>, <ets>vocis</ets>, voice: cf. F.
<ets>vocation</ets>. See <er>Vocal</er>.]</ety> <sn>1.</sn> <def>A call;
a summons; a citation; especially, a designation or appointment to a
particular state, business, or profession.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>What can be urged for them who not having the <qex>vocation</qex>
of poverty to scribble, out of mere wantonness make themselves
ridiculous?</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Destined or appropriate employment; calling;
occupation; trade; business; profession.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He would think his service greatly rewarded, if he might obtain by
that means to live in the sight of his prince, and yet practice his own
chosen <qex>vocation</qex>.</q> <rj><qau>Sir. P. Sidney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Theol.)</fld> <def>A calling by the will of
God.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>The bestowment of God's distinguishing grace upon a
person or nation, by which that person or nation is put in the way of
salvation; <as>as, the <ex>vocation</ex> of the Jews under the old
dispensation, and of the Gentiles under the gospel</as>.</def>
<ldquo/The golden chain of <xex>vocation</xex>, election, and
justification.<rdquo/ <rj><au>Jer. Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>A call to special religious work, as to the
ministry.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Every member of the same [the Church], in his <qex>vocation</qex>
and ministry.</q> <rj><qau>Bk. of Com. Prayer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocative</ent><br/
<hw>Voc"a*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vocativus</ets>, fr. <ets>vocare</ets> to call.]</ety> <def>Of or
pertaining to calling; used in calling; specifically <fld>(Gram.)</fld>,
used in address; appellative; -- said of that case or form of the noun,
pronoun, or adjective, in which a person or thing is addressed; <as>as,
<ex>Domine</ex>, O Lord</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocative</ent><br/
<hw>Voc"a*tive</hw>, <pos>n.</pos> <ety>[L. <ets>vocativus</ets> (sc.
<ets>casus</ets>): cf. F. <ets>vocatif</ets>.]</ety> <fld>(Gram.)</fld>
<def>The vocative case.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vociferance</ent><br/
<hw>Vo*cif"er*ance</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Vociferation;
noise; clamor.</def> <mark>[R.]</mark> <rj><au>R.
Browning.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vociferant</ent><br/
<hw>Vo*cif"er*ant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vociferans</ets>, p. pr.]</ety> <def>Noisy; clamorous.</def>
<rj><au>Gauden. R. Browning.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vociferate</ent><br/
<hw>Vo*cif"er*ate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[L.
<ets>vociferatus</ets>, p. p. <ets>vociferari</ets> to vociferate;
<ets>vox</ets>, <ets>vocis</ets>, voice + <ets>ferre</ets> to bear. See
<er>Voice</er>, and <er>Bear</er> to carry.]</ety> <def>To cry out with
vehemence; to exclaim; to bawl; to clamor.</def>
<rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vociferate</ent><br/
<hw>Vo*cif"er*ate</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Vociferated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vociferating</conjf>.]</vmorph> <def>To utter with a
loud voice; to shout out.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Though he may <qex>vociferate</qex> the word liberty.</q>
<rj><qau>V. Knox.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vociferation</ent><br/
<hw>Vo*cif`er*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vociferatio</ets>: cf. F. <ets>vocif<eacute/ration</ets>.]</ety>
<def>The act of vociferating; violent outcry; vehement utterance of the
voice.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Violent gesture and <qex>vociferation</qex> naturally shake the
hearts of the ignorant.</q> <rj><qau>Spectator.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Plaintive strains succeeding the <qex>vociferations</qex> of
emotion or of pain.</q> <rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vociferator</ent><br/
<hw>Vo*cif"er*a`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who
vociferates, or is clamorous.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vociferous</ent><br/
<hw>Vo*cif"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vocif<egrave/re</ets>.]</ety> <def>Making a loud outcry; clamorous;
noisy; <as>as, <ex>vociferous</ex> heralds</as>.</def> --
<wordforms><wf>Vo*cif"er*ous*ly</wf>, <pos>adv.</pos> --
<wf>Vo*cif"er*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vocule</ent><br/
<hw>Voc"ule</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>vocula</ets>,
dim. of <ets>vox</ets>, <ets>vocis</ets>, voice.]</ety>
<fld>(Phon.)</fld> <def>A short or weak utterance; a faint or feeble
sound, as that heard on separating the lips in pronouncing <xex>p</xex>
or <xex>b</xex>.</def> <au>Rush.</au> -- <wordforms><wf>Voc"u*lar</wf>
<pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vodanium</ent><br/
<hw>Vo*da"ni*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.]</ety>
<fld>(Old Chem.)</fld> <def>A supposed element, afterward found to be a
mixture of several metals, as copper, iron, lead, nickel, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vodka</ent><br/
<hw>Vod"ka</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Russ.]</ety> <def>A
Russian drink distilled from rye.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voe</ent><br/
<hw>Voe</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Icel <ets>ver</ets>
sea, <ets>v<oum/ar</ets> a fenced-in landing place.]</ety> <def>An
inlet, bay, or creek; -- so called in the Orkney and Shetland
Islands.</def> <rj><au>Jamieson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vogle</ent><br/
<hw>Vo"gle</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Mining)</fld>
<def>Same as <er>Vugg</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vogue</ent><br/
<hw>Vogue</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>vogue</ets> a
rowing, vogue, fashion, It. <ets>voga</ets>, fr. <ets>vogare</ets> to
row, to sail; probably fr. OHG. <ets>wag<?/n</ets> to move, akin to E.
<ets>way</ets>. Cf. <er>Way</er>.]</ety> <sn>1.</sn> <def>The way or
fashion of people at any particular time; temporary mode, custom, or
practice; popular reception for the time; -- used now generally in the
phrase <xex>in vogue</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>One <qex>vogue</qex>, one vein,<br/
One air of thoughts usurps my brain.</q>
<rj><qau>Herbert.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Whatsoever its <qex>vogue</qex> may be, I still flatter myself
that the parents of the growing generation will be satisfied with what
<?/<?/ to be taught to their children in Westminster, in Eton, or in
Winchester.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Use may revive the obsoletest words,<br/
And banish those that now are most in <qex>vogue</qex>.</q>
<rj><qau>Roscommon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Influence; power; sway.</def> <mark>[Obs.]</mark>
<rj><au>Strype.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voice</ent><br/
<hw>Voice</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>vois</ets>,
<ets>voys</ets>, OF. <ets>vois</ets>, <ets>voiz</ets>, F.
<ets>voix</ets>, L. <ets>vox</ets>, <ets>vocis</ets>, akin to Gr. <?/ a
word, <?/ a voice, Skr. <ets>vac</ets> to say, to speak, G.
er<ets>w<aum/hnen</ets> to mention. Cf. <er>Advocate</er>,
<er>Advowson</er>, <er>Avouch</er>, <er>Convoke</er>, <er>Epic</er>,
<er>Vocal</er>, <er>Vouch</er>, <er>Vowel</er>.]</ety> <sn>1.</sn>
<def>Sound uttered by the mouth, especially that uttered by human beings
in speech or song; sound thus uttered considered as possessing some
special quality or character; <as>as, the human <ex>voice</ex>; a
pleasant <ex>voice</ex>; a low <ex>voice</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He with a manly <qex>voice</qex> saith his message.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Her <qex>voice</qex> was ever soft,<br/
Gentle, and low; an excellent thing in woman.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Thy <qex>voice</qex> is music.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Join thy <qex>voice</qex> unto the angel choir.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Phon.)</fld> <def>Sound of the kind or quality
heard in speech or song in the consonants <xex>b</xex>, <xex>v</xex>,
<xex>d</xex>, etc., and in the vowels; sonant, or intonated, utterance;
tone; -- distinguished from mere <xex>breath</xex> sound as heard in
<xex>f</xex>, <xex>s</xex>, <xex>sh</xex>, etc., and also
<xex>whisper</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Voice, in this sense, is produced by vibration of the
so-called vocal cords in the larynx (see <xex>Illust.</xex> of
<er>Larynx</er>) which act upon the air, not in the manner of the
strings of a stringed instrument, but as a pair of membranous tongues,
or reeds, which, being continually forced apart by the outgoing current
of breath, and continually brought together again by their own
elasticity and muscular tension, break the breath current into a series
of puffs, or pulses, sufficiently rapid to cause the sensation of tone.
The <xex>power</xex>, or loudness, of such a tone depends on the force
of the separate pulses, and this is determined by the pressure of the
expired air, together with the resistance on the part of the vocal cords
which is continually overcome. Its <xex>pitch</xex> depends on the
number of aerial pulses within a given time, that is, on the rapidity of
their succession. See <xex>Guide to Pronunciation</xex>, <sect/<sect/ 5,
146, 155.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The tone or sound emitted by anything.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>After the fire a still small <qex>voice</qex>.</q> <rj><qau>1
Kings xix. 12.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Canst thou thunder with a <qex>voice</qex> like him?</q>
<rj><qau>Job xl. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The floods have lifted up their <qex>voice</qex>.</q> <rj><qau>Ps.
xciii. 3.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>O Marcus, I am warm'd; my heart<br/
Leaps at the trumpet's <qex>voice</qex>.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The faculty or power of utterance; <as>as, to
cultivate the <ex>voice</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Language; words; speech; expression; signification
of feeling or opinion.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I desire to be present with you now, and to change my
<qex>voice</qex>; for I stand in doubt of you.</q> <rj><qau>Gal. iv.
20.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>My <qex>voice</qex> is in my sword.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Let us call on God in the <qex>voice</qex> of his church.</q>
<rj><qau>Bp. Fell.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Opinion or choice expressed; judgment; a
vote.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Sic</qex>. How now, my masters! have you chose this man?<br/
1 <qex>Cit</qex>. He has our <qex>voices</qex>, sir.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Some laws ordain, and some attend the choice<br/
Of holy senates, and elect by <qex>voice</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Command; precept; -- now chiefly used in scriptural
language.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>So shall ye perish; because ye would not be obedient unto the
<qex>voice</qex> of the Lord your God.</q> <rj><qau>Deut. viii.
20.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>One who speaks; a speaker.</def> <ldquo/A potent
<xex>voice</xex> of Parliament.<rdquo/ <rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Gram.)</fld> <def>A particular mode of inflecting
or conjugating verbs, or a particular form of a verb, by means of which
is indicated the relation of the subject of the verb to the action which
the verb expresses.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Active voice</b></col> <fld>(Gram.)</fld>, <cd>that form
of the verb by which its subject is represented as the agent or doer of
the action expressed by it.</cd> -- <col><b>Chest voice</b></col>
<fld>(Phon.)</fld>, <cd>a kind of voice of a medium or low pitch and of
a sonorous quality ascribed to resonance in the chest, or thorax; voice
of the thick register. It is produced by vibration of the vocal cords
through their entire width and thickness, and with convex surfaces
presented to each other.</cd> -- <col><b>Head voice</b></col>
<fld>(Phon.)</fld>, <cd>a kind of voice of high pitch and of a thin
quality ascribed to resonance in the head; voice of the thin register;
falsetto. In producing it, the vibration of the cords is limited to
their thin edges in the upper part, which are then presented to each
other.</cd> -- <col><b>Middle voice</b></col> <fld>(Gram.)</fld>,
<cd>that form of the verb by which its subject is represented as both
the agent, or doer, and the object of the action, that is, as performing
some act to or upon himself, or for his own advantage.</cd> --
<col><b>Passive voice</b></col>. <fld>(Gram.)</fld> <cd>See under
<er>Passive</er>, <pos>a.</pos></cd> -- <col><b>Voice glide</b></col>
<fld>(Pron.)</fld>, <cd>the brief and obscure neutral vowel sound that
sometimes occurs between two consonants in an unaccented syllable
(represented by the apostrophe), as in <xex>able</xex> <pr>(a"b'l)</pr>.
See <er>Glide</er>, <pos>n.</pos>, 2.</cd> -- <col><b>Voice
stop</b></col>. <cd>See <cref>Voiced stop</cref>, under <er>Voiced</er>,
<pos>a.</pos></cd> -- <col><b>With one voice</b></col>,
<cd>unanimously.</cd> <ldquo/All <xex>with one voice</xex> . . . cried
out, Great is Diana of the Ephesians.<rdquo/ <au>Acts xix.
34.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voice</ent><br/
<hw>Voice</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Voiced</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Voicing</conjf> <pr>(?)</pr>.]</vmorph> <sn>1.</sn> <def>To give
utterance or expression to; to utter; to publish; to announce; to
divulge; <as>as, to <ex>voice</ex> the sentiments of the
nation</as>.</def> <ldquo/Rather assume thy right in silence and . . .
then <xex>voice</xex> it with claims and challenges.<rdquo/
<rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It was <qex>voiced</qex> that the king purposed to put to death
Edward Plantagenet.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Phon.)</fld> <def>To utter with sonant or vocal
tone; to pronounce with a narrowed glottis and rapid vibrations of the
vocal cords; to speak above a whisper.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To fit for producing the proper sounds; to regulate
the tone of; <as>as, to <ex>voice</ex> the pipes of an
organ</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To vote; to elect; to appoint.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voice</ent><br/
<hw>Voice</hw>, <pos>v. i.</pos> <def>To clamor; to cry out.</def>
<mark>[Obs.]</mark> <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voiced</ent><br/
<hw>Voiced</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Furnished
with a voice; expressed by the voice.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Phon.)</fld> <def>Uttered with voice; pronounced
with vibrations of the vocal cords; sonant; -- said of a sound uttered
with the glottis narrowed.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Voiced stop</b></col>, <col><b>Voice
stop</b></col></mcol> <fld>(Phon.)</fld>, <cd>a stopped consonant made
with tone from the larynx while the mouth organs are closed at some
point; a sonant mute, as <xex>b</xex>, <xex>d</xex>, <xex>g</xex>
hard.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1617 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voiceful</ent><br/
<hw>Voice"ful</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having a voice or
vocal quality; having a loud voice or many voices; vocal;
sounding.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Beheld the Iliad and the Odyssey<br/
Rise to the swelling of the <qex>voiceful</qex> sea.</q>
<rj><qau>Coleridge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voiceless</ent><br/
<hw>Voice"less</hw>, <pos>a.</pos> <sn>1.</sn> <def>Having no voice,
utterance, or vote; silent; mute; dumb.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I live and die unheard,<br/
With a most <qex>voiceless</qex> thought, sheathing it as a sword.</q>
<rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Phon.)</fld> <def>Not sounded with voice; <as>as, a
<ex>voiceless</ex> consonant</as>; surd.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Voiceless stop</b></col> <fld>(Phon.)</fld>, <cd>a
consonant made with no audible sound except in the transition to or from
another sound; a surd mute, as <xex>p</xex>, <xex>t</xex>,
<xex>k</xex>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Voice"less*ly</wf>, <pos>adv.</pos> --
<wf>Voice"less*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Void</ent><br/
<hw>Void</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OE. <ets>voide</ets>,
OF. <ets>voit</ets>, <ets>voide</ets>, <ets>vuit</ets>,
<ets>vuide</ets>, F. <ets>vide</ets>, fr. (assumed) LL.
<ets>vocitus</ets>, fr. L. <ets>vocare</ets>, an old form of
<ets>vacare</ets> to be empty, or a kindred word. Cf. <er>Vacant</er>,
<er>Avoid</er>.]</ety> <sn>1.</sn> <def>Containing nothing; empty;
vacant; not occupied; not filled.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The earth was without form, and <qex>void</qex>.</q> <rj><qau>Gen.
i. 2.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I 'll get me to a place more <qex>void</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I 'll chain him in my study, that, at <qex>void</qex> hours,<br/
I may run over the story of his country.</q>
<rj><qau>Massinger.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Having no incumbent; unoccupied; -- said of offices
and the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Divers great offices that had been long <qex>void</qex>.</q>
<rj><qau>Camden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Being without; destitute; free; wanting; devoid;
<as>as, <ex>void</ex> of learning, or of common use</as>.</def>
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A conscience <qex>void</qex> of offense toward God.</q>
<rj><qau>Acts xxiv. 16.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He that is <qex>void</qex> of wisdom despiseth his neighbor.</q>
<rj><qau>Prov. xi. 12.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Not producing any effect; ineffectual;
vain.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[My word] shall not return to me <qex>void</qex>, but it shall
accomplish that which I please.</q> <rj><qau>Isa. lv. 11.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I will make <qex>void</qex> the counsel of Judah.</q>
<rj><qau>Jer. xix. 7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Containing no immaterial quality; destitute of mind
or soul.</def> <ldquo/Idol, <xex>void</xex> and vain.<rdquo/
<rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Law)</fld> <def>Of no legal force or effect,
incapable of confirmation or ratification; null. Cf. <er>Voidable</er>,
2.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Void space</b></col> <fld>(Physics)</fld>, <cd>a
vacuum.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Empty; vacant; devoid; wanting; unfurnished;
unsupplied; unoccupied.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Void</ent><br/
<hw>Void</hw>, <pos>n.</pos> <def>An empty space; a vacuum.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Pride, where wit fails, steps in to our defense,<br/
And fills up all the mighty <qex>void</qex> of sense.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Void</ent><br/
<hw>Void</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Voided</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Voiding</conjf>.]</vmorph> <ety>[OF. <ets>voidier</ets>,
<ets>vuidier</ets>. See <er>Void</er>, <pos>a.</pos>]</ety> <sn>1.</sn>
<def>To remove the contents of; to make or leave vacant or empty; to
quit; to leave; <as>as, to <ex>void</ex> a table</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Void</qex> anon her place.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>If they will fight with us, bid them come down,<br/
Or <qex>void</qex> the field.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To throw or send out; to evacuate; to emit; to
discharge; <as>as, to <ex>void</ex> excrements</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A watchful application of mind in <qex>voiding</qex>
prejudices.</q> <rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>With shovel, like a fury, <qex>voided</qex> out<br/
The earth and scattered bones.</q> <rj><qau>J. Webster.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To render void; to make to be of no validity or
effect; to vacate; to annul; to nullify.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>After they had <qex>voided</qex> the obligation of the oath he had
taken.</q> <rj><qau>Bp. Burnet.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It was become a practice . . . to <qex>void</qex> the security
that was at any time given for money so borrowed.</q>
<rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Void</ent><br/
<hw>Void</hw>, <pos>v. i.</pos> <def>To be emitted or evacuated.</def>
<rj><au>Wiseman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voidable</ent><br/
<hw>Void"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Capable
of being voided, or evacuated.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>Capable of being avoided, or of
being adjudged void, invalid, and of no force; capable of being either
avoided or confirmed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If the metropolitan . . . grants letters of administration, such
administration is not, but <qex>voidable</qex> by sentence.</q>
<rj><qau>Ayliffe.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A <xex>voidable</xex> contract may be ratified and
confirmed; to render it null and of no effect, it must be
<xex>avoided</xex>; a <xex>void</xex> contract can not be
ratified.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voidance</ent><br/
<hw>Void"ance</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act
of voiding, emptying, ejecting, or evacuating.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Eccl.)</fld> <def>A ejection from a
benefice.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The state of being void; vacancy, as of a benefice
which is without an incumbent.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Evasion; subterfuge.</def> <mark>[Obs.]</mark>
<rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voided</ent><br/
<hw>Void"ed</hw>, <pos>a.</pos> <sn>1.</sn> <def>Emptied;
evacuated.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Annulled; invalidated.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Her.)</fld> <def>Having the inner part cut away, or
left vacant, a narrow border being left at the sides, the tincture of
the field being seen in the vacant space; -- said of a charge.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voider</ent><br/
<hw>Void"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who,
or that which, voids, empties, vacates, or annuls.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A tray, or basket, formerly used to receive or
convey that which is voided or cleared away from a given place;
especially, one for carrying off the remains of a meal, as fragments of
food; sometimes, a basket for containing household articles, as clothes,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Piers Plowman laid the cloth, and Simplicity brought in the
<qex>voider</qex>.</q> <rj><qau>Decker.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The cloth whereon the earl dined was taken away, and the
<qex>voider</qex>, wherein the plate was usually put, was set upon the
cupboard's head.</q> <rj><qau>Hist. of Richard Hainam.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A servant whose business is to void, or clear away,
a table after a meal.</def> <mark>[R.]</mark>
<rj><au>Decker.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Her.)</fld> <def>One of the ordinaries, much like
the flanch, but less rounded and therefore smaller.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voiding</ent><br/
<hw>Void"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of one who, or
that which, voids.</def> <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is voided; that which is ejected or
evacuated; a remnant; a fragment.</def> <mark>[R.]</mark>
<rj><au>Rowe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Voiding knife</b></col>, <cd>a knife used for gathering
up fragments of food to put them into a voider.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voiding</ent><br/
<hw>Void"ing</hw>, <pos>a.</pos> <def>Receiving what is ejected or
voided.</def> <ldquo/How in our <xex>voiding</xex> lobby hast thou
stood?<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voidness</ent><br/
<hw>Void"ness</hw>, <pos>n.</pos> <def>The quality or state of being
void; emptiness; vacuity; nullity; want of substantiality.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voir dire</ent><br/
\'d8<hw>Voir dire</hw> <pr>(?)</pr>. <ety>[OF., to say the truth, fr. L.
<ets>verus</ets> true + <ets>dicere</ets> to say.]</ety>
<fld>(Law)</fld> <def>An oath administered to a witness, usually before
being sworn in chief, requiring him to speak the truth, or make true
answers in reference to matters inquired of, to ascertain his competency
to give evidence.</def> <rj><au>Greenleaf. Ld. Abinger.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voiture</ent><br/
<hw>Voi"ture</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L.
<ets>vectura</ets> a carrying, conveying. Cf. <er>Vettura</er>.]</ety>
<def>A carriage.</def> <rj><au>Arbuthnot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voivode</ent><br/
<hw>Voi"vode</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Waywode</er>.</def> <rj><au>Longfellow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volacious</ent><br/
<hw>Vo*la"cious</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>volare</ets> to fly.]</ety> <def>Apt or fit to fly.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volador</ent><br/
\'d8<hw>Vo*la*dor"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp.]</ety>
<fld>(Zool.)</fld> <sd>(a)</sd> <def>A flying fish of California
(<spn>Exoc<oe/tus Californicus</spn>): -- called also
<altname>volator</altname>.</def> <sd>(b)</sd> <def>The Atlantic flying
gurnard. See under <er>Flying</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volage</ent><br/
<hw>Vo*lage"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F.]</ety>
<def>Light; giddy.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>They wroughten all their lust <qex>volage</qex>.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volant</ent><br/
<hw>Vo"lant</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>volans</ets>, <ets>-antis</ets>, p. pr. of <ets>volare</ets> to
fly: cf. F. <ets>volant</ets>.]</ety> <sn>1.</sn> <def>Passing through
the air upon wings, or as if upon wings; flying; hence, passing from
place to place; current.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>English silver now was current, and our gold <qex>volant</qex> in
the pope's court.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Nimble; light and quick; active; rapid.</def>
<ldquo/His <xex>volant</xex> touch.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Her.)</fld> <def>Represented as flying, or having
the wings spread; <as>as, an eagle <ex>volant</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Volant piece</b></col> <fld>(Anc. Armor)</fld>, <cd>an
adjustable piece of armor, for guarding the throat, etc., in a
joust.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volante</ent><br/
\'d8<hw>Vo*lan"te</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp., prop.,
flying.]</ety> <def>A two-wheeled carriage formerly much used in Cuba.
The body is in front of the axle; the driver rides on the
horse.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Volapuk</ent><br/
<ent>Volapuek</ent><br/
<hw>Vol`a*p<uum/k"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Literally,
world's speech; the name of an artificial language invented by
<person>Johan Martin Schleyer</person>, of <city>Constance</city>,
<country>Switzerland</country>, about 1879. For more about
<ldquo/planned languages<rdquo/, see <er>Esperanto</er>.</def><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><ent>Volap<uum/kist</ent><br/
<hw>Vol`a*p<uum/k"ist</hw>, <pos>n.</pos> <def>One who is conversant
with, or who favors adoption of, Volap<uum/k.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volar</ent><br/
<hw>Vo"lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>vola</ets> the
palm of the hand, the sole of the foot.]</ety> <fld>(Anat.)</fld>
<def>Of or pertaining to the palm of the hand or the sole of the
foot.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volary</ent><br/
<hw>Vol"a*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See
<er>Volery</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volatile</ent><br/
<hw>Vol"a*tile</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F.
<ets>volatil</ets>, L. <ets>volatilis</ets>, fr. <ets>volare</ets> to
fly, perhaps akin to <ets>velox</ets> swift, E. <ets>velocity</ets>. Cf.
<er>Volley</er>.]</ety> <sn>1.</sn> <def>Passing through the air on
wings, or by the buoyant force of the atmosphere; flying; having the
power to fly.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Capable of wasting away, or of easily passing into
the aeriform state; subject to evaporation.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Substances which affect the smell with pungent or
fragrant odors, as musk, hartshorn, and essential oils, are called
<xex>volatile</xex> substances, because they waste away on exposure to
the atmosphere. Alcohol and ether are called <xex>volatile</xex> liquids
for a similar reason, and because they easily pass into the state of
vapor on the application of heat. On the contrary, gold is a
<xex>fixed</xex> substance, because it does not suffer waste, even when
exposed to the heat of a furnace; and oils are called <xex>fixed</xex>
when they do not evaporate on simple exposure to the
atmosphere.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Fig.: Light-hearted; easily affected by
circumstances; airy; lively; hence, changeable; fickle; <as>as, a
<ex>volatile</ex> temper</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>You are as giddy and <qex>volatile</qex> as ever.</q>
<rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Volatile alkali</b></col>. <fld>(Old Chem.)</fld> <cd>See
under <er>Alkali</er>.</cd> -- <col><b>Volatile liniment</b></col>,
<cd>a liniment composed of sweet oil and ammonia, so called from the
readiness with which the latter evaporates.</cd> -- <col><b>Volatile
oils</b></col>. <fld>(Chem.)</fld> <cd>See <cref>Essential oils</cref>,
under <er>Essential</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volatile</ent><br/
<hw>Vol"a*tile</hw>, <pos>n.</pos> <ety>[Cf. F.
<ets>volatile</ets>.]</ety> <def>A winged animal; wild fowl; game.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au> <au>Sir T.
Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volatility</ent><br/
<ent>Volatileness</ent><br/
<mhw>{<hw>Vol"a*tile*ness</hw>, <hw>Vol`a*til"i*ty</hw> <pr>(?)</pr>,
}</mhw> <pos>n.</pos> <ety>[Cf. F. <ets>volatilit<eacute/</ets>.]</ety>
<def>Quality or state of being volatile; disposition to evaporate;
changeableness; fickleness.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- See <er>Levity</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volatilizable</ent><br/
<hw>Vol"a*til*i`za*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>volatisable</ets>.]</ety> <def>Capable of being
volatilized.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volatilization</ent><br/
<hw>Vol`a*til*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>volatilisation</ets>.]</ety> <def>The act or process of
volatilizing, or rendering volatile; the state of being
volatilized.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volatilize</ent><br/
<hw>Vol"a*til*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Volatilized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Volatilizing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[Cf.
F. <ets>volatiliser</ets>.]</ety> <def>To render volatile; to cause to
exhale or evaporate; to cause to pass off in vapor.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The water . . . dissolving the oil, and <qex>volatilizing</qex> it
by the action.</q> <rj><qau>Sir I. Newton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volator</ent><br/
\'d8<hw>Vo*la"tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.]</ety>
<fld>(Zool.)</fld> <def>Same as <er>Volador</er>, 1.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vol-au-vent</ent><br/
\'d8<hw>Vol`-au`-vent"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<fld>(Cookery)</fld> <def>A light puff paste, with a raised border,
filled, after baking, usually with a ragout of fowl, game, or
fish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volborthite</ent><br/
<hw>Vol"borth*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So named after
<etsep>Volborth</etsep>, who first discovered it.]</ety>
<fld>(Min.)</fld> <def>A mineral occurring in small six-sided tabular
crystals of a green or yellow color. It is a hydrous vanadate of copper
and lime.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volcanian</ent><br/
<hw>Vol*ca"ni*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Volcanic.</def>
<mark>[R.]</mark> <rj><au>Keats.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volcanic</ent><br/
<hw>Vol*can"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>volcanique</ets>, It. <ets>vulcanico</ets>.]</ety> <sn>1.</sn>
<def>Of or pertaining to a volcano or volcanoes; <as>as,
<ex>volcanic</ex> heat</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Produced by a volcano, or, more generally, by
igneous agencies; <as>as, <ex>volcanic</ex> tufa</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Changed or affected by the heat of a
volcano.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Volcanic bomb</b></col>, <cd>a mass ejected from a
volcano, often of molten lava having a rounded form.</cd> --
<col><b>Volcanic cone</b></col>, <cd>a hill, conical in form, built up
of cinders, tufa, or lava, during volcanic eruptions.</cd> --
<col><b>Volcanic foci</b></col>, <cd>the subterranean centers of
volcanic action; the points beneath volcanoes where the causes producing
volcanic phenomena are most active.</cd> -- <col><b>Volcanic
glass</b></col>, <cd>the vitreous form of lava, produced by sudden
cooling; obsidian. See <er>Obsidian</er>.</cd> -- <col><b>Volcanic
mud</b></col>, <cd>fetid, sulphurous mud discharged by a volcano.</cd>
-- <col><b>Volcanic rocks</b></col>, <cd>rocks which have been produced
from the discharges of volcanic matter, as the various kinds of basalt,
trachyte, scoria, obsidian, etc., whether compact, scoriaceous, or
vitreous.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volcanically</ent><br/
<hw>Vol*can"ic*al*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>Like a
volcano.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volcanicity</ent><br/
<hw>Vol`can*ic"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>volcanicit<eacute/</ets>.]</ety> <def>Quality or state of being
volcanic; volcanic power.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volcanic neck</ent><br/
<hw>Vol*can"ic neck</hw>. <fld>(Geol.)</fld> <def>A column of igneous
rock formed by congelation of lava in the conduit of a volcano and later
exposed by the removal of surrounding rocks.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Volcanic wind</ent><br/
<hw>Volcanic wind</hw>. <fld>(Meteorol.)</fld> <def>A wind associated
with a volcanic outburst and due to the eruption or to convection
currents over hot lava.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Volcanism</ent><br/
<hw>Vol"can*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Volcanic power or
action; volcanicity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volcanist</ent><br/
<hw>Vol"can*ist</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>volcaniste</ets>,
<ets>vulcaniste</ets>.]</ety> <sn>1.</sn> <def>One versed in the history
and phenomena of volcanoes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who believes in the igneous, as opposed to the
aqueous, origin of the rocks of the earth's crust; a vulcanist. Cf.
<er>Neptunist</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volcanity</ent><br/
<hw>Vol*can"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Volcanic</er>, and <er>Volcanicity</er>.]</ety> <def>The quality or
state of being volcanic, or volcanic origin; volcanicity.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volcanization</ent><br/
<hw>Vol`can*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of
volcanizing, or the state of being volcanized; the process of undergoing
volcanic heat, and being affected by it.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volcanize</ent><br/
<hw>Vol"can*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Volcanized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Volcanizing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[Cf.
<er>Vulcanize</er>.]</ety> <def>To subject to, or cause to undergo,
volcanic heat, and to be affected by its action.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volcano</ent><br/
<hw>Vol*ca"no</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Volcanoes</plw> <pr>(#)</pr>.</plu> <ety>[It. <ets>volcano</ets>,
<ets>vulcano</ets>, fr. L. <ets>Vulcanus</ets> Vulkan, the god of fire.
See <er>Vulkan</er>.]</ety> <fld>(Geol.)</fld> <def>A mountain or hill,
usually more or less conical in form, from which lava, cinders, steam,
sulphur gases, and the like, are ejected; -- often popularly called a
<altname>burning mountain</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Volcanoes include many of the most conspicuous and lofty
mountains of the earth, as Mt. Vesuvius in Italy (4,000 ft. high), Mt.
Loa in Hawaii (14,000 ft.), Cotopaxi in South America (nearly 20,000
ft.), which are examples of active volcanoes. The crater of a volcano is
usually a pit-shaped cavity, often of great size. The summit crater of
Mt. Loa has a maximum length of 13,000 ft., and a depth of nearly 800
feet. Beside the chief crater, a volcano may have a number of
subordinate craters.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vole</ent><br/
<hw>Vole</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A deal at
cards that draws all the tricks.</def> <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vole</ent><br/
<hw>Vole</hw>, <pos>v. i.</pos> <fld>(Card Playing)</fld> <def>To win
all the tricks by a vole.</def> <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vole</ent><br/
<hw>Vole</hw>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Any one of numerous
species of micelike rodents belonging to <gen>Arvicola</gen> and allied
genera of the subfamily <fam>Arvicolinae</fam>. They have a thick head,
short ears, and a short hairy tail.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The water vole, or water rat, of Europe (<spn>Arvicola
amphibius</spn>) is a common large aquatic species. The short-tailed
field vole (<spn>Arvicola agrestis</spn>) of Northern and Central
Europe, and Asia, the Southern field vole (<spn>Arvicola arvalis</spn>),
and the Siberian root vole (<spn>Arvicola oeconomus</spn>), are
important European species. The common species of the Eastern United
States (<spn>Arvicola riparius</spn>) (called also <stype>meadow
mouse</stype>) and the prairie mouse (<spn>Arvicola austerus</spn>) are
abundant, and often injurious to vegetation. Other species are found in
Canada.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volery</ent><br/
<hw>Vol"er*y</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>volerie</ets> a flying, <ets>voli<egrave/re</ets> a large bird
cage, fr. <ets>voler</ets> to fly, L. <ets>volare</ets>. See
<er>Volatile</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A flight of birds.</def> <mark>[R.]</mark>
<rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A large bird cage; an aviary.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volge</ent><br/
<hw>Volge</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vulgus</ets>.]</ety> <def>The common sort of people; the crowd; the
mob.</def> <mark>[Obs.]</mark> <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volitable</ent><br/
<hw>Vol"i*ta*ble</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Volatilizable.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volitation</ent><br/
<hw>Vol`i*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>volitare</ets>, <ets>volitatum</ets>, to fly to and fro, v. freq.
from <ets>volare</ets> to fly.]</ety> <def>The act of flying;
flight.</def> <mark>[R.]</mark> <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volitient</ent><br/
<hw>Vo*li"tient</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Volition</er>.]</ety> <def>Exercising the will; acting from choice;
willing, or having power to will.</def> <ldquo/What I do, I do
<xex>volitient</xex>, not obedient.<rdquo/ <rj><au>Mrs.
Browning.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volition</ent><br/
<hw>Vo*li"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L.
<ets>volo</ets> I will, <ets>velle</ets> to will, be willing. See
<er>Voluntary</er>.]</ety> <sn>1.</sn> <def>The act of willing or
choosing; the act of forming a purpose; the exercise of the
will.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Volition</qex> is the actual exercise of the power the mind
has to order the consideration of any idea, or the forbearing to
consider it.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Volition</qex> is an act of the mind, knowingly exerting that
dominion it takes itself to have over any part of the man, by employing
it in, or withholding it from, any particular action.</q>
<rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The result of an act or exercise of choosing or
willing; a state of choice.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The power of willing or determining; will.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Will; choice; preference; determination;
purpose.</syn> <usage> -- <er>Volition</er>, <er>Choice</er>.
<xex>Choice</xex> is the familiar, and <xex>volition</xex> the
scientific, term for the same state of the will; <xex>viz.</xex>, an
<ldquo/elective preference.<rdquo/ When we have <ldquo/made up our
minds<rdquo/ (as we say) to a thing, <it>i. e.</it>, have a settled
state of choice respecting it, that state is called an <xex>immanent
volition</xex>; when we put forth any particular act of choice, that act
is called an <xex>emanent</xex>, or <xex>executive</xex>, or
<xex>imperative</xex>, volition. When an <xex>immanent</xex>, or settled
state of, choice, is one which controls or governs a series of actions,
we call that state a <xex>predominant</xex> volition; while we give the
name of <xex>subordinate</xex> volitions to those particular acts of
choice which carry into effect the object sought for by the governing or
<ldquo/predominant volition.<rdquo/ See <er>Will</er>.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volitional</ent><br/
<hw>Vo*li"tion*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Belonging or
relating to volition.</def> <ldquo/The <xex>volitional</xex>
impulse.<rdquo/ <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volitive</ent><br/
<hw>Vol"i*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See
<er>Volition</er>.]</ety> <sn>1.</sn> <def>Of or pertaining to the will;
originating in the will; having the power to will.</def> <ldquo/They not
only perfect the intellectual faculty, but the
<xex>volitive</xex>.<rdquo/ <rj><au>Sir M. Hale.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Gram.)</fld> <def>Used in expressing a wish or
permission as, <xex>volitive</xex> proposition.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volkslied</ent><br/
\'d8<hw>Volks"lied</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Volkslieder</plw> <pr>(#)</pr>.</plu> <ety>[G.]</ety>
<fld>(Mus.)</fld> <def>A popular song, or national air.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volksraad</ent><br/
\'d8<hw>Volks"raad`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[D.]</ety>
<def>A legislative assembly or parliament of any one of several
countries colonized by the Dutch, esp. that of the South African
Republic, or the Transvaal, and that of the Orange Free State.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Volley</ent><br/
<hw>Vol"ley</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Volleys</plw> <pr>(#)</pr>.</plu> <ety>[F. <ets>vol<eacute/e</ets>;
flight, a volley, or discharge of several guns, fr. <ets>voler</ets> to
fly, L. <ets>volare</ets>. See <er>Volatile</er>.]</ety> <sn>1.</sn>
<def>A flight of missiles, as arrows, bullets, or the like; the
simultaneous discharge of a number of small arms.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Fiery darts in flaming <qex>volleys</qex> flew.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Each <qex>volley</qex> tells that thousands cease to breathe.</q>
<rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A burst or emission of many things at once; <as>as,
a <ex>volley</ex> of words</as>.</def> <ldquo/This <xex>volley</xex> of
oaths.<rdquo/ <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Rattling nonsense in full <qex>volleys</qex> breaks.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <sd>(a)</sd> <fld>(Tennis)</fld> <def>A return of the
ball before it touches the ground.</def> <sd>(b)</sd>
<fld>(Cricket)</fld> <def>A sending of the ball full to the top of the
wicket.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1618 --><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Half volley</b></col>. <sd>(a)</sd> <fld>(Tennis)</fld>
<cd>A return of the ball immediately after is has touched the
ground.</cd> <sd>(b)</sd> <fld>(Cricket)</fld> <cd>A sending of the ball
so that after touching the ground it flies towards the top of the
wicket.</cd> <au>R. A. Proctor.</au> -- <col><b>On the volley</b></col>,
<cd>at random.</cd> <mark>[Obs.]</mark> <ldquo/What we spake <xex>on the
volley</xex> begins work.<rdquo/ <au>Massinger.</au> -- <col><b>Volley
gun</b></col>, <cd>a gun with several barrels for firing a number of
shots simultaneously; a kind of mitrailleuse.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volley</ent><br/
<hw>Vol"ley</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Volleyed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Volleying</conjf>.]</vmorph> <def>To discharge with, or
as with, a volley.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volley</ent><br/
<hw>Vol"ley</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To be thrown out, or
discharged, at once; to be discharged in a volley, or as if in a volley;
to make a volley or volleys.</def> <rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <sd>(a)</sd> <fld>(Tennis)</fld> <def>To return the ball
before it touches the ground.</def> <sd>(b)</sd> <sd>(Cricket)</sd>
<def>To send the ball full to the top of the wicket.</def> <rj><au>R. A.
Proctor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volley ball</ent><br/
<hw>Vol"ley ball</hw>. <def>A game played by volleying a large inflated
ball with the hands over a net 7 ft. 6 in. high.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Volleyed</ent><br/
<hw>Vol"leyed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Discharged with a
sudden burst, or as if in a volley; <as>as, <ex>volleyed</ex>
thunder</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volost</ent><br/
<hw>Vo"lost</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Russ.
<ets>volost'</ets>.]</ety> <def>In the greater part of Russia, a
division for local government consisting of a group of mirs, or village
communities; a canton.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Volow</ent><br/
<hw>Vol"ow</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[From the answer,
<ets>Volo</ets> I will, in the baptismal service. <au>Richardson
(Dict.).</au>]</ety> <def>To baptize; -- used in contempt by the
Reformers.</def> <mark>[Obs.]</mark> <rj><au>Tyndale.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volplane</ent><br/
<hw>Vol"plane`</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[F. <ets>vol
plan<eacute/</ets> act of volplaning; <ets>vol</ets> flight +
<ets>plan<eacute/</ets>, p.p.; cf. <ets>planer</ets> to hover.]</ety>
<fld>(Aeronautics)</fld> <def>To glide in a flying machine.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Volt</ent><br/
<hw>Volt</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>volte</ets>; cf.
It. <ets>volta</ets>. See <er>Vault</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Man.)</fld> <def>A circular tread; a gait by which
a horse going sideways round a center makes two concentric
tracks.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Fencing)</fld> <def>A sudden movement to avoid a
thrust.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volt</ent><br/
<hw>Volt</hw>, <pos>n.</pos> <ety>[After Alessandro <ets>Volta</ets>,
the Italian electrician.]</ety> <fld>(Elec.)</fld> <def>The unit of
electro-motive force; -- defined by the International Electrical
Congress in 1893 and by United States Statute as, that electro-motive
force which steadily applied to a conductor whose resistance is one ohm
will produce a current of one amp<egrave/re. It is practically
equivalent to <frac1000x1434/ the electro-motive force of a standard
Clark's cell at a temperature of 15<deg/ C.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volta</ent><br/
\'d8<hw>Vol"ta</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Volte</plw> <pr>(#)</pr>.</plu> <ety>[It. <ets>volta</ets> a turn,
turning, a time. See <er>Volt</er> a tread.]</ety> <fld>(Mus.)</fld>
<def>A turning; a time; -- chiefly used in phrases signifying that the
part is to be repeated one, two, or more times; <as>as, <ex>una
volta</ex>, once. <ex>Seconda volta</ex>, second time, points to certain
modifications in the close of a repeated strain.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volta-electric</ent><br/
<hw>Vol"ta-e*lec"tric</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or
pertaining to voltaic electricity, or voltaism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volta-electrometer</ent><br/
<hw>Vol`ta-e`lec*trom"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An
instrument for the exact measurement of electric currents.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltage</ent><br/
<hw>Vol"tage</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Elec.)</fld>
<def>Electric potential or potential difference, expressed in
volts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltagraphy</ent><br/
<hw>Vol*tag"ra*phy</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Volta</ets>ic + <ets>-graphy</ets>.]</ety> <def>In
electrotypy, the act or art of copying, in metals deposited by
electrolytic action, a form or pattern which is made the negative
electrode.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltaic</ent><br/
<hw>Vol*ta"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>volta<ium/que</ets>, It. <ets>voltaico</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Of or pertaining to Alessandro <ets>Volta</ets>, who
first devised apparatus for developing electric currents by chemical
action, and established this branch of electric science; discovered by
<ets>Volta</ets>; <as>as, <ex>voltaic</ex> electricity</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to voltaism, or voltaic
electricity; <as>as, <ex>voltaic</ex> induction; the <ex>voltaic</ex>
arc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ See the Note under <er>Galvanism</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Voltaic arc</b></col>, <cd>a luminous arc, of intense
brilliancy, formed between carbon points as electrodes by the passage of
a powerful voltaic current.</cd> -- <col><b>Voltaic battery</b></col>,
<cd>an apparatus variously constructed, consisting of a series of plates
or pieces of dissimilar metals, as copper and zinc, arranged in pairs,
and subjected to the action of a saline or acid solution, by which a
current of electricity is generated whenever the two poles, or ends of
the series, are connected by a conductor; a galvanic battery. See
<er>Battery</er>, 4. <sd>(b)</sd>, and Note.</cd> -- <col><b>Voltaic
circuit</b></col>. <cd>See under <er>Circuit</er>.</cd> --
<mcol><col><b>Voltaic couple</b></col> <it>or</it> <col><b>Voltaic
element</b></col></mcol>, <cd>a single pair of the connected plates of a
battery.</cd> -- <col><b>Voltaic electricity</b></col>. <cd>See the Note
under <er>Electricity</er>.</cd> -- <col><b>Voltaic pile</b></col>,
<cd>a kind of voltaic battery consisting of alternate disks of
dissimilar metals, separated by moistened cloth or paper. See 5th
<er>Pile</er>.</cd> -- <col><b>Voltaic protection of metals</b></col>,
<cd>the protection of a metal exposed to the corrosive action of sea
water, saline or acid liquids, or the like, by associating it with a
metal which is positive to it, as when iron is galvanized, or coated
with zinc.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltairean</ent><br/
<hw>Vol*tair"e*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>voltairien</ets>.]</ety> <def>Of or relating to
<ets>Voltaire</ets>, the French author.</def> <rj><au>J.
Morley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltairism</ent><br/
<hw>Vol*tair"ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The theories or
practice of Voltaire.</def> <rj><au>J. Morley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltaism</ent><br/
<hw>Vol"ta*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>volta<ium/sme</ets>.]</ety> <fld>(Physics)</fld> <def>That form of
electricity which is developed by the chemical action between metals and
different liquids; voltaic electricity; also, the science which treats
of this form of electricity; -- called also
<altname>galvanism</altname>, from <ets>Galvani</ets>, on account of his
experiments showing the remarkable influence of this agent on
animals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltameter</ent><br/
<hw>Vol*tam"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Volta</ets>ic + <ets>-meter</ets>.]</ety>
<fld>(Physics)</fld> <def>An instrument for measuring the voltaic
electricity passing through it, by its effect in decomposing water or
some other chemical compound acting as an electrolyte.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltammeter</ent><br/
<hw>Volt*am"me`ter</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A
wattmeter.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Volt ampere</ent><br/
<ent>Volt-amp</ent><br/
<hw>Volt amp<egrave/re</hw>. <fld>(Elec.)</fld> <def>A unit of electric
measurement equal to the product of a volt and an ampere. For direct
current it is a measure of power and is the same as a watt; for
alternating current it is a measure of apparent power.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Voltaplast</ent><br/
<hw>Vol"ta*plast</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Volta</ets>ic + Gr. <?/ molded.]</ety> <def>A form of
voltaic, or galvanic, battery suitable for use electrotyping.</def>
<rj><au>G. Francis.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltatype</ent><br/
<hw>Vol"ta*type</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Volta</ets>ic + <ets>type</ets>.]</ety> <def>An
electrotype.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volti</ent><br/
\'d8<hw>Vol"ti</hw> <pr>(?)</pr>, <pos>imperative.</pos> <ety>[It., fr.
<ets>voltare</ets> to turn. See <er>Volt</er> a tread.]</ety>
<fld>(Mus.)</fld> <def>Turn, that is, turn over the leaf.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Volti subito</b></col> <ety>[It.]</ety>
<fld>(Mus.)</fld>, <cd>turn over quickly.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltigeur</ent><br/
\'d8<hw>Vol`ti*geur</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr.
<ets>voltiger</ets> to vault, It. <ets>volteggiare</ets>. See
<er>Volt</er> a tread.]</ety> <sn>1.</sn> <def>A tumbler; a leaper or
vaulter.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mil.)</fld> <def>One of a picked company of
irregular riflemen in each regiment of the French infantry.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltmeter</ent><br/
<hw>Volt"me`ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[2d
<ets>volt</ets> + <ets>-meter</ets>.]</ety> <fld>(elec.)</fld> <def>An
instrument for measuring in volts the differences of potential between
different points of an electrical circuit.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voltzite</ent><br/
<hw>Voltz"ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So named in honor
of <etsep>Voltz</etsep>, a French engineer.]</ety> <fld>(Min.)</fld>
<def>An oxysulphide of lead occurring in implanted spherical globules of
a yellowish or brownish color; -- called also
<altname>voltzine</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volubile</ent><br/
<ent>Volubilate</ent><br/
<mhw>{ <hw>Vo*lu"bi*late</hw> <pr>(?)</pr>, <hw>Vol"u*bile</hw>
<pr>(?)</pr>},</mhw> <pos>a.</pos> <ety>[See <er>Voluble</er>.]</ety>
<def>Turning, or whirling; winding; twining; voluble.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volubility</ent><br/
<hw>Vol`u*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>volubilitas</ets>: cf. F. <ets>volubilit<eacute/</ets>.]</ety>
<def>The quality or state of being voluble (in any of the senses of the
adjective).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluble</ent><br/
<hw>Vol"u*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>volubilis</ets>, fr. <ets>volvere</ets>, <ets>volutum</ets>, to
roll, to turn round; akin to Gr. <?/ to infold, to inwrap, <?/ to roll,
G. <ets>welle</ets> a wave: cf. F. <ets>voluble</ets>. Cf. F.
<er>Well</er> of water, <er>Convolvulus</er>, <er>Devolve</er>,
<er>Involve</er>, <er>Revolt</er>, <er>Vault</er> an arch,
<er>Volume</er>, <er>Volute</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Easily rolling or turning; easily set in motion; apt
to roll; rotating; <as>as, <ex>voluble</ex> particles of
matter</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Moving with ease and smoothness in uttering words;
of rapid speech; nimble in speaking; glib; <as>as, a flippant,
<ex>voluble</ex>, tongue</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[Cassio,] a knave very <qex>voluble</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Voluble</xex> was used formerly to indicate
readiness of speech merely, without any derogatory suggestion. <ldquo/A
grave and <xex>voluble</xex> eloquence.<rdquo/</note> <rj><au>Bp.
Hacket.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Changeable; unstable; fickle.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Bot.)</fld> <def>Having the power or habit of
turning or twining; <as>as, the <ex>voluble</ex> stem of hop
plants</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Voluble stem</b></col> <fld>(Bot.)</fld>, <cd>a stem that
climbs by winding, or twining, round another body.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vol"u*ble*ness</wf>, <pos>n.</pos> --
<wf>Vol"u*bly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volume</ent><br/
<hw>Vol"ume</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., from L.
<ets>volumen</ets> a roll of writing, a book, volume, from
<ets>volvere</ets>, <ets>volutum</ets>, to roll. See
<er>Voluble</er>.]</ety> <sn>1.</sn> <def>A roll; a scroll; a written
document rolled up for keeping or for use, after the manner of the
ancients.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The papyrus, and afterward the parchment, was joined together [by
the ancients] to form one sheet, and then rolled upon a staff into a
<qex>volume</qex> (<qex>volumen</qex>).</q> <rj><qau>Encyc.
Brit.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, a collection of printed sheets bound
together, whether containing a single work, or a part of a work, or more
than one work; a book; a tome; especially, that part of an extended work
which is bound up together in one cover; <as>as, a work in four
<ex>volumes</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>An odd <qex>volume</qex> of a set of books bears not the value of
its proportion to the set.</q> <rj><qau>Franklin.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Anything of a rounded or swelling form resembling a
roll; a turn; a convolution; a coil.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>So glides some trodden serpent on the grass,<br/
And long behind wounded <qex>volume</qex> trails.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Undulating billows rolling their silver <qex>volumes</qex>.</q>
<rj><qau>W. Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Dimensions; compass; space occupied, as measured by
cubic units, that is, cubic inches, feet, yards, etc.; mass; bulk;
<as>as, the <ex>volume</ex> of an elephant's body; a <ex>volume</ex> of
gas</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Mus.)</fld> <def>Amount, fullness, quantity, or
caliber of voice or tone.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Atomic volume</b></col>, <col><b>Molecular
volume</b></col></mcol> <fld>(Chem.)</fld>, <cd>the ratio of the atomic
and molecular weights divided respectively by the specific gravity of
the substance in question.</cd> -- <col><b>Specific volume</b></col>
<fld>(Physics & Chem.)</fld>, <cd>the quotient obtained by dividing
unity by the specific gravity; the reciprocal of the specific gravity.
It is equal (when the specific gravity is referred to water at 4<deg/ C.
as a standard) to the number of cubic centimeters occupied by one gram
of the substance.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volumed</ent><br/
<hw>Vol"umed</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Having
the form of a volume, or roil; <as>as, <ex>volumed</ex>
mist</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The distant torrent's rushing sound<br/
Tells where the <qex>volumed</qex> cataract doth roll.</q>
<rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Having volume, or bulk; massive; great.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volumenometer</ent><br/
<hw>Vol`u*me*nom"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>volumen</ets> volume + <ets>-meter</ets>.]</ety>
<fld>(Physics)</fld> <def>An instrument for measuring the volume of a
body, especially a solid, by means of the difference in tension caused
by its presence and absence in a confined portion of air.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volumenometry</ent><br/
<hw>Vol`u*me*nom"e*try</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem. &
Physics)</fld> <def>The method or process of measuring volumes by means
of the volumenometer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volumescope</ent><br/
<hw>Vo*lu"me*scope</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[<ets>Volume</ets> + <ets>-scope</ets>.]</ety> <fld>(Physics)</fld>
<def>An instrument consisting essentially of a glass tube provided with
a graduated scale, for exhibiting to the eye the changes of volume of a
gas or gaseous mixture resulting from chemical action, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volumeter</ent><br/
<hw>Vo*lu"me*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>volum<egrave/tre</ets>. See <er>Volumetric</er>.]</ety>
<fld>(Physics)</fld> <def>An instrument for measuring the volumes of
gases or liquids by introducing them into a vessel of known
capacity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volumetric</ent><br/
<hw>Vol`u*met"ric</hw> <pr>(?)</pr>, <pos>a.</pos>
<ety>[<ets>Volume</ets> + <ets>-metric</ets>.]</ety> <def>Of or
pertaining to the measurement of volume.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Volumetric analysis</b></col> <fld>(Chem.)</fld>,
<cd>that system of the quantitative analysis of solutions which employs
definite volumes of standardized solutions of reagents, as measured by
burettes, pipettes, etc.; also, the analysis of gases by volume, as by
the eudiometer.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volumetrical</ent><br/
<hw>Vol`u*met"ric*al</hw> <pr>(?)</pr>, <pos>a.</pos>
<def>Volumetric.</def> -- <wordforms><wf>Vol`u*met"ric*al*ly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluminous</ent><br/
<hw>Vo*lu"mi*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>voluminosus</ets>: cf. F. <ets>volumineux</ets>.]</ety> <def>Of or
pertaining to volume or volumes.</def> Specifically: --<br/
[<source>1913 Webster</source>]</p>

<p><sd>(a)</sd> <def>Consisting of many folds, coils, or
convolutions.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>But ended foul in many a scaly fold,<br/
<qex>Voluminous</qex> and vast.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Over which dusky draperies are hanging, and <qex>voluminous</qex>
curtains have long since fallen.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>Of great volume, or bulk; large.</def> <rj><au>B.
Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> Consisting of many volumes or books; as, the collections
of Muratori are <xex>voluminous</xex>.<br/
[<source>1913 Webster</source>]</p>

<p><sd>(d)</sd> <def>Having written much, or produced many volumes;
copious; diffuse; <as>as, a <ex>voluminous</ex> writer</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vo*lu"mi*nous*ly</wf>, <pos>adv.</pos> --
<wf>Vo*lu"mi*nous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volumist</ent><br/
<hw>Vol"u*mist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who writes a
volume; an author.</def> <mark>[Obs.]</mark>
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluntarily</ent><br/
<hw>Vol"un*ta*ri*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a
voluntary manner; of one's own will; spontaneously.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluntariness</ent><br/
<hw>Vol"un*ta*ri*ness</hw>, <pos>n.</pos> <def>The quality or state of
being voluntary; spontaneousness; specifically, the quality or state of
being free in the exercise of one's will.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluntarism</ent><br/
<hw>Vol"un*ta*rism</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn>
<fld>(Philosophy)</fld> <def>Any theory which conceives will to be the
dominant factor in experience or in the constitution of the world; --
contrasted with <contr>intellectualism</contr>.
<persfn>Schopenhauer</persfn> and <persfn>Fichte</persfn> are typical
exponents of the two types of metaphysical voluntarism,
<persfn>Schopenhauer</persfn> teaching that the evolution of the
universe is the activity of a blind and irrational will,
<persfn>Fichte</persfn> holding that the intelligent activity of the ego
is the fundamental fact of reality.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>The principle or practice of depending on volunteers
to support institutions or perform some desired action.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>A political philosophy opposed to dependence on
governmental action or support for social services that might be
performed by private groups.</def><br/
[<source>PJC</source>]</p>

<p><ent>Voluntary</ent><br/
<hw>Vol"un*ta*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>voluntarius</ets>, fr. <ets>voluntas</ets> will, choice, from the
root of <ets>velle</ets> to will, p. pr. <ets>volens</ets>; akin to E.
<ets>will</ets>: cf. F. <ets>volontaire</ets>, Of. also
<ets>voluntaire</ets>. See <er>Will</er>, <pos>v. t.</pos>, and cf.
<er>Benevolent</er>, <er>Volition</er>, <er>Volunteer</er>.]</ety>
<sn>1.</sn> <def>Proceeding from the will; produced in or by an act of
choice.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That sin or guilt pertains exclusively to <qex>voluntary</qex>
action is the true principle of orthodoxy.</q> <rj><qau>N. W.
Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Unconstrained by the interference of another;
unimpelled by the influence of another; not prompted or persuaded by
another; done of his or its own accord; spontaneous; acting of one's
self, or of itself; free.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Our <qex>voluntary</qex> service he requires.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>She fell to lust a <qex>voluntary</qex> prey.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Done by design or intention; intentional; purposed;
intended; not accidental; <as>as, if a man kills another by lopping a
tree, it is not <ex>voluntary</ex> manslaughter</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Physiol.)</fld> <def>Of or pertaining to the will;
subject to, or regulated by, the will; <as>as, the <ex>voluntary</ex>
motions of an animal, such as the movements of the leg or arm (in
distinction from <ex>involuntary</ex> motions, such as the movements of
the heart); the <ex>voluntary</ex> muscle fibers, which are the agents
in voluntary motion</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Endowed with the power of willing; <as>as, man is a
<ex>voluntary</ex> agent</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>God did not work as a necessary, but a <qex>voluntary</qex>,
agent, intending beforehand, and decreeing with himself, that which did
outwardly proceed from him.</q> <rj><qau>Hooker.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Law)</fld> <def>Free; without compulsion; according
to the will, consent, or agreement, of a party; without consideration;
gratuitous; without valuable consideration.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Eccl.)</fld> <def>Of or pertaining to voluntarism;
<as>as, a <ex>voluntary</ex> church, in distinction from an established
or state church</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Voluntary affidavit</b></col> <it>or</it>
<col><b>Voluntary oath</b></col></mcol> <fld>(Law)</fld>, <cd>an
affidavit or oath made in an extrajudicial matter.</cd> --
<col><b>Voluntary conveyance</b></col> <fld>(Law)</fld>, <cd>a
conveyance without valuable consideration.</cd> -- <col><b>Voluntary
escape</b></col> <fld>(Law)</fld>, <cd>the escape of a prisoner by the
express consent of the sheriff.</cd> -- <col><b>Voluntary
jurisdiction</b></col>. <fld>(Eng. Eccl. Law)</fld> <cd>See
<cref>Contentious jurisdiction</cref>, under <er>Contentious</er>.</cd>
-- <col><b>Voluntary waste</b></col>. <fld>(Law)</fld> <cd>See
<er>Waste</er>, <pos>n.</pos>, 4.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- See <er>Spontaneous</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluntary</ent><br/
<hw>Vol"un*ta*ry</hw>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Voluntaries</plw> <pr>(<?/)</pr>.</plu> <sn>1.</sn> <def>One who
engages in any affair of his own free will; a volunteer.</def>
<mark>[R.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>A piece played by a musician,
often extemporarily, according to his fancy; specifically, an organ solo
played before, during, or after divine service.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Eccl.)</fld> <def>One who advocates
voluntarism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluntaryism</ent><br/
<hw>Vol"un*ta*ry*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Eccl.)</fld>
<def>The principle of supporting a religious system and its institutions
by voluntary association and effort, rather than by the aid or patronage
of the state.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volunteer</ent><br/
<hw>Vol`un*teer"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>volontaire</ets>. See <er>Voluntary</er>, <pos>a.</pos>]</ety>
<sn>1.</sn> <def>One who enters into, or offers for, any service of his
own free will.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mil.)</fld> <def>One who enters into service
voluntarily, but who, when in service, is subject to discipline and
regulations like other soldiers; -- opposed to <contr>conscript</contr>;
specifically, a voluntary member of the organized militia of a country
as distinguished from the standing army.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Law)</fld> <def>A grantee in a voluntary
conveyance; one to whom a conveyance is made without valuable
consideration; a party, other than a wife or child of the grantor, to
whom, or for whose benefit, a voluntary conveyance is made.</def>
<rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A plant, especially a flowering plant in a garden,
that appears spontaneously without having been intentionally
planted.</def><br/
[<source>RDH</source>]</p>

<p><ent>Volunteer</ent><br/
<hw>Vol`un*teer"</hw>, <pos>a.</pos> <def>Of or pertaining to a
volunteer or volunteers; consisting of volunteers; voluntary; <as>as,
<ex>volunteer</ex> companies; <ex>volunteer</ex> advice.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volunteer</ent><br/
<hw>Vol`un*teer"</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Volunteered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Volunteering</conjf>.]</vmorph> <def>To offer or bestow
voluntarily, or without solicitation or compulsion; <as>as, to
<ex>volunteer</ex> one's services</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volunteer</ent><br/
<hw>Vol`un*teer"</hw>, <pos>v. i.</pos> <def>To enter into, or offer
for, any service of one's own free will, without solicitation or
compulsion; <as>as, he <ex>volunteered</ex> in that
undertaking</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volunteer navy</ent><br/
<hw>Vol`un*teer" na"vy</hw>. <def>A navy of vessels fitted out and
manned by volunteers who sail under the flag of the regular navy and
subject to naval discipline. Prussia in 1870, in the Franco-German war,
organized such a navy, which was commanded by merchant seamen with
temporary commissions, with the claim (in which England acquiesced) that
it did not come within the meaning of the term
<xex>privateer</xex>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Volunteers of America</ent><br/
<hw>Vol`un*teers" of America</hw>. <def>A religious and philanthropic
organization, similar to the Salvation Army, founded (1896) by Commander
and Mrs. Ballington Booth.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Volunteer State</ent><br/
<hw>Volunteer State</hw>. <def>Tennessee; -- a nickname.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Volupere</ent><br/
<hw>Vol"u*pere</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Envelop</er>.]</ety> <def>A woman's cap.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluptuary</ent><br/
<hw>Vo*lup"tu*a*ry</hw> <pr>(?; 135)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Voluptuaries</plw> <pr>(#)</pr>.</plu> <ety>[L.
<ets>voluptuarius</ets> or <ets>voluptarius</ets>, fr.
<ets>voluptas</ets> pleasure.]</ety> <def>A voluptuous person; one who
makes his physical enjoyment his chief care; one addicted to luxury, and
the gratification of sensual appetites.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A good-humored, but hard-hearted, <qex>voluptuary</qex>.</q>
<rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Sensualist; epicure.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluptuary</ent><br/
<hw>Vo*lup"tu*a*ry</hw>, <pos>a.</pos> <def>Voluptuous;
luxurious.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluptuous</ent><br/
<hw>Vo*lup"tu*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F.
<ets>voluptueux</ets>, L. <ets>voluptuosus</ets>, fr.
<ets>voluptas</ets> pleasure, <ets>volup</ets> agreeably, delightfully;
probably akin to Gr. <?/ to hope, <?/ hope, and to L. <ets>velle</ets>
to wish. See <er>Voluntary</er>.]</ety> <sn>1.</sn> <def>Full of delight
or pleasure, especially that of the senses; ministering to sensuous or
sensual gratification; exciting sensual desires; luxurious;
sensual.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Music arose with its <qex>voluptuous</qex> swell.</q>
<rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Sink back into your <qex>voluptuous</qex> repose.</q> <rj><qau>De
Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Given to the enjoyments of luxury and pleasure;
indulging to excess in sensual gratifications.</def> <ldquo/The jolly
and <xex>voluptuous</xex> livers.<rdquo/
<rj><au>Atterbury.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Softened with pleasure and <qex>voluptuous</qex> life.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vo*lup"tu*ous*ly</wf>, <pos>adv.</pos> --
<wf>Vo*lup"tu*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1619 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volupty</ent><br/
<hw>Vo*lup"ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>volupt<eacute/</ets> pleasure. See <er>Voluptuous</er>.]</ety>
<def>Voluptuousness.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluta</ent><br/
<hw>Vo*lu"ta</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> E.
<plw>Volutas</plw> <pr>(#)</pr>, L. <plw>Volutae</plw>
<pr>(#)</pr>.</plu> <ety>[L., a spiral scroll. See
<er>Volute</er>.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous
species of large, handsome marine gastropods belonging to
<gen>Voluta</gen> and allied genera.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volutation</ent><br/
<hw>Vol`u*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>volutatio</ets>, from <ets>volutare</ets> to roll, wallow, verb
freq. <ets>volvere</ets>, <ets>volutum</ets>, to roll.]</ety> <def>A
rolling of a body; a wallowing.</def> <mark>[R.]</mark> <rj><au>Sir T.
Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volute</ent><br/
<hw>Vo*lute"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>volute</ets>
(cf. It. <ets>voluta</ets>), L. <ets>voluta</ets>, from
<ets>volvere</ets>, <ets>volutum</ets>, to roll. See
<er>Voluble</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Arch.)</fld> <def>A spiral scroll which forms the
chief feature of the Ionic capital, and which, on a much smaller scale,
is a feature in the Corinthian and Composite capitals. See
<xex>Illust.</xex> of <er>Capital</er>, also <er>Helix</er>, and
<er>Stale</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A spiral turn, as in certain
shells.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>Any voluta.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Volute spiring</b></col>, <cd>a spring formed of a spiral
scroll of plate, rod, or wire, extended or extensible in the direction
of the axis of the coil, in which direction its elastic force is exerted
and employed.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voluted</ent><br/
<hw>Vo*lut"ed</hw>, <pos>a.</pos> <def>Having a volute, or spiral
scroll.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volution</ent><br/
<hw>Vo*lu"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. LL.
<ets>volutio</ets> an arch, vault.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A spiral turn or wreath.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A whorl of a spiral
shell.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volva</ent><br/
\'d8<hw>Vol"va</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>volva</ets>, <ets>vulva</ets>, covering.]</ety> <fld>(Bot.)</fld>
<def>A saclike envelope of certain fungi, which bursts open as the plant
develops.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volvox</ent><br/
\'d8<hw>Vol"vox</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>A genus of minute, pale-green, globular, organisms, about one
fiftieth of an inch in diameter, found rolling through water, the motion
being produced by minute colorless cilia. It has been considered as
belonging to the flagellate Infusoria, but is now referred to the
vegetable kingdom, and each globule is considered a colony of many
individuals. The commonest species is <spn>Volvox globator</spn>, often
called <stype>globe animalcule</stype>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volvulus</ent><br/
\'d8<hw>Vol"vu*lus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. L.
<ets>volvere</ets> to turn about, to roll.]</ety> <fld>(Med.)</fld>
<sd>(a)</sd> <def>The spasmodic contraction of the intestines which
causes colic.</def> <sd>(b)</sd> <def>Any twisting or displacement of
the intestines causing obstruction; ileus. See <er>Ileus</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Volyer</ent><br/
<hw>Vol"yer</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A
lurcher.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomer</ent><br/
\'d8<hw>Vo"mer</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a
plowshare.]</ety> <fld>(Anat.)</fld> <sd>(a)</sd> <def>A bone, or one of
a pair of bones, beneath the ethmoid region of the skull, forming a part
a part of the partition between the nostrils in man and other
mammals.</def> <sd>(b)</sd> <def>The pygostyle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomerine</ent><br/
<hw>Vo"mer*ine</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to
the vomer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomica</ent><br/
\'d8<hw>Vom"i*ca</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., fr.
<ets>vomere</ets> to throw up, vomit.]</ety> <fld>(Med.)</fld>
<sd>(a)</sd> <def>An abscess cavity in the lungs.</def> <sd>(b)</sd>
<def>An abscess in any other parenchymatous organ.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomicine</ent><br/
<hw>Vom"i*cine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From nux
<ets>vomica</ets>.]</ety> <fld>(Chem.)</fld> <def>See
<er>Brucine</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomic nut</ent><br/
<hw>Vom"ic nut`</hw> <pr>(?)</pr>. <ety>[Cf. F. <ets>noix
vomique</ets>.]</ety> <def>Same as <er>Nux vomica</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomit</ent><br/
<hw>Vom"it</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Vomited</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Vomiting</conjf>.]</vmorph> <ety>[Cf. L. <ets>vomere</ets>,
<ets>vomitum</ets>, and v. freq. <ets>vomitare</ets>. See
<er>Vomit</er>, <pos>n.</pos>]</ety> <def>To eject the contents of the
stomach by the mouth; to puke; to spew.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomit</ent><br/
<hw>Vom"it</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To throw up; to eject
from the stomach through the mouth; to disgorge; to puke; to spew out;
-- often followed by <xex>up</xex> or <xex>out</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The fish . . . <qex>vomited</qex> out Jonah upon the dry land.</q>
<rj><qau>Jonah ii. 10.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, to eject from any hollow place; to belch
forth; to emit; to throw forth; <as>as, volcanoes <ex>vomit</ex> flame,
stones, etc</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Like the sons of Vulcan, <qex>vomit</qex> smoke.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomit</ent><br/
<hw>Vom"it</hw>, <pos>n.</pos> <ety>[L. <ets>vomitus</ets>, from
<ets>vomere</ets>, <ets>vomitum</ets>, to vomit; akin to Gr. <?/, Skr.
<ets>vam</ets>, Lith. <ets>vemiti</ets>. Cf. <er>Emetic</er>,
<er>Vomito</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Matter that is vomited; esp., matter ejected from
the stomach through the mouth.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Like <qex>vomit</qex> from his yawning entrails poured.</q>
<rj><qau>Sandys.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <def>That which excites vomiting; an
emetic.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He gives your Hollander a <qex>vomit</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Black vomit</b></col>. <fld>(Med.)</fld> <cd>See in the
Vocabulary.</cd> -- <col><b>Vomit nut</b></col>, <cd>nux
vomica.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomiting</ent><br/
<hw>Vom"it*ing</hw>, <pos>n.</pos> <def>The spasmodic ejection of matter
from the stomach through the mouth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomition</ent><br/
<hw>Vo*mi"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vomitio</ets>.]</ety> <def>The act or power of vomiting.</def>
<rj><au>Grew.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomitive</ent><br/
<hw>Vom"i*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>vomitif</ets>.]</ety> <def>Causing the ejection of matter from the
stomach; emetic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomito</ent><br/
\'d8<hw>Vo*mi"to</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp.
<ets>v<oacute/mito</ets>, fr. L. <ets>vomitus</ets>. See <er>Vomit</er>,
<pos>n.</pos>]</ety> <fld>(Med.)</fld> <def>The yellow fever in its
worst form, when it is usually attended with black vomit. See <er>Black
vomit</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomitory</ent><br/
<hw>Vom"i*to*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vomitorious</ets>.]</ety> <def>Causing vomiting; emetic;
vomitive.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomitory</ent><br/
<hw>Vom"i*to*ry</hw>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Vomitories</plw> <pr>(<?/)</pr>.</plu> <sn>1.</sn> <def>An emetic;
a vomit.</def> <rj><au>Harvey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[L. <ets>vomitorium</ets>.]</ety> <fld>(Arch.)</fld>
<def>A principal door of a large ancient building, as of an
amphitheater.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Sixty-four <qex>vomitories</qex> . . . poured forth the immense
multitude.</q> <rj><qau>Gibbon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vomiturition</ent><br/
<hw>Vom`i*tu*ri"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vomiturition</ets>.]</ety> <fld>(Med.)</fld> <sd>(a)</sd> <def>An
ineffectual attempt to vomit.</def> <sd>(b)</sd> <def>The vomiting of
but little matter; also, that vomiting which is effected with little
effort.</def> <rj><au>Dunglison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vondsira</ent><br/
<hw>Vond*si"ra</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>Same as <er>Vansire</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voodoo</ent><br/
<hw>Voo"doo</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>See
<er>Voodooism</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who practices voodooism; a negro
sorcerer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voodoo</ent><br/
<hw>Voo"doo</hw>, <pos>a.</pos> <def>Of or pertaining to voodooism, or a
voodoo; <as>as, <ex>voodoo</ex> incantations</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voodoo economics</ent><br/
<hw>Voo"doo economics</hw>, <pos>n.</pos> <fld>(Politics)</fld> <def>an
economic hypothesis, proposed by President <person>Ronald
Regan</person>, that large cuts in tax rates would so stimulate the
economy that the tax revenue on the increases in business and personal
income would offset the anticipated tax revenue losses, so that such tax
cuts would not increasing the federal budget deficit. Its believers do
not consider the actual massive deficit increases subsequent to the
1982-83 tax cut as being caused by the tax cut itself, but by other
governmental policies. This hypothesis was graphically illustrated by
the <er>Laffer curve</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Voodooism</ent><br/
<hw>Voo"doo*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Probably (through
Creole French <ets>vaudoux</ets> a negro sorcerer) fr. F.
<ets>Vaudois</ets> Waldensian, because the Waldenses were accused of
sorcery.]</ety> <def>A degraded form of superstition and sorcery, said
to include human sacrifices and cannibalism in some of its rites. It is
prevalent among the negroes of Haiti, and to some extent in the United
States, and is regarded as a relic of African barbarism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voortreker</ent><br/
\'d8<hw>Voor"trek`er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[D. (in South
Africa).]</ety> <def>One who treks before or first; a pioneer.</def>
<mark>[South Africa]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Voracious</ent><br/
<hw>Vo*ra"cious</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vorax</ets>, <ets>-acis</ets>, fr. <ets>vorare</ets> to devour;
akin to Gr. <?/ meat, food, <?/ to devour, Skr. <ets>gar</ets>. Cf.
<er>Devour</er>.]</ety> <def>Greedy in eating; very hungry; eager to
devour or swallow; ravenous; gluttonous; edacious; rapacious; <as>as, a
<ex>voracious</ex> man or appetite; a <ex>voracious</ex> gulf or
whirlpool.</as></def> <au>Dampier.</au> --
<wordforms><wf>Vo*ra"cious*ly</wf>, <pos>adv.</pos> --
<wf>Vo*ra"cious*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voracity</ent><br/
<hw>Vo*rac"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>voracitas</ets>: cf. F. <ets>voracit<eacute/</ets>.]</ety> <def>The
quality of being voracious; voraciousness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voraginous</ent><br/
<hw>Vo*rag"i*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>voraginosus</ets>, fr. <ets>vorago</ets> an abyss, fr.
<ets>vorare</ets> to swallow up.]</ety> <def>Pertaining to a gulf; full
of gulfs; hence, devouring.</def> <mark>[R.]</mark>
<rj><au>Mallet.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vortex</ent><br/
<hw>Vor"tex</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> E.
<plw>Vortexes</plw> <pr>(#)</pr>, L. <plw>Vortices</plw>
<pr>(#)</pr>.</plu> <ety>[L. <ets>vortex</ets>, <ets>vertex</ets>,
<ets>-icis</ets>, fr. <ets>vortere</ets>, <ets>vertere</ets>, to turn.
See <er>Vertex</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A mass of fluid, especially of a liquid, having a
whirling or circular motion tending to form a cavity or vacuum in the
center of the circle, and to draw in towards the center bodies subject
to its action; the form assumed by a fluid in such motion; a whirlpool;
an eddy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Cartesian System)</fld> <def>A supposed collection
of particles of very subtile matter, endowed with a rapid rotary motion
around an axis which was also the axis of a sun or a planet. Descartes
attempted to account for the formation of the universe, and the
movements of the bodies composing it, by a theory of vortices.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>Any one of numerous species of
small Turbellaria belonging to <gen>Vortex</gen> and allied genera. See
<xex>Illustration</xex> in Appendix.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vortex atom</b></col> <fld>(Chem.)</fld>, <cd>a
hypothetical ring-shaped mass of elementary matter in continuous
vortical motion. It was conveniently regarded in certain early
mathematical models as the typical form and structure of the chemical
atom, but is no longer considered a useful model, having been superseded
by quantum mechanics.</cd> -- <col><b>Vortex wheel</b></col>, <cd>a kind
of turbine.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Vortex filament</ent><br/
<hw>Vor"tex fil"a*ment</hw>. <def>A vortex tube of infinitesimal cross
section.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vortex fringe</ent><br/
<hw>Vor"tex fringe</hw>. <def>The region immediately surrounding a disk
moving flatwise through air; -- so called because the air has a cyclic
motion as in vortex ring.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vortex line</ent><br/
<hw>Vortex line</hw>. <def>A line, within a rotating fluid, whose
tangent at every point is the instantaneous axis of rotation as that
point of the fluid.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vortex ring</ent><br/
<hw>Vortex ring</hw>. <fld>(Physics)</fld> <def>A ring-shaped mass of
moving fluid which, by virtue of its motion of rotation around an axis
disposed in circular form, attains a more or less distinct separation
from the surrounding medium and has many of the properties of a
solid.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vortex theory</ent><br/
<hw>Vortex theory</hw>. <fld>(Chem. & Physics)</fld> <def>The theory,
advanced by Thomson (Lord Kelvin) on the basis of investigation by
Helmholtz, that the atoms are vortically moving ring-shaped masses (or
masses of other forms having a similar internal motion) of a
homogeneous, incompressible, frictionless fluid. Various properties of
such atoms (<col><b>vortex atoms</b></col>) can be mathematically
deduced. This theory is now (1998) obsolete, and has been superseded by
quantum mechanics, which provides more accurate and detailed
explanations of atomic behavior.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Vortex tube</ent><br/
<hw>Vortex tube</hw>. <fld>(Physics)</fld> <def>An imaginary tube within
a rotating fluid, formed by drawing the vortex lines through all points
of a closed curve.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Vortical</ent><br/
<hw>Vor"ti*cal</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to
a vortex or vortexes; resembling a vortex in form or motion; whirling;
<as>as, a <ex>vortical</ex> motion</as>.</def> --
<wordforms><wf>Vor"ti*cal*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vorticel</ent><br/
<hw>Vor"ti*cel</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vorticelle</ets>. See <er>Vortex</er>.]</ety> <fld>(Zool.)</fld>
<def>A vorticella.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vorticella</ent><br/
<hw>Vor`ti*cel"la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> E.
<plw>Vorticellas</plw> <pr>(<?/)</pr>, L. <plw>Vorticellae</plw>
<pr>(<?/)</pr>.</plu> <ety>[NL., dim. fr. L. <ets>vortex</ets>. See
<er>Vortex</er>.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous
species of ciliated Infusoria belonging to <gen>Vorticella</gen> and
many other genera of the family <fam>Vorticellidae</fam>. They have a
more or less bell-shaped body with a circle of vibrating cilia around
the oral disk. Most of the species have slender, contractile stems,
either simple or branched.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vorticose</ent><br/
<hw>Vor"ti*cose`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vorticosus</ets>.]</ety> <def>Vortical; whirling; <as>as, a
<ex>vorticose</ex> motion</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vortiginous</ent><br/
<hw>Vor*tig"i*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf.
<er>Vertiginous</er>.]</ety> <def>Moving rapidly round a center;
vortical.</def> <mark>[R.]</mark> <rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Votaress</ent><br/
<hw>Vo"ta*ress</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Votary</er>, <pos>n.</pos>]</ety> <def>A woman who is a
votary.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Votarist</ent><br/
<hw>Vo"ta*rist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Votary</er>.]</ety> <def>A votary.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Like a sad <qex>votarist</qex> in palmer's weed.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Votary</ent><br/
<hw>Vo"ta*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From L.
<ets>votus</ets>, p. p. <ets>vovere</ets> to vow, to devote. See
<er>Vote</er>, <er>Vow</er>.]</ety> <def>Consecrated by a vow or
promise; consequent on a vow; devoted; promised.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Votary</qex> resolution is made equipollent to custom.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Votary</ent><br/
<hw>Vo"ta*ry</hw>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Votaries</plw>
<pr>(<?/)</pr>.</plu> <def>One devoted, consecrated, or engaged by a vow
or promise; hence, especially, one devoted, given, or addicted, to some
particular service, worship, study, or state of life.</def> <ldquo/You
are already love's firm <xex>votary</xex>.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>'T was coldness of the <qex>votary</qex>, not the prayer, that was
in fault.</q> <rj><qau>Bp. Fell.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>But thou, my <qex>votary</qex>, weepest thou?</q>
<rj><qau>Emerson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vote</ent><br/
<hw>Vote</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>votum</ets> a
vow, wish, will, fr. <ets>vovere</ets>, <ets>votum</ets>, to vow: cf. F.
<ets>vote</ets>. See <er>Vow</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>An ardent wish or desire; a vow; a prayer.</def>
<mark>[Obs.]</mark> <rj><au>Massinger.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A wish, choice, or opinion, of a person or a body of
persons, expressed in some received and authorized way; the expression
of a wish, desire, will, preference, or choice, in regard to any measure
proposed, in which the person voting has an interest in common with
others, either in electing a person to office, or in passing laws,
rules, regulations, etc.; suffrage.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That by means of which will or preference is
expressed in elections, or in deciding propositions; voice; a ballot; a
ticket; <as>as, a written <ex>vote</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The freeman casting with unpurchased hand<br/
The <qex>vote</qex> that shakes the turrets of the land.</q>
<rj><qau>Holmes.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Expression of judgment or will by a majority; legal
decision by some expression of the minds of a number; <as>as, the
<ex>vote</ex> was unanimous; a <ex>vote</ex> of
confidence</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Votes, collectively; <as>as, the Tory <ex>vote</ex>;
the labor <ex>vote</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Casting vote</b></col>, <col><b>Cumulative
vote</b></col>, etc.</mcol> <cd>See under <er>Casting</er>,
<er>Cumulative</er>, etc.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vote</ent><br/
<hw>Vote</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Voted</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Voting</conjf>.]</vmorph> <ety>[Cf. F. <ets>voter</ets>.]</ety>
<def>To express or signify the mind, will, or preference, either
<xex>viva voce</xex>, or by ballot, or by other authorized means, as in
electing persons to office, in passing laws, regulations, etc., or in
deciding on any proposition in which one has an interest with
others.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>vote</qex> for a duelist is to assist in the prostration
of justice, and, indirectly, to encourage the crime.</q> <rj><qau>L.
Beecher.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To <qex>vote</qex> on large principles, to <qex>vote</qex>
honestly, requires a great amount of information.</q> <rj><qau>F. W.
Robertson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vote</ent><br/
<hw>Vote</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To choose by suffrage;
to elect; <as>as, to <ex>vote</ex> a candidate into
office</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To enact, establish, grant, determine, etc., by a
formal vote; <as>as, the legislature <ex>voted</ex> the
resolution</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Parliament <qex>voted</qex> them one hundred thousand pounds.</q>
<rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To declare by general opinion or common consent, as
if by a vote; <as>as, he was <ex>voted</ex> a bore</as>.</def>
<mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To condemn; to devote; to doom.</def>
<mark>[Obs.]</mark> <rj><au>Glanvill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voter</ent><br/
<hw>Vot"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who votes; one who
has a legal right to vote, or give his suffrage; an elector; a
suffragist; <as>as, an independent <ex>voter</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voting</ent><br/
<hw>Vot"ing</hw>, <def><pos>a. & n.</pos> from <er>Vote</er>,
<pos>v.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Voting paper</b></col>, <cd>a form of ballot containing
the names of more candidates than there are offices to be filled, the
voter making a mark against the preferred names.</cd>
<mark>[Eng.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Votist</ent><br/
<hw>Vot"ist</hw>, <pos>n.</pos> <def>One who makes a vow.</def>
<mark>[Obs.]</mark> <rj><au>Chapman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Votive</ent><br/
<hw>Vo"tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>votivus</ets>, fr. <ets>votum</ets> a vow: cf. F. <ets>votif</ets>.
See <er>Vow</er>.]</ety> <def>Given by vow, or in fulfillment of a vow;
consecrated by a vow; devoted; <as>as, <ex>votive</ex> offerings; a
<ex>votive</ex> tablet.</as></def> <ldquo/<xex>Votive</xex>
incense.<rdquo/ <rj><au>Keble.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>We reached a <qex>votive</qex> stone, that bears the name<br/
Of Aloys Reding.</q> <rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Embellishments of flowers and <qex>votive</qex> garlands.</q>
<rj><qau>Motley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Votive medal</b></col>, <cd>a medal struck in grateful
commemoration of some auspicious event.</cd> -- <col><b>Votive
offering</b></col>, <cd>an offering in fulfillment of a religious vow,
as of one's person or property.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Vo"tive*ly</wf>, <pos>adv.</pos> --
<wf>Vo"tive*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Votress</ent><br/
<hw>Vo"tress</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A votaress.</def>
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vouch</ent><br/
<hw>Vouch</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Vouched</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vouching</conjf>.]</vmorph> <ety>[OE. <ets>vouchen</ets>, OF.
<ets>vochier</ets> to call, fr. L. <ets>vocare</ets> to call, fr.
<ets>vox</ets>, <ets>vocis</ets>, voice. See <er>Voice</er>, and cf.
<er>Avouch</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To call; to summon.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>[They] <qex>vouch</qex> (as I might say) to their aid the
authority of the writers.</q> <rj><qau>Sir T. Elyot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To call upon to witness; to obtest.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vouch</qex> the silent stars and conscious moon.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To warrant; to maintain by affirmations; to attest;
to affirm; to avouch.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They made him ashamed to <qex>vouch</qex> the truth of the
relation, and afterwards to credit it.</q>
<rj><qau>Atterbury.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To back; to support; to confirm; to
establish.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Me damp horror chilled<br/
At such bold words <qex>vouched</qex> with a deed so bold.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Law)</fld> <def>To call into court to warrant and
defend, or to make good a warranty of title.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>vouches</qex> the tenant in tail, who <qex>vouches</qex>
over the common vouchee.</q> <rj><qau>Blackstone.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To obtest; declare; affirm; attest; warrant;
confirm; asseverate; aver; protest; assure.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vouch</ent><br/
<hw>Vouch</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To bear witness; to
give testimony or full attestation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He will not believe her until the elector of Hanover shall
<qex>vouch</qex> for the truth of what she has . . . affirmed.</q>
<rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To assert; to aver; to declare.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vouch</ent><br/
<hw>Vouch</hw>, <pos>n.</pos> <def>Warrant; attestation.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>vouch</qex> of very malice itself.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vouchee</ent><br/
<hw>Vouch*ee"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Law)</fld> <def>The
person who is vouched, or called into court to support or make good his
warranty of title in the process of common recovery.</def>
<rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voucher</ent><br/
<hw>Vouch"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who
vouches, or gives witness or full attestation, to anything.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Will his <qex>vouchers</qex> vouch him no more?</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The great writers of that age stand up together as
<qex>vouchers</qex> for one another's reputation.</q>
<rj><qau>Spectator.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A book, paper, or document which serves to vouch the
truth of accounts, or to confirm and establish facts of any kind; also,
any acquittance or receipt showing the payment of a debt; <as>as, the
merchant's books are his <ex>vouchers</ex> for the correctness of his
accounts; notes, bonds, receipts, and other writings, are used as
<ex>vouchers</ex> in proving facts</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Law)</fld> <sd>(a)</sd> <def>The act of calling in
a person to make good his warranty of title in the old form of action
for the recovery of lands.</def> <sd>(b)</sd> <def>The tenant in a writ
of right; one who calls in another to establish his warranty of title.
In common recoveries, there may be a single <xex>voucher</xex> or double
<xex>vouchers</xex>.</def> <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A document attesting to a credit against certain
defined expenditures; a receipt for prepayment; -- often used in
pre-arranged travel plans, to provide evidence of pre-payment of the
cost of lodging, transportation, or meals.</def><br/
[<source>PJC</source>]</p>

<p><ent>Vouchment</ent><br/
<hw>Vouch"ment</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A solemn
assertion.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vouchor</ent><br/
<hw>Vouch"or</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Law)</fld> <def>Same
as <er>Voucher</er>, 3 <sd>(b)</sd>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vouchsafe</ent><br/
<hw>Vouch*safe"</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vouchsafed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vouchsafing</conjf>.]</vmorph> <ety>[<ets>Vouch</ets> +
<ets>safe</ets>, that is, to vouch or answer for safety.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To condescend to grant; to concede; to
bestow.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If ye <qex>vouchsafe</qex> that it be so.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Shall I <qex>vouchsafe</qex> your worship a word or two?</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It is not said by the apostle that God <qex>vouchsafed</qex> to
the heathens the means of salvation.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To receive or accept in condescension.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vouchsafe</ent><br/
<hw>Vouch*safe"</hw>, <pos>v. i.</pos> <def>To condescend; to deign; to
yield; to descend or stoop.</def> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vouchsafe</qex>, O Lord, to keep us this day without sin.</q>
<rj><qau>Bk. of Com. Prayer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Vouchsafe</qex>, illustrious Ormond, to behold<br/
What power the charms of beauty had of old.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vouchsafement</ent><br/
<hw>Vouch*safe"ment</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of
vouchsafing, or that which is vouchsafed; a gift or grant in
condescension.</def> <rj><au>Glanvill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voussoir</ent><br/
\'d8<hw>Vous`soir"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., akin to
<ets>vo<ucir/te</ets> an arch, a vault.]</ety> <fld>(Arch.)</fld>
<def>One of the wedgelike stones of which an arch is composed.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1620 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vow</ent><br/
<hw>Vow</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>vou</ets>, OF.
<ets>vou</ets>, <ets>veu</ets>, <ets>vo</ets>, <ets>vu</ets>, F.
<ets>v<?/u</ets>, from L. <ets>votum</ets>, from <ets>vovere</ets>, to
vow. Cf. <er>Avow</er>, <er>Devout</er>, <er>Vote</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A solemn promise made to God, or to some deity; an
act by which one consecrates or devotes himself, absolutely or
conditionally, wholly or in part, for a longer or shorter time, to some
act, service, or condition; a devotion of one's possessions; <as>as, a
baptismal <ex>vow</ex>; a <ex>vow</ex> of poverty</as>.</def>
<ldquo/Nothing . . . that may . . . stain my <xex>vow</xex> of
Nazarite.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I pray thee, let me go and pay my <qex>vow</qex>.</q> <rj><qau>2
Sam. xv. 7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I am combined by a sacred <qex>vow</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Specifically, a promise of fidelity; a pledge of
love or affection; <as>as, the marriage <ex>vow</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Knights of love, who never broke their <qex>vow</qex>;<br/
Firm to their plighted faith.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vow</ent><br/
<hw>Vow</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Vowed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Vowing</conjf>.]</vmorph> <ety>[OE. <ets>vouen</ets>, OF.
<ets>vouer</ets>, <ets>voer</ets>, F. <ets>vouer</ets>, LL.
<ets>votare</ets>. See <er>Vow</er>, <pos>n.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To give, consecrate, or dedicate to God, or to some
deity, by a solemn promise; to devote; to promise solemnly.</def>
<ldquo/When thou <xex>vowest</xex> a vow unto God, defer not to pay
it.<rdquo/ <rj><au>Eccl. v. 4.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>[Men] that <qex>vow</qex> a long and weary pilgrimage.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To assert solemnly; to asseverate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vow</ent><br/
<hw>Vow</hw>, <pos>v. i.</pos> <def>To make a vow, or solemn
promise.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Better is it that thou shouldest not <qex>vow</qex>, than that
thou shouldest <qex>vow</qex> and not pay.</q> <rj><qau>Eccl. v.
5.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vowel</ent><br/
<hw>Vow"el</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>voyelle</ets>,
or an OF. form without <it>y</it>, L. <ets>vocalis</ets> (sc.
<ets>littera</ets>), from <ets>vocalis</ets> sounding, from
<ets>vox</ets>, <ets>vocis</ets>, a voice, sound. See
<er>Vocal</er>.]</ety> <fld>(Phon.)</fld> <def>A vocal, or sometimes a
whispered, sound modified by resonance in the oral passage, the peculiar
resonance in each case giving to each several vowel its distinctive
character or quality as a sound of speech; -- distinguished from a
<contr>consonant</contr> in that the latter, whether made with or
without vocality, derives its character in every case from some kind of
obstructive action by the mouth organs. Also, a letter or character
which represents such a sound. See <xex>Guide to Pronunciation</xex>,
<sect/<sect/ 5, 146-149.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the English language, the written vowels are
<it>a</it>, <it>e</it>, <it>i</it>, <it>o</it>, <it>u</it>, and
sometimes <it>w</it> and <it>y.</it> The spoken vowels are much more
numerous.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Close vowel</b></col>. <cd>See under <er>Close</er>,
<pos>a.</pos></cd> -- <col><b>Vowel point</b></col>. <cd>See under
<er>Point</er>, <pos>n.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vowel</ent><br/
<hw>Vow"el</hw>, <pos>a.</pos> <def>Of or pertaining to a vowel;
vocal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voweled</ent><br/
<hw>Vow"eled</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Furnished with
vowels.</def> <altsp>[Written also <asp>vowelled</asp>.]</altsp>
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vowelish</ent><br/
<hw>Vow"el*ish</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of the nature of a
vowel.</def> <mark>[R.]</mark> <ldquo/The power [of <xex>w</xex>] is
always <xex>vowelish</xex>.<rdquo/ <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vowelism</ent><br/
<hw>Vow"el*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The use of
vowels.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vowelize</ent><br/
<hw>Vow"el*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To give the
quality, sound, or office of a vowel to.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vower</ent><br/
<hw>Vow"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who makes a
vow.</def> <rj><au>Bale.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vow-fellow</ent><br/
<hw>Vow"-fel`low</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One bound by the
same vow as another.</def> <mark>[R.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vox</ent><br/
\'d8<hw>Vox</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. See
<er>Voice</er>.]</ety> <def>A voice.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vox humana</b></col> <pr>(<?/)</pr> <ety>[L., human
voice]</ety> <fld>(Mus.)</fld>, <cd>a reed stop in an organ, made to
imitate the human voice.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vox angelica</ent><br/
\'d8<hw>Vox` an*gel"i*ca</hw> <pr>(?)</pr>. <ety>[L. <ets>angelica</ets>
angelic.]</ety> <fld>(Music)</fld> <def>An organ stop of delicate
stringlike quality, having for each finger key a pair of pipes, of which
one is tuned slightly sharp to give a wavy effect to their joint
tone.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Voyage</ent><br/
<hw>Voy"age</hw> <pr>(?; 48)</pr>, <pos>n.</pos> <ety>[OE.
<ets>veage</ets>, <ets>viage</ets>, OF. <ets>veage</ets>,
<ets>viage</ets>, <ets>veiage</ets>, <ets>voiage</ets>, F.
<ets>voyage</ets>, LL. <ets>viaticum</ets>, fr. L. <ets>viaticum</ets>
traveling money, provision for a journey, from <ets>viaticus</ets>
belonging to a road or journey, fr. <ets>via</ets> way, akin to E.
<ets>way</ets>. See <er>Way</er>, <pos>n.</pos>, and cf.
<er>Convey</er>, <er>Deviate</er>, <er>Devious</er>, <er>Envoy</er>,
<er>Trivial</er>, <er>Viaduct</er>, <er>Viaticum</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Formerly, a passage either by sea or land; a
journey, in general; but not chiefly limited to a passing by sea or
water from one place, port, or country, to another; especially, a
passing or journey by water to a distant place or country.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I love a sea <qex>voyage</qex> and a blustering tempest.</q>
<rj><qau>J. Fletcher.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>So steers the prudent crane<br/
Her annual <qex>voyage</qex>, borne on winds.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>All the <qex>voyage</qex> of their life<br/
Is bound in shallows and in miseries.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The act or practice of traveling.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Nations have interknowledge of one another by <qex>voyage</qex>
into foreign parts, or strangers that come to them.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Course; way.</def> <mark>[Obs.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voyage</ent><br/
<hw>Voy"age</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Voyaged</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Voyaging</conjf> <pr>(?)</pr>.]</vmorph> <ety>[Cf. F.
<ets>voyager</ets>.]</ety> <def>To take a voyage; especially, to sail or
pass by water.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A mind forever<br/
<qex>Voyaging</qex> through strange seas of thought alone.</q>
<rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voyage</ent><br/
<hw>Voy"age</hw>, <pos>v. t.</pos> <def>To travel; to pass over; to
traverse.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>With what pain<br/
[I] <qex>voyaged</qex> the unreal, vast, unbounded deep.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voyageable</ent><br/
<hw>Voy"age*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>voyageable</ets>.]</ety> <def>That may be sailed over, as water or
air; navigable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voyager</ent><br/
<hw>Voy"a*ger</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>voyager</ets> traveling.]</ety> <def>One who voyages; one who sails
or passes by sea or water.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voyageur</ent><br/
\'d8<hw>Voy`a`geur"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr.
<ets>voyager</ets> to travel. See <er>Voyage</er>.]</ety> <def>A
traveler; -- applied in Canada to a man employed by the fur companies in
transporting goods by the rivers and across the land, to and from the
remote stations in the Northwest.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Voyol</ent><br/
<hw>Voy"ol</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Naut.)</fld>
<sd>(a)</sd> <def>See <er>Viol</er>, 2.</def> <sd>(b)</sd> <def>The
block through which a messenger passes.</def> <altsp>[Written also
<asp>viol</asp>, and <asp>voyal</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vraisemblance</ent><br/
\'d8<hw>Vrai`sem`blance"</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[F.]</ety> <def>The appearance of truth; verisimilitude.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vugh</ent><br/
<ent>Vugg</ent><br/
<mhw>{ <hw>Vugg</hw>, <hw>Vugh</hw> }</mhw> <pr>(?)</pr>, <pos>n.</pos>
<fld>(Mining)</fld> <def>A cavity in a lode; -- called also
<altname>vogle</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcan</ent><br/
<hw>Vul"can</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>Vulcanus</ets>, <ets>Volcanus</ets>: cf. Skr. <ets>ulk<amac/</ets>
a firebrand, meteor. Cf. <er>Volcano</er>.]</ety> <fld>(Rom.
Myth.)</fld> <def>The god of fire, who presided over the working of
metals; -- answering to the Greek <xex>Hephaestus</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcanian</ent><br/
<hw>Vul*ca"ni*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>Vulcanius</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Of or pertaining to Vulcan; made by Vulcan; hence,
of or pertaining to works in iron or other metals.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ingenious allusions to the <qex>Vulcanian</qex> panoply which
Achilles lent to his feebler friend.</q>
<rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Geol.)</fld> <def>Volcanic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcanic</ent><br/
<hw>Vul*can"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Of or
pertaining to Vulcan; made by Vulcan; Vulcanian.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to volcanoes; specifically,
relating to the geological theory of the Vulcanists, or
Plutonists.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcanicity</ent><br/
<hw>Vul`can*ic"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos>
<def>Volcanicity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcanism</ent><br/
<hw>Vul"can*ism</hw> <pr>(?)</pr>, <pos>n.</pos>
<def>Volcanism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcanist</ent><br/
<hw>Vul"can*ist</hw>, <pos>n.</pos> <def>A volcanist.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcanite</ent><br/
<hw>Vul"can*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Hard rubber
produced by vulcanizing with a large proportion of sulphur.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcanization</ent><br/
<hw>Vul`can*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Vulcan</er>.]</ety> <def>The act or process of imparting to
caoutchouc, gutta-percha, or the like, greater elasticity, durability,
or hardness by heating with sulphur under pressure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcanize</ent><br/
<hw>Vul"can*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Vulcanized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Vulcanizing</conjf> <pr>(?)</pr>.]</vmorph> <def>To
change the properties of, as caoutchouc, or India rubber, by the process
of vulcanization.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vulcanized fiber</b></col>, <cd>paper, paper pulp, or
other fiber, chemically treated, as with metallic chlorides, so as to
form a substance resembling ebonite in texture, hardness, etc.</cd>
<au>Knight.</au> -- <col><b>Vulcanized rubber</b></col>, <cd>India
rubber, vulcanized.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcanizer</ent><br/
<hw>Vul"can*i`zer</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that
which, vulcanizes; esp., an apparatus for vulcanizing
caoutchouc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcano</ent><br/
<hw>Vul*ca"no</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A volcano.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcanology</ent><br/
<hw>Vul`can*ol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Vulcan</er>, and <er>-logy</er>.]</ety> <def>The science which
treats of phenomena due to plutonic action, as in volcanoes, hot
springs, etc.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulcan powder</ent><br/
<hw>Vul"can pow"der</hw>. <def>A dynamite composed of nitroglycerin (30
parts), sodium nitrate (52.5), charcoal (10.5), and sulphur (7), used in
mining and blasting.</def></p>

<p><ent>Vulgar</ent><br/
<hw>Vul"gar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vulgaris</ets>, from <ets>vulgus</ets> the multitude, the common
people; of uncertain origin: cf. F. <ets>vulgaire</ets>. Cf.
<er>Divulge</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Of or pertaining to the mass, or multitude, of
people; common; general; ordinary; public; hence, in general use;
vernacular.</def> <ldquo/As common as any the most vulgar thing to
sense. <rdquo/ <rj><au> Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Things <qex>vulgar</qex>, and well-weighed, scarce worth the
praise.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It might be more useful to the English reader . . . to write in
our <qex>vulgar</qex> language.</q> <rj><qau>Bp. Fell.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The mechanical process of multiplying books had brought the New
Testament in the <qex>vulgar</qex> tongue within the reach of every
class.</q> <rj><qau>Bancroft.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Belonging or relating to the common people, as
distinguished from the cultivated or educated; pertaining to common
life; plebeian; not select or distinguished; hence, sometimes, of little
or no value.</def> <ldquo/Like the <xex>vulgar</xex> sort of market
men.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Men who have passed all their time in low and <qex>vulgar</qex>
life.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In reading an account of a battle, we follow the hero with our
whole attention, but seldom reflect on the<br/
<qex>vulgar</qex> heaps of slaughter.</q>
<rj><qau>Rambler.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Hence, lacking cultivation or refinement; rustic;
boorish; also, offensive to good taste or refined feelings; low; coarse;
mean; base; <as>as, <ex>vulgar</ex> men, minds, language, or
manners</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Be thou familiar, but by no means <qex>vulgar</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vulgar fraction</b></col>. <fld>(Arith.)</fld> <cd>See
under <er>Fraction</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulgar</ent><br/
<hw>Vul"gar</hw>, <pos>n.</pos> <ety>[Cf. F.
<ets>vulgaire</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>One of the common people; a vulgar person.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>These vile <qex>vulgars</qex> are extremely proud.</q>
<rj><qau>Chapman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The vernacular, or common language.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulgarian</ent><br/
<hw>Vul*ga"ri*an</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A vulgar person;
one who has vulgar ideas. Used also adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulgarism</ent><br/
<hw>Vul"gar*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vulgarisme</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Grossness; rudeness; vulgarity.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A vulgar phrase or expression.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A fastidious taste will find offense in the occasional
<qex>vulgarisms</qex>, or what we now call <ldquo/slang,<rdquo/ which
not a few of our writers seem to have affected.</q>
<rj><qau>Coleridge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulgarity</ent><br/
<hw>Vul*gar"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>vulgarit<eacute/</ets>, L. <ets>vulgaritas</ets> the
multitude.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The quality or state of being vulgar; mean condition
of life; the state of the lower classes of society.</def> <rj><au>Sir T.
Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Grossness or clownishness of manners of language;
absence of refinement; coarseness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The reprobate <qex>vulgarity</qex> of the frequenters of
Bartholomew Fair.</q> <rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulgarization</ent><br/
<hw>Vul`gar*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act or
process of making vulgar, or common.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulgarize</ent><br/
<hw>Vul"gar*ize</hw> <pr>(?)</pr>, <pos>v. t. & i.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Vulgarized</conjf> <pr>(?)</pr>;
<pos>p. pr. & vb. n.</pos> <conjf>Vulgarizing</conjf>
<pr>(?)</pr>.]</vmorph> <ety>[Cf. F. <ets>vulgariser</ets>, LL.
<ets>vulgarizare</ets>.]</ety> <def>To make vulgar, or common.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Exhortation <qex>vulgarized</qex> by low wit.</q> <rj><qau>V.
Knox.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulgarly</ent><br/
<hw>Vul"gar*ly</hw>, <pos>adv.</pos> <def>In a vulgar manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulgarness</ent><br/
<hw>Vul"gar*ness</hw>, <pos>n.</pos> <def>The quality of being
vulgar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulgate</ent><br/
<hw>Vul"gate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.
<ets>vulgata</ets>, from L. <ets>vulgatus</ets> usual, common, p. p. of
<ets>vulgare</ets> to make general, or common, fr. <ets>vulgus</ets> the
multitude: cf. F. <ets>vulgate</ets>. See <er>Vulgar</er>,
<pos>a.</pos>]</ety> <def>An ancient Latin version of the Scripture, and
the only version which the Roman Church admits to be authentic; -- so
called from its common use in the Latin Church.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The Vulgate was made by Jerome at the close of the 4th
century. The Old Testament he translated mostly from the Hebrew and
Chaldaic, and the New Testament he revised from an older Latin version.
The Douay version, so called, is an English translation from the
Vulgate. See <er>Douay Bible</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulgate</ent><br/
<hw>Vul"gate</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to
the Vulgate, or the old Latin version of the Scriptures.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulnerability</ent><br/
<hw>Vul`ner*a*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality
or state of being vulnerable; vulnerableness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulnerable</ent><br/
<hw>Vul"ner*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vulnerabilis</ets> wounding, injurious, from <ets>vulnerare</ets>
to wound, <ets>vulnus</ets> a wound; akin to Skr. <ets>vra<?/a</ets>:
cf. F. <ets>vuln<eacute/rable</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Capable of being wounded; susceptible of wounds or
external injuries; <as>as, a <ex>vulnerable</ex> body</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Achilles was <qex>vulnerable</qex> in his heel; and there will be
wanting a Paris to infix the dart.</q> <rj><qau>Dr. T.
Dwight.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Liable to injury; subject to be affected
injuriously; assailable; <as>as, a <ex>vulnerable</ex>
reputation</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His skill in finding out the <qex>vulnerable</qex> parts of strong
minds was consummate.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulnerableness</ent><br/
<hw>Vul"ner*a*ble*ness</hw>, <pos>n.</pos> <def>The quality or state of
being vulnerable; vulnerability.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulnerary</ent><br/
<hw>Vul"ner*a*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vulnearius</ets>: cf. F. <ets>vuln<eacute/raire</ets>.]</ety>
<def>Useful in healing wounds; adapted to the cure of external injuries;
<as>as, <ex>vulnerary</ex> plants or potions</as>.</def> <ldquo/Such
<xex>vulnerary</xex> remedies.<rdquo/ <au>Sir W. Scott.</au> --
<def2><pos>n.</pos> <ety>[Cf. F. <ets>vuln<eacute/raire</ets>.]</ety>
<fld>(Med.)</fld> <def>A vulnerary remedy.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulnerate</ent><br/
<hw>Vul"ner*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L.
<ets>vulneratus</ets>, p. p. of <ets>vulnerare</ets> to wound.]</ety>
<def>To wound; to hurt.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulneration</ent><br/
<hw>Vul`ner*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vulneratio</ets>.]</ety> <def>The act of wounding, or the state of
being wounded.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulnerose</ent><br/
<hw>Vul"ner*ose`</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Full of wounds;
wounded.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulnifical</ent><br/
<ent>Vulnific</ent><br/
<mhw>{ <hw>Vul*nif"ic</hw> <pr>(?)</pr>, <hw>Vul*nif"ic*al</hw>
<pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>vulnificus</ets>;
<ets>vulnus</ets> a wound + <ets>facere</ets> to make.]</ety>
<def>Causing wounds; inflicting wounds; wounding.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulnose</ent><br/
<hw>Vul*nose"</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having wounds;
vulnerose.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulpes</ent><br/
\'d8<hw>Vul"pes</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a fox.]</ety>
<fld>(Zool.)</fld> <def>A genus of Carnivora including the
foxes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulpic</ent><br/
<hw>Vul"pic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld>
<def>Pertaining to, derived from, or designating, an acid obtained from
a lichen (<spn>Cetraria vulpina</spn>) as a yellow or red crystalline
substance which on decomposition yields pulvinic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulpicide</ent><br/
<hw>Vul"pi*cide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.
<ets>vulpes</ets> a fox + <ets>caedere</ets> to kill.]</ety> <def>One
who kills a fox, except in hunting; also, the act of so killing a
fox.</def> <altsp>[Written also <asp>vulpecide</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulpine</ent><br/
<hw>Vul"pine</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>vulpinus</ets>, from <ets>vulpes</ets> a fox.]</ety> <def>Of or
pertaining to the fox; resembling the fox; foxy; cunning; crafty;
artful.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Vulpine phalangist</b></col> <fld>(Zool.)</fld>, <cd>an
Australian carnivorous marsupial (<spn>Phalangista vulpina</spn> syn.
<spn>Trichosurus vulpina</spn>); -- called also <altname>vulpine
phalanger</altname>, and <altname>vulpine
opossum</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulpinic</ent><br/
<hw>Vul*pin"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld>
<def>Same as <er>Vulpic</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulpinism</ent><br/
<hw>Vul"pin*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality of
being cunning like the fox; craft; artfulness.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He was without guile, and had no <qex>vulpinism</qex> at all.</q>
<rj><qau>Carlyle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulpinite</ent><br/
<hw>Vul"pi*nite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So called after
<ets>Vulpino</ets>, in Italy.]</ety> <fld>(Min.)</fld> <def>A scaly
granular variety of anhydrite of a grayish white color, used for
ornamental purposes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vultern</ent><br/
<hw>Vul"tern</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>The brush turkey (<spn>Talegallus Lathami</spn>) of Australia. See
<er>Brush turkey</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulture</ent><br/
<hw>Vul"ture</hw> <pr>(?; 135)</pr>, <pos>n.</pos> <ety>[OE.
<ets>vultur</ets>, L. <ets>vultur</ets>: cf. OF. <ets>voltour</ets>, F.
<ets>vautour</ets>.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous
species of rapacious birds belonging to <gen>Vultur</gen>,
<gen>Cathartes</gen>, <gen>Catharista</gen>, and various other genera of
the family <fam>Vulturidae</fam>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In most of the species the head and neck are naked or
nearly so. They feed chiefly on carrion. The condor, king vulture,
turkey buzzard, and black vulture (<spn>Catharista atrata</spn>) are
well known American species. The griffin, lammergeir, and Pharaoh's
chicken, or Egyptian vulture, are common Old World vultures.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulturine</ent><br/
<hw>Vul"tur*ine</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[L.
<ets>vulturinus</ets>.]</ety> <def>Of or pertaining to a vulture;
resembling a vulture in qualities or looks; <as>as, the
<ex>vulturine</ex> sea eagle (<spn>Gypohierax Angolensis</spn>);
<ex>vulturine</ex> rapacity.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>vulturine</qex> nose, which smells nothing but
corruption, is no credit to its possessor.</q> <rj><qau>C.
Kingsley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulturish</ent><br/
<hw>Vul"tur*ish</hw>, <pos>a.</pos> <def>Vulturous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulturism</ent><br/
<hw>Vul"tur*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or
state of being like a vulture; rapaciousness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulturous</ent><br/
<hw>Vul"tur*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Like a vulture;
rapacious.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulva</ent><br/
<hw>Vul"va</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>vulva</ets>,
<ets>volva</ets>, from <ets>volvere</ets> to roll.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Anat.)</fld> <def>The external parts of the female
genital organs; sometimes, the opening between the projecting parts of
the external organs.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The orifice of the oviduct of an
insect or other invertebrate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulviform</ent><br/
<hw>Vul"vi*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.
<ets>vulva</ets>, <ets>volva</ets>, a wrapper + <ets>-form</ets>.]</ety>
<fld>(Bot.)</fld> <def>Like a cleft with projecting edges.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulvitis</ent><br/
\'d8<hw>Vul*vi"tis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See
<er>Vulva</er>, and <er>-itis</er>.]</ety> <fld>(Med.)</fld>
<def>Inflammation of the vulva.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulvo-uterine</ent><br/
<hw>Vul`vo-u"ter*ine</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld>
<def>Pertaining both to the vulva and the uterus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vulvovaginal</ent><br/
<hw>Vul`vo*vag"i*nal</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld>
<def>Pertaining both to the vulva and the vagina.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vyce</ent><br/
<hw>Vyce</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Vise</er>.]</ety> <fld>(Coopering)</fld> <def>A kind of clamp with
gimlet points for holding a barrel head while the staves are being
closed around it.</def> <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Vying</ent><br/
<hw>Vy"ing</hw> <pr>(?)</pr>, <def><pos>a. & n.</pos> from
<er>Vie</er>.</def> -- <wordforms><wf>Vy"ing*ly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1621 --></p>


<-- Local variables: -->
<-- mode: sgml -->
<-- fill-column: 72 -->
<-- End: -->
