/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.util;

import java.awt.geom.Rectangle2D;

public class PageSize {
    private static final double MM_PER_INCH = 2.54;
    public static final PageSize A3 = new PageSize(297.0, 420.0);
    public static final PageSize A4 = new PageSize(210.0, 297.0);
    public static final PageSize A5 = new PageSize(148.0, 210.0);
    public static final PageSize LETTER = new PageSize(21.59, 27.94);
    public static final PageSize LEGAL = new PageSize(21.59, 35.56);
    public static final PageSize TABLOID = new PageSize(27.94, 43.18);
    public static final PageSize LEDGER = TABLOID.getLandscape();
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public PageSize(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public PageSize(double width, double height) {
        this(0.0, 0.0, width, height);
    }

    public PageSize(Rectangle2D size) {
        this(size.getX(), size.getY(), size.getWidth(), size.getHeight());
    }

    public PageSize getPortrait() {
        if (this.width <= this.height) {
            return this;
        }
        return new PageSize(this.x, this.y, this.height, this.width);
    }

    public PageSize getLandscape() {
        if (this.width >= this.height) {
            return this;
        }
        return new PageSize(this.x, this.y, this.height, this.width);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }
}

